<?php
require('../libs/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/Reports.php');

$reportModelo = new Reports();

if(isset($_GET['idreport']) && is_numeric($_GET['idreport']))
{
	$idReport = $_GET['idreport'];
	
	if($reportModelo->cantidad($idReport)>0)
	{
		define("IDREPORT", $idReport);
		$report = $reportModelo->getById(IDREPORT);
	}
	else
		die("El Report no existe");
}
else
	die("No fue posible generar el reporte");



class PDF extends FPDF
{
	//Cabecera de p�gina
	function Header()
	{
		//Logo
		$this->Image('../imagenes/logo.png',10,10,33);
		//Arial bold 15
		$this->SetFont('Arial','B',16);
		//Movernos a la derecha
		$this->Cell(64);
		//T�tulo
		$this->Cell(80,10,'Report de Servicios');
		$this->SetFont('Arial','B',14);
		$this->Cell(0,10,'Nº '.IDREPORT,1,0,'C');
		//Salto de línea
		$this->Ln(16);
	}
}


$pdf=new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->SetFillColor(220,220,220);
$pdf->Cell(0,5,'Empresa',0,1,'L',true);
$pdf->Cell(50,5,'Razón Social:');
$pdf->Cell(50,5,'ABOGADO GUILLERMO VALDERRAMA');
$pdf->Ln();
$pdf->Cell(50,5,'Rut:');
$pdf->Cell(50,5,'71507637');
$pdf->Ln();
$pdf->Cell(50,5,'Nombre Empresa:');
$pdf->Cell(50,5,'ABOGADO GUILLERMO VALDERRAMA');
$pdf->Ln();
$pdf->Cell(50,5,'Dirección:');
$pdf->Cell(50,5,'SUCRE 220. OF. 608');
$pdf->Ln();
$pdf->Cell(50,5,'Telefono:');
$pdf->Cell(50,5,'268991');
$pdf->Ln();
$pdf->Cell(50,5,'Ciudad:');
$pdf->Cell(50,5,'Antofagasta');
$pdf->Ln();
$pdf->Cell(50,5,'Giro:');
$pdf->Cell(50,5,'Construcción');
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,'Máquina',0,1,'L',true);
$pdf->Cell(50,5,'Marca:');
$pdf->Cell(50,5,'OLIVETTI');
$pdf->Ln();
$pdf->Cell(50,5,'Modelo:');
$pdf->Cell(50,5,'8520');
$pdf->Ln();
$pdf->Cell(50,5,'Serie Interna:');
$pdf->Cell(50,5,'OL1119');
$pdf->Ln();
$pdf->Cell(50,5,'Serie:');
$pdf->Cell(50,5,'506090');
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,'Movimiento',0,1,'L',true);
$pdf->Cell(50,5,'Mantención Correctiva');
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,'Report',0,1,'L',true);
$pdf->Cell(50,5,'Técnico:');
$pdf->Cell(50,5,'Juan Perez');
$pdf->Ln();
$pdf->Cell(50,5,'Contador:');
$pdf->Cell(50,5,$report['contador']);
$pdf->Ln();
$pdf->Cell(50,5,'Fecha:');
$pdf->Cell(50,5,$report['fecha']);
$pdf->Ln();
$pdf->Cell(50,5,'Hora Despacho:');
$pdf->Cell(50,5,$report['horadespacho']);
$pdf->Ln();
$pdf->Cell(50,5,'Hora Llegada:');
$pdf->Cell(50,5,$report['horallegada']);
$pdf->Ln();
$pdf->Cell(50,5,'Hora Salida:');
$pdf->Cell(50,5,$report['horasalida']);
$pdf->Ln();
$pdf->Cell(50,5,'Detalle:');
$pdf->Cell(50,5,$report['detalle']);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,'Insumos',0,1,'L',true);
$pdf->Output();

?>