<?php
require("../config/global.php");
require('../libs/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/OrdenCompra.php');
require('../modelos/Proveedor.php');

$clientes = new Clientes($_CONF);
$orden = new OrdenCompra($_CONF);
$proveedor = new Proveedor($_CONF);

$idoc 	= $_GET['idOC'];

//Datos Orden de Compra
$oc 	= $orden->obtenerdatosOC($idoc);
$listainventario = $orden->obtenerItemsInventarioOC($idoc);
$listamaqserv = $orden->obtenerItemsMaqServOC($idoc);
//Datos proveedor
$prov	= $proveedor->obtenerDatos($oc["rutp"]);
$direccion = $orden->obtenerDireccion($oc["idDireccion"]);

class PDF extends FPDF
{
    //Cabecera de página
    function Header()
    {
        //Logo
        $this->Image('../imagenes/headerdoc.jpg',55,10,100,20);
        //Salto de l�nea
        $this->Ln(24);
    }

    function BasicTable($header,$data)
    {
        //Cabecera
        $this->SetFillColor(220,220,220);

        $this->Cell(8,7,$header[0],1,0,'C',true);
        $this->Cell(115,7,$header[1],1,0,'C',true);
        $this->Cell(20,7,$header[2],1,0,'C',true);
        $this->Cell(15,7,$header[3],1,0,'C',true);
        $this->Cell(15,7,$header[4],1,0,'C',true);
        $this->Cell(15,7,$header[5],1,0,'C',true);

        $this->Ln();
        //Datos
        foreach($data as $row) //Por cada Array
        {
            $pos = 1;
            foreach($row as $col) //Por cada celda del Array
            {
                if($pos == 1) //descripcion
                {
                    $this->Cell(8,6,$col,1,0,'C');
                }
                else if($pos == 2)
                {
                    $this->Cell(115,6,utf8_decode($col),1,0,'C');
                }
                else if($pos == 3)
                {
                    $this->Cell(20,6,$col,1,0,'C');
                }
                else
                {
                    $this->Cell(15,6,$col,1,0,'C');
                }
                $pos++;
            }
            $this->Ln();
        }
    }
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->SetFillColor(220,220,220);
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Cell(0,5,'ORDEN DE COMPRA  N '.$oc["IDoc"],0,3,'C',true);
$pdf->Ln();
$pdf->Cell(0,5,'Proveedor',0,1,'L',true);
$pdf->Cell(50,5,'Razon Social:');
$pdf->Cell(50,5,$prov["razonsocial"]);
$pdf->Ln();
$pdf->Cell(50,5,'Rut:');
$pdf->Cell(50,5,$prov["rut"]);
$pdf->Ln();
$pdf->Cell(50,5,'Nombre:');
$pdf->Cell(50,5,$prov["nombre"]);
$pdf->Ln();
$pdf->Cell(50,5,'Direccion:');
$pdf->Cell(50,5,$prov["direccion"]);
$pdf->Ln();
$pdf->Cell(50,5,'Telefono:');
$pdf->Cell(50,5,$prov["telefono"]);
$pdf->Ln();
$pdf->Cell(50,5,'Ciudad:');
$pdf->Cell(50,5,$prov["ciudad"]);
$pdf->Ln();
$pdf->Cell(50,5,'Giro:');
$pdf->Cell(50,5,$prov["giro"]);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(50,5,'Fecha:');
$pdf->Cell(50,5,gmdate("d-m-Y",strtotime($oc["fecha"])));
$pdf->Ln();
$pdf->Cell(50,5,'Factura:');
$pdf->Cell(50,5,$oc["numfactura"]);
$pdf->Ln();
$pdf->Cell(50,5,'Guia Despacho:');
$pdf->Cell(50,5,$oc["numguia"]);

$pdf->Ln();
$pdf->Cell(50,5,'Condicion de Pago:');
$pdf->Cell(50,5,$oc["condicionpago"]);

$pdf->Ln();
$pdf->Ln();

$header=array('Cant.','Descripcion', 'Num Parte', 'Serie Int.' ,'P. Unitario','Total');
$totalneto = 0;
$data = array();

if(is_array($listainventario))
{
    foreach($listainventario as $c)
    {
        $descrip = $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["modelo"]." ".$c["descripcion"];
        $data[]=array($c["cantidad"], $descrip, $c["numparte"], $c["codinterno"], number_format($c["precio"],0, ',', '.'), number_format($c["precio"]*$c["cantidad"],0, ',', '.'));
        $totalneto = $totalneto + $c["precio"]*$c["cantidad"];

    }//fin lista
}

if(is_array($listamaqserv))
{
    foreach($listamaqserv as $ms)
    {
        $descrip = isset($ms["descripcion"]) ? $ms["descripcion"] : null;
        $data[]=array(
            $ms["cantidad"],
            $descrip,
            isset($ms["IDproducto"]) ? $ms["IDproducto"] : null,
            isset($ms["codinterno"]) ? $ms["codinterno"] : null,
            number_format(isset($ms["precio"]) ? $ms["precio"] : 0,
                0,
                ',',
                '.'),
            number_format(isset($ms["precio"]) ? $ms["precio"]*$ms["cantidad"] : 0,
                0, ',',
                '.'));
        $totalneto = $totalneto + (isset($ms["precio"]) ? $ms["precio"] : 0) * (isset($ms["cantidad"]) ? $ms["cantidad"] : 0);

    }//fin lista
}
$pdf->SetFont('Arial','',8);
$pdf->BasicTable($header,$data);
$pdf->SetFont('Arial','B',8);
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')

$pdf->Cell(173,6,'Total Neto',1,0,'R');
$pdf->Cell(15,6,number_format($totalneto,0, ',', '.'),1,0,'C');
$pdf->Ln();
$pdf->Cell(173,6,'I.V.A.',1,0,'R');
$pdf->Cell(15,6,number_format($totalneto*0.19,0, ',', '.'),1,0,'C');
$pdf->Ln();
$pdf->Cell(173,6,'TOTAL',1,0,'R');
$pdf->Cell(15,6,number_format($totalneto+($totalneto*0.19),0, ',', '.'),1,0,'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->SetFont('Arial','B',10);
$pdf->Ln();
$pdf->Cell(50,5,$oc["despacho"]);

$pdf->SetFont('Arial','',10);
$pdf->Ln();
$pdf->Cell(50,5,'Inversiones y Servicios Digitales Spa.');

$pdf->Ln();
$pdf->Cell(50,5,'76.121.841-7');

$pdf->Ln();
$pdf->Cell(50,5,'55-2774040');

$pdf->Ln();
$pdf->Cell(50,5,isset($direccion["descDireccion"]) ? $direccion["descDireccion"] : "Galleguillos Lorca 1474");   //DIRECCION DESPACHO

$pdf->Ln();
$pdf->Cell(50,5,isset($direccion["ciudadDireccion"]) ? $direccion["ciudadDireccion"] : "Antofagasta");   //CIUDAD DESPACHO

$pdf->Output("OrdenCompra.pdf", "I");