<?php

require('../libs/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/Maquinas.php');
require('../modelos/Contadores.php');

$clientes = new Clientes();
$maquinas = new Maquinas();
$contadores = new Contadores();

$rut 			     = $_GET['rut'];
$serieInterna 	     = $_GET['serieinterna'];
$tipoServicioMaquina = $_GET['tipoServicioMaquina'];
$correlativo         = $_GET['correlativo'];

$ultimaFechaFacturacion = $contadores->ultimaFechaFacturacion($rut, $serieInterna, $tipoServicioMaquina);

if(isset($_GET['desde']	))
{
	$desde	= $_GET['desde'];
}
else
{
	$desde	= date('Y-m-d', strtotime($ultimaFechaFacturacion . '-1 year'));
}

if(isset($_GET['hasta']	))
{
	$hasta	= $_GET['hasta'];
}
else
{
	$hasta	= $ultimaFechaFacturacion;
}

$cliente 	= $clientes->obtenerDatos($rut);
$maquina 	= $maquinas->obtenerDatos($serieInterna);	

$maquinacliente = $maquinas->obtenerDatosMaquinaCliente($rut, $serieInterna);	


$lista 		= $contadores->listarByFechas($rut , $serieInterna, $correlativo, $desde, $hasta, $tipoServicioMaquina);
$glosaTipoServicioMaquina = $contadores->glosaTipoServicioMaquina($tipoServicioMaquina);

function mes($mes)
{
	if($mes>12)
		$mes = $mes % 12;
		
	switch($mes)
	{
		case 1:
			$mesStr = "Enero";
		break;
		case 2:
			$mesStr = "Febrero";
		break;
		case 3:
			$mesStr = "Marzo";
		break;
		case 4:
			$mesStr = "Abril";
		break;
		case 5:
			$mesStr = "Mayo";
		break;
		case 6:
			$mesStr = "Junio";
		break;
		case 7:
			$mesStr = "Julio";
		break;
		case 8:
			$mesStr = "Agosto";
		break;
		case 9:
			$mesStr = "Septiembre";
		break;
		case 10:
			$mesStr = "Octubre";
		break;
		case 11:
			$mesStr = "Noviembre";
		break;
		case 12:
			$mesStr = "Diciembre";
		break;
	}
	return 	$mesStr;
}

class PDF extends FPDF
{
	//Cabecera de p�gina
	function Header()
	{
		//Logo
		$this->Image('../imagenes/headerdoc.jpg',55,10,100,20);
		//Salto de l�nea
		$this->Ln(24);
	}


	//Tabla simple
	function BasicTable($header,$data)
	{
		//Cabecera
		$this->SetFillColor(220,220,220);
		foreach($header as $col)
			//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
			$this->Cell(38,7,$col,1,0,'C',true);
		$this->Ln();
		//Datos
		foreach($data as $row)
		{
			foreach($row as $col)
				$this->Cell(38,6,$col,1,0,'C');
			$this->Ln();
		}
	}
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->SetFillColor(220,220,220);
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Cell(0,5,'Empresa',0,1,'L',true);
$pdf->Cell(50,5,'Raz�n Social:');
$pdf->Cell(50,5,$cliente["razonsocial"]);
$pdf->Ln();
$pdf->Cell(50,5,'Rut:');
$pdf->Cell(50,5,$cliente["rut"]);
$pdf->Ln();
$pdf->Cell(50,5,'Nombre Empresa:');
$pdf->Cell(50,5,$cliente["nombre"]);
$pdf->Ln();
$pdf->Cell(50,5,'Direcci�n:');
$pdf->Cell(50,5,$cliente["direccion"]);
$pdf->Ln();
$pdf->Cell(50,5,'Telefono:');
$pdf->Cell(50,5,$cliente["telefono"]);
$pdf->Ln();
$pdf->Cell(50,5,'Ciudad:');
$pdf->Cell(50,5,$cliente["ciudad"]);
$pdf->Ln();
$pdf->Cell(50,5,'Giro:');
$pdf->Cell(50,5,$cliente["giro"]);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,'M�quina',0,1,'L',true);
$pdf->Cell(50,5,'Marca:');
$pdf->Cell(50,5,$maquina["marca"]);
$pdf->Ln();
$pdf->Cell(50,5,'Modelo:');
$pdf->Cell(50,5,$maquina["modelo"]);
$pdf->Ln();
$pdf->Cell(50,5,'Serie Interna:');
$pdf->Cell(50,5,$maquina["serieinterna"]);
$pdf->Ln();
$pdf->Cell(50,5,'Serie:');
$pdf->Cell(50,5,$maquina["seriemaquina"]);
$pdf->Ln();
$pdf->Cell(50,5,'Ubicacion:');
//$pdf->Cell(50,5,'Sin Informacion');
$pdf->Cell(50,5,$maquinacliente["ubicacion"]);


$pdf->Ln();
$pdf->Cell(50,5,'Tipo de Servicio:');
$pdf->Cell(50,5,$glosaTipoServicioMaquina["nombreTipoServicio"]);
$pdf->Ln();
$pdf->Ln();

$tmpMes		= 0;
$tmpAnio 	= 0;
$mesAnt 	= 0;
$anioAnt 	= 0;

$header=array('Meses','Final','Copias','Fecha', 'Firma/Report');
if(is_array($lista))
{
	foreach($lista as $c)
	{
		if($mesAnt==0)
		{
			$mesAnt  = $c["mes"];
			$anioAnt = $c["anio"];
		}
		//Mismo ano
		if($mesAnt + 1 != $c["mes"] && $c["anio"] == $anioAnt)
		{
			for($i=1; $i<($c["mes"]-$mesAnt); $i++)
			{
				$data[]=array(mes($mesAnt+$i) . " - " . $c["anio"],'---','---','---', '---');
			}
		}
		
		//Distinto ano
		if($mesAnt!=12 && $c["anio"] != $anioAnt)
		{
			$diferenciaAnios = $c["anio"] - $anioAnt;
			
			// Llego Hasta que termine el ano Diciembre
			for($j=1; $j<=(12-$mesAnt); $j++)
			{
				$data[]=array(mes($mesAnt+$j) . " - " . $anioAnt,'---','---','---', '---');
			}
			
			//Comienzo de Enero hasta terminar en el mes actual
			for($j=1; $j<$c["mes"]; $j++)
			{
				$data[]=array(mes($j) . " - " . $c["anio"],'---','---','---', '---');
			}
			
		}
		
		$data[]=array(mes($c["mes"])." - ".$c["anio"],$c["contador"],$c["copiasfacturadas"],$c["fecha"].($c["instalacion"]==1?" - Inst.":null), !empty($c["firma"])?$c["firma"]:"Report ".$c["idreport"]);
		
		$tmpMes 	= $c["mes"];
		$tmpAnio 	= $c["anio"];	
		$mesAnt 	= $c["mes"];	
		$anioAnt 	= $c["anio"];	
	}//fin lista
	
	if($tmpMes==12)
		$tmpAnio = $c["anio"]+1;
}
else
{
	$data[]=array('','','','', '');
	$data[]=array('','','','', '');
	$data[]=array('','','','', '');
}
$data[]=array(mes($tmpMes+1) . " - " . $tmpAnio,'','','', '');//Ultimo mes que se agrega automatico

$pdf->BasicTable($header,$data);
$pdf->Ln();
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$datosCopiado = $contadores->obtenerMinCostCopia($rut, $tipoServicioMaquina, $maquina["serieinterna"]);
$pdf->Cell(40,5,'Costo Copia:');
$pdf->Cell(20,5,'$'.' '.$datosCopiado["costocopia"]);
$pdf->Cell(40,5,'Cargo Fijo:');
$pdf->Cell(20,5,'$'.' '.$datosCopiado["costofijo"]);
$pdf->Cell(40,5,'Minimo de Copiado:');
$pdf->Cell(20,5,$datosCopiado["minimocopia"]);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,8,'Contacto:',1);
$pdf->Output();

?>