<?php
require('../libs/fpdf.php');
require("../config/global.php");

require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/Cotizacion.php');
require('../modelos/Maquinas.php');
require('../modelos/Usuarios.php');

$clientes = new Clientes($_CONF);
$cotizacion = new Cotizacion($_CONF);
$maquinas = new Maquinas($_CONF);
$usuarios = new Usuarios($_CONF);

$numerocotizacion       = $_GET['idCotizacion'];

$cotizacionDatos  = $cotizacion->obtenerdatosCotizacion($numerocotizacion);
$listaItems       = $cotizacion->obtenerItemsCotizacion($numerocotizacion,4);

$vendedor = $usuarios->obtenerDatos($cotizacionDatos["idVendedor"]);

class PDF extends FPDF
{
    //Cabecera de página
    function Header()
    {
        //Logo
        $this->Image('../imagenes/logoCotizacionVenta.jpg',8,5,181,25);
        //Salto de l�nea
        $this->Ln(24);
    }

    function BasicTable($header,$data)
    {

        //Cabecera
        //$this->SetFillColor(220,220,220);
        $this->SetFillColor(1,1,220);

        $this->Cell(8,7,$header[0],1,0,'C',true);
        $this->Cell(115,7,$header[1],1,0,'C',true);
        $this->Cell(20,7,$header[2],1,0,'C',true);
        $this->Cell(15,7,$header[3],1,0,'C',true);
        $this->Cell(15,7,$header[4],1,0,'C',true);
        $this->Cell(15,7,$header[5],1,0,'C',true);

        $this->Ln();
        //Datos
        foreach($data as $row) //Por cada Array
        {
            $pos = 1;
            foreach($row as $col) //Por cada celda del Array
            {
                if($pos == 1) //descripcion
                {
                    $this->Cell(8,6,$col,1,0,'C');
                }
                else if($pos == 2)
                {
                    $this->Cell(115,6,utf8_decode($col),1,0,'C');
                }
                else if($pos == 3)
                {
                    $this->Cell(20,6,$col,1,0,'C');
                }
                else
                {
                    $this->Cell(15,6,$col,1,0,'C');
                }


                $pos++;
            }
            $this->Ln();
        }
    }
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetDrawColor(91,155,213);
$pdf->SetFont('Arial','',10);
$pdf->Ln();
$pdf->Cell(110,5,'Inversiones y Servicios Digitales SPA');
$pdf->Cell(30,5,'Fecha');
$pdf->Cell(50,5,gmdate("d-m-Y",strtotime($cotizacionDatos["fechaCotizacion"])),1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Galleguillos Lorca No 1474');
$pdf->Cell(30,5,utf8_decode('Cotización N°'));
$pdf->Cell(50,5,$cotizacionDatos["idCotizacion"],1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Antofagasta');
$pdf->Cell(30,5,utf8_decode('Válido Hasta'));
$pdf->Cell(50,5,utf8_decode($cotizacionDatos["validez"]),1,0,'C');
//$pdf->Ln();
//$pdf->Cell(50,5,'76.121.841-7');
$pdf->Ln();
$pdf->Cell(110,5,'55-2774040');
$pdf->Cell(30,5,'Stock');
$pdf->Cell(50,5,' ',1,0,'C');
$pdf->Ln();



$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
//$pdf->SetFillColor(220,220,220);
//$pdf->SetFillColor(0,170,228);
$pdf->setfillcolor(91,155,213);

$pdf->Ln();
$pdf->Cell(150,5,'CLIENTE',1,1,'L',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);
$pdf->Cell(30,5,'Nombre:','LR');
$pdf->Cell(120,5,$cotizacionDatos["nombreContacto"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Empresa:','LR');
$pdf->Cell(120,5,$cotizacionDatos["empresa"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,utf8_decode('Dirección:'),'LR');
$pdf->Cell(120,5,$cotizacionDatos["direccion"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Ciudad:','LR');
$pdf->Cell(120,5,$cotizacionDatos["ciudad"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,utf8_decode('Teléfono:'),'LR');
$pdf->Cell(120,5,$cotizacionDatos["telefono"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Correo:','LRB');
$pdf->Cell(120,5,$cotizacionDatos["correo"],'LRB');

$pdf->Ln();
$pdf->Ln();


$pdf->Ln();
$pdf->Ln();

$pdf->Cell(50,5,utf8_decode('Por intermedio de la presente, hacemos llegar cotización.'));

$subtotal = 0;

if(is_array($listaItems))
{
    $pdf->Ln();

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(20, 5, 'CANTIDAD', 0, 0, 'C', true);
    $pdf->Cell(105, 5, 'DETALLE', 0, 0, 'C', true);
    $pdf->Cell(35, 5, 'VALOR UNITARIO', 0, 0, 'C', true);
    $pdf->Cell(30, 5, 'TOTAL', 0, 0, 'C', true);
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Ln();

    foreach($listaItems as $m)
    {
        $pdf->Cell(20, 5, $m["cantidad"], 'LRB', 0, 'C');
        $pdf->Cell(105, 5, utf8_decode($m["servicio"]), 'LRB', 0, 'C');
        $pdf->Cell(35, 5, utf8_decode('$' .number_format($m["valorUnitario"], 0, ',', '.')), 'LRB', 0, 'R');
        $pdf->Cell(30, 5, utf8_decode('$' . number_format($m["valorUnitario"]*$m["cantidad"], 0, ',', '.')), 'LRB', 0, 'R');
        $subtotal = $subtotal + $m["valorUnitario"]*$m["cantidad"];
        $pdf->Ln();
    }//fin lista
}
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(20, 5, '', 0, 0, 'C');
$pdf->Cell(20, 5, '', 0, 0, 'C');
$pdf->Cell(85, 5, '', 0, 0, 'C');
$pdf->Cell(35, 5, 'VALOR NETO', 'LRB', 0, 'R');
$pdf->Cell(30, 5, utf8_decode('$' .number_format($subtotal, 0, ',', '.')), 'LRB', 0, 'R');
$pdf->Ln();
$pdf->Cell(20, 5, '', 0, 0, 'C');
$pdf->Cell(20, 5, '', 0, 0, 'L');
$pdf->Cell(85, 5, '', 0, 0, 'C');
$pdf->Cell(35, 5, 'IVA', 'LRB', 0, 'R');
$pdf->Cell(30, 5, utf8_decode('$' .number_format($subtotal*0.19, 0, ',', '.')), 'LRB', 0, 'R');
$pdf->Ln();
$pdf->Cell(20, 5, '', 0, 0, 'C');
$pdf->Cell(20, 5, '', 0, 0, 'C');
$pdf->Cell(85, 5, '', 0, 0, 'C');
$pdf->Cell(35, 5, 'VALOR TOTAL', 'LRB', 0, 'R');
$pdf->Cell(30, 5, utf8_decode('$' .number_format($subtotal*1.19, 0, ',', '.')), 'LRB', 0, 'R');
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();

$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

$pdf->MultiCell(190,5,utf8_decode('Depósito efectivo a Cuenta Corriente'),'0');
$pdf->MultiCell(190,5,utf8_decode('003060003752'),'0');
$pdf->MultiCell(190,5,utf8_decode('Banco Scotiabank'),'0');
$pdf->MultiCell(190,5,utf8_decode('Rut: 76.121.841-7'),'0');
$pdf->MultiCell(190,5,utf8_decode('Inversiones y Servicios Digitales SPA'),'0');
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();

$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

$pdf->Ln();
$pdf->Ln();

$pdf->Ln();
$pdf->Cell(0,5,utf8_decode('Si usted tiene alguna pregunta sobre esta cotización, por favor póngase en contacto con nosotros'),0,1,'C',false);

$pdf->Ln();
$pdf->Ln();

$pdf->Cell(0,5,utf8_decode($vendedor["nombre"]. ' ' . $vendedor["apellidos"]),0,1,'C',false);
$pdf->Cell(0,5,'Ejecutivo de Ventas',0,1,'C',false);
$pdf->Cell(0,5,$vendedor["correo"],0,1,'C',false);
$pdf->Cell(0,5,$vendedor["fono"],0,1,'C',false);

$pdf->Ln();
$pdf->Ln();

$pdf->Ln();
$pdf->SetFont('Arial','B',10);
$pdf->Ln();

$pdf->Output("CotizacionArriendo",'I');
?>