<?php
require("../config/global.php");
require('../libs/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/Cotizacion.php');
require('../modelos/Maquinas.php');
require('../modelos/Usuarios.php');


$clientes = new Clientes($_CONF);
//$orden = new OrdenCompra($_CONF);
//$proveedor = new Proveedor($_CONF);

//$clientes = new Clientes();
$cotizacion = new Cotizacion($_CONF);
$maquinas = new Maquinas($_CONF);
$usuarios = new Usuarios($_CONF);

$numerocotizacion = $_GET['idCotizacion'];

$cotizacionDatos = $cotizacion->obtenerdatosCotizacion($numerocotizacion);
$listaMaquinas = $cotizacion->obtenerItemsCotizacion($numerocotizacion,2);
$listaItems = $cotizacion->obtenerItemsCotizacion($numerocotizacion,3);
$listaNuevoServicioVenta = $cotizacion->obtenerItemsNuevoServicioVenta($numerocotizacion);
$listaOpciones = $cotizacion->obtenerValorServicioInstalacion();

$vendedor = $usuarios->obtenerDatos($cotizacionDatos["idVendedor"]);

class PDF extends FPDF
{
    //Cabecera de página
    function Header()
    {
        //Logo
        $this->Image('../imagenes/logoCotizacionVentaFormato.jpg',8,5,193,25);
        //Salto de l�nea
        $this->Ln(24);
    }

    function BasicTable($header,$data)
    {

        //Cabecera
        //$this->SetFillColor(220,220,220);
        $this->SetFillColor(1,1,220);

        $this->Cell(8,7,$header[0],1,0,'C',true);
        $this->Cell(115,7,$header[1],1,0,'C',true);
        $this->Cell(20,7,$header[2],1,0,'C',true);
        $this->Cell(15,7,$header[3],1,0,'C',true);
        $this->Cell(15,7,$header[4],1,0,'C',true);
        $this->Cell(15,7,$header[5],1,0,'C',true);

        $this->Ln();
        //Datos
        foreach($data as $row) //Por cada Array
        {
            $pos = 1;
            foreach($row as $col) //Por cada celda del Array
            {
                if($pos == 1) //descripcion
                {
                    $this->Cell(8,6,$col,1,0,'C');
                }
                else if($pos == 2)
                {
                    $this->Cell(115,6,utf8_decode($col),1,0,'C');
                }
                else if($pos == 3)
                {
                    $this->Cell(20,6,$col,1,0,'C');
                }
                else
                {
                    $this->Cell(15,6,$col,1,0,'C');
                }


                $pos++;
            }
            $this->Ln();
        }
    }
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetDrawColor(91,155,213);
$pdf->SetFont('Arial','',10);
$pdf->Ln();
$pdf->Cell(110,5,'Inversiones y Servicios Digitales SPA');
$pdf->Cell(23,5,'Fecha');
$pdf->Cell(57,5,gmdate("d-m-Y",strtotime($cotizacionDatos["fechaCotizacion"])),1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Galleguillos Lorca No 1474');
$pdf->Cell(23,5,utf8_decode('Cotización N°'));
$pdf->Cell(57,5,$cotizacionDatos["idCotizacion"],1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Antofagasta');
$pdf->Cell(23,5,utf8_decode('Válido Hasta'));
$pdf->Cell(57,5,utf8_decode($cotizacionDatos["validez"]),1,0,'C');
//$pdf->Ln();
//$pdf->Cell(50,5,'76.121.841-7');
$pdf->Ln();
$pdf->Cell(110,5,'55-2774040');
$pdf->Cell(23,5,'Stock');
$pdf->Cell(57,5,utf8_decode($cotizacionDatos["stock"]),1,0,'C');
$pdf->Ln();


$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
//$pdf->SetFillColor(220,220,220);
//$pdf->SetFillColor(0,170,228);
$pdf->setfillcolor(91,155,213);


//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
//$pdf->Cell(0,5,utf8_decode('COTIZACION N° '.$cotizacionDatos["idCotizacion"]),0,3,'C',true);
$pdf->Ln();
$pdf->Cell(150,5,'DATOS CLIENTE',1,1,'L',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);
$pdf->Cell(30,5,'Razon Social','LR');
$pdf->Cell(120,5,$cotizacionDatos["empresa"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Contacto','LR');
$pdf->Cell(120,5,$cotizacionDatos["nombreContacto"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,utf8_decode('Teléfono'),'LR');
$pdf->Cell(120,5,$cotizacionDatos["telefono"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'e-mail','LR');
$pdf->Cell(120,5,$cotizacionDatos["correo"],'LR');
//$pdf->Ln();
//$pdf->Cell(30,5,utf8_decode('Dirección:'),'LR');
//$pdf->Cell(120,5,$cotizacionDatos["direccion"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Ciudad','LRB');
$pdf->Cell(120,5,$cotizacionDatos["ciudad"],'LRB');

$pdf->Ln();
$pdf->Ln();

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,'DESCRIPCION',0,1,'C',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

$totalVentaConIva = 0;
$instalacion = 'NO';

if(is_array($listaMaquinas))
{
    foreach($listaMaquinas as $m)
    {
        $pdf->MultiCell(190, 5, utf8_decode($m["descripcion"]), 1);
        $pdf->Ln();

        $pdf->SetFont('Arial','B',10);
        $pdf->SetTextColor(255,255,255);
        $pdf->Cell(0,5,'MAQUINA Y SUMINISTROS',0,1,'C',true);
        $pdf->SetFont('Arial','',10);
        $pdf->SetTextColor(0,0,0);

        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->Cell(100, 5, 'DETALLE', 0, 0, 'C', true);
        $pdf->Cell(20, 5, 'CANTIDAD', 0, 0, 'C', true);
        $pdf->Cell(35, 5, 'PRECIO UNITARIO', 0, 0, 'C', true);
        $pdf->Cell(35, 5, 'TOTAL CON IVA', 0, 0, 'C', true);
        $pdf->SetFont('Arial', '', 10);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Ln();

        $subtotal = round($m["cantidad"]*$m["precioVenta"]*1.19,0);
        $pdf->Cell(100, 5, utf8_decode($m["modelo"]), 'LRB', 0, 'L');
        $pdf->Cell(20, 5, $m["cantidad"], 'LRB', 0, 'C');
        $pdf->Cell(35, 5,'$' .number_format($m["precioVenta"], 0, ',', '.'), 'LRB', 0, 'R');
        $pdf->Cell(35, 5,'$' .number_format($subtotal, 0, ',', '.'), 'LRB', 0, 'R');
        $totalVentaConIva = $totalVentaConIva + $subtotal;
        $opcionSeleccionada = $m["servicioinstalacion"];
        $instalacion = $m["instalacion"];
        $pdf->Ln();
    }
}

if(is_array($listaItems)) {
    foreach ($listaItems as $li) {
        $subtotal = round($li["cantidad"]*$li["valorUnitario"]*1.19,0);
        $pdf->Cell(100, 5, utf8_decode($li["descripcion"]), 'LRB', 0, 'L');
        $pdf->Cell(20, 5, $li["cantidad"], 'LRB', 0, 'C');
        $pdf->Cell(35, 5,'$' .number_format($li["valorUnitario"], 0, ',', '.'), 'LRB', 0, 'R');
        $pdf->Cell(35, 5,'$' .number_format($subtotal, 0, ',', '.'), 'LRB', 0, 'R');
        $totalVentaConIva = $totalVentaConIva + $subtotal;
        $pdf->Ln();
    }
}

if(is_array($listaNuevoServicioVenta)) {
    foreach ($listaNuevoServicioVenta as $li) {
        $subtotal = round($li["cantidad"]*$li["precioVenta"]*1.19,0);
        $pdf->Cell(100, 5, utf8_decode($li["detalle"]), 'LRB', 0, 'L');
        $pdf->Cell(20, 5, $li["cantidad"], 'LRB', 0, 'C');
        $pdf->Cell(35, 5,'$' .number_format($li["precioVenta"], 0, ',', '.'), 'LRB', 0, 'R');
        $pdf->Cell(35, 5,'$' .number_format($subtotal, 0, ',', '.'), 'LRB', 0, 'R');
        $totalVentaConIva = $totalVentaConIva + $subtotal;
        $pdf->Ln();
    }
}

$pdf->SetFont('Arial','B',10);
$pdf->Cell(100, 5, '', 'LRB', 0, 'C');
$pdf->Cell(20, 5, '', 'LRB', 0, 'C');
$pdf->Cell(35, 5,'Total','LRB', 0, 'R');
$pdf->Cell(35, 5,'$' .number_format(($totalVentaConIva), 0, ',', '.'), 'LRB', 0, 'R');
$pdf->SetFont('Arial','',10);

$pdf->Ln();
$pdf->Cell(70, 5, utf8_decode('Nota: Cotización no incluye instalación.'), '0', 0, 'C');

$pdf->Ln();
$pdf->Ln();

if ($instalacion == "SI" ) {
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(0, 5, 'SERVICIOS INSTALACION', 0, 1, 'C', true);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(0, 0, 0);
//$pdf->Ln();

    $pdf->Cell(0, 5, utf8_decode('Marcar con una X la opción de Servicio de Instalación más deseada.'), 'LR', 0, 'L');
    $pdf->Ln();
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor(0, 0, 0);
//$pdf->Cell(0, 5, utf8_decode('Seleccione la opción que más le acomode.'), 'LR', 0, 'L');
    $pdf->Cell(0, 5, utf8_decode(' '), 'LR', 0, 'L');
    if (is_array($listaOpciones)) {
        foreach ($listaOpciones as $m) {
            $pdf->Ln();
            $pdf->Cell(100, 5, $m["descripcion"], 'L', 0, 'L');
            $pdf->Cell(20, 5, '$  ' . number_format($m["valor"], 0, ',', '.'), 0, 0, 'R');
            $pdf->Cell(5, 5, '', 'TLRB', 0, 'L', $m["idLugarInstalacion"] == $opcionSeleccionada ? true : false);
            $pdf->Cell(0, 5, '', 'R', 0, 'L');
        }
    }

    $pdf->Ln();
    $pdf->Cell(0, 5, '  ', 'LR', 0, 'L');
    $pdf->Ln();

    $pdf->Cell(50, 5, utf8_decode('*Valores de instalación no incluyen IVA'), 'LR', 0, 'L');
    $pdf->Cell(0, 5, '', 'R', 0, 'L');
    $pdf->Ln();
    $pdf->Cell(50, 5, utf8_decode('Incluye Instalación de equipo/ Conexión del equipo a 01 computador a red, USB o WiFi/ Inducción al personal'), 'LR', 0, 'L');
    $pdf->Cell(0, 5, '', 'R', 0, 'L');
    $pdf->Ln();
    $pdf->Cell(50, 5, utf8_decode('La conexión del equipo en red, USB o WiFi en otros computadores adicionales, este tendrá un valor de'), 'LR', 0, 'L');
    $pdf->Cell(0, 5, '', 'R', 0, 'L');
    $pdf->Ln();
    $pdf->Cell(50, 5, utf8_decode('$0.5 UF más IVA por cada computador'), 'LR', 0, 'L');
    $pdf->Cell(0, 5, '', 'R', 0, 'L');
    $pdf->Ln();
    $pdf->Cell(0, 5, '  ', 'LRB', 0, 'L');

    $pdf->Ln();
    $pdf->Ln();

}

if ($instalacion == "SI" ) {
    $pdf->Ln();
    $pdf->Ln();
    $pdf->AddPage();
}

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,'CONDICIONES DE PAGO',0,1,'C',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

$pdf->SetFont('Arial','B',10);
$pdf->MultiCell(190,5,utf8_decode('La forma de pago de los productos ofrecidos en esta cotización son los siguientes'),'LR');
$pdf->SetFont('Arial','',10);
$pdf->MultiCell(190,5,utf8_decode('Efectivo/ Cheque al día/ Transferencia o Depósito Bancario'),'LR');
$pdf->MultiCell(190,5,utf8_decode('Se aceptan OC a 30 días con previa evaluación'),'LR');
$pdf->SetFont('Arial','B',10);
$pdf->MultiCell(190,5,utf8_decode('Datos para transferencia y depósito:'),'LR');
$pdf->SetFont('Arial','',10);
$pdf->MultiCell(190,5,utf8_decode('- Nombre: Inversiones y Servicios Digitales SPA'),'LR');
$pdf->MultiCell(190,5,utf8_decode('- Rut: 76.121.841-7'),'LR');
$pdf->MultiCell(190,5,utf8_decode('- Cta. Cte.: 003060003752 Scotiabank'),'LR');
$pdf->MultiCell(190,5,utf8_decode('- administracion@dsprint.cl'),'LR');

//$pdf->Cell(0, 5, '', 'LR',0,'L');
$pdf->Cell(0,5,'x____________________________________________','LR',1,'R',false);
$pdf->Cell(0,5,'Nombre y Firma del Cliente','LRB',1,'R',false);
//$pdf->Cell(0, 5, ' ', 'LRB',0,'L');
//$pdf->Ln();
//$pdf->Cell(0, 5, '  ', 'LRB', 0, 'L');


$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,utf8_decode('Si usted tiene alguna pregunta sobre esta cotización, por favor póngase en contacto con nosotros'),0,1,'C',false);

//$pdf->Ln();
//$pdf->Ln();

$pdf->Cell(0,5,utf8_decode($vendedor["nombre"]. ' ' . $vendedor["apellidos"]),0,1,'C',false);
$pdf->Cell(0,5,'Ejecutivo de Ventas',0,1,'C',false);
$pdf->Cell(0,5,$vendedor["correo"],0,1,'C',false);
$pdf->Cell(0,5,$vendedor["fono"],0,1,'C',false);

$pdf->Ln();
//$pdf->Ln();

$pdf->Cell(0,5,utf8_decode('¡Gracias por hacer negocios con nosotros!'),0,1,'C',false);

//$pdf->SetFont('Arial','',8);
//$pdf->SetFont('Arial','B',8);

//$pdf->Ln();
//$pdf->Ln();
//$pdf->Ln();
//$pdf->Ln();
//$pdf->SetFont('Arial','B',10);
//$pdf->Ln();

$pdf->Output("CotizacionVentaMaquina",'I');
?>