<?php
require('../libs/fpdf.php');
require("../config/global.php");

require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/Cotizacion.php');
require('../modelos/Maquinas.php');
require('../modelos/Usuarios.php');

$clientes = new Clientes($_CONF);
$cotizacion = new Cotizacion($_CONF);
$maquinas = new Maquinas($_CONF);
$usuarios = new Usuarios($_CONF);

$numerocotizacion       = $_GET['idCotizacion'];

$cotizacionDatos     = $cotizacion->obtenerdatosCotizacion($numerocotizacion);
$listaMaquinas       = $cotizacion->obtenerItemsCotizacion($numerocotizacion,1);

$vendedor = $usuarios->obtenerDatos($cotizacionDatos["idVendedor"]);

class PDF extends FPDF
{
    //Cabecera de página
    function Header()
    {
        //Logo
        $this->Image('../imagenes/logoCotizacionArriendo.jpg',8,5,193,25);
        //Salto de l�nea
        $this->Ln(24);
    }

    function BasicTable($header,$data)
    {

        //Cabecera
        //$this->SetFillColor(220,220,220);
        $this->SetFillColor(1,1,220);

        $this->Cell(8,7,$header[0],1,0,'C',true);
        $this->Cell(115,7,$header[1],1,0,'C',true);
        $this->Cell(20,7,$header[2],1,0,'C',true);
        $this->Cell(15,7,$header[3],1,0,'C',true);
        $this->Cell(15,7,$header[4],1,0,'C',true);
        $this->Cell(15,7,$header[5],1,0,'C',true);

        $this->Ln();
        //Datos
        foreach($data as $row) //Por cada Array
        {
            $pos = 1;
            foreach($row as $col) //Por cada celda del Array
            {
                if($pos == 1) //descripcion
                {
                    $this->Cell(8,6,$col,1,0,'C');
                }
                else if($pos == 2)
                {
                    $this->Cell(115,6,utf8_decode($col),1,0,'C');
                }
                else if($pos == 3)
                {
                    $this->Cell(20,6,$col,1,0,'C');
                }
                else
                {
                    $this->Cell(15,6,$col,1,0,'C');
                }


                $pos++;
            }
            $this->Ln();
        }
    }
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetDrawColor(91,155,213);
$pdf->SetFont('Arial','',10);
$pdf->Ln();
$pdf->Cell(110,5,'Inversiones y Servicios Digitales SPA');
$pdf->Cell(30,5,'Fecha');
$pdf->Cell(50,5,gmdate("d-m-Y",strtotime($cotizacionDatos["fechaCotizacion"])),1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Galleguillos Lorca No 1474');
$pdf->Cell(30,5,utf8_decode('Cotización N°'));
$pdf->Cell(50,5,$cotizacionDatos["idCotizacion"],1,0,'C');
$pdf->Ln();
$pdf->Cell(110,5,'Antofagasta');
$pdf->Cell(30,5,utf8_decode('Válido Hasta'));
$pdf->Cell(50,5,utf8_decode($cotizacionDatos["validez"]),1,0,'C');
//$pdf->Ln();
//$pdf->Cell(50,5,'76.121.841-7');
$pdf->Ln();
$pdf->Cell(110,5,'55-2774040');
$pdf->Cell(30,5,'Stock');
$pdf->Cell(50,5,' ',1,0,'C');
$pdf->Ln();



$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
//$pdf->SetFillColor(220,220,220);
//$pdf->SetFillColor(0,170,228);
$pdf->setfillcolor(91,155,213);


//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
//$pdf->Cell(0,5,utf8_decode('COTIZACION N° '.$cotizacionDatos["idCotizacion"]),0,3,'C',true);
$pdf->Ln();
$pdf->Cell(150,5,'DATOS CLIENTE',1,1,'L',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);
$pdf->Cell(30,5,'Razon Social','LR');
$pdf->Cell(120,5,$cotizacionDatos["empresa"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Contacto','LR');
$pdf->Cell(120,5,$cotizacionDatos["nombreContacto"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,utf8_decode('Teléfono'),'LR');
$pdf->Cell(120,5,$cotizacionDatos["telefono"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'e-mail','LR');
$pdf->Cell(120,5,$cotizacionDatos["correo"],'LR');
//$pdf->Ln();
//$pdf->Cell(30,5,utf8_decode('Dirección:'),'LR');
//$pdf->Cell(120,5,$cotizacionDatos["direccion"],'LR');
$pdf->Ln();
$pdf->Cell(30,5,'Ciudad','LRB');
$pdf->Cell(120,5,$cotizacionDatos["ciudad"],'LRB');

$pdf->Ln();
$pdf->Ln();


$pdf->Ln();
$pdf->Ln();

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,'SERVICIO',0,1,'C',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

if(is_array($listaMaquinas))
{
    foreach($listaMaquinas as $m)
    {
        //$descrip = $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["modelo"]." ".$c["descripcion"];
        //$data[]=array($c["cantidad"], $descrip, $c["numparte"], $c["codinterno"], number_format($c["precio"],0, ',', '.'), number_format($c["precio"]*$c["cantidad"],0, ',', '.'));
        //$totalneto = $totalneto + $c["precio"]*$c["cantidad"];

        //$datosMaquinaPeriodoCosto = $cotizacion->obtenerdatosMaquinaPeriodoCosto($listaMaquinas[$i],$arr_itemidmaquinacotizacion[$i]);
        $pdf->MultiCell(190, 5, utf8_decode('Arriendo Máquina ' . $m["tipo"] . ' ' . $m["formato"] . ', Modelo ' . $m["modelo"] . ' ' . $m["nombremarca"] . ' ocupada como equipo por un periodo de ' . $m["descripcionPeriodo"] . '. Instalada en Segunda Región'), 1);
        $pdf->Ln();

        $listaOpciones      = $cotizacion->obtenerItemsCotizacionOpciones($m["idCotizacionItem"]);

        if ($m["colorCosto"] == 0) {
            $pdf->SetFont('Arial', 'B', 10);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->Cell(20, 5, 'CANTIDAD', 0, 0, 'C', true);
            $pdf->Cell(40, 5, 'MAQUINA', 0, 0, 'C', true);
            $pdf->Cell(20, 5, 'COSTO', 0, 0, 'C', true);
            $pdf->Cell(20, 5, 'MINIMO', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'COSTO', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'MINIMO', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'CARGO', 0, 0, 'C', true);
            $pdf->Cell(24, 5, 'TOTAL', 0, 0, 'C', true);
            $pdf->Ln();
            $pdf->Cell(20, 5, '', 0, 0, 'C', true);
            $pdf->Cell(40, 5, '', 0, 0, 'C', true);
            $pdf->Cell(20, 5, 'B/N', 0, 0, 'C', true);
            $pdf->Cell(20, 5, 'B/N', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'SCANNER', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'SCANNER', 0, 0, 'C', true);
            $pdf->Cell(22, 5, 'FIJO', 0, 0, 'C', true);
            $pdf->Cell(24, 5, '', 0, 0, 'C', true);
            $pdf->SetFont('Arial', '', 10);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->Ln();
            $pdf->Cell(20, 5, $m["cantidad"], 'LRB', 0, 'C');
            $pdf->Cell(40, 5, utf8_decode($m["modelo"]), 'LRB', 0, 'C');
            $pdf->Cell(20, 5, utf8_decode('$' . $m["bnCosto"]), 'LRB', 0, 'C');
            $pdf->Cell(20, 5, utf8_decode(number_format($m["bnMinimo"], 0, ',', '.')), 'LRB', 0, 'C');
            $pdf->Cell(22, 5, utf8_decode('$' . $m["scannerCosto"]), 'LRB', 0, 'C');
            $pdf->Cell(22, 5, utf8_decode(number_format($m["scannerMinimo"], 0, ',', '.')), 'LRB', 0, 'C');
            $pdf->Cell(22, 5, utf8_decode('$' . number_format($m["cargoFijo"], 0, ',', '.')), 'LRB', 0, 'C');
            $TOTALPARCIAL = $m["cantidad"] * ($m["bnCosto"] * $m["bnMinimo"] + $m["scannerCosto"] * $m["scannerMinimo"] + $m["cargoFijo"]);
            $pdf->Cell(24, 5, utf8_decode('$' . number_format($TOTALPARCIAL, 0, ',', '.')), 'LRB', 0, 'C');
        }
        else{
            $pdf->SetFont('Arial', 'B', 10);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->Cell(13, 5, 'CANT.', 0, 0, 'C', true);
            $pdf->Cell(32, 5, 'MAQUINA', 0,  0, 'C', true);
            $pdf->Cell(17, 5, 'COSTO',  0,  0, 'C', true);
            $pdf->Cell(17, 5, 'COSTO',  0, 0, 'C', true);
            $pdf->Cell(20, 5, 'COSTO',  0, 0, 'C', true);
            $pdf->Cell(17, 5, 'MINIMO', 0, 0, 'C', true);
            $pdf->Cell(17, 5, 'MINIMO', 0, 0,  'C', true);
            $pdf->Cell(20, 5, 'MINIMO', 0, 0,  'C', true);
            $pdf->Cell(17, 5, 'CARGO', 0, 0, 'C', true);
            $pdf->Cell(20, 5, 'TOTAL', 0,  0, 'C', true);
            $pdf->Ln();
            $pdf->Cell(13, 5, '', 0, 0, 'C', true);
            $pdf->Cell(32, 5, '', 0,  0, 'C', true);
            $pdf->Cell(17, 5, '  B/N',  0,  0, 'C', true);
            $pdf->Cell(17, 5, 'COLOR',  0, 0, 'C', true);
            $pdf->Cell(20, 5, 'SCANNER',  0, 0, 'C', true);
            $pdf->Cell(17, 5, 'B/N',  0, 0, 'C', true);
            $pdf->Cell(17, 5, 'COLOR', 0, 0,  'C', true);
            $pdf->Cell(20, 5, 'SCANNER', 0, 0,  'C', true);
            $pdf->Cell(17, 5, 'FIJO', 0, 0, 'C', true);
            $pdf->Cell(20, 5, '', 0,  0, 'C', true);
            $pdf->SetFont('Arial', '', 10);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->Ln();
            $pdf->Cell(13, 5, $m["cantidad"], 'LRB',0,'C');
            $pdf->Cell(32, 5, utf8_decode($m["modelo"]), 'LRB');
            $pdf->Cell(17, 5, utf8_decode('$' . $m["bnCosto"]), 'LRB',0,'C');
            $pdf->Cell(17, 5, utf8_decode('$' . $m["colorCosto"]), 'LRB',0,'C');
            $pdf->Cell(20, 5, utf8_decode('$' . $m["scannerCosto"]), 'LRB',0,'C');
            $pdf->Cell(17, 5, utf8_decode(number_format($m["bnMinimo"], 0, ',', '.')), 'LRB',0,'C');
            $pdf->Cell(17, 5, utf8_decode(number_format($m["colorMinimo"], 0, ',', '.')), 'LRB',0,'C');
            $pdf->Cell(20, 5, utf8_decode(number_format($m["scannerMinimo"], 0, ',', '.')), 'LRB',0,'C');
            $pdf->Cell(17, 5, utf8_decode('$' . number_format($m["cargoFijo"], 0, ',', '.')), 'LRB',0,'C');
            $TOTALPARCIAL = $m["cantidad"] * ($m["bnCosto"] * $m["bnMinimo"] + $m["colorCosto"] * $m["colorMinimo"] + $m["scannerCosto"] * $m["scannerMinimo"] + $m["cargoFijo"]);
            $pdf->Cell(20, 5, utf8_decode('$' . number_format($TOTALPARCIAL, 0, ',', '.')), 'LRB',0,'C');
        }

        //$datosMaquinaCondiciones = $cotizacion->obtenerdatosMaquinaPeriodoCostoCondiciones($cotizacionDatos["idCotizacion"],$m["idmaquinacotizacion"]);


        $datosMaquinaCondiciones = $m["condiciones"];
        $pdf->Ln();
        $pdf->Ln();
    }//fin lista
}

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,'CARGO FIJO MENSUAL',0,1,'C',true);
$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(0,0,0);
//$pdf->Ln();

$pdf->Cell(0, 5, utf8_decode('Marcar con una X la opción de Cargo Fijo Mensual más deseada, de lo contrario se considera'), 'LR', 0, 'L');
$pdf->Ln();
$pdf->Cell(0, 5, utf8_decode('automáticamente la opción estándar.'), 'LR', 0, 'L');
$pdf->Ln();
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);
//$pdf->Cell(0, 5, utf8_decode('Seleccione la opción que más le acomode.'), 'LR', 0, 'L');
$pdf->Cell(0, 5, utf8_decode(' '), 'LR', 0, 'L');
if(is_array($listaOpciones)) {
    foreach ($listaOpciones as $m){
        $pdf->Ln();
        $pdf->Cell(100, 5, $m["descripcion"], 'L', 0, 'L');
        $pdf->Cell(20, 5, '$  ' . number_format($m["valor"], 0, ',', '.'), 0,0,'R');
        $pdf->Cell(5, 5, '', 'TLRB',0,'L',1==$m["seleccionado"]?true:false);
        $pdf->Cell(0, 5, '', 'R',0,'L');
    }
}
$pdf->Ln();
$pdf->Cell(0, 5, '  ', 'LRB', 0, 'L');
$pdf->Ln();$pdf->Ln();

$pdf->Cell(50,5,utf8_decode('*Todos los valores que se reflejan en esta cotización son NETO'));
$pdf->Ln();

$pdf->Ln();

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,'TERMINOS Y CONDICIONES',0,1,'C',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);

$pdf->MultiCell(190,5,utf8_decode($datosMaquinaCondiciones),'LR');

$pdf->MultiCell(190,5,utf8_decode('*El uso del equipo es netamente para trabajos de Oficina y no para impresiones Gráficas. Si el cliente utiliza la máquina para impresiones gráficas, Digital Service, tendrá la facultad de realizar el cambio de la máquina.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('*Este contrato incluye: Tóner, Servicio Técnico, repuestos y mantención del equipo.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('*Todo daño provocado por el usuario de la máquina (mala manipulación de esta) por ejemplo Quiebre de piezas, ralladura de piezas internas o externas, derrame de líquido en el equipo entre otras, serán descontadas en la próxima facturación con previa evaluación e información.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('*En caso de faenas, la primera visita (instalación de equipo) será sin costo alguno, si el cliente solicita la visita técnica en su faena, tendrá un costo de $80.000.- + IVA. Si no desea cancelar este monto deberá bajar el equipo a nuestras oficinas en Antofagasta, respetando los protocolos de traslados entregados por Digital Service.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('*El arrendatario no podrá trasladar y/o mover los equipos sin previa autorización de Digital Service, el no cumplimiento conllevará a multas evaluadas según gravedad.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('*En caso de pérdida de suministros, estos serán cobrados en la siguiente facturación.'),'LRB');
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();

$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(0,5,utf8_decode('Para realizar la instalación de la máquina se requiere lo siguiente:'),0,1,'C',true);
$pdf->SetFont('Arial','',10);
$pdf->SetTextColor(0,0,0);
$pdf->MultiCell(190,5,utf8_decode('Enviar OC, para el respaldo del arriendo (si lo amerita).'),'LR');
$pdf->MultiCell(190,5,utf8_decode('Completar formularios con datos de la empresa (solo para Clientes Nuevos).'),'LR');
$pdf->MultiCell(190,5,utf8_decode('Tener contrato firmado por ambas partes.'),'LR');
$pdf->MultiCell(190,5,utf8_decode('Enviar cotización firmada al mail abastecimiento@dsprint.cl (firmar a continuación).'),'LRB');
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();

$pdf->Cell(0,5,'x____________________________________________',0,1,'L',false);
$pdf->Cell(0,5,'Nombre del Cliente',0,1,'L',false);

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,5,utf8_decode('Si usted tiene alguna pregunta sobre esta cotización, por favor póngase en contacto con nosotros'),0,1,'C',false);

$pdf->Ln();
$pdf->Ln();

$pdf->Cell(0,5,utf8_decode($vendedor["nombre"]. ' ' . $vendedor["apellidos"]),0,1,'C',false);
$pdf->Cell(0,5,'Ejecutivo de Ventas',0,1,'C',false);
$pdf->Cell(0,5,$vendedor["correo"],0,1,'C',false);
$pdf->Cell(0,5,$vendedor["fono"],0,1,'C',false);

$pdf->Ln();
$pdf->Ln();

$pdf->Cell(0,5,utf8_decode('¡Gracias por hacer negocios con nosotros!'),0,1,'C',false);

$pdf->SetFont('Arial','',8);
$pdf->SetFont('Arial','B',8);

$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->SetFont('Arial','B',10);
$pdf->Ln();

$pdf->Output("CotizacionArriendo",'I');
?>