<?php
require('../libs/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/CompraDirecta.php');

$compra = new CompraDirecta();

$idcd 	= $_GET['idCD'];

//Datos Orden de Compra
$cd 	= $compra->obtenerdatosCD($idcd);
$listainventario = $compra->obtenerItemsInventarioCD($idcd);
$listamaqserv = $compra->obtenerItemsMaqServCD($idcd);

class PDF extends FPDF
{
	//Cabecera de p�gina
	function Header()
	{
		//Logo
		$this->Image('../imagenes/headerdoc.jpg',55,10,100,20);
		//Salto de l�nea
		$this->Ln(24);
	}

	//Tabla simple
	//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
	
	function BasicTable($header,$data)
	{
		
		//Cabecera
		$this->SetFillColor(220,220,220);
		foreach($header as $col)	
		{	$head = substr($col,0,8);
			if($head == "Descripc")
				$this->Cell(82,7,$col,1,0,'C',true);
			else
				$this->Cell(35,7,$col,1,0,'C',true);
		}
		$this->Ln();
		//Datos
		foreach($data as $row) //Por cada Array
		{
			$pos = 1;
			foreach($row as $col) //Por cada celda del Array
			{				
				if($pos == 2)
					$this->Cell(82,6,utf8_decode($col),1,0,'C');
				else
					$this->Cell(35,6,$col,1,0,'C');
					
				$pos++;
			}
			$this->Ln();
		}
	}
}

$pdf=new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->SetFillColor(220,220,220);
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Cell(0,5,'COMPRA DIRECTA  N� '.$cd["IDcd"],0,3,'C',true);
$pdf->Ln();
$pdf->Cell(0,5,'Proveedor',0,1,'L',true);
$pdf->Cell(50,5,'Raz�n Social:');
$pdf->Cell(50,5,$cd["razonsocial"]);
$pdf->Ln();
$pdf->Cell(50,5,'Rut:');
$pdf->Cell(50,5,$cd["rutp"]);
$pdf->Ln();
$pdf->Cell(50,5,'Nombre:');
$pdf->Cell(50,5,$cd["nombre"]);
$pdf->Ln();
$pdf->Ln();

$header=array('Cantidad','Descripci�n','P. Unitario','Total');
$totalneto = 0;
if(is_array($listainventario))
{
	foreach($listainventario as $c)
	{		
		$cadena = $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["modelo"]." ".$c["descripcion"];
		if(strlen($cadena) < 38)
		{
			$descrip = $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["modelo"]." ".$c["descripcion"];
		}else
		{
			$descrip = $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["modelo"];	
		}
		$data[]=array($c["cantidad"], $descrip, number_format($c["precio"],0, ',', '.'), number_format($c["precio"]*$c["cantidad"],0, ',', '.'));
		$totalneto = $totalneto + $c["precio"]*$c["cantidad"];
		
	}//fin lista
}

if(is_array($listamaqserv))
{	
	foreach($listamaqserv as $ms)
	{	
		if(strlen($ms["descripcion"]) > 38)
		{
			$descrip = substr($ms["descripcion"],0,38);
		}else
		{
			$descrip = $ms["descripcion"];	
		}
		
		$data[]=array($ms["cantidad"], $descrip, number_format($ms["precio"],0, ',', '.'), number_format($ms["precio"]*$ms["cantidad"],0, ',', '.'));
		$totalneto = $totalneto + $ms["precio"]*$ms["cantidad"];
		
	}//fin lista
}

$pdf->BasicTable($header,$data);

//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Cell(152,6,'Total Neto',1,0,'R');
$pdf->Cell(35,6,number_format($totalneto,0, ',', '.'),1,0,'C');
$pdf->Ln();
$pdf->Cell(152,6,'I.V.A.',1,0,'R');
$pdf->Cell(35,6,number_format($totalneto*0.19,0, ',', '.'),1,0,'C');
$pdf->Ln();
$pdf->Cell(152,6,'TOTAL',1,0,'R');
$pdf->Cell(35,6,number_format($totalneto+($totalneto*0.19),0, ',', '.'),1,0,'C');

$pdf->Output("CompraDirecta",I);

?>