SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for areas
-- ----------------------------
DROP TABLE IF EXISTS `areas`;
CREATE TABLE `areas`  (
  `idarea` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nombrearea` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idarea`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 12 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for boletaitems
-- ----------------------------
DROP TABLE IF EXISTS `boletaitems`;
CREATE TABLE `boletaitems`  (
  `IDboletaitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDboleta` int(11) NULL DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cantidad` int(11) NULL DEFAULT NULL,
  `precio` int(11) NULL DEFAULT NULL,
  `IDinventario` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `IDdepartamentoCliente` int(11) NULL DEFAULT 0,
  `IDcentroCosto` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`IDboletaitem`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 21 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for boletas
-- ----------------------------
DROP TABLE IF EXISTS `boletas`;
CREATE TABLE `boletas`  (
  `idBoleta` int(11) NOT NULL DEFAULT 0,
  `fechaBoleta` date NULL DEFAULT NULL,
  `rutCliente` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `formaPago` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Forma de Pago',
  `referencia` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Referencia',
  `idCentroCosto` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`idBoleta`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for categorias
-- ----------------------------
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias`  (
  `IDcategoria` int(20) NOT NULL AUTO_INCREMENT,
  `nombrecategoria` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`IDcategoria`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 145 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cd
-- ----------------------------
DROP TABLE IF EXISTS `cd`;
CREATE TABLE `cd`  (
  `IDcd` int(11) NOT NULL AUTO_INCREMENT,
  `rutp` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `razonsocial` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombre` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `total` int(10) NULL DEFAULT NULL,
  PRIMARY KEY (`IDcd`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 445 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cditems
-- ----------------------------
DROP TABLE IF EXISTS `cditems`;
CREATE TABLE `cditems`  (
  `IDcdprod` int(11) NOT NULL AUTO_INCREMENT,
  `IDcd` int(11) NOT NULL DEFAULT 0,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NULL DEFAULT NULL,
  `precio` int(10) NULL DEFAULT NULL,
  `tipo` int(11) NULL DEFAULT NULL COMMENT '1: inventario, 0:maquinas u otro servicio',
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY (`IDcdprod`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1180 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for centrocosto
-- ----------------------------
DROP TABLE IF EXISTS `centrocosto`;
CREATE TABLE `centrocosto`  (
  `idCentroCosto` int(11) NOT NULL AUTO_INCREMENT,
  `nombreCentroCosto` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `codigoCentroCosto` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'CC',
  PRIMARY KEY (`idCentroCosto`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 12 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for clientedepartamentos
-- ----------------------------
DROP TABLE IF EXISTS `clientedepartamentos`;
CREATE TABLE `clientedepartamentos`  (
  `idDepartamentoCliente` int(10) NOT NULL AUTO_INCREMENT,
  `nombreDepartamentoCliente` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'NOMBRE DEPARTAMENTO',
  `rutCliente` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `estado` int(10) NOT NULL DEFAULT 1,
  PRIMARY KEY (`idDepartamentoCliente`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 26 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for clientemaquina
-- ----------------------------
DROP TABLE IF EXISTS `clientemaquina`;
CREATE TABLE `clientemaquina`  (
  `rutcliente` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `serieintmaquina` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `correlativo` int(11) NOT NULL,
  `estado` int(1) NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT '0000-00-00',
  `ubicacion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `facturada` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`rutcliente`, `serieintmaquina`, `correlativo`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'Historial de máquinas clientes' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes`  (
  `rut` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `dv` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `razonsocial` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cliente` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombre` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ciudad` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `giro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`rut`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for configuraciones
-- ----------------------------
DROP TABLE IF EXISTS `configuraciones`;
CREATE TABLE `configuraciones`  (
  `idconfiguracion` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `valor` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `tipo` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `deshabilitado` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`idconfiguracion`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for contadores
-- ----------------------------
DROP TABLE IF EXISTS `contadores`;
CREATE TABLE `contadores`  (
  `rutcliente` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `serieintmaquina` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `correlativo` int(11) NOT NULL DEFAULT 0,
  `instalacion` int(11) NOT NULL DEFAULT 0,
  `fechafacturacion` date NOT NULL DEFAULT '0000-00-00',
  `contador` int(11) NULL DEFAULT NULL,
  `copiaerrores` int(11) NULL DEFAULT NULL,
  `diferencia` int(11) NULL DEFAULT NULL,
  `copiasfacturadas` int(11) NULL DEFAULT NULL,
  `fechacaptura` date NOT NULL DEFAULT '0000-00-00',
  `tipocaptura` int(11) NULL DEFAULT NULL,
  `firma` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `idreport` int(11) NULL DEFAULT NULL,
  `idfactura` int(11) NULL DEFAULT NULL,
  `idTipoServicioMaquina` int(11) NOT NULL DEFAULT 1 COMMENT 'Cambio 27-Enero-2014 - Jose Quinteros',
  PRIMARY KEY (`rutcliente`, `serieintmaquina`, `correlativo`, `instalacion`, `fechafacturacion`, `fechacaptura`, `idTipoServicioMaquina`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for controldevolucioninventario
-- ----------------------------
DROP TABLE IF EXISTS `controldevolucioninventario`;
CREATE TABLE `controldevolucioninventario`  (
  `idDevolucion` int(11) NOT NULL AUTO_INCREMENT,
  `idControl` int(11) NULL DEFAULT NULL,
  `idProducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cantidad` int(10) NULL DEFAULT NULL,
  `fechaDevolucion` date NULL DEFAULT NULL,
  `fechaDevolucionReal` date NULL DEFAULT NULL,
  PRIMARY KEY (`idDevolucion`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3446 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for controlinventario
-- ----------------------------
DROP TABLE IF EXISTS `controlinventario`;
CREATE TABLE `controlinventario`  (
  `IDcontrol` int(11) NOT NULL DEFAULT 0,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `cantidad` int(10) NULL DEFAULT NULL,
  PRIMARY KEY (`IDcontrol`, `IDproducto`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for controlsalida
-- ----------------------------
DROP TABLE IF EXISTS `controlsalida`;
CREATE TABLE `controlsalida`  (
  `IDcontrol` int(11) NOT NULL AUTO_INCREMENT,
  `rut` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombrecliente` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `rutcliente` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `recinto` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `hora` time(0) NULL DEFAULT NULL,
  `idCentroCosto` int(11) NULL DEFAULT 8,
  PRIMARY KEY (`IDcontrol`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 19191 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for copiascliente
-- ----------------------------
DROP TABLE IF EXISTS `copiascliente`;
CREATE TABLE `copiascliente`  (
  `rutcliente` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `costocopia` int(11) NULL DEFAULT NULL,
  `minimocopia` int(11) NULL DEFAULT NULL,
  `costofijo` int(11) NULL DEFAULT NULL,
  `idTipoServicioMaquina` int(11) NOT NULL DEFAULT 0,
  `serieintmaquina` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`rutcliente`, `idTipoServicioMaquina`, `serieintmaquina`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cotizacion
-- ----------------------------
DROP TABLE IF EXISTS `cotizacion`;
CREATE TABLE `cotizacion`  (
  `IDcotizacion` int(11) NOT NULL AUTO_INCREMENT,
  `rutcliente` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `total` int(10) NULL DEFAULT NULL,
  `estado` int(1) NULL DEFAULT NULL COMMENT 'Estado: 2: Pendiente total (producto + factura) / 1: Pendiente factura / 0: Recibida sin problemas',
  `tipocotizacion` int(1) NULL DEFAULT 1,
  PRIMARY KEY (`IDcotizacion`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cotizacionitems
-- ----------------------------
DROP TABLE IF EXISTS `cotizacionitems`;
CREATE TABLE `cotizacionitems`  (
  `IDcotizacionitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDcotizacion` int(11) NOT NULL DEFAULT 0,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NULL DEFAULT NULL,
  `precio` int(10) NULL DEFAULT NULL,
  `tipo` int(1) NULL DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY (`IDcotizacionitem`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cotizacionmaquinas
-- ----------------------------
DROP TABLE IF EXISTS `cotizacionmaquinas`;
CREATE TABLE `cotizacionmaquinas`  (
  `idmaquinacotizacion` int(11) NOT NULL AUTO_INCREMENT,
  `tipomaquina` int(11) NULL DEFAULT NULL,
  `marca` int(11) NULL DEFAULT NULL,
  `modelo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `formato` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `conectividad` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `activo` int(1) NULL DEFAULT 1,
  `precioarriendo` int(10) NULL DEFAULT 0,
  `precioventa` int(10) NULL DEFAULT 0,
  PRIMARY KEY (`idmaquinacotizacion`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 260 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for facturaitems
-- ----------------------------
DROP TABLE IF EXISTS `facturaitems`;
CREATE TABLE `facturaitems`  (
  `IDfacturaitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDfactura` int(11) NULL DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cantidad` int(11) NULL DEFAULT NULL,
  `precio` int(11) NULL DEFAULT NULL,
  `IDinventario` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `IDdepartamentoCliente` int(11) NULL DEFAULT 0,
  `IDcentroCosto` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`IDfacturaitem`) USING BTREE,
  INDEX `idxIDFACTURA`(`IDfactura`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3179 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for facturas
-- ----------------------------
DROP TABLE IF EXISTS `facturas`;
CREATE TABLE `facturas`  (
  `idFactura` int(11) NOT NULL DEFAULT 0,
  `fechaFactura` date NULL DEFAULT NULL,
  `rutCliente` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `formaPago` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Forma de Pago',
  `referencia` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Referencia',
  `fechaVencimiento` date NULL DEFAULT NULL,
  `otro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `descuento` decimal(12, 2) NULL DEFAULT 0.00,
  PRIMARY KEY (`idFactura`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for fallas
-- ----------------------------
DROP TABLE IF EXISTS `fallas`;
CREATE TABLE `fallas`  (
  `IDfalla` int(11) NOT NULL AUTO_INCREMENT,
  `nombrefalla` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`IDfalla`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 14 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for inventario
-- ----------------------------
DROP TABLE IF EXISTS `inventario`;
CREATE TABLE `inventario`  (
  `ID` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `tipo` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `categoria` int(20) NULL DEFAULT NULL,
  `marca` int(11) NULL DEFAULT NULL,
  `modelo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contteorico` int(10) NULL DEFAULT NULL,
  `contreal` int(10) NULL DEFAULT NULL,
  `stockminimo` int(10) NULL DEFAULT NULL,
  `stockcritico` int(10) NULL DEFAULT NULL,
  `codinterno` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `numparte` varchar(400) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `precioventa` int(10) UNSIGNED NULL DEFAULT NULL,
  `preciocompra` int(10) NULL DEFAULT NULL,
  `existe` int(1) UNSIGNED NULL DEFAULT NULL COMMENT '1: esta en inventario, 0:aun no',
  `maquinas` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `activo` int(1) NULL DEFAULT 1 COMMENT 'Activo indica si el insumo-repuesto esta activo o dado de baja',
  `cantidadacomprar` int(10) NULL DEFAULT 0 COMMENT 'Cantidad de Productos a Comprar',
  `rendimiento` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'DEFINIR RENDIMIENTO 5%',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for llamados
-- ----------------------------
DROP TABLE IF EXISTS `llamados`;
CREATE TABLE `llamados`  (
  `idllamado` int(11) NOT NULL AUTO_INCREMENT,
  `report` int(11) NULL DEFAULT NULL,
  `rut` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `serieinterna` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `correlativo` int(11) NULL DEFAULT NULL,
  `tipo` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `otrotipo` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `idfalla` int(11) NOT NULL,
  `otrafalla` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `coderror` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `prioridad` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pendiente` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `fecha` datetime(0) NULL DEFAULT NULL,
  `razon` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tecnicoasignado` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombrecontacto` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Contacto',
  `telefonocontacto` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Sin Telefono',
  `eliminado` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'NO' COMMENT 'indica si el registro de llamado fue eliminado por el sistema',
  PRIMARY KEY (`idllamado`) USING BTREE,
  INDEX `idxReport`(`report`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6670 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for maquinas
-- ----------------------------
DROP TABLE IF EXISTS `maquinas`;
CREATE TABLE `maquinas`  (
  `serieinterna` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `seriemaquina` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tipomaquina` int(11) NULL DEFAULT NULL COMMENT '(FK) Enlace a tipomaquina',
  `marca` int(11) NULL DEFAULT NULL,
  `modelo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fechacompra` date NULL DEFAULT NULL,
  `formato` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `conectividad` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `existe` int(1) NULL DEFAULT NULL,
  `idfactura` int(11) NULL DEFAULT NULL,
  `cargofijo` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`serieinterna`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for maquinasinventario
-- ----------------------------
DROP TABLE IF EXISTS `maquinasinventario`;
CREATE TABLE `maquinasinventario`  (
  `serieintmaquina` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`serieintmaquina`, `IDproducto`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for marcasmaquina
-- ----------------------------
DROP TABLE IF EXISTS `marcasmaquina`;
CREATE TABLE `marcasmaquina`  (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `nombremarca` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 169 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for movimientosmaquina
-- ----------------------------
DROP TABLE IF EXISTS `movimientosmaquina`;
CREATE TABLE `movimientosmaquina`  (
  `idmovimiento` int(2) NOT NULL DEFAULT 0,
  `nombre` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idmovimiento`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oc
-- ----------------------------
DROP TABLE IF EXISTS `oc`;
CREATE TABLE `oc`  (
  `IDoc` int(11) NOT NULL AUTO_INCREMENT,
  `rutp` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `total` int(10) NULL DEFAULT NULL,
  `estado` int(1) NULL DEFAULT NULL COMMENT 'Estado: 2: Pendiente total (producto + factura) / 1: Pendiente factura / 0: Recibida sin problemas',
  `numfactura` int(11) NULL DEFAULT NULL,
  `condicionpago` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'SIN DEFINIR CONDICION DE PAGO',
  `despacho` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'Despachar por Starken o Pullman Bus a domicilio:',
  PRIMARY KEY (`IDoc`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 14277 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ocitems
-- ----------------------------
DROP TABLE IF EXISTS `ocitems`;
CREATE TABLE `ocitems`  (
  `IDocitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDoc` int(11) NOT NULL DEFAULT 0,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `cantidad` int(10) NULL DEFAULT NULL,
  `precio` int(10) NULL DEFAULT NULL,
  `tipo` int(1) NULL DEFAULT NULL,
  `descripcion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY (`IDocitem`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 10159 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ocpagos
-- ----------------------------
DROP TABLE IF EXISTS `ocpagos`;
CREATE TABLE `ocpagos`  (
  `idPago` int(11) NOT NULL AUTO_INCREMENT,
  `IDoc` int(11) NULL DEFAULT NULL,
  `tipopago` int(2) NULL DEFAULT NULL,
  `numcheque30` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `numcheque60` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `numcheque90` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `numcheque120` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `montocheque30` double(20, 0) NULL DEFAULT NULL,
  `montocheque60` double(20, 0) NULL DEFAULT NULL,
  `montocheque90` double(20, 0) NULL DEFAULT NULL,
  `montocheque120` double(20, 0) NULL DEFAULT NULL,
  `numtransferencia` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `montotransferencia` double(20, 0) NULL DEFAULT NULL,
  `fechacredito` date NULL DEFAULT NULL,
  `fechacheque30` date NULL DEFAULT NULL,
  `fechacheque60` date NULL DEFAULT NULL,
  `fechacheque90` date NULL DEFAULT NULL,
  `fechacheque120` date NULL DEFAULT NULL,
  `fechatransferencia` date NULL DEFAULT NULL,
  PRIMARY KEY (`idPago`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3908 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ot
-- ----------------------------
DROP TABLE IF EXISTS `ot`;
CREATE TABLE `ot`  (
  `IDot` int(11) NOT NULL DEFAULT 0,
  `rutcliente` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `idtalonario` int(11) NULL DEFAULT NULL,
  `idfactura` int(11) NULL DEFAULT NULL,
  `nombreresp` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `numboleta` int(6) NULL DEFAULT NULL,
  `idguia` int(11) NULL DEFAULT NULL,
  `total` int(11) NULL DEFAULT NULL,
  `tipopago` int(11) NULL DEFAULT 0 COMMENT '0 sin tipo. 1 efectivo. 2 otros medios',
  `ajuste` int(11) NULL DEFAULT 0,
  `totalapagar` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`IDot`, `rutcliente`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for otservicios
-- ----------------------------
DROP TABLE IF EXISTS `otservicios`;
CREATE TABLE `otservicios`  (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `IDot` int(11) NOT NULL DEFAULT 0,
  `rutcliente` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `IDservicio` int(11) NOT NULL DEFAULT 0,
  `cantoriginales` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `copiasoriginales` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `unidades` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `precio` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 39010 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ottalonarios
-- ----------------------------
DROP TABLE IF EXISTS `ottalonarios`;
CREATE TABLE `ottalonarios`  (
  `IDtalonario` int(11) NOT NULL AUTO_INCREMENT,
  `rutcliente` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `estado` int(1) NULL DEFAULT NULL COMMENT '1:Actual, 2:Cola, 3:Usado',
  `numactual` int(11) NULL DEFAULT NULL,
  `numinicial` int(11) NULL DEFAULT NULL,
  `numfinal` int(11) NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  PRIMARY KEY (`IDtalonario`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 127 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for proveedores
-- ----------------------------
DROP TABLE IF EXISTS `proveedores`;
CREATE TABLE `proveedores`  (
  `rut` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `razonsocial` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombre` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `direccion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ciudad` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `giro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`rut`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for proveedoritems
-- ----------------------------
DROP TABLE IF EXISTS `proveedoritems`;
CREATE TABLE `proveedoritems`  (
  `rutp` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `IDitem` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `precio` int(10) NULL DEFAULT NULL,
  `codigoprov` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`rutp`, `IDitem`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for rebajainsumo
-- ----------------------------
DROP TABLE IF EXISTS `rebajainsumo`;
CREATE TABLE `rebajainsumo`  (
  `IDrebajainsumo` int(11) NOT NULL,
  `rutResponsable` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `idCentroCosto` int(11) NULL DEFAULT NULL,
  `detalle` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`IDrebajainsumo`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for rebajainsumoitems
-- ----------------------------
DROP TABLE IF EXISTS `rebajainsumoitems`;
CREATE TABLE `rebajainsumoitems`  (
  `IDrebajainsumoitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDrebajainsumo` int(11) NULL DEFAULT NULL,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cantidad` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`IDrebajainsumoitem`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 46 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reportanulados
-- ----------------------------
DROP TABLE IF EXISTS `reportanulados`;
CREATE TABLE `reportanulados`  (
  `IDtalonario` int(11) NOT NULL AUTO_INCREMENT,
  `numanulado` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `detalle` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`IDtalonario`, `numanulado`, `fecha`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 676 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reportinventario
-- ----------------------------
DROP TABLE IF EXISTS `reportinventario`;
CREATE TABLE `reportinventario`  (
  `idreport` int(11) UNSIGNED NOT NULL,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `cantidad` int(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`idreport`, `IDproducto`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reports
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports`  (
  `idreport` int(11) NOT NULL,
  `rut` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `serieinterna` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `correlativo` int(10) UNSIGNED NULL DEFAULT NULL,
  `tecnico` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `contador` int(11) NULL DEFAULT NULL,
  `fecha` date NOT NULL,
  `horadespacho` time(0) NOT NULL,
  `horallegada` time(0) NOT NULL,
  `horasalida` time(0) NOT NULL,
  `movimiento` int(1) NULL DEFAULT NULL,
  `detalle` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `estadoretiro` int(1) NULL DEFAULT NULL,
  `observacionretiro` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `observacionmaqext` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `idTipoServicioMaquina` int(11) NULL DEFAULT 1 COMMENT 'Cambio Jose Quinteros  17-Feb-2016',
  `contadorColor` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`idreport`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for reporttalonarios
-- ----------------------------
DROP TABLE IF EXISTS `reporttalonarios`;
CREATE TABLE `reporttalonarios`  (
  `IDtalonario` int(11) NOT NULL AUTO_INCREMENT,
  `ruttecnico` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `estado` int(1) UNSIGNED NULL DEFAULT NULL COMMENT '1:Actual, 2:Cola, 3:Usado; 4:Anulado',
  `numactual` int(11) NULL DEFAULT NULL,
  `numinicial` int(11) NULL DEFAULT NULL,
  `numfinal` int(11) NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  PRIMARY KEY (`IDtalonario`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 678 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for salidainterna
-- ----------------------------
DROP TABLE IF EXISTS `salidainterna`;
CREATE TABLE `salidainterna`  (
  `IDsalidainterna` int(11) NOT NULL,
  `rutResponsable` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fecha` date NULL DEFAULT NULL,
  `idCentroCosto` int(11) NULL DEFAULT NULL,
  `detalle` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`IDsalidainterna`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for salidainternaitems
-- ----------------------------
DROP TABLE IF EXISTS `salidainternaitems`;
CREATE TABLE `salidainternaitems`  (
  `IDsalidainternaitem` int(11) NOT NULL AUTO_INCREMENT,
  `IDsalidainterna` int(11) NULL DEFAULT NULL,
  `IDproducto` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cantidad` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`IDsalidainternaitem`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 783 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for servicioexterno
-- ----------------------------
DROP TABLE IF EXISTS `servicioexterno`;
CREATE TABLE `servicioexterno`  (
  `idServicioExterno` int(11) NOT NULL AUTO_INCREMENT,
  `rutcliente` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `serieintmaquina` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `nombrecontacto` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `telefonocontacto` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `estado` int(1) NULL DEFAULT NULL,
  `fechaingreso` date NULL DEFAULT '0000-00-00',
  `tipocliente` int(10) NULL DEFAULT NULL,
  `tipomaquina` int(10) NULL DEFAULT NULL,
  `accesorios` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `falla` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idServicioExterno`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 20 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'Servicio Externo de Maquinas' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for servicios
-- ----------------------------
DROP TABLE IF EXISTS `servicios`;
CREATE TABLE `servicios`  (
  `IDservicio` int(11) NOT NULL AUTO_INCREMENT,
  `servicio` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `precio` float(11, 1) NULL DEFAULT NULL,
  `tipocambio` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `IDCliente` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`IDservicio`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 14189 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipocapturas
-- ----------------------------
DROP TABLE IF EXISTS `tipocapturas`;
CREATE TABLE `tipocapturas`  (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `nombretipo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipocliente
-- ----------------------------
DROP TABLE IF EXISTS `tipocliente`;
CREATE TABLE `tipocliente`  (
  `idTipoCliente` int(11) NOT NULL,
  `descripcion` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idTipoCliente`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipocotizacion
-- ----------------------------
DROP TABLE IF EXISTS `tipocotizacion`;
CREATE TABLE `tipocotizacion`  (
  `idTipoCotizacion` int(2) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idTipoCotizacion`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tiposerviciomaquina
-- ----------------------------
DROP TABLE IF EXISTS `tiposerviciomaquina`;
CREATE TABLE `tiposerviciomaquina`  (
  `idTipoServicio` int(11) NOT NULL AUTO_INCREMENT,
  `nombreTipoServicio` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idTipoServicio`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tiposmaquina
-- ----------------------------
DROP TABLE IF EXISTS `tiposmaquina`;
CREATE TABLE `tiposmaquina`  (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 15 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipospago
-- ----------------------------
DROP TABLE IF EXISTS `tipospago`;
CREATE TABLE `tipospago`  (
  `idTipoPago` int(2) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idTipoPago`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for tipospagoot
-- ----------------------------
DROP TABLE IF EXISTS `tipospagoot`;
CREATE TABLE `tipospagoot`  (
  `idTipoPagoOT` int(2) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`idTipoPagoOT`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for usuarios
-- ----------------------------
DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE `usuarios`  (
  `rut` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dv` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nombre` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `apellidos` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `fono` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `celular` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `direccion` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `pass` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `area` int(10) UNSIGNED NULL DEFAULT NULL,
  `estado` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`rut`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- View structure for t_llamadoshistoricosmaquinas
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadoshistoricosmaquinas`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `t_llamadoshistoricosmaquinas` AS select `maquinas`.`serieinterna` AS `serieinterna`,`maquinas`.`modelo` AS `modelo`,`marcasmaquina`.`nombremarca` AS `nombremarca`,count(0) AS `Cantidad` from ((`llamados` join `maquinas` on(`maquinas`.`serieinterna` = `llamados`.`serieinterna`)) join `marcasmaquina` on(`marcasmaquina`.`ID` = `maquinas`.`marca`)) group by `maquinas`.`modelo`,`marcasmaquina`.`nombremarca` order by count(0) desc;

-- ----------------------------
-- View structure for t_llamadoshistoricosporcliente
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadoshistoricosporcliente`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `t_llamadoshistoricosporcliente` AS select `clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro`,count(0) AS `total` from (`clientes` join `llamados`) where `clientes`.`rut` = `llamados`.`rut` group by `clientes`.`rut`;

-- ----------------------------
-- View structure for t_llamadosportecnicomaquinacliente
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadosportecnicomaquinacliente`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `t_llamadosportecnicomaquinacliente` AS select concat(`usuarios`.`nombre`,_utf8' ',`usuarios`.`apellidos`) AS `NombreTecnico`,`usuarios`.`rut` AS `RUTTecnico`,count(`llamados`.`idllamado`) AS `Cantidad`,`llamados`.`rut` AS `RutCliente`,`clientes`.`razonsocial` AS `ClienteRazonSocial`,`maquinas`.`modelo` AS `ModeloMaquina`,`llamados`.`serieinterna` AS `SerieInternaMaquina`,`marcasmaquina`.`nombremarca` AS `MarcaMaquina`,`tiposmaquina`.`tipo` AS `TipoMaquina` from ((((((`llamados` join `reports` on(`reports`.`idreport` = `llamados`.`report`)) join `clientes` on(`clientes`.`rut` = `llamados`.`rut`)) join `usuarios` on(`usuarios`.`rut` = `reports`.`tecnico`)) join `maquinas` on(`maquinas`.`serieinterna` = `llamados`.`serieinterna`)) join `marcasmaquina` on(`marcasmaquina`.`ID` = `maquinas`.`marca`)) join `tiposmaquina` on(`tiposmaquina`.`ID` = `maquinas`.`tipomaquina`)) group by `llamados`.`rut`,`usuarios`.`rut`,`llamados`.`serieinterna` order by `usuarios`.`apellidos`,`clientes`.`razonsocial`,`maquinas`.`modelo`;

-- ----------------------------
-- View structure for t_repuestosusadospormaquina
-- ----------------------------
DROP VIEW IF EXISTS `t_repuestosusadospormaquina`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `t_repuestosusadospormaquina` AS select count(`reports`.`serieinterna`) AS `Cantidad`,`inventario`.`codinterno` AS `RepuestoCodigoInterno`,`inventario`.`ID` AS `RepuestoCodigo`,`categorias`.`nombrecategoria` AS `RepuestoCategoria`,`inventario`.`descripcion` AS `descripcion`,`marcasmaquina`.`nombremarca` AS `MaquinaMarca`,`tiposmaquina`.`tipo` AS `MaquinaTipo`,`maquinas`.`modelo` AS `MaquinaModelo`,`maquinas`.`serieinterna` AS `MaquinaSerieInterna`,`reports`.`fecha` AS `Fecha`,`inventario`.`tipo` AS `TipoInventario` from ((((((`reports` join `reportinventario` on(`reportinventario`.`idreport` = `reports`.`idreport`)) join `inventario` on(`inventario`.`ID` = `reportinventario`.`IDproducto`)) join `maquinas` on(`maquinas`.`serieinterna` = `reports`.`serieinterna`)) join `marcasmaquina` on(`marcasmaquina`.`ID` = `maquinas`.`marca`)) join `categorias` on(`categorias`.`IDcategoria` = `inventario`.`categoria`)) join `tiposmaquina` on(`tiposmaquina`.`ID` = `maquinas`.`tipomaquina`)) group by `inventario`.`codinterno`,`inventario`.`ID`,`categorias`.`nombrecategoria`,`inventario`.`descripcion`,`marcasmaquina`.`nombremarca`,`tiposmaquina`.`tipo`,`maquinas`.`modelo`,`maquinas`.`serieinterna`,`reports`.`fecha`,`inventario`.`tipo`;

-- ----------------------------
-- View structure for v_listado_facturas
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_listado_facturas` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`formaPago` AS `formaPago`,(select sum(`facturaitems`.`cantidad` * `facturaitems`.`precio`) AS `sum(cantidad * precio)` from `facturaitems` where `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `NETO`,(select sum(round(`facturaitems`.`cantidad` * `facturaitems`.`precio` * 0.19,0)) AS `sum(round((cantidad * precio)*0.19,0))` from `facturaitems` where `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `IVA`,(select sum(round(`facturaitems`.`cantidad` * `facturaitems`.`precio` * 1.19,0)) AS `sum(round((cantidad * precio)*1.19,0))` from `facturaitems` where `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `TOTAL`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro`,(select distinct `centrocosto`.`nombreCentroCosto` AS `nombreCentroCosto` from (`facturaitems` join `centrocosto`) where `facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto` and `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `CENTROCOSTO`,(select distinct `centrocosto`.`idCentroCosto` AS `IDcentroCosto` from (`facturaitems` join `centrocosto`) where `facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto` and `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `IDCENTROCOSTO` from (`facturas` left join `clientes` on(`clientes`.`rut` = `facturas`.`rutCliente`));

-- ----------------------------
-- View structure for v_listado_facturas_v2
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas_v2`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_listado_facturas_v2` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`descuento` AS `descuento`,`facturas`.`formaPago` AS `formaPago`,(select sum(`facturaitems`.`cantidad` * `facturaitems`.`precio`) AS `sum(cantidad * precio)` from `facturaitems` where `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `NETO`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro` from (`facturas` left join `clientes` on(`clientes`.`rut` = `facturas`.`rutCliente`));

-- ----------------------------
-- View structure for v_listado_facturas_v3
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas_v3`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_listado_facturas_v3` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`descuento` AS `descuento`,`facturas`.`formaPago` AS `formaPago`,(select sum(`facturaitems`.`cantidad` * `facturaitems`.`precio`) AS `sum(cantidad * precio)` from `facturaitems` where `facturaitems`.`IDfactura` = `facturas`.`idFactura`) AS `NETO`,(select group_concat(distinct `centrocosto`.`codigoCentroCosto` separator ',') AS `GROUP_CONCAT(distinct centrocosto.codigoCentroCosto)` from (`facturaitems` left join `centrocosto` on(`facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto`)) where `facturaitems`.`IDfactura` = `facturas`.`idFactura` group by `facturaitems`.`IDfactura`) AS `CENTROCOSTO`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro` from (`facturas` left join `clientes` on(`clientes`.`rut` = `facturas`.`rutCliente`));

-- ----------------------------
-- View structure for v_reporte_insumos_centro_costo
-- ----------------------------
DROP VIEW IF EXISTS `v_reporte_insumos_centro_costo`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_reporte_insumos_centro_costo` AS select `controlsalida`.`IDcontrol` AS `IDCONTROL`,`controlsalida`.`rut` AS `RUT`,`controlsalida`.`fecha` AS `FECHA`,`controlsalida`.`recinto` AS `RECINTO`,`controlinventario`.`IDproducto` AS `IDPRODUCTO`,`controlinventario`.`cantidad` AS `CANTIDAD`,`centrocosto`.`nombreCentroCosto` AS `NOMBRECENTROCOSTO`,`clientes`.`razonsocial` AS `RAZONSOCIAL`,`clientes`.`cliente` AS `CLIENTE`,`inventario`.`modelo` AS `MODELO`,`inventario`.`tipo` AS `TIPO`,`inventario`.`descripcion` AS `DESCRIPCION`,`inventario`.`precioventa` AS `PRECIOVENTA`,`inventario`.`preciocompra` AS `PRECIOCOMPRA`,`inventario`.`codinterno` AS `CODINTERNO`,`marcasmaquina`.`nombremarca` AS `NOMBREMARCA`,`categorias`.`nombrecategoria` AS `NOMBRECATEGORIA`,`centrocosto`.`idCentroCosto` AS `idCentroCosto` from ((((((`controlsalida` join `controlinventario` on(`controlsalida`.`IDcontrol` = `controlinventario`.`IDcontrol`)) join `centrocosto` on(`controlsalida`.`idCentroCosto` = `centrocosto`.`idCentroCosto`)) join `clientes` on(`controlsalida`.`rut` = `clientes`.`rut`)) join `inventario` on(`controlinventario`.`IDproducto` = `inventario`.`ID`)) join `marcasmaquina` on(`inventario`.`marca` = `marcasmaquina`.`ID`)) join `categorias` on(`inventario`.`categoria` = `categorias`.`IDcategoria`)) union select `controldevolucioninventario`.`idControl` AS `idControl`,`controlsalida`.`rut` AS `rut`,`controldevolucioninventario`.`fechaDevolucion` AS `FECHA`,`controlsalida`.`recinto` AS `recinto`,`controldevolucioninventario`.`idProducto` AS `idProducto`,`controldevolucioninventario`.`cantidad` * -1 AS `CANTIDAD`,`centrocosto`.`nombreCentroCosto` AS `nombreCentroCosto`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`inventario`.`modelo` AS `modelo`,`inventario`.`tipo` AS `tipo`,`inventario`.`descripcion` AS `descripcion`,`inventario`.`precioventa` AS `precioventa`,`inventario`.`preciocompra` AS `preciocompra`,`inventario`.`codinterno` AS `codinterno`,`marcasmaquina`.`nombremarca` AS `nombremarca`,`categorias`.`nombrecategoria` AS `nombrecategoria`,`centrocosto`.`idCentroCosto` AS `idCentroCosto` from ((((((`controldevolucioninventario` join `inventario` on(`controldevolucioninventario`.`idProducto` = `inventario`.`ID`)) join `marcasmaquina` on(`inventario`.`marca` = `marcasmaquina`.`ID`)) join `controlsalida` on(`controldevolucioninventario`.`idControl` = `controlsalida`.`IDcontrol`)) join `centrocosto` on(`controlsalida`.`idCentroCosto` = `centrocosto`.`idCentroCosto`)) join `clientes` on(`controlsalida`.`rut` = `clientes`.`rut`)) join `categorias` on(`inventario`.`categoria` = `categorias`.`IDcategoria`)) order by `IDCONTROL`,`CODINTERNO`,`CANTIDAD` desc;

SET FOREIGN_KEY_CHECKS = 1;