/*
MySQL Data Transfer
Source Host: localhost
Source Database: csj
Target Host: localhost
Target Database: csj
Date: 3/14/2022 5:33:27 PM
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for areas
-- ----------------------------
DROP TABLE IF EXISTS `areas`;
CREATE TABLE `areas` (
  `idarea` int(10) unsigned NOT NULL auto_increment,
  `nombrearea` varchar(255) default NULL,
  PRIMARY KEY  (`idarea`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for boletaitems
-- ----------------------------
DROP TABLE IF EXISTS `boletaitems`;
CREATE TABLE `boletaitems` (
  `IDboletaitem` int(11) NOT NULL auto_increment,
  `IDboleta` int(11) default NULL,
  `descripcion` varchar(255) default NULL,
  `cantidad` int(11) default NULL,
  `precio` int(11) default NULL,
  `IDinventario` varchar(10) default NULL,
  `IDdepartamentoCliente` int(11) default '0',
  `IDcentroCosto` int(11) default '0',
  PRIMARY KEY  (`IDboletaitem`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for boletas
-- ----------------------------
DROP TABLE IF EXISTS `boletas`;
CREATE TABLE `boletas` (
  `idBoleta` int(11) NOT NULL default '0',
  `fechaBoleta` date default NULL,
  `rutCliente` varchar(13) default NULL,
  `formaPago` varchar(30) default 'Sin Forma de Pago',
  `referencia` varchar(255) default 'Sin Referencia',
  `idCentroCosto` int(11) default NULL,
  PRIMARY KEY  (`idBoleta`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for categorias
-- ----------------------------
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias` (
  `IDcategoria` int(20) NOT NULL auto_increment,
  `nombrecategoria` varchar(255) default NULL,
  PRIMARY KEY  (`IDcategoria`)
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cd
-- ----------------------------
DROP TABLE IF EXISTS `cd`;
CREATE TABLE `cd` (
  `IDcd` int(11) NOT NULL auto_increment,
  `rutp` varchar(13) default NULL,
  `razonsocial` varchar(20) default NULL,
  `nombre` varchar(20) default NULL,
  `fecha` date default NULL,
  `total` int(10) default NULL,
  PRIMARY KEY  (`IDcd`)
) ENGINE=MyISAM AUTO_INCREMENT=445 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cditems
-- ----------------------------
DROP TABLE IF EXISTS `cditems`;
CREATE TABLE `cditems` (
  `IDcdprod` int(11) NOT NULL auto_increment,
  `IDcd` int(11) NOT NULL default '0',
  `IDproducto` varchar(10) NOT NULL default '0',
  `cantidad` int(10) default NULL,
  `precio` int(10) default NULL,
  `tipo` int(11) default NULL COMMENT '1: inventario, 0:maquinas u otro servicio',
  `descripcion` varchar(255) default NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY  (`IDcdprod`)
) ENGINE=MyISAM AUTO_INCREMENT=1180 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for centrocosto
-- ----------------------------
DROP TABLE IF EXISTS `centrocosto`;
CREATE TABLE `centrocosto` (
  `idCentroCosto` int(11) NOT NULL auto_increment,
  `nombreCentroCosto` varchar(30) default NULL,
  `codigoCentroCosto` varchar(4) default 'CC',
  PRIMARY KEY  (`idCentroCosto`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for clientedepartamentos
-- ----------------------------
DROP TABLE IF EXISTS `clientedepartamentos`;
CREATE TABLE `clientedepartamentos` (
  `idDepartamentoCliente` int(10) NOT NULL auto_increment,
  `nombreDepartamentoCliente` varchar(255) NOT NULL default 'NOMBRE DEPARTAMENTO',
  `rutCliente` varchar(9) NOT NULL,
  `estado` int(10) NOT NULL default '1',
  PRIMARY KEY  (`idDepartamentoCliente`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for clientemaquina
-- ----------------------------
DROP TABLE IF EXISTS `clientemaquina`;
CREATE TABLE `clientemaquina` (
  `rutcliente` varchar(9) NOT NULL,
  `serieintmaquina` varchar(10) NOT NULL default '',
  `correlativo` int(11) NOT NULL,
  `estado` int(1) default NULL,
  `fecha` date default '0000-00-00',
  `ubicacion` varchar(255) default NULL,
  `facturada` int(11) default NULL,
  PRIMARY KEY  (`rutcliente`,`serieintmaquina`,`correlativo`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Historial de máquinas clientes';

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `rut` varchar(9) NOT NULL default '',
  `dv` varchar(1) default '',
  `razonsocial` varchar(255) default NULL,
  `cliente` varchar(255) default NULL,
  `nombre` varchar(255) default NULL,
  `telefono` varchar(255) default NULL,
  `direccion` varchar(255) default NULL,
  `ciudad` varchar(255) default NULL,
  `giro` varchar(255) default NULL,
  PRIMARY KEY  (`rut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for configuraciones
-- ----------------------------
DROP TABLE IF EXISTS `configuraciones`;
CREATE TABLE `configuraciones` (
  `idconfiguracion` int(10) unsigned NOT NULL auto_increment,
  `nombre` varchar(255) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `valor` varchar(100) NOT NULL,
  `tipo` varchar(10) default NULL,
  `deshabilitado` varchar(255) NOT NULL,
  PRIMARY KEY  (`idconfiguracion`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for contadores
-- ----------------------------
DROP TABLE IF EXISTS `contadores`;
CREATE TABLE `contadores` (
  `rutcliente` varchar(13) NOT NULL default '',
  `serieintmaquina` varchar(10) NOT NULL default '',
  `correlativo` int(11) NOT NULL default '0',
  `instalacion` int(11) NOT NULL default '0',
  `fechafacturacion` date NOT NULL default '0000-00-00',
  `contador` int(11) default NULL,
  `copiaerrores` int(11) default NULL,
  `diferencia` int(11) default NULL,
  `copiasfacturadas` int(11) default NULL,
  `fechacaptura` date NOT NULL default '0000-00-00',
  `tipocaptura` int(11) default NULL,
  `firma` varchar(255) default NULL,
  `idreport` int(11) default NULL,
  `idfactura` int(11) default NULL,
  `idTipoServicioMaquina` int(11) NOT NULL default '1' COMMENT 'Cambio 27-Enero-2014 - Jose Quinteros',
  PRIMARY KEY  (`rutcliente`,`serieintmaquina`,`correlativo`,`instalacion`,`fechafacturacion`,`fechacaptura`,`idTipoServicioMaquina`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for controldevolucioninventario
-- ----------------------------
DROP TABLE IF EXISTS `controldevolucioninventario`;
CREATE TABLE `controldevolucioninventario` (
  `idDevolucion` int(11) NOT NULL auto_increment,
  `idControl` int(11) default NULL,
  `idProducto` varchar(10) default NULL,
  `cantidad` int(10) default NULL,
  `fechaDevolucion` date default NULL,
  `fechaDevolucionReal` date default NULL,
  PRIMARY KEY  (`idDevolucion`)
) ENGINE=MyISAM AUTO_INCREMENT=3446 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for controlinventario
-- ----------------------------
DROP TABLE IF EXISTS `controlinventario`;
CREATE TABLE `controlinventario` (
  `IDcontrol` int(11) NOT NULL default '0',
  `IDproducto` varchar(10) NOT NULL default '',
  `cantidad` int(10) default NULL,
  PRIMARY KEY  (`IDcontrol`,`IDproducto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for controlsalida
-- ----------------------------
DROP TABLE IF EXISTS `controlsalida`;
CREATE TABLE `controlsalida` (
  `IDcontrol` int(11) NOT NULL auto_increment,
  `rut` varchar(13) default NULL,
  `nombrecliente` varchar(20) default NULL,
  `rutcliente` varchar(12) default NULL,
  `recinto` varchar(30) default NULL,
  `fecha` date default NULL,
  `hora` time default NULL,
  `idCentroCosto` int(11) default '8',
  PRIMARY KEY  (`IDcontrol`)
) ENGINE=MyISAM AUTO_INCREMENT=19191 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for copiascliente
-- ----------------------------
DROP TABLE IF EXISTS `copiascliente`;
CREATE TABLE `copiascliente` (
  `rutcliente` varchar(255) NOT NULL default '',
  `costocopia` int(11) default NULL,
  `minimocopia` int(11) default NULL,
  `costofijo` int(11) default NULL,
  `idTipoServicioMaquina` int(11) NOT NULL default '0',
  `serieintmaquina` varchar(10) NOT NULL default '1',
  PRIMARY KEY  (`rutcliente`,`idTipoServicioMaquina`,`serieintmaquina`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cotizacion
-- ----------------------------
DROP TABLE IF EXISTS `cotizacion`;
CREATE TABLE `cotizacion` (
  `IDcotizacion` int(11) NOT NULL auto_increment,
  `rutcliente` varchar(13) default NULL,
  `fecha` date default NULL,
  `total` int(10) default NULL,
  `estado` int(1) default NULL COMMENT 'Estado: 2: Pendiente total (producto + factura) / 1: Pendiente factura / 0: Recibida sin problemas',
  `tipocotizacion` int(1) default '1',
  PRIMARY KEY  (`IDcotizacion`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cotizacionitems
-- ----------------------------
DROP TABLE IF EXISTS `cotizacionitems`;
CREATE TABLE `cotizacionitems` (
  `IDcotizacionitem` int(11) NOT NULL auto_increment,
  `IDcotizacion` int(11) NOT NULL default '0',
  `IDproducto` varchar(10) NOT NULL default '0',
  `cantidad` int(10) default NULL,
  `precio` int(10) default NULL,
  `tipo` int(1) default NULL,
  `descripcion` varchar(255) default NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY  (`IDcotizacionitem`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for cotizacionmaquinas
-- ----------------------------
DROP TABLE IF EXISTS `cotizacionmaquinas`;
CREATE TABLE `cotizacionmaquinas` (
  `idmaquinacotizacion` int(11) NOT NULL auto_increment,
  `tipomaquina` int(11) default NULL,
  `marca` int(11) default NULL,
  `modelo` varchar(255) default NULL,
  `formato` varchar(255) default NULL,
  `conectividad` varchar(2) default NULL,
  `activo` int(1) default '1',
  `precioarriendo` int(10) default '0',
  `precioventa` int(10) default '0',
  PRIMARY KEY  (`idmaquinacotizacion`)
) ENGINE=MyISAM AUTO_INCREMENT=260 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for facturaitems
-- ----------------------------
DROP TABLE IF EXISTS `facturaitems`;
CREATE TABLE `facturaitems` (
  `IDfacturaitem` int(11) NOT NULL auto_increment,
  `IDfactura` int(11) default NULL,
  `descripcion` varchar(255) default NULL,
  `cantidad` int(11) default NULL,
  `precio` int(11) default NULL,
  `IDinventario` varchar(10) default NULL,
  `IDdepartamentoCliente` int(11) default '0',
  `IDcentroCosto` int(11) default '0',
  PRIMARY KEY  (`IDfacturaitem`),
  KEY `idxIDFACTURA` (`IDfactura`)
) ENGINE=MyISAM AUTO_INCREMENT=3179 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for facturas
-- ----------------------------
DROP TABLE IF EXISTS `facturas`;
CREATE TABLE `facturas` (
  `idFactura` int(11) NOT NULL default '0',
  `fechaFactura` date default NULL,
  `rutCliente` varchar(13) default NULL,
  `formaPago` varchar(30) default 'Sin Forma de Pago',
  `referencia` varchar(255) default 'Sin Referencia',
  `fechaVencimiento` date default NULL,
  `otro` varchar(255) default NULL,
  `descuento` decimal(12,2) default '0.00',
  PRIMARY KEY  (`idFactura`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for fallas
-- ----------------------------
DROP TABLE IF EXISTS `fallas`;
CREATE TABLE `fallas` (
  `IDfalla` int(11) NOT NULL auto_increment,
  `nombrefalla` varchar(40) default NULL,
  PRIMARY KEY  (`IDfalla`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for inventario
-- ----------------------------
DROP TABLE IF EXISTS `inventario`;
CREATE TABLE `inventario` (
  `ID` varchar(10) NOT NULL,
  `tipo` varchar(10) default NULL,
  `categoria` int(20) default NULL,
  `marca` int(11) default NULL,
  `modelo` varchar(255) default NULL,
  `contteorico` int(10) default NULL,
  `contreal` int(10) default NULL,
  `stockminimo` int(10) default NULL,
  `stockcritico` int(10) default NULL,
  `codinterno` varchar(255) default NULL,
  `numparte` varchar(400) default NULL,
  `descripcion` varchar(255) default NULL,
  `precioventa` int(10) unsigned default NULL,
  `preciocompra` int(10) default NULL,
  `existe` int(1) unsigned default NULL COMMENT '1: esta en inventario, 0:aun no',
  `maquinas` varchar(255) default NULL,
  `activo` int(1) default '1' COMMENT 'Activo indica si el insumo-repuesto esta activo o dado de baja',
  `cantidadacomprar` int(10) default '0' COMMENT 'Cantidad de Productos a Comprar',
  `rendimiento` varchar(255) default 'DEFINIR RENDIMIENTO 5%',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for llamados
-- ----------------------------
DROP TABLE IF EXISTS `llamados`;
CREATE TABLE `llamados` (
  `idllamado` int(11) NOT NULL auto_increment,
  `report` int(11) default NULL,
  `rut` varchar(13) NOT NULL,
  `serieinterna` varchar(100) NOT NULL,
  `correlativo` int(11) default NULL,
  `tipo` varchar(10) NOT NULL,
  `otrotipo` varchar(100) default NULL,
  `idfalla` int(11) NOT NULL,
  `otrafalla` varchar(100) default NULL,
  `coderror` varchar(100) default NULL,
  `prioridad` varchar(5) NOT NULL,
  `pendiente` varchar(2) NOT NULL,
  `fecha` datetime default NULL,
  `razon` varchar(200) default NULL,
  `tecnicoasignado` varchar(9) default NULL,
  `nombrecontacto` varchar(200) default 'Sin Contacto',
  `telefonocontacto` varchar(200) default 'Sin Telefono',
  `eliminado` varchar(2) default 'NO' COMMENT 'indica si el registro de llamado fue eliminado por el sistema',
  PRIMARY KEY  (`idllamado`),
  KEY `idxReport` (`report`)
) ENGINE=MyISAM AUTO_INCREMENT=6670 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for maquinas
-- ----------------------------
DROP TABLE IF EXISTS `maquinas`;
CREATE TABLE `maquinas` (
  `serieinterna` varchar(10) NOT NULL default '',
  `seriemaquina` varchar(30) default NULL,
  `tipomaquina` int(11) default NULL COMMENT '(FK) Enlace a tipomaquina',
  `marca` int(11) default NULL,
  `modelo` varchar(255) default NULL,
  `fechacompra` date default NULL,
  `formato` varchar(255) default NULL,
  `conectividad` varchar(2) default NULL,
  `existe` int(1) default NULL,
  `idfactura` int(11) default NULL,
  `cargofijo` int(11) default '0',
  PRIMARY KEY  (`serieinterna`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for maquinasinventario
-- ----------------------------
DROP TABLE IF EXISTS `maquinasinventario`;
CREATE TABLE `maquinasinventario` (
  `serieintmaquina` varchar(10) NOT NULL default '',
  `IDproducto` varchar(10) NOT NULL default '0',
  PRIMARY KEY  (`serieintmaquina`,`IDproducto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for marcasmaquina
-- ----------------------------
DROP TABLE IF EXISTS `marcasmaquina`;
CREATE TABLE `marcasmaquina` (
  `ID` int(11) NOT NULL auto_increment,
  `nombremarca` varchar(255) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=169 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for movimientosmaquina
-- ----------------------------
DROP TABLE IF EXISTS `movimientosmaquina`;
CREATE TABLE `movimientosmaquina` (
  `idmovimiento` int(2) NOT NULL default '0',
  `nombre` varchar(50) default NULL,
  PRIMARY KEY  (`idmovimiento`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for oc
-- ----------------------------
DROP TABLE IF EXISTS `oc`;
CREATE TABLE `oc` (
  `IDoc` int(11) NOT NULL auto_increment,
  `rutp` varchar(13) default NULL,
  `fecha` date default NULL,
  `total` int(10) default NULL,
  `estado` int(1) default NULL COMMENT 'Estado: 2: Pendiente total (producto + factura) / 1: Pendiente factura / 0: Recibida sin problemas',
  `numfactura` int(11) default NULL,
  `condicionpago` varchar(200) default 'SIN DEFINIR CONDICION DE PAGO',
  `despacho` varchar(200) default 'Despachar por Starken o Pullman Bus a domicilio:',
  PRIMARY KEY  (`IDoc`)
) ENGINE=MyISAM AUTO_INCREMENT=14277 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ocitems
-- ----------------------------
DROP TABLE IF EXISTS `ocitems`;
CREATE TABLE `ocitems` (
  `IDocitem` int(11) NOT NULL auto_increment,
  `IDoc` int(11) NOT NULL default '0',
  `IDproducto` varchar(10) NOT NULL default '0',
  `cantidad` int(10) default NULL,
  `precio` int(10) default NULL,
  `tipo` int(1) default NULL,
  `descripcion` varchar(255) default NULL COMMENT 'si es tipo:0 e IDproducto:ESPECIAL tiene descripcion',
  PRIMARY KEY  (`IDocitem`)
) ENGINE=MyISAM AUTO_INCREMENT=10159 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ocpagos
-- ----------------------------
DROP TABLE IF EXISTS `ocpagos`;
CREATE TABLE `ocpagos` (
  `idPago` int(11) NOT NULL auto_increment,
  `IDoc` int(11) default NULL,
  `tipopago` int(2) default NULL,
  `numcheque30` varchar(20) default NULL,
  `numcheque60` varchar(20) default NULL,
  `numcheque90` varchar(20) default NULL,
  `numcheque120` varchar(20) default NULL,
  `montocheque30` double(20,0) default NULL,
  `montocheque60` double(20,0) default NULL,
  `montocheque90` double(20,0) default NULL,
  `montocheque120` double(20,0) default NULL,
  `numtransferencia` varchar(20) default NULL,
  `montotransferencia` double(20,0) default NULL,
  `fechacredito` date default NULL,
  `fechacheque30` date default NULL,
  `fechacheque60` date default NULL,
  `fechacheque90` date default NULL,
  `fechacheque120` date default NULL,
  `fechatransferencia` date default NULL,
  PRIMARY KEY  (`idPago`)
) ENGINE=MyISAM AUTO_INCREMENT=3908 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ot
-- ----------------------------
DROP TABLE IF EXISTS `ot`;
CREATE TABLE `ot` (
  `IDot` int(11) NOT NULL default '0',
  `rutcliente` varchar(13) NOT NULL default '',
  `idtalonario` int(11) default NULL,
  `idfactura` int(11) default NULL,
  `nombreresp` varchar(255) default NULL,
  `fecha` date default NULL,
  `numboleta` int(6) default NULL,
  `idguia` int(11) default NULL,
  `total` int(11) default NULL,
  `tipopago` int(11) default '0' COMMENT '0 sin tipo. 1 efectivo. 2 otros medios',
  `ajuste` int(11) default '0',
  `totalapagar` int(11) default '0',
  PRIMARY KEY  (`IDot`,`rutcliente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for otservicios
-- ----------------------------
DROP TABLE IF EXISTS `otservicios`;
CREATE TABLE `otservicios` (
  `Id` int(11) NOT NULL auto_increment,
  `IDot` int(11) NOT NULL default '0',
  `rutcliente` varchar(12) NOT NULL default '',
  `IDservicio` int(11) NOT NULL default '0',
  `cantoriginales` varchar(11) default NULL,
  `copiasoriginales` varchar(11) default NULL,
  `unidades` varchar(11) default NULL,
  `precio` varchar(11) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=39010 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ottalonarios
-- ----------------------------
DROP TABLE IF EXISTS `ottalonarios`;
CREATE TABLE `ottalonarios` (
  `IDtalonario` int(11) NOT NULL auto_increment,
  `rutcliente` varchar(12) default NULL,
  `estado` int(1) default NULL COMMENT '1:Actual, 2:Cola, 3:Usado',
  `numactual` int(11) default NULL,
  `numinicial` int(11) default NULL,
  `numfinal` int(11) default NULL,
  `fecha` date default NULL,
  PRIMARY KEY  (`IDtalonario`)
) ENGINE=MyISAM AUTO_INCREMENT=127 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for proveedores
-- ----------------------------
DROP TABLE IF EXISTS `proveedores`;
CREATE TABLE `proveedores` (
  `rut` varchar(13) NOT NULL default '',
  `razonsocial` varchar(255) default NULL,
  `nombre` varchar(255) default NULL,
  `telefono` varchar(255) default NULL,
  `direccion` varchar(255) default NULL,
  `ciudad` varchar(255) default NULL,
  `giro` varchar(255) default NULL,
  PRIMARY KEY  (`rut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for proveedoritems
-- ----------------------------
DROP TABLE IF EXISTS `proveedoritems`;
CREATE TABLE `proveedoritems` (
  `rutp` varchar(13) NOT NULL default '',
  `IDitem` varchar(10) NOT NULL default '',
  `precio` int(10) default NULL,
  `codigoprov` varchar(20) default NULL,
  PRIMARY KEY  (`rutp`,`IDitem`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for rebajainsumo
-- ----------------------------
DROP TABLE IF EXISTS `rebajainsumo`;
CREATE TABLE `rebajainsumo` (
  `IDrebajainsumo` int(11) NOT NULL,
  `rutResponsable` varchar(12) default NULL,
  `fecha` date default NULL,
  `idCentroCosto` int(11) default NULL,
  `detalle` varchar(255) default NULL,
  PRIMARY KEY  (`IDrebajainsumo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for rebajainsumoitems
-- ----------------------------
DROP TABLE IF EXISTS `rebajainsumoitems`;
CREATE TABLE `rebajainsumoitems` (
  `IDrebajainsumoitem` int(11) NOT NULL auto_increment,
  `IDrebajainsumo` int(11) default NULL,
  `IDproducto` varchar(10) default NULL,
  `cantidad` int(11) default NULL,
  PRIMARY KEY  (`IDrebajainsumoitem`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for reportanulados
-- ----------------------------
DROP TABLE IF EXISTS `reportanulados`;
CREATE TABLE `reportanulados` (
  `IDtalonario` int(11) NOT NULL auto_increment,
  `numanulado` varchar(50) NOT NULL default '',
  `detalle` varchar(255) default NULL,
  `fecha` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`IDtalonario`,`numanulado`,`fecha`)
) ENGINE=MyISAM AUTO_INCREMENT=676 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for reportinventario
-- ----------------------------
DROP TABLE IF EXISTS `reportinventario`;
CREATE TABLE `reportinventario` (
  `idreport` int(11) unsigned NOT NULL,
  `IDproducto` varchar(10) NOT NULL,
  `cantidad` int(11) unsigned NOT NULL,
  PRIMARY KEY  (`idreport`,`IDproducto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for reports
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `idreport` int(11) NOT NULL,
  `rut` varchar(255) NOT NULL,
  `serieinterna` varchar(255) default NULL,
  `correlativo` int(10) unsigned default NULL,
  `tecnico` varchar(9) NOT NULL,
  `contador` int(11) default NULL,
  `fecha` date NOT NULL,
  `horadespacho` time NOT NULL,
  `horallegada` time NOT NULL,
  `horasalida` time NOT NULL,
  `movimiento` int(1) default NULL,
  `detalle` varchar(255) default NULL,
  `estadoretiro` int(1) default NULL,
  `observacionretiro` varchar(255) default NULL,
  `observacionmaqext` varchar(255) default NULL,
  `idTipoServicioMaquina` int(11) default '1' COMMENT 'Cambio Jose Quinteros  17-Feb-2016',
  `contadorColor` int(11) default '0',
  PRIMARY KEY  (`idreport`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for reporttalonarios
-- ----------------------------
DROP TABLE IF EXISTS `reporttalonarios`;
CREATE TABLE `reporttalonarios` (
  `IDtalonario` int(11) NOT NULL auto_increment,
  `ruttecnico` varchar(9) default NULL,
  `estado` int(1) unsigned default NULL COMMENT '1:Actual, 2:Cola, 3:Usado; 4:Anulado',
  `numactual` int(11) default NULL,
  `numinicial` int(11) default NULL,
  `numfinal` int(11) default NULL,
  `fecha` date default NULL,
  PRIMARY KEY  (`IDtalonario`)
) ENGINE=MyISAM AUTO_INCREMENT=678 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for salidainterna
-- ----------------------------
DROP TABLE IF EXISTS `salidainterna`;
CREATE TABLE `salidainterna` (
  `IDsalidainterna` int(11) NOT NULL,
  `rutResponsable` varchar(255) default NULL,
  `fecha` date default NULL,
  `idCentroCosto` int(11) default NULL,
  `detalle` varchar(255) default NULL,
  PRIMARY KEY  (`IDsalidainterna`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for salidainternaitems
-- ----------------------------
DROP TABLE IF EXISTS `salidainternaitems`;
CREATE TABLE `salidainternaitems` (
  `IDsalidainternaitem` int(11) NOT NULL auto_increment,
  `IDsalidainterna` int(11) default NULL,
  `IDproducto` varchar(10) default NULL,
  `cantidad` int(11) default NULL,
  PRIMARY KEY  (`IDsalidainternaitem`)
) ENGINE=MyISAM AUTO_INCREMENT=783 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for servicioexterno
-- ----------------------------
DROP TABLE IF EXISTS `servicioexterno`;
CREATE TABLE `servicioexterno` (
  `idServicioExterno` int(11) NOT NULL auto_increment,
  `rutcliente` varchar(9) NOT NULL,
  `serieintmaquina` varchar(10) NOT NULL default '',
  `nombrecontacto` varchar(255) default NULL,
  `telefonocontacto` varchar(255) default NULL,
  `estado` int(1) default NULL,
  `fechaingreso` date default '0000-00-00',
  `tipocliente` int(10) default NULL,
  `tipomaquina` int(10) default NULL,
  `accesorios` varchar(255) default NULL,
  `falla` varchar(255) default NULL,
  PRIMARY KEY  (`idServicioExterno`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COMMENT='Servicio Externo de Maquinas';

-- ----------------------------
-- Table structure for servicios
-- ----------------------------
DROP TABLE IF EXISTS `servicios`;
CREATE TABLE `servicios` (
  `IDservicio` int(11) NOT NULL auto_increment,
  `servicio` varchar(255) NOT NULL default '',
  `precio` float(11,1) default NULL,
  `tipocambio` varchar(10) default NULL,
  `IDCliente` varchar(9) default NULL,
  PRIMARY KEY  (`IDservicio`)
) ENGINE=MyISAM AUTO_INCREMENT=14189 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tipocapturas
-- ----------------------------
DROP TABLE IF EXISTS `tipocapturas`;
CREATE TABLE `tipocapturas` (
  `ID` int(11) NOT NULL auto_increment,
  `nombretipo` varchar(255) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tipocliente
-- ----------------------------
DROP TABLE IF EXISTS `tipocliente`;
CREATE TABLE `tipocliente` (
  `idTipoCliente` int(11) NOT NULL,
  `descripcion` varchar(50) default NULL,
  PRIMARY KEY  (`idTipoCliente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tipocotizacion
-- ----------------------------
DROP TABLE IF EXISTS `tipocotizacion`;
CREATE TABLE `tipocotizacion` (
  `idTipoCotizacion` int(2) NOT NULL auto_increment,
  `descripcion` varchar(50) default NULL,
  PRIMARY KEY  (`idTipoCotizacion`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tiposerviciomaquina
-- ----------------------------
DROP TABLE IF EXISTS `tiposerviciomaquina`;
CREATE TABLE `tiposerviciomaquina` (
  `idTipoServicio` int(11) NOT NULL auto_increment,
  `nombreTipoServicio` varchar(30) default NULL,
  PRIMARY KEY  (`idTipoServicio`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tiposmaquina
-- ----------------------------
DROP TABLE IF EXISTS `tiposmaquina`;
CREATE TABLE `tiposmaquina` (
  `ID` int(11) NOT NULL auto_increment,
  `tipo` varchar(255) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tipospago
-- ----------------------------
DROP TABLE IF EXISTS `tipospago`;
CREATE TABLE `tipospago` (
  `idTipoPago` int(2) NOT NULL auto_increment,
  `descripcion` varchar(50) default NULL,
  PRIMARY KEY  (`idTipoPago`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tipospagoot
-- ----------------------------
DROP TABLE IF EXISTS `tipospagoot`;
CREATE TABLE `tipospagoot` (
  `idTipoPagoOT` int(2) NOT NULL auto_increment,
  `descripcion` varchar(50) default NULL,
  PRIMARY KEY  (`idTipoPagoOT`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for usuarios
-- ----------------------------
DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE `usuarios` (
  `rut` varchar(9) NOT NULL,
  `dv` varchar(1) default NULL,
  `nombre` varchar(30) NOT NULL,
  `apellidos` varchar(100) NOT NULL,
  `fono` varchar(20) NOT NULL,
  `celular` varchar(10) default NULL,
  `direccion` varchar(30) default NULL,
  `pass` varchar(50) default NULL,
  `area` int(10) unsigned default NULL,
  `estado` int(11) default NULL,
  PRIMARY KEY  (`rut`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- View structure for t_llamadoshistoricosmaquinas
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadoshistoricosmaquinas`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `t_llamadoshistoricosmaquinas` AS select `maquinas`.`serieinterna` AS `serieinterna`,`maquinas`.`modelo` AS `modelo`,`marcasmaquina`.`nombremarca` AS `nombremarca`,count(0) AS `Cantidad` from ((`llamados` join `maquinas` on((`maquinas`.`serieinterna` = `llamados`.`serieinterna`))) join `marcasmaquina` on((`marcasmaquina`.`ID` = `maquinas`.`marca`))) group by `maquinas`.`modelo`,`marcasmaquina`.`nombremarca` order by count(0) desc;

-- ----------------------------
-- View structure for t_llamadoshistoricosporcliente
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadoshistoricosporcliente`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `t_llamadoshistoricosporcliente` AS select `clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro`,count(0) AS `total` from (`clientes` join `llamados`) where (`clientes`.`rut` = `llamados`.`rut`) group by `clientes`.`rut`;

-- ----------------------------
-- View structure for t_llamadosportecnicomaquinacliente
-- ----------------------------
DROP VIEW IF EXISTS `t_llamadosportecnicomaquinacliente`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `t_llamadosportecnicomaquinacliente` AS select concat(`usuarios`.`nombre`,_utf8' ',`usuarios`.`apellidos`) AS `NombreTecnico`,`usuarios`.`rut` AS `RUTTecnico`,count(`llamados`.`idllamado`) AS `Cantidad`,`llamados`.`rut` AS `RutCliente`,`clientes`.`razonsocial` AS `ClienteRazonSocial`,`maquinas`.`modelo` AS `ModeloMaquina`,`llamados`.`serieinterna` AS `SerieInternaMaquina`,`marcasmaquina`.`nombremarca` AS `MarcaMaquina`,`tiposmaquina`.`tipo` AS `TipoMaquina` from ((((((`llamados` join `reports` on((`reports`.`idreport` = `llamados`.`report`))) join `clientes` on((`clientes`.`rut` = `llamados`.`rut`))) join `usuarios` on((`usuarios`.`rut` = `reports`.`tecnico`))) join `maquinas` on((`maquinas`.`serieinterna` = `llamados`.`serieinterna`))) join `marcasmaquina` on((`marcasmaquina`.`ID` = `maquinas`.`marca`))) join `tiposmaquina` on((`tiposmaquina`.`ID` = `maquinas`.`tipomaquina`))) group by `llamados`.`rut`,`usuarios`.`rut`,`llamados`.`serieinterna` order by `usuarios`.`apellidos`,`clientes`.`razonsocial`,`maquinas`.`modelo`;

-- ----------------------------
-- View structure for t_repuestosusadospormaquina
-- ----------------------------
DROP VIEW IF EXISTS `t_repuestosusadospormaquina`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `t_repuestosusadospormaquina` AS select count(`reports`.`serieinterna`) AS `Cantidad`,`inventario`.`codinterno` AS `RepuestoCodigoInterno`,`inventario`.`ID` AS `RepuestoCodigo`,`categorias`.`nombrecategoria` AS `RepuestoCategoria`,`inventario`.`descripcion` AS `descripcion`,`marcasmaquina`.`nombremarca` AS `MaquinaMarca`,`tiposmaquina`.`tipo` AS `MaquinaTipo`,`maquinas`.`modelo` AS `MaquinaModelo`,`maquinas`.`serieinterna` AS `MaquinaSerieInterna`,`reports`.`fecha` AS `Fecha`,`inventario`.`tipo` AS `TipoInventario` from ((((((`reports` join `reportinventario` on((`reportinventario`.`idreport` = `reports`.`idreport`))) join `inventario` on((`inventario`.`ID` = `reportinventario`.`IDproducto`))) join `maquinas` on((`maquinas`.`serieinterna` = `reports`.`serieinterna`))) join `marcasmaquina` on((`marcasmaquina`.`ID` = `maquinas`.`marca`))) join `categorias` on((`categorias`.`IDcategoria` = `inventario`.`categoria`))) join `tiposmaquina` on((`tiposmaquina`.`ID` = `maquinas`.`tipomaquina`))) group by `inventario`.`codinterno`,`inventario`.`ID`,`categorias`.`nombrecategoria`,`inventario`.`descripcion`,`marcasmaquina`.`nombremarca`,`tiposmaquina`.`tipo`,`maquinas`.`modelo`,`maquinas`.`serieinterna`,`reports`.`fecha`,`inventario`.`tipo`;

-- ----------------------------
-- View structure for v_listado_facturas
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_listado_facturas` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`formaPago` AS `formaPago`,(select sum((`facturaitems`.`cantidad` * `facturaitems`.`precio`)) AS `sum(cantidad * precio)` from `facturaitems` where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`)) AS `NETO`,(select sum(round(((`facturaitems`.`cantidad` * `facturaitems`.`precio`) * 0.19),0)) AS `sum(round((cantidad * precio)*0.19,0))` from `facturaitems` where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`)) AS `IVA`,(select sum(round(((`facturaitems`.`cantidad` * `facturaitems`.`precio`) * 1.19),0)) AS `sum(round((cantidad * precio)*1.19,0))` from `facturaitems` where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`)) AS `TOTAL`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro`,(select distinct `centrocosto`.`nombreCentroCosto` AS `nombreCentroCosto` from (`facturaitems` join `centrocosto`) where ((`facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto`) and (`facturaitems`.`IDfactura` = `facturas`.`idFactura`))) AS `CENTROCOSTO`,(select distinct `centrocosto`.`idCentroCosto` AS `IDcentroCosto` from (`facturaitems` join `centrocosto`) where ((`facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto`) and (`facturaitems`.`IDfactura` = `facturas`.`idFactura`))) AS `IDCENTROCOSTO` from (`facturas` left join `clientes` on((`clientes`.`rut` = `facturas`.`rutCliente`)));

-- ----------------------------
-- View structure for v_listado_facturas_v2
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas_v2`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_listado_facturas_v2` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`descuento` AS `descuento`,`facturas`.`formaPago` AS `formaPago`,(select sum((`facturaitems`.`cantidad` * `facturaitems`.`precio`)) AS `sum(cantidad * precio)` from `facturaitems` where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`)) AS `NETO`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro` from (`facturas` left join `clientes` on((`clientes`.`rut` = `facturas`.`rutCliente`)));

-- ----------------------------
-- View structure for v_listado_facturas_v3
-- ----------------------------
DROP VIEW IF EXISTS `v_listado_facturas_v3`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_listado_facturas_v3` AS select `facturas`.`idFactura` AS `idFactura`,`facturas`.`fechaFactura` AS `fechaFactura`,`facturas`.`rutCliente` AS `rutCliente`,`facturas`.`fechaVencimiento` AS `fechaVencimiento`,`facturas`.`descuento` AS `descuento`,`facturas`.`formaPago` AS `formaPago`,(select sum((`facturaitems`.`cantidad` * `facturaitems`.`precio`)) AS `sum(cantidad * precio)` from `facturaitems` where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`)) AS `NETO`,(select group_concat(distinct `centrocosto`.`codigoCentroCosto` separator ',') AS `GROUP_CONCAT(distinct centrocosto.codigoCentroCosto)` from (`facturaitems` left join `centrocosto` on((`facturaitems`.`IDcentroCosto` = `centrocosto`.`idCentroCosto`))) where (`facturaitems`.`IDfactura` = `facturas`.`idFactura`) group by `facturaitems`.`IDfactura`) AS `CENTROCOSTO`,`clientes`.`rut` AS `rut`,`clientes`.`dv` AS `dv`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`clientes`.`nombre` AS `nombre`,`clientes`.`telefono` AS `telefono`,`clientes`.`direccion` AS `direccion`,`clientes`.`ciudad` AS `ciudad`,`clientes`.`giro` AS `giro` from (`facturas` left join `clientes` on((`clientes`.`rut` = `facturas`.`rutCliente`)));

-- ----------------------------
-- View structure for v_reporte_insumos_centro_costo
-- ----------------------------
DROP VIEW IF EXISTS `v_reporte_insumos_centro_costo`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_reporte_insumos_centro_costo` AS select `controlsalida`.`IDcontrol` AS `IDCONTROL`,`controlsalida`.`rut` AS `RUT`,`controlsalida`.`fecha` AS `FECHA`,`controlsalida`.`recinto` AS `RECINTO`,`controlinventario`.`IDproducto` AS `IDPRODUCTO`,`controlinventario`.`cantidad` AS `CANTIDAD`,`centrocosto`.`nombreCentroCosto` AS `NOMBRECENTROCOSTO`,`clientes`.`razonsocial` AS `RAZONSOCIAL`,`clientes`.`cliente` AS `CLIENTE`,`inventario`.`modelo` AS `MODELO`,`inventario`.`tipo` AS `TIPO`,`inventario`.`descripcion` AS `DESCRIPCION`,`inventario`.`precioventa` AS `PRECIOVENTA`,`inventario`.`preciocompra` AS `PRECIOCOMPRA`,`inventario`.`codinterno` AS `CODINTERNO`,`marcasmaquina`.`nombremarca` AS `NOMBREMARCA`,`categorias`.`nombrecategoria` AS `NOMBRECATEGORIA`,`centrocosto`.`idCentroCosto` AS `idCentroCosto` from ((((((`controlsalida` join `controlinventario` on((`controlsalida`.`IDcontrol` = `controlinventario`.`IDcontrol`))) join `centrocosto` on((`controlsalida`.`idCentroCosto` = `centrocosto`.`idCentroCosto`))) join `clientes` on((`controlsalida`.`rut` = `clientes`.`rut`))) join `inventario` on((`controlinventario`.`IDproducto` = `inventario`.`ID`))) join `marcasmaquina` on((`inventario`.`marca` = `marcasmaquina`.`ID`))) join `categorias` on((`inventario`.`categoria` = `categorias`.`IDcategoria`))) union select `controldevolucioninventario`.`idControl` AS `idControl`,`controlsalida`.`rut` AS `rut`,`controldevolucioninventario`.`fechaDevolucion` AS `FECHA`,`controlsalida`.`recinto` AS `recinto`,`controldevolucioninventario`.`idProducto` AS `idProducto`,(`controldevolucioninventario`.`cantidad` * -(1)) AS `CANTIDAD`,`centrocosto`.`nombreCentroCosto` AS `nombreCentroCosto`,`clientes`.`razonsocial` AS `razonsocial`,`clientes`.`cliente` AS `cliente`,`inventario`.`modelo` AS `modelo`,`inventario`.`tipo` AS `tipo`,`inventario`.`descripcion` AS `descripcion`,`inventario`.`precioventa` AS `precioventa`,`inventario`.`preciocompra` AS `preciocompra`,`inventario`.`codinterno` AS `codinterno`,`marcasmaquina`.`nombremarca` AS `nombremarca`,`categorias`.`nombrecategoria` AS `nombrecategoria`,`centrocosto`.`idCentroCosto` AS `idCentroCosto` from ((((((`controldevolucioninventario` join `inventario` on((`controldevolucioninventario`.`idProducto` = `inventario`.`ID`))) join `marcasmaquina` on((`inventario`.`marca` = `marcasmaquina`.`ID`))) join `controlsalida` on((`controldevolucioninventario`.`idControl` = `controlsalida`.`IDcontrol`))) join `centrocosto` on((`controlsalida`.`idCentroCosto` = `centrocosto`.`idCentroCosto`))) join `clientes` on((`controlsalida`.`rut` = `clientes`.`rut`))) join `categorias` on((`inventario`.`categoria` = `categorias`.`IDcategoria`))) order by `idControl`,`codinterno`,`cantidad` desc;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `areas` VALUES ('1', 'Abastecimiento y Call Center');
INSERT INTO `areas` VALUES ('2', 'Administración');
INSERT INTO `areas` VALUES ('4', 'Centro Fotocopiado');
INSERT INTO `areas` VALUES ('5', 'Gerencia');
INSERT INTO `areas` VALUES ('6', 'Secretaria');
INSERT INTO `areas` VALUES ('7', 'Servicio Técnico');
INSERT INTO `areas` VALUES ('8', 'Supervisor');
INSERT INTO `areas` VALUES ('9', 'Abastecimiento');
INSERT INTO `areas` VALUES ('10', 'Call Center');
INSERT INTO `areas` VALUES ('11', 'Bodega');
INSERT INTO `boletaitems` VALUES ('1', '16975', 'TONER - BROTHER - MFC-7460 - TONER ALT GOLD', '4', '22538', 'BRO-I270', '0', '0');
INSERT INTO `boletaitems` VALUES ('2', '17024', 'TONER - BROTHER - MFC-L2740 - TONER ALTERNATIVO GOLD 2600 PAG', '1', '25210', 'BRO-I268', '0', '0');
INSERT INTO `boletaitems` VALUES ('3', '18743', 'TONER - BROTHER - HL-L2360 - TONER CARTRIDGE ALTERNATIVO 2600 APROX.', '2', '17126', 'BRO-I230', '0', '0');
INSERT INTO `boletaitems` VALUES ('4', '18743', 'TONER - BROTHER - MFC-L8850CDW - TONER ALT. 6K NEGRO / ASC', '1', '19625', 'BRO-I700', '0', '0');
INSERT INTO `boletaitems` VALUES ('5', '18743', 'TONER - BROTHER - MFC-L8850CDW - TONER ALT. 6K YELLOW / ASC', '1', '24125', 'BRO-I702', '0', '0');
INSERT INTO `boletaitems` VALUES ('6', '19022', 'TONER - TOSHIBA - ESTUDIO 2000 - CARTUCHO ORIGINAL NEGRO', '1', '81050', 'TOS-I255', '0', '0');
INSERT INTO `boletaitems` VALUES ('7', '19022', 'TONER - TOSHIBA - ESTUDIO 2000 - CARTUCHO ORIGINAL MAGENTA ', '1', '186350', 'TOS-I257', '0', '0');
INSERT INTO `boletaitems` VALUES ('8', '19071', 'TONER - BROTHER - MFC-7460 - TONER ALT GOLD', '1', '13874', 'BRO-I270', '0', '0');
INSERT INTO `boletaitems` VALUES ('9', '19077', 'TINTA - RISO - RZ 220UI - TUBO CON CHIP/NEGRA/1000cc', '1', '14840', 'RIS-I90', '0', '0');
INSERT INTO `boletaitems` VALUES ('10', '19126', 'TINTA - RISO - RZ 220UI - TUBO CON CHIP/NEGRA/1000cc', '1', '14840', 'RIS-I90', '0', '0');
INSERT INTO `boletaitems` VALUES ('11', '19123', 'TONER - BROTHER - DCP 8085 - TONER ALTERNATIVO GOLD 8000 COPIAS', '1', '26000', 'BRO-I219', '0', '0');
INSERT INTO `boletaitems` VALUES ('12', '19206', 'TINTA - BROTHER - MFC J200 - TINTA ORIGINAL NEGRA/ 2400 PAG.', '1', '15083', 'BRO-I792', '0', '0');
INSERT INTO `boletaitems` VALUES ('13', '19206', 'TINTA - BROTHER - MFC J200 - TINTA ORIGINAL MAGENTA', '1', '15083', 'BRO-I794', '0', '0');
INSERT INTO `boletaitems` VALUES ('14', '19206', 'TINTA - BROTHER - MFC J200 - TINTA ORIGINAL YELLOW', '1', '15083', 'BRO-I795', '0', '0');
INSERT INTO `boletaitems` VALUES ('15', '19467', 'TINTA - RISO - RZ 220UI - TUBO CON CHIP/NEGRA/1000cc', '1', '14840', 'RIS-I90', '0', '0');
INSERT INTO `boletaitems` VALUES ('16', '19523', 'TINTA - BROTHER - MFC J200 - TINTA ORIGINAL CYAN', '1', '14390', 'BRO-I793', '0', '0');
INSERT INTO `boletaitems` VALUES ('17', '317', 'TONER - BROTHER - MFC-L8850CDW - TONER ALT. 6K NEGRO / ASC', '1', '30252', 'BRO-I700', '0', '0');
INSERT INTO `boletaitems` VALUES ('18', '317', 'TONER - BROTHER - MFC-L8850CDW - TONER ALT. 6K NEGRO / ASC', '1', '30252', 'BRO-I700', '0', '0');
INSERT INTO `boletaitems` VALUES ('19', '363', 'TONER - BROTHER - DCP 7055 - TONER ORGINAL 1000 COPIA APROX', '1', '36000', 'BRO-I208', '0', '0');
INSERT INTO `boletaitems` VALUES ('20', '0', 'TINTA - EPSON - WF C869R - TINTA ORIGINAL NEGRA 22,5K', '1', '79500', 'EPS-I589', '0', '0');
INSERT INTO `boletas` VALUES ('16975', '2019-06-17', '70265000', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('17024', '2019-06-20', '13420903', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('18743', '2020-03-05', '76191772', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19022', '2020-06-15', '76206541', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19071', '2020-08-21', '99514800', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19077', '2020-08-21', '12347432', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19126', '2020-10-05', '12347432', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19123', '2020-10-02', '77015194', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19206', '2020-10-26', '6584101', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19467', '2020-12-11', '12347432', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('19523', '2020-12-24', '6584101', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('317', '2021-04-09', '7103332', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('363', '2021-05-10', '8738250', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `boletas` VALUES ('0', '2021-05-25', '65102261', 'Sin Forma de Pago', 'Sin Referencia', '0');
INSERT INTO `categorias` VALUES ('1', 'MASTER');
INSERT INTO `categorias` VALUES ('2', 'TINTA');
INSERT INTO `categorias` VALUES ('3', 'TONER');
INSERT INTO `categorias` VALUES ('4', 'REVELADOR');
INSERT INTO `categorias` VALUES ('5', 'CUCHILLA');
INSERT INTO `categorias` VALUES ('6', 'BANDA');
INSERT INTO `categorias` VALUES ('7', 'RODILLO');
INSERT INTO `categorias` VALUES ('8', 'TAMBOR');
INSERT INTO `categorias` VALUES ('9', 'TELILLA');
INSERT INTO `categorias` VALUES ('10', 'UNIDAD');
INSERT INTO `categorias` VALUES ('11', 'UÃ‘ETAS');
INSERT INTO `categorias` VALUES ('12', 'TERMISTOR');
INSERT INTO `categorias` VALUES ('13', 'ENGRANAJE');
INSERT INTO `categorias` VALUES ('14', 'TARJETA PWB');
INSERT INTO `categorias` VALUES ('15', 'RODAMIENTO');
INSERT INTO `categorias` VALUES ('16', 'SELLO');
INSERT INTO `categorias` VALUES ('17', 'KIT');
INSERT INTO `categorias` VALUES ('18', 'CORREA');
INSERT INTO `categorias` VALUES ('19', 'BUJES');
INSERT INTO `categorias` VALUES ('20', 'TAPA');
INSERT INTO `categorias` VALUES ('21', 'GOMAS');
INSERT INTO `categorias` VALUES ('22', 'VISAGRA');
INSERT INTO `categorias` VALUES ('23', 'MOTOR');
INSERT INTO `categorias` VALUES ('24', 'ZIN');
INSERT INTO `categorias` VALUES ('25', 'CORONA');
INSERT INTO `categorias` VALUES ('26', 'LAMPARA');
INSERT INTO `categorias` VALUES ('27', 'CILICONA');
INSERT INTO `categorias` VALUES ('28', 'FUENTE');
INSERT INTO `categorias` VALUES ('29', 'GUIA');
INSERT INTO `categorias` VALUES ('30', 'BANDEJA');
INSERT INTO `categorias` VALUES ('31', 'FILTRO');
INSERT INTO `categorias` VALUES ('32', 'HILO');
INSERT INTO `categorias` VALUES ('33', 'EMBRAGE');
INSERT INTO `categorias` VALUES ('34', 'SINFIN');
INSERT INTO `categorias` VALUES ('35', 'CONDUCTO');
INSERT INTO `categorias` VALUES ('36', 'SOCALO');
INSERT INTO `categorias` VALUES ('37', 'SOPORTE');
INSERT INTO `categorias` VALUES ('38', 'CONECTOR');
INSERT INTO `categorias` VALUES ('39', 'TONER BAG');
INSERT INTO `categorias` VALUES ('40', 'RESORTE');
INSERT INTO `categorias` VALUES ('41', 'INTERRUPTOR');
INSERT INTO `categorias` VALUES ('42', 'TERMOSTATO');
INSERT INTO `categorias` VALUES ('43', 'COD. DE BARRA');
INSERT INTO `categorias` VALUES ('44', 'DISCO DURO');
INSERT INTO `categorias` VALUES ('45', 'PLACA');
INSERT INTO `categorias` VALUES ('46', 'PAPEL');
INSERT INTO `categorias` VALUES ('47', 'SENSOR ');
INSERT INTO `categorias` VALUES ('48', 'FUSOR');
INSERT INTO `categorias` VALUES ('49', 'TARJETA PCB');
INSERT INTO `categorias` VALUES ('50', 'CABEZAL');
INSERT INTO `categorias` VALUES ('51', 'GRILLA');
INSERT INTO `categorias` VALUES ('52', 'PROTECTOR');
INSERT INTO `categorias` VALUES ('53', 'CARCASA');
INSERT INTO `categorias` VALUES ('54', 'ANTENA');
INSERT INTO `categorias` VALUES ('55', 'CONJUNTO');
INSERT INTO `categorias` VALUES ('56', 'GRASA');
INSERT INTO `categorias` VALUES ('57', 'CUBIERTA');
INSERT INTO `categorias` VALUES ('58', 'PANEL DE CONTROL');
INSERT INTO `categorias` VALUES ('59', 'CORCHETES');
INSERT INTO `categorias` VALUES ('60', 'ACTUADOR');
INSERT INTO `categorias` VALUES ('61', 'TARJETA');
INSERT INTO `categorias` VALUES ('62', 'SISTEMA CONTINUO');
INSERT INTO `categorias` VALUES ('63', 'CARTUCHO');
INSERT INTO `categorias` VALUES ('64', 'GUILLOTINA');
INSERT INTO `categorias` VALUES ('65', 'CHIP');
INSERT INTO `categorias` VALUES ('66', 'CONFORT');
INSERT INTO `categorias` VALUES ('67', 'ARCHIVADOR');
INSERT INTO `categorias` VALUES ('68', 'GUANTES');
INSERT INTO `categorias` VALUES ('69', 'NOTAS');
INSERT INTO `categorias` VALUES ('70', 'CARPETA');
INSERT INTO `categorias` VALUES ('71', 'CUCHILLO');
INSERT INTO `categorias` VALUES ('72', 'EPP');
INSERT INTO `categorias` VALUES ('73', 'ALCOHOL ');
INSERT INTO `categorias` VALUES ('74', 'MICA');
INSERT INTO `categorias` VALUES ('75', 'PILAS');
INSERT INTO `categorias` VALUES ('76', 'BOLSAS');
INSERT INTO `categorias` VALUES ('77', 'CORCHETE');
INSERT INTO `categorias` VALUES ('78', 'CINTA');
INSERT INTO `categorias` VALUES ('79', 'COMPUTACION');
INSERT INTO `categorias` VALUES ('80', 'DESTACADOR');
INSERT INTO `categorias` VALUES ('81', 'SEPARADORES');
INSERT INTO `categorias` VALUES ('82', 'FUNDA');
INSERT INTO `categorias` VALUES ('83', 'UTILES DE ASEO');
INSERT INTO `categorias` VALUES ('84', 'PEGAMENTO');
INSERT INTO `categorias` VALUES ('85', 'LIBRETA');
INSERT INTO `categorias` VALUES ('86', 'LAPIZ');
INSERT INTO `categorias` VALUES ('87', 'MARCADOR');
INSERT INTO `categorias` VALUES ('88', 'SACACORCHETE');
INSERT INTO `categorias` VALUES ('89', 'VENTILADOR');
INSERT INTO `categorias` VALUES ('90', 'DESODORANTE ');
INSERT INTO `categorias` VALUES ('91', 'LINTERNA');
INSERT INTO `categorias` VALUES ('92', 'CAFÉ');
INSERT INTO `categorias` VALUES ('93', 'TE');
INSERT INTO `categorias` VALUES ('94', 'CARTULINA');
INSERT INTO `categorias` VALUES ('95', 'TERMOLAMINADO');
INSERT INTO `categorias` VALUES ('96', 'ESPIRALES');
INSERT INTO `categorias` VALUES ('97', 'LIBRO');
INSERT INTO `categorias` VALUES ('98', 'ACOCLIP');
INSERT INTO `categorias` VALUES ('99', 'CD-R');
INSERT INTO `categorias` VALUES ('100', 'CLIP');
INSERT INTO `categorias` VALUES ('101', 'DVD+R');
INSERT INTO `categorias` VALUES ('102', 'LUPA');
INSERT INTO `categorias` VALUES ('103', 'ORGANIZADOR');
INSERT INTO `categorias` VALUES ('104', 'PAÑO');
INSERT INTO `categorias` VALUES ('105', 'SILICONA ');
INSERT INTO `categorias` VALUES ('106', 'SOBRES');
INSERT INTO `categorias` VALUES ('107', 'TIJERA');
INSERT INTO `categorias` VALUES ('108', 'TANQUE');
INSERT INTO `categorias` VALUES ('109', 'CORCHETERA');
INSERT INTO `categorias` VALUES ('110', 'BROCHA');
INSERT INTO `categorias` VALUES ('111', 'ENCHUFE');
INSERT INTO `categorias` VALUES ('112', 'HOJA DE DOCUMENTO');
INSERT INTO `categorias` VALUES ('113', 'CUADERNO');
INSERT INTO `categorias` VALUES ('114', 'DEDAL');
INSERT INTO `categorias` VALUES ('115', 'HIERBA');
INSERT INTO `categorias` VALUES ('116', 'REGLA');
INSERT INTO `categorias` VALUES ('117', 'BORRADOR');
INSERT INTO `categorias` VALUES ('118', 'PORTAMINA');
INSERT INTO `categorias` VALUES ('119', 'MINA');
INSERT INTO `categorias` VALUES ('120', 'RESIDUAL');
INSERT INTO `categorias` VALUES ('121', 'PLUMON');
INSERT INTO `categorias` VALUES ('122', 'FIBRA OPTICA');
INSERT INTO `categorias` VALUES ('123', 'CORRECTOR');
INSERT INTO `categorias` VALUES ('124', 'PERFORADOR');
INSERT INTO `categorias` VALUES ('125', 'PUCH-PIN');
INSERT INTO `categorias` VALUES ('126', 'INSECTICIDA');
INSERT INTO `categorias` VALUES ('127', 'BISAGRA ');
INSERT INTO `categorias` VALUES ('128', 'BASE');
INSERT INTO `categorias` VALUES ('129', 'ETIQUETA ');
INSERT INTO `categorias` VALUES ('130', 'AZUCAE');
INSERT INTO `categorias` VALUES ('131', 'MECANISMO');
INSERT INTO `categorias` VALUES ('132', 'CARGADOR');
INSERT INTO `categorias` VALUES ('133', 'DESINFECTANTE');
INSERT INTO `categorias` VALUES ('134', 'ENDULZANTE');
INSERT INTO `categorias` VALUES ('135', 'CRISTAL');
INSERT INTO `categorias` VALUES ('136', 'ROLLO');
INSERT INTO `categorias` VALUES ('137', 'COJIN');
INSERT INTO `categorias` VALUES ('138', 'PENDRIVE');
INSERT INTO `categorias` VALUES ('139', 'CALCULADORA');
INSERT INTO `categorias` VALUES ('140', 'MEMORIA');
INSERT INTO `categorias` VALUES ('141', 'DISPENSADOR');
INSERT INTO `categorias` VALUES ('142', 'TAMPON');
INSERT INTO `categorias` VALUES ('143', 'PAPELERO');
INSERT INTO `categorias` VALUES ('144', 'MOUSE PAD');
INSERT INTO `cd` VALUES ('1', '111111', 'mandinga', 'mandinga', '2011-01-24', '10000');
INSERT INTO `cd` VALUES ('2', '1.111.111-1', 'bodega', 'por devulucion de in', '2011-02-24', '0');
INSERT INTO `cd` VALUES ('3', '11111111', 'CSJ Digital Express', 'devolucion de produc', '2011-03-01', '0');
INSERT INTO `cd` VALUES ('4', '11111111', 'CSJ Digital Express', 'devolucion de repues', '2011-03-02', '0');
INSERT INTO `cd` VALUES ('5', '11111111', 'CONSTRUCTORA NAVARRE', 'DEVOLUCION', '2011-02-24', '0');
INSERT INTO `cd` VALUES ('6', '11111111-1', 'PRECISION ROLLER', 'PRECISION ROLLER', '2011-04-12', '11985');
INSERT INTO `cd` VALUES ('7', '156909297', 'CSJ DIGITAL EXPRESS', 'DEVOLUCION DE INSUMO', '2011-04-18', '0');
INSERT INTO `cd` VALUES ('8', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-04-18', '0');
INSERT INTO `cd` VALUES ('9', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-04-18', '0');
INSERT INTO `cd` VALUES ('10', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-04-26', '0');
INSERT INTO `cd` VALUES ('11', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-04-27', '0');
INSERT INTO `cd` VALUES ('12', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-04-28', '0');
INSERT INTO `cd` VALUES ('13', '156909297', 'JOSUE', 'MARCELA LY', '2011-04-29', '0');
INSERT INTO `cd` VALUES ('14', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-05-10', '0');
INSERT INTO `cd` VALUES ('15', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-05-10', '0');
INSERT INTO `cd` VALUES ('16', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-05-13', '0');
INSERT INTO `cd` VALUES ('17', '969047306', 'Empresa Virtual', 'Grafica Virtual', '2011-05-13', '53784');
INSERT INTO `cd` VALUES ('18', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-05-26', '0');
INSERT INTO `cd` VALUES ('19', '782857509', 'Jose Carlos Quiroz y', 'Jose Carlos Quiroz', '2011-06-03', '388700');
INSERT INTO `cd` VALUES ('20', '1111111|', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2011-06-21', '0');
INSERT INTO `cd` VALUES ('21', '111111111111', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2011-06-24', '0');
INSERT INTO `cd` VALUES ('22', '11111111', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2011-06-30', '0');
INSERT INTO `cd` VALUES ('23', '11111111', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2011-07-04', '0');
INSERT INTO `cd` VALUES ('24', '1111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMOS', '2011-08-25', '0');
INSERT INTO `cd` VALUES ('25', '1111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMOS', '2011-08-25', '0');
INSERT INTO `cd` VALUES ('26', '156909297', 'JEAN PIERE SOUBLETTE', 'MARCELA LY', '2011-09-21', '0');
INSERT INTO `cd` VALUES ('27', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-09-26', '0');
INSERT INTO `cd` VALUES ('28', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-09-26', '0');
INSERT INTO `cd` VALUES ('29', '1111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMOS', '2011-09-27', '0');
INSERT INTO `cd` VALUES ('30', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-09-27', '0');
INSERT INTO `cd` VALUES ('31', '156909297', 'CSJ DIGITAL EXPRESS', 'MARCELA LY', '2011-09-27', '0');
INSERT INTO `cd` VALUES ('32', '17723828-7', 'CSJ Digital Express', 'ROSE MARY CORTES', '2011-09-30', '0');
INSERT INTO `cd` VALUES ('33', '17723828-7', 'CSJ Digital Express', 'ROSE MARY CORTES', '2011-09-30', '0');
INSERT INTO `cd` VALUES ('34', '156909297', 'csj digital express', 'marcela ly', '2011-10-04', '0');
INSERT INTO `cd` VALUES ('35', '156909297', 'csj digital express', 'marcela Ly', '2011-10-04', '0');
INSERT INTO `cd` VALUES ('36', '77.397.590-6', 'ORTIZ Y SAN MARTIN L', 'DOCUSERVICE', '2012-03-21', '39924');
INSERT INTO `cd` VALUES ('37', '17.723.828-7', 'CSJ Digital Express', 'ROSE MARY CORTES', '2012-03-27', '0');
INSERT INTO `cd` VALUES ('38', '111111111', 'CJS DIGITAL', 'DEVOLUCION DE IQUIQU', '2012-06-28', '0');
INSERT INTO `cd` VALUES ('39', '11111111', 'csj digital', 'devolucion', '2012-07-04', '0');
INSERT INTO `cd` VALUES ('40', '11111111', 'csj digital', 'devolucion', '2012-07-04', '0');
INSERT INTO `cd` VALUES ('41', '111111111111', 'csj digital', 'devolucion', '2012-07-06', '0');
INSERT INTO `cd` VALUES ('42', '111111111', 'csjdigital', 'devolucion', '2012-07-12', '0');
INSERT INTO `cd` VALUES ('43', '1111111', 'csj digital', 'devolucion', '2012-07-13', '0');
INSERT INTO `cd` VALUES ('44', '1111111111111', 'csj digital', 'DEVOLUCION', '2012-07-17', '0');
INSERT INTO `cd` VALUES ('45', '1111111111', 'CSJ DIGITAL', 'DEVOLUCION', '2012-07-17', '0');
INSERT INTO `cd` VALUES ('46', '1111111111', 'CSJ DIGITAL', 'DEVOLUCION', '2012-07-18', '0');
INSERT INTO `cd` VALUES ('47', '1111111111', 'CSJ DIGITAL', 'DEVOLUCION', '2012-07-19', '0');
INSERT INTO `cd` VALUES ('48', '111111111', 'CSJ DIGITAL', 'DEVOLUCION', '2012-07-24', '0');
INSERT INTO `cd` VALUES ('49', '11111111111', 'CSJ', 'DEVOLUCION', '2012-07-24', '0');
INSERT INTO `cd` VALUES ('50', '1111111111111', 'csj', 'DEVOLUCION', '2012-07-25', '0');
INSERT INTO `cd` VALUES ('51', '11111111', 'CSJ', 'DEVOLUCION', '2012-07-25', '0');
INSERT INTO `cd` VALUES ('52', '111111111111', 'CSJ', 'DEVOLUCION', '2012-07-26', '0');
INSERT INTO `cd` VALUES ('53', '11111111', ' CSJ', 'DEVOLUCION', '2012-07-26', '0');
INSERT INTO `cd` VALUES ('54', '1111111111111', 'csj ', 'devolucion', '2012-07-31', '0');
INSERT INTO `cd` VALUES ('55', '111111111', 'CSJ', 'CART. RECARGADOS', '2012-08-07', '0');
INSERT INTO `cd` VALUES ('56', '1111111111111', 'CSJ', 'RECARGAS', '2012-08-08', '0');
INSERT INTO `cd` VALUES ('57', '11111111', 'CSJ', 'DEVOLUCION', '2012-08-08', '0');
INSERT INTO `cd` VALUES ('58', '11111111111', 'CSJ', 'RECARGAS', '2012-08-09', '0');
INSERT INTO `cd` VALUES ('59', '1111111', 'CSJ', 'DEVOLUCION', '2012-08-09', '0');
INSERT INTO `cd` VALUES ('60', '1111111111111', 'CSJ', 'RECARGAS', '2012-08-14', '0');
INSERT INTO `cd` VALUES ('61', '11111111111', 'CSJ', 'DEVOLUCION', '2012-08-16', '0');
INSERT INTO `cd` VALUES ('62', '1111111111', 'CSJ', 'DEVOLUCION', '2012-08-16', '0');
INSERT INTO `cd` VALUES ('63', '111111111', 'CSJ', 'RELLENO', '2012-08-24', '0');
INSERT INTO `cd` VALUES ('64', '1111111111111', 'CSJ', 'DEVOLUCION', '2012-08-28', '0');
INSERT INTO `cd` VALUES ('65', '1111111111111', 'CSJ', 'DEVOLUCION', '2012-08-28', '0');
INSERT INTO `cd` VALUES ('66', '1111111111111', 'CSJ', 'DEVOLUCION', '2012-10-05', '0');
INSERT INTO `cd` VALUES ('67', '11111111111', 'CSJ', 'DEVOLUCION', '2012-10-05', '0');
INSERT INTO `cd` VALUES ('68', '1111111111111', 'csj', 'devolucion', '2012-11-09', '0');
INSERT INTO `cd` VALUES ('69', '1111111111', 'CSJ', 'DEVOLUCION', '2012-11-09', '0');
INSERT INTO `cd` VALUES ('70', '11111111', 'CSJ', 'DEVOLUCION', '2012-11-09', '0');
INSERT INTO `cd` VALUES ('71', '1111111111', 'CSJ', 'DEVOLUCION', '2012-11-15', '0');
INSERT INTO `cd` VALUES ('72', '111111111111', 'CSJ', 'DEVOLUCION', '2012-11-15', '0');
INSERT INTO `cd` VALUES ('73', '111111111', 'CSJ', 'DEVOLUCION', '2012-11-21', '0');
INSERT INTO `cd` VALUES ('74', '111111111', 'csj', 'devolucion', '2012-11-22', '0');
INSERT INTO `cd` VALUES ('75', '11111', 'csj', 'tinta rellenadas', '2012-11-22', '0');
INSERT INTO `cd` VALUES ('76', '111111', 'csj', 'devolucion', '2012-11-22', '0');
INSERT INTO `cd` VALUES ('77', '11111111111', 'CSJ', 'DEVOLUCION', '2012-11-26', '0');
INSERT INTO `cd` VALUES ('78', '1111111111111', 'CSJ', 'DEVOLUCION', '2012-11-29', '0');
INSERT INTO `cd` VALUES ('79', '1111111111111', 'CSJ', 'DEVOLUCION', '2012-12-05', '0');
INSERT INTO `cd` VALUES ('80', '1111111111', 'csj', 'devolucio', '2012-12-10', '0');
INSERT INTO `cd` VALUES ('81', '111111111', 'csj', 'devolucion', '2012-12-12', '0');
INSERT INTO `cd` VALUES ('82', '1111111111111', 'csj', 'relleno', '2012-12-14', '0');
INSERT INTO `cd` VALUES ('83', '111111111111', 'CSJ Digital Express', 'devolucion', '2012-12-19', '0');
INSERT INTO `cd` VALUES ('84', '111111111111', 'csj ', 'devolucion', '2012-12-21', '0');
INSERT INTO `cd` VALUES ('85', '1111111111111', 'csj digital', 'devolucion', '2013-01-16', '0');
INSERT INTO `cd` VALUES ('86', '11111111111', 'csj', 'devolucion', '2013-01-18', '0');
INSERT INTO `cd` VALUES ('87', '11111111', 'COMERCIAL CECOM LTDA', 'DANIEL FUNTELZAR', '2013-01-21', '0');
INSERT INTO `cd` VALUES ('88', '11111111', 'CSJ Digital Express', 'devolucion', '2013-01-23', '0');
INSERT INTO `cd` VALUES ('89', '1111111111111', 'csj digital', 'devolucion', '2013-02-07', '0');
INSERT INTO `cd` VALUES ('90', '1111111111111', 'csj', 'rose', '2013-02-08', '0');
INSERT INTO `cd` VALUES ('91', '111111', 'CSJ', 'DEVOLUCION', '2013-02-11', '0');
INSERT INTO `cd` VALUES ('92', '1111111111111', 'csj', 'sistema', '2013-02-12', '0');
INSERT INTO `cd` VALUES ('93', '011111', 'CSJ Digital Express', 'sistema', '2013-02-12', '0');
INSERT INTO `cd` VALUES ('94', '111111111', 'CSJ Digital Express', 'devolucion', '2013-02-12', '0');
INSERT INTO `cd` VALUES ('95', '111111111', 'CSJ Digital Express', 'devolucion', '2013-02-19', '0');
INSERT INTO `cd` VALUES ('96', '111111111', 'CSJ ', 'DEVOLUCION', '2013-02-20', '0');
INSERT INTO `cd` VALUES ('97', '111111111', 'CSJ Digital Express', 'devolucion', '2013-02-21', '0');
INSERT INTO `cd` VALUES ('98', '111111111', 'CSJ Digital Express', 'devolucion', '2013-02-21', '0');
INSERT INTO `cd` VALUES ('99', '1111111111111', 'csj', 'devolucion', '2013-02-22', '0');
INSERT INTO `cd` VALUES ('100', '11111111111', 'csj', 'devolucion', '2013-03-06', '0');
INSERT INTO `cd` VALUES ('101', '1111111111111', 'DIMACOFI', 'MONICA BAEZ', '2013-03-22', '0');
INSERT INTO `cd` VALUES ('102', '1111111111', 'csj', 'devolucion', '2013-09-30', '0');
INSERT INTO `cd` VALUES ('103', '11111111', 'csj', 'rellenado', '2013-10-01', '0');
INSERT INTO `cd` VALUES ('104', '222222222222', 'csj', 'devolucion', '2013-10-01', '0');
INSERT INTO `cd` VALUES ('105', '1111111111111', 'CSJ', '', '2013-10-09', '0');
INSERT INTO `cd` VALUES ('106', '111111111111', 'CSJ', 'DEVOLUCION', '2013-10-04', '0');
INSERT INTO `cd` VALUES ('107', '1111111111111', 'CSJ', 'SE RETIRA DE MAQUINA', '2013-10-16', '0');
INSERT INTO `cd` VALUES ('108', '11111111111', 'CSJ', 'DEVOLUCION', '2013-10-16', '0');
INSERT INTO `cd` VALUES ('109', '11111111', 'csj', 'recargas', '2013-10-18', '0');
INSERT INTO `cd` VALUES ('110', '1111111111', 'DIGITAL SERVICE', 'DEVOLUCION', '2013-11-27', '0');
INSERT INTO `cd` VALUES ('111', '761218417', 'CSJ Digital Express', 'digital service', '2014-02-04', '95700');
INSERT INTO `cd` VALUES ('112', '13420903', 'CSJ Digital Express', 'CSJ Digital Express', '2014-02-05', '0');
INSERT INTO `cd` VALUES ('113', '1111111111', 'DIGITAL SERVICE ', 'TALLER', '2014-06-16', '0');
INSERT INTO `cd` VALUES ('114', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION DE REGIST', '2014-10-29', '0');
INSERT INTO `cd` VALUES ('115', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2014-10-29', '0');
INSERT INTO `cd` VALUES ('116', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO CE', '2014-11-05', '0');
INSERT INTO `cd` VALUES ('117', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO CA', '2014-11-05', '0');
INSERT INTO `cd` VALUES ('118', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO CE', '2014-11-07', '0');
INSERT INTO `cd` VALUES ('119', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO SA', '2014-11-13', '0');
INSERT INTO `cd` VALUES ('120', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO CE', '2014-11-18', '0');
INSERT INTO `cd` VALUES ('121', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO EN', '2014-11-18', '0');
INSERT INTO `cd` VALUES ('122', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION INSUMO CO', '2014-11-25', '0');
INSERT INTO `cd` VALUES ('123', '1111111111111', 'CSJ Digital Express', 'DEVOLUCION DE INSUMO', '2014-11-25', '0');
INSERT INTO `cd` VALUES ('124', '1111111111111', 'CSJ Digital Express', 'devolucion', '2014-12-04', '0');
INSERT INTO `cd` VALUES ('125', '1111111111111', 'CSJ Digital Express', 'devolucion', '2014-12-04', '0');
INSERT INTO `cd` VALUES ('126', '1111111111111', 'CSJ Digital Express', 'devolucion', '2014-12-04', '0');
INSERT INTO `cd` VALUES ('127', '1111111111111', 'DIGITAL SERVICE', 'devolucion', '2014-12-10', '0');
INSERT INTO `cd` VALUES ('128', '1111111111111', 'DIGITAL SERVICE', 'devolucion', '2014-12-10', '0');
INSERT INTO `cd` VALUES ('129', '1111111111111', 'CSJ Digital Express', 'devolucion casino ri', '2014-12-12', '0');
INSERT INTO `cd` VALUES ('130', '1111111111111', 'CSJ Digital Express', 'devolucion casino ri', '2014-12-12', '0');
INSERT INTO `cd` VALUES ('131', '1111111111111', 'CSJ Digital Express', 'CSJ Digital Express', '2014-12-30', '0');
INSERT INTO `cd` VALUES ('132', '1111111111111', 'CSJ Digital Express', 'efrain', '2015-01-09', '0');
INSERT INTO `cd` VALUES ('133', '1111111111111', 'CSJ Digital Express', 'CSJ Digital Express', '2015-01-22', '0');
INSERT INTO `cd` VALUES ('134', '111111111', 'CSJ Digital Express', 'devolucion', '2015-04-14', '0');
INSERT INTO `cd` VALUES ('135', '15690929', 'CSJ Digital Express', 'MARCELA LY', '2015-05-18', '0');
INSERT INTO `cd` VALUES ('136', '111111111', 'CSJ Digital Express', 'devolucion', '2015-05-27', '0');
INSERT INTO `cd` VALUES ('137', '17.723.828-7', 'CSJ Digital Express', 'devolucion', '2015-05-27', '0');
INSERT INTO `cd` VALUES ('138', '15690929', 'CSJ Digital Express', 'MARCELA LY', '2015-05-27', '0');
INSERT INTO `cd` VALUES ('139', '15690929', 'CSJ Digital Express', 'MARCELA LY', '2015-05-29', '0');
INSERT INTO `cd` VALUES ('140', '78581570K', 'BROTTHER INTERNATION', 'GARANTIA', '2015-06-01', '0');
INSERT INTO `cd` VALUES ('141', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-08', '0');
INSERT INTO `cd` VALUES ('142', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-08', '0');
INSERT INTO `cd` VALUES ('143', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-10', '0');
INSERT INTO `cd` VALUES ('144', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-11', '0');
INSERT INTO `cd` VALUES ('145', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-12', '0');
INSERT INTO `cd` VALUES ('146', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-16', '0');
INSERT INTO `cd` VALUES ('147', '11111111111', 'BROTHER INTERNATIONA', 'GARANTIA', '2015-06-19', '0');
INSERT INTO `cd` VALUES ('148', '15.690.929-7', 'CSJ Digital Express', 'MARCELA LY', '2015-06-19', '0');
INSERT INTO `cd` VALUES ('149', '111111111', 'TOPAC CHILE COMERCIA', 'TECHINT ', '2015-06-22', '0');
INSERT INTO `cd` VALUES ('150', '15.690.929-7', 'CSJ Digital Express', 'DEVOLUCION ', '2015-06-23', '0');
INSERT INTO `cd` VALUES ('151', 'DEVOLUCION VI', 'CSJ Digital Express', 'MARCELA LY', '2015-06-23', '0');
INSERT INTO `cd` VALUES ('152', '13420903', 'CSJ Digital Express', 'BROTHER', '2015-06-24', '0');
INSERT INTO `cd` VALUES ('153', '111111', 'digital service', 'devolucion', '2015-06-24', '0');
INSERT INTO `cd` VALUES ('154', '13420903', 'CSJ Digital Express', 'ADMINISTRACION', '2015-06-30', '0');
INSERT INTO `cd` VALUES ('155', '13420903', 'CSJ Digital Express', 'CSJ Digital Express', '2015-07-01', '0');
INSERT INTO `cd` VALUES ('156', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-06', '0');
INSERT INTO `cd` VALUES ('157', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-07', '0');
INSERT INTO `cd` VALUES ('158', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-07', '0');
INSERT INTO `cd` VALUES ('159', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-07', '0');
INSERT INTO `cd` VALUES ('160', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-08', '0');
INSERT INTO `cd` VALUES ('161', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-08', '0');
INSERT INTO `cd` VALUES ('162', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-09', '0');
INSERT INTO `cd` VALUES ('163', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-09', '0');
INSERT INTO `cd` VALUES ('164', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-15', '0');
INSERT INTO `cd` VALUES ('165', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-20', '0');
INSERT INTO `cd` VALUES ('166', '156909297', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-21', '0');
INSERT INTO `cd` VALUES ('167', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-22', '0');
INSERT INTO `cd` VALUES ('168', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-23', '0');
INSERT INTO `cd` VALUES ('169', '1111111111', 'BROTHER CHILE', 'GARANTIA BROTHER', '2015-07-23', '0');
INSERT INTO `cd` VALUES ('170', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-29', '0');
INSERT INTO `cd` VALUES ('171', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-29', '0');
INSERT INTO `cd` VALUES ('172', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-07-29', '0');
INSERT INTO `cd` VALUES ('173', '11111111111', 'BROTHER INTERNATIONA', 'GARANTIA', '2015-07-30', '0');
INSERT INTO `cd` VALUES ('174', 'DEVOLUCION', 'DIGITALSERVICE', 'MARCELA LY', '2015-07-30', '0');
INSERT INTO `cd` VALUES ('175', '1111111111111', 'BROTHER INTERNATIONA', 'GARANTIA', '2015-08-03', '0');
INSERT INTO `cd` VALUES ('176', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-04', '0');
INSERT INTO `cd` VALUES ('177', 'DEVOLUCION PR', 'DIGITAL SERVICE', 'MARCELA', '2015-08-05', '0');
INSERT INTO `cd` VALUES ('178', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-05', '0');
INSERT INTO `cd` VALUES ('179', 'DEVOLUCION ', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-05', '0');
INSERT INTO `cd` VALUES ('180', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-06', '0');
INSERT INTO `cd` VALUES ('181', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-07', '0');
INSERT INTO `cd` VALUES ('182', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-10', '0');
INSERT INTO `cd` VALUES ('183', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-10', '0');
INSERT INTO `cd` VALUES ('184', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-13', '0');
INSERT INTO `cd` VALUES ('185', 'SANDVIK', 'TOPAC CHILE', 'GARANTIA ', '2015-08-18', '0');
INSERT INTO `cd` VALUES ('186', 'REPUESTOS DE ', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-18', '0');
INSERT INTO `cd` VALUES ('187', 'DEVOLUCION TO', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-19', '0');
INSERT INTO `cd` VALUES ('188', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-21', '0');
INSERT INTO `cd` VALUES ('189', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-24', '0');
INSERT INTO `cd` VALUES ('190', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-26', '0');
INSERT INTO `cd` VALUES ('191', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2015-08-28', '0');
INSERT INTO `cd` VALUES ('192', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-08-31', '0');
INSERT INTO `cd` VALUES ('193', 'LLEGO MAS MAT', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-01', '0');
INSERT INTO `cd` VALUES ('194', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-02', '0');
INSERT INTO `cd` VALUES ('195', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-02', '0');
INSERT INTO `cd` VALUES ('196', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-03', '0');
INSERT INTO `cd` VALUES ('197', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-04', '0');
INSERT INTO `cd` VALUES ('198', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-04', '0');
INSERT INTO `cd` VALUES ('199', 'AGREGAR', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-07', '0');
INSERT INTO `cd` VALUES ('200', 'DEVOLUCION', 'DIGITIAL SERVICE', 'MARCELA LY', '2015-09-07', '0');
INSERT INTO `cd` VALUES ('201', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-09', '0');
INSERT INTO `cd` VALUES ('202', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2015-09-10', '0');
INSERT INTO `cd` VALUES ('203', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-11', '0');
INSERT INTO `cd` VALUES ('204', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-11', '0');
INSERT INTO `cd` VALUES ('205', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-11', '0');
INSERT INTO `cd` VALUES ('206', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-14', '0');
INSERT INTO `cd` VALUES ('207', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-09-17', '0');
INSERT INTO `cd` VALUES ('208', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2015-09-24', '0');
INSERT INTO `cd` VALUES ('209', 'DEVOLUCION', 'DIGITAL SERVERCE', 'MARCELA LY', '2015-09-24', '0');
INSERT INTO `cd` VALUES ('210', 'DEVOLUCION ', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-02', '0');
INSERT INTO `cd` VALUES ('211', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-05', '0');
INSERT INTO `cd` VALUES ('212', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-05', '0');
INSERT INTO `cd` VALUES ('213', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-08', '0');
INSERT INTO `cd` VALUES ('214', 'DEVOLUCION', 'DIGITAL SERVICI', 'MARCELA LY', '2015-10-15', '0');
INSERT INTO `cd` VALUES ('215', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-19', '0');
INSERT INTO `cd` VALUES ('216', '156909297', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-19', '0');
INSERT INTO `cd` VALUES ('217', 'DEVOLUCION', 'DIGITAL SERVECE', 'MARCELA LY', '2015-10-19', '0');
INSERT INTO `cd` VALUES ('218', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2015-10-26', '0');
INSERT INTO `cd` VALUES ('219', 'DEVOLUCION', 'DIGITAL SRVICE', 'MARCELA LY', '2015-10-30', '0');
INSERT INTO `cd` VALUES ('220', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-11-09', '0');
INSERT INTO `cd` VALUES ('221', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-11-10', '0');
INSERT INTO `cd` VALUES ('222', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-10-30', '0');
INSERT INTO `cd` VALUES ('223', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-11-13', '0');
INSERT INTO `cd` VALUES ('224', 'INCORPORTACIO', 'DIGITAL SERVICE', 'MARCELA ', '2015-11-17', '0');
INSERT INTO `cd` VALUES ('225', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-11-17', '0');
INSERT INTO `cd` VALUES ('226', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2015-11-24', '0');
INSERT INTO `cd` VALUES ('227', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2015-12-03', '0');
INSERT INTO `cd` VALUES ('228', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-12-15', '0');
INSERT INTO `cd` VALUES ('229', 'INGRESAR A IN', 'VAM', 'VIRGINIA', '2015-12-16', '0');
INSERT INTO `cd` VALUES ('230', 'DEVOLUCION ', 'DIGITAL SERVICE', 'MARCELA ', '2015-12-17', '0');
INSERT INTO `cd` VALUES ('231', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2015-12-18', '0');
INSERT INTO `cd` VALUES ('232', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2015-12-21', '0');
INSERT INTO `cd` VALUES ('233', 'DEVOLUCIOIN', 'DIGITAL SERVICE', 'MARCELA ', '2015-12-22', '0');
INSERT INTO `cd` VALUES ('234', 'DVOLUCION ', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-05', '0');
INSERT INTO `cd` VALUES ('235', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-01-06', '0');
INSERT INTO `cd` VALUES ('236', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-07', '0');
INSERT INTO `cd` VALUES ('237', 'MARCELA', 'DIGITAL SERVICE', 'DEVOLUCION', '2016-01-07', '0');
INSERT INTO `cd` VALUES ('238', 'DEVOLUCION', 'DIGITAL SRVICE', 'MARCELA ', '2016-01-08', '0');
INSERT INTO `cd` VALUES ('239', 'DEVOLUCINO', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-12', '0');
INSERT INTO `cd` VALUES ('240', 'BROTHER', 'DIGITAL SERVICE', 'GARANTIA', '2016-01-19', '0');
INSERT INTO `cd` VALUES ('241', 'DEVOLUCION', 'DIGITAL SERVICES', 'MARCELA ', '2016-01-19', '0');
INSERT INTO `cd` VALUES ('242', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-19', '0');
INSERT INTO `cd` VALUES ('243', 'DEVOLUCION', 'DIGITAL SERVICE ', 'MARCELA ', '2016-01-20', '0');
INSERT INTO `cd` VALUES ('244', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-01-22', '0');
INSERT INTO `cd` VALUES ('245', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-22', '0');
INSERT INTO `cd` VALUES ('246', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-25', '0');
INSERT INTO `cd` VALUES ('247', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-01-28', '0');
INSERT INTO `cd` VALUES ('248', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-01-28', '0');
INSERT INTO `cd` VALUES ('249', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-02-02', '0');
INSERT INTO `cd` VALUES ('250', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-02-16', '0');
INSERT INTO `cd` VALUES ('251', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-02-23', '0');
INSERT INTO `cd` VALUES ('252', 'DEVOLUCION', 'DIGITAL SERVICE ', 'MARCELA ', '2016-03-02', '0');
INSERT INTO `cd` VALUES ('253', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-03-08', '0');
INSERT INTO `cd` VALUES ('254', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-03-10', '0');
INSERT INTO `cd` VALUES ('255', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-03-21', '0');
INSERT INTO `cd` VALUES ('256', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-03-18', '0');
INSERT INTO `cd` VALUES ('257', 'devolucion', 'digital service', 'marcela ', '2016-03-23', '0');
INSERT INTO `cd` VALUES ('258', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-03-23', '0');
INSERT INTO `cd` VALUES ('259', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2016-03-29', '0');
INSERT INTO `cd` VALUES ('260', 'DEVOLUCION', 'digital service', 'marcela', '2016-03-29', '0');
INSERT INTO `cd` VALUES ('261', 'DEVOLUCION', 'digital service', 'marcela', '2016-03-29', '0');
INSERT INTO `cd` VALUES ('262', 'DEVOLUCION', 'digital service', 'marcela', '2016-03-29', '0');
INSERT INTO `cd` VALUES ('263', 'DEVOLUCION', 'digital service', 'marcela', '2016-03-30', '0');
INSERT INTO `cd` VALUES ('264', 'DEVOLUCION', 'digital service', 'marcela', '2016-03-31', '0');
INSERT INTO `cd` VALUES ('265', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-04', '0');
INSERT INTO `cd` VALUES ('266', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-07', '0');
INSERT INTO `cd` VALUES ('267', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-07', '0');
INSERT INTO `cd` VALUES ('268', 'RECARGAS', 'digital service', 'marcela', '2016-04-11', '0');
INSERT INTO `cd` VALUES ('269', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-11', '0');
INSERT INTO `cd` VALUES ('270', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-11', '0');
INSERT INTO `cd` VALUES ('271', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2016-04-15', '0');
INSERT INTO `cd` VALUES ('272', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-18', '0');
INSERT INTO `cd` VALUES ('273', 'devolucion', 'digital service', 'marcela', '2016-04-20', '0');
INSERT INTO `cd` VALUES ('274', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-20', '0');
INSERT INTO `cd` VALUES ('275', 'DEVULUCION', 'digital service', 'marcela', '2016-04-27', '0');
INSERT INTO `cd` VALUES ('276', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-28', '0');
INSERT INTO `cd` VALUES ('277', 'DEVOLUCION', 'digital service', 'marcela', '2016-04-28', '0');
INSERT INTO `cd` VALUES ('278', 'DEVOLUCION ', 'digital service', 'marcela', '2016-04-29', '0');
INSERT INTO `cd` VALUES ('279', 'DEVOLUCION', 'digital service', 'marcela', '2016-05-03', '0');
INSERT INTO `cd` VALUES ('280', '1111111111', 'INVERSIONES Y SERVIC', 'ROSE', '2016-05-03', '0');
INSERT INTO `cd` VALUES ('281', 'DEVOLUCION', 'digital service', 'marcela', '2016-05-06', '0');
INSERT INTO `cd` VALUES ('282', 'DEVOLUCION', 'digital service', 'marcela', '2016-05-06', '0');
INSERT INTO `cd` VALUES ('283', 'devolucion', 'digital service', 'marcela', '2016-05-06', '0');
INSERT INTO `cd` VALUES ('284', 'devolucion', 'digital service', 'marcela', '2016-05-09', '0');
INSERT INTO `cd` VALUES ('285', 'DEVOLUCION', 'digital service', 'marcela', '2016-05-10', '0');
INSERT INTO `cd` VALUES ('286', 'devolucion', 'digital service', 'marcela', '2016-05-13', '0');
INSERT INTO `cd` VALUES ('287', 'devolucion', 'digital service', 'marcela', '2016-05-17', '0');
INSERT INTO `cd` VALUES ('288', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-05-17', '0');
INSERT INTO `cd` VALUES ('289', '1111111111111', 'VAM', 'POR ERROR', '2016-06-29', '0');
INSERT INTO `cd` VALUES ('290', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-07-04', '0');
INSERT INTO `cd` VALUES ('291', 'DEVOLUVION', 'DIGITAL SERVICE', 'marcela ly', '2016-06-30', '0');
INSERT INTO `cd` VALUES ('292', 'DEVOLVER', 'DIGITAL SERVICE', 'MARCELA ', '2016-06-30', '0');
INSERT INTO `cd` VALUES ('293', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-06-22', '0');
INSERT INTO `cd` VALUES ('294', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2016-06-22', '0');
INSERT INTO `cd` VALUES ('295', 'DEVOLUCION ', 'digital service', 'MARCELA ', '2016-07-08', '0');
INSERT INTO `cd` VALUES ('296', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-07-13', '0');
INSERT INTO `cd` VALUES ('297', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-07-29', '0');
INSERT INTO `cd` VALUES ('298', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-07-29', '0');
INSERT INTO `cd` VALUES ('299', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-07-29', '0');
INSERT INTO `cd` VALUES ('300', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-08-04', '0');
INSERT INTO `cd` VALUES ('301', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-08-09', '0');
INSERT INTO `cd` VALUES ('302', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-08-19', '0');
INSERT INTO `cd` VALUES ('303', '1111111111', 'ascarcon ltda', 'para luis gonzalez', '2016-08-22', '20500');
INSERT INTO `cd` VALUES ('304', 'devolucion', 'digital service', 'marcela ly', '2016-08-26', '0');
INSERT INTO `cd` VALUES ('305', 'devolucion', 'digital service', 'marcela ly', '2016-08-26', '0');
INSERT INTO `cd` VALUES ('306', 'DEVOLCUION', 'digital service', 'marcela ly', '2016-08-26', '0');
INSERT INTO `cd` VALUES ('307', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-08-30', '0');
INSERT INTO `cd` VALUES ('308', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-09-02', '0');
INSERT INTO `cd` VALUES ('309', 'DEVOLUCION', 'digital service', 'marcela ly', '2016-09-02', '0');
INSERT INTO `cd` VALUES ('310', 'devolucion', 'digital service', 'MARCELA LY BROCHET', '2016-09-13', '0');
INSERT INTO `cd` VALUES ('311', 'devolucion', 'digital service', 'MARCELA LY BROCHET', '2016-09-13', '0');
INSERT INTO `cd` VALUES ('312', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-10-18', '0');
INSERT INTO `cd` VALUES ('313', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-10-24', '0');
INSERT INTO `cd` VALUES ('314', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-10-24', '0');
INSERT INTO `cd` VALUES ('315', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-10-24', '0');
INSERT INTO `cd` VALUES ('316', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-10-26', '0');
INSERT INTO `cd` VALUES ('317', 'DEVOLUCION', 'DIGITAL SERVICE', 'marcela ly', '2016-10-26', '0');
INSERT INTO `cd` VALUES ('318', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2016-10-28', '0');
INSERT INTO `cd` VALUES ('319', 'DEVOLUCION', 'DIGITAL SERVICE ', 'marcela ly', '2016-11-09', '0');
INSERT INTO `cd` VALUES ('320', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2016-11-16', '0');
INSERT INTO `cd` VALUES ('321', 'MARCELA LY', 'DIGITAL SERVICE', 'DEVOLUCION INSUMOS', '2016-11-29', '0');
INSERT INTO `cd` VALUES ('322', 'MARCELA', 'DIGITAL SERVICE', 'DEVOLUCION INSUMOS', '2016-12-01', '0');
INSERT INTO `cd` VALUES ('323', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2016-12-15', '0');
INSERT INTO `cd` VALUES ('324', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2017-01-03', '0');
INSERT INTO `cd` VALUES ('325', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA ', '2017-01-09', '0');
INSERT INTO `cd` VALUES ('326', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA', '2017-01-13', '0');
INSERT INTO `cd` VALUES ('327', 'DEVOLUCION', 'DIGITAL SERVICE', 'MARCELA LY', '2017-02-24', '0');
INSERT INTO `cd` VALUES ('328', 'INSUMOS', 'DIGITAL SERVICE', 'MARCELA', '2017-04-07', '0');
INSERT INTO `cd` VALUES ('329', 'CATRIDGE DS N', 'DIGITAL SERVICE', 'MARCELA LY', '2017-04-20', '10');
INSERT INTO `cd` VALUES ('330', 'U.IMAGEN REMA', 'DIGITAL SERVICE', 'MARCELA LY', '2017-04-20', '2');
INSERT INTO `cd` VALUES ('331', 'TONER DS NORT', 'DIGITAL SERVICE', 'MARCELA LY', '2017-04-20', '22');
INSERT INTO `cd` VALUES ('332', 'INCORPORACION', 'DIGITAL SERVICE ', 'MARCELA LY', '2017-05-15', '0');
INSERT INTO `cd` VALUES ('333', '17437778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-06-21', '70044');
INSERT INTO `cd` VALUES ('334', '15.690.929-7', 'DIGITAL SERVICE', 'MARCELA', '2017-09-01', '11');
INSERT INTO `cd` VALUES ('335', '17437778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-09-11', '0');
INSERT INTO `cd` VALUES ('336', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-09-11', '0');
INSERT INTO `cd` VALUES ('337', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-09-27', '3');
INSERT INTO `cd` VALUES ('338', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-09-28', '4');
INSERT INTO `cd` VALUES ('339', '.', 'JOSE SALGADO', '.', '2017-10-02', '99496');
INSERT INTO `cd` VALUES ('340', 'INGRESO DE SA', 'DIGITAL SEVICE', 'MARCELA', '2017-10-04', '0');
INSERT INTO `cd` VALUES ('341', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-05', '0');
INSERT INTO `cd` VALUES ('342', 'LABORATORIO', 'DIGITAL SERVICE', 'MARCELA', '2017-10-06', '0');
INSERT INTO `cd` VALUES ('343', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-12', '0');
INSERT INTO `cd` VALUES ('344', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-16', '0');
INSERT INTO `cd` VALUES ('345', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-17', '0');
INSERT INTO `cd` VALUES ('346', '17.723.828-7', 'BROTHER', 'BROTHER', '2017-10-18', '4287');
INSERT INTO `cd` VALUES ('347', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-18', '0');
INSERT INTO `cd` VALUES ('348', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-18', '0');
INSERT INTO `cd` VALUES ('349', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-19', '0');
INSERT INTO `cd` VALUES ('350', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-19', '0');
INSERT INTO `cd` VALUES ('351', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-19', '0');
INSERT INTO `cd` VALUES ('352', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-23', '0');
INSERT INTO `cd` VALUES ('353', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-10-25', '0');
INSERT INTO `cd` VALUES ('354', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-11-08', '0');
INSERT INTO `cd` VALUES ('355', '177238287', 'BROTHER', 'ROSE MARY ', '2017-11-08', '16091');
INSERT INTO `cd` VALUES ('356', '17437778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-11-20', '0');
INSERT INTO `cd` VALUES ('357', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-11-22', '0');
INSERT INTO `cd` VALUES ('358', '15690929', 'DS PRINT', 'MARCELA LY', '2017-11-30', '0');
INSERT INTO `cd` VALUES ('359', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-11-30', '0');
INSERT INTO `cd` VALUES ('360', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-11-30', '0');
INSERT INTO `cd` VALUES ('361', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-04', '0');
INSERT INTO `cd` VALUES ('362', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-07', '0');
INSERT INTO `cd` VALUES ('363', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA ', '2017-12-14', '0');
INSERT INTO `cd` VALUES ('364', '156909297', 'Digital Service', 'MARCELA LY', '2017-12-18', '0');
INSERT INTO `cd` VALUES ('365', '17.723.828-7', 'COMPUTER DESIGN CHIL', 'ROSE MARY', '2017-12-20', '0');
INSERT INTO `cd` VALUES ('366', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-21', '0');
INSERT INTO `cd` VALUES ('367', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-21', '0');
INSERT INTO `cd` VALUES ('368', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-22', '0');
INSERT INTO `cd` VALUES ('369', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-27', '0');
INSERT INTO `cd` VALUES ('370', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-28', '0');
INSERT INTO `cd` VALUES ('371', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2017-12-28', '0');
INSERT INTO `cd` VALUES ('372', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-04', '0');
INSERT INTO `cd` VALUES ('373', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-04', '0');
INSERT INTO `cd` VALUES ('374', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-05', '0');
INSERT INTO `cd` VALUES ('375', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-08', '0');
INSERT INTO `cd` VALUES ('376', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-08', '0');
INSERT INTO `cd` VALUES ('377', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-09', '0');
INSERT INTO `cd` VALUES ('378', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-15', '0');
INSERT INTO `cd` VALUES ('379', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-15', '0');
INSERT INTO `cd` VALUES ('380', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-16', '0');
INSERT INTO `cd` VALUES ('381', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-16', '0');
INSERT INTO `cd` VALUES ('382', '17.437.778-2', 'DIGITAL SERVICE', 'PAMELA', '2018-01-17', '0');
INSERT INTO `cd` VALUES ('383', '156909297', 'DIGITAL SERVICE CC', 'MARCELA', '2018-01-19', '0');
INSERT INTO `cd` VALUES ('384', '177238287', 'PROCAD', 'ROSE MARY CORTES', '2018-01-22', '109800');
INSERT INTO `cd` VALUES ('385', '177238287', 'PROCAD', 'ROSE MARY CORTES', '2018-01-22', '109800');
INSERT INTO `cd` VALUES ('386', '256620693', 'DIGITAL SERVICE CC', 'valentina montes c', '2018-02-05', '0');
INSERT INTO `cd` VALUES ('387', '25.662.069-3', 'DIGITAL SERVICE CC', 'VALENTINA MONTES C', '2018-02-16', '0');
INSERT INTO `cd` VALUES ('388', '25.662.069-3', 'topac toshiba ', 'valentina montes c', '2018-02-19', '0');
INSERT INTO `cd` VALUES ('389', 'TONER', 'BROADSPRECTRUM', 'FAENAS CALAMA', '2018-02-22', '0');
INSERT INTO `cd` VALUES ('390', 'TONER', 'LABORATORIO DE RECAR', 'IGNACIO', '2018-02-22', '0');
INSERT INTO `cd` VALUES ('391', '156909297', 'DIGITAL SERVICE CC', 'MARCELA LY', '2018-04-02', '0');
INSERT INTO `cd` VALUES ('392', 'EPSON', 'DIGITAL SERVICE ', 'REGALO', '2018-04-13', '0');
INSERT INTO `cd` VALUES ('393', '15.690.929-7', 'DIGITAL SERVICE CC', 'Marcela Alejandra Ly', '2018-06-08', '0');
INSERT INTO `cd` VALUES ('394', '7779298-8', 'jose salgado', 'jose salgado', '2018-06-19', '70590');
INSERT INTO `cd` VALUES ('395', '177238287', 'TOPAC', 'GARANTIA', '2018-06-27', '0');
INSERT INTO `cd` VALUES ('396', '76.690.856-K', 'IMP Y EXP ARGENTA CH', 'ROSE CORTES', '2018-06-29', '0');
INSERT INTO `cd` VALUES ('397', '177238287', 'TOPAC', 'ROSE CORTES', '2018-06-29', '0');
INSERT INTO `cd` VALUES ('398', 'MARCELA', 'DIGITAL SERVICE', 'TONER NUEVOS', '2018-09-27', '0');
INSERT INTO `cd` VALUES ('399', 'TONER NUEVOS', 'DIGITAL SERVICE', 'SOUTHERNROCK', '2018-11-26', '0');
INSERT INTO `cd` VALUES ('400', 'DE BROADSPECT', 'DIGITAL SERVICE', 'INGRESO TONER ', '2018-12-14', '0');
INSERT INTO `cd` VALUES ('401', '15.690.929-7', 'DIGITAL SERVICE', 'Marcela Alejandra', '2018-12-28', '0');
INSERT INTO `cd` VALUES ('402', '764642465', 'COMERCIAL IRC CHILE ', 'DEVOLUCION ', '2019-01-09', '0');
INSERT INTO `cd` VALUES ('403', '15.690.929-7', 'Devuelta de Broasdpe', 'Marcela Alejandra Ly', '2019-01-23', '0');
INSERT INTO `cd` VALUES ('404', '15.690.929-7', 'Toner Bueno', 'Marcela Alejandra Ly', '2019-01-23', '0');
INSERT INTO `cd` VALUES ('405', '15.690.929-7', 'BROTHER', 'Marcela Alejandra Ly', '2019-01-24', '0');
INSERT INTO `cd` VALUES ('406', '156909297', 'Gerencia Digital', 'Marcela', '2019-02-19', '0');
INSERT INTO `cd` VALUES ('407', '15.690.929-7', 'DIGITAL SERVICE', 'Marcela Alejandra Ly', '2019-03-13', '0');
INSERT INTO `cd` VALUES ('408', '15.690.929-7', 'DIGITAL SERVICE ', 'Marcela Alejandra', '2019-03-22', '0');
INSERT INTO `cd` VALUES ('409', '15.690.929-7', 'DIGITAL SERVICE INGR', 'MARCELA LY', '2019-03-26', '0');
INSERT INTO `cd` VALUES ('410', '15.690.929-7', 'DIGITAL SERVICE ', 'Marcela Alejandra', '2019-03-27', '0');
INSERT INTO `cd` VALUES ('411', '7858157K', 'BROTHER INTERNATIONA', 'ROSE', '2019-07-02', '17844');
INSERT INTO `cd` VALUES ('412', '156909297', 'DIGITAL SERVICE CC', 'BROADPECTRUM', '2019-07-22', '0');
INSERT INTO `cd` VALUES ('413', '15.690.929-7', 'DIGITAL SERVICE CC', 'Marcela Alejandra Ly', '2019-07-25', '0');
INSERT INTO `cd` VALUES ('414', '15.690.929-7', 'TOPAC', 'DEVOLUCION SIKA', '2019-08-01', '0');
INSERT INTO `cd` VALUES ('415', '15.690.929-7', 'FAM SIERRA GORDA', 'TERMINO CONTRATO', '2019-07-31', '0');
INSERT INTO `cd` VALUES ('416', '15.690.929-7', 'BROADSPECTRUM', 'ANTOFAGASTA', '2019-08-05', '0');
INSERT INTO `cd` VALUES ('417', 'RETIRO MAQUIN', 'SAGITA', 'DEVOLUCION', '2019-09-06', '0');
INSERT INTO `cd` VALUES ('418', '177238287', 'EPSON', 'ROSE', '2019-10-07', '0');
INSERT INTO `cd` VALUES ('419', '177238287', 'EPSON CHILE', 'ROSE MARY ', '2019-11-28', '0');
INSERT INTO `cd` VALUES ('420', '156909297', 'DIGITAL SERVICE', 'MARCELA LY', '2019-12-05', '0');
INSERT INTO `cd` VALUES ('421', '17.723.828-7', 'epson chile', 'rose mary', '2019-12-11', '0');
INSERT INTO `cd` VALUES ('422', '96.800.440-9', 'DISTRIBUIDORA DIAZOL', 'DIAZOL S.A.', '2020-02-13', '172274');
INSERT INTO `cd` VALUES ('423', '761218417', 'DIGITAL SERVICE', '761218417', '2020-06-18', '0');
INSERT INTO `cd` VALUES ('424', '15.690.929-7', 'ILUSTRE MUNICIPALIDA', 'DEVOLUCION POR RETIR', '2020-08-18', '0');
INSERT INTO `cd` VALUES ('425', '177238287', 'Papeles GrÃ¡ficos Ch', 'ROSE ', '2021-01-14', '23980');
INSERT INTO `cd` VALUES ('426', '17.723.828-7', 'Marioly CaamaÃ±o', 'Rose Cortes', '2021-01-14', '7564');
INSERT INTO `cd` VALUES ('427', '15.690.929-7', 'Cobra', 'Retiro de Maquinas', '2021-02-09', '10');
INSERT INTO `cd` VALUES ('428', '15.690.929-7', 'DEVOLUCION POR GARAN', 'Marcela Ly', '2021-03-08', '0');
INSERT INTO `cd` VALUES ('429', '17.723.828-7', 'DSPRINT', 'Rose Cortes', '2021-03-12', '0');
INSERT INTO `cd` VALUES ('430', '76.121.841-7', 'BERLIAM SPA', 'devolucion', '2021-03-18', '0');
INSERT INTO `cd` VALUES ('431', '15.690.929-7', 'DIGITAL SERVICE ', 'Sumar a Inventario', '2021-04-19', '0');
INSERT INTO `cd` VALUES ('432', '15.690.929-7', 'COBRA', 'devolucion', '2021-04-21', '0');
INSERT INTO `cd` VALUES ('433', '15.690.929-7', 'MEDINORT SALUD OCUPA', 'devolucion', '2021-05-07', '0');
INSERT INTO `cd` VALUES ('434', '15.690.929-7', 'chier', 'Retiro de Maquinas', '2021-05-20', '0');
INSERT INTO `cd` VALUES ('435', '15.690.929-7', 'ADEXUS S.A.', 'Devolucion prestamo', '2021-05-31', '0');
INSERT INTO `cd` VALUES ('436', '15.690.929-7', 'MERCOSUR', 'CAMBIO DE MAQUINA', '2021-06-03', '0');
INSERT INTO `cd` VALUES ('437', '17.723.828-7', 'TOPAC CHILE COMERCIA', 'Rose Cortes', '2021-07-02', '0');
INSERT INTO `cd` VALUES ('438', '17.723.828-7', 'INGRAM MICRO CHILE S', 'Rose Cortes', '2021-08-13', '0');
INSERT INTO `cd` VALUES ('439', '15.690.929-7', 'BERLIAM SPA', 'devolucion', '2021-08-18', '0');
INSERT INTO `cd` VALUES ('440', '17.723.828-7', 'BROTHER INTERNACIONA', 'Rose Cortes', '2021-09-13', '0');
INSERT INTO `cd` VALUES ('441', 'SUMAR A INV', 'CSJ Digital Express', 'MARCELA LY', '2021-12-29', '0');
INSERT INTO `cd` VALUES ('442', 'DEVOLUCION TO', 'NETLAND', 'RETIRO MAQUIAS', '2022-01-12', '0');
INSERT INTO `cd` VALUES ('443', 'DEVOLUCION TO', 'NETLAND', 'RETIRO MAQUIAS', '2022-01-12', '0');
INSERT INTO `cd` VALUES ('444', '96.550.470-2', 'USA S.p.A.', 'Rose Cortes', '2022-03-02', '45502');
INSERT INTO `cditems` VALUES ('1', '1', 'CAN-I44', '2', '5000', '1', null);
INSERT INTO `cditems` VALUES ('2', '2', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('3', '2', 'KYO-I11', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('4', '2', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('5', '2', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('6', '2', 'TOS-R51', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('7', '2', 'TOS-R11', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('8', '3', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('9', '3', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('10', '3', 'TOS-R51', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('11', '3', 'TOS-R11', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('12', '3', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('13', '3', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('14', '3', 'RIC-I59', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('15', '3', 'BRO-R65', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('16', '4', 'TOS-R23', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('17', '5', 'BRO-I60', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('18', '6', 'TOS-R114', '3', '3995', '1', null);
INSERT INTO `cditems` VALUES ('19', '7', 'TOS-I45', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('20', '7', 'BRO-I31', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('21', '7', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('22', '7', 'TOS-I37', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('23', '8', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('24', '9', 'WOR-R130', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('25', '9', 'TOS-R129', '9', '0', '1', null);
INSERT INTO `cditems` VALUES ('26', '9', 'TOS-R128', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('27', '10', 'TOS-R116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('28', '11', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('29', '12', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('30', '13', 'WOR-R134', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('31', '14', 'RIC-I59', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('32', '15', 'WOR-R135', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('33', '16', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('34', '16', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('35', '16', 'BRO-I31', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('36', '16', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('37', '16', 'TOS-R23', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('38', '16', 'KYO-I92', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('39', '17', 'ESPECIAL', '8', '6723', '0', 'TALONERIOS DE REPORT DE SERVICIO');
INSERT INTO `cditems` VALUES ('40', '18', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('41', '18', 'MIN-R137', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('42', '18', 'KAT-I99', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('43', '18', 'TOS-R138', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('44', '18', 'LAN-R140', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('45', '18', 'MIN-R141', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('46', '18', 'TOS-R142', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('47', '18', 'MIN-R143', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('48', '18', 'TOS-R145', '11', '0', '1', null);
INSERT INTO `cditems` VALUES ('49', '18', 'MIN-R144', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('50', '19', 'ESPECIAL', '23', '16900', '0', 'Confeccion de equipos de futbol oficina');
INSERT INTO `cditems` VALUES ('51', '20', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('52', '20', 'TOS-R116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('53', '20', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('54', '20', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('55', '21', 'TOS-R49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('56', '21', 'TOS-R8', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('57', '21', 'SAM-I5', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('58', '21', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('59', '21', 'KYO-I12', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('60', '22', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('61', '22', 'TOS-R49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('62', '22', 'SHA-I88', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('63', '23', 'RIC-I96', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('64', '24', 'TOS-I17', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('65', '24', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('66', '24', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('67', '24', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('68', '25', 'RIC-I96', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('69', '26', 'TOS-I72', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('70', '26', 'TOS-I73', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('71', '26', 'TOS-I74', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('72', '27', 'TOS-R172', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('73', '27', 'TOS-R171', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('74', '27', 'RIC-R146', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('75', '27', 'RIC-R149', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('76', '27', 'RIC-R158', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('77', '27', 'RIC-R148', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('78', '27', 'RIC-R3', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('79', '27', 'RIC-R154', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('80', '27', 'RIC-R152', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('81', '27', 'RIC-R175', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('82', '27', 'RIC-R155', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('83', '27', 'RIC-R151', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('84', '27', 'TOS-R122', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('85', '28', 'TOS-R182', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('86', '28', 'XER-R181', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('87', '28', 'XER-R75', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('88', '28', 'XER-R180', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('89', '28', 'XER-R179', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('90', '28', 'XER-R178', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('91', '28', 'WOR-R134', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('92', '28', 'WOR-R135', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('93', '28', 'XER-R177', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('94', '28', 'RIC-R176', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('95', '29', 'RIC-I7', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('96', '29', 'RIC-I95', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('97', '29', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('98', '30', 'RIC-I7', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('99', '31', 'RIC-I7', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('100', '32', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('101', '32', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('102', '33', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('103', '34', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('104', '34', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('105', '34', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('106', '34', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('107', '34', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('108', '34', 'TOS-R122', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('109', '35', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('110', '35', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('111', '35', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('112', '35', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('113', '35', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('114', '35', 'TOS-R122', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('127', '36', 'TOS-R189', '1', '39924', '1', null);
INSERT INTO `cditems` VALUES ('128', '37', 'WOR-R130', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('129', '38', 'TOS-I37', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('130', '39', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('131', '39', 'RIC-I104', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('132', '39', 'RIC-I59', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('133', '40', 'TOS-I37', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('134', '40', 'BRO-R65', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('135', '41', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('136', '41', 'TOS-I17', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('137', '41', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('138', '41', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('139', '41', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('140', '42', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('141', '42', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('142', '42', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('143', '42', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('144', '43', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('145', '43', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('146', '43', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('147', '43', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('148', '43', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('149', '44', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('150', '45', 'TOS-R47', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('151', '46', 'RIC-I59', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('152', '47', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('153', '47', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('154', '47', 'RIC-I104', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('155', '48', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('156', '49', 'RIS-I55', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('157', '50', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('158', '51', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('159', '51', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('160', '51', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('161', '51', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('162', '52', 'BRO-I31', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('163', '53', 'RIC-I59', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('164', '53', 'RIC-I49', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('165', '54', 'TOS-R47', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('166', '55', 'XER-I111', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('167', '56', 'BRO-I109', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('168', '56', 'BRO-I110', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('169', '57', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('170', '57', 'SHA-R61', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('171', '58', 'BRO-I110', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('172', '59', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('173', '60', 'BRO-I110', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('174', '60', 'BRO-I109', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('175', '61', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('176', '61', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('177', '61', 'WOR-R130', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('178', '62', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('179', '63', 'XER-I111', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('180', '64', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('181', '64', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('182', '64', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('183', '64', 'TOS-I35', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('184', '65', 'RIC-I49', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('185', '65', 'RIC-I104', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('186', '66', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('187', '66', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('188', '66', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('189', '66', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('190', '66', 'TOS-R116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('191', '66', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('192', '67', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('193', '68', 'WOR-I114', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('194', '68', 'XER-R71', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('195', '69', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('196', '69', 'WOR-R130', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('197', '70', 'TOS-R122', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('198', '71', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('199', '71', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('200', '71', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('201', '71', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('202', '71', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('203', '71', 'WOR-I114', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('204', '71', 'XER-R71', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('205', '72', 'TOS-I35', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('206', '73', 'BRO-R132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('207', '73', 'WOR-R130', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('208', '73', 'WOR-R131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('209', '73', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('210', '73', 'TOS-I37', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('211', '73', 'TOS-I45', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('212', '74', 'TOS-I34', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('213', '75', 'RIS-I47', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('214', '76', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('215', '77', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('216', '78', 'TOS-I17', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('217', '78', 'KYO-I11', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('218', '78', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('219', '78', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('220', '78', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('221', '78', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('222', '78', 'TOS-I35', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('223', '78', 'KYO-R208', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('224', '78', 'BRO-R132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('225', '78', 'KYO-R205', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('226', '78', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('227', '78', 'TOS-R116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('228', '78', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('229', '78', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('230', '79', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('231', '80', 'RIC-I103', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('232', '81', 'TOS-I17', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('233', '81', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('234', '82', 'BRO-I109', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('235', '82', 'BRO-I110', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('236', '83', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('237', '84', 'TOS-I37', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('238', '84', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('239', '84', 'TOS-I17', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('240', '84', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('241', '84', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('242', '84', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('243', '84', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('244', '84', 'SHA-R7', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('245', '84', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('246', '85', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('247', '85', 'TOS-R8', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('248', '85', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('249', '86', 'XER-I111', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('250', '86', 'BRO-I109', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('251', '87', 'BRO-I60', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('252', '88', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('253', '88', 'TOS-R122', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('254', '88', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('255', '89', 'TOS-R142', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('256', '89', 'RIC-I62', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('257', '89', 'TOS-R101', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('258', '89', 'TOS-R53', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('259', '89', 'RIC-R125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('260', '90', 'XER-R66', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('261', '91', 'RIS-I91', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('262', '92', 'BRO-I110', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('263', '93', 'BRO-I109', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('264', '94', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('265', '95', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('266', '95', 'TOS-I45', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('267', '96', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('268', '97', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('269', '98', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('270', '98', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('271', '99', 'TOS-R227', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('272', '99', 'TOS-R232', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('273', '100', 'TOS-I18', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('274', '100', 'TOS-I19', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('275', '100', 'TOS-I20', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('276', '100', 'RIC-I58', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('277', '100', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('278', '100', 'TOS-I34', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('279', '101', 'RIC-R265', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('280', '101', 'RIC-R266', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('281', '102', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('282', '103', 'BRO-I109', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('283', '104', 'TOS-R122', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('284', '104', 'BRO-I109', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('285', '104', 'BRO-I117', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('286', '105', 'TOS-R21', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('287', '106', 'TOS-I17', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('288', '107', 'TOS-R309', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('289', '108', 'TOS-I115', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('290', '108', 'TOS-I116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('291', '108', 'TOS-R243', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('292', '109', 'BRO-I109', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('293', '110', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('294', '111', 'TOS-I37', '1', '10000', '1', null);
INSERT INTO `cditems` VALUES ('295', '111', 'BRO-I126', '1', '21900', '1', null);
INSERT INTO `cditems` VALUES ('296', '111', 'BRO-I124', '1', '21900', '1', null);
INSERT INTO `cditems` VALUES ('297', '111', 'BRO-I125', '1', '21900', '1', null);
INSERT INTO `cditems` VALUES ('298', '111', 'TOS-R122', '1', '20000', '1', null);
INSERT INTO `cditems` VALUES ('299', '112', 'TOS-I115', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('300', '112', 'TOS-R243', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('301', '112', 'TOS-I116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('302', '113', 'BRO-I109', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('303', '114', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('304', '115', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('305', '116', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('306', '117', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('307', '118', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('308', '119', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('309', '120', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('310', '121', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('311', '122', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('312', '123', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('313', '124', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('314', '124', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('315', '124', 'RIC-I59', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('316', '125', 'RIC-I59', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('317', '126', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('318', '127', 'TOS-I37', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('319', '128', 'BRO-R278', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('320', '128', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('321', '129', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('322', '130', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('323', '131', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('324', '131', 'HP-I152', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('325', '131', 'BRO-R184', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('326', '131', 'BRO-I129', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('327', '131', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('328', '131', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('329', '131', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('330', '131', 'BRO-I102', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('331', '132', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('332', '133', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('333', '133', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('334', '133', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('335', '133', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('336', '134', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('337', '134', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('338', '135', 'BRO-I188', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('339', '135', 'BRO-I189', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('340', '135', 'BRO-I190', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('341', '136', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('342', '136', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('343', '137', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('344', '137', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('345', '137', 'TOS-R389', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('346', '138', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('347', '138', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('348', '138', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('349', '138', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('350', '138', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('351', '139', 'TOS-I165', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('352', '139', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('353', '139', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('354', '139', 'RIC-I58', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('355', '140', 'BRO-R380', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('356', '141', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('357', '141', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('358', '141', 'BRO-I102', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('359', '141', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('360', '141', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('361', '142', 'SAM-I5', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('362', '142', 'BRO-I31', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('363', '142', 'SHA-I1', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('364', '142', 'SHA-I67', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('365', '143', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('366', '143', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('367', '143', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('368', '143', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('369', '143', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('370', '143', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('371', '143', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('372', '144', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('373', '144', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('374', '144', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('375', '144', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('376', '144', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('377', '145', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('378', '145', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('379', '145', 'RIC-I59', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('380', '145', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('381', '145', 'TOS-I192', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('382', '146', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('383', '146', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('384', '146', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('385', '146', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('386', '146', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('387', '147', 'BRO-R433', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('388', '148', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('389', '149', 'TOS-R434', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('390', '149', 'TOS-I202', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('391', '149', 'TOS-R435', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('392', '149', 'TOS-R436', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('393', '149', 'TOS-R437', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('394', '149', 'TOS-R438', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('395', '149', 'TOS-R439', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('396', '149', 'TOS-R440', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('397', '149', 'TOS-R267', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('398', '149', 'TOS-R405', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('399', '150', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('400', '151', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('401', '152', 'BRO-R441', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('402', '153', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('403', '154', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('404', '154', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('405', '154', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('406', '154', 'KYO-R187', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('407', '154', 'KYO-R257', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('408', '155', 'TOS-I37', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('409', '156', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('410', '157', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('411', '158', 'BRO-I154', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('412', '159', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('413', '160', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('414', '160', 'BRO-R170', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('415', '161', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('416', '162', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('417', '162', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('418', '162', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('419', '162', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('420', '162', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('421', '163', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('422', '164', 'RIC-R462', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('423', '164', 'TOS-R256', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('424', '164', 'TOS-I174', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('425', '164', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('426', '164', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('427', '164', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('428', '165', 'TOS-I35', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('429', '166', 'BRO-R170', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('430', '167', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('431', '167', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('432', '167', 'TOS-I36', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('433', '167', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('434', '168', 'TOS-R389', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('435', '169', 'BRO-R380', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('436', '169', 'BRO-R469', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('437', '170', 'BRO-I31', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('438', '171', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('439', '171', 'BRO-R79', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('440', '172', 'HP-I152', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('441', '173', 'BRO-I207', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('442', '174', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('443', '174', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('444', '174', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('445', '174', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('446', '174', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('447', '174', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('448', '174', 'BRO-R132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('449', '175', 'BRO-R472', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('450', '176', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('451', '177', 'BRO-I102', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('452', '178', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('453', '178', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('454', '178', 'RIC-R78', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('455', '179', 'TOS-R389', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('456', '180', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('457', '181', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('458', '181', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('459', '181', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('460', '182', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('461', '183', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('462', '184', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('463', '185', 'TOS-R476', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('464', '185', 'TOS-R477', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('465', '185', 'TOS-R478', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('466', '185', 'TOS-R479', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('467', '185', 'TOS-R405', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('468', '185', 'TOS-R480', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('469', '185', 'TOS-R482', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('470', '186', 'TOS-R483', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('471', '186', 'TOS-R101', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('472', '186', 'TOS-R16', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('473', '186', 'TOS-R44', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('474', '187', 'BRO-I117', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('475', '187', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('476', '188', 'TOS-R477', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('477', '188', 'TOS-R478', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('478', '188', 'TOS-R479', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('479', '188', 'TOS-R482', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('480', '189', 'TOS-R145', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('481', '190', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('482', '190', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('483', '190', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('484', '190', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('485', '190', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('486', '191', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('487', '192', 'BRO-R397', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('488', '192', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('489', '192', 'BRO-R380', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('490', '192', 'TOS-I175', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('491', '192', 'TOS-I176', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('492', '193', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('493', '194', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('494', '195', 'TOS-R477', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('495', '195', 'BRO-R415', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('496', '195', 'RIC-I104', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('497', '195', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('498', '195', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('499', '196', 'RIC-I103', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('500', '197', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('501', '197', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('502', '198', 'TOS-R145', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('503', '199', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('504', '200', 'BRO-I178', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('505', '201', 'TOS-R145', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('506', '201', 'TOS-I165', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('507', '202', 'BRO-R473', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('508', '203', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('509', '203', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('510', '204', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('511', '205', 'TOS-R145', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('512', '206', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('513', '206', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('514', '207', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('515', '208', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('516', '208', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('517', '208', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('518', '208', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('519', '209', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('520', '209', 'BRO-I129', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('521', '209', 'BRO-I156', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('522', '209', 'BRO-I157', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('523', '209', 'BRO-R132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('524', '209', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('525', '209', 'KYO-I12', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('526', '209', 'KYO-I93', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('527', '209', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('528', '209', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('529', '209', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('530', '209', 'TOS-I17', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('531', '209', 'TOS-I18', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('532', '209', 'TOS-I19', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('533', '209', 'TOS-I20', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('534', '210', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('535', '210', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('536', '210', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('537', '210', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('538', '210', 'TOS-I174', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('539', '210', 'TOS-I175', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('540', '210', 'TOS-I176', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('541', '210', 'TOS-I177', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('542', '211', 'TOS-R307', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('543', '211', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('544', '212', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('545', '212', 'RIS-I91', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('546', '213', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('547', '213', 'TOS-I45', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('548', '213', 'BRO-I123', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('549', '213', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('550', '213', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('551', '213', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('552', '214', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('553', '214', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('554', '214', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('555', '214', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('556', '214', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('557', '214', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('558', '214', 'RIC-I59', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('559', '214', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('560', '215', 'BRO-R132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('561', '216', 'TOS-I164', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('562', '217', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('563', '218', 'TOS-R389', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('564', '219', 'BRO-I129', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('565', '219', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('566', '219', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('567', '219', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('568', '220', 'RIS-I90', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('569', '221', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('570', '221', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('571', '222', 'BRO-I129', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('572', '222', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('573', '222', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('574', '222', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('575', '223', 'BRO-I143', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('576', '223', 'BRO-I144', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('577', '223', 'BRO-I145', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('578', '223', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('579', '223', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('580', '223', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('581', '224', 'RIS-I90', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('582', '225', 'BRO-I154', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('583', '225', 'BRO-I155', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('584', '225', 'BRO-I156', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('585', '225', 'BRO-I157', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('586', '225', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('587', '225', 'RIS-I90', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('588', '225', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('589', '225', 'RIS-I147', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('590', '226', 'BRO-R346', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('591', '227', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('592', '228', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('593', '228', 'RIC-I103', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('594', '229', 'BRO-I219', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('595', '229', 'BRO-I220', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('596', '230', 'BRO-I129', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('597', '230', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('598', '230', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('599', '230', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('600', '231', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('601', '232', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('602', '233', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('603', '234', 'TOS-R434', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('604', '234', 'TOS-R506', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('605', '234', 'BRO-I144', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('606', '235', 'TOS-I183', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('607', '236', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('608', '236', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('609', '237', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('610', '237', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('611', '237', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('612', '237', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('613', '237', 'TOS-I116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('614', '237', 'TOS-R243', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('615', '237', 'TOS-I115', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('616', '238', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('617', '239', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('618', '240', 'BRO-R380', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('619', '241', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('620', '242', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('621', '243', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('622', '243', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('623', '243', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('624', '243', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('625', '244', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('626', '244', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('627', '244', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('628', '244', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('629', '245', 'BRO-R362', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('630', '246', 'BRO-R65', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('631', '247', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('632', '247', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('633', '247', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('634', '247', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('635', '248', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('636', '249', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('637', '249', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('638', '249', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('639', '249', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('640', '250', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('641', '250', 'BRO-I102', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('642', '250', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('643', '250', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('644', '251', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('645', '251', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('646', '251', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('647', '251', 'RIS-I147', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('648', '252', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('649', '252', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('650', '252', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('651', '252', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('652', '252', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('653', '253', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('654', '253', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('655', '253', 'TOS-I164', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('656', '253', 'TOS-I34', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('657', '253', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('658', '253', 'RIS-I91', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('659', '254', 'BRO-R362', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('660', '254', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('661', '254', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('662', '254', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('663', '254', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('664', '254', 'TOS-R417', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('665', '254', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('666', '255', 'TOS-I183', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('667', '255', 'TOS-R442', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('668', '255', 'TOS-R443', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('669', '255', 'TOS-R463', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('670', '256', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('671', '257', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('672', '258', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('673', '258', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('674', '258', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('675', '259', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('676', '259', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('677', '260', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('678', '261', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('679', '262', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('680', '263', 'BRO-I102', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('681', '263', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('682', '263', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('683', '263', 'KYO-I170', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('684', '264', 'TOS-R307', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('685', '264', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('686', '264', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('687', '265', 'BRO-I157', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('688', '265', 'BRO-I156', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('689', '265', 'BRO-I155', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('690', '265', 'BRO-I154', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('691', '265', 'BRO-I123', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('692', '265', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('693', '265', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('694', '266', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('695', '266', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('696', '266', 'TOS-R110', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('697', '266', 'BRO-R472', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('698', '267', 'TOS-R307', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('699', '268', 'BRO-I224', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('700', '269', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('701', '269', 'BRO-R486', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('702', '270', 'BRO-R472', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('703', '270', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('704', '270', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('705', '270', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('706', '270', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('707', '270', 'RIS-I91', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('708', '271', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('709', '271', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('710', '271', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('711', '271', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('712', '271', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('713', '271', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('714', '271', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('715', '271', 'BRO-I154', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('716', '271', 'BRO-I155', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('717', '271', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('718', '271', 'BRO-I157', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('719', '272', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('720', '273', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('721', '273', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('722', '273', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('723', '273', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('724', '273', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('725', '274', 'TOS-R129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('726', '274', 'TOS-R238', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('727', '275', 'BRO-R411', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('728', '275', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('729', '276', 'TOS-R438', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('730', '276', 'TOS-R439', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('731', '277', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('732', '277', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('733', '277', 'BRO-R347', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('734', '277', 'RIC-I103', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('735', '278', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('736', '278', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('737', '278', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('738', '278', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('739', '278', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('740', '279', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('741', '279', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('742', '279', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('743', '279', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('744', '279', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('745', '280', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('746', '281', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('747', '281', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('748', '282', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('749', '282', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('750', '282', 'RIC-I49', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('751', '283', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('752', '284', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('753', '284', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('754', '284', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('755', '284', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('756', '284', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('757', '285', 'BRO-R79', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('758', '285', 'TOS-I174', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('759', '286', 'BRO-R448', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('760', '287', 'TOS-R399', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('761', '288', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('762', '288', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('763', '288', 'TOS-R418', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('764', '288', 'TOS-R419', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('765', '288', 'TOS-R420', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('766', '289', 'BRO-I131', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('767', '289', 'BRO-I132', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('768', '289', 'BRO-I133', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('769', '290', 'TOS-R16', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('770', '291', 'TOS-R463', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('771', '292', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('772', '293', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('773', '293', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('774', '293', 'BRO-I129', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('775', '293', 'BRO-R170', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('776', '294', 'TOS-R499', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('777', '295', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('778', '295', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('779', '295', 'BRO-R132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('780', '295', 'BRO-R170', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('781', '295', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('782', '295', 'BRO-R411', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('783', '295', 'BRO-R65', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('784', '295', 'RIC-I103', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('785', '295', 'RIC-I49', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('786', '296', 'BRO-R362', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('787', '296', 'BRO-R411', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('788', '296', 'TOS-I35', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('789', '296', 'TOS-R444', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('790', '297', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('791', '297', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('792', '297', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('793', '297', 'BRO-I155', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('794', '298', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('795', '298', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('796', '299', 'TOS-R442', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('797', '299', 'TOS-R443', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('798', '300', 'BRO-R362', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('799', '300', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('800', '300', 'BRO-I154', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('801', '300', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('802', '301', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('803', '301', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('804', '301', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('805', '301', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('806', '301', 'RIC-I103', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('807', '302', 'BRO-I219', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('808', '302', 'RIS-I147', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('809', '303', 'ESPECIAL', '1', '20500', '0', 'kit de cilindro y cuchilla canon ir1022');
INSERT INTO `cditems` VALUES ('810', '304', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('811', '304', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('812', '304', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('813', '304', 'BRO-R362', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('814', '304', 'BRO-R397', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('815', '304', 'BRO-R411', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('816', '305', 'RIC-I59', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('817', '305', 'BRO-R523', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('818', '305', 'BRO-R362', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('819', '305', 'TOS-R16', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('820', '305', 'TOS-R53', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('821', '305', 'TOS-R9', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('822', '305', 'BRO-R451', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('823', '306', 'RIC-I49', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('824', '307', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('825', '307', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('826', '307', 'BRO-R362', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('827', '307', 'TOS-R445', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('828', '307', 'TOS-R446', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('829', '307', 'TOS-R447', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('830', '308', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('831', '309', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('832', '309', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('833', '310', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('834', '310', 'BRO-R362', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('835', '310', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('836', '310', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('837', '310', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('838', '311', 'BRO-R362', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('839', '311', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('840', '312', 'BRO-I102', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('841', '312', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('842', '313', 'BRO-R411', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('843', '314', 'BRO-R551', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('844', '315', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('845', '316', 'BRO-R362', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('846', '317', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('847', '317', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('848', '317', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('849', '317', 'BRO-I102', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('850', '317', 'BRO-I155', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('851', '317', 'BRO-I156', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('852', '317', 'BRO-I157', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('853', '317', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('854', '317', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('855', '317', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('856', '317', 'BRO-R397', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('857', '317', 'TOS-R548', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('858', '318', 'TOS-R548', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('859', '318', 'BRO-I129', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('860', '318', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('861', '318', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('862', '318', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('863', '318', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('864', '318', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('865', '318', 'BRO-R347', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('866', '318', 'TOS-R499', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('867', '319', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('868', '319', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('869', '319', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('870', '319', 'HP-I212', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('871', '320', 'TOS-R419', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('872', '320', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('873', '320', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('874', '320', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('875', '321', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('876', '321', 'BRO-I102', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('877', '321', 'BRO-R65', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('878', '322', 'BRO-R362', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('879', '322', 'TOS-I249', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('880', '323', 'BRO-R565', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('881', '323', 'CAN-R373', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('882', '323', 'TOS-R399', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('883', '323', 'TOS-R442', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('884', '323', 'TOS-R443', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('885', '323', 'TOS-I194', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('886', '324', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('887', '324', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('888', '324', 'BRO-I102', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('889', '324', 'BRO-R347', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('890', '324', 'TOS-I175', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('891', '324', 'RIC-I49', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('892', '324', 'RIC-I103', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('893', '324', 'BRO-R411', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('894', '324', 'BRO-R397', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('895', '324', 'BRO-I220', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('896', '324', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('897', '325', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('898', '325', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('899', '325', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('900', '325', 'TOS-I116', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('901', '325', 'TOS-R243', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('902', '326', 'TOS-R405', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('903', '326', 'BRO-I216', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('904', '326', 'BRO-R507', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('905', '327', 'RIS-I90', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('906', '327', 'RIS-I91', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('907', '327', 'BRO-I220', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('908', '327', 'TOS-I164', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('909', '328', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('910', '329', 'BRO-I224', '10', '1', '1', null);
INSERT INTO `cditems` VALUES ('911', '330', 'BRO-R529', '2', '1', '1', null);
INSERT INTO `cditems` VALUES ('912', '331', 'BRO-I228', '12', '1', '1', null);
INSERT INTO `cditems` VALUES ('913', '331', 'BRO-I227', '9', '1', '1', null);
INSERT INTO `cditems` VALUES ('914', '331', 'BRO-I226', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('915', '332', 'BRO-I131', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('916', '332', 'BRO-I132', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('917', '332', 'BRO-I133', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('918', '333', 'BRO-I229', '4', '17511', '1', null);
INSERT INTO `cditems` VALUES ('919', '334', 'RIS-I90', '9', '1', '1', null);
INSERT INTO `cditems` VALUES ('920', '334', 'RIS-I91', '2', '1', '1', null);
INSERT INTO `cditems` VALUES ('921', '335', 'RIS-I91', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('922', '335', 'RIS-I90', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('923', '335', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('924', '336', 'TOS-R515', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('925', '337', 'TOS-I165', '1', '3', '1', null);
INSERT INTO `cditems` VALUES ('926', '338', 'RIC-I49', '3', '1', '1', null);
INSERT INTO `cditems` VALUES ('927', '338', 'RIC-I59', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('928', '339', 'TOS-R619', '8', '12437', '1', null);
INSERT INTO `cditems` VALUES ('929', '340', 'BRO-I239', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('930', '340', 'BRO-I241', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('931', '340', 'BRO-I240', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('932', '340', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('933', '340', 'BRO-I300', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('934', '340', 'BRO-I228', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('935', '340', 'BRO-I224', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('936', '341', 'RIC-I103', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('937', '342', 'BRO-I227', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('938', '343', 'BRO-I224', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('939', '344', 'BRO-I224', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('940', '345', 'BRO-R530', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('941', '346', 'BRO-R620', '3', '1429', '1', null);
INSERT INTO `cditems` VALUES ('942', '347', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('943', '348', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('944', '349', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('945', '350', 'BRO-I224', '9', '0', '1', null);
INSERT INTO `cditems` VALUES ('946', '351', 'BRO-I228', '11', '0', '1', null);
INSERT INTO `cditems` VALUES ('947', '352', 'BRO-I228', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('948', '352', 'BRO-I224', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('949', '353', 'BRO-I228', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('950', '354', 'EPS-I302', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('951', '354', 'EPS-I303', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('952', '354', 'EPS-I304', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('953', '354', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('954', '355', 'BRO-R621', '1', '16091', '1', null);
INSERT INTO `cditems` VALUES ('955', '356', 'EPS-I302', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('956', '356', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('957', '357', 'BRO-I224', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('958', '358', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('959', '359', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('960', '360', 'BRO-I315', '15', '0', '1', null);
INSERT INTO `cditems` VALUES ('961', '360', 'BRO-I224', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('962', '361', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('963', '361', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('964', '361', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('965', '362', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('966', '363', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('967', '364', 'BRO-I224', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('968', '364', 'BRO-I315', '12', '0', '1', null);
INSERT INTO `cditems` VALUES ('969', '365', 'HP-I260', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('970', '365', 'HP-I261', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('971', '365', 'HP-I262', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('972', '365', 'HP-I263', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('973', '366', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('974', '366', 'BRO-I247', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('975', '367', 'BRO-I131', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('976', '367', 'BRO-I132', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('977', '367', 'BRO-I133', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('978', '368', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('979', '369', 'BRO-R529', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('980', '370', 'TOS-I177', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('981', '371', 'BRO-R529', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('982', '372', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('983', '373', 'TOS-R499', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('984', '374', 'BRO-R529', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('985', '375', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('986', '376', 'BRO-I224', '13', '0', '1', null);
INSERT INTO `cditems` VALUES ('987', '376', 'BRO-I315', '8', '0', '1', null);
INSERT INTO `cditems` VALUES ('988', '377', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('989', '377', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('990', '378', 'BRO-R529', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('991', '379', 'BRO-R529', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('992', '380', 'BRO-R529', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('993', '381', 'BRO-R582', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('994', '382', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('995', '383', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('996', '384', 'SIN-I477', '2', '54900', '1', null);
INSERT INTO `cditems` VALUES ('997', '385', 'EPS-R636', '2', '54900', '1', null);
INSERT INTO `cditems` VALUES ('998', '386', 'BRO-I224', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('999', '386', 'BRO-I315', '8', '0', '1', null);
INSERT INTO `cditems` VALUES ('1000', '387', 'BRO-R529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1001', '388', 'TOS-R419', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1002', '389', 'BRO-I123', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1003', '389', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1004', '389', 'BRO-I124', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1005', '389', 'BRO-I125', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('1006', '389', 'BRO-I220', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1007', '389', 'BRO-I117', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1008', '389', 'BRO-I102', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1009', '389', 'BRO-I219', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1010', '390', 'BRO-I316', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1011', '390', 'BRO-I315', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('1012', '391', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1013', '391', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1014', '391', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1015', '391', 'BRO-I126', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1016', '392', 'EPS-I527', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1017', '392', 'EPS-I528', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1018', '392', 'EPS-I529', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1019', '392', 'EPS-I530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1020', '393', 'EPS-I302', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1021', '393', 'EPS-I303', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1022', '393', 'EPS-I304', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1023', '393', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1024', '393', 'BRO-I219', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1025', '393', 'BRO-I220', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1026', '393', 'BRO-I117', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1027', '393', 'BRO-I270', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1028', '394', 'TOS-R619', '5', '14118', '1', null);
INSERT INTO `cditems` VALUES ('1029', '395', 'TOS-R648', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1030', '396', 'SIN-I477', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('1031', '397', 'TOS-R418', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1032', '397', 'TOS-R419', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1033', '397', 'TOS-R420', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1034', '398', 'BRO-I124', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1035', '398', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1036', '398', 'BRO-I220', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1037', '398', 'BRO-I123', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1038', '398', 'BRO-I515', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1039', '398', 'BRO-I514', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1040', '398', 'BRO-I125', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1041', '398', 'BRO-I513', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1042', '398', 'BRO-I536', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1043', '398', 'BRO-I247', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1044', '399', 'BRO-I123', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1045', '399', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1046', '399', 'BRO-I125', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1047', '399', 'BRO-I126', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1048', '400', 'BRO-I220', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1049', '400', 'BRO-I549', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1050', '400', 'BRO-I556', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1051', '400', 'BRO-I536', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1052', '400', 'BRO-I547', '5', '0', '1', null);
INSERT INTO `cditems` VALUES ('1053', '400', 'BRO-I548', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1054', '400', 'BRO-I554', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1055', '400', 'TOS-I112', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1056', '400', 'BRO-R530', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1057', '401', 'BRO-I220', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1058', '402', 'BRO-I433', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1059', '402', 'BRO-I434', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1060', '402', 'BRO-I435', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1061', '402', 'BRO-I436', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1062', '402', 'BRO-I536', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1063', '403', 'BRO-I433', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1064', '403', 'BRO-I434', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1065', '403', 'BRO-I435', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1066', '403', 'BRO-I436', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1067', '404', 'TOS-I164', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1068', '406', 'BRO-I549', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1069', '406', 'BRO-I548', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1070', '406', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1071', '406', 'BRO-I435', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1072', '406', 'BRO-I554', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1073', '406', 'BRO-I124', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1074', '406', 'BRO-I434', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1075', '406', 'BRO-I536', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1076', '407', 'EPS-I302', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1077', '408', 'BRO-I220', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1078', '408', 'BRO-I123', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1079', '408', 'BRO-I549', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1080', '408', 'BRO-I436', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1081', '409', 'BRO-I277', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1082', '410', 'TOS-I153', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1083', '411', 'BRO-R721', '2', '8922', '1', null);
INSERT INTO `cditems` VALUES ('1084', '412', 'BRO-I220', '11', '0', '1', null);
INSERT INTO `cditems` VALUES ('1085', '413', 'BRO-I247', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1086', '413', 'BRO-I633', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1087', '414', 'TOS-R417', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1088', '414', 'TOS-R418', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1089', '414', 'TOS-R419', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1090', '414', 'TOS-R420', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1091', '415', 'BRO-I547', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1092', '415', 'BRO-I548', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1093', '415', 'BRO-I549', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1094', '415', 'BRO-I536', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1095', '416', 'TOS-I165', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1096', '416', 'TOS-I235', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1097', '416', 'BRO-I231', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1098', '416', 'BRO-I117', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1099', '417', 'BRO-I547', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1100', '417', 'BRO-I703', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1101', '417', 'BRO-I701', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1102', '417', 'BRO-I702', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1103', '418', 'EPS-R640', '10', '0', '1', null);
INSERT INTO `cditems` VALUES ('1104', '419', 'EPS-I303', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1105', '419', 'EPS-I304', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1106', '419', 'EPS-I305', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1107', '420', 'BRO-I433', '12', '0', '1', null);
INSERT INTO `cditems` VALUES ('1108', '420', 'BRO-I434', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1109', '420', 'BRO-I435', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1110', '420', 'BRO-I436', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1111', '421', 'EPS-I302', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1112', '421', 'EPS-I303', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1113', '421', 'EPS-I304', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1114', '421', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1115', '422', 'DIA-I750', '2', '86137', '1', null);
INSERT INTO `cditems` VALUES ('1116', '423', 'DEU-I764', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1117', '424', 'RIC-I59', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('1118', '424', 'RIC-I286', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1119', '424', 'BRO-I633', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1120', '425', 'GEN-I854', '2', '11990', '1', null);
INSERT INTO `cditems` VALUES ('1121', '426', 'DEU-I857', '2', '3782', '1', null);
INSERT INTO `cditems` VALUES ('1122', '427', 'TOS-I568', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1123', '427', 'TOS-I569', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1124', '427', 'TOS-I570', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1125', '427', 'TOS-I571', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1126', '427', 'TOS-I256', '2', '1', '1', null);
INSERT INTO `cditems` VALUES ('1127', '427', 'TOS-I257', '2', '1', '1', null);
INSERT INTO `cditems` VALUES ('1128', '427', 'TOS-I255', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1129', '427', 'TOS-I258', '1', '1', '1', null);
INSERT INTO `cditems` VALUES ('1130', '428', 'BRO-R725', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1131', '428', 'KYO-R808', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1132', '429', 'TOS-R873', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1133', '430', 'BRO-I633', '6', '0', '1', null);
INSERT INTO `cditems` VALUES ('1134', '430', 'BRO-I220', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1135', '430', 'BRO-I129', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1136', '430', 'BRO-I703', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1137', '430', 'BRO-I435', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1138', '430', 'BRO-I644', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1139', '431', 'EPS-R842', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1140', '431', 'TOS-I289', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1141', '431', 'TOS-R680', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1142', '431', 'BRO-R644', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1143', '431', 'EPS-I663', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1144', '431', 'HP-I261', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1145', '431', 'KYO-I647', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1146', '431', 'EPS-R782', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1147', '431', 'TOS-R478', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1148', '432', 'TOS-I731', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1149', '432', 'TOS-I734', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1150', '432', 'TOS-I732', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1151', '432', 'TOS-I733', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1152', '432', 'TOS-I753', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1153', '433', 'BRO-I700', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1154', '433', 'BRO-I702', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1155', '433', 'BRO-I703', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1156', '434', 'EPS-I304', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1157', '434', 'EPS-I303', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1158', '434', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1159', '434', 'EPS-I302', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1160', '435', 'EPS-I302', '4', '0', '1', null);
INSERT INTO `cditems` VALUES ('1161', '435', 'EPS-R640', '3', '0', '1', null);
INSERT INTO `cditems` VALUES ('1162', '436', 'BRO-I270', '7', '0', '1', null);
INSERT INTO `cditems` VALUES ('1163', '437', 'TOS-I653', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1164', '438', 'EPS-R693', '15', '0', '1', null);
INSERT INTO `cditems` VALUES ('1165', '439', 'BRO-I833', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1166', '439', 'BRO-I834', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1167', '439', 'BRO-I835', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1168', '439', 'BRO-I836', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1169', '439', 'EPS-I840', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1170', '439', 'KAT-I874', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1171', '440', 'BRO-R965', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1172', '441', 'EPS-I305', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1173', '441', 'EPS-I304', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1174', '441', 'BRO-I700', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1175', '441', 'BRO-I702', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1176', '441', 'BRO-I739', '2', '0', '1', null);
INSERT INTO `cditems` VALUES ('1177', '442', 'BRO-I739', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1178', '443', 'BRO-I739', '1', '0', '1', null);
INSERT INTO `cditems` VALUES ('1179', '444', 'GEN-I966', '2', '22751', '1', null);
INSERT INTO `centrocosto` VALUES ('1', 'Centro Copiado', 'CC1');
INSERT INTO `centrocosto` VALUES ('2', 'Venta de Equipos', 'CC2');
INSERT INTO `centrocosto` VALUES ('3', 'Venta de Suministros e Insumos', 'CC3');
INSERT INTO `centrocosto` VALUES ('4', 'Arriendo de Equipos', 'CC4');
INSERT INTO `centrocosto` VALUES ('5', 'Servicio Técnico', 'CC5');
INSERT INTO `centrocosto` VALUES ('6', 'Administración', 'CC6');
INSERT INTO `centrocosto` VALUES ('7', 'Gerencia', 'CC7');
INSERT INTO `centrocosto` VALUES ('8', 'Sin Centro de Costo', 'CC8');
INSERT INTO `centrocosto` VALUES ('9', 'Laboratorio', 'CC9');
INSERT INTO `centrocosto` VALUES ('0', 'Sin Centro Costo', 'CC0');
INSERT INTO `clientedepartamentos` VALUES ('1', 'ABASTECIMIENTOS', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('2', 'CONTABILIDAD', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('3', 'PRODUCCION', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('4', 'DIRECCION DE OBRAS', '69020100', '1');
INSERT INTO `clientedepartamentos` VALUES ('5', 'DIRECCION DE FINANZAS', '69020100', '1');
INSERT INTO `clientedepartamentos` VALUES ('6', 'LICENCIAS DE CONDUCIR', '69020100', '1');
INSERT INTO `clientedepartamentos` VALUES ('7', 'Nuevo Depto  correct', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('8', 'otro departamento', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('9', 'nuevo depttrooo', '11118822', '1');
INSERT INTO `clientedepartamentos` VALUES ('10', 'sdfsdfsdf sdf sd fsdf sd fsdf sdf ', '76625330', '1');
INSERT INTO `clientedepartamentos` VALUES ('11', 'Nuevo Departamento', '76495040', '1');
INSERT INTO `clientedepartamentos` VALUES ('12', 'DEPARTAMENTO GENERAL', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('13', 'CENTRAL', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('14', 'gre r er ert ert ert e', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('15', 'fsdfsdf', '96912990', '1');
INSERT INTO `clientedepartamentos` VALUES ('16', 'sdfsdfsdf', '10050364', '1');
INSERT INTO `clientedepartamentos` VALUES ('17', 'Super Departamento', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('18', 'otro departamento 45', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('19', 'nuevamente', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('20', 'mas departamentos', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('21', 'FSDF SDFSD FSDF ', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('22', 'werwe we rwe r', '76206541', '0');
INSERT INTO `clientedepartamentos` VALUES ('23', 'FISCALIZACIÃ“N', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('24', 'COMPRAS INTERNACIONALES', '76206541', '1');
INSERT INTO `clientedepartamentos` VALUES ('25', 'ESCRITURA PUBLICA', '8215914', '1');
INSERT INTO `clientemaquina` VALUES ('60704000', 'BR1128', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61004007', 'CA1056', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'CA1105', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'CA1118', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'CA1161', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96266000', 'DI1042', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'DI1044', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'DI1045', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'DI1059', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'DI1063', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'DI1156', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'DI1201', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96266000', 'GE1246', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'IN1152', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'KY1220', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60803000', 'KY1232', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61606203', 'KY1820', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'LA1085', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'LA1150', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'LA1167', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'MI1096', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('10857039', 'MI1103', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60511023', 'MI1124', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'MI1245', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61814000', 'MI1255', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('95748000', 'NA1019', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'NA3413', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('17433594', 'OL1003', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'OL1148', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'PB1072', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61606203', 'RI1029', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'RI1034', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'RI1043', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'RI1046', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'RI1070', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('87682500', 'RI1097', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'RI1104', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1145', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96621640', 'RI1179', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96870780', 'RI1185', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60511023', 'RI1187', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1028', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'RIS1143', '1', '1', '0000-00-00', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RIS1144', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1197', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1258', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1259', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'SA1015', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SA1082', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SA1091', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'SA1147', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'SA1172', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'SA1200', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SA1202', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('95467000', 'SA1203', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'SA1260', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('79826770', 'SA1262', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'SH1001', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('81537600', 'SH1036', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'SH1041', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'SH1155', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1181', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1182', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1184', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1192', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('71529400', 'SH1194', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1215', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1216', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('89701900', 'SH1233', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61606203', 'SH1234', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('99545610', 'SH1238', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96912990', 'SH1242', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'SH1243', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'SH1247', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1251', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1252', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1253', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('81537600', 'SH1254', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60803000', 'SH1257', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('79705403', 'TO1018', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1021', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1023', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1024', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('99541860', 'TO1025', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1026', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1027', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1030', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('95467000', 'TO1031', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60804004', 'TO1035', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1040', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1052', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1053', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1054', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1057', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1066', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1069', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1073', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('9427783', 'TO1076', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'TO1081', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'TO1086', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1100', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('81537600', 'TO1108', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1116', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1126', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60704000', 'TO1129', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('9231948', 'TO1130', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'TO1132', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60803000', 'TO1138', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1166', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1191', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('59090630', 'TO1204', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('59090630', 'TO1205', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1219c', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96870780', 'TO1220', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'TO1224h', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('76201140', 'TO1225h', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1227h', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('96709420', 'TO1235h', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1236H', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'TO1237', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1239', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1240', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1241', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1250', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'TO1261', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'XE1050', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1098', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'XE1169', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1169', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'XE1172', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('81537600', 'XE1176', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'XE1212', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('96621640', 'XE1223', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1248', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('60803000', 'XE1256', '1', '1', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'XE1263', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1264', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1252', '1', '0', '2010-03-01', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SH1252', '1', '0', '2010-03-01', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1214', '1', '0', '2010-03-01', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'DI1214', '1', '0', '2010-03-01', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1112', '1', '0', '2010-03-01', null, null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'TO1112', '1', '0', '2010-03-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '1', '0', '2010-03-02', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1225h', '1', '0', '2010-03-02', null, null);
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1225h', '1', '0', '2010-03-02', null, null);
INSERT INTO `clientemaquina` VALUES ('76201140', 'TO1240', '1', '0', '2010-03-02', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1153', '1', '0', '2010-03-04', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RIS1153', '1', '0', '2010-03-04', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1022', '1', '0', '2010-03-04', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SH1022', '1', '0', '2010-03-04', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1178', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1178', '1', '0', '2010-03-08', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1266', '1', '0', '2010-03-08', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1266', '1', '0', '2010-03-08', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1133', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('60511023', 'SH1133', '1', '0', '2010-03-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1133', '2', '0', '2010-03-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1124', '1', '0', '2010-03-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '1', '0', '2010-03-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1174', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'KY1231 ', '1', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1269', '1', '1', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1150', '1', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1084', '1', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'LA1084', '1', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1084', '2', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1146', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SH1146', '1', '0', '2010-03-16', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267h', '1', '0', '2010-03-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1235h', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1270 ', '1', '0', '2010-03-17', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1267h', '1', '0', '2010-03-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1268 ', '1', '0', '2010-03-17', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'SH1268 ', '1', '0', '2010-03-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1211', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1211', '1', '0', '2010-03-18', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'CA1118', '1', '0', '2010-03-18', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1139', '1', '0', '2010-03-18', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1265h', '1', '0', '2010-03-18', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RI1270 ', '1', '0', '2010-03-19', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1197', '1', '0', '2010-03-19', null, null);
INSERT INTO `clientemaquina` VALUES ('96870780', 'TO1265h', '1', '0', '2010-03-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1260', '1', '0', '2010-03-24', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SA1260', '1', '0', '2010-03-24', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '1', '0', '0000-00-00', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1172', '1', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'SA1172', '2', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1172', '2', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'SA1172', '1', '0', '2010-03-25', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '1', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '2', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1206', '1', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1271', '1', '0', '2010-03-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1235h', '2', '0', '2010-03-29', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1235h', '1', '0', '2010-03-29', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1235h', '3', '0', '2010-03-29', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '2', '0', '2010-03-30', null, null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'XE1175', '1', '0', '2010-03-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1197', '2', '0', '2010-03-31', null, null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'RIS1197', '1', '0', '2010-03-31', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '2', '0', '2010-04-05', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1171', '1', '0', '2010-04-05', null, null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1271', '1', '0', '2010-04-05', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1276', '1', '0', '2010-06-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1287', '1', '1', '2010-06-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'OL10003', '1', '0', '2010-06-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1288', '1', '1', '2010-06-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1217', '1', '0', '2010-06-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1229', '1', '0', '2010-06-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1093', '1', '0', '2010-06-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1284', '1', '1', '2010-06-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'NA1094', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1272', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1277', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1185', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1280', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1286', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1230', '1', '0', '2010-07-01', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1174', '2', '0', '2010-07-05', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1036', '1', '0', '2010-07-06', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1036', '1', '0', '2010-07-06', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1086', '1', '0', '2010-07-13', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1086', '1', '0', '2010-07-13', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1277', '1', '0', '2010-07-13', null, '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1272', '1', '0', '2010-07-13', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '2', '0', '2010-07-19', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1226', '1', '1', '2010-08-11', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1170', '1', '1', '2010-08-11', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267h', '2', '0', '2010-08-31', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1034', '1', '0', '2010-08-31', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1293', '1', '0', '2010-09-02', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1293', '1', '0', '2010-09-02', null, '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'TO1267h', '1', '0', '2010-09-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1204', '1', '0', '2010-09-03', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'TO1204', '1', '0', '2010-09-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1287', '1', '0', '2010-09-03', null, null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RI1287', '1', '0', '2010-09-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267C', '1', '1', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267S', '1', '1', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1132', '1', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1251', '1', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1282', '1', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1282', '1', '0', '2010-09-07', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '2', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1272', '2', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'SH1251', '1', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224h', '1', '0', '2010-09-07', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1217', '1', '0', '2010-09-08', null, '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1224h', '1', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '3', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1231 ', '1', '0', '2010-09-08', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1220', '1', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1130', '1', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1130', '1', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1130', '2', '0', '2010-09-08', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'RI1034', '1', '0', '2010-09-08', null, '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1286', '1', '0', '2010-09-09', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1289', '1', '0', '2010-09-09', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289C', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289S', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1289C', '1', '0', '2010-09-09', null, '0');
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1289S', '1', '0', '2010-09-09', null, '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'XE1174', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1212', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1103', '1', '0', '2010-09-09', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267HC', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267HS', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1220', '1', '0', '2010-09-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'TO1267HC', '1', '0', '2010-09-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'TO1267HS', '1', '0', '2010-09-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('10857039', 'XE1212', '1', '0', '2010-09-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1249', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'TO1280', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1249', '2', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1249', '1', '0', '2010-09-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1279', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279C', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279S', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1279C', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1279S', '1', '0', '2010-09-10', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '3', '0', '2010-09-13', null, null);
INSERT INTO `clientemaquina` VALUES ('81537600', 'KY1231 ', '2', '0', '2010-09-13', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1185', '1', '0', '2010-09-13', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1138', '1', '0', '2010-09-13', null, null);
INSERT INTO `clientemaquina` VALUES ('60803000', 'MI1124', '1', '0', '2010-09-14', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1250C', '1', '1', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1223', '1', '0', '2010-09-14', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'OL1148', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'OL1148', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224h', '2', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1251', '2', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'SH1251', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'TO1021', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'BR1295', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '1', '0', '2010-09-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HC', '1', '0', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HS', '1', '0', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1224HC', '1', '0', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1224HS', '1', '0', '2010-09-15', null, '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'TO1132', '1', '0', '2010-09-15', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1271C', '1', '0', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1271S', '1', '0', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1271C', '1', '1', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1271S', '1', '1', '2010-09-15', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1173', '1', '0', '2010-09-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1277', '2', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291', '1', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291C', '1', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291S', '1', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1291', '1', '0', '2010-09-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1291C', '1', '0', '2010-09-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1291S', '1', '0', '2010-09-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1245', '1', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1044', '1', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'MI1245', '2', '0', '2010-09-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1251', '3', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '3', '0', '2010-09-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1261', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1167', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'LA1167', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1167', '2', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1290', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'MI1290', '1', '0', '2010-09-22', null, '0');
INSERT INTO `clientemaquina` VALUES ('9231948', 'TO1276', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '2', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1173', '1', '0', '2010-09-22', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1261', '1', '0', '2010-09-22', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '3', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1173', '2', '0', '2010-09-22', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '2', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'BR1295', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279C', '2', '1', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1191', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279S', '2', '1', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1279', '2', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '4', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1112', '2', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1112', '1', '1', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1296', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1296C', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1296S', '1', '0', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1296', '1', '0', '2010-09-22', null, '0');
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1296C', '1', '1', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('96717980', 'TO1296S', '1', '1', '2010-09-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '3', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1295', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '4', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1277', '2', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('60109000', 'TO1224h', '1', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HS', '2', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1224HS', '2', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HC', '2', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HS', '3', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('60109000', 'TO1224HC', '1', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1224HS', '3', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '2', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240C', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240S', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1240', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1240C', '1', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1240S', '1', '0', '2010-09-23', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1297', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'SA1297', '1', '1', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1081', '1', '0', '2010-09-23', null, null);
INSERT INTO `clientemaquina` VALUES ('61511020', 'TO1081', '1', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1097', '1', '1', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1057', '1', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1185', '2', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'KY1230', '1', '0', '2010-09-24', null, '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1251', '1', '0', '2010-09-24', null, '0');
INSERT INTO `clientemaquina` VALUES ('61511020', 'XE1185', '1', '0', '2010-09-24', null, '0');
INSERT INTO `clientemaquina` VALUES ('87682500', 'BR1295', '2', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1185', '1', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'RI1185', '1', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '3', '0', '2010-09-24', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'XE1171', '1', '0', '2010-09-24', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '4', '0', '2010-09-29', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1173', '2', '0', '2010-09-29', null, '0');
INSERT INTO `clientemaquina` VALUES ('61606203', 'TO1183', '1', '0', '0000-00-00', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '4', '0', '2010-10-21', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1231 ', '2', '0', '2010-10-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1199', '1', '0', '2010-10-21', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1199', '1', '0', '2010-10-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1176', '1', '0', '2010-10-21', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1176', '1', '0', '2010-10-21', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '5', '0', '2010-10-27', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '1', '0', '2010-10-27', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'BR1292', '1', '0', '2010-10-27', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1177', '1', '0', '2010-11-01', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'DI1093', '1', '0', '2010-11-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1177', '1', '0', '2010-11-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '5', '0', '2010-11-03', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1295', '1', '0', '2010-11-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1252', '2', '0', '2010-11-03', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1022', '2', '0', '2010-11-03', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SH1252', '2', '0', '2010-11-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('87682500', 'SH1022', '1', '0', '2010-11-03', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1022', '3', '0', '2010-11-04', null, null);
INSERT INTO `clientemaquina` VALUES ('96870780', 'TO1281', '1', '0', '2010-11-11', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1298', '1', '0', '2010-11-11', null, null);
INSERT INTO `clientemaquina` VALUES ('72443600', 'XE1298', '1', '0', '2010-11-11', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1225h', '2', '0', '2010-11-15', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1225h', '1', '0', '2010-11-15', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '2', '0', '2010-11-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1236H', '1', '0', '2010-11-15', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1281', '1', '0', '2010-11-15', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '2', '0', '2010-11-15', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1082', '1', '0', '2010-11-16', null, null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'SA1082', '1', '0', '2010-11-16', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1303', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'BR1303', '1', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1108', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1108', '1', '1', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1280', '2', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1280', '1', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1185', '2', '1', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '5', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'XE1173', '3', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1272', '1', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1042', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1052', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1299', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'XE1299', '1', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1043', '1', '1', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1052', '2', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1145', '1', '0', '2010-11-17', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1206', '1', '0', '2010-11-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1258', '1', '1', '2010-11-18', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1294', '1', '0', '2010-11-18', null, null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RI1294', '1', '0', '2010-11-18', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '1', '0', '2010-11-18', null, null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1304', '1', '0', '2010-11-18', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1305', '1', '0', '2010-11-18', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'XE1305', '1', '0', '2010-11-18', null, '0');
INSERT INTO `clientemaquina` VALUES ('95748000', 'TO1021', '2', '0', '2010-11-19', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '4', '0', '2010-11-22', null, null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'XE1171', '1', '0', '2010-11-22', null, null);
INSERT INTO `clientemaquina` VALUES ('61603000', 'TO1057', '2', '0', '2010-11-22', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1057', '2', '0', '2010-11-22', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1145', '2', '0', '2010-11-25', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1213', '1', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'DI1213', '1', '0', '2010-11-25', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '5', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('76182660', 'XE1171', '1', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1265h', '2', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('60103000', 'TO1265h', '1', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1300', '1', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'XE1300', '1', '0', '2010-11-25', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '3', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1057', '3', '0', '2010-11-25', null, null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1057', '1', '0', '2010-11-25', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '3', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'TO1021', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '4', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'XE1175', '2', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1302', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'XE1302', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'OL1148', '2', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'TO1021', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1091', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1293', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('81426700', 'BR1293', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '4', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1301', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1301', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1237', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1175', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1178', '2', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1305', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1305', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1306', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1306', '1', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SA1091', '2', '0', '2010-11-26', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1029', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1307', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1307', '1', '0', '2010-11-26', null, null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'SH1022', '1', '0', '2010-11-30', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1174', '3', '0', '2010-12-02', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1147', '1', '0', '2010-12-07', null, null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'XE1174', '1', '0', '2010-12-07', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1268 ', '2', '0', '2010-12-07', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1046', '1', '1', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1276', '2', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('9231948', 'TO1279', '1', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1308', '1', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '1', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1308', '1', '0', '2010-12-14', null, '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1309', '1', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '6', '0', '2010-12-14', null, null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'XE1171', '2', '0', '2010-12-14', null, '0');
INSERT INTO `clientemaquina` VALUES ('61606203', 'RI1029', '2', '0', '2010-12-15', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1307', '2', '1', '2010-12-16', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1320', '1', '0', '2010-12-16', null, null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1320', '1', '0', '2010-12-16', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1031', '1', '0', '2010-12-16', null, null);
INSERT INTO `clientemaquina` VALUES ('95467000', 'XE1178', '1', '0', '2010-12-16', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1321', '1', '0', '2010-12-17', null, null);
INSERT INTO `clientemaquina` VALUES ('9231948', 'XE1321', '1', '0', '2010-12-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'SH1268 ', '1', '0', '2010-12-17', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1265h', '3', '1', '2010-12-21', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '2', '0', '2010-12-27', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1322', '1', '0', '2010-12-29', null, null);
INSERT INTO `clientemaquina` VALUES ('60103000', 'TO1322', '1', '0', '2010-12-29', null, '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SA1147', '1', '0', '2010-12-29', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '2', '0', '2010-12-30', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1323', '1', '0', '2010-12-30', null, null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1323', '1', '0', '2010-12-30', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1200', '1', '0', '2011-01-03', null, null);
INSERT INTO `clientemaquina` VALUES ('61511020', 'SA1200', '1', '0', '2011-01-03', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'GE1246', '1', '0', '2011-01-04', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1081', '2', '0', '2011-01-05', null, null);
INSERT INTO `clientemaquina` VALUES ('61511020', 'BR1309', '1', '0', '2011-01-05', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '3', '0', '2011-01-10', null, null);
INSERT INTO `clientemaquina` VALUES ('76044303', 'TO1240', '1', '0', '2011-01-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1223', '2', '0', '2011-01-10', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1028', '1', '0', '2011-01-12', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '5', '0', '2011-01-18', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1324', '1', '0', '2011-01-19', null, null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1310', '1', '0', '2011-01-20', null, null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'XE1310', '1', '1', '2011-01-20', null, null);
INSERT INTO `clientemaquina` VALUES ('9231948', 'KY1324', '1', '0', '2011-01-20', null, '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240C', '2', '0', '2011-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240S', '2', '0', '2011-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76044303', 'TO1240C', '1', '1', '2011-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76044303', 'TO1240S', '1', '1', '2011-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1235h', '1', '0', '2011-01-27', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1308', '2', '0', '2011-02-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1241', '1', '0', '2011-02-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '3', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HS', '4', '1', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291C', '2', '1', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291S', '2', '1', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1241', '1', '0', '2011-02-17', 'ING. Y ADM.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1325', '1', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1325', '1', '0', '2011-02-17', 'ING. Y ADM.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1296', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1296', '1', '0', '2011-02-17', 'SERVICIO DE EVALUACION AMBIENTAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1326', '1', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'KY1326', '1', '0', '2011-02-17', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1282', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1299', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1299', '1', '0', '2011-02-17', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1231 ', '3', '0', '2011-02-17', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '6', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1034', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1236H', '1', '0', '2011-02-17', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1213', '2', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'RI1034', '2', '0', '2011-02-17', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '3', '0', '2011-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61511020', 'KY1231 ', '1', '0', '2011-02-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('79705403', 'SH1282', '1', '0', '2011-02-18', 'ADM.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1216', '1', '0', '2011-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1309', '1', '0', '2011-02-18', 'OF. DE PARTES', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1216', '2', '0', '2011-02-18', 'ARCHIVO Y BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1018', '1', '0', '2011-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1282', '3', '0', '2011-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1282', '1', '0', '2011-02-22', 'POSTA RURAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1327', '1', '0', '2011-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79705403', 'KY1327', '1', '0', '2011-02-22', 'ADM.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1328', '1', '0', '2011-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1328', '1', '0', '2011-02-25', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1294', '2', '0', '2011-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1329', '1', '0', '2011-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RI1294', '2', '0', '2011-03-02', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1294', '3', '0', '2011-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1329', '1', '0', '2011-03-02', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1293', '2', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '5', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1299', '3', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '5', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1291', '1', '0', '2011-03-03', 'EDUCACION/ DEPTO. TECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1029', '2', '1', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1190', '1', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1260', '2', '0', '2011-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SA1190', '1', '0', '2011-03-03', 'ADQUICISIONES', '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'SA1260', '2', '0', '2011-03-03', 'RECEPCION', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1028', '2', '0', '2011-03-04', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1245', '2', '0', '2011-03-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1331', '1', '1', '2011-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'TO1308', '2', '0', '2011-03-08', 'PLANIFICACIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1069', '1', '0', '2011-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96266000', 'XE1299', '2', '0', '2011-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1293', '1', '0', '2011-03-11', 'INTENDENTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'CA1056', '1', '0', '2011-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'XE1175', '1', '0', '2011-03-11', 'RECEPCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1299', '4', '0', '2011-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'RI1294', '1', '0', '2011-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1330', '1', '0', '2011-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12218820', 'EP1330', '1', '0', '2011-03-14', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'OL1003', '1', '0', '2011-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1299', '2', '0', '2011-03-15', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1052', '2', '0', '2011-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1323', '2', '0', '2011-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17433594', 'TO1052', '1', '0', '2011-03-15', 'LICEO EBEN-EZER', '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'TO1021', '2', '0', '2011-03-17', 'CECOM PLAZA', '0');
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1281', '1', '0', '2011-03-21', 'MINVU', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1250', '1', '1', '2011-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1332', '1', '0', '2011-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96825130', 'TO1332', '1', '0', '2011-03-21', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1146', '2', '0', '2011-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1262', '1', '0', '2011-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1238', '1', '0', '2011-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '7', '0', '2011-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1336', '1', '0', '2011-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1335', '1', '0', '2011-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'SA1262', '2', '0', '2011-03-29', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1335', '1', '0', '2011-03-30', '', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1069', '1', '0', '2011-03-30', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1040', '1', '0', '2011-03-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1336', '1', '0', '2011-03-30', 'EDUCACION /FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1172', '3', '0', '2011-03-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1176', '2', '1', '2011-03-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1171', '1', '0', '2011-03-30', 'ESCUELA ESPECIAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1337', '1', '0', '2011-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'RIS1337', '1', '0', '2011-04-01', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SA1172', '2', '0', '2011-04-11', 'ESCUELA ESPECIAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '8', '0', '2011-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'MI1245', '1', '0', '2011-04-11', 'ESCUELA BERNARDO OHIGGUINS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1338', '1', '0', '2011-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125852', 'XE1338', '1', '0', '2011-04-12', 'BRONOR', '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'XE1171', '1', '0', '2011-04-12', 'COMUNICACIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1339', '1', '0', '2011-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1340', '1', '0', '2011-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1128', '1', '1', '2011-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1260', '3', '0', '2011-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1214', '2', '0', '2011-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1239', '1', '0', '2011-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1239', '1', '0', '2011-04-25', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '4', '0', '2011-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '4', '0', '2011-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1340', '1', '0', '2011-04-28', 'ADM.(LEOPOLDO)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1247', '1', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1091', '2', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1277', '3', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1261', '2', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1245', '3', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'DI1214', '1', '0', '2011-05-03', 'ESCUELA BERNARDO O.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1184', '1', '0', '2011-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291', '3', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1291', '2', '0', '2011-05-04', 'DIRECCION DE OBRAS MUNICIPALES', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1184', '2', '0', '2011-05-04', 'TRANSITO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1336', '2', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1306', '2', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1172', '4', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1336', '2', '0', '2011-05-04', 'ESCUELA ESPECIAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1104', '1', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'RI1104', '2', '0', '2011-05-04', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1104', '2', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1104', '1', '0', '2011-05-04', 'CENTRAL DE APUNTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1129', '1', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1334', '1', '0', '2011-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60704000', 'TO1334', '1', '0', '2011-05-04', 'SERNATUR', '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'BR1306', '1', '0', '2011-05-04', 'MAIPU', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1277', '3', '0', '2011-05-06', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1217', '2', '0', '2011-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1281', '1', '0', '2011-05-06', 'EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13632833', 'SA1172', '1', '0', '2011-05-06', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1247', '1', '0', '2011-05-06', '2Âº PISO', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1139', '1', '0', '2011-05-10', '', '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1237', '1', '0', '2011-05-10', 'SRA. MARITZA.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1298', '2', '0', '2011-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1133', '1', '0', '2011-05-10', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('60103000', 'SA1260', '3', '0', '2011-05-12', 'SERPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('89701900', 'SH1238', '1', '0', '2011-05-12', 'ABOGADO BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1233', '1', '0', '2011-05-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1133', '3', '0', '2011-05-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1233', '1', '0', '2011-05-12', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1217', '1', '0', '2011-05-12', '2Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1045', '1', '0', '2011-05-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1225h', '3', '0', '2011-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TSQ03154', '1', '0', '2011-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1271', '2', '0', '2011-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '5', '0', '2011-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1271', '1', '0', '2011-05-17', 'EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1342', '1', '0', '2011-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1190', '2', '0', '2011-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'XE1298', '1', '0', '2011-05-18', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1015', '1', '0', '2011-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'TO1129', '1', '0', '2011-05-18', 'CECOM LAUTARO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1172', '5', '0', '2011-05-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1021', '6', '0', '2011-05-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SH1146', '2', '0', '2011-05-23', 'CECOM PLAZA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1298', '3', '0', '2011-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'SA1091', '1', '0', '2011-05-24', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1333 ', '1', '0', '2011-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1333 ', '1', '0', '2011-05-24', 'LEOPOLDO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1070', '1', '0', '2011-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'RI1070', '2', '0', '2011-05-26', 'REGISTRO CIVIL BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1298', '1', '0', '2011-05-27', 'ESCUELA CARACOLES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1272', '3', '0', '2011-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1220', '2', '0', '2011-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1272', '1', '0', '2011-05-30', 'VISION JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1227h', '1', '1', '2011-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1281', '2', '0', '2011-06-02', 'HANS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1181', '1', '0', '2011-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1342', '1', '0', '2011-06-06', 'depto. proyecto', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1225h', '1', '0', '2011-06-08', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '4', '0', '2011-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1309', '2', '0', '2011-06-08', 'SECOPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '1', '0', '2011-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1344', '1', '0', '2011-06-10', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1205', '1', '0', '2011-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1172', '1', '0', '2011-06-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'SH1181', '1', '0', '2011-06-22', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1082', '2', '0', '2011-06-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1311', '1', '0', '2011-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1305', '2', '0', '2011-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'SH1305', '1', '0', '2011-06-24', 'caucho industrial', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1035', '1', '0', '2011-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60804004', 'TO1018', '1', '0', '2011-06-24', 'ADUANA', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1035', '1', '0', '2011-06-24', 'REGISTRO CIVIL MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1233', '2', '0', '2011-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1156', '1', '0', '2011-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'RI1311', '1', '0', '2011-06-29', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1172', '1', '0', '2011-06-30', 'ESCUELA BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1345', '1', '0', '2011-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1247', '2', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'R11343', '1', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'R11343', '1', '0', '2011-07-05', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1028', '2', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1054', '1', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1287', '2', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1028', '3', '0', '2011-07-05', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1247', '2', '0', '2011-07-05', 'DEPTO. MATRIMONIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '2', '0', '2011-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'SH1233', '1', '0', '2011-07-05', 'CORE 6Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'BR1304', '1', '0', '2011-07-05', 'ANTONINO TORO 1ER PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1338', '2', '0', '2011-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1345', '1', '0', '2011-07-13', 'BODEGA EL SITIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1124', '2', '0', '2011-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60803000', 'TO1205', '1', '1', '2011-07-13', '1ER PISO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '3', '0', '2011-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125852', 'XE1223', '1', '0', '2011-07-14', 'OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'CA1161', '1', '0', '2011-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1334', '2', '0', '2011-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'CA1161', '2', '1', '2011-07-25', 'VISION LIDER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1325', '2', '0', '2011-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1325', '1', '0', '2011-07-26', 'HANS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '6', '0', '2011-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'XE1338', '1', '0', '2011-07-26', 'ADMISION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1247', '3', '0', '2011-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SA1082', '2', '0', '2011-07-26', 'DEPTO. MATRIMONIO', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1281', '2', '0', '2011-07-26', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1241', '2', '1', '2011-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'TO1323', '1', '0', '2011-08-08', '2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1347', '1', '0', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1347', '1', '0', '2011-08-11', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '7', '0', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1286', '2', '1', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1281', '1', '0', '2011-08-11', 'NILSON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1022', '4', '0', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1346', '1', '0', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1346', '1', '0', '2011-08-11', 'ADM.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1277', '4', '0', '2011-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1287', '1', '0', '2011-08-11', 'ESCUELA BERNARDO O.', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1277', '1', '0', '2011-08-19', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1312', '1', '0', '2011-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1348', '1', '0', '2011-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1312', '1', '0', '2011-08-22', 'ESCUELA BERNARDO O.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1312', '2', '1', '2011-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1247', '1', '0', '2011-08-22', 'ESCUELA BERNARDO O.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1234', '1', '0', '2011-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1348', '1', '0', '2011-08-22', 'DEPTO. DIRECCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1249', '3', '0', '2011-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1054', '1', '0', '2011-08-23', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1251', '4', '0', '2011-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1279', '1', '0', '2011-08-26', 'DEPTO. SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1251', '2', '0', '2011-08-29', 'BODEGA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '2', '0', '2011-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1337', '2', '1', '2011-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1211', '2', '0', '2011-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1211', '1', '0', '2011-08-31', 'GARAJE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1277', '5', '1', '2011-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1202', '1', '0', '2011-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SH1022', '1', '0', '2011-09-05', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('61603000', 'BR1292', '2', '0', '2011-09-06', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1306', '3', '0', '2011-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511021', 'BR1306', '1', '0', '2011-09-06', 'GOBERNACION MARITIMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '3', '0', '2011-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1053', '1', '0', '2011-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1166', '1', '0', '2011-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1076', '1', '0', '2011-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9427783', 'TO1166', '1', '0', '2011-09-09', 'ESSANE DEL NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1313', '1', '0', '2011-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1313', '1', '0', '2011-09-09', 'ESCUELA EE.UU.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1332', '2', '1', '2011-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96825130', 'TO1276', '1', '0', '2011-09-21', 'CRISTIAN MOLINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'E1J724080', '1', '0', '2011-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71102600', 'E1J724080', '1', '1', '2011-09-23', 'ESCUELA D-75 VENTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'ZA00593', '1', '0', '2011-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71102600', 'ZA00593', '1', '1', '2011-09-23', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'IN1152', '1', '0', '2011-09-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'MI1245', '1', '0', '2011-09-26', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('76125852', 'SH1234', '1', '0', '2011-09-26', 'BRONOR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '4', '0', '2011-09-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '123456', '1', '0', '2011-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76092002', '123456', '1', '0', '2011-09-28', 'NEWLAND VENTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1314', '1', '1', '2011-09-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1324', '2', '0', '2011-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9231948', 'BR1304', '1', '0', '2011-10-06', 'RICARDO LAZCANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1248', '1', '0', '2011-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1234', '2', '0', '2011-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125852', 'SH1234', '2', '0', '2011-10-11', 'BRONOR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1036', '2', '0', '2011-10-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'SA1202', '1', '0', '2011-10-11', 'POSTA RURAL SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '4', '0', '2011-10-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9231948', 'KY1324', '2', '0', '2011-10-11', 'RICARDO LAZCANO', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1053', '1', '0', '2011-10-13', 'MARIA ELENA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '4', '0', '2011-10-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'XE1248', '1', '0', '2011-10-17', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1022', '5', '0', '2011-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1315', '1', '0', '2011-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1315', '1', '0', '2011-10-20', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'NA3413', '1', '0', '2011-10-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1223', '3', '0', '2011-10-27', 'DEPTO. OF DE PARTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1364', '1', '0', '2011-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1364', '1', '0', '2011-10-27', 'ADMICION  NETLAND SCHOOL', '0');
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1304', '2', '0', '2011-10-27', 'ISMENIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1230', '2', '0', '2011-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1225h', '4', '1', '2011-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1239', '2', '0', '2011-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1239', '2', '0', '2011-11-03', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1366', '1', '0', '2011-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1356', '1', '0', '2011-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1357', '1', '0', '2011-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1366', '1', '0', '2011-11-03', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1356', '1', '0', '2011-11-03', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1357', '1', '0', '2011-11-03', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'R11343', '2', '0', '2011-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1365', '1', '0', '2011-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RI1365', '1', '0', '2011-11-08', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1240', '1', '0', '2011-11-15', 'OF. DE PARTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '5', '0', '2011-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1030', '1', '0', '2011-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY1230', '1', '0', '2011-11-15', 'LICEO DIEGO PORTALES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1001', '1', '0', '2011-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1223', '1', '0', '2011-11-17', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1353', '1', '0', '2011-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1353', '1', '0', '2011-11-21', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1334', '1', '0', '2011-11-21', 'MONTEC IQUIQUE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1070', '2', '0', '2011-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '3', '0', '2011-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'BR1292', '1', '0', '2011-12-01', 'IQUIQUE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1324', '3', '1', '2011-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1353', '2', '0', '2011-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1356', '2', '0', '2011-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1366', '2', '0', '2011-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1366', '2', '0', '2011-12-01', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1243', '1', '0', '2011-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'SH1036', '1', '0', '2011-12-05', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1036', '3', '0', '2011-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'SH1243', '2', '0', '2011-12-05', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1367', '1', '0', '2011-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1369', '1', '0', '2011-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'RI1369', '1', '0', '2011-12-13', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1301', '2', '0', '2011-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76010311', 'BR1301', '1', '0', '2011-12-13', 'COLEGIO CHAÃ‘ARES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1268 ', '3', '0', '2011-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1368', '1', '0', '2011-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1368', '1', '0', '2011-12-14', 'MARISOL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1293', '2', '0', '2011-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1238', '2', '0', '2011-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('89701900', 'SH1268 ', '1', '0', '2011-12-19', 'CARLOS BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1316', '1', '0', '2011-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1316', '1', '0', '2011-12-19', 'CECOM TERMINAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1366', '3', '0', '2011-12-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1197', '3', '1', '2011-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1217', '3', '0', '2011-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1018', '2', '0', '2012-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1370', '1', '0', '2012-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1371', '1', '0', '2012-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76014676', 'BR1370', '1', '1', '2012-01-05', 'MARIA BASTIA', null);
INSERT INTO `clientemaquina` VALUES ('76014676', 'BR1371', '1', '1', '2012-01-05', 'MARIA BASTIA', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'XE1293', '1', '0', '2012-01-05', 'PRESUPUESTO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1357', '2', '0', '2012-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1018', '1', '0', '2012-02-08', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1034', '3', '0', '2012-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1356', '2', '0', '2012-03-08', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1232', '1', '0', '2012-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1237', '2', '0', '2012-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1237', '1', '0', '2012-03-08', 'SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '2', '0', '2012-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1375', '1', '0', '2012-03-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1375', '1', '0', '2012-03-09', 'NETLAND ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1373', '1', '0', '2012-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1373', '1', '0', '2012-03-12', 'GORE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1126', '1', '1', '2012-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1369', '2', '0', '2012-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'R11343', '1', '0', '2012-03-12', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'RI1369', '1', '0', '2012-03-12', 'CENTRAL DE APUNTES ', '0');
INSERT INTO `clientemaquina` VALUES ('9231948', 'TO1289', '1', '0', '2012-03-14', 'RICARDO LAZCANO', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1030', '2', '0', '2012-03-15', 'LICEO POLITECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1242', '1', '0', '2012-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '6', '0', '2012-03-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1230', '3', '0', '2012-03-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'KY1230', '1', '0', '2012-03-20', 'NETLAND', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1364', '2', '0', '2012-03-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RI1206', '1', '0', '2012-03-20', 'NETLAND', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'RI1034', '1', '0', '2012-03-20', 'NETLAND CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('96912990', 'BR1364', '1', '0', '2012-03-20', 'AEROPUERTO', '0');
INSERT INTO `clientemaquina` VALUES ('76697710', 'SH1242', '1', '0', '2012-03-20', 'OYARZUN', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'R11343', '3', '1', '2012-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1376', '1', '0', '2012-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'LA1376', '1', '0', '2012-03-21', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1356', '3', '0', '2012-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1230', '4', '1', '2012-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1223', '2', '0', '2012-03-22', 'NETLAND', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1300', '2', '0', '2012-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1300', '1', '0', '2012-03-22', 'NETLAND', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1212', '2', '0', '2012-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1238', '1', '0', '2012-04-11', 'COMPLEJO CULTURAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1192', '1', '0', '2012-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10857039', 'XE1212', '2', '0', '2012-04-11', 'JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1375', '2', '0', '2012-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1375', '1', '0', '2012-04-11', 'ADM', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1034', '4', '0', '2012-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'RI1034', '1', '0', '2012-04-11', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '5', '0', '2012-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'RI1206', '1', '0', '2012-04-12', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1369', '3', '0', '2012-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '7', '0', '2012-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1300', '3', '0', '2012-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'XE1300', '1', '0', '2012-04-23', 'TESORERIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1338', '3', '0', '2012-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1380', '1', '0', '2012-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96825130', 'BR1380', '1', '0', '2012-04-26', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1379', '1', '0', '2012-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'BR1379', '1', '0', '2012-04-26', 'JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'RI1369', '1', '0', '2012-04-26', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1367', '1', '0', '2012-04-30', 'IQUIQUE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1377', '1', '0', '2012-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1377', '1', '0', '2012-04-30', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '8', '0', '2012-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1169', '1', '0', '2012-05-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1338', '1', '0', '2012-05-07', 'SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1378', '1', '0', '2012-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1378', '1', '0', '2012-05-08', '5PISO', '0');
INSERT INTO `clientemaquina` VALUES ('78808210', 'KY1232', '1', '0', '2012-05-08', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('70385000', 'EP1356', '1', '0', '2012-05-10', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1315', '2', '1', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1091', '3', '0', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SA1091', '1', '0', '2012-05-10', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1377', '2', '0', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '5', '0', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1381', '1', '0', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1381', '1', '0', '2012-05-10', 'SERPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1381', '2', '0', '2012-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1309', '1', '0', '2012-05-10', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1381', '1', '0', '2012-05-10', 'SERPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '3', '0', '2012-05-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'SH1217', '1', '0', '2012-05-16', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('61002008', 'RI1070', '3', '0', '2012-05-16', 'REGISTRO CIVIL BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1223', '3', '0', '2012-05-17', 'contabilidad', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '8', '0', '2012-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'XE1223', '1', '0', '2012-05-17', 'contabilidad', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1365', '2', '0', '2012-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1382', '1', '0', '2012-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1382', '1', '0', '2012-05-17', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('78863090', 'RI1365', '1', '0', '2012-05-17', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1380', '2', '0', '2012-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96825130', 'TO1289', '1', '0', '2012-05-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '1', '0', '2012-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76511550', 'BR1383', '1', '0', '2012-05-28', 'LABONORT', '0');
INSERT INTO `clientemaquina` VALUES ('76511550', 'BR1380', '1', '0', '2012-06-05', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1385', '1', '0', '2012-06-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('96825130', 'TO1385', '1', '0', '2012-06-05', 'MEJILLONES FAENA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1091', '4', '0', '2012-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1217', '4', '0', '2012-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1377', '2', '0', '2012-06-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1317', '1', '0', '2012-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1317', '1', '0', '2012-06-07', 'POSTA RURAL BAQUEDANO.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '6', '0', '2012-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'SA1091', '2', '0', '2012-06-07', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('71541900', 'TO1281', '1', '0', '2012-06-07', 'RECEPCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1330', '2', '1', '2012-06-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1293', '3', '0', '2012-06-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96825130', 'BR1309', '1', '0', '2012-06-13', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '4', '0', '2012-06-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '1', '0', '2012-06-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('60109000', 'BR1384', '1', '0', '2012-06-14', 'TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224h', '3', '0', '2012-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1367', '2', '0', '2012-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1367', '2', '0', '2012-06-14', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('89629300', 'TO1289', '1', '0', '2012-06-14', 'hotel Antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '5', '0', '2012-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1289', '1', '0', '2012-06-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '5', '0', '2012-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1389', '1', '0', '2012-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1389', '1', '0', '2012-06-15', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1302', '2', '1', '2012-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1395', '1', '0', '2012-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1386', '1', '0', '2012-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1386', '1', '0', '2012-06-18', 'oficina de partes', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1368', '2', '0', '2012-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1368', '1', '0', '2012-06-25', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'XE1169', '2', '0', '2012-06-25', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1390', '1', '0', '2012-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1390', '1', '0', '2012-06-25', 'PAMPA PUNO (SITIO CALAMA)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '6', '0', '2012-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1240', '1', '0', '2012-06-25', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1396', '1', '0', '2012-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'RI1396', '1', '0', '2012-06-25', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1282', '4', '0', '2012-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'SH1282', '1', '0', '2012-06-26', 'FINANZAS Y PERSONAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1235h', '4', '0', '2012-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1030', '2', '0', '2012-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1224h', '1', '0', '2012-06-28', 'LICEO POLITECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1342', '2', '0', '2012-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1030', '3', '0', '2012-06-28', 'SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1235h', '2', '0', '2012-06-28', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1327', '2', '0', '2012-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1398', '1', '0', '2012-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79705403', 'KY1327', '2', '0', '2012-07-05', 'siec', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1132', '2', '0', '2012-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1237', '3', '0', '2012-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'TO1237', '1', '0', '2012-07-06', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1398', '1', '0', '2012-07-12', 'PAMPAPUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '1', '0', '2012-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'BR1397', '1', '0', '2012-07-12', 'PAMPAPUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '4', '0', '2012-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'BR1292', '2', '0', '2012-07-12', 'PAMPAPUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1334', '3', '0', '2012-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1334', '2', '0', '2012-07-12', 'PAMPAPUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '2', '0', '2012-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'BR1397', '2', '0', '2012-07-12', 'CALIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1334', '4', '0', '2012-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1334', '1', '0', '2012-07-12', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1390', '2', '1', '2012-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1399', '1', '0', '2012-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1399', '1', '0', '2012-07-13', 'PAMPAPUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1400', '1', '1', '2012-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1382', '2', '0', '2012-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1169', '2', '0', '2012-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1243', '2', '0', '2012-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1155', '1', '0', '2012-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61511020', 'KY1342', '1', '0', '2012-07-19', 'JURIDICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1185', '3', '1', '2012-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '9', '0', '2012-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1372', '1', '0', '2012-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1372', '1', '0', '2012-07-20', 'CORE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1329', '2', '0', '2012-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1382', '1', '0', '2012-07-20', 'CENTRAL DE APUNTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1242', '2', '0', '2012-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76697710', 'XE1171', '1', '0', '2012-07-20', 'OYARZUN', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1272', '4', '1', '2012-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1401', '1', '0', '2012-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1401', '1', '0', '2012-07-24', 'VISION JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1263', '1', '0', '2012-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'SH1243', '1', '0', '2012-07-24', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1293', '2', '0', '2012-07-24', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'SH1155', '1', '0', '2012-07-24', 'CECOM PLAZA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '6', '0', '2012-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1289', '2', '0', '2012-07-24', 'AK DRILLING', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XXXX', '1', '0', '2012-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '9', '0', '2012-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'TO1240', '1', '0', '2012-08-10', 'CANAL 95', '1');
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1169', '1', '0', '2012-08-16', 'PROYECTO', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1281', '3', '0', '2012-08-16', 'DEPTO. SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '6', '0', '2012-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1263', '1', '0', '2012-08-16', 'TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1392', '1', '0', '2012-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1392', '1', '0', '2012-08-27', 'PAMPA PUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1308', '3', '0', '2012-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '2', '0', '2012-08-30', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1391', '1', '0', '2012-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1391', '1', '0', '2012-08-31', 'PAMPA PUNO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267h', '3', '0', '2012-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'TO1267h', '1', '0', '2012-08-31', 'COMUNICACIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224HC', '3', '1', '2012-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1388', '1', '0', '2012-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1388', '1', '0', '2012-09-03', 'JURIDICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1145', '2', '1', '2012-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1091', '5', '0', '2012-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1402', '1', '0', '2012-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1402', '1', '0', '2012-09-06', 'ADMISION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1172', '2', '0', '2012-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1279', '2', '0', '2012-09-06', 'ESCUELA ESTACION BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('60109000', 'BR1384', '2', '0', '2012-09-12', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1239', '3', '1', '2012-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1398', '2', '0', '2012-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1398', '1', '0', '2012-09-12', 'BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'XE1172', '2', '0', '2012-09-12', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1018', '3', '0', '2012-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1018', '2', '0', '2012-09-12', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1403', '1', '0', '2012-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1403', '1', '0', '2012-09-20', 'ESCUELA BAQUENO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1404', '1', '0', '2012-09-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1404', '1', '0', '2012-09-24', 'CECOM NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1028', '3', '1', '2012-09-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1204', '2', '0', '2012-09-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1407', '1', '0', '2012-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1407', '1', '0', '2012-10-02', 'ESC. Bernardo O.', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1329', '2', '0', '2012-10-04', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1259', '1', '1', '2012-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1345', '2', '1', '2012-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1408', '1', '0', '2012-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1408', '1', '0', '2012-10-23', 'MINISTRO HALES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1252', '3', '0', '2012-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1405', '1', '0', '2012-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1405', '1', '0', '2012-10-24', 'TESORERIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1321', '2', '0', '2012-10-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'XE1321', '1', '0', '2012-10-25', 'VENTAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '7', '0', '2012-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1342', '3', '0', '2012-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1200', '2', '0', '2012-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY1342', '1', '0', '2012-10-26', 'DEPTO. JURIDICO', '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY1231 ', '1', '0', '2012-10-26', 'DEPTO. CONTABILIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'SA1200', '1', '0', '2012-10-26', 'DEPTO. SOCIAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1260', '4', '0', '2012-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289', '7', '1', '2012-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1308', '1', '0', '2012-11-06', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1409', '1', '0', '2012-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1409', '1', '0', '2012-11-06', 'FOMENTO', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1366', '3', '0', '2012-11-07', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1169', '3', '0', '2012-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'XE1169', '2', '0', '2012-11-09', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1410', '1', '0', '2012-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1410', '1', '0', '2012-11-09', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1399', '2', '0', '2012-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1399', '1', '0', '2012-11-14', 'escuela g130', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'SH1252', '1', '0', '2012-11-15', 'ESCUELA BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1252', '4', '0', '2012-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1411', '1', '0', '2012-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13941385', 'BR1411', '1', '0', '2012-11-15', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'SH1252', '1', '0', '2012-11-16', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1412', '1', '0', '2012-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1412', '1', '0', '2012-11-21', 'ANTOGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1366', '4', '1', '2012-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '6', '0', '2012-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1173', '3', '0', '2012-11-21', 'ESCUELA PABLO NERUDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1146', '3', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1098', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1263', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1266', '2', '1', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'NA1019', '1', '1', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1287', '3', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1182', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1023', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1024', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1086', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1116', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1199', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1219c', '1', '1', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289C', '2', '1', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1289S', '2', '1', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1050', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'PB1072', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1073', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'CA1105', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1093', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1220', '1', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1153', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '2', '0', '2012-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1201', '1', '0', '2012-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267HC', '2', '1', '2012-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267HS', '2', '1', '2012-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1367', '3', '0', '2012-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'XE1263', '2', '0', '2012-11-30', 'TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'RIS1153', '2', '0', '2012-12-06', 'Central de apuntes', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1413', '1', '0', '2012-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76137208', 'BR1413', '1', '0', '2012-12-06', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '10', '0', '2012-12-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1281', '4', '0', '2012-12-12', 'depto.Salud', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1169', '4', '0', '2012-12-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1414', '1', '0', '2012-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1414', '1', '0', '2012-12-21', 'FAENA LINERTEC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1183', '1', '0', '2012-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1415', '1', '0', '2012-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'TO1415', '1', '0', '2012-12-21', 'SERVICIOS GRAL.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1166', '2', '0', '2013-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('89701900', 'BR1344', '1', '0', '2013-01-08', 'Carlos Bonilla', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416 CL', '1', '0', '2013-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1417 CL', '1', '0', '2013-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1417 CL', '1', '0', '2013-01-08', 'DIDECO(BAQUEDANO)', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1416 CL', '1', '0', '2013-01-08', 'DIDECO(SIERRA GORDA)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416', '1', '0', '2013-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78791070', 'BR1416', '1', '0', '2013-01-08', 'SERCABOL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1268 ', '4', '0', '2013-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1271', '3', '1', '2013-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1367', '1', '0', '2013-01-10', 'DEPTO. EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1100', '1', '0', '2013-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1204', '1', '0', '2013-01-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1153', '3', '1', '2013-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1421', '1', '0', '2013-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RIS1421', '1', '0', '2013-01-15', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1420', '1', '0', '2013-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'XE1420', '1', '0', '2013-01-15', 'MARISOL 6TO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '5', '0', '2013-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1419', '1', '0', '2013-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76217844', 'BR1419', '1', '0', '2013-01-15', 'LABONORT SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1204', '3', '0', '2013-01-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1204', '2', '0', '2013-01-17', 'DEPTO. ARCHIVO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1263', '3', '1', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1422', '1', '0', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1422', '1', '0', '2013-01-21', 'CECOM TOCOPILLA ANTIGUO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1423', '1', '0', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1423', '1', '0', '2013-01-21', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1212', '3', '1', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1428', '1', '0', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10857039', 'BR1428', '1', '0', '2013-01-21', 'JUMBO NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1316', '2', '1', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1425', '1', '0', '2013-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1425', '1', '0', '2013-01-21', 'TERMINAL DE BUSES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1424', '1', '0', '2013-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1155', '2', '0', '2013-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1424', '1', '0', '2013-01-22', 'Unimarc plaza', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1420', '2', '1', '2013-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1426', '1', '0', '2013-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'BR1426', '1', '0', '2013-01-22', 'GORE MARISOL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '3', '0', '2013-02-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1335', '2', '1', '2013-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1211', '3', '0', '2013-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1384', '1', '0', '2013-02-08', 'CECOM TERMINAL 2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1346', '2', '0', '2013-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1367', '4', '0', '2013-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1354', '1', '0', '2013-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1354', '1', '0', '2013-02-14', 'DEPTO. EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1129', '2', '0', '2013-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1427', '1', '0', '2013-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1427', '1', '0', '2013-02-14', 'CECOM LAUTARO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1238', '3', '0', '2013-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1346', '1', '0', '2013-02-18', 'CASA DE LA CULTURA', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1211', '2', '0', '2013-02-18', 'DEPTO. PROYECTO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1301', '3', '0', '2013-02-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1211', '4', '0', '2013-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'SA1260', '1', '0', '2013-02-22', 'DEPTO. PROYECTO', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1211', '3', '0', '2013-03-01', 'complejo cultural allegado', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '1', '0', '2013-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60103000', 'BR1429', '1', '0', '2013-03-01', 'SERPLAC CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1430', '1', '0', '2013-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60103000', 'BR1430', '1', '0', '2013-03-01', 'SERPLAC  V. CODELCO. AFTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1181', '2', '0', '2013-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR1301', '1', '0', '2013-03-11', 'VICE RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '9', '0', '2013-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1398', '3', '0', '2013-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1431', '1', '0', '2013-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1431', '1', '0', '2013-03-11', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1403', '2', '0', '2013-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1403', '2', '0', '2013-03-14', 'Escuela Sierra Gorda', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1391', '2', '0', '2013-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1392', '2', '0', '2013-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1432', '1', '0', '2013-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1367', '2', '0', '2013-03-20', 'DEPTO. SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1432', '1', '0', '2013-03-20', 'JUNJI ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1139', '2', '0', '2013-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1100', '2', '1', '2013-03-21', 'TALTAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1236H', '2', '1', '2013-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1391', '1', '0', '2013-03-28', 'DEPTO. FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '4', '0', '2013-04-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '5', '0', '2013-04-03', 'TERMINAL 2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '6', '0', '2013-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1384', '2', '0', '2013-04-03', 'TERMINAL 2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1354', '2', '1', '2013-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1433', '1', '0', '2013-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1433', '1', '0', '2013-04-11', 'DEPTO. EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '1', '0', '2013-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1434', '1', '0', '2013-04-11', 'DEPTO.SERPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1300', '4', '0', '2013-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1053', '2', '0', '2013-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'TO1183', '1', '1', '2013-04-17', 'MARIA ELENA', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'KY1229', '1', '0', '2013-04-22', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1436', '1', '0', '2013-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1435', '1', '0', '2013-04-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76079600', 'KY1435', '1', '0', '2013-04-29', 'MADERO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'F2J218535', '1', '0', '2013-05-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1436', '1', '0', '2013-05-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR1436', '1', '0', '2013-05-02', 'DEPTO. ADM. Y FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1243', '3', '0', '2013-05-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'XE1300', '2', '0', '2013-05-06', 'tesoreria', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1300', '5', '1', '2013-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'XE1223', '2', '0', '2013-05-06', 'TESORERIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1437', '1', '0', '2013-05-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('73297300', 'BR1437', '1', '0', '2013-05-07', 'CREO ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1279', '7', '1', '2013-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1392', '1', '0', '2013-05-17', 'ESCUELA BAQUEDANO RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1262', '2', '0', '2013-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1438', '1', '0', '2013-05-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1439', '1', '0', '2013-05-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1438', '1', '0', '2013-05-30', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1438', '2', '0', '2013-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1439', '1', '0', '2013-05-30', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('76697710', 'BR1438', '1', '0', '2013-05-30', 'SALAR DEL CARMEN', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1440', '1', '0', '2013-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76217844', 'TO1440', '1', '0', '2013-06-03', '1ER PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '7', '0', '2013-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1385', '2', '0', '2013-06-10', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1234', '3', '0', '2013-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1441', '1', '0', '2013-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1276', '3', '1', '2013-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1018', '4', '0', '2013-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1309', '3', '0', '2013-06-12', 'DEPTO. JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('78863090', 'SH1234', '1', '0', '2013-06-14', 'CENTRAL DE APUNTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', '2N627735', '1', '0', '2013-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76014676', '2N627735', '1', '1', '2013-06-21', 'CALLE SIN NOMBRE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '5', '0', '2013-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '3', '0', '2013-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1321', '3', '1', '2013-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1442', '1', '0', '2013-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'BR1442', '1', '0', '2013-06-24', 'DEPTO. VENTAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1392', '3', '0', '2013-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1385', '1', '0', '2013-06-24', 'ESCUELA BAQUEDANO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1296', '3', '1', '2013-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1443', '1', '0', '2013-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95431000', 'BR1443', '1', '0', '2013-06-28', 'INFORMATICA', '0');
INSERT INTO `clientemaquina` VALUES ('72443600', 'BR1397', '1', '0', '2013-07-02', 'SEA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1178', '3', '1', '2013-07-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1444', '1', '0', '2013-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70385000', 'EP1444', '1', '0', '2013-07-03', 'JUAN PABLO II', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1203', '1', '0', '2013-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1445', '1', '0', '2013-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1445', '1', '0', '2013-07-09', 'ADM', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1340', '2', '0', '2013-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1325', '3', '0', '2013-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1367', '5', '1', '2013-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1446', '1', '0', '2013-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1446', '1', '0', '2013-07-12', 'DEPTO. SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1452', '1', '0', '2013-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1452', '1', '0', '2013-07-12', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('72443600', 'TO1340', '1', '0', '2013-07-17', 'SEA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '4', '0', '2013-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1397', '1', '0', '2013-07-17', 'ADMISION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1401', '2', '0', '2013-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1453CL', '1', '0', '2013-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'BR1453CL', '1', '1', '2013-07-31', 'VISION JUMBO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1026', '1', '0', '2013-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1018', '1', '0', '2013-07-31', 'ESC. CARLOS CODELL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '2', '0', '2013-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1451', '1', '0', '2013-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1451', '1', '0', '2013-08-01', 'SECPLAC BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1414', '2', '0', '2013-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1333 ', '2', '0', '2013-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1392', '1', '0', '2013-08-13', 'LEOPOLDO', '0');
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1401', '2', '0', '2013-08-19', 'VISION JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1443', '2', '0', '2013-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1347', '2', '1', '2013-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1443', '1', '0', '2013-08-20', 'BODEGA FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '11', '0', '2013-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1414', '2', '0', '2013-08-26', 'calama', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1408', '2', '1', '2013-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1211', '5', '1', '2013-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1292', '1', '0', '2013-08-27', 'terminal 2 piso', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR145', '1', '1', '2013-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1454', '1', '0', '2013-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1454', '1', '0', '2013-08-27', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1353', '2', '0', '2013-09-05', 'BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'EP1357', '2', '0', '2013-09-05', 'BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1281', '1', '0', '2013-09-09', 'LICEO POLITECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1224h', '4', '1', '2013-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1455', '1', '0', '2013-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'BR1455', '1', '0', '2013-09-09', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1322', '2', '0', '2013-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1430', '2', '0', '2013-09-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '8', '0', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1172', '3', '0', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1456', '1', '0', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1456', '1', '0', '2013-10-03', 'JUZGADO POLICIA LOCAL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1430', '1', '0', '2013-10-03', 'JUZGAO POLICIA LOCAL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '2', '0', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1357', '3', '1', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1353', '3', '1', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1317', '2', '1', '2013-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1429', '1', '0', '2013-10-03', 'POSTA RURAL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '3', '0', '2013-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1429', '1', '0', '2013-10-04', 'POSTA RURAL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('61930500', 'BR1434', '1', '0', '2013-10-08', 'MI BARRIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1202', '2', '0', '2013-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1309', '4', '0', '2013-10-16', 'POSTA RURAL SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1457', '1', '0', '2013-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1457', '1', '0', '2013-10-18', 'DEPTO. CALIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1442', '2', '0', '2013-11-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'SH1181', '1', '0', '2013-11-11', 'venta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1181', '3', '0', '2013-11-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'BR1442', '2', '0', '2013-11-11', 'depto. venta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'LA1376', '2', '0', '2013-11-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'ZE1459', '1', '1', '2013-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1305', '3', '0', '2013-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1458', '1', '0', '2013-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'BR1458', '1', '1', '2013-11-14', 'CAUCHOS INDUSTRIALES', null);
INSERT INTO `clientemaquina` VALUES ('88918500', 'BR1304', '1', '0', '2013-11-14', 'JUMBO NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '10', '0', '2013-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1438', '3', '0', '2013-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76697710', 'BR1438', '2', '0', '2013-11-20', 'antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '1', '0', '2013-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'BR1460', '1', '0', '2013-11-20', 'CONTABILIDAD (RIVER SPA)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1461', '1', '0', '2013-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83484700', 'BR1461', '1', '0', '2013-11-25', 'CAMINO LA NEGRA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1462', '1', '0', '2013-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78808210', 'BR1462', '1', '0', '2013-11-25', 'CAMINO A CHIU-CHIU', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1232', '2', '0', '2013-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'XE1169', '1', '0', '2013-12-04', 'MATRICULA  2014', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1181', '4', '1', '2013-12-04', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('72224100', 'KY1232', '1', '0', '2013-12-04', 'HOTEL ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '1', '0', '2013-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('88918500', 'BR1463', '1', '0', '2013-12-10', 'DERCO JUMBO NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '6', '0', '2013-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1169', '5', '1', '2013-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1304', '1', '0', '2013-12-16', 'MATRICULA 2014', '0');
INSERT INTO `clientemaquina` VALUES ('76105206', 'TO1398', '1', '0', '2013-12-18', 'buildtek', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'XE1171', '2', '0', '2013-12-19', 'COMUNICACION Y EVENTOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1340', '3', '1', '2014-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76105206', 'TO1333 ', '1', '0', '2014-01-02', 'RRHH', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1398', '4', '0', '2014-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '6', '0', '2014-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1464', '1', '0', '2014-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1464', '1', '1', '2014-01-20', 'OF. ALCALDE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416', '2', '0', '2014-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78791070', 'BR1295', '1', '0', '2014-01-20', 'REMPLAZO', '0');
INSERT INTO `clientemaquina` VALUES ('78791070', 'BR1416', '2', '0', '2014-01-24', 'antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1466', '1', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1466', '1', '0', '2014-01-24', '', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1381', '3', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1381', '2', '0', '2014-01-24', 'SECOPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1467', '1', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1467', '1', '0', '2014-01-24', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1452', '2', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1435', '2', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1465', '1', '0', '2014-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1465', '1', '0', '2014-01-24', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '7', '0', '2014-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76079600', 'BR1295', '1', '0', '2014-01-27', 'REMPLAZO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1410', '2', '0', '2014-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1171', '11', '1', '2014-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1322', '1', '0', '2014-03-03', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1234', '4', '0', '2014-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1468', '1', '0', '2014-03-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1468', '1', '0', '2014-03-05', 'SECRETARIO MUNICIPAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '3', '0', '2014-03-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '8', '0', '2014-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76079600', 'KY1435', '2', '0', '2014-03-06', 'MADERO', '0');
INSERT INTO `clientemaquina` VALUES ('89701900', 'BR1295', '1', '0', '2014-03-06', 'abogado bonilla', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '2', '0', '2014-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1470', '1', '0', '2014-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76270424', 'TO1470', '1', '0', '2014-03-11', 'PROYECTO TALTAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1240', '7', '1', '2014-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1290', '2', '0', '2014-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1471', '1', '0', '2014-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'BR1471', '1', '0', '2014-03-13', 'RADIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1472', '1', '0', '2014-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '7', '0', '2014-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1410', '2', '0', '2014-03-17', 'MATRICULA 2014', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1438', '4', '0', '2014-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1469', '1', '0', '2014-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'BR1469', '1', '0', '2014-04-03', 'CANAL 95 TV', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1411', '2', '0', '2014-05-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1260', '5', '0', '2014-05-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1411', '1', '0', '2014-05-15', 'GARAJE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1313', '2', '1', '2014-05-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1438', '1', '1', '2014-05-15', 'ESCUELA EE.UU.', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1281', '12', '1', '2014-05-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1344', '1', '0', '2014-05-16', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1018', '5', '0', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1395', '1', '1', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1378', '2', '0', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1233', '3', '0', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1280', '3', '1', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1267h', '4', '1', '2014-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1245', '4', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1479', '1', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'TO1479', '1', '0', '2014-05-20', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1388', '2', '1', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1426', '2', '1', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1293', '3', '1', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1232', '3', '1', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1372', '2', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1373', '2', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1372', '1', '0', '2014-05-20', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1481', '1', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1473', '1', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1482', '1', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1473', '1', '0', '2014-05-20', 'CONTABILIDAD P-3', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1481', '1', '0', '2014-05-20', 'RRHH', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1482', '1', '0', '2014-05-20', 'FINANZAS 2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1483', '1', '0', '2014-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1483', '1', '0', '2014-05-20', 'GERENCIA GENERAL -4TO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1476', '1', '0', '2014-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1476', '1', '0', '2014-05-22', 'SOUTHERN ROCK (ZONGE)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1414', '3', '0', '2014-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1478', '1', '0', '2014-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1437', '2', '0', '2014-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('73297300', 'BR1478', '1', '0', '2014-05-26', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1477', '1', '0', '2014-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76853500', 'BR1477', '1', '0', '2014-05-26', 'SGM', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1437', '1', '0', '2014-05-26', 'PEÃ‘ON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1333 ', '3', '1', '2014-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1480', '1', '0', '2014-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76105206', 'TO1480', '1', '0', '2014-05-26', 'RRHH', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1475', '1', '0', '2014-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1475', '1', '0', '2014-05-27', 'CONST. NAV. Y DIAZ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1027', '1', '0', '2014-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1304', '1', '0', '2014-05-27', 'ESC. ARTURO PRAT CHACON', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'SH1305', '1', '0', '2014-06-02', 'COLEGIO B. OHIGGINS P.I.E', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1440', '2', '0', '2014-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1485', '1', '0', '2014-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1486', '1', '0', '2014-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76217844', 'BR1486', '1', '0', '2014-06-03', 'LABONORT SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('76217844', 'TO1485', '1', '0', '2014-06-03', 'LABONORT SALUD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1144', '1', '1', '2014-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1487', '1', '0', '2014-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'RI1487', '1', '0', '2014-06-10', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1389', '2', '0', '2014-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1389', '1', '0', '2014-07-01', 'ESC. B. O. DPTO. DIRECCIÃ“N', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '4', '0', '2014-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1344', '2', '0', '2014-07-01', 'LICEO POLITECNICO INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '5', '0', '2014-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1344', '2', '0', '2014-07-01', 'LICEO POLITECNICO INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '2', '0', '2014-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1380', '3', '0', '2014-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1490', '1', '0', '2014-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1490', '1', '0', '2014-07-17', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1491', '1', '0', '2014-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1491', '1', '0', '2014-07-18', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1174', '4', '1', '2014-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1391', '3', '1', '2014-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1386', '2', '0', '2014-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1494', '1', '0', '2014-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1494', '1', '0', '2014-07-29', 'FINANZAS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1467', '2', '0', '2014-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '1', '0', '2014-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1492', '1', '0', '2014-07-31', 'oficina de partes', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1493', '1', '0', '2014-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1493', '1', '0', '2014-08-04', 'ALCALDIA SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1467', '2', '0', '2014-08-05', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1496', '1', '0', '2014-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1495', '1', '0', '2014-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1495', '1', '0', '2014-08-05', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1496', '1', '0', '2014-08-05', 'CENTRO DISTRIBUCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '9', '0', '2014-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '10', '0', '2014-08-06', 'POSTA RURAL SIERRA GORDA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1034', '5', '1', '2014-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1495', '1', '0', '2014-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1495', '1', '0', '2014-08-06', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1419', '2', '0', '2014-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1497', '1', '0', '2014-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76217844', 'BR1497', '1', '0', '2014-08-06', '2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1455', '2', '1', '2014-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1298', '4', '1', '2014-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1379', '2', '0', '2014-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1379', '1', '0', '2014-08-19', 'ESC. SIERRA GORDA BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1309', '5', '0', '2014-08-20', 'POSTA RURAL SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1229', '2', '1', '2014-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1498', '1', '0', '2014-08-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1498', '1', '0', '2014-08-21', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1175', '6', '1', '2014-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'SH1233', '1', '0', '2014-08-22', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1467', '3', '0', '2014-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77797920', 'BR1467', '1', '0', '2014-08-26', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1499', '1', '0', '2014-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76625330', 'BR1499', '1', '0', '2014-08-27', 'AGGREKO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1467', '4', '0', '2014-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1501', '1', '0', '2014-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'TO1501', '1', '0', '2014-08-29', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1104', '3', '1', '2014-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'BR1463', '1', '0', '2014-09-29', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '1', '0', '2014-09-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1500', '1', '0', '2014-09-29', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '2', '0', '2014-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1500', '1', '0', '2014-09-30', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('76105206', 'BR1419', '1', '0', '2014-09-30', 'RR.HH', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1512', '1', '0', '2014-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR1512', '1', '1', '2014-09-30', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('76105206', 'TO1440', '1', '0', '2014-09-30', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1440', '3', '0', '2014-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1506', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1506', '1', '0', '2014-10-01', 'SALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1510', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1511', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1511', '1', '0', '2014-10-01', 'MINERA MINISTRO HALES ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1510', '1', '0', '2014-10-01', 'MINERA MINISTRO HALES ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1505', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1505', '1', '0', '2014-10-01', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '3', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '9', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('89701900', 'BR1463', '1', '0', '2014-10-01', 'ABOGADO BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1251', '5', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1514', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1514', '1', '0', '2014-10-01', 'SALUD SALA DE ESTIMULACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1431', '2', '1', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1513', '1', '0', '2014-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1513', '1', '0', '2014-10-01', 'BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1299', '5', '1', '2014-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1467', '1', '0', '2014-10-02', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1365', '3', '1', '2014-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '1502', '1', '0', '2014-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', '1502', '1', '0', '2014-10-02', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1503', '1', '0', '2014-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1503', '1', '0', '2014-10-02', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1380', '1', '0', '2014-10-03', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1419', '3', '0', '2014-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77650710', 'BR1419', '1', '0', '2014-10-08', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1520', '1', '0', '2014-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1490', '2', '0', '2014-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'BR1490', '1', '0', '2014-10-14', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1518', '1', '0', '2014-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96870780', 'TO1518', '1', '0', '2014-10-16', 'ADMINISTRACIÃ“N', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1517', '1', '0', '2014-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96870780', 'TO1517', '1', '0', '2014-10-16', 'ADM', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1519', '1', '0', '2014-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1519', '1', '0', '2014-10-20', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1309', '11', '1', '2014-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1295', '1', '0', '2014-10-20', 'POSTA RURAL SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1520', '1', '0', '2014-10-24', 'EDIFICIOS', '0');
INSERT INTO `clientemaquina` VALUES ('61930500', 'TO1414', '1', '0', '2014-10-24', 'BARRIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1522', '1', '0', '2014-10-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '3', '0', '2014-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1523', '1', '0', '2014-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1521', '1', '0', '2014-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76105206', 'TO1521', '1', '0', '2014-11-05', 'BUILDTEK ANF', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1480', '2', '0', '2014-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1434', '1', '0', '2014-11-05', 'FAENA ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1404', '2', '0', '2014-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1452', '1', '1', '2014-11-07', 'TESORERIA', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1404', '2', '0', '2014-11-07', 'CECOM NORTE ANF', '0');
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1523', '1', '0', '2014-11-07', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1311', '2', '1', '2014-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1401', '3', '0', '2014-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '2', '0', '2014-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1492', '2', '0', '2014-11-10', 'SECOPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1524', '1', '0', '2014-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1525', '1', '0', '2014-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1526', '1', '0', '2014-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1527', '1', '0', '2014-11-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1504', '1', '0', '2014-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1504', '1', '0', '2014-11-13', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1527', '1', '0', '2014-11-17', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1528', '1', '0', '2014-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76217844', 'TO1528', '1', '0', '2014-11-18', 'PSICOTECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1497', '2', '0', '2014-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1522', '1', '0', '2014-11-18', 'oficina de partes', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1470', '2', '0', '2014-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1383', '1', '0', '2014-11-24', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1200', '3', '0', '2014-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1526', '1', '0', '2014-11-24', 'DPTO. SOCIAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '8', '0', '2014-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1525', '1', '0', '2014-11-24', 'ADMINISTRACIÃƒï¿½N', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1342', '4', '0', '2014-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1524', '1', '0', '2014-11-24', 'DPTO. JURIDICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1506', '2', '1', '2014-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1497', '1', '0', '2014-12-01', 'INSER ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1475', '2', '0', '2014-12-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1378', '1', '0', '2014-12-10', 'CARLOS CONDELL INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1530', '1', '0', '2014-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1530', '1', '0', '2014-12-10', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1504', '2', '0', '2014-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '1529', '1', '0', '2014-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '1531', '1', '0', '2014-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1532', '1', '0', '2014-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', '1529', '1', '0', '2014-12-22', 'antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1401', '3', '0', '2014-12-22', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1504', '1', '0', '2014-12-22', 'Bernardo Ohiggins ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1305', '4', '0', '2014-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1490', '3', '0', '2014-12-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', '1531', '1', '0', '2014-12-24', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76307633', 'BR1532', '1', '1', '2014-12-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1533', '1', '0', '2015-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1070', '3', '0', '2015-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1533', '2', '0', '2015-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '4', '0', '2015-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'RI1070', '4', '0', '2015-01-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1434', '2', '0', '2015-01-20', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1305', '2', '0', '2015-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'KY1342', '1', '0', '2015-01-20', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1534', '1', '0', '2015-01-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96917120', 'BR1534', '1', '1', '2015-01-30', 'CHUQUICAMATA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1177', '2', '0', '2015-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61002008', 'XE1177', '1', '0', '2015-02-25', 'DPTO. JURIDICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1327', '3', '1', '2015-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1326', '2', '1', '2015-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1475', '2', '0', '2015-02-26', 'Navarrete Casas', '0');
INSERT INTO `clientemaquina` VALUES ('79705403', 'TO1470', '1', '0', '2015-03-09', 'SIEC', '0');
INSERT INTO `clientemaquina` VALUES ('76079600', 'KY1436', '1', '0', '2015-03-09', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1521', '2', '0', '2015-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1490', '1', '0', '2015-03-10', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1237', '4', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1518', '2', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'TO1518', '1', '0', '2015-03-11', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158921', '1', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158923', '1', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158879', '1', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158901', '1', '1', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158920', '1', '1', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '3', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1457', '2', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1457', '1', '0', '2015-03-11', 'EE. UU.', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'H4J158921', '1', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'H4J158879', '1', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'H4J158923', '1', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'U63089J3N5', '1', '1', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '9J3N529539', '1', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', '9J3N529539', '1', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1346', '3', '1', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1383', '1', '0', '2015-03-11', 'CASA DE LA CULTURA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1385', '3', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1480', '1', '0', '2015-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1480', '3', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1480', '1', '0', '2015-03-11', 'ESCUELA G 130 SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1541', '1', '0', '2015-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1541', '1', '0', '2015-03-11', 'ESCUELA G130 RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1462', '2', '0', '2015-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78808210', 'BR1462', '2', '0', '2015-03-13', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1543', '1', '0', '2015-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1543', '1', '0', '2015-03-27', 'EE. UU. PIE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1462', '3', '1', '2015-03-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1484', '1', '0', '2015-03-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78808210', 'BR1484', '1', '0', '2015-03-31', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '1', '0', '2015-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1437', '3', '0', '2015-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '1', '0', '2015-04-01', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1510', '2', '1', '2015-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1511', '2', '1', '2015-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1437', '2', '0', '2015-04-01', 'ministro hayer ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1432', '2', '1', '2015-04-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1545', '1', '0', '2015-04-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1545', '1', '0', '2015-04-10', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1546', '1', '0', '2015-04-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1546', '1', '0', '2015-04-10', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1430', '3', '0', '2015-04-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1547', '1', '0', '2015-04-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1547', '1', '0', '2015-04-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1548', '1', '0', '2015-04-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79826770', 'TO1548', '1', '1', '2015-04-14', 'JUMBO NORTE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1544', '1', '0', '2015-04-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1544', '1', '0', '2015-04-15', 'BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1601', '1', '0', '2015-04-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1600', '1', '0', '2015-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO-1600', '1', '0', '2015-04-16', 'SECRETARIA RECTORIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1375', '3', '1', '2015-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1602', '1', '0', '2015-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO-1602', '1', '0', '2015-04-16', 'RECTORIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1322', '3', '0', '2015-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1601', '1', '0', '2015-04-20', 'central de apuntes ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'U63482K3J2', '1', '1', '2015-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1435', '3', '0', '2015-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78915940', 'KY1435', '1', '0', '2015-04-20', 'MADERO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1604', '1', '0', '2015-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1605', '1', '0', '2015-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO-1605', '1', '0', '2015-04-23', 'ESC.G121 BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1401', '4', '1', '2015-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1607', '1', '1', '2015-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1544', '1', '1', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1334', '5', '1', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1519', '2', '1', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO-1604', '1', '0', '2015-04-28', 'central de apuntes ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1608', '1', '0', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO-1608', '1', '0', '2015-04-28', 'central de apuntes ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1545', '1', '0', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR-1545', '1', '0', '2015-04-28', 'RECEPCION CATALUÑA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1609', '1', '0', '2015-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1610', '1', '1', '2015-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1610', '1', '1', '2015-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1611', '1', '0', '2015-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1611', '1', '0', '2015-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1612', '1', '1', '2015-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1613', '1', '0', '2015-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1550', '1', '0', '2015-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1550', '1', '0', '2015-05-05', 'antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '2', '0', '2015-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '2', '0', '2015-05-05', 'FAENA RADOMIRO TOMIC', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR-1613', '1', '0', '2015-05-05', 'FAENA RADOMIRO TOMIC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1608', '2', '1', '2015-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO-1609', '1', '0', '2015-05-06', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1344', '6', '1', '2015-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1538', '1', '0', '2015-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '1', '0', '2015-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '1', '0', '2015-05-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1538', '1', '0', '2015-05-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1612', '1', '0', '2015-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1604', '2', '1', '2015-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'to1618', '1', '0', '2015-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'to1618', '1', '0', '2015-05-22', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1617', '1', '0', '2015-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1616', '1', '0', '2015-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1615', '1', '0', '2015-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1615', '1', '0', '2015-05-22', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1612', '1', '0', '2015-05-25', 'COPIAPO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRIS1001', '1', '0', '2015-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78104070', 'EXRIS1001', '1', '1', '2015-05-26', 'CLIENTE EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBRO1002', '1', '0', '2015-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76138505', 'EXBRO1002', '1', '1', '2015-05-26', 'CLIENTE EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBRO1003', '1', '0', '2015-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77939000', 'EXBRO1003', '1', '1', '2015-05-26', 'CLIENTE EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBRO1004', '1', '0', '2015-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBRO1005', '1', '0', '2015-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBRO1004', '1', '1', '2015-05-26', 'CLIENTE EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('11820509', 'EXBRO1005', '1', '1', '2015-05-26', 'CLIENTE EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1609', '2', '0', '2015-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'TO1521', '1', '0', '2015-05-27', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1006', '1', '0', '2015-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76037556', 'EXTO1006', '1', '0', '2015-06-01', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1007', '1', '0', '2015-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15021769', 'EXTO1007', '1', '1', '2015-06-01', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1008', '1', '0', '2015-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('94879000', 'EXTO1008', '1', '0', '2015-06-01', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1009', '1', '0', '2015-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96828740', 'EXTO1009', '1', '1', '2015-06-01', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1010', '1', '0', '2015-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1011', '1', '0', '2015-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1010', '1', '1', '2015-06-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1011', '1', '1', '2015-06-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1619', '1', '0', '2015-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96912990', 'BR1619', '1', '0', '2015-06-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1616', '1', '0', '2015-06-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1617', '1', '0', '2015-06-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1012', '1', '0', '2015-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'EXBR1012', '1', '0', '2015-06-05', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1013', '1', '0', '2015-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1014', '1', '0', '2015-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('80207900', 'EXBR1013', '1', '1', '2015-06-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76176613', 'EXTO1014', '1', '1', '2015-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1052', '3', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1620', '1', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1620', '1', '1', '2015-06-11', 'CENTRO COPIADO ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1621', '1', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1621', '1', '0', '2015-06-11', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1622', '1', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1622', '1', '1', '2015-06-11', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'RI1441', '1', '1', '2015-06-11', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1623', '1', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'KY1623', '1', '1', '2015-06-11', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1624', '1', '0', '2015-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1624', '1', '1', '2015-06-11', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1373', '1', '1', '2015-06-12', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1015', '1', '0', '2015-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXSH1016', '1', '0', '2015-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76204669', 'EXRI1015', '1', '1', '2015-06-12', 'EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('76204669', 'EXSH1016', '1', '1', '2015-06-12', 'EXTRENO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1017', '1', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777070', 'EXTO1017', '1', '0', '2015-06-15', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', '123456', '2', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1018', '1', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76092002', 'EXBR1018', '1', '1', '2015-06-15', 'EXTERNO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1502', '1', '1', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '1502', '2', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1502', '1', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'RIS1502', '1', '0', '2015-06-15', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1625', '1', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1502', '2', '1', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'RIS1625', '1', '0', '2015-06-15', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '3', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1503', '2', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '1529', '2', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1505', '2', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1500', '1', '0', '2015-06-15', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1503', '1', '0', '2015-06-15', 'ANTOFAGASTA', '1');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1529', '1', '0', '2015-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1529', '1', '0', '2015-06-15', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1505', '1', '0', '2015-06-15', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1019', '1', '0', '2015-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1020', '1', '0', '2015-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'EXTO1019', '1', '0', '2015-06-16', 'EXTERNA VISION ', '0');
INSERT INTO `clientemaquina` VALUES ('13011790', 'EXBR1020', '1', '0', '2015-06-16', 'EXTERNA JUMBO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '1', '0', '2015-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76155777', 'BR1614', '1', '0', '2015-06-16', 'FAERNA SPENCE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1021', '1', '0', '2015-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77254640', 'EXBR1021', '1', '1', '2015-06-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1025', '1', '0', '2015-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76052745', 'EXBR1025', '1', '1', '2015-06-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1436', '2', '1', '2015-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1626', '1', '0', '2015-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76079600', 'BR1626', '1', '0', '2015-06-17', 'MADERO FM', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1627', '1', '0', '2015-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1627', '1', '0', '2015-06-18', 'faena peÃ±on', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', '1531', '2', '0', '2015-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1531', '1', '0', '2015-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'BR1531', '1', '0', '2015-06-18', 'TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1026', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1027', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77412250', 'EXBR1026', '1', '1', '2015-06-23', 'EXTERNA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('77412250', 'EXBR1027', '1', '1', '2015-06-23', 'EXTERNO CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1494', '2', '1', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1629', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1629', '1', '0', '2015-06-23', 'FINANZAS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1630', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1630', '1', '0', '2015-06-23', 'SECPLAC BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1631', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1631', '1', '0', '2015-06-23', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1632', '1', '0', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1522', '2', '1', '2015-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1632', '1', '0', '2015-06-23', 'OFICINA DE PARTE BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1626', '2', '0', '2015-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78915940', 'BR1626', '1', '0', '2015-06-24', 'MADERO  AFTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1057', '4', '0', '2015-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1633', '1', '0', '2015-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019073', '123456', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', '1502', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', '1529', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', '1531', '1', '1', '2015-07-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'CA1056', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'CA1105', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'CA1118', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1042', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1044', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'NA3413', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1045', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1093', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1156', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1201', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'DI1213', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'GE1246', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'IN1152', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'LA1084', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'LA1150', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'OL10003', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'LA1167', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'LA1376', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'MI1103', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'MI1124', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'MI1245', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'MI1290', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'NA1094', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'OL1003', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'OL1148', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'PB1072', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1015', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1091', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1172', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1190', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1200', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1202', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1203', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1260', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1262', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'XE1172', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'RI1287', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SA1339', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1001', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1022', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1036', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1133', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1146', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1155', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1182', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1192', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1217', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1234', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1238', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1242', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1243', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1251', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1268 ', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'XE1305', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'SH1305', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1018', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1021', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1023', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1024', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1026', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1027', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1031', '2', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1040', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1052', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1053', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1057', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1073', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1076', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1081', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1086', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1116', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1129', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1130', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1132', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1138', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1139', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1166', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1191', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1199', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'KY1220', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1220', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1237', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1249', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1261', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TSQ03154', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'XE1050', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'XE1098', '1', '1', '2015-07-02', '', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1634', '1', '0', '2015-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1634', '1', '0', '2015-07-03', 'ADQUISICION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1517', '2', '0', '2015-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1633', '1', '0', '2015-07-03', 'SECPLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1215', '1', '1', '2015-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1054', '2', '1', '2015-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1435', '4', '0', '2015-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1017', '2', '1', '2015-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1028', '1', '0', '2015-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1356', '4', '1', '2015-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1636', '1', '0', '2015-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1636', '1', '0', '2015-07-06', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('96777070', 'EXTO1028', '1', '0', '2015-07-06', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1637', '1', '0', '2015-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1637', '1', '0', '2015-07-07', 'ALCALDIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1070', '4', '1', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1177', '3', '1', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1035', '2', '0', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1638', '1', '0', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1486', '2', '0', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1485', '2', '0', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1528', '2', '0', '2015-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'BR1486', '1', '0', '2015-07-08', 'PRIMERPISO', '0');
INSERT INTO `clientemaquina` VALUES ('76409216', 'TO1485', '1', '0', '2015-07-08', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('76409216', 'TO1528', '1', '0', '2015-07-08', 'PSICOTECNICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1619', '2', '0', '2015-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76179538', 'BR1619', '1', '0', '2015-07-09', 'AEROPUERTO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1364', '3', '0', '2015-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1428', '2', '0', '2015-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77669340', 'BR1428', '1', '0', '2015-07-09', 'JUMBO NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1293', '4', '1', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1628', '1', '0', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '9J3N529539', '2', '1', '2015-07-10', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1403', '3', '0', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1403', '3', '0', '2015-07-10', 'ESC. G101 SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1430', '2', '0', '2015-07-10', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '5', '0', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1434', '2', '0', '2015-07-10', 'DIRECCION DE EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1635', '1', '0', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1635', '1', '0', '2015-07-10', 'ESC. G-101 - BIBLIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1635', '2', '1', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1639', '1', '0', '2015-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1639', '1', '0', '2015-07-10', 'ESCUELA G-101 -BIBLIIOTECA', '0');
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1628', '1', '0', '2015-07-10', 'Escritura Publica', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1147', '2', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1342', '5', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1253', '1', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SA1082', '3', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1282', '5', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1204', '4', '0', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1503', '3', '0', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1437', '4', '0', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1602', '2', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1602', '1', '0', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1602', '1', '0', '2015-07-13', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1402', '2', '1', '2015-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1640', '1', '0', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '1', '0', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1035', '1', '1', '2015-07-14', 'ELIMINADA', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1204', '1', '1', '2015-07-14', 'ELIMINADA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158879', '2', '1', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158921', '2', '1', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'H4J158923', '2', '1', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1536', '1', '0', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '1', '0', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1537', '1', '0', '2015-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1536', '1', '0', '2015-07-14', 'MANTOS BLANCOS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '1', '0', '2015-07-14', 'MANTOS BLANCOS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1537', '1', '0', '2015-07-14', 'MANTOS BLANCOS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1641', '1', '0', '2015-07-14', 'radomiro tomic', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1640', '1', '0', '2015-07-14', 'EDIFICIO informatica', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1642', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1643', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1644', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1545', '2', '1', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1546', '2', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1547', '2', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1642', '1', '0', '2015-07-15', 'META PRESIDENCIAL', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1643', '1', '0', '2015-07-15', '3Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1644', '1', '0', '2015-07-15', '1Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1645', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1646', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1647', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1649', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1651', '1', '1', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1652', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1653', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1654', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1655', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1656', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1657', '1', '0', '2015-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1645', '1', '0', '2015-07-17', 'BODEGA ', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1646', '1', '0', '2015-07-17', 'BODEGA 2', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1647', '1', '0', '2015-07-17', 'BODEGA 2', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1648', '1', '0', '2015-07-17', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1611', '2', '0', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1649', '1', '0', '2015-07-17', 'BODEGA 2', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1650', '1', '0', '2015-07-17', 'BODEGA 2', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1657', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1652', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1653', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1654', '1', '1', '2015-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1655', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1656', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1611', '1', '1', '2015-07-17', 'BODEGA 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1645', '2', '0', '2015-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1646', '2', '0', '2015-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1601', '2', '1', '2015-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO-1609', '1', '0', '2015-07-21', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('8292366', 'BR1646', '1', '0', '2015-07-22', 'administracion', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1645', '1', '0', '2015-07-22', 'finanza', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1437', '3', '0', '2015-07-22', 'OFF CALAMA FAENA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1364', '1', '0', '2015-07-22', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1425', '2', '1', '2015-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '2', '0', '2015-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13643530', 'BR1533', '1', '1', '2015-07-23', 'EDIFICIO CENTENARIO OF 1402', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XXXX', '2', '0', '2015-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83407700', 'BR1648', '1', '0', '2015-07-24', 'VISTA PACIFICO', '0');
INSERT INTO `clientemaquina` VALUES ('77669340', 'TO1517', '1', '0', '2015-07-27', 'CECOM TERMINAR 1Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1660', '1', '0', '2015-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1660', '1', '0', '2015-07-28', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1609', '3', '0', '2015-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1658', '1', '0', '2015-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1659', '1', '0', '2015-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1030', '3', '1', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1658', '1', '0', '2015-07-30', 'secretaria municipal', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1069', '2', '0', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1659', '1', '0', '2015-07-30', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1662', '1', '0', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1662', '1', '1', '2015-07-30', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1029', '1', '0', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61008000', 'EXTO1029', '1', '1', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1030', '1', '0', '2015-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('90146000', 'EXBR1030', '1', '1', '2015-07-30', 'EXTERNA CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'U63572E5F1', '1', '1', '2015-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1194', '1', '1', '2015-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71529400', 'KY1231 ', '1', '0', '2015-08-04', 'ASOCIACION DE ABOGADOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '1', '0', '2015-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '2', '0', '2015-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1663', '1', '0', '2015-08-05', 'SUCURSAL CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1650', '1', '0', '2015-08-05', 'RADOMIRO TOMIC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '1', '0', '2015-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '1', '0', '2015-08-05', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1665', '1', '0', '2015-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1398', '1', '1', '2015-08-06', 'ELIMINADA ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'BR1665', '1', '0', '2015-08-07', 'recepsion', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1031', '1', '0', '2015-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76204669', 'EXBR1031', '1', '1', '2015-08-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1521', '3', '0', '2015-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1666', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1667', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1668', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1669', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1670', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1671', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1673', '1', '0', '2015-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1338', '4', '1', '2015-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'KY1435', '1', '0', '2015-08-11', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1495', '2', '0', '2015-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1368', '3', '0', '2015-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1666', '1', '0', '2015-08-11', 'adquisiciones', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1033', '1', '0', '2015-08-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1034', '1', '0', '2015-08-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('94879000', 'EXTO1033', '1', '0', '2015-08-18', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('94879000', 'EXTO1034', '1', '1', '2015-08-18', 'EXTERNA CALAMA CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1521', '1', '0', '2015-08-19', 'RT-CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1668', '1', '0', '2015-08-19', 'ASEO Y ORNATO', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1670', '1', '0', '2015-08-19', 'SENDA', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1671', '1', '0', '2015-08-19', 'OF. PROTECCION DE LA INFANCIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1640', '2', '0', '2015-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1640', '1', '0', '2015-08-20', 'CALL CENTER', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1497', '3', '0', '2015-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1364', '4', '1', '2015-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1437', '5', '1', '2015-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1667', '1', '1', '2015-08-26', 'BODEGA', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1669', '1', '0', '2015-08-26', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1672', '1', '0', '2015-08-26', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1673', '1', '0', '2015-08-26', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1675', '1', '0', '2015-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1676', '1', '0', '2015-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'RIS1675', '1', '0', '2015-08-26', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'RIS1676', '1', '0', '2015-08-26', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '1', '0', '2015-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1035', '1', '0', '2015-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99549130', 'EXBR1035', '1', '1', '2015-08-31', 'EXTERNA CLINICA CUMBRES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1675', '2', '0', '2015-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'RIS1675', '1', '0', '2015-09-01', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1442', '3', '0', '2015-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1396', '2', '1', '2015-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1036', '1', '0', '2015-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1036', '2', '0', '2015-09-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76120463', 'EXBR1036', '1', '1', '2015-09-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1678', '1', '1', '2015-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1679', '1', '0', '2015-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1680', '1', '0', '2015-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'BR1677', '1', '0', '2015-09-09', 'AdministraciÃ³n ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '2', '0', '2015-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1460', '1', '0', '2015-09-09', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1681', '1', '0', '2015-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1676', '2', '0', '2015-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'TO1680', '1', '0', '2015-09-11', 'central apuntes', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1681', '1', '1', '2015-09-11', 'central apuntes', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'RIS1676', '1', '1', '2015-09-11', 'central apuntes', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'TO1679', '1', '1', '2015-09-11', 'central apuntes', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '2', '0', '2015-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1096', '1', '1', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1270 ', '2', '1', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1682', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1684', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1685', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1688', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1689', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1692', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1694', '1', '0', '2015-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1495', '1', '0', '2015-09-23', 'OFF ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1672', '1', '0', '2015-09-23', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '3', '0', '2015-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1682', '1', '0', '2015-09-25', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1684', '1', '0', '2015-09-25', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1689', '1', '1', '2015-09-25', 'ASISTENTE SOCIAL', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1694', '1', '1', '2015-09-25', 'RECTORIA (OFICINA DEL RECTOR)', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1692', '1', '0', '2015-09-25', 'PSICOLOGIA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1685', '1', '0', '2015-09-25', 'ADM Y FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1683', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1686', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1687', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1690', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1691', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1683', '1', '1', '2015-09-25', 'DIRECCION ACADEMICA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1697', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1698', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1699', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1700', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1702', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1704', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1705', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1706', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1707', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1708', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1711', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1712', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1713', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1714', '1', '0', '2015-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1688', '1', '0', '2015-09-25', 'GIMNASIO 2', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1697', '1', '0', '2015-09-25', 'DIRECCION ACADEMICA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1686', '1', '0', '2015-09-25', 'COMPUTACION BASICA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1687', '1', '1', '2015-09-25', 'PASTORAL', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1699', '1', '0', '2015-09-25', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1712', '1', '1', '2015-09-25', 'RELIGION', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1702', '1', '1', '2015-09-25', 'ARTE', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1698', '1', '0', '2015-09-25', 'ACADEMIA CULTURALES', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1691', '1', '0', '2015-09-25', 'LENGUAJE', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1705', '1', '0', '2015-09-25', 'CIENCIAS', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1713', '1', '1', '2015-09-25', 'INSPECTORIA TERCER CICLO', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1711', '1', '0', '2015-09-25', 'INGLES', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1706', '1', '0', '2015-09-25', 'INSPECTORIA 4TO CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1704', '1', '0', '2015-09-25', 'MATEMATICAS', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1708', '1', '1', '2015-09-25', 'GIMNASIO', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1714', '1', '0', '2015-09-25', 'REPUESTO', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1690', '1', '0', '2015-09-25', 'BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1707', '1', '0', '2015-09-25', 'HISTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1700', '1', '0', '2015-09-25', 'INSPECTORIA 1Â° CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1638', '1', '0', '2015-09-25', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1069', '2', '0', '2015-09-30', 'JUZGADO POLICIA LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1703', '1', '0', '2015-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1703', '1', '0', '2015-10-01', 'SALA DE PROFESORES PRIMER CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1715', '1', '0', '2015-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1710', '1', '0', '2015-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1709', '1', '0', '2015-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1715', '1', '1', '2015-10-01', 'SALA DE PROFESORES PRIMER CICLO', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1709', '1', '0', '2015-10-01', 'SALA DE PROFESORES 2DO CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1710', '1', '0', '2015-10-01', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1377', '3', '1', '2015-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1672', '1', '0', '2015-10-08', 'RADOMIRO TOMIC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '1', '0', '2015-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '1', '0', '2015-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1718', '1', '0', '2015-10-13', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1716', '1', '0', '2015-10-13', 'PREVENCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1184', '2', '1', '2015-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1476', '2', '0', '2015-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1717', '1', '0', '2015-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '1', '0', '2015-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1722', '1', '0', '2015-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1673', '2', '0', '2015-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1722', '1', '0', '2015-10-15', 'ZONGE', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1673', '1', '0', '2015-10-15', 'TRANSITO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1630', '2', '1', '2015-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1723', '1', '0', '2015-10-15', 'SECPLAC BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1505', '3', '0', '2015-10-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1427', '2', '1', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1424', '2', '1', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1423', '2', '0', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1428', '3', '0', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1404', '3', '0', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1384', '7', '1', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '6', '0', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1517', '3', '1', '2015-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1719', '1', '0', '2015-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1717', '1', '1', '2015-10-27', 'BODEGA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1720', '1', '0', '2015-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1720', '1', '1', '2015-10-27', 'BODEGA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1721', '1', '0', '2015-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1721', '1', '0', '2015-10-27', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1724', '1', '0', '2015-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1724', '1', '0', '2015-10-27', 'BOODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1725', '1', '0', '2015-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1725', '1', '0', '2015-10-27', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1726', '1', '0', '2015-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1726', '1', '0', '2015-10-28', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1320', '2', '1', '2015-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1422', '2', '0', '2015-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1336', '3', '1', '2015-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1423', '1', '0', '2015-10-30', 'ESCUELA ESPECIAL OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1444', '2', '1', '2015-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70385000', 'BR1719', '1', '0', '2015-10-30', 'INFORMATICA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1710', '2', '0', '2015-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1727', '1', '0', '2015-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1727', '1', '0', '2015-11-03', 'SALA PROFESORES 2 CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1701', '1', '0', '2015-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1701', '1', '0', '2015-11-03', 'INSPECTORIA 1 CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1422', '1', '0', '2015-11-04', 'ADMISION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1252', '5', '1', '2015-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1428', '1', '0', '2015-11-09', 'ADMISION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1478', '2', '0', '2015-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1725', '2', '0', '2015-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('73297300', 'BR1725', '1', '0', '2015-11-10', 'CREO ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1478', '1', '1', '2015-11-11', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1724', '2', '0', '2015-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1724', '1', '0', '2015-11-13', 'M-T SUPER INTENDENCIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1665', '2', '1', '2015-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1328', '2', '1', '2015-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1442', '1', '0', '2015-11-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1728', '1', '0', '2015-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1728', '1', '0', '2015-11-23', 'COLOSO', '0');
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1505', '1', '0', '2015-11-26', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1476', '1', '0', '2015-11-27', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1733', '1', '0', '2015-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1734', '1', '0', '2015-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1735', '1', '0', '2015-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1736', '1', '0', '2015-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '3', '0', '2015-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '2', '0', '2015-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '3', '0', '2015-12-03', 'MINISTRO HALES', '0');
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1733', '1', '0', '2015-12-11', 'oficina notario ', '0');
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1734', '1', '1', '2015-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1735', '1', '0', '2015-12-11', 'SEGUNDO PISO COMPRA Y VENTA', '0');
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1736', '1', '0', '2015-12-11', 'SEGUNDO PISO ARCHIVO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '2', '0', '2015-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '2', '0', '2015-12-11', 'MANTOS BLANCOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1499', '2', '0', '2015-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1529', '2', '0', '2015-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1529', '1', '0', '2015-12-15', 'SEGUNDO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1008', '2', '1', '2015-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1739', '1', '0', '2016-01-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1739', '1', '0', '2016-01-04', 'TESORERIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '1', '0', '2016-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1669', '2', '0', '2016-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1732', '1', '0', '2016-01-06', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1669', '1', '0', '2016-01-06', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1248', '2', '1', '2016-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1646', '3', '0', '2016-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1037', '1', '0', '2016-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70995200', 'EXTO1037', '1', '1', '2016-01-11', 'EXTERNA CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1038', '1', '0', '2016-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70995200', 'EXTO1038', '1', '1', '2016-01-11', 'EXTERNA CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1039', '1', '1', '2016-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1695', '1', '0', '2016-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1695', '1', '0', '2016-01-12', 'EE.UU.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1696', '1', '0', '2016-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1696', '1', '0', '2016-01-12', 'EE.UU.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1741', '1', '0', '2016-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '1', '0', '2016-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1743', '1', '0', '2016-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1537', '2', '0', '2016-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1740', '1', '0', '2016-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1740', '1', '0', '2016-01-15', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1385', '4', '0', '2016-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1385', '1', '1', '2016-01-19', 'DE BAJA', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1386', '1', '1', '2016-01-19', 'DE BAJA', null);
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1322', '1', '1', '2016-01-19', 'DE BAJA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1744', '1', '0', '2016-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1745', '1', '0', '2016-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1746', '1', '0', '2016-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1747', '1', '0', '2016-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1741', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1742', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1743', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1744', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1745', '1', '1', '2016-01-19', 'BODEGA', null);
INSERT INTO `clientemaquina` VALUES ('17723828', 'TO1746', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('17723828', 'BR1747', '1', '0', '2016-01-19', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '2', '0', '2016-01-19', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1206', '6', '1', '2016-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1223', '10', '1', '2016-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1621', '2', '1', '2016-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1529', '3', '1', '2016-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1748', '1', '0', '2016-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1748', '1', '0', '2016-01-22', 'SEGUNDO PISO CONSERVADOR ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1291', '4', '1', '2016-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO-1609', '1', '0', '2016-01-27', 'D.O.M', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1292', '1', '0', '2016-02-02', 'CONTABILIDAD (PRESTAMO)', '0');
INSERT INTO `clientemaquina` VALUES ('15019073', 'TO1325', '1', '1', '2016-02-02', 'ELIMINADA DEL INVENTARIO ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1040', '1', '0', '2016-02-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5554286', 'EXBR1040', '1', '1', '2016-02-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1752', '1', '0', '2016-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1751', '1', '0', '2016-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1752', '1', '0', '2016-02-11', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('11872506', 'TO1751', '1', '0', '2016-02-11', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1445', '2', '0', '2016-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1414', '4', '1', '2016-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1392', '4', '1', '2016-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1729', '1', '0', '2016-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'BR1729', '1', '0', '2016-02-16', '5to PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '7', '0', '2016-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1631', '2', '0', '2016-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1292', '1', '0', '2016-02-25', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1466', '2', '1', '2016-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1476', '3', '0', '2016-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1476', '1', '0', '2016-02-25', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '1', '0', '2016-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1753', '1', '0', '2016-03-01', 'COLOSO ESC-12001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1422', '3', '0', '2016-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1041', '1', '0', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61979930', 'EXTO1041', '1', '0', '2016-03-04', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1042', '1', '0', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1043', '1', '0', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1028', '2', '1', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78451050', 'EXTBR1042', '1', '1', '2016-03-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('78451050', 'EXTBR1043', '1', '1', '2016-03-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTHP1045', '1', '0', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77134310', 'EXTHP1045', '1', '1', '2016-03-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTEP1046', '1', '0', '2016-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7640567', 'EXTEP1046', '1', '1', '2016-03-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1747', '2', '0', '2016-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16209287', 'BR1747', '1', '1', '2016-03-10', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1531', '2', '0', '2016-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1743', '2', '0', '2016-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1743', '1', '0', '2016-03-10', 'TESORERIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1757', '1', '0', '2016-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1757', '1', '1', '2016-03-10', 'OFICINA OMIL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1012', '2', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1749', '1', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76464003', 'TO1749', '1', '0', '2016-03-14', 'SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1380', '4', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '2', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1742', '1', '0', '2016-03-14', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1758', '1', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '2', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '2', '0', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '1', '0', '2016-03-14', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1495', '3', '1', '2016-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '2', '0', '2016-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1476', '4', '0', '2016-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1476', '1', '0', '2016-03-23', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1497', '2', '0', '2016-03-23', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1499', '1', '0', '2016-03-23', 'RADOMIRO TOMIC 10001', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'RIS1758', '1', '0', '2016-03-24', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1369', '4', '1', '2016-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '1', '0', '2016-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76495040', 'BR1759', '1', '0', '2016-03-28', 'AKASA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1750', '1', '0', '2016-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1750', '1', '0', '2016-03-28', 'NOTARIA LASCAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1292', '8', '1', '2016-03-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1422', '1', '0', '2016-03-31', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1644', '2', '1', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1642', '2', '1', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1643', '2', '1', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1760', '1', '0', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1761', '1', '0', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1762', '1', '0', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1763', '1', '0', '2016-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70072600', 'BR1760', '1', '0', '2016-04-05', 'PRIMER PISO', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'BR1762', '1', '0', '2016-04-05', 'SEGUNDO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'BR1763', '1', '0', '2016-04-05', 'TERCER PISO', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'BR1761', '1', '0', '2016-04-05', 'META ', '0');
INSERT INTO `clientemaquina` VALUES ('89701900', 'BR1646', '1', '0', '2016-04-06', 'CARLOS BONILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '4', '0', '2016-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1627', '2', '1', '2016-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1503', '1', '1', '2016-04-07', 'BIBLIOTECA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1513', '2', '0', '2016-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1677', '1', '0', '2016-04-08', 'RADOMITO TOMIC 10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1764', '1', '0', '2016-04-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1764', '1', '0', '2016-04-08', 'DIDECO ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1716', '1', '0', '2016-04-12', 'PEÃ‘ON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1606', '1', '0', '2016-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1606', '1', '0', '2016-04-13', 'R-T  29015', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '1', '0', '2016-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76305905', 'BR1765', '1', '0', '2016-04-13', 'CARBON GRAFIC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '2', '0', '2016-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1368', '2', '0', '2016-04-18', 'RECURSOS HUMANOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '3', '0', '2016-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '3', '0', '2016-04-26', 'MANTOS BLANCOS OXIDOS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1537', '2', '0', '2016-04-26', 'MANTOS BLANCOS SULFURO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '2', '0', '2016-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76305905', 'BR1531', '1', '0', '2016-04-26', 'NOTARIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '1', '0', '2016-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1767', '1', '0', '2016-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1766', '1', '0', '2016-04-28', 'RT- 29015', '0');
INSERT INTO `clientemaquina` VALUES ('77794540', 'BR1767', '1', '0', '2016-04-28', 'SERVICIO A LA MINERIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '2', '0', '2016-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1614', '1', '0', '2016-05-12', 'MANTOS BLANCOS OXIDO', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1631', '1', '0', '2016-05-13', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1491', '2', '0', '2016-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1531', '3', '0', '2016-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13869531', 'BR1531', '1', '0', '2016-05-13', 'NOTARIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1368', '4', '1', '2016-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1741', '2', '0', '2016-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1481', '2', '0', '2016-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1741', '1', '1', '2016-05-17', 'BS-000-ADM014ES01 RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1475', '3', '0', '2016-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1641', '2', '0', '2016-05-19', 'REMUNERACIONES EDF. CATALUÃ‘A', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '3', '0', '2016-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1536', '2', '0', '2016-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '4', '0', '2016-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '3', '0', '2016-05-26', 'MMB-74003', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1768', '1', '0', '2016-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1769', '1', '0', '2016-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1768', '1', '0', '2016-05-26', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1769', '1', '0', '2016-05-26', 'FINANZA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1769', '2', '1', '2016-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1768', '2', '1', '2016-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1475', '1', '0', '2016-05-31', 'RECURSOS HUMANOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1737', '1', '0', '2016-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1738', '1', '0', '2016-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1738', '1', '0', '2016-06-01', 'ESCRITURA PUBLICA OFICINA 2', '0');
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1737', '1', '0', '2016-06-01', 'ESCRITURA PUBLICA OFICINA 3', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1771', '1', '0', '2016-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '1', '0', '2016-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1770', '1', '0', '2016-06-02', 'ES-12001-EWS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1772', '1', '0', '2016-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1771', '1', '0', '2016-06-03', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1772', '1', '0', '2016-06-03', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1537', '3', '0', '2016-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '4', '0', '2016-06-09', 'MMH-49003', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '2', '0', '2016-06-09', 'RT ADM-08000', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1047', '1', '0', '2016-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXTBR1047', '1', '0', '2016-06-10', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '2', '0', '2016-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1482', '2', '0', '2016-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '4', '0', '2016-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1481', '2', '0', '2016-06-14', 'CONTABILIDAD 2DO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1537', '3', '0', '2016-06-14', 'MANTOS BLANCOS   MMB-74003  SULFUROS   ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1773', '1', '0', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'BR1773', '1', '0', '2016-06-16', 'BODEGA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1048', '1', '0', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78048910', 'EXTBR1048', '1', '1', '2016-06-16', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1049', '1', '0', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76229725', 'EXTBR1049', '1', '1', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1050', '1', '0', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EXTBR1050', '1', '1', '2016-06-16', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1051', '1', '0', '2016-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76293630', 'EXTBR1051', '1', '1', '2016-06-16', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1774', '1', '0', '2016-06-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'BR1774', '1', '0', '2016-06-20', 'OFICINA 02', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1052', '1', '0', '2016-06-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77242290', 'EXTBR1052', '1', '1', '2016-06-20', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1055', '1', '0', '2016-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78459770', 'EXBR1055', '1', '1', '2016-06-21', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1053', '1', '0', '2016-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1054', '1', '0', '2016-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91947000', 'EXTO1053', '1', '1', '2016-06-21', 'EXTERNA CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('91947000', 'EXTO1054', '1', '0', '2016-06-21', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1056', '1', '0', '2016-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96596370', 'EXBR1056', '1', '1', '2016-06-21', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '3', '0', '2016-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1650', '2', '0', '2016-06-23', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1499', '3', '0', '2016-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1638', '2', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1765', '1', '0', '2016-06-30', 'RT -10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1536', '2', '0', '2016-06-30', 'MMH-44001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1057', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1058', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1059', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1060', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1061', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1062', '1', '0', '2016-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXTO1057', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXBR1058', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXBR1059', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXBR1060', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXTO1061', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('60400000', 'EXTO1062', '1', '0', '2016-06-30', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1776', '1', '0', '2016-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'BR1776', '1', '0', '2016-07-01', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1308', '4', '1', '2016-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1740', '2', '0', '2016-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1775', '1', '0', '2016-07-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1775', '1', '0', '2016-07-05', 'CALIDAD 5Â° PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1422', '4', '0', '2016-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1499', '1', '0', '2016-07-07', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1063', '1', '0', '2016-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXBR1063', '1', '0', '2016-07-08', 'EXTERNA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1063', '2', '1', '2016-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XXXX', '3', '0', '2016-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1638', '2', '0', '2016-07-13', 'MMH 49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1820', '1', '1', '2016-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1422', '1', '0', '2016-07-14', 'CONTABILIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('70072600', 'TO1546', '2', '0', '2016-07-14', 'META PISO 1', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1777', '1', '0', '2016-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1777', '1', '0', '2016-07-19', 'TESORERIA 1er PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1405', '2', '0', '2016-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1778', '1', '0', '2016-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1778', '1', '0', '2016-07-20', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1660', '2', '1', '2016-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1756', '1', '0', '2016-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1756', '1', '0', '2016-07-20', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '2', '0', '2016-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1497', '4', '0', '2016-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1538', '2', '0', '2016-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1732', '2', '0', '2016-07-26', 'MINISTRO HALES 49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1537', '4', '1', '2016-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '4', '0', '2016-07-27', 'MANTOS BLANCOS/SULFUROS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1233', '4', '1', '2016-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'BR1405', '1', '0', '2016-08-03', 'GUARDIA USEP', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1410', '3', '0', '2016-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '2', '0', '2016-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1065', '1', '0', '2016-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10751916', 'EXBR1065', '1', '1', '2016-08-04', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1006', '2', '1', '2016-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1066', '1', '0', '2016-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76037556', 'EXTO1066', '1', '0', '2016-08-09', 'AVAL CHILE ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '1', '0', '2016-08-09', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '3', '0', '2016-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1067', '1', '0', '2016-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('94879000', 'EXTO1067', '1', '0', '2016-08-11', 'EXTERNA CLIENTE TOSHIBA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1231 ', '9', '1', '2016-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71529400', 'BR1410', '1', '1', '2016-08-11', 'FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '4', '0', '2016-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '4', '0', '2016-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1404', '1', '0', '2016-08-22', 'POSTA RURAL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '4', '0', '2016-08-25', ' CALAMA MMH-49001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1497', '3', '0', '2016-08-25', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1616', '2', '0', '2016-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1616', '2', '0', '2016-08-26', 'MANTOS BLANCOS ', '0');
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1472', '1', '0', '2016-09-05', 'SEGUNDO PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1736', '2', '1', '2016-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1482', '1', '0', '2016-09-27', 'SEGUNDO PISO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1472', '2', '1', '2016-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '2', '0', '2016-10-04', 'FAENA PEÃ‘ON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1780', '1', '0', '2016-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1780', '1', '1', '2016-10-04', 'COMPUTACION BASICA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1781', '1', '0', '2016-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1782', '1', '0', '2016-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1783', '1', '0', '2016-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1764', '2', '0', '2016-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1782', '1', '0', '2016-10-06', 'DIRECCION DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1434', '6', '1', '2016-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1783', '1', '0', '2016-10-06', 'DIRECCION DE EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1629', '2', '1', '2016-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1781', '1', '0', '2016-10-06', 'FINANZAS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1505', '4', '0', '2016-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1513', '1', '0', '2016-10-06', 'PRIMER PISO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1068', '1', '1', '2016-10-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76275386', 'EXBR1012', '1', '1', '2016-10-12', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1490', '4', '1', '2016-10-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1616', '3', '1', '2016-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1477', '2', '0', '2016-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1784', '1', '0', '2016-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '3', '0', '2016-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '3', '0', '2016-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1784', '1', '0', '2016-10-14', 'MINERA GABY', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1477', '1', '0', '2016-10-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '5', '0', '2016-10-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '3', '0', '2016-10-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1788', '1', '0', '2016-10-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1746', '2', '0', '2016-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1746', '1', '0', '2016-10-18', 'Secplac Baquedano', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1446', '2', '1', '2016-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1788', '1', '0', '2016-10-18', 'DIRECCION DE SALUD BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '3', '0', '2016-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1429', '1', '0', '2016-10-19', 'MANTOS BLANCOS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1069', '1', '0', '2016-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'EXBR1069', '1', '1', '2016-10-24', 'GARANTIA BROTHER EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '4', '0', '2016-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '3', '0', '2016-10-26', 'FAENA PEÃ‘ON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1606', '2', '0', '2016-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99564360', 'TO1740', '1', '0', '2016-10-28', 'FAENA CENTINELA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1070', '1', '0', '2016-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12348211', 'EXBR1070', '1', '1', '2016-11-02', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1071', '1', '0', '2016-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16133899', 'EXBR1071', '1', '1', '2016-11-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1072', '1', '0', '2016-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15514339', 'EXBR1072', '1', '1', '2016-11-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('99564360', 'BR1535', '1', '0', '2016-11-07', 'FAENA CENTINELA', '0');
INSERT INTO `clientemaquina` VALUES ('99564360', 'TO1492', '1', '0', '2016-11-09', 'FAENA CENTINELA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1740', '3', '1', '2016-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1419', '4', '0', '2016-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1793', '1', '0', '2016-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1794', '1', '0', '2016-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1794', '1', '0', '2016-11-15', 'MATRICULAS SALA MULTIUSO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1738', '2', '0', '2016-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1505', '1', '0', '2016-11-15', 'NOTARIA LASCAR', '0');
INSERT INTO `clientemaquina` VALUES ('71102600', 'XXXX', '1', '1', '2016-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1716', '2', '0', '2016-11-21', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1677', '1', '0', '2016-11-22', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1073', '1', '0', '2016-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6593783', 'EXBR1073', '1', '1', '2016-11-23', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1074', '1', '0', '2016-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16435864', 'EXBR1074', '1', '1', '2016-11-23', 'GARANTÃA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1075', '1', '0', '2016-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12107547', 'EXBR1075', '1', '1', '2016-11-23', 'GARANTÃA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DEVOINSUMO', '1', '0', '2016-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1041', '2', '1', '2016-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '3', '0', '2016-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1445', '1', '0', '2016-11-28', 'MMH-49004 CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '2', '0', '2016-11-28', 'RTT-10001 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1497', '5', '1', '2016-11-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('33333333', 'DEVOINSUMO', '1', '1', '2016-11-29', 'FICTICIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1076', '1', '0', '2016-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76456068', 'EXBR1076', '1', '1', '2016-11-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1077', '1', '0', '2016-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76456068', 'EXBR1077', '1', '1', '2016-11-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1078', '1', '0', '2016-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1079', '1', '0', '2016-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12867333', 'EXBR1079', '1', '1', '2016-11-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('12107547', 'EXBR1078', '1', '1', '2016-11-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1080', '1', '0', '2016-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EXBR1080', '1', '1', '2016-11-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1795', '1', '0', '2016-11-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1795', '1', '0', '2016-11-30', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1796', '1', '0', '2016-11-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1796', '1', '0', '2016-11-30', 'MINERA GLUF', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1081', '1', '0', '2016-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12867333', 'EXBR1081', '1', '1', '2016-12-02', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('16209287', 'BR1419', '1', '0', '2016-12-05', 'OFICINA NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '5', '0', '2016-12-09', 'MMB-74003 OXIDOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1638', '3', '0', '2016-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1638', '3', '0', '2016-12-13', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1602', '2', '0', '2016-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1082', '1', '0', '2016-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76162391', 'EXBR1082', '1', '1', '2016-12-15', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXHP1083', '1', '0', '2016-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXHP1083', '1', '0', '2016-12-15', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1463', '1', '0', '2016-12-16', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1797', '1', '0', '2016-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1084', '1', '0', '2016-12-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('82200000', 'BR1797', '1', '0', '2016-12-21', '3 PISO', '0');
INSERT INTO `clientemaquina` VALUES ('61979930', 'EXTO1084', '1', '1', '2016-12-21', 'EXTERNA TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1738', '1', '0', '2016-12-27', 'CENTRAL APUNTES ', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1602', '2', '0', '2016-12-27', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1372', '3', '1', '2016-12-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '5', '0', '2016-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '4', '0', '2016-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '4', '0', '2016-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1085', '1', '0', '2017-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('59190140', 'EXBR1085', '1', '1', '2017-01-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'TO1492', '1', '0', '2017-01-04', 'PRIMER PISO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1412', '2', '1', '2017-01-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '4', '0', '2017-01-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1445', '3', '0', '2017-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '3', '0', '2017-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TALLER', '1', '0', '2017-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TALLER', '2', '1', '2017-01-09', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1732', '3', '0', '2017-01-10', 'MMH -49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1409', '2', '1', '2017-01-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1677', '1', '0', '2017-01-10', 'EGIS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '3', '0', '2017-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1793', '1', '0', '2017-01-16', 'EDIFICIO LAS EMPRESAS 801', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1793', '2', '0', '2017-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '3', '0', '2017-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '5', '0', '2017-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'to1618', '2', '0', '2017-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1632', '2', '1', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1744', '2', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1744', '1', '0', '2017-02-03', 'OFICINA DE PARTES ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1790', '1', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1790', '1', '0', '2017-02-03', 'DIRECCION DE SECPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'HP1798', '1', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'HP1798', '1', '0', '2017-02-03', 'SECPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1429', '2', '0', '2017-02-03', 'MANTOS BLANCOS 74003', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1786', '1', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1789', '1', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1786', '1', '0', '2017-02-03', 'SECRETARIA ESCU. BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1541', '2', '1', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1493', '2', '0', '2017-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1789', '1', '0', '2017-02-03', 'secretaria alcalde ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1802', '1', '0', '2017-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1802', '1', '1', '2017-02-06', 'FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '3', '0', '2017-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1606', '2', '1', '2017-02-08', 'BS-000-ADM014ES01 tercer piso', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1787', '1', '0', '2017-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76185799', 'BR1787', '1', '0', '2017-02-13', 'SAGITA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1439', '2', '1', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1800', '1', '0', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1799', '1', '0', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1801', '1', '0', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1800', '1', '0', '2017-02-21', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1428', '4', '0', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1799', '1', '0', '2017-02-21', 'ADMISION/INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1801', '1', '0', '2017-02-21', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY1435', '5', '1', '2017-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1803', '1', '0', '2017-02-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1803', '1', '0', '2017-02-23', 'MMB-74003', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RECARGATON', '1', '0', '2017-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'RECARGATON', '1', '1', '2017-02-24', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1087', '1', '0', '2017-02-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76950750', 'EXBR1087', '1', '1', '2017-02-27', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1615', '2', '1', '2017-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1060', '2', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTBR1047', '2', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1059', '2', '0', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1062', '2', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1061', '2', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1057', '2', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1484', '2', '0', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1389', '3', '1', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1428', '1', '0', '2017-03-06', 'P.I.E. ESCUELA B. OHIGGINS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '3', '0', '2017-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1614', '2', '0', '2017-03-08', 'RTT-29015', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1058', '2', '1', '2017-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1088', '1', '0', '2017-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1089', '1', '0', '2017-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76266064', 'EXBR1088', '1', '0', '2017-03-08', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('76266064', 'EXBR1089', '1', '0', '2017-03-08', 'EXTERNA ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '3', '0', '2017-03-08', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1091', '1', '0', '2017-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78782700', 'EXBR1091', '1', '1', '2017-03-13', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1543', '2', '1', '2017-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1804', '1', '0', '2017-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1804', '1', '0', '2017-03-13', 'EE.UU PIE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '4', '0', '2017-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1793', '1', '0', '2017-03-13', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1480', '4', '0', '2017-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1805', '1', '0', '2017-03-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1805', '1', '0', '2017-03-15', 'Esc. G-130 Secretaria', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1092', '1', '0', '2017-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96900610', 'EXBR1092', '1', '0', '2017-03-17', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1807', '1', '0', '2017-03-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1808', '1', '0', '2017-03-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1669', '3', '0', '2017-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1807', '1', '0', '2017-03-22', 'PIPESA OFICINA301', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1809', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1810', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1811', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1812', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1813', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1814', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1815', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1816', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '1', '0', '2017-03-23', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1818', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1819', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1820', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1821', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1822', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1823', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1825', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1826', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1827', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1828', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1829', '1', '1', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1830', '1', '0', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416 CL', '2', '1', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1809', '1', '0', '2017-03-23', 'DIDECO SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1295', '10', '1', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1811', '1', '0', '2017-03-23', 'POSTA RURAL SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1810', '1', '0', '2017-03-23', 'SECRETARIA DIRECTOR SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1403', '4', '1', '2017-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76425249', 'BR1808', '1', '0', '2017-03-24', 'INMOBILIARIA HUB', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1498', '2', '0', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1822', '1', '0', '2017-03-24', 'OFICINA FINANZAS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1443', '3', '0', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1818', '1', '0', '2017-03-24', 'BODEGA FINANZAS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1499', '4', '1', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1823', '1', '0', '2017-03-24', 'DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '5', '0', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1816', '1', '0', '2017-03-24', 'EGES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1633', '2', '0', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1821', '1', '0', '2017-03-24', 'SECPLAC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '2', '0', '2017-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1817', '1', '0', '2017-03-24', 'D. O. M.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1514', '2', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1404', '4', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1814', '1', '0', '2017-03-27', 'POSTA RURAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1399', '3', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1815', '1', '0', '2017-03-27', 'ESCUELA G-130 BAQUEDANO UTP', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1456', '2', '0', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1819', '1', '0', '2017-03-27', 'JUZGADO POLICIA LOCAL ( SECRETARIA)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1430', '4', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1820', '1', '0', '2017-03-27', 'JUZGADO POLICIA LOCAL ( OFICINA)', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1813', '1', '0', '2017-03-27', 'BODEGA FARMACIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1639', '2', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1825', '1', '0', '2017-03-27', 'ESCUELA DE PROFESORES OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1826', '1', '0', '2017-03-27', 'ESCUELA PROFESORES OFICINA 1', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1812', '1', '0', '2017-03-27', 'CONTROL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1301', '4', '1', '2017-03-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR1830', '1', '1', '2017-03-27', 'INSPECTORIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1093', '1', '0', '2017-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78782700', 'EXBR1093', '1', '1', '2017-03-28', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1442', '4', '1', '2017-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1669', '2', '0', '2017-03-28', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1824', '1', '0', '2017-03-28', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1812', '2', '0', '2017-03-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1827', '1', '0', '2017-03-31', 'CONTROL BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '4', '0', '2017-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1800', '2', '1', '2017-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1443', '1', '0', '2017-04-03', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'to1618', '1', '0', '2017-04-03', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1518', '3', '0', '2017-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1094', '1', '0', '2017-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96554490', 'EXBR1094', '1', '1', '2017-04-04', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1440', '1', '0', '2017-04-04', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1807', '2', '0', '2017-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1723', '1', '0', '2017-04-04', 'OFICINA PIPESA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1445', '2', '0', '2017-04-05', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1716', '3', '0', '2017-04-05', 'MMH-49003', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1638', '4', '0', '2017-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1764', '1', '0', '2017-04-06', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1095', '1', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('94879000', 'EXTO1095', '1', '1', '2017-04-07', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1415', '2', '1', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1456', '1', '0', '2017-04-07', 'SERVICIOS GENERALES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1546', '3', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1761', '2', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1760', '2', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1762', '2', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1763', '2', '0', '2017-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1767', '2', '0', '2017-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'BR1761', '1', '0', '2017-04-12', 'SMG', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1762', '1', '1', '2017-04-12', 'NETLAND INSPECTORIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1530', '2', '0', '2017-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '2', '0', '2017-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1831', '1', '1', '2017-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1538', '2', '0', '2017-04-27', 'ADM-08000', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1672', '2', '0', '2017-04-27', 'CALAMA  RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1766', '2', '0', '2017-04-28', 'PEÃ‘ON ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1096', '1', '0', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77810360', 'EXBR1096', '1', '1', '2017-05-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1097', '1', '0', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXBR1097', '1', '1', '2017-05-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1088', '2', '1', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1089', '2', '1', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1092', '2', '0', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'BR1807', '1', '0', '2017-05-03', 'ESCRITURAS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1832', '1', '0', '2017-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1832', '1', '1', '2017-05-03', 'EE.UU C. DE APUNTE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1098', '1', '0', '2017-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXBR1098', '1', '1', '2017-05-05', 'EXTERNA RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1440', '4', '0', '2017-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1329', '3', '0', '2017-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '5', '0', '2017-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '5', '0', '2017-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1833', '1', '0', '2017-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'RIS1833', '1', '0', '2017-05-08', 'CENTRAL APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RECARGA MA', '1', '0', '2017-05-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1804', '2', '1', '2018-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1791', '1', '0', '2017-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1791', '1', '0', '2017-05-10', 'MICHILLA', '0');
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1765', '1', '0', '2017-05-10', 'MICHILLA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1440', '2', '0', '2017-05-10', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1099', '1', '0', '2017-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1100', '1', '0', '2017-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1101', '1', '0', '2017-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76179222', 'EXBR1099', '1', '1', '2017-05-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76179222', 'EXBR1100', '1', '1', '2017-05-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('12027512', 'EXBR1101', '1', '1', '2017-05-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '4', '0', '2017-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1102', '1', '0', '2017-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXBR1102', '1', '1', '2017-05-17', 'CONTABILIDAD EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1103', '1', '0', '2017-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777070', 'EXTO1103', '1', '1', '2017-05-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1792', '1', '0', '2017-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1792', '1', '0', '2017-05-17', 'RECTORIA ESCUELA B. OHIGGINS', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '4', '0', '2017-05-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '5', '0', '2017-05-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1835', '1', '0', '2017-05-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125852', 'TO1835', '1', '0', '2017-05-19', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1835', '2', '0', '2017-05-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1835', '1', '0', '2017-05-19', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1104', '1', '0', '2017-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16874234', 'EXBR1104', '1', '0', '2017-05-22', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1445', '4', '1', '2017-05-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1105', '1', '0', '2017-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1105', '1', '1', '2017-05-24', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1067', '2', '1', '2017-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1033', '2', '1', '2017-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1106', '1', '0', '2017-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13529035', 'EXBR1106', '1', '1', '2017-05-30', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1107', '1', '0', '2017-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10983385', 'EXBR1107', '1', '1', '2017-05-30', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1719', '2', '1', '2017-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1108', '1', '1', '2017-05-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1109', '1', '0', '2017-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6216268', 'EXBR1109', '1', '1', '2017-05-31', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '2', '0', '2017-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '4', '0', '2017-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1613', '2', '0', '2017-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1801', '2', '0', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1812', '1', '1', '2017-06-01', 'RECTORIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1726', '2', '0', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1801', '2', '0', '2017-06-01', 'ADQUISICIONES ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1104', '2', '1', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1407', '2', '0', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1329', '1', '0', '2017-06-01', 'BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1303', '2', '1', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'BR1498', '1', '0', '2017-06-01', 'OFICINA Â°1 PISO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1323', '3', '1', '2017-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('87682500', 'BR1763', '1', '0', '2017-06-01', 'OFICINA 2Â°PISO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1520', '2', '0', '2017-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416', '3', '0', '2017-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78791070', 'BR1760', '1', '0', '2017-06-05', 'sercabol ', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1633', '1', '0', '2017-06-05', ' RECTORIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1631', '3', '0', '2017-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1614', '3', '0', '2017-06-06', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR-1613', '2', '0', '2017-06-06', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1480', '1', '0', '2017-06-06', 'Administracion', '0');
INSERT INTO `clientemaquina` VALUES ('82200000', 'BR1828', '1', '0', '2017-06-08', 'OFICINA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '3', '0', '2017-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1493', '1', '0', '2017-06-08', 'PIPESA AFTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1803', '2', '0', '2017-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1803', '2', '0', '2017-06-08', 'MMB-10001', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'TO1518', '1', '0', '2017-06-09', 'CONTABILIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1836', '1', '0', '2017-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1650', '3', '0', '2017-06-13', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1723', '1', '0', '2017-06-13', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1111', '1', '0', '2017-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1378', '3', '1', '2017-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1416', '1', '0', '2017-06-14', 'CARLOS CONDEL,SECRETARIA ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1824', '1', '0', '2017-06-14', 'JUAN ANDRES- NOTARIO', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1836', '1', '0', '2017-06-14', 'JUAN ANDRES- NOTARIO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1419', '5', '1', '2017-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1547', '1', '0', '2017-06-15', 'ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '4', '0', '2017-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1844', '1', '1', '2017-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1837', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1838', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1839', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1840', '1', '1', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1841', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1842', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1843', '1', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '4', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1793', '3', '0', '2017-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '5', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1836', '2', '0', '2017-06-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16209287', 'TO1836', '1', '0', '2017-06-20', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '3', '0', '2017-06-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16209287', 'BR1824', '1', '0', '2017-06-20', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'U63089E5N1', '1', '1', '2017-06-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1845', '1', '0', '2017-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1846', '1', '0', '2017-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1847', '1', '0', '2017-06-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'TO1843', '1', '0', '2017-06-22', 'FAM ANTUCOYA ', '0');
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1837', '1', '0', '2017-06-22', 'FAM ANTUCOYA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1793', '2', '0', '2017-06-22', 'MMH-49001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1838', '1', '0', '2017-06-22', 'MMH-49003', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '3', '0', '2017-06-22', 'CMZ-21001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1115', '1', '0', '2017-06-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10983385', 'EXBR1115', '1', '1', '2017-06-22', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76182983', 'BR1841', '1', '0', '2017-06-23', 'AURA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1738', '3', '0', '2017-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1423', '3', '1', '2017-06-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1530', '1', '0', '2017-06-27', 'ESCUELA ESPECIAL-OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1846', '1', '0', '2017-06-27', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1845', '1', '0', '2017-06-27', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1849', '1', '0', '2017-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1849', '1', '0', '2017-06-29', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1847', '1', '0', '2017-06-29', 'MMH-49003', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1725', '3', '0', '2017-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '5', '0', '2017-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1440', '5', '1', '2017-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '4', '0', '2017-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1116', '1', '0', '2017-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12937731', 'EXBR1116', '1', '1', '2017-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1525', '2', '0', '2017-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1526', '2', '0', '2017-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1524', '2', '1', '2017-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1850', '1', '1', '2017-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1851', '1', '0', '2017-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1852', '1', '0', '2017-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '1', '0', '2017-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1493', '3', '1', '2017-07-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1723', '2', '0', '2017-07-10', 'PIPESA MICHILLA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1677', '2', '0', '2017-07-10', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1520', '1', '0', '2017-07-10', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1842', '1', '0', '2017-07-10', 'LEM COPIAPO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1117', '1', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5972543', 'EXBR1117', '1', '1', '2017-07-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1854', '1', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1855', '1', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1856', '1', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1619', '3', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76179538', 'BR1725', '1', '0', '2017-07-11', 'AEROPUERTO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1118', '1', '0', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1118', '2', '1', '2017-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1856', '1', '0', '2017-07-11', 'DEPTO SOCIAL ', '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1855', '1', '0', '2017-07-11', 'DEPTO ADMINISTRACIÃ“N ', '0');
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1854', '1', '0', '2017-07-11', 'DEPTO JURÃDICO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1520', '3', '0', '2017-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1527', '2', '0', '2017-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1852', '1', '0', '2017-07-14', 'OFICINA PUERTO CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1839', '1', '0', '2017-07-14', 'LEM ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1550', '2', '0', '2017-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1853', '1', '0', '2017-07-14', 'GALPON ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1119', '1', '0', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77694090', 'EXBR1119', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1120', '1', '0', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5972543', 'EXBR1120', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1121', '1', '0', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'EXBR1121', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1114', '1', '0', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76080169', 'EXBR1114', '1', '1', '2017-07-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1416', '4', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'DI1214', '3', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1235h', '5', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1173', '7', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'XE1264', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1069', '3', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1247', '4', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1525', '1', '0', '2017-07-17', 'ESC. CARLOS CONDELL-SECRETARIA ', '0');
INSERT INTO `clientemaquina` VALUES ('61980680', 'EXTO1111', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1113', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1122', '1', '0', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77800010', 'EXBR1122', '1', '1', '2017-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1123', '1', '0', '2017-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1124', '1', '0', '2017-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1125', '1', '0', '2017-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1126', '1', '0', '2017-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1127', '1', '0', '2017-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1123', '1', '1', '2017-07-18', 'AV. RUTA EL COBRE 711 LOTE 6 PARQUE INDUSTRIAL LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1124', '1', '1', '2017-07-18', 'AV. RUTA EL COBRE 711 LOTE 6 PARQUE INDUSTRIAL LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1125', '1', '1', '2017-07-18', 'AV. RUTA EL COBRE 711 LOTE 6 PARQUE INDUSTRIAL LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1126', '1', '1', '2017-07-18', 'AV. RUTA EL COBRE 711 LOTE 6 PARQUE INDUSTRIAL LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1127', '1', '0', '2017-07-18', 'AV. RUTA EL COBRE 711 LOTE 6 PARQUE INDUSTRIAL LA NEGRA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1609', '4', '0', '2017-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1546', '1', '1', '2017-07-19', 'D.O.M ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1857', '1', '0', '2017-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'C2DC32359', '1', '1', '2017-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1858', '1', '0', '2017-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1619', '1', '0', '2017-07-24', 'Lomas Bayas ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1550', '1', '0', '2017-07-24', 'lomas bayas ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '2', '0', '2017-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1128', '1', '0', '2017-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1129', '1', '0', '2017-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1128', '1', '1', '2017-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76184053', 'EXBR1129', '1', '1', '2017-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1859', '1', '0', '2017-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1860', '1', '0', '2017-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1861', '1', '0', '2017-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1862', '1', '0', '2017-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1130', '1', '0', '2017-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65102261', 'EXTO1130', '1', '1', '2017-07-26', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1131', '1', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'EXBR1131', '1', '1', '2017-07-28', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1863', '1', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1132', '1', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1133', '1', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1134', '1', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '3', '0', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76352215', 'EXBR1132', '1', '1', '2017-07-28', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76352215', 'EXBR1133', '1', '1', '2017-07-28', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76352215', 'EXBR1134', '1', '1', '2017-07-28', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1859', '1', '0', '2017-07-28', 'famae', '0');
INSERT INTO `clientemaquina` VALUES ('8555294', 'BR1860', '1', '0', '2017-07-28', 'mejillones juan salvador notaria', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1748', '2', '1', '2017-07-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1858', '1', '0', '2017-07-28', 'piso 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1135', '1', '0', '2017-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('87606700', 'EXBR1135', '1', '1', '2017-07-31', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1663', '2', '0', '2017-07-31', 'peÃ±on', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '3', '0', '2017-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '5', '0', '2017-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1863', '1', '0', '2017-07-31', 'BSMG', '0');
INSERT INTO `clientemaquina` VALUES ('76204669', 'RI1407', '1', '1', '2017-08-01', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'BR1861', '1', '0', '2017-08-01', 'ESCRITURAS PUBLICAS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '2', '0', '2017-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1862', '1', '0', '2017-08-01', 'GALPON ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1136', '1', '0', '2017-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76281400', 'EXBR1136', '1', '1', '2017-08-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1796', '2', '0', '2017-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1796', '2', '0', '2017-08-03', 'oficina la negra ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '5', '0', '2017-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1865', '1', '0', '2017-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '1', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1867', '1', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1137', '1', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96551880', 'EXTO1137', '1', '1', '2017-08-08', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1865', '1', '0', '2017-08-08', 'finanzas', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1619', '4', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1477', '3', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1476', '5', '1', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1835', '3', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76110235', 'BR1866', '1', '0', '2017-08-08', '3Â°piso ', '0');
INSERT INTO `clientemaquina` VALUES ('76110235', 'BR1867', '1', '0', '2017-08-08', '2Â°piso ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1735', '2', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1716', '4', '0', '2017-08-08', 'lmb-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1527', '1', '0', '2017-08-08', 'lmb-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1547', '3', '0', '2017-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1735', '1', '0', '2017-08-08', 'documentos privados ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1807', '3', '0', '2017-08-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16209287', 'BR1520', '1', '0', '2017-08-14', 'notaria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '4', '0', '2017-08-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1864', '1', '0', '2017-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1138', '1', '0', '2017-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXBR1138', '1', '1', '2017-08-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1864', '1', '0', '2017-08-17', 'OFICINA ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1761', '3', '0', '2017-08-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1500', '1', '0', '2017-08-18', 'adm y finanza ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1835', '2', '0', '2017-08-21', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1139', '1', '0', '2017-08-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70265000', 'EXBR1139', '1', '1', '2017-08-21', 'CODESSER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1140', '1', '0', '2017-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78889270', 'EXBR1140', '1', '1', '2017-08-22', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1868', '1', '0', '2017-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1869', '1', '0', '2017-08-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1870', '1', '0', '2017-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1536', '3', '0', '2017-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXOK1140', '1', '1', '2017-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1884', '1', '0', '2017-11-16', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76110235', 'BR1868', '1', '0', '2017-08-25', 'OFICINA ', '0');
INSERT INTO `clientemaquina` VALUES ('76110235', 'BR1869', '1', '0', '2017-08-25', 'CERRO COLORADO ', '0');
INSERT INTO `clientemaquina` VALUES ('76733334', 'EP1870', '1', '0', '2017-08-25', 'oficina mejillones ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1141', '1', '0', '2017-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1142', '1', '0', '2017-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76733334', 'EXBR1141', '1', '1', '2017-08-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76733334', 'EXBR1142', '1', '1', '2017-08-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1143', '1', '0', '2017-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76031075', 'EXBR1143', '1', '1', '2017-08-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1852', '2', '0', '2017-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1853', '2', '0', '2017-08-28', 'oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1484', '1', '0', '2017-08-28', 'oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1518', '4', '1', '2017-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1144', '1', '0', '2017-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1145', '1', '0', '2017-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77005150', 'EXBR1144', '1', '1', '2017-08-31', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('77005150', 'EXBR1145', '1', '1', '2017-08-31', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1146', '1', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71173500', 'EXBR1146', '1', '1', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1742', '1', '0', '2017-09-01', 'CENTRAL DE APUNTES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1871', '1', '1', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '4', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1501', '2', '1', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1487', '2', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1625', '2', '1', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1849', '2', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1756', '2', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1794', '2', '0', '2017-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1756', '2', '0', '2017-09-01', 'sala de profesores', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1421', '2', '0', '2017-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1149', '1', '0', '2017-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77005150', 'EXBR1149', '1', '1', '2017-09-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1150', '1', '0', '2017-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1151', '1', '0', '2017-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1152', '1', '0', '2017-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1153', '1', '0', '2017-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11610918', 'EXBR1150', '1', '1', '2017-09-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('11610918', 'EXBR1151', '1', '1', '2017-09-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1152', '1', '1', '2017-09-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('77800010', 'EXBR1153', '1', '1', '2017-09-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1535', '1', '0', '2017-09-07', 'secplac baquedano ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1147', '1', '0', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1148', '1', '0', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77305850', 'EXBR1147', '1', '1', '2017-09-08', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76329503', 'EXBR1148', '1', '1', '2017-09-08', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1154', '1', '0', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBR1154', '1', '1', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1465', '2', '0', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1454', '2', '1', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1801', '3', '0', '2017-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1833', '2', '0', '2017-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'IDE1834', '1', '0', '2017-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'IDE1834', '1', '0', '2017-09-11', 'Central de Apuntes', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1793', '4', '0', '2017-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'IDE1834', '2', '0', '2017-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1382', '3', '1', '2017-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1156', '1', '1', '2017-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1156', '1', '0', '2017-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78104070', 'EXBR1156', '1', '0', '2017-09-13', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'to1618', '3', '0', '2017-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1479', '2', '0', '2017-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1156', '2', '0', '2017-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78403190', 'EXBR1156', '1', '1', '2017-09-13', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '5', '0', '2017-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1397', '2', '0', '2017-09-14', 'admision ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1758', '2', '0', '2017-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1675', '3', '0', '2017-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1795', '2', '0', '2017-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1495', '2', '0', '2017-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'TO1857', '1', '0', '2017-09-14', 'oficina la negra ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXHP1083', '2', '0', '2017-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1872', '1', '0', '2017-09-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1873', '1', '0', '2017-09-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1742', '1', '0', '2017-09-22', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76419232', 'EP1873', '1', '0', '2017-09-25', 'laboratorio ', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXHP1083', '2', '1', '2017-09-25', 'secretaria- rectoria', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXHP1157', '1', '0', '2017-09-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXHP1157', '1', '1', '2017-09-26', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1675', '1', '0', '2017-09-28', 'EE.UU C. DE APUNTE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1457', '3', '0', '2017-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '2', '0', '2017-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1753', '2', '0', '2017-10-02', 'escondida coloso admin ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1545', '2', '1', '2017-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1477', '2', '0', '2017-10-02', 'RECEPCION CATALUÃ‘A', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1496', '2', '0', '2017-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1465', '1', '0', '2017-10-02', 'bodega ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1158', '1', '0', '2017-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('14392035', 'EXBR1158', '1', '1', '2017-10-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1159', '1', '0', '2017-10-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76275945', 'EXBR1159', '1', '1', '2017-10-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1160', '1', '0', '2017-10-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11346834', 'EXBR1160', '1', '1', '2017-10-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1874', '1', '0', '2017-10-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1875', '1', '0', '2017-10-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1294', '4', '1', '2017-10-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'RI1457', '1', '0', '2017-10-06', 'Servicios generales ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1766', '3', '0', '2017-10-10', 'MER-42001 peÃ±on', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1874', '1', '0', '2017-10-10', 'direccion academica ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '3', '0', '2017-10-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1807', '1', '0', '2017-10-12', 'oficina puerto seco calama ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1161', '1', '0', '2017-10-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76116241', 'EXBR1161', '1', '1', '2017-10-12', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1666', '2', '0', '2017-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1496', '1', '0', '2017-10-13', 'secretaria administracion ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1486', '3', '1', '2017-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1528', '3', '1', '2017-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1793', '3', '0', '2017-10-16', 'RTT-29015', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1619', '2', '0', '2017-10-16', 'RTT-29015', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1485', '3', '0', '2017-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'TO1485', '2', '1', '2017-10-16', '2Â°piso ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'BR1536', '1', '0', '2017-10-16', '1Â°piso ', '0');
INSERT INTO `clientemaquina` VALUES ('76409216', 'TO1875', '1', '1', '2017-10-16', 'piso 1', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1306', '4', '1', '2017-10-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511021', 'BR1852', '1', '0', '2017-10-17', 'secretaria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1162', '1', '0', '2017-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83145600', 'EXBR1162', '1', '1', '2017-10-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1163', '1', '0', '2017-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1164', '1', '0', '2017-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71102600', 'EXBR1163', '1', '1', '2017-10-20', 'ESCUELA D72 LUBICA DOMIC', null);
INSERT INTO `clientemaquina` VALUES ('76551249', 'EXBR1164', '1', '1', '2017-10-20', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '3', '0', '2017-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '1', '0', '2017-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1663', '3', '0', '2017-10-24', 'MMB-74003 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1165', '1', '0', '2017-10-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15811642', 'EXBR1165', '1', '1', '2017-10-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1166', '1', '0', '2017-10-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7103332', 'EXBR1166', '1', '1', '2017-10-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76698075', 'EP1876', '1', '0', '2017-10-25', 'asesoramiento empresarial ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'RI1487', '1', '1', '2017-10-26', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1167', '1', '0', '2017-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15690929', 'EXBR1167', '1', '1', '2017-10-30', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1168', '1', '0', '2017-10-30', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1168', '2', '0', '2017-10-30', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1877', '1', '0', '2017-10-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1878', '1', '0', '2017-10-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1878', '1', '0', '2017-10-31', 'puerto seco oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1877', '1', '0', '2017-10-31', 'administracion calama ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1879', '1', '0', '2017-10-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1169', '1', '0', '2017-10-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1170', '1', '0', '2017-10-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1880', '1', '0', '2017-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76290837', 'EXBR1170', '1', '1', '2017-11-02', 'oficina ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1881', '1', '0', '2017-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1881', '1', '0', '2017-11-03', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1168', '3', '0', '2017-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81889300', 'EXBR1168', '1', '1', '2017-11-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69900303', 'EP1880', '1', '0', '2017-11-03', 'CONSULADO OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('76071784', 'EXBR1169', '1', '1', '2017-11-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1171', '1', '0', '2017-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1172', '1', '0', '2017-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76098841', 'EXBR1171', '1', '1', '2017-11-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76098841', 'EXBR1172', '1', '1', '2017-11-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1882', '1', '0', '2017-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1173', '1', '0', '2017-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1173', '1', '1', '2017-11-07', 'oficina de parte ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1879', '1', '0', '2017-11-08', 'inspectoria 4Â°ciclo', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1697', '2', '0', '2017-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1697', '2', '1', '2017-11-09', 'INFORMATICA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '6', '0', '2017-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '6', '0', '2017-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76196877', 'TO1849', '1', '0', '2017-11-10', 'antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1523', '2', '1', '2017-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1882', '1', '1', '2017-11-10', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1174', '1', '0', '2017-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10726267', 'EXBR1174', '1', '1', '2017-11-10', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1641', '1', '0', '2017-11-13', 'DAEM ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1824', '1', '0', '2017-11-13', 'depto social ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1666', '1', '0', '2017-11-13', 'EGIS', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1479', '1', '0', '2017-11-13', 'finanza', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO-1611', '1', '0', '2017-11-13', 'DAEM', '0');
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1761', '1', '0', '2017-11-13', 'matricula', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '5', '0', '2017-11-13', 'MER-42001 peÃƒÂ±on', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1175', '1', '0', '2017-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76071838', 'EXBR1175', '1', '1', '2017-11-14', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '1', '0', '2017-11-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1885', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1886', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1887', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1888', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1889', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1890', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1891', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1892', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1893', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1894', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1895', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1896', '1', '0', '2017-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1176', '1', '0', '2017-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1177', '1', '0', '2017-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60107000', 'EXTO1176', '1', '1', '2017-11-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('60107000', 'EXTO1177', '1', '1', '2017-11-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1883', '1', '0', '2017-11-17', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('76110235', 'BR1872', '1', '0', '2017-11-17', 'faena jesmin ltda', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1178', '1', '0', '2017-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76899720', 'EXBR1178', '1', '1', '2017-11-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1179', '1', '0', '2017-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13867385', 'EXBR1179', '1', '1', '2017-11-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '2', '0', '2017-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76698075', 'BR1896', '1', '0', '2017-11-17', 'oficina', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1380', '1', '0', '2017-11-20', 'ADQUISICIONES', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1884', '1', '0', '2017-11-20', 'alcaldia ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1886', '1', '0', '2017-11-20', 'D.O.M', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1888', '1', '0', '2017-11-20', 'policia local', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1890', '1', '0', '2017-11-20', 'dideco ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1887', '1', '0', '2017-11-20', 'secretaria municipal ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1885', '1', '0', '2017-11-20', 'control', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1893', '1', '0', '2017-11-20', 'planificacion ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1890', '2', '0', '2017-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76464003', 'BR1767', '1', '0', '2017-11-21', 'matricula', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1892', '1', '0', '2017-11-21', 'albergue municipal ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1897', '1', '0', '2017-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'ICC', '1', '0', '2017-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'ICC', '1', '1', '2017-11-22', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RECARGA MA', '2', '0', '2017-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('19396150', 'RECARGA MA', '1', '1', '2017-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'IADM', '1', '0', '2017-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'IADM', '1', '1', '2017-11-22', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1380', '5', '1', '2017-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1666', '3', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '3', '0', '2017-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1889', '1', '0', '2017-11-23', 'bodega', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1547', '1', '0', '2017-11-23', 'TRANSITO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '4', '0', '2017-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '5', '0', '2017-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1891', '1', '0', '2017-11-23', 'SOCIAL ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '4', '0', '2017-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1851', '1', '1', '2017-11-24', 'BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1824', '2', '0', '2017-11-24', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1890', '1', '0', '2017-11-27', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '4', '0', '2017-11-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1436', '2', '1', '2017-11-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1495', '1', '0', '2017-11-27', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1765', '2', '0', '2017-11-27', 'COLOSO ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1898', '1', '1', '2017-11-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1649', '2', '0', '2017-11-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1649', '1', '0', '2017-11-29', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '5', '0', '2017-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1879', '2', '0', '2017-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SH1216', '2', '1', '2017-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1874', '2', '1', '2017-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'EP1897', '1', '1', '2017-11-29', 'RECTORIA 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1841', '2', '0', '2017-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1180', '1', '0', '2017-11-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125014', 'EXBR1180', '1', '1', '2017-11-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1899', '1', '0', '2017-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1181', '1', '0', '2017-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78295070', 'EXTO1181', '1', '1', '2017-12-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '4', '0', '2017-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '5', '0', '2017-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1753', '3', '0', '2017-12-05', 'MER-42001 peÃƒÂ±on', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '4', '0', '2017-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1182', '1', '0', '2017-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99526550', 'EXBR1182', '1', '1', '2017-12-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1183', '1', '0', '2017-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6601931', 'EXBR1183', '1', '1', '2017-12-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1742', '2', '0', '2017-12-07', 'mer 42001 peÃ±on ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1906', '1', '0', '2017-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1907', '1', '0', '2017-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1907', '1', '0', '2017-12-11', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1906', '2', '1', '2017-12-11', 'administracion/abastecimiento ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1184', '1', '0', '2017-12-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17434040', 'EXBR1184', '1', '1', '2017-12-12', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '7', '0', '2017-12-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1901', '1', '0', '2017-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1902', '1', '0', '2017-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1903', '1', '1', '2017-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1904', '1', '1', '2017-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1905', '1', '1', '2017-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1185', '1', '0', '2017-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95151000', 'EXBR1185', '1', '0', '2017-12-14', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1791', '2', '0', '2017-12-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1641', '2', '0', '2017-12-18', 'EducaciÃ³n ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1186', '1', '0', '2017-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96773480', 'EXBR1186', '1', '1', '2017-12-19', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1908', '1', '1', '2017-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '6', '0', '2017-12-20', 'CMZ-21001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1187', '1', '0', '2017-12-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76118094', 'EXBR1187', '1', '1', '2017-12-20', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1188', '1', '0', '2017-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1189', '1', '0', '2017-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1190', '1', '0', '2017-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76126252', 'EXBR1188', '1', '0', '2017-12-22', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('76126252', 'EXBR1189', '1', '0', '2017-12-22', 'EXTERNA', '0');
INSERT INTO `clientemaquina` VALUES ('76214280', 'EXBR1190', '1', '1', '2017-12-26', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TONER DEFE', '1', '1', '2017-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MFC-L8850', '1', '1', '2017-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MFC-8910', '1', '1', '2017-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1732', '1', '0', '2017-12-26', 'GALPON ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1862', '2', '1', '2017-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1191', '1', '0', '2017-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EXBR1191', '1', '1', '2017-12-26', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1766', '4', '0', '2017-12-28', 'peÃ±on, mer-42001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '5', '0', '2017-12-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1662', '6', '0', '2017-12-28', 'ESCONDIDA,COLOSO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1761', '4', '1', '2018-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1397', '6', '1', '2018-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1799', '2', '0', '2018-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1909', '1', '1', '2018-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1185', '2', '1', '2018-01-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1192', '1', '0', '2018-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99526550', 'EXBR1192', '1', '1', '2018-01-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '4', '0', '2018-01-08', 'COLOSO ESC-12001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1193', '1', '0', '2018-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76675405', 'EXBR1193', '1', '1', '2018-01-09', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1915', '1', '0', '2018-01-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1648', '1', '0', '2018-01-09', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1463', '1', '0', '2018-01-09', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1791', '1', '0', '2018-01-09', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '2', '0', '2018-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1194', '1', '0', '2018-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76899720', 'EXBR1194', '1', '1', '2018-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1195', '1', '0', '2018-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16203216', 'EXBR1195', '1', '1', '2018-01-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1910', '1', '0', '2018-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO1910', '1', '0', '2018-01-11', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1196', '1', '0', '2018-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76092002', 'EXRI1196', '1', '1', '2018-01-15', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1911', '1', '0', '2018-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1188', '2', '1', '2018-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1189', '2', '1', '2018-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1197', '1', '0', '2018-01-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70265000', 'EXBR1197', '1', '1', '2018-01-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1911', '1', '0', '2018-01-17', 'gof', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1794', '1', '0', '2018-03-09', 'admision ', '0');
INSERT INTO `clientemaquina` VALUES ('70265000', 'BR1799', '1', '0', '2018-01-17', 'oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1738', '2', '0', '2018-01-18', 'ESCRITURA PUBLICA OFICINA 3', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1737', '2', '0', '2018-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1912', '1', '0', '2018-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1738', '4', '0', '2018-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO1912', '1', '0', '2018-01-18', 'ESCRITURA PUBLICA OFICINA 3', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1913', '1', '0', '2018-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1770', '2', '0', '2018-01-19', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1753', '4', '0', '2018-01-19', 'MMH-49004', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1685', '2', '0', '2018-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'SI1913', '1', '0', '2018-01-22', 'ADMINISTRACION ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1914', '1', '0', '2018-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1538', '3', '0', '2018-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1723', '2', '0', '2018-01-25', 'ADM-08000', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1198', '1', '0', '2018-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76140282', 'EXBR1198', '1', '1', '2018-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '6', '0', '2018-01-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16524375', 'BR1915', '1', '0', '2018-02-05', 'notaria taltal', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1611', '2', '0', '2018-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '5', '0', '2018-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1900', '1', '1', '2018-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1916', '1', '0', '2018-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'BR1916', '1', '0', '2018-02-06', 'rrhh', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1520', '4', '0', '2018-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'BR1795', '1', '0', '2018-02-08', 'oficina notaria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1755', '1', '0', '2018-02-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '6', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1803', '3', '1', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1429', '6', '1', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '4', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1896', '2', '1', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1836', '3', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'TO1836', '1', '0', '2018-02-13', 'oficina notaria ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1894', '1', '1', '2018-02-13', 'oficina de la mujer ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1917', '1', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1917', '1', '1', '2018-02-13', 'OPD', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1895', '1', '1', '2018-02-13', 'OFICINA SERNAMEG ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1754', '1', '0', '2018-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1754', '1', '0', '2018-02-13', 'ADMINISTRACION SEP (DAEM )', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1755', '1', '0', '2018-02-13', 'DAEM SECRETARIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1918', '1', '0', '2018-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1918', '1', '0', '2018-02-16', 'EGIS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1724', '3', '0', '2018-02-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1199', '1', '0', '2018-02-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5488051', 'EXBR1199', '1', '1', '2018-02-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1617', '2', '1', '2018-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1737', '1', '0', '2018-02-21', 'HOTEL DIEGO DE ALMAGRO', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO-1611', '1', '0', '2018-03-01', 'SECPLA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1200', '1', '0', '2018-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76037060', 'EXBR1200', '1', '1', '2018-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1796', '3', '0', '2018-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1738', '1', '0', '2018-02-27', 'EDIFICIO LAS EMPRESAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1649', '3', '0', '2018-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76689118', 'TO1649', '1', '1', '2018-03-01', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1806', '1', '0', '2018-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1663', '4', '0', '2018-03-05', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('76689118', 'TO1806', '1', '1', '2018-03-02', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1907', '2', '0', '2018-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76689118', 'TO1907', '1', '1', '2018-03-02', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1641', '3', '0', '2018-03-05', 'RTT-10001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1647', '2', '0', '2018-03-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1647', '1', '0', '2018-03-07', 'BOH SECRETARIA DIRECCION ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1540', '6', '0', '2018-03-08', 'RTT-29015', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1914', '1', '0', '2018-03-08', 'RTT-29015', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1879', '1', '1', '2018-03-08', 'BS-102-CRT001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1602', '3', '0', '2018-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1520', '1', '0', '2018-03-08', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('71102600', 'RIS1421', '1', '1', '2018-03-08', 'D-75 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1799', '3', '0', '2018-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70047302', 'BR1526', '1', '0', '2018-03-09', 'BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1777', '2', '1', '2018-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1602', '1', '1', '2018-03-12', 'tesoreria ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'SI1899', '1', '0', '2018-03-12', 'MANTOS BLANCOS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1201', '1', '0', '2018-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96922700', 'EXBR1201', '1', '1', '2018-03-13', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1716', '5', '0', '2018-03-15', 'CMZ-21001 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1202', '1', '0', '2018-03-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70047302', 'EXTO1202', '1', '1', '2018-03-16', 'ESCUELA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1526', '3', '0', '2018-03-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1721', '2', '0', '2018-03-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('71102600', 'TO1721', '1', '1', '2018-03-16', 'c.apuntes  d-75 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1835', '4', '0', '2018-03-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1791', '3', '0', '2018-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1463', '6', '1', '2018-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1638', '4', '0', '2018-03-20', 'lomas bayas ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1539', '1', '0', '2018-03-21', 'EDUCACION ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1783', '2', '0', '2018-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '6', '0', '2018-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1538', '1', '0', '2018-03-21', 'EDUCACION ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1467', '5', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1685', '1', '0', '2018-03-23', 'DIDECO TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1204', '1', '1', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1204', '1', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBR1204', '1', '1', '2018-03-23', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1205', '1', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13867385', 'EXBR1205', '1', '0', '2018-03-23', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1206', '1', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76392776', 'EXBR1206', '1', '1', '2018-03-23', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1924', '1', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1695', '2', '0', '2018-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1924', '1', '0', '2018-03-23', 'EE.UU C. DE APUNTE', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1695', '2', '0', '2018-03-23', 'BIBLIOTECA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1203', '1', '0', '2018-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBR1203', '1', '1', '2018-03-26', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1922 ', '1', '0', '2018-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1796', '1', '0', '2018-03-26', 'MINERA MANTOS COOPER', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1922 ', '1', '0', '2018-03-26', 'educacion ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1538', '4', '0', '2018-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1636', '2', '1', '2018-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1205', '2', '0', '2018-03-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13419959', 'EXBR1205', '1', '1', '2018-03-28', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1207', '1', '0', '2018-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18154730', 'EXBR1207', '1', '1', '2018-03-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1208', '1', '0', '2018-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXBR1208', '1', '1', '2018-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1209', '1', '0', '2018-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('90146000', 'EXTO1209', '1', '1', '2018-04-02', 'piso 16 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1210', '1', '0', '2018-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1211', '1', '0', '2018-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EXBR1210', '1', '1', '2018-04-02', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EXBR1211', '1', '1', '2018-04-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1794', '3', '1', '2018-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1706', '2', '1', '2018-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1526', '1', '1', '2018-04-04', '4Â°CICLO INSPECTORIA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1212', '1', '0', '2018-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76761720', 'EXBR1212', '1', '1', '2018-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1920', '1', '1', '2018-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1919', '1', '0', '2018-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1428', '5', '1', '2018-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'OK1926', '1', '0', '2018-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'OK1926', '1', '1', '2018-04-06', 'PIE BOH ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1467', '2', '1', '2018-04-06', 'ARTURO PRAT ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1304', '8', '1', '2018-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '1', '0', '2018-04-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1214', '1', '0', '2018-04-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1214', '1', '0', '2018-04-10', 'DRI', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1213', '1', '0', '2018-04-10', 'ferrocarril ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1928', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1929', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1930', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1931', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1932', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1933', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1934', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1935', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1936', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1937', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1938', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1939', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1940', '1', '0', '2018-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1927', '1', '0', '2018-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO1927', '1', '1', '2018-04-12', 'carlos condell UTP', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1611', '3', '1', '2018-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1671', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1668', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1411', '3', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1936', '1', '0', '2018-04-13', 'aseo y ornato ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1933', '1', '0', '2018-04-13', 'casa de la cultura ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '4', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1934', '1', '0', '2018-04-13', 'alcaldia ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1930', '1', '0', '2018-04-13', 'secretaria municipal ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1637', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1937', '1', '0', '2018-04-13', 'OPD ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1645', '3', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1932', '1', '0', '2018-04-13', 'finanzas ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1743', '3', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1940', '1', '0', '2018-04-13', 'tesoreria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1468', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1658', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1670', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1938', '1', '0', '2018-04-13', 'senda ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1659', '2', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1631', '1', '0', '2018-04-13', 'J de policia local ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1475', '4', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1935', '1', '0', '2018-04-13', 'recursos humanos ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1673', '3', '0', '2018-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1928', '1', '0', '2018-04-13', 'TRANSITO', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1939', '1', '0', '2018-04-13', 'DOM ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1929', '1', '0', '2018-04-13', 'DIDECO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1631', '4', '1', '2018-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1931', '1', '0', '2018-04-16', 'J. Policia Locar', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1925', '1', '0', '2018-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'BR1925', '1', '1', '2018-04-16', 'notaria Mejillones ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1215', '1', '0', '2018-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78701740', 'EXBR1215', '1', '1', '2018-04-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1216', '1', '0', '2018-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99526550', 'EXBR1216', '1', '1', '2018-04-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1217', '1', '0', '2018-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76761321', 'EXBR1217', '1', '1', '2018-04-17', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '1', '0', '2018-04-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1634', '2', '1', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1659', '1', '0', '2018-04-18', 'adquisiciones ', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1941', '1', '0', '2018-04-18', 'calama ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1218', '1', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76540665', 'EXBR1218', '1', '1', '2018-04-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1219', '1', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1219', '1', '1', '2018-04-18', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1220', '1', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('86356400', 'EXBR1220', '1', '1', '2018-04-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1943', '1', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1944', '1', '0', '2018-04-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '5', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1767', '3', '1', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1942', '1', '0', '2018-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'to1618', '1', '0', '2018-04-19', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('76464003', 'BR1942', '1', '1', '2018-04-19', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'EP1943', '1', '1', '2018-04-20', 'RADIO ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1902', '1', '0', '2018-04-25', 'Juzgado policia local ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1650', '1', '0', '2018-04-25', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1468', '2', '1', '2018-04-25', 'upt escuela especial ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1530', '3', '1', '2018-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1743', '1', '0', '2018-04-25', 'finanzas ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1422', '5', '1', '2018-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1668', '1', '0', '2018-04-25', 'direccion ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1348', '2', '1', '2018-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1685', '3', '0', '2018-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1670', '1', '0', '2018-04-25', 'adquisiciones ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1221', '1', '0', '2018-04-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76092002', 'EXRI1221', '1', '1', '2018-04-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1944', '1', '0', '2018-04-26', 'CONTROL ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1613', '3', '0', '2018-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '5', '0', '2018-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '5', '0', '2018-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '6', '0', '2018-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1737', '3', '0', '2018-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76162391', 'EP1876', '1', '0', '2018-04-27', 'ALTO NORTE ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1222', '1', '0', '2018-05-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('87606700', 'EXRI1222', '1', '1', '2018-05-02', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1405', '3', '1', '2018-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'BR1685', '1', '0', '2018-05-03', 'gendarmeria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1685', '4', '0', '2018-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'BR1671', '1', '1', '2018-05-03', 'gendarmeria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '3', '0', '2018-05-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76479476', 'EP1876', '1', '0', '2018-05-03', 'ALTO NORTE OF. DE PROYECTO PISO 2', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1783', '1', '0', '2018-05-07', 'PEÃ‘ON ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '5', '0', '2018-05-07', 'PEÃ‘ON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1869', '2', '0', '2018-05-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1872', '2', '0', '2018-05-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1650', '6', '1', '2018-05-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1945', '1', '0', '2018-05-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1223', '1', '0', '2018-05-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99526550', 'EXBR1223', '1', '1', '2018-05-09', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1945', '1', '0', '2018-05-09', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '6', '0', '2018-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1685', '1', '0', '2018-05-10', 'MMH-49004-CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '5', '0', '2018-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1669', '4', '0', '2018-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1778', '2', '1', '2018-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1482', '3', '0', '2018-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '6', '0', '2018-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '5', '0', '2018-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1224', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79511210', 'EXBR1224', '1', '1', '2018-05-16', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1225', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99536660', 'EXBR1225', '1', '1', '2018-05-16', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1226', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99536660', 'EXBR1226', '1', '1', '2018-05-16', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1946', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1227', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXTO1227', '1', '1', '2018-05-16', 'EXTERNA TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1228', '1', '1', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1229', '1', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1229', '1', '1', '2018-05-16', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1946', '1', '1', '2018-05-16', 'abasolo ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '5', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1872', '1', '0', '2018-05-16', 'GALPÃ“N ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1868', '2', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1945', '2', '0', '2018-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1947', '1', '0', '2018-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1735', '3', '0', '2018-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1947', '1', '1', '2018-05-17', 'finanzas', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1948', '1', '0', '2018-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1949', '1', '0', '2018-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1949', '1', '0', '2018-05-17', 'notaria ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1628', '2', '0', '2018-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1628', '2', '0', '2018-05-17', 'escrituras ', '0');
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1948', '1', '0', '2018-05-18', 'escrituras ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1766', '5', '0', '2018-05-22', 'CMZ-21001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1709', '2', '1', '2018-05-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1645', '1', '1', '2018-05-23', 'SALA DE PROFESORES 2DO CICLO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1950', '1', '0', '2018-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '4', '0', '2018-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76479476', 'EP1950', '1', '0', '2018-05-25', 'la negra ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1901', '1', '1', '2018-05-30', 'secretaria alcalde ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1788', '2', '0', '2018-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1876', '1', '0', '2018-05-31', 'salud', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '2', '0', '2018-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '5', '0', '2018-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1883', '1', '0', '2018-06-01', 'Salud/Baquedano', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1705', '2', '1', '2018-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'EXBR1059', '1', '1', '2018-06-05', 'Ciencias  ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'to1618', '4', '0', '2018-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1230', '1', '0', '2018-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1231', '1', '0', '2018-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1230', '1', '1', '2018-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1231', '1', '1', '2018-06-08', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1677', '3', '0', '2018-06-08', 'faena salvador bs-103-ces002in01', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1945', '2', '1', '2018-06-11', 'secplac ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1951', '1', '0', '2018-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '5', '0', '2018-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1737', '1', '0', '2018-06-12', 'GLUF ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1951', '1', '0', '2018-06-12', 'egis y otros ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1952', '1', '0', '2018-06-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76446262', 'to1618', '1', '0', '2018-06-14', 'ogalde ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1531', '4', '0', '2018-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1232', '1', '0', '2018-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('19396811', 'EXBR1232', '1', '1', '2018-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1233', '1', '0', '2018-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8156574', 'EXBR1233', '1', '1', '2018-06-14', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1672', '3', '0', '2018-06-14', 'BS-103-CRT001BA01 (CALAMA)', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1952', '1', '1', '2018-06-15', 'social ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1329', '4', '1', '2018-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1758', '1', '0', '2018-06-25', 'bernardo ohiggins ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1714', '2', '1', '2018-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1836', '4', '1', '2018-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'TO1482', '1', '0', '2018-06-25', 'notaria tocopilla ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1953', '1', '0', '2018-06-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1658', '1', '0', '2018-06-26', 'PSICOLOGIA 2Â°CICLO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1772', '2', '1', '2018-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1771', '2', '1', '2018-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1484', '3', '0', '2018-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1953', '1', '0', '2018-06-26', 'GERENCIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1470', '3', '1', '2019-03-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1234', '1', '0', '2018-06-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77327630', 'EXBR1234', '1', '1', '2018-06-27', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1955', '1', '0', '2018-06-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1955', '1', '0', '2018-06-29', 'faena salvador bs-103-ces002in01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1869', '1', '0', '2018-06-29', 'faena salvador bs-103-ces002in01', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1484', '2', '0', '2018-07-03', 'oficina calama ', '0');
INSERT INTO `clientemaquina` VALUES ('77430080', 'TO1500', '1', '0', '2018-07-04', 'OFICINA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1956', '1', '0', '2018-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1956', '1', '1', '2018-07-11', 'OF DE CONCEJALES ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1876', '1', '0', '2018-07-11', 'GOF', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '6', '0', '2018-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1807', '4', '0', '2018-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1958', '1', '0', '2018-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '1', '0', '2018-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76499251', 'BR1957', '1', '0', '2018-07-13', 'calama oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'SI1958', '1', '0', '2018-07-13', 'calama oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1961', '1', '0', '2018-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '1', '0', '2018-07-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76095896', 'EP1960', '1', '0', '2018-07-18', 'barthen (prestamo)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1612', '2', '1', '2018-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1637', '1', '1', '2018-07-19', 'faena candelaria-CopiapÃ³ ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1868', '1', '0', '2018-07-19', 'faena candelaria-copiapÃ³ ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1235', '1', '0', '2018-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8727697', 'EXBR1235', '1', '1', '2018-07-20', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '5', '0', '2018-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1236', '1', '0', '2018-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1236', '1', '1', '2018-07-20', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1237', '1', '0', '2018-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99573900', 'EXBR1237', '1', '1', '2018-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '2', '0', '2018-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1962', '1', '0', '2018-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76095896', 'TO1962', '1', '0', '2018-07-24', 'barthen antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1020', '2', '1', '2018-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'EP1960', '1', '0', '2018-07-24', 'jumbo norte ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1238', '1', '0', '2018-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1239', '1', '0', '2018-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXTO1238', '1', '1', '2018-07-26', 'venta- oficina antofa ', null);
INSERT INTO `clientemaquina` VALUES ('76206541', 'EXBR1239', '1', '1', '2018-07-26', 'venta- oficina antofa', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1788', '1', '0', '2018-07-30', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1963', '1', '1', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1964', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1965', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1966', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1967', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1968', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1240', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81518400', 'EXBR1240', '1', '1', '2018-07-30', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1241', '1', '0', '2018-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76757110', 'EXBR1241', '1', '1', '2018-07-30', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1722', '2', '0', '2018-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1765', '1', '0', '2018-07-31', 'southernrock', '0');
INSERT INTO `clientemaquina` VALUES ('81842900', 'EP1966', '1', '1', '2018-09-04', 'ADMINISTRACION Y FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('81842900', 'EP1964', '1', '1', '2018-08-06', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1242', '1', '0', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76820775', 'EXBR1242', '1', '1', '2018-08-07', 'EXTERNA FOLIO 297', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1243', '1', '0', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81842900', 'EXRI1243', '1', '0', '2018-08-07', 'central de apuntes ', '0');
INSERT INTO `clientemaquina` VALUES ('81842900', 'EP1965', '1', '1', '2018-08-07', 'UTP', null);
INSERT INTO `clientemaquina` VALUES ('81842900', 'EP1967', '1', '1', '2018-08-07', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1483', '2', '1', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR-1613', '3', '0', '2018-08-07', '3Â°PISO GERENCIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1969', '1', '0', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1970', '1', '0', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1244', '1', '0', '2018-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1244', '1', '1', '2018-08-07', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1969', '1', '0', '2018-08-08', 'bs-103-crt001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1970', '1', '0', '2018-08-08', 'bs-103-crt001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1614', '4', '0', '2018-08-08', 'gaby ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1479', '3', '1', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1735', '1', '0', '2018-08-09', 'finanza', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '4', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '6', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '5', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '6', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1970', '2', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1970', '2', '0', '2018-08-09', 'bs-103-crt001ba01/(rodomiro tomic)', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1968', '1', '0', '2018-08-09', 'carroceria', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1753', '5', '0', '2018-08-09', 'MMH-49003', '0');
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1669', '1', '0', '2018-08-09', 'sierra gorda ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1245', '1', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1246', '1', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1247', '1', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1248', '1', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1249', '1', '0', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1245', '1', '1', '2018-08-09', 'u.antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1246', '1', '1', '2018-08-09', 'u.antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1247', '1', '1', '2018-08-09', 'u.antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1248', '1', '1', '2018-08-09', 'u.antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1249', '1', '1', '2018-08-09', 'ing.quimica ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1716', '7', '1', '2018-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '8', '0', '2018-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1264', '1', '0', '2018-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1782', '2', '1', '2018-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1847', '2', '0', '2018-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1847', '1', '0', '2018-08-16', 'dideco baquedano ', '0');
INSERT INTO `clientemaquina` VALUES ('61930500', 'EP1961', '1', '0', '2018-08-16', 'minvu antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '3', '0', '2018-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'TO1492', '1', '0', '2018-08-20', 'externa vision jumbo norte ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1677', '7', '0', '2018-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1971', '1', '0', '2018-08-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1250', '1', '0', '2018-08-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1250', '1', '1', '2018-08-23', 'la negra ', null);
INSERT INTO `clientemaquina` VALUES ('76243616', 'BR1648', '1', '0', '2018-08-23', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('76243616', 'BR1641', '1', '0', '2018-08-23', 'antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1251', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1252', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1253', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1254', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1255', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1256', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1257', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1258', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1259', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1260', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1261', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1262', '1', '0', '2018-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1256', '1', '0', '2018-08-24', 'dpto de medio ambiente ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1255', '1', '0', '2018-08-24', 'of. concejo municipal ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1257', '1', '0', '2018-08-24', 'DOM ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1258', '1', '1', '2018-08-24', 'oficina de partes ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1259', '1', '0', '2018-08-24', 'informÃ¡tica ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1260', '1', '0', '2018-08-24', 'dpto personal  ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1261', '1', '1', '2018-08-24', 'prevenciÃ³n de riesgos ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EXBR1262', '1', '0', '2018-08-24', 'social (programa familia)', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1251', '1', '1', '2018-08-24', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1253', '1', '1', '2018-08-24', 'social', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1252', '1', '1', '2018-08-24', 'oficina de control ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1254', '1', '0', '2018-08-24', 'EGIS Y VIVIENDA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1263', '1', '0', '2018-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76464446', 'EXBR1263', '1', '1', '2018-08-24', 'EMS ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1971', '1', '0', '2018-08-27', 'faena gabriela mistral ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1824', '3', '0', '2018-08-27', 'faena gabriela mistral ', '0');
INSERT INTO `clientemaquina` VALUES ('76063521', 'EXBR1264', '1', '1', '2018-08-27', 'insecap calama', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1677', '4', '1', '2018-08-30', 'BS-103-CMH001BA01 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1265', '1', '0', '2018-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76650889', 'EXBR1265', '1', '1', '2018-09-03', 'latorre 2731-casa de cambio ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1266', '1', '0', '2018-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1267', '1', '0', '2018-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '6', '0', '2018-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1759', '1', '0', '2018-09-05', 'antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1268', '1', '0', '2018-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '7', '0', '2018-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '5', '0', '2018-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1648', '1', '0', '2018-09-07', 'colegio san agustin ', '0');
INSERT INTO `clientemaquina` VALUES ('76899720', 'EXBR1268', '1', '1', '2018-09-07', 'impocarb', null);
INSERT INTO `clientemaquina` VALUES ('4234188', 'EXBR1266', '1', '1', '2018-09-07', 'luis anguita', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1270', '1', '0', '2018-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7954313', 'EXBR1270', '1', '1', '2018-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1791', '2', '0', '2018-09-11', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1951', '2', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '3', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1685', '5', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1973', '1', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1974', '1', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1975', '1', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1976', '1', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1977', '1', '0', '2018-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TO1973', '1', '1', '2018-09-20', 'EGIS Y VARIOS ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1860', '2', '0', '2018-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'TO1951', '1', '1', '2018-09-20', 'notaria mejillones ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1845', '2', '0', '2018-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1846', '2', '0', '2018-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1974', '1', '0', '2018-09-20', 'bs-103-cmh001ba01 ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1975', '1', '0', '2018-09-20', 'bs-103-cmh001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR-1613', '4', '1', '2018-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1977', '1', '1', '2018-09-20', 'BS-000-ADM014ES01 RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1271', '1', '0', '2018-09-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EXBR1271', '1', '1', '2018-09-21', 'externa-MEL 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '6', '0', '2018-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1976', '1', '0', '2018-09-21', 'zonge ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1272', '1', '0', '2018-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1273', '1', '0', '2018-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1972', '1', '0', '2018-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1972', '1', '0', '2018-09-25', 'bs-103-mel001ba01/escondida', '0');
INSERT INTO `clientemaquina` VALUES ('77393120', 'EXBR1273', '1', '1', '2018-09-25', 'CASINOS RIVER:CALLE TARAPACA 4651 ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'EXBR1272', '1', '1', '2018-09-25', 'CALLE TARAPACA 4651 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1978', '1', '0', '2018-09-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1978', '1', '0', '2018-09-26', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('96900610', 'EXBR1092', '2', '1', '2018-10-01', 'imer chile', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1733', '2', '0', '2018-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1979', '1', '0', '2018-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1979', '1', '1', '2018-10-01', 'notaria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1413', '2', '1', '2018-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76137208', 'BR1491', '1', '0', '2018-10-01', 'intem ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1860', '1', '0', '2018-10-01', 'CSJ TALLER MANTENCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1274', '1', '0', '2018-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76278553', 'EXBR1274', '1', '1', '2018-10-03', 'FELIPE ANTONIO LA FLOR CATALAN ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1981', '1', '0', '2018-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1981', '1', '0', '2018-10-03', 'SECRETARIA DOM ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1929', '2', '0', '2018-10-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1732', '1', '0', '2018-10-09', 'matricula ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1961', '2', '0', '2018-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1504', '3', '1', '2018-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TP1982', '1', '0', '2018-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'TP1982', '1', '1', '2018-10-10', 'municipalidad de mejillones', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1846', '2', '0', '2018-10-10', 'peÃ±on ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '7', '0', '2018-10-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1539', '1', '0', '2018-10-10', 'UTP ', '0');
INSERT INTO `clientemaquina` VALUES ('77881200', 'EP1961', '1', '0', '2018-10-19', 'propipe antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1275', '1', '0', '2018-10-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1276', '1', '0', '2018-10-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1277', '1', '0', '2018-10-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1673', '1', '0', '2018-10-19', 'E-105', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1531', '1', '0', '2018-10-19', 'colegio (liceo c-21 )', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1742', '1', '0', '2018-10-19', 'escuela hogar E-104', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1666', '2', '0', '2018-10-19', 'escuela alondra D-135', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1672', '1', '0', '2018-10-19', 'politecnico C-20', '0');
INSERT INTO `clientemaquina` VALUES ('76148551', 'EXBR1276', '1', '1', '2018-10-19', 'fennix antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('76148551', 'EXBR1275', '1', '1', '2018-10-19', 'fennix antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('8082310', 'EXBR1277', '1', '1', '2018-10-19', 'luis leiva ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1278', '1', '0', '2018-10-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1279', '1', '0', '2018-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65628810', 'EXBR1279', '1', '1', '2018-10-23', 'prodel ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1700', '2', '1', '2018-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1280', '1', '0', '2018-10-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1983', '1', '0', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1984', '1', '0', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1985', '1', '0', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '1', '0', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1983', '1', '1', '2018-10-24', 'SALA DE PROFESORES 1Â° CICLO ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1703', '2', '1', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1984', '1', '1', '2018-10-24', 'sala profesores 2Â°ciclo ', null);
INSERT INTO `clientemaquina` VALUES ('76599537', 'EXBR1278', '1', '1', '2018-10-24', 'glauben ecology ', null);
INSERT INTO `clientemaquina` VALUES ('96757750', 'BR1986', '1', '0', '2018-10-24', 'faena ', '0');
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1280', '1', '1', '2018-10-24', 'falabella garantia ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1727', '2', '1', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1701', '2', '0', '2018-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1701', '2', '0', '2018-10-24', 'matemÃ¡ticas', '0');
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1985', '1', '1', '2018-10-26', 'inspectoria primer ciclo ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1704', '2', '0', '2018-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1281', '1', '1', '2018-10-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1723', '6', '1', '2018-10-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1718', '7', '0', '2018-10-29', 'ADM-080000/ADMINISTRACION CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1282', '1', '0', '2018-10-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78378860', 'EXBR1282', '1', '1', '2018-10-29', 'mejillones ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1870', '2', '0', '2018-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1663', '5', '0', '2018-11-06', 'GABY FAENA 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '6', '0', '2018-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1283', '1', '0', '2018-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1284', '1', '0', '2018-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('21863782', 'EXBR1283', '1', '1', '2018-11-07', 'av independencia 2265', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EXBR1284', '1', '1', '2018-11-07', 'externa FAM', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1285', '1', '0', '2018-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXBR1285', '1', '1', '2018-11-07', 'UNIVERSIDAD ANTOFAGASTA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1791', '4', '0', '2018-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1770', '3', '0', '2018-11-08', 'esc-12001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1988', '1', '0', '2018-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1989', '1', '0', '2018-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1990', '1', '0', '2018-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1991', '1', '0', '2018-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1286', '1', '0', '2018-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1722', '1', '0', '2018-11-12', 'bs-101-cmz001ba01 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '6', '0', '2018-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7704689', 'EXBR1286', '1', '1', '2018-11-12', 'rossana santamaria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1987', '1', '0', '2018-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1987', '1', '0', '2018-11-12', 'BS-102-CRT001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1807', '2', '0', '2018-11-13', 'calama puerto seco/oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1878', '2', '0', '2018-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1991', '1', '0', '2018-11-13', 'daem-of partes ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1989', '1', '0', '2018-11-13', 'daem finanzas ', '0');
INSERT INTO `clientemaquina` VALUES ('76056333', 'BR1988', '1', '0', '2018-11-13', 'oficina mejillones ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1992', '1', '0', '2018-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1992', '1', '0', '2018-11-13', 'Bsmg recursos humanos ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1287', '1', '0', '2018-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1262', '2', '0', '2018-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1262', '1', '1', '2018-11-13', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('76754263', 'EXBR1287', '1', '1', '2018-11-14', 'gacema otec ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1641', '1', '0', '2018-11-14', 'matricula ', '0');
INSERT INTO `clientemaquina` VALUES ('70791800', 'EP1870', '1', '0', '2018-11-15', 'finanzas', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1288', '1', '0', '2018-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1993', '1', '0', '2018-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'TO1993', '1', '0', '2018-11-16', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1857', '2', '1', '2018-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('95748000', 'TO-1609', '1', '1', '2018-11-16', 'oficina la negra', null);
INSERT INTO `clientemaquina` VALUES ('9512497', 'EXBR1288', '1', '1', '2018-11-16', 'jose toribio medina ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1289', '1', '0', '2018-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1289', '1', '1', '2018-11-20', 'hites ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1290', '1', '0', '2018-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1994', '1', '0', '2018-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1995', '1', '0', '2018-11-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1760', '3', '0', '2018-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1835', '3', '0', '2018-11-26', 'bs-202-mlb001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1994', '1', '0', '2018-11-26', 'recursos humanos ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1916', '2', '0', '2018-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76689118', 'IDE1834', '1', '1', '2018-11-26', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1291', '1', '0', '2018-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76063521', 'EXBR1291', '1', '1', '2018-11-26', 'insecap ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1791', '1', '1', '2018-11-29', 'back up', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1997', '1', '0', '2018-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1292', '1', '0', '2018-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'TO1997', '1', '0', '2018-12-03', 'oficina calama ', '0');
INSERT INTO `clientemaquina` VALUES ('91947000', 'EXTO1292', '1', '1', '2018-12-03', 'sika despacho ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1869', '3', '0', '2018-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1293', '1', '0', '2018-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16438921', 'EXBR1293', '1', '1', '2018-12-05', 'JOANA BARRAZA', null);
INSERT INTO `clientemaquina` VALUES ('76398358', 'EXBR1290', '1', '1', '2018-12-05', 'INCOSER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1996', '1', '0', '2018-12-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EP1996', '1', '1', '2018-12-05', 'rectoria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1870', '3', '0', '2018-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1998', '1', '0', '2018-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1999', '1', '0', '2018-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2000', '1', '1', '2018-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1998', '1', '0', '2018-12-10', 'bs-105-mel 002 ba01/ mel 2 ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1999', '1', '0', '2018-12-10', 'bs-103-mel002ba01 ', '0');
INSERT INTO `clientemaquina` VALUES ('99572320', 'EXBR1267', '1', '1', '2018-12-10', 'russell mill ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1461', '2', '1', '2018-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83484700', 'BR1916', '1', '1', '2018-12-10', 'LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '6', '0', '2018-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9670942', 'BR1929', '1', '0', '2018-12-11', 'CALAMA/ ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1838', '2', '0', '2018-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1878', '1', '0', '2018-12-11', 'ALCALDÃA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1786', '2', '0', '2018-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1765', '1', '0', '2018-12-11', 'secretaria/escuela g130 ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1869', '2', '0', '2018-12-12', 'salvador ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1294', '1', '0', '2018-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1786', '2', '0', '2018-12-17', 'SECRETARIA ESCUELA G130 BAQUEDANO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '7', '0', '2018-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1638', '5', '1', '2018-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1256', '2', '0', '2018-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1753', '1', '0', '2018-12-17', 'medio ambiente ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1870', '1', '0', '2018-12-17', 'oficina lomas bayas ', '0');
INSERT INTO `clientemaquina` VALUES ('70095900', 'BR1919', '1', '1', '2018-12-17', 'antofagasta, oficina ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1993', '2', '0', '2018-12-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('14464403', 'EXBR1294', '1', '1', '2018-12-18', 'jasna plantak ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1295', '1', '0', '2018-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1296', '1', '0', '2018-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1728', '2', '1', '2018-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76181913', 'EXBR1295', '1', '1', '2018-12-19', 'of. san gregorio 74d ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '2', '0', '2018-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1297', '1', '0', '2018-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'EXBR1297', '1', '1', '2018-12-27', 'secretaria administracion ', null);
INSERT INTO `clientemaquina` VALUES ('76006032', 'EXBR1296', '1', '1', '2018-12-27', 'servicios generales en gomas y metalmecanica', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '7', '0', '2018-12-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2001', '1', '0', '2018-12-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2001', '1', '1', '2018-12-27', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1255', '2', '1', '2018-12-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1256', '2', '1', '2018-12-27', 'Of. Concejo Municipal', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1525', '3', '0', '2018-12-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1760', '1', '1', '2018-12-28', 'escuela carlos condell ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1298', '1', '0', '2019-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '6', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1911', '2', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1299', '1', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2002', '1', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1838', '2', '0', '2019-01-03', 'bs-103-mel001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1788', '3', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1520', '5', '1', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1732', '2', '0', '2019-01-03', 'RECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('70265000', 'EXBR1299', '1', '1', '2019-01-03', 'codesser', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1531', '5', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '7', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1673', '4', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1666', '4', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '7', '0', '2019-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP2002', '1', '0', '2019-01-03', 'gof', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1300', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2004', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2005', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2006', '1', '1', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2007', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2008', '1', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '7', '0', '2019-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '5', '0', '2019-01-08', 'bs-205-cch001/chuquicamata ', '0');
INSERT INTO `clientemaquina` VALUES ('5972543', 'EXBR1300', '1', '1', '2019-01-08', 'guillermo mancilla ', null);
INSERT INTO `clientemaquina` VALUES ('76525290', 'EXBR1298', '1', '1', '2019-01-08', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1766', '1', '0', '2019-01-09', 'fam/sierra gorda ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '2', '0', '2019-01-10', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1884', '2', '0', '2019-01-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1884', '3', '0', '2019-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1944', '2', '0', '2019-01-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1944', '1', '0', '2019-01-14', 'FERROCARRIL CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1301', '1', '0', '2019-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1753', '2', '0', '2019-01-15', 'OPD', '0');
INSERT INTO `clientemaquina` VALUES ('78764450', 'EXBR1301', '1', '1', '2019-01-15', 'TMA ingenieria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1641', '8', '0', '2019-01-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1867', '2', '0', '2019-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '2', '0', '2019-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1672', '4', '0', '2019-01-21', 'MMH-49004-CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('76185799', 'BR2003', '1', '0', '2019-01-21', 'sagita calama ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2008', '1', '1', '2019-01-21', 'diseÃ±o ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2009', '1', '0', '2019-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2009', '1', '0', '2019-01-21', 'relaciones publicas ', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2007', '1', '0', '2019-01-21', 'ADQUISICION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '2', '0', '2019-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2004', '1', '0', '2019-01-21', 'bs-103-ces0021n01/salvador ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2010', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2011', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2013', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2014', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2015', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2016', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2012', '1', '0', '2019-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2013', '1', '0', '2019-01-25', 'DMHBS-101-CMH002IN01/CODELCO CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2012', '1', '0', '2019-01-25', 'DMHBS101-CMH002IN01 /CODELCO CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR2016', '1', '0', '2019-01-28', 'DAEM personal  ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '6', '0', '2019-01-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2018', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2019', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2020', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2021', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2022', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2023', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2024', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2025', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2026', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2027', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2028', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2029', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2030', '1', '0', '2019-02-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2031', '1', '0', '2019-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'KY2031', '1', '0', '2019-02-08', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1821', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2021', '1', '0', '2019-02-11', 'secplac 1', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1816', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2022', '1', '0', '2019-02-11', 'secplac 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1823', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2024', '1', '0', '2019-02-11', 'dideco ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1827', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2023', '1', '0', '2019-02-11', 'direcciÃ³n de control ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1814', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2018', '1', '0', '2019-02-11', 'posta rural Baquedano ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1820', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2019', '1', '0', '2019-02-11', 'juzgado policÃ­a local ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1819', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2020', '1', '0', '2019-02-11', 'juzgado policÃ­a local ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1986', '1', '0', '2019-02-11', 'bs-105- mel003ba01 escondida ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1957', '1', '0', '2019-02-11', 'BS-105-MEL003BA01 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1302', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96659360', 'EXBR1302', '1', '1', '2019-02-11', 'HONYWELL ANTOFAGASTA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1865', '2', '1', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2036', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2037', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2038', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2039', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2040', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2041', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2042', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2043', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2044', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2045', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2046', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2047', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2048', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2049', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2033', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2032', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2034', '1', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '1', '0', '2019-02-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO2033', '1', '0', '2019-02-11', 'FINANZAS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1822', '2', '0', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2030', '1', '0', '2019-02-11', 'DIRECCIÃ“N FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1813', '2', '1', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2029', '1', '0', '2019-02-11', 'BODEGA FARMACIA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1746', '3', '1', '2019-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2010', '1', '0', '2019-02-11', 'SECPLAC ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1809', '2', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2011', '1', '0', '2019-02-13', 'DIDECO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1811', '2', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2025', '1', '0', '2019-02-13', 'posta sierra gorda ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1781', '2', '1', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2036', '1', '0', '2019-02-13', 'FINANZAS BAQUEDANO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '2', '0', '2019-02-13', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2038', '1', '0', '2019-02-13', 'DOM ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1847', '3', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2041', '1', '0', '2019-02-13', 'DIRECCION DIDECO BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1744', '3', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2037', '1', '0', '2019-02-13', 'OF PARTES (ALCALDIA) ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1789', '2', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2045', '1', '0', '2019-02-13', 'SECRETARIA DE ALCALDE ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '3', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2042', '1', '0', '2019-02-13', 'DIRECCION DE SALUD BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1922 ', '2', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2043', '1', '0', '2019-02-13', 'DIRECCIÃ“N DE EDUCACIÃ“N ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1790', '2', '1', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2044', '1', '0', '2019-02-13', 'DIRECCION DE SECPLAC ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1303', '1', '0', '2019-02-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2036', '2', '0', '2019-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2035', '1', '0', '2019-02-18', 'FINANZAS BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1305', '1', '0', '2019-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1304', '1', '0', '2019-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76260599', 'EXBR1305', '1', '1', '2019-02-19', 'juan asper ', null);
INSERT INTO `clientemaquina` VALUES ('16791574', 'EXBR1303', '1', '1', '2019-02-19', 'felipe acuÃ±a robles ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2039', '1', '0', '2019-02-19', 'SERVICIOS GENERALES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '6', '0', '2019-02-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76010097', 'EXBR1304', '1', '1', '2019-02-19', 'constructora ls ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1306', '1', '0', '2019-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2048', '1', '0', '2019-02-25', 'OFICINA SEPLAC ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1818', '2', '1', '2019-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2046', '1', '0', '2019-02-25', 'DIRECCION FINANZAS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'HP1798', '2', '0', '2019-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '8', '0', '2019-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76521779', 'EXBR1306', '1', '1', '2019-02-25', 'ursicorp', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'HP2050', '1', '0', '2019-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'HP2050', '1', '0', '2019-02-26', 'SECPLAC ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1307', '1', '0', '2019-02-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1308', '1', '0', '2019-02-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1309', '1', '0', '2019-02-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77134420', 'EXBR1308', '1', '1', '2019-02-27', 'radio carnaval ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1873', '2', '0', '2019-02-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76419232', 'EP1876', '1', '0', '2019-02-27', 'caze salud ', '0');
INSERT INTO `clientemaquina` VALUES ('96732670', 'EXBR1307', '1', '1', '2019-02-27', 'hotel colon sa ', null);
INSERT INTO `clientemaquina` VALUES ('77162800', 'EXBR1309', '1', '1', '2019-02-27', 'electromecanica flores ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1765', '3', '0', '2019-02-28', 'bs-103-mel001ba01 ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1990', '1', '0', '2019-02-28', 'bs-103-mel001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1972', '2', '0', '2019-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1662', '7', '1', '2019-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1443', '4', '1', '2019-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1648', '2', '0', '2019-03-04', 'INSPECTORIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1310', '1', '0', '2019-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1311', '1', '0', '2019-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1312', '1', '0', '2019-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EXBR1310', '1', '1', '2019-03-05', 'ferrocarril externa ', null);
INSERT INTO `clientemaquina` VALUES ('17433995', 'EXBR1312', '1', '1', '2019-03-05', 'karen ordenes externa  ', null);
INSERT INTO `clientemaquina` VALUES ('76391903', 'EXBR1311', '1', '1', '2019-03-05', 'externa ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1614', '1', '0', '2019-03-05', 'fam antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2034', '1', '0', '2019-03-06', 'secretaria oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2040', '1', '0', '2019-03-06', 'ESCUELA G-130', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2026', '1', '0', '2019-03-06', 'depto utp ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1810', '2', '0', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2047', '1', '0', '2019-03-06', 'secretaria director ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1825', '2', '0', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2027', '1', '0', '2019-03-06', 'sala de profesores ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1826', '2', '1', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2028', '1', '0', '2019-03-06', 'biblioteca ', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1673', '1', '0', '2019-03-06', 'rectoria ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1960', '1', '0', '2019-03-06', 'maritza rojas huerta oficina baquedano ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1786', '3', '1', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1805', '2', '0', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1815', '2', '0', '2019-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1795', '3', '0', '2019-03-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'BR1827', '1', '0', '2019-03-07', 'notaria tocopilla ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1756', '3', '1', '2019-03-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'TO1733', '1', '1', '2019-03-07', 'sala de profesores', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1739', '2', '1', '2019-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1821', '1', '1', '2019-03-08', 'tesoreria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1633', '3', '1', '2019-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1820', '1', '1', '2019-03-08', 'ractoria ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2045', '2', '0', '2019-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1883', '2', '0', '2019-03-11', 'alcaldÃ­a baquedano', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '2', '0', '2019-03-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2035', '1', '0', '2019-03-11', 'Finanza', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1314', '1', '0', '2019-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2031', '2', '0', '2019-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11872506', 'KY2031', '1', '0', '2019-03-13', 'NOTARIA TREUER ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1313', '1', '0', '2019-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR2015', '1', '1', '2019-03-15', 'OMIL', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'EP2049', '1', '1', '2019-03-15', 'JARDIN CORALITO (OFICINA)', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1742', '1', '0', '2019-03-15', 'Direccion Academica', '0');
INSERT INTO `clientemaquina` VALUES ('78498240', 'EXBR1313', '1', '1', '2019-03-15', 'geomaq ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1315', '1', '1', '2019-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9441231', 'EXBR1314', '1', '1', '2019-03-20', 'juan carlos torres ', null);
INSERT INTO `clientemaquina` VALUES ('76513726', 'BR1819', '1', '1', '2019-03-20', 'antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '4', '0', '2019-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11203242', 'EP1960', '1', '0', '2019-03-21', 'Calama', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1817', '1', '0', '2019-03-21', 'peÃ±on ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1783', '3', '1', '2019-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1732', '7', '0', '2019-03-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76513726', 'BR1814', '1', '1', '2019-03-22', 'LOBBY', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1316', '1', '0', '2019-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76513726', 'BR1710', '1', '1', '2019-03-22', 'hotel MT ', null);
INSERT INTO `clientemaquina` VALUES ('76513726', 'BR1816', '1', '1', '2019-03-22', 'hotel mt (maquina de Stock) ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1317', '1', '0', '2019-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76265500', 'EXBR1317', '1', '1', '2019-03-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1318', '1', '0', '2019-03-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9132056', 'EXBR1318', '1', '1', '2019-03-25', 'GARANTIA BROHER', null);
INSERT INTO `clientemaquina` VALUES ('79705403', 'BR1823', '1', '1', '2019-03-25', 'SIEC ', null);
INSERT INTO `clientemaquina` VALUES ('76761720', 'EXBR1316', '1', '1', '2019-03-25', 'dimport ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1531', '1', '1', '2019-03-27', 'PSICOLOGIA 2Â° ciclo ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1482', '4', '0', '2019-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1827', '3', '0', '2019-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8311491', 'TO1482', '1', '0', '2019-03-29', 'Notaria Tocopilla', '0');
INSERT INTO `clientemaquina` VALUES ('8311491', 'BR1827', '1', '0', '2019-03-29', 'Notaria Tocopilla', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1855', '2', '0', '2019-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'BR1884', '1', '0', '2019-03-29', '2Â°piso ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1658', '3', '1', '2019-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1751', '2', '1', '2019-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1481', '3', '0', '2019-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1805', '1', '1', '2019-04-01', 'BS-000-ADM014ES01 2Â°PISO OFICINA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1680', '2', '0', '2019-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'TO2032', '1', '1', '2019-04-01', 'CENTRAL DE APUNTES ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '4', '0', '2019-04-04', 'chuqui bs-205-cch001', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2040', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2037', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2038', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2035', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2036', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2033', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2039', '1', '0', '2019-04-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2035', '1', '1', '2019-04-05', '3Â°piso actividad fisica ', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2036', '1', '1', '2019-04-05', 'deporte competitivo ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1825', '1', '1', '2019-04-05', 'BS-105-SPC001BA01', null);
INSERT INTO `clientemaquina` VALUES ('79705403', 'KY2033', '1', '0', '2019-04-08', 'ANTOFAGASTA', '0');
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2037', '1', '1', '2019-04-09', 'GIN', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2040', '1', '1', '2019-04-09', 'CRECER EN MOVIMIENTO', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2039', '1', '1', '2019-04-09', 'OFICINA ANALISTA DPS', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2038', '1', '1', '2019-04-09', 'PISCINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2033', '2', '0', '2019-04-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61107000', 'KY2033', '1', '1', '2019-04-09', 'OFICINA DE PARTES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1319', '1', '0', '2019-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1666', '1', '0', '2019-04-11', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('65155528', 'EXBR1319', '1', '1', '2019-04-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1320', '1', '0', '2019-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76961000', 'EXBR1320', '1', '1', '2019-04-11', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2041', '1', '0', '2019-04-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65114358', 'TO2041', '1', '0', '2019-04-11', 'FUNDACION MI NORTE', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1833', '1', '1', '2019-04-12', 'ESC. PABLO NERUDA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1758', '3', '0', '2019-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1321', '1', '0', '2019-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76354375', 'EXBR1321', '1', '1', '2019-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '3', '0', '2019-04-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1795', '1', '1', '2019-04-17', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2054', '1', '0', '2019-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2056', '1', '0', '2019-04-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76733334', 'EP2056', '1', '0', '2019-04-18', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1941', '1', '0', '2019-04-18', 'CONTROL', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1809', '1', '0', '2019-04-18', 'BS-102-CRT001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1322', '1', '0', '2019-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69252500', 'EXBR1322', '1', '1', '2019-04-22', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'IB2054', '1', '1', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1323', '1', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76732735', 'EXBR1323', '1', '1', '2019-04-24', 'EXTERNA FOLIO 360', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2052', '1', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2052', '1', '1', '2019-04-24', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2053', '1', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2053', '1', '1', '2019-04-24', 'CENTRAL DE APUNTES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2051', '1', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2051', '1', '1', '2019-04-24', 'ESC. B. OHIGGINS DEPTO TECNICO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '8', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1324', '1', '0', '2019-04-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15022287', 'EXBR1324', '1', '1', '2019-04-26', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1699', '2', '0', '2019-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1789', '1', '1', '2019-04-30', 'inspectoria 2 ciclo ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'RIS1758', '2', '1', '2019-05-02', 'boh central de apuntes ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2032', '1', '0', '2019-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'KY2032', '1', '0', '2019-05-06', 'notaria mejillones ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1325', '1', '0', '2019-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76191772', 'EXBR1325', '1', '1', '2019-05-13', 'venta ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'BR1866', '1', '0', '2019-05-13', 'lascar ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2056', '1', '0', '2019-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2055', '1', '0', '2019-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR2056', '1', '0', '2019-05-13', 'sala computacion', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2055', '1', '1', '2019-05-13', 'sala computacion piso 2 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2034', '1', '0', '2019-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83385600', 'KY2034', '1', '0', '2019-05-14', 'movitec oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1326', '1', '0', '2019-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1327', '1', '0', '2019-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1861', '2', '0', '2019-05-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125014', 'EXBR1327', '1', '1', '2019-05-14', 'externa ', null);
INSERT INTO `clientemaquina` VALUES ('76125014', 'EXBR1326', '1', '1', '2019-05-15', 'externa ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1837', '2', '0', '2019-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '4', '0', '2019-05-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2045', '2', '0', '2019-05-16', 'alcaldia ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1725', '4', '1', '2019-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76179538', 'BR1699', '1', '0', '2019-05-17', 'aeropuerto ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1718', '9', '1', '2019-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2014', '1', '0', '2019-05-17', 'ADM-08000', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2057', '1', '0', '2019-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2056', '2', '0', '2019-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2056', '1', '1', '2019-05-20', 'SALA DE COMPUTACION BASICA', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2057', '1', '0', '2019-05-20', 'oficina recursos humanos ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1480', '5', '1', '2019-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1843', '2', '0', '2019-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2058', '1', '0', '2019-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1328', '1', '0', '2019-05-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11612845', 'EXBR1328', '1', '1', '2019-05-29', 'alejandro palma ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1329', '1', '0', '2019-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1331', '1', '0', '2019-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1332', '1', '0', '2019-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1329', '1', '1', '2019-06-03', 'falabella calama ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2058', '1', '0', '2019-06-03', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('6752412', 'EXBR1332', '1', '1', '2019-06-03', 'maria montenegro ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1685', '2', '1', '2019-06-04', 'PSICOLOGIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1686', '2', '0', '2019-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1692', '2', '0', '2019-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2059', '1', '0', '2019-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1521', '4', '0', '2019-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1855', '1', '0', '2019-06-05', 'BS-101-CMH002BA01 (CODELCO)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1333', '1', '0', '2019-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2060', '1', '0', '2019-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('90146000', 'EXBR1333', '1', '1', '2019-06-05', 'progreso calama ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2079', '1', '0', '2019-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2079', '1', '0', '2019-06-05', 'BS-101-CMZ001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2060', '1', '1', '2019-06-05', 'BS-000-ADM015ES01 ', null);
INSERT INTO `clientemaquina` VALUES ('93779000', 'KY2059', '1', '1', '2019-06-06', 'faena gabriela mistral ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1330', '1', '0', '2019-06-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('93077000', 'EXBR1330', '1', '1', '2019-06-06', 'droguett ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1547', '4', '1', '2019-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1481', '1', '0', '2019-06-07', 'transito ', '0');
INSERT INTO `clientemaquina` VALUES ('76229860', 'EXBR1331', '1', '1', '2019-06-07', 'saser safety ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2041', '2', '0', '2019-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1883', '3', '0', '2019-06-07', 'dideco sierra gorda ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1722', '3', '1', '2019-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2011', '2', '0', '2019-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR1922 ', '2', '0', '2019-06-11', 'dideco ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1334', '1', '0', '2019-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1335', '1', '0', '2019-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1336', '1', '0', '2019-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1337', '1', '0', '2019-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1338', '1', '0', '2019-06-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1972', '2', '0', '2019-06-12', 'chuquicamata ', '0');
INSERT INTO `clientemaquina` VALUES ('76001769', 'EXBR1334', '1', '1', '2019-06-12', 'mena y mena ', null);
INSERT INTO `clientemaquina` VALUES ('15336964', 'EXBR1337', '1', '1', '2019-06-12', 'tania avendaÃ±o ', null);
INSERT INTO `clientemaquina` VALUES ('79527230', 'EXBR1335', '1', '1', '2019-06-12', 'emin ing ', null);
INSERT INTO `clientemaquina` VALUES ('79527230', 'EXBR1336', '1', '1', '2019-06-12', 'emin ing', null);
INSERT INTO `clientemaquina` VALUES ('76682120', 'EXBR1338', '1', '1', '2019-06-12', 'brown and morgan ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '3', '0', '2019-06-12', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1944', '3', '0', '2019-06-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1941', '2', '0', '2019-06-17', 'FERROCARRIL CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'X25R002626', '1', '1', '2019-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1339', '1', '0', '2019-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13198616', 'EXEP1339', '1', '1', '2019-06-19', 'venta san pedro atacama ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2080', '1', '0', '2019-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2080', '1', '0', '2019-06-19', 'control ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1340', '1', '0', '2019-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1341', '1', '0', '2019-06-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2011', '2', '0', '2019-06-20', 'dideco sierra gorda ', '0');
INSERT INTO `clientemaquina` VALUES ('76042014', 'EXBR1341', '1', '1', '2019-06-20', 'walmart garantia ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1340', '1', '1', '2019-06-20', 'falabella ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2041', '2', '0', '2019-06-24', 'dideco ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '5', '0', '2019-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2065', '1', '0', '2019-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'KY2065', '1', '1', '2019-06-24', '3 er piso', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2080', '2', '0', '2019-06-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('74454100', 'EP2080', '1', '1', '2019-06-24', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1342', '1', '0', '2019-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'OK1343', '1', '0', '2019-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99562370', 'OK1343', '1', '1', '2019-06-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1344', '1', '0', '2019-06-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('24311943', 'EXBR1344', '1', '1', '2019-06-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1345', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76380532', 'EXBR1345', '1', '1', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2055', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76367270', 'EP2055', '1', '0', '2019-07-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76479798', 'EP2036', '1', '0', '2019-07-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1346', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1346', '1', '1', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76176613', 'EXBR1342', '1', '1', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '2', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1883', '1', '0', '2019-07-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2061', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2062', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2063', '1', '1', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2064', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2066', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2067', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2068', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2069', '1', '1', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2070', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2071', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2072', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2073', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2074', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2075', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2076', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2077', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2078', '1', '0', '2019-07-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2057', '2', '1', '2019-07-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2077', '1', '0', '2019-07-04', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76238445', 'TO1993', '1', '1', '2019-07-05', 'suaval- Maria Helena', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1801', '1', '0', '2019-07-05', 'call center ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1640', '3', '1', '2019-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '3', '0', '2019-07-09', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1846', '3', '0', '2019-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76797557', 'TO1843', '1', '0', '2019-07-11', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('76662759', 'EP2054', '1', '1', '2019-07-11', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', '7018904304', '1', '1', '2019-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1349', '1', '0', '2019-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1347', '1', '0', '2019-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1348', '1', '0', '2019-07-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('86431800', 'EXTO1347', '1', '0', '2019-07-11', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('86431800', 'EXTO1349', '1', '0', '2019-07-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1680', '1', '1', '2019-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1628', '3', '1', '2019-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('86431800', 'EXTO1348', '1', '1', '2019-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '6', '0', '2019-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1213', '2', '0', '2019-07-12', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2041', '2', '0', '2019-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2081', '1', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78991830', 'TO2081', '1', '1', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76689118', 'BR1853', '1', '0', '2019-07-15', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2012', '2', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2082', '1', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2012', '2', '0', '2019-07-15', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('73968300', 'EP2082', '1', '1', '2019-07-15', 'PUERTO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2083', '1', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2084', '1', '1', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2085', '1', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('73968300', 'EP2083', '1', '1', '2019-07-15', 'PUERTO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '7', '0', '2019-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1350', '1', '0', '2019-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('23906778', 'EXTO1350', '1', '1', '2019-07-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76429110', 'BR1811', '1', '0', '2019-07-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1054', '2', '0', '2019-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1672', '8', '0', '2019-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1867', '1', '0', '2019-07-19', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2085', '1', '1', '2019-07-19', 'DAEM', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1686', '2', '0', '2019-07-19', 'COMPUTACION BASICA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '3', '0', '2019-07-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'KY2071', '1', '1', '2019-07-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1460', '1', '0', '2019-07-24', 'gerson salazar', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1351', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1352', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1353', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1354', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1355', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1356', '1', '0', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76380532', 'EXBR1355', '1', '1', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7683976', 'EXBR1354', '1', '1', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76009937', 'EXBR1351', '1', '1', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76613923', 'EXEP1356', '1', '1', '2019-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1847', '1', '1', '2019-07-25', 'SOCIAL ', null);
INSERT INTO `clientemaquina` VALUES ('76953555', 'EXBR1352', '1', '1', '2019-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12263231', 'EXBR1353', '1', '1', '2019-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1357', '1', '0', '2019-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1358', '1', '0', '2019-07-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1688', '2', '1', '2019-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1692', '2', '1', '2019-07-26', 'GIMNASIO 2', null);
INSERT INTO `clientemaquina` VALUES ('16438099', 'EXBR1357', '1', '1', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1787', '2', '1', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76185799', 'BR1817', '1', '0', '2019-07-29', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '5', '0', '2019-07-29', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1019', '2', '1', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'TO1744', '1', '0', '2019-07-29', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('77276280', 'EXBR1358', '1', '1', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1359', '1', '0', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79527230', 'EXBR1359', '1', '1', '2019-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91947000', 'EXTO1054', '2', '1', '2019-07-30', 'CLIENTE TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1361', '1', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1361', '1', '1', '2019-08-01', '', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1362', '1', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1922 ', '3', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1360', '1', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('92177000', 'EXBR1360', '1', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1766', '7', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1669', '5', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1992', '2', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2031', '3', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1863', '2', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1752', '2', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1363', '1', '0', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17210262', 'EXBR1363', '1', '1', '2019-08-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65147763', 'EXBR1362', '1', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1364', '1', '0', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1364', '1', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1691', '2', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1732', '1', '1', '2019-08-02', 'LENGUAJE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1711', '2', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1525', '1', '1', '2019-08-02', 'INGLES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1707', '2', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1475', '1', '1', '2019-08-02', 'HISTORIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1701', '3', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1672', '1', '1', '2019-08-02', 'MATEMATICAS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1698', '2', '1', '2019-08-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1641', '1', '1', '2019-08-02', 'ACADEMIAS CULTURALES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1737', '4', '0', '2019-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1365', '1', '0', '2019-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1366', '1', '0', '2019-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99536660', 'EXBR1365', '1', '1', '2019-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96684600', 'EXBR1366', '1', '1', '2019-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2086', '1', '0', '2019-08-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77471030', 'EP2086', '1', '0', '2019-08-07', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2064', '1', '1', '2019-08-08', 'DAEM LICEO C-21 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1811', '3', '0', '2019-08-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1846', '3', '0', '2019-08-08', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2077', '2', '0', '2019-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2066', '1', '0', '2019-08-12', 'OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2087', '1', '0', '2019-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2088', '1', '0', '2019-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2089', '1', '0', '2019-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'TO2088', '1', '0', '2019-08-13', 'ZOCALO', '0');
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2087', '1', '0', '2019-08-13', 'CONSULTORIO', '0');
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2089', '1', '0', '2019-08-13', 'INFORMATICA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '4', '0', '2019-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1974', '2', '0', '2019-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1473', '2', '1', '2019-08-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1365', '1', '0', '2019-08-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1366', '1', '0', '2019-08-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2090', '1', '0', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1367', '1', '0', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1368', '1', '0', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1369', '1', '0', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'BR1366', '1', '1', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76613923', 'EXEP1365', '1', '1', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1368', '1', '1', '2019-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11680709', 'EXBR1367', '1', '1', '2019-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2091', '1', '0', '2019-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2092', '1', '0', '2019-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2093', '1', '0', '2019-08-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2091', '1', '1', '2019-08-21', 'ADQUISICIONES', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'TO2093', '1', '1', '2019-08-21', '2 DO. PISO', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'TO2092', '1', '1', '2019-08-21', '3 ER PISO', null);
INSERT INTO `clientemaquina` VALUES ('76754263', 'EXBR1369', '1', '1', '2019-08-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2070', '1', '1', '2019-08-23', 'BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2095', '1', '0', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2096', '1', '0', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2094', '1', '0', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'TO2095', '1', '1', '2019-08-23', 'ESCRITURA 1', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1505', '5', '1', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'TO2096', '1', '0', '2019-08-23', 'ESCRITURA 2', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2094', '1', '0', '2019-08-23', 'MMH-49004-CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2078', '1', '0', '2019-08-23', 'DMHBS-101-CMH002IN01/CODELCO CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1750', '2', '1', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1686', '3', '0', '2019-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1837', '1', '1', '2019-08-23', 'COMPUTACION BASICA', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR2090', '1', '0', '2019-08-27', 'DAEM TECNICO PEDAGOGICO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1854', '2', '1', '2019-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1856', '2', '0', '2019-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1884', '4', '0', '2019-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1922 ', '1', '0', '2019-08-29', 'MEL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1370', '1', '0', '2019-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1371', '1', '0', '2019-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1372', '1', '0', '2019-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1373', '1', '0', '2019-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1374', '1', '0', '2019-08-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2097', '1', '0', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2097', '1', '0', '2019-08-30', 'EDUCACION', '0');
INSERT INTO `clientemaquina` VALUES ('15691900', 'EXBR1372', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76270521', 'EXBR1370', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1371', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2098', '1', '0', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBR1374', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2099', '1', '0', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2100', '1', '0', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('22764028', 'EXBR1373', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2101', '1', '0', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2102', '1', '1', '2019-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76010685', 'KY2061', '1', '1', '2019-09-02', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2103', '1', '0', '2019-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1695', '3', '1', '2019-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'TO2103', '1', '1', '2019-09-05', 'CONSULTORIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1375', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1376', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1377', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1378', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1379', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1380', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1381', '1', '0', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('86431800', 'EXBR1375', '1', '1', '2019-09-05', 'brinks', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1347', '2', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1376', '1', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76042014', 'EXBR1380', '1', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76042014', 'EXBR1379', '1', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11383739', 'EXBR1381', '1', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76112086', 'EXBR1378', '1', '1', '2019-09-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1843', '3', '0', '2019-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '2', '0', '2019-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76797557', 'TO1843', '2', '0', '2019-09-06', 'FAENA LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1690', '2', '1', '2019-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1799', '1', '1', '2019-09-06', 'HISTORIA', null);
INSERT INTO `clientemaquina` VALUES ('14264113', 'EXBR1377', '1', '1', '2019-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1955', '2', '0', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1858', '2', '1', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO1521', '1', '1', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1912', '2', '0', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1774', '2', '1', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2104', '1', '0', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2109', '1', '0', '2019-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8215914', 'TO2104', '1', '0', '2019-09-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('8215914', 'KY2068', '1', '0', '2019-09-11', 'notaria', '0');
INSERT INTO `clientemaquina` VALUES ('7016316', 'TO2109', '1', '1', '2019-09-11', 'NOTARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2104', '2', '0', '2019-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1382', '1', '0', '2019-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76042014', 'EXBR1382', '1', '1', '2019-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1913', '2', '1', '2019-09-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'KY2076', '1', '1', '2019-09-11', 'ADMINISTRACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '8', '0', '2019-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1845', '1', '1', '2019-09-12', 'ESC.EE.UU (UTP)', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2012', '3', '0', '2019-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1855', '3', '0', '2019-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1846', '4', '0', '2019-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1383', '1', '0', '2019-09-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1699', '3', '1', '2019-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2111', '1', '0', '2019-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77073480', 'EP2111', '1', '1', '2019-09-13', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1929', '3', '0', '2019-09-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1384', '1', '0', '2019-09-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1384', '2', '0', '2019-09-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76657896', 'EXBR1383', '1', '1', '2019-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1385', '1', '0', '2019-09-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65102261', 'EXEP1385', '1', '1', '2019-09-25', 'ENSEÃ‘ANZA PREESCOLAR', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1386', '1', '0', '2019-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1387', '1', '0', '2019-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1388', '1', '0', '2019-09-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2003', '1', '0', '2019-09-25', 'BS-103-CES0021N01/salvador ', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2012', '3', '0', '2019-09-25', 'bs-103-ces0021n01/salvador ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1389', '1', '0', '2019-09-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72907800', 'EXBR1386', '1', '1', '2019-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8377117', 'EXBR1387', '1', '1', '2019-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1390', '1', '0', '2019-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1391', '1', '0', '2019-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76732124', 'EXBR1390', '1', '1', '2019-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60109000', 'EXBR1388', '1', '1', '2019-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1500', '6', '1', '2019-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77430080', 'KY2075', '1', '1', '2019-09-30', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13868210', 'EXBR1389', '1', '1', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1392', '1', '0', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1392', '1', '1', '2019-10-02', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '8', '0', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96849540', 'KY2074', '1', '1', '2019-10-02', 'MEJILLONES', null);
INSERT INTO `clientemaquina` VALUES ('76132593', 'EP2101', '1', '1', '2019-10-02', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1349', '2', '1', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1393', '1', '0', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('86431800', 'EXBR1393', '1', '1', '2019-10-02', 'BRINKS', null);
INSERT INTO `clientemaquina` VALUES ('76262882', 'EXBR1391', '1', '1', '2019-10-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1395', '1', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1396', '1', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1397', '1', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1398', '1', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1399', '1', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76507666', 'EXBR1395', '1', '1', '2019-10-04', 'OFICINA SERV.DOMICILIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2004', '2', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1868', '3', '0', '2019-10-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65728790', 'EXBR1399', '1', '1', '2019-10-07', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('77276280', 'EXBR1398', '1', '1', '2019-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77276280', 'EXBR1396', '1', '1', '2019-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77276280', 'EXBR1397', '1', '1', '2019-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '3', '0', '2019-10-09', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'TO1912', '1', '0', '2019-10-09', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1401', '1', '0', '2019-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1402', '1', '0', '2019-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1403', '1', '0', '2019-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76257428', 'EXEP1402', '1', '1', '2019-10-14', 'OFICINA FAENA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '6', '0', '2019-10-14', 'CHUQUICAMATA', '0');
INSERT INTO `clientemaquina` VALUES ('13328822', 'EXBR1401', '1', '1', '2019-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77572850', 'EXEP1403', '1', '1', '2019-10-14', 'OFICINA ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1686', '1', '0', '2019-10-15', 'MEL 1(BS-103-MEL001BA01)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '8', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1763', '3', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1400', '1', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1400', '1', '1', '2019-10-15', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'KY2067', '1', '0', '2019-10-15', '2do  PISO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1404', '1', '1', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1404', '1', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1405', '1', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1406', '1', '0', '2019-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99572320', 'EXBR1404', '1', '1', '2019-10-15', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2073', '1', '1', '2019-10-15', 'FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1972', '3', '0', '2019-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76110235', 'EXBR1406', '1', '1', '2019-10-17', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('99595800', 'KY2072', '1', '1', '2019-10-18', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1498', '3', '1', '2019-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2043', '2', '0', '2019-10-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2043', '1', '1', '2019-10-18', 'DIRECCION ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2062', '1', '1', '2019-10-18', 'ESC.PABLO NERUDA(OF.UTP)', null);
INSERT INTO `clientemaquina` VALUES ('8311491', 'BR1868', '1', '0', '2019-10-18', 'OFICINA NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('8311491', 'BR1856', '1', '0', '2019-10-18', 'OFICINA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1407', '1', '0', '2019-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1958', '2', '1', '2019-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1815', '1', '0', '2019-10-22', 'oficina calama ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1408', '1', '0', '2019-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77059162', 'EXEP1408', '1', '1', '2019-10-22', 'VENTA ANT', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1456', '3', '1', '2019-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1460', '1', '0', '2019-10-24', 'GESTOR USUARIO LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '5', '0', '2019-10-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61606203', 'BR1460', '1', '0', '2019-10-24', 'GESTOR USUARIO LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('69900303', 'EP1883', '1', '0', '2019-10-24', 'instalacion provisional ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '7', '0', '2019-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11946737', 'EXBR1407', '1', '1', '2019-10-29', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2068', '2', '0', '2019-10-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'BR1884', '1', '1', '2019-10-29', 'NOTARIA LASCAR', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1405', '1', '1', '2019-10-29', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1827', '4', '0', '2019-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1409', '1', '0', '2019-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96828740', 'EXTO1409', '1', '1', '2019-11-05', 'EXTERNA TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1997', '2', '0', '2019-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2017', '1', '0', '2019-11-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO2017', '1', '0', '2019-11-07', 'MINERA ESCONDIDA(OXIDO)', '0');
INSERT INTO `clientemaquina` VALUES ('77794540', 'TO1995', '1', '0', '2019-11-07', 'FAENA ESCONDIDA(SULFURO)', '0');
INSERT INTO `clientemaquina` VALUES ('76381978', 'EP1911', '1', '0', '2019-11-08', 'CALAMA /PARQUE BALMACEDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2112', '1', '0', '2019-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2113', '1', '0', '2019-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2114', '1', '0', '2019-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2115', '1', '0', '2019-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'EP2114', '1', '1', '2019-11-08', 'NOTARIA ARRIETA', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'EP2112', '1', '1', '2019-11-08', 'NOTARIA ARRIETA', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'EP2113', '1', '1', '2019-11-08', 'NOTARIA ARRIETA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1810', '1', '0', '2019-11-08', 'zaldivar bs-101cmz-001ba01', '0');
INSERT INTO `clientemaquina` VALUES ('7016316', 'EP2115', '1', '1', '2019-11-11', 'NOTARIA ARRIETA', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'EP1883', '1', '0', '2019-11-13', 'junji oficina prov.', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1410', '1', '0', '2019-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77461750', 'EXBR1410', '1', '1', '2019-11-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1929', '1', '0', '2019-11-19', 'COLEGIO RENDIC', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1410', '1', '0', '2019-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70791800', 'EXEP1410', '1', '1', '2019-11-20', 'CENTRO DE DESARROLLO ENERGETICO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1411', '1', '0', '2019-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1412', '1', '0', '2019-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1413', '1', '0', '2019-11-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11722632', 'EXBR1411', '1', '1', '2019-11-22', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1763', '1', '0', '2019-11-22', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('76683564', 'EXBR1412', '1', '1', '2019-11-22', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2116', '1', '0', '2019-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1414', '1', '0', '2019-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1415', '1', '0', '2019-11-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1416', '1', '0', '2019-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('24334035', 'EXBR1416', '1', '1', '2019-11-27', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2116', '1', '0', '2019-11-27', 'CHUQUICAMATA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'EXBR1414', '1', '1', '2019-11-27', 'BS-103-CRT002BA01(PREVENCION RIESGO)', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EXBR1415', '1', '0', '2019-11-27', 'BS-103-CRT002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '8', '0', '2019-11-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2117', '1', '1', '2019-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1417', '1', '0', '2019-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1418', '1', '0', '2019-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76400472', 'EXBR1417', '1', '1', '2019-12-03', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1866', '1', '0', '2019-12-03', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('16133237', 'EXBR1418', '1', '1', '2019-12-03', 'garantia brother ', null);
INSERT INTO `clientemaquina` VALUES ('76429110', 'BR1811', '2', '0', '2019-12-03', 'ADMINISTRACION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1626', '3', '1', '2021-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1419', '1', '0', '2019-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1420', '1', '0', '2019-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76270521', 'EXBR1420', '1', '1', '2019-12-04', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1944', '4', '0', '2019-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1827', '1', '1', '2019-12-06', 'secretaria academica', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1742', '8', '1', '2019-12-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77461750', 'EXBR1413', '1', '1', '2019-12-06', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('16450044', 'EXBR1419', '1', '1', '2019-12-06', 'externa', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1924', '2', '1', '2019-12-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '4', '0', '2019-12-09', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP1944', '2', '0', '2019-12-09', 'OFICINA CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1421', '1', '0', '2019-12-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1811', '4', '0', '2019-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12365746', 'EXEP1421', '1', '1', '2019-12-10', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1765', '4', '0', '2019-12-10', 'bs-103-mel001ba01 ', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1841', '1', '0', '2019-12-11', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1422', '1', '0', '2019-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1422', '1', '1', '2019-12-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '4', '0', '2019-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1423', '1', '0', '2019-12-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76036872', 'EXEP1423', '1', '1', '2019-12-11', 'VENTA OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RIS1675', '4', '1', '2019-12-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '9', '0', '2019-12-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2118', '1', '0', '2019-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2119', '1', '0', '2019-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1424', '1', '0', '2019-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96945150', 'TO2118', '1', '0', '2019-12-13', 'MANTOS BLANCOS ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1911', '3', '0', '2019-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2105', '1', '0', '2019-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1425', '1', '0', '2019-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1426', '1', '0', '2019-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1427', '1', '0', '2019-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1428', '1', '0', '2019-12-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76125014', 'EXBR1427', '1', '1', '2019-12-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2079', '2', '0', '2019-12-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1428', '1', '1', '2019-12-18', 'externa', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1944', '5', '1', '2019-12-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP2105', '1', '0', '2019-12-18', 'oficina', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1932', '2', '0', '2019-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1855', '1', '0', '2019-12-19', 'FINANZAS', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1932', '2', '0', '2019-12-19', 'dideco ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1429', '1', '0', '2019-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1430', '1', '0', '2019-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65086877', 'EXBR1425', '1', '1', '2019-12-19', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76768702', 'EXBR1426', '1', '1', '2019-12-19', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1430', '1', '1', '2019-12-19', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'TO2119', '1', '1', '2019-12-19', 'OFICINA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2120', '1', '0', '2019-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77242190', 'KY2120', '1', '1', '2019-12-19', 'oficina 403', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1539', '6', '0', '2019-12-19', 'SF-201-CGM', '0');
INSERT INTO `clientemaquina` VALUES ('76006032', 'EXBR1429', '1', '1', '2019-12-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1932', '3', '0', '2019-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'BR1861', '1', '0', '2019-12-23', 'DIDECO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1431', '1', '0', '2019-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '4', '0', '2019-12-24', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76356183', 'EXBR1431', '1', '1', '2019-12-24', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '4', '0', '2019-12-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP1911', '1', '0', '2019-12-24', 'centro copiado ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1841', '3', '0', '2019-12-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1432', '1', '0', '2019-12-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1432', '1', '1', '2020-01-02', 'GARANTIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1797', '2', '1', '2020-01-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('82200000', 'BR1704', '1', '1', '2020-01-02', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1433', '1', '0', '2020-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1434', '1', '0', '2020-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1433', '1', '1', '2020-01-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('16245135', 'EXBR1434', '1', '1', '2020-01-03', 'EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1435', '1', '0', '2020-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76136141', 'EXBR1435', '1', '1', '2020-01-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '4', '0', '2020-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1436', '1', '0', '2020-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61979830', 'EXTO1436', '1', '1', '2020-01-07', 'ED. LAS EMPRESAS OF. 402', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'HP1798', '1', '1', '2020-01-08', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1868', '4', '0', '2020-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1437', '1', '0', '2020-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('73968300', 'EXKY1437', '1', '1', '2020-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1663', '6', '0', '2020-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2121', '1', '0', '2020-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2121', '1', '0', '2020-01-09', 'BS-102-CRT002BA01(INTEGRAL ELECTRICO)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1987', '2', '1', '2020-01-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8311491', 'BR1866', '1', '0', '2020-01-10', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1482', '5', '1', '2020-01-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1438', '1', '0', '2020-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76063521', 'EXBR1438', '1', '1', '2020-01-13', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1763', '4', '1', '2020-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2104', '1', '0', '2020-01-15', 'CONTROL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1885', '2', '1', '2020-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1439', '1', '0', '2020-01-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2106', '1', '0', '2020-01-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76425249', 'EP2106', '1', '0', '2020-01-23', 'OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1808', '2', '1', '2020-01-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78438660', 'EXBR1439', '1', '1', '2020-01-23', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1440', '1', '0', '2020-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77928160', 'EXBR1440', '1', '1', '2020-01-24', 'cliente externo', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '7', '0', '2020-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1535', '6', '0', '2020-01-24', 'BS-102-CRT002BA01(INTEGRAL ELECTRICO)', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2106', '2', '0', '2020-01-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76284812', 'EP2106', '1', '1', '2020-01-24', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2035', '2', '0', '2020-01-28', 'DOM', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2038', '2', '0', '2020-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1441', '1', '0', '2020-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1442', '1', '0', '2020-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1443', '1', '0', '2020-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1764', '3', '1', '2020-01-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'BR1663', '1', '1', '2020-01-29', 'ADMINISTRACION ', null);
INSERT INTO `clientemaquina` VALUES ('78829890', 'EXBR1443', '1', '1', '2020-01-29', 'maquina externa', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1441', '1', '1', '2020-01-31', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1260', '2', '1', '2020-01-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1846', '1', '0', '2020-01-31', 'PERSONAL ', '0');
INSERT INTO `clientemaquina` VALUES ('99580830', 'EXBR1442', '1', '1', '2020-01-31', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1491', '3', '1', '2020-01-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2044', '2', '0', '2020-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'CIEH27703', '1', '1', '2020-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP1883', '4', '0', '2020-02-05', 'SECPLAC SECRETARIA', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO2005', '1', '1', '2020-02-05', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1444', '1', '0', '2020-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1445', '1', '0', '2020-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1446', '1', '0', '2020-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('92805000', 'EXBR1444', '1', '1', '2020-02-05', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1445', '1', '1', '2020-02-05', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76129826', 'EXBR1446', '1', '1', '2020-02-06', 'maquina externa', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1447', '1', '0', '2020-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1448', '1', '0', '2020-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77515180', 'EXBR1447', '1', '1', '2020-02-10', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1449', '1', '0', '2020-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1450', '1', '0', '2020-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76031066', 'EXKY1449', '1', '1', '2020-02-11', 'VENTA  STARTER MOTORS', null);
INSERT INTO `clientemaquina` VALUES ('76371830', 'EXBR1450', '1', '1', '2020-02-11', 'MAQUINA EXTERNA HOTEL', null);
INSERT INTO `clientemaquina` VALUES ('15019147', 'EXBR1448', '1', '1', '2020-02-11', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2122', '1', '0', '2020-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2123', '1', '0', '2020-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2124', '1', '0', '2020-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2125', '1', '0', '2020-02-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2123', '1', '0', '2020-02-17', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2124', '1', '0', '2020-02-17', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2125', '1', '0', '2020-02-17', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '5', '0', '2020-02-18', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1451', '1', '0', '2020-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1452', '1', '0', '2020-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1452', '1', '1', '2020-02-18', 'EXTERNA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1451', '1', '1', '2020-02-18', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1453', '1', '0', '2020-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1454', '1', '0', '2020-02-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76453379', 'EXBR1454', '1', '1', '2020-02-19', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXBR1453', '1', '1', '2020-02-19', 'maquina externa', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1955', '2', '0', '2020-02-24', 'BS-103-CRT002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2123', '2', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1838', '3', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1893', '2', '1', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1455', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1910', '2', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO1910', '1', '0', '2020-02-24', 'mejillones oficina', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1886', '2', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2126', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2127', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2128', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2129', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2130', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2131', '1', '0', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2129', '1', '1', '2020-02-24', 'D.O.M', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1481', '4', '1', '2020-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2127', '1', '1', '2020-02-24', 'TRANSITO', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'TO2122', '1', '1', '2020-02-25', 'CENTRO COPIADO ', null);
INSERT INTO `clientemaquina` VALUES ('76004534', 'EXBR1455', '1', '1', '2020-02-25', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2079', '2', '0', '2020-02-25', 'BS-105MEL002BA01 INTEGRAL  MINA', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1538', '3', '0', '2020-02-25', 'BS-105-MEL002BA03', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2104', '3', '0', '2020-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2126', '1', '1', '2020-02-25', 'CONTROL', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2128', '1', '1', '2020-02-25', 'PLANIFICACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1735', '4', '0', '2020-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2130', '1', '1', '2020-02-25', 'FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2131', '1', '1', '2020-02-25', 'OFICINAS 2do. PISO ', null);
INSERT INTO `clientemaquina` VALUES ('71102600', 'EXKY1424', '1', '1', '2020-02-28', 'CENTRO COPIADO ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1969', '2', '1', '2020-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2132', '1', '0', '2020-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2132', '1', '0', '2020-02-28', 'BS-103-CRT002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1955', '3', '1', '2020-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1849', '3', '1', '2020-03-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76196877', 'TO1735', '1', '0', '2020-03-02', 'TECHCOM ANTOFAGASTA ', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1868', '1', '1', '2020-03-03', 'DIRECCIÃ“N  ACADÃ‰MICA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1456', '1', '0', '2020-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5488051', 'EXBR1456', '1', '1', '2020-03-03', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1457', '1', '0', '2020-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65077905', 'EP2099', '1', '1', '2020-03-03', 'FUNDACION ATACAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2133', '1', '0', '2020-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77490350', 'KY2133', '1', '1', '2020-03-03', 'MINERA GABRIELA MISTRAL CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1842', '2', '0', '2020-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1841', '1', '0', '2020-03-03', 'LEM COPIAPO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1838', '3', '0', '2020-03-03', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1469', '2', '1', '2020-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'BR1540', '1', '0', '2020-03-03', 'CANAL 95 TV', '0');
INSERT INTO `clientemaquina` VALUES ('13043560', 'EXBR1457', '1', '1', '2020-03-05', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '6', '0', '2020-03-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1817', '2', '0', '2020-03-05', 'BS103MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1886', '2', '1', '2020-03-06', 'EGIS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1918', '2', '1', '2020-03-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76060841', 'TO1992', '1', '0', '2020-03-09', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1513', '3', '1', '2020-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5735196', 'TO2104', '1', '1', '2020-03-11', 'NOTARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1843', '4', '0', '2020-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1458', '1', '0', '2020-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1459', '1', '0', '2020-03-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('25267423', 'EXBR1459', '1', '1', '2020-03-13', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76000158', 'EXBR1458', '1', '1', '2020-03-13', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2134', '1', '0', '2020-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2134', '1', '0', '2020-03-13', 'BS-105-MEL002BA03', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2004', '2', '0', '2020-03-13', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '3', '0', '2020-03-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2135', '1', '0', '2020-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1460', '1', '0', '2020-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1461', '1', '0', '2020-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1462', '1', '0', '2020-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15017086', 'EXBR1460', '1', '1', '2020-03-17', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('65803400', 'EP2100', '1', '1', '2020-03-17', 'orica chile antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1462', '1', '1', '2020-03-17', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76060289', 'EXBR1461', '1', '1', '2020-03-17', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2135', '1', '1', '2020-03-17', 'DAEM TESORERIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1463', '1', '0', '2020-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1464', '1', '0', '2020-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1465', '1', '0', '2020-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1950', '2', '0', '2020-03-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1463', '1', '1', '2020-03-20', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1466', '1', '0', '2020-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1467', '1', '0', '2020-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1468', '1', '0', '2020-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76946077', 'EXEP1466', '1', '1', '2020-03-25', 'CENTRAL COPIADO( INACAP )', null);
INSERT INTO `clientemaquina` VALUES ('20213167', 'EXBR1465', '1', '1', '2020-03-25', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76946077', 'EXKY1468', '1', '1', '2020-03-25', 'CENTRO COPIADO(INACAP)', null);
INSERT INTO `clientemaquina` VALUES ('76946077', 'EXKY1467', '1', '1', '2020-03-25', 'CENTRO COPIADO(INACAP)', null);
INSERT INTO `clientemaquina` VALUES ('99536660', 'EXBR1464', '1', '1', '2020-03-25', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2036', '3', '0', '2020-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1469', '1', '0', '2020-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1470', '1', '0', '2020-04-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXTO1469', '1', '0', '2020-04-02', 'SAN PEDRO ATACAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '3', '0', '2020-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2079', '3', '1', '2020-04-02', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXTO1470', '1', '1', '2020-04-02', 'SAN PEDRO DE ATACAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1471', '1', '0', '2020-04-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1670', '3', '1', '2020-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1842', '1', '0', '2020-04-03', 'ADQUICISIONES', '0');
INSERT INTO `clientemaquina` VALUES ('12442343', 'EXBR1471', '1', '1', '2020-04-03', 'GARATIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1472', '1', '0', '2020-04-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'EXBR1472', '1', '1', '2020-04-03', 'OFICINA ZONGE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1999', '2', '0', '2020-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1214', '2', '1', '2020-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '3', '0', '2020-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1473', '1', '0', '2020-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18315170', 'EXBR1473', '1', '1', '2020-04-13', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1600', '2', '1', '2020-04-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR1986', '1', '0', '2020-04-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1474', '1', '0', '2020-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77189740', 'EXBR1474', '1', '1', '2020-04-16', 'garantia brother ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1527', '3', '1', '2020-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1810', '3', '1', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2148', '1', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO2148', '1', '0', '2020-04-20', 'SAN PATRICIO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '4', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2141', '1', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2142', '1', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2143', '1', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2144', '1', '0', '2020-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1930', '2', '0', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2142', '1', '1', '2020-04-22', 'SECRETARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1934', '2', '1', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2141', '1', '1', '2020-04-22', 'ALCALDIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1938', '2', '0', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2144', '1', '1', '2020-04-22', 'SENDA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1935', '2', '0', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2143', '1', '1', '2020-04-22', 'RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1861', '3', '0', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1940', '2', '0', '2020-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1936', '2', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2140', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2136', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2137', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2140', '1', '1', '2020-04-23', 'DIDECO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1855', '4', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2136', '1', '1', '2020-04-23', 'FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2139', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2149', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2150', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2137', '1', '1', '2020-04-23', 'TESORERIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2138', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2150', '1', '1', '2020-04-23', 'ASEO Y ORNATO ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1931', '2', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2138', '1', '1', '2020-04-23', 'J. POLICIA LOCAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1928', '2', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2149', '1', '1', '2020-04-23', 'TRANSITO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1939', '2', '1', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2139', '1', '1', '2020-04-23', 'D.O.M', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1475', '1', '0', '2020-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81242500', 'EXBR1475', '1', '1', '2020-04-23', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1066', '2', '1', '2020-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1724', '2', '0', '2020-04-29', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1213', '1', '0', '2020-04-30', 'relaciones publicas ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2009', '2', '0', '2020-04-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1968', '2', '0', '2020-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1971', '2', '0', '2020-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1986', '2', '0', '2020-05-05', 'BS-105-CGM001BA01 GABY 2', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1957', '2', '0', '2020-05-05', 'BS-103-CES0021N01 SALVADOR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '3', '0', '2020-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2086', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1937', '2', '1', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2157', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2160', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2157', '1', '1', '2020-05-18', 'OPD', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1933', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2160', '1', '1', '2020-05-18', 'CASA DE LA CULTURA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1889', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2153', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2154', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2155', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2156', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2158', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2147', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2153', '1', '1', '2020-05-18', 'BODEGA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1878', '3', '1', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2151', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2151', '1', '1', '2020-05-18', 'ALCALDIA', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2155', '1', '1', '2020-05-18', 'SECRETARIA MUNICIPAL', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'EP2044', '1', '1', '2020-05-18', 'OFICINA PISO NO. 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1998', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1888', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2158', '1', '1', '2020-05-18', 'JUZGADO POLICÃA LOCAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1891', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2154', '1', '1', '2020-05-18', 'SOCIAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1754', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2147', '1', '1', '2020-05-18', 'DAEM', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1887', '2', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2163', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2164', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1478', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1477', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1476', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1479', '1', '0', '2020-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2165', '1', '0', '2020-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2166', '1', '0', '2020-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2167', '1', '0', '2020-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2168', '1', '0', '2020-05-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('70954900', 'EXEP1476', '1', '1', '2020-05-25', 'DIRECCION', null);
INSERT INTO `clientemaquina` VALUES ('70954900', 'EXEP1477', '1', '1', '2020-05-25', 'EDUCACION', null);
INSERT INTO `clientemaquina` VALUES ('70954900', 'EXTO1478', '1', '1', '2020-05-25', 'APOYO TECNICO', null);
INSERT INTO `clientemaquina` VALUES ('76928183', 'EXTO1479', '1', '1', '2020-05-25', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2162', '1', '0', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1538', '5', '1', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO2162', '1', '1', '2020-05-25', 'POLITECNICO BIBLIOTECA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2161', '1', '0', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'TO2161', '1', '1', '2020-05-25', 'POLITECNICO DIRECTOR', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2164', '1', '1', '2020-05-25', 'POLITECNICO SECRE. DIRECTOR', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2163', '1', '0', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2163', '1', '1', '2020-05-25', 'OFICINA ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1480', '1', '0', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1481', '1', '1', '2020-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77189740', 'EXBR1480', '1', '1', '2020-05-25', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2056', '2', '0', '2020-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1994', '2', '0', '2020-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1953', '2', '0', '2020-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1482', '1', '0', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1483', '1', '0', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1484', '1', '0', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1482', '2', '1', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXEP1484', '1', '1', '2020-05-28', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76129826', 'EXBR1483', '1', '1', '2020-05-28', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1890', '3', '1', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2166', '1', '1', '2020-05-28', 'DIDECO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1892', '2', '0', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2168', '1', '1', '2020-05-28', 'ALBERGUE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1915', '2', '1', '2020-05-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16524375', 'BR1891', '1', '1', '2020-05-28', 'NOTARIA', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2098', '1', '1', '2020-06-01', 'RECURSOS HUMANOS', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '4', '0', '2020-06-01', 'Mel 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1485', '1', '0', '2020-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76031066', 'EXBR1485', '1', '1', '2020-06-02', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1852', '3', '0', '2020-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511021', 'KY2165', '1', '1', '2020-06-02', 'SECRETARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1696', '2', '1', '2020-06-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1971', '2', '0', '2020-06-02', 'bs-105-mel002ba01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1484', '4', '1', '2020-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1888', '1', '0', '2020-06-03', 'CALAMA PUERTO SECO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1770', '4', '0', '2020-06-04', 'BS-103MEL001BA01 COLOSO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '9', '0', '2020-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1486', '1', '1', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1487', '1', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1488', '1', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1489', '1', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1490', '1', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1491', '1', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1773', '2', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1776', '2', '0', '2020-06-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('14056874', 'EXBR1487', '1', '1', '2020-06-05', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76110235', 'EXBR1491', '1', '1', '2020-06-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('11728712', 'EXBR1488', '1', '1', '2020-06-09', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1784', '2', '0', '2020-06-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO2041', '1', '1', '2020-06-09', 'CC2040 GABY', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2169', '1', '0', '2020-06-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1838', '4', '0', '2020-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1496', '3', '0', '2020-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR2169', '1', '1', '2020-06-10', 'SECRETARIA', null);
INSERT INTO `clientemaquina` VALUES ('13724673', 'EXBR1489', '1', '1', '2020-06-10', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13724673', 'EXBR1490', '1', '1', '2020-06-10', 'MAQUNA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1492', '1', '0', '2020-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2003', '2', '0', '2020-06-11', 'MEL 2', '0');
INSERT INTO `clientemaquina` VALUES ('12696840', 'EXBR1492', '1', '1', '2020-06-11', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1686', '4', '0', '2020-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1990', '2', '0', '2020-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1998', '2', '0', '2020-06-15', 'MEL COLOSO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1493', '1', '0', '2020-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1494', '1', '0', '2020-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1495', '1', '0', '2020-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1496', '1', '0', '2020-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77044498', 'EXBR1493', '1', '1', '2020-06-16', 'maquina eterna', null);
INSERT INTO `clientemaquina` VALUES ('76544188', 'EXBR1494', '1', '1', '2020-06-16', 'MAQUNA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1497', '1', '0', '2020-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6569463', 'EXBR1497', '1', '1', '2020-06-17', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('23811657', 'EXBR1495', '1', '1', '2020-06-17', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76525290', 'EXBR1496', '1', '1', '2020-06-17', 'MAQUNA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76446262', 'KY2068', '1', '1', '2020-06-17', 'OFICINA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'to1618', '5', '1', '2020-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1499', '1', '0', '2020-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1498', '1', '0', '2020-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17937221', 'EXBR1498', '1', '1', '2020-06-18', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76451669', 'EXBR1499', '1', '1', '2020-06-19', 'maquina externa ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1500', '1', '0', '2020-06-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2170', '1', '0', '2020-06-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1765', '5', '0', '2020-06-23', 'MEL 1', '0');
INSERT INTO `clientemaquina` VALUES ('76092002', 'EXBR1500', '1', '1', '2020-07-07', 'CENTRAL DE APUNTES ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1775', '2', '1', '2020-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78991830', 'TO2170', '1', '1', '2020-07-07', 'LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1501', '1', '0', '2020-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8994065', 'EXBR1501', '1', '1', '2020-07-07', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2042', '2', '0', '2020-07-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2009', '1', '0', '2020-07-08', 'SALUD BAQUEDANO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1502', '1', '1', '2020-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1503', '1', '0', '2020-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1504', '1', '0', '2020-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1505', '1', '0', '2020-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('93077000', 'EXBR1505', '1', '1', '2020-07-15', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1506', '1', '0', '2020-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1507', '1', '0', '2020-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1508', '1', '0', '2020-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2171', '1', '0', '2020-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('14264113', 'EXBR1506', '1', '1', '2020-07-15', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2171', '1', '1', '2020-07-15', 'BS-103-MEL001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76640732', 'EXBR1503', '1', '1', '2020-07-20', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('21463496', 'EXBR1504', '1', '1', '2020-07-20', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('18506493', 'EXBR1508', '1', '1', '2020-07-20', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('9267076', 'EXBR1507', '1', '1', '2020-07-20', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1971', '3', '0', '2020-07-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1843', '1', '0', '2020-07-22', 'BS-103-CRT002BA01CHANCADA SECUNDARIO', '0');
INSERT INTO `clientemaquina` VALUES ('11203242', 'EP2038', '1', '0', '2020-07-22', 'BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1509', '1', '0', '2020-07-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76419232', 'EP2042', '1', '0', '2020-07-22', 'RECEPCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '7', '0', '2020-07-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1509', '2', '1', '2020-07-23', 'CLIENTE MAX SERVICE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '5', '0', '2020-07-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '5', '0', '2020-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2038', '3', '0', '2020-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2058', '2', '0', '2020-07-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11203242', 'EP2058', '1', '0', '2020-07-24', 'BAQUEDANO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1970', '3', '0', '2020-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1510', '1', '0', '2020-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76533368', 'EXBR1510', '1', '1', '2020-07-29', 'externa', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2118', '2', '0', '2020-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1511', '1', '0', '2020-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1512', '1', '0', '2020-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1513', '1', '0', '2020-07-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13645277', 'EXBR1512', '1', '1', '2020-07-31', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1992', '3', '0', '2020-07-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'TO1997', '1', '0', '2020-08-03', 'NOTARIA', '0');
INSERT INTO `clientemaquina` VALUES ('7000961', 'KY2156', '1', '1', '2020-08-03', 'NOTARIA', null);
INSERT INTO `clientemaquina` VALUES ('16437046', 'EXBR1513', '1', '1', '2020-08-04', 'garantia brother ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2172', '1', '0', '2020-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2173', '1', '0', '2020-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EP2172', '1', '0', '2020-08-04', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('776803790', 'KY2167', '1', '0', '2020-08-04', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2173', '1', '0', '2020-08-06', 'MEJILLONES OF.CALIDAD', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1514', '1', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1515', '1', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1516', '1', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1517', '1', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65095729', 'EXBR1514', '1', '1', '2020-08-06', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1995', '2', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2017', '2', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78442280', 'EP2056', '1', '0', '2020-08-06', 'OFICINA MEJILLONES ', '0');
INSERT INTO `clientemaquina` VALUES ('76883840', 'EXBR1515', '1', '1', '2020-08-06', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'SI1899', '2', '1', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76063288', 'EXBR1511', '1', '1', '2020-08-06', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1872', '3', '1', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR1938', '1', '0', '2020-08-06', 'BODEGA /GALPON', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2174', '1', '0', '2020-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2055', '2', '0', '2020-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2174', '1', '0', '2020-08-10', 'CHUQUICAMATA', '0');
INSERT INTO `clientemaquina` VALUES ('96846410', 'BR1753', '1', '0', '2020-08-10', 'SF-201-CGM EXTRACCION DE AGUA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1518', '1', '0', '2020-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5488051', 'EXEP1518', '1', '1', '2020-08-10', 'OFICINA ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1770', '5', '0', '2020-08-10', 'ZALDIVAR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY12175', '1', '0', '2020-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76634430', 'KY12175', '1', '1', '2020-08-11', 'OPERACIONES ', null);
INSERT INTO `clientemaquina` VALUES ('76367270', 'EP2086', '1', '1', '2020-08-11', 'OFICINA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('10510610', 'EXBR1516', '1', '1', '2020-08-12', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1859', '2', '0', '2020-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('19520859', 'EXBR1517', '1', '1', '2020-08-13', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2175', '1', '1', '2020-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2176', '1', '0', '2020-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1518', '1', '0', '2020-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'KY2176', '1', '0', '2020-08-13', 'FAMAE', '0');
INSERT INTO `clientemaquina` VALUES ('13012713', 'EXBR1518', '1', '1', '2020-08-13', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'BR1859', '2', '0', '2020-08-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2176', '2', '0', '2020-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1519', '1', '0', '2020-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('25663372', 'EXBR1519', '1', '1', '2020-08-19', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'RI1457', '4', '1', '2020-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1460', '6', '1', '2020-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1743', '4', '1', '2020-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1668', '3', '1', '2020-08-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1999', '2', '0', '2020-08-20', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('61964800', 'KY2031', '1', '1', '2020-08-20', 'COMANDANCIA', null);
INSERT INTO `clientemaquina` VALUES ('61964800', 'BR1931', '1', '1', '2020-08-20', 'BATALLON LOGISTICO', null);
INSERT INTO `clientemaquina` VALUES ('61964800', 'BR1889', '1', '1', '2020-08-20', 'BATALLON DE TELECOMUNICACIONES', null);
INSERT INTO `clientemaquina` VALUES ('76963244', 'EP2036', '1', '1', '2020-08-21', 'ORMAT CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1990', '2', '0', '2020-08-21', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1971', '3', '0', '2020-08-24', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2177', '1', '0', '2020-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2178', '1', '0', '2020-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2058', '3', '0', '2020-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11203242', 'EP1960', '2', '0', '2020-08-25', 'SIERRA GORDA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'U65053G9H6', '1', '1', '2020-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1521', '1', '0', '2020-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1522', '1', '0', '2020-08-25', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1523', '1', '0', '2020-08-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76129826', 'EXBR1521', '1', '1', '2020-08-25', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('14109702', 'EXBR1523', '1', '1', '2020-08-26', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2178', '1', '0', '2020-08-26', 'MMH-49004/BS-103-CMH001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2177', '1', '1', '2020-08-26', 'BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1524', '1', '0', '2020-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1524', '1', '1', '2020-08-26', 'POLYTEX LA NEGRA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2013', '2', '0', '2020-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1975', '2', '1', '2020-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1526', '1', '0', '2020-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1525', '1', '0', '2020-08-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1876', '1', '0', '2020-08-31', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13936454', 'EXBR1525', '1', '1', '2020-08-31', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('23433805', 'EXBR1526', '1', '1', '2020-09-01', 'garantia brother', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2179', '1', '0', '2020-09-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1971', '4', '0', '2020-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2004', '3', '0', '2020-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '5', '0', '2020-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2179', '1', '1', '2020-09-03', 'MMH-49004 BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2116', '2', '0', '2020-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1971', '4', '0', '2020-09-04', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO1995', '1', '0', '2020-09-04', 'COMISIONAMIENTO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1974', '2', '0', '2020-09-04', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1527', '1', '0', '2020-09-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76489622', 'EXBR1527', '1', '1', '2020-09-07', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'BR2013', '1', '0', '2020-09-07', 'SF-201-CGM EXTRACCION DE AGUA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1539', '9', '1', '2020-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1528', '1', '0', '2020-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12365746', 'EXBR1528', '1', '1', '2020-09-09', 'CONSULTORIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1529', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1530', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1531', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1532', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1533', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1534', '1', '0', '2020-09-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12007740', 'EXBR1532', '1', '1', '2020-09-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76130512', 'EXEP1531', '1', '1', '2020-09-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76489622', 'EXBR1529', '1', '1', '2020-09-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13904361', 'EXBR1533', '1', '1', '2020-09-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1535', '1', '0', '2020-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1753', '9', '1', '2020-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76130512', 'EXBR1530', '1', '1', '2020-09-14', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'EXBR1535', '1', '1', '2020-09-14', 'MAQUNA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('65082792', 'EXBR1534', '1', '1', '2020-09-15', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1536', '1', '0', '2020-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5455609', 'EXBR1536', '1', '1', '2020-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2058', '2', '0', '2020-09-22', 'CENTRO COPIADO', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO1970', '1', '0', '2020-09-22', 'PISO NO. 1', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1978', '2', '1', '2020-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1796', '4', '0', '2020-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1537', '1', '0', '2020-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1538', '1', '0', '2020-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1539', '1', '0', '2020-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10208628', 'EXBR1537', '1', '1', '2020-09-28', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('15812030', 'EXBR1538', '1', '1', '2020-09-28', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13219503', 'EXBR1539', '1', '1', '2020-09-28', 'MAQUNA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1257', '2', '1', '2020-09-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1686', '1', '1', '2020-09-30', 'DOM ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2180', '1', '0', '2020-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'KY2180', '1', '1', '2020-10-01', 'CC2000 Calama', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2125', '2', '1', '2020-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2017', '1', '0', '2020-10-01', 'PRECONDICIONAMIENTO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1540', '1', '0', '2020-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1541', '1', '0', '2020-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1542', '1', '0', '2020-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15690698', 'EXBR1540', '1', '1', '2020-10-05', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1543', '1', '0', '2020-10-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17131717', 'EXBR1542', '1', '1', '2020-10-06', 'garantia brother ', null);
INSERT INTO `clientemaquina` VALUES ('15572815', 'EXBR1543', '1', '1', '2020-10-06', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76808039', 'EXBR1541', '1', '1', '2020-10-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1544', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1545', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1546', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1547', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1548', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1549', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1550', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76455577', 'EXBR1544', '1', '1', '2020-10-07', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2181', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2182', '1', '0', '2020-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1911', '4', '0', '2020-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('59164480', 'EP1911', '1', '0', '2020-10-08', 'FAENA MARIA ELENA ', '0');
INSERT INTO `clientemaquina` VALUES ('59164480', 'EP1950', '1', '1', '2020-10-08', 'PROYECTOS S.A MARIA ELENA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2181', '1', '0', '2020-10-08', 'BS-105-MEL002BA01 INTEGRAL MINA', '0');
INSERT INTO `clientemaquina` VALUES ('13218020', 'EXBR1546', '1', '1', '2020-10-08', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR2003', '1', '0', '2020-10-13', 'TRANSITO ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '6', '0', '2020-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2182', '1', '1', '2020-10-13', 'TRANSITO', null);
INSERT INTO `clientemaquina` VALUES ('8500843', 'EXBR1545', '1', '1', '2020-10-14', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2183', '1', '0', '2020-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2183', '1', '1', '2020-10-14', 'OFICINA LA NEGRA SITIO NO.1', null);
INSERT INTO `clientemaquina` VALUES ('12395016', 'EXBR1547', '1', '1', '2020-10-14', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('89003900', 'EXBR1548', '1', '1', '2020-10-14', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1551', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1552', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1553', '1', '1', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1554', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1555', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1556', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2185', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2184', '1', '0', '2020-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76883840', 'EXBR1550', '1', '1', '2020-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78403190', 'EXBR1551', '1', '1', '2020-10-16', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO1953', '1', '0', '2020-10-16', 'MEJILLONES', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1860', '3', '0', '2020-10-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'BR1935', '1', '1', '2020-10-16', 'FOMENTO PRODUCTIVO', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1860', '1', '0', '2020-10-16', 'MATRICULA NO.1', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1852', '1', '0', '2020-10-16', 'MATRICULA NO. 2', '0');
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1932', '1', '0', '2020-10-16', 'MATRICULA NO. 3', '0');
INSERT INTO `clientemaquina` VALUES ('76883840', 'EXBR1549', '1', '1', '2020-10-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1759', '7', '0', '2020-10-20', 'MEL1', '0');
INSERT INTO `clientemaquina` VALUES ('7286614', 'EXBR1552', '1', '1', '2020-10-20', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('12840126', 'EXBR1556', '1', '1', '2020-10-20', 'GARANTIA BROTHER ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1557', '1', '0', '2020-10-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1557', '1', '1', '2020-10-21', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1558', '1', '0', '2020-10-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1559', '1', '0', '2020-10-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1560', '1', '0', '2020-10-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76084889', 'EXBR1555', '1', '1', '2020-10-21', 'mÃ¡quina externa', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2184', '1', '1', '2020-10-21', 'DAEM FINANZAS', null);
INSERT INTO `clientemaquina` VALUES ('8099175', 'EXBR1554', '1', '1', '2020-10-21', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('11931976', 'EXBR1559', '1', '1', '2020-10-21', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('16304878', 'EXBR1558', '1', '1', '2020-10-21', 'GARANTÃA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2055', '1', '0', '2020-10-22', 'LOMAS BAYAS', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1561', '1', '0', '2020-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1562', '1', '0', '2020-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1563', '1', '0', '2020-10-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18232521', 'EXBR1561', '1', '1', '2020-10-23', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76110235', 'EXBR1560', '1', '1', '2020-10-23', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('7002470', 'EXBR1563', '1', '1', '2020-10-23', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1564', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1565', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1564', '1', '1', '2020-10-26', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2186', '1', '1', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2187', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2188', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2189', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2190', '1', '0', '2020-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1817', '7', '1', '2020-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77461750', 'EXBR1562', '1', '1', '2020-10-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2116', '2', '1', '2020-10-28', 'BS-103-CRT002BA01', null);
INSERT INTO `clientemaquina` VALUES ('59164480', 'TO2118', '1', '1', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1415', '2', '1', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2132', '2', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12614744', 'EXBR1565', '1', '1', '2020-10-28', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1887', '1', '0', '2020-10-28', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1566', '1', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76173235', 'EXBR1566', '1', '1', '2020-10-28', 'MAQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2002', '2', '1', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2191', '1', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81148200', 'EP2191', '1', '0', '2020-10-28', 'GOF', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1999', '3', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1567', '1', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1990', '3', '0', '2020-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('14113771', 'EXBR1567', '1', '1', '2020-10-28', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1968', '1', '0', '2020-10-30', 'BS-103-CRT002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1870', '4', '1', '2020-10-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2188', '1', '0', '2020-10-30', 'MERCOSUR', '0');
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2190', '1', '0', '2020-10-30', 'ROMANA3', '0');
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2189', '1', '0', '2020-10-30', 'CSJ TALLER MANTENCION', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2066', '2', '0', '2020-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2066', '2', '0', '2020-11-02', 'CALAMA AV.CHORRILLOS 1677 OFICINA 308 ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1568', '1', '0', '2020-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1569', '1', '0', '2020-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1570', '1', '0', '2020-11-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96591730', 'EXBR1568', '1', '1', '2020-11-02', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1571', '1', '0', '2020-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76883840', 'EXBR1570', '1', '1', '2020-11-03', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('8170299', 'EXEP1571', '1', '1', '2020-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76883840', 'EXBR1569', '1', '1', '2020-11-03', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('77881200', 'EP2038', '1', '0', '2020-11-03', 'OFICINA, PROPIPE', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1572', '1', '0', '2020-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1573', '1', '0', '2020-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '5', '0', '2020-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2004', '3', '0', '2020-11-04', 'BS-105-CGM001BA01 GABY 2', '0');
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2187', '1', '1', '2020-11-05', 'DAEM OF DE PARTES ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1991', '2', '0', '2020-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1522', '2', '0', '2020-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1520', '1', '0', '2020-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'EXBR1522', '1', '1', '2020-11-05', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'EXBR1520', '1', '1', '2020-11-05', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('17938220', 'EXBR1572', '1', '1', '2020-11-05', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1961', '3', '1', '2020-11-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1997', '3', '0', '2020-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7000961', 'KY2176', '1', '1', '2020-11-09', 'NOTARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1574', '1', '0', '2020-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1575', '1', '0', '2020-11-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12443036', 'EXBR1574', '1', '1', '2020-11-09', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('16559206', 'EXBR1575', '1', '1', '2020-11-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2185', '1', '0', '2020-11-09', 'ADMINISTRACIÃ“N', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2194', '1', '0', '2020-11-11', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2194', '2', '0', '2020-11-11', 'GERENCIA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '4', '0', '2020-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1986', '3', '0', '2020-11-12', 'BS-103-CES0021N01 SALVADOR', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1576', '1', '0', '2020-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2195', '1', '0', '2020-11-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('19951168', 'EXBR1576', '1', '1', '2020-11-12', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2195', '1', '0', '2020-11-12', 'BS-101-CMZ001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1962', '2', '0', '2020-11-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2192', '1', '0', '2020-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1577', '1', '0', '2020-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1578', '1', '0', '2020-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2193', '1', '0', '2020-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'KY2193', '1', '0', '2020-11-17', 'NOTARIA DE MARIA ELENA', '0');
INSERT INTO `clientemaquina` VALUES ('76095896', 'KY2192', '1', '0', '2020-11-17', 'BARTHEN OFICINA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1995', '3', '1', '2020-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO2123', '2', '0', '2020-11-17', 'CARPETAS TOP', '0');
INSERT INTO `clientemaquina` VALUES ('76156521', 'TO1994', '1', '1', '2020-11-17', 'COBRA MEJILLONES', null);
INSERT INTO `clientemaquina` VALUES ('13011591', 'EXBR1573', '1', '1', '2020-11-18', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1929', '4', '0', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1855', '1', '1', '2020-11-18', 'ADQUISICIONES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1579', '1', '0', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'EXBR1577', '1', '1', '2020-11-18', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1580', '1', '0', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1581', '1', '0', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76371830', 'EXBR1581', '1', '1', '2020-11-18', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1770', '6', '1', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1724', '4', '1', '2020-11-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16436831', 'EXBR1579', '1', '1', '2020-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('26408240', 'EXBR1578', '1', '1', '2020-11-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1582', '1', '0', '2020-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1583', '1', '0', '2020-11-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6125115', 'EXBR1582', '1', '1', '2020-11-24', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1583', '1', '1', '2020-11-24', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('78110220', 'EXBR1580', '1', '1', '2020-11-24', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1584', '1', '0', '2020-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1585', '1', '0', '2020-11-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76930140', 'EXBR1584', '1', '1', '2020-11-25', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('15794537', 'EXBR1585', '1', '1', '2020-11-25', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1586', '1', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1587', '1', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2192', '2', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77220207', 'KY2192', '1', '0', '2020-11-26', 'Antofagasta', '0');
INSERT INTO `clientemaquina` VALUES ('69253600', 'F2J218535', '1', '0', '2020-11-26', 'NotarÃ­a 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2194', '3', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2194', '1', '0', '2020-11-26', 'ROMANA 2', '0');
INSERT INTO `clientemaquina` VALUES ('70574900', 'EXBR1586', '1', '1', '2020-11-26', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('18233358', 'EXBR1587', '1', '1', '2020-11-26', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1588', '1', '1', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1589', '1', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'F2J218535', '2', '0', '2020-11-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'F2J218535', '1', '1', '2020-11-26', 'Notaria 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1590', '1', '0', '2020-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2196', '1', '0', '2020-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1383', '1', '0', '2020-12-01', 'TesorerÃ­a', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2185', '2', '0', '2020-12-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'EP2185', '1', '1', '2020-12-01', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1659', '3', '1', '2020-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1811', '1', '1', '2020-12-03', 'ADQUISICIONES', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1940', '1', '0', '2020-12-03', 'MATRÃCULA # 1', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1933', '1', '0', '2020-12-03', 'MATRÃCULA # 2', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1929', '1', '0', '2020-12-03', 'MATRÃCULA #3', '0');
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1589', '1', '1', '2020-12-03', 'MÃQUINA EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1932', '4', '1', '2020-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1861', '1', '0', '2020-12-03', 'matrÃ­cula #2', '0');
INSERT INTO `clientemaquina` VALUES ('76110235', 'EXBR1590', '1', '1', '2020-12-04', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '5', '0', '2020-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2196', '1', '0', '2020-12-04', 'TesorerÃ­a', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1591', '1', '0', '2020-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1592', '1', '0', '2020-12-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1784', '2', '1', '2020-12-07', 'CC2060 GABY', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2105', '2', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2191', '2', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2078', '2', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1867', '3', '1', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2178', '2', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1593', '1', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96789280', 'EXBR1593', '1', '0', '2020-12-07', 'Mejillones', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1594', '1', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1595', '1', '0', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96789280', 'EXBR1594', '1', '1', '2020-12-07', 'EXTERNA TGN/BECHEL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1593', '2', '1', '2020-12-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76808039', 'EXBR1592', '1', '1', '2020-12-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2196', '2', '0', '2020-12-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1822', '1', '0', '2020-12-09', 'TesorerÃ­a', '0');
INSERT INTO `clientemaquina` VALUES ('76525290', 'EXBR1591', '1', '1', '2020-12-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1596', '1', '0', '2020-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1597', '1', '1', '2020-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1598', '1', '0', '2020-12-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2198', '1', '0', '2020-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2197', '1', '0', '2020-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1595', '1', '1', '2020-12-14', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1957', '1', '0', '2020-12-14', 'ADMINISTRACIÃ“N', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1929', '5', '0', '2020-12-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1892', '1', '0', '2020-12-14', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1684', '2', '1', '2020-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1930', '1', '0', '2020-12-15', 'SECRETARIA RECTORÃA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1599', '1', '0', '2020-12-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1930', '3', '0', '2020-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1936', '1', '1', '2020-12-16', 'SECRETARIA RECTORIA ', null);
INSERT INTO `clientemaquina` VALUES ('24115129', 'EXBR1599', '1', '1', '2020-12-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1788', '2', '1', '2020-12-16', 'BS-105-MEL002BA01', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1726', '2', '0', '2020-12-16', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1411', '1', '0', '2020-12-16', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2198', '1', '0', '2020-12-16', 'matricula', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1383', '2', '0', '2020-12-16', 'matricula', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2196', '2', '0', '2020-12-16', 'matricula', '0');
INSERT INTO `clientemaquina` VALUES ('16489530', 'EXBR1596', '1', '1', '2020-12-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1773', '1', '0', '2020-12-16', 'piso 4', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1600', '1', '0', '2020-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76689118', 'BR1930', '1', '1', '2020-12-16', 'AFTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '4', '0', '2020-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6613476', 'EXBR1600', '1', '1', '2020-12-17', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76190282', 'EXEP1598', '1', '1', '2020-12-18', 'CALAMA. VENTA DE PLOTTER', null);
INSERT INTO `clientemaquina` VALUES ('77976320', 'EP2105', '1', '0', '2020-12-21', 'Oficina la Negra', '0');
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO2197', '1', '1', '2020-12-21', 'CC2070 DMH TOSTACION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1601', '1', '0', '2020-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76613923', 'EXEP1601', '1', '1', '2020-12-22', 'MAQUINA EXTERNA VENTA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1838', '4', '1', '2020-12-22', 'BS-103-MEL001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2038', '4', '0', '2020-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1602', '1', '0', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1603', '1', '0', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1604', '1', '0', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1605', '1', '0', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1759', '10', '1', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1765', '10', '1', '2020-12-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65628810', 'EXBR1603', '1', '1', '2020-12-23', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1606', '1', '0', '2020-12-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65628810', 'EXBR1602', '1', '1', '2020-12-24', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76201107', 'EXKY1606', '1', '1', '2020-12-24', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1604', '1', '1', '2020-12-28', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1824', '7', '1', '2020-12-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2056', '3', '0', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2198', '2', '1', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2196', '3', '0', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1383', '6', '1', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1411', '4', '1', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1726', '3', '0', '2020-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76293328', 'EXBR1605', '1', '1', '2021-01-04', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2209', '1', '0', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2210', '1', '0', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2211', '1', '0', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2210', '1', '0', '2021-01-05', 'JUZGADO POLICIAL LOCAL', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2019', '2', '1', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2020', '2', '0', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2211', '1', '1', '2021-01-05', 'JUZGADO POLICIAL LOCAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2041', '3', '0', '2021-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2209', '1', '0', '2021-01-05', 'Dideco Baquedano', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1933', '3', '0', '2021-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1607', '1', '0', '2021-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1608', '1', '0', '2021-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2212', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2213', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2214', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2215', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2216', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2199', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2200', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2201', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2202', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2203', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2204', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2205', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2206', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2207', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2208', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2217', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2218', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2219', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2220', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2221', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2222', '1', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EP2212', '1', '0', '2021-01-08', 'LA NEGRA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1729', '2', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2022', '2', '1', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2216', '1', '1', '2021-01-08', 'SECPLA BAQUEDANO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2021', '2', '0', '2021-01-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2215', '1', '1', '2021-01-08', 'SECPLAC', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1607', '1', '1', '2021-01-08', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1496', '2', '1', '2021-01-08', 'BS-105-CGM001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'EP2132', '1', '0', '2021-01-08', 'PISO 5', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1822', '3', '0', '2021-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1892', '3', '0', '2021-01-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2029', '2', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1940', '3', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2190', '2', '1', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR1726', '1', '0', '2021-01-12', 'ROMANA 1', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2227', '1', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2223', '1', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2224', '1', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76525290', 'KY2227', '1', '1', '2021-01-12', 'MAQUINA EXTERNA. CALAMA.', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2011', '3', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2214', '1', '1', '2021-01-12', 'Dideco sierra gorda ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2217', '1', '1', '2021-01-12', 'Posta Sierra Gorda', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2025', '2', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2224', '1', '1', '2021-01-12', 'Bodega Farmacia', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2210', '2', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2213', '1', '1', '2021-01-12', 'Juzgado PolicÃ­a Local Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2045', '3', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2205', '1', '1', '2021-01-12', 'Secretaria Alcalde Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2046', '2', '0', '2021-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2206', '1', '1', '2021-01-12', 'DirecciÃ³n Finanzas Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1609', '1', '0', '2021-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76293328', 'EXBR1608', '1', '1', '2021-01-13', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2048', '2', '0', '2021-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2204', '1', '1', '2021-01-13', 'SECPLAC Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '9', '0', '2021-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2203', '1', '1', '2021-01-13', 'SECPLAC Oficina Jefe Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2030', '2', '0', '2021-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2223', '1', '1', '2021-01-13', 'DirecciÃ³n Finanzas Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1773', '3', '0', '2021-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1861', '4', '0', '2021-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1860', '4', '0', '2021-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1852', '4', '0', '2021-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1912', '3', '1', '2021-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2229', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2230', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2231', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2232', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2233', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2228', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2229', '1', '1', '2021-01-15', 'Finanzas Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2207', '1', '1', '2021-01-15', 'Transito', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2033', '2', '1', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2230', '1', '1', '2021-01-15', 'Finanzas Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1610', '1', '0', '2021-01-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76408707', 'EXBR1610', '1', '1', '2021-01-15', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2097', '2', '0', '2021-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2199', '1', '1', '2021-01-18', 'DirecciÃ³n de EducaciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2009', '3', '0', '2021-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2200', '1', '1', '2021-01-18', 'Departamento Salud Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2037', '2', '0', '2021-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2234', '1', '0', '2021-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2231', '1', '1', '2021-01-18', 'Oficina de Partes', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2232', '1', '1', '2021-01-19', 'Secpla Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2010', '2', '0', '2021-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2194', '4', '0', '2021-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR2196', '1', '0', '2021-01-19', 'ROMANA 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2235', '1', '0', '2021-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2235', '1', '1', '2021-01-19', 'centro copiado ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2236', '1', '0', '2021-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1968', '3', '0', '2021-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2046', '1', '1', '2021-01-20', 'BS-103-CRT002BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2024', '2', '0', '2021-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2221', '1', '1', '2021-01-20', 'Dideco Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2023', '2', '0', '2021-01-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2220', '1', '1', '2021-01-20', 'Oficina de partes Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2234', '1', '1', '2021-01-20', 'Posta Farmacia Baquedano.', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2003', '3', '0', '2021-01-21', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'HP2050', '2', '0', '2021-01-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2236', '1', '1', '2021-01-21', 'Secplac Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('76899720', 'EXBR1609', '1', '1', '2021-01-21', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1990', '3', '0', '2021-01-22', 'BS-205-CCH001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1254', '2', '1', '2021-01-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2045', '1', '1', '2021-01-22', 'DOM', null);
INSERT INTO `clientemaquina` VALUES ('76260393', 'EP2097', '1', '1', '2021-01-25', 'oficina, mÃ¡quina externo', null);
INSERT INTO `clientemaquina` VALUES ('76844941', 'EP2011', '1', '0', '2021-01-26', 'CHIER chuquicamata', '0');
INSERT INTO `clientemaquina` VALUES ('76844941', 'EP2041', '1', '0', '2021-01-26', 'CHIER chuquicamata', '0');
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2201', '1', '1', '2021-01-26', 'Medio Ambiente Baquedano.', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2018', '2', '0', '2021-01-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2218', '1', '1', '2021-01-26', 'Posta Rural Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2202', '1', '1', '2021-01-26', 'Finanzas Caja Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2039', '2', '0', '2021-01-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2208', '1', '1', '2021-01-26', 'Servicios Generales Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '5', '0', '2021-01-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2228', '1', '1', '2021-01-27', 'DOM Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '4', '0', '2021-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2009', '2', '1', '2021-01-28', 'Relaciones PÃºblicas', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2048', '1', '0', '2021-01-29', 'BS-205-CCH001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1974', '3', '1', '2021-02-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1999', '3', '0', '2021-02-02', 'BS-105-MEL002BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1611', '1', '0', '2021-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76063288', 'EP2037', '1', '0', '2021-02-03', 'ConstrucciÃ³n', '0');
INSERT INTO `clientemaquina` VALUES ('76063288', 'EP2035', '1', '0', '2021-02-03', 'Calidad, Medio Ambiente, PrevenciÃ³n.', '0');
INSERT INTO `clientemaquina` VALUES ('17434697', 'EXBR1611', '1', '1', '2021-02-03', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR1822', '1', '0', '2021-02-03', 'SITIO 2', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2237', '1', '0', '2021-02-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2188', '2', '0', '2021-02-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76214934', 'KY2237', '1', '1', '2021-02-04', 'FE-000-STD001TA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1953', '3', '0', '2021-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1970', '4', '0', '2021-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2124', '2', '0', '2021-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1998', '3', '0', '2021-02-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1612', '1', '0', '2021-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76722755', 'EXEP1612', '1', '1', '2021-02-09', 'MÃ¡quina Externa CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2032', '2', '0', '2021-02-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1613', '1', '0', '2021-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1614', '1', '0', '2021-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76356183', 'EXEP1614', '1', '1', '2021-02-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1990', '4', '0', '2021-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2174', '2', '1', '2021-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1615', '1', '0', '2021-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1616', '1', '0', '2021-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1617', '1', '0', '2021-02-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1618', '1', '0', '2021-02-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76465760', 'EXBR1615', '1', '1', '2021-02-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('7411113', 'EXBR1616', '1', '1', '2021-02-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('88201900', 'EXEP1613', '1', '1', '2021-02-16', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1619', '1', '0', '2021-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76722755', 'EXEP1619', '1', '1', '2021-02-16', 'MAQUINA EXTERNA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1540', '8', '1', '2021-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2032', '1', '1', '2021-02-17', 'CoordinaciÃ³n. Calama', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2238', '1', '0', '2021-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2238', '1', '1', '2021-02-18', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('77037108', 'EXBR1617', '1', '1', '2021-02-19', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1471', '2', '1', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'BR1729', '1', '0', '2021-02-22', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13870282', 'EXBR1618', '1', '1', '2021-02-22', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1620', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1621', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2239', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2240', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2241', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2242', '1', '0', '2021-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76886060', 'EXBR1620', '1', '1', '2021-02-22', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76886060', 'EXBR1621', '1', '1', '2021-02-22', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1622', '1', '0', '2021-02-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777070', 'EXTO1622', '1', '1', '2021-02-23', 'OFICINA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2243', '1', '0', '2021-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2244', '1', '0', '2021-02-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'KY2240', '1', '1', '2021-02-25', 'Aseo y Ornato', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1623', '1', '0', '2021-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1624', '1', '0', '2021-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1625', '1', '0', '2021-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76149673', 'EXBR1624', '1', '1', '2021-02-25', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1988', '2', '0', '2021-02-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76056333', 'KY2241', '1', '1', '2021-02-25', 'Mejillones', null);
INSERT INTO `clientemaquina` VALUES ('76408707', 'EXBR1623', '1', '1', '2021-02-25', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1379', '3', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1381', '4', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1417 CL', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1433', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1451', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO-1605', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1544', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76419232', 'KY2242', '1', '1', '2021-02-26', '1 PISO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2028', '2', '1', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2219', '1', '0', '2021-02-26', 'Escuela Caracoles', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2027', '2', '0', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2210', '2', '0', '2021-02-26', 'Escuela Caracoles', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2047', '2', '0', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2244', '1', '1', '2021-02-26', 'Escuela Caracoles', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2034', '2', '0', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2040', '2', '0', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2026', '2', '0', '2021-02-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2233', '1', '1', '2021-02-26', 'ESCUELA G-130', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2243', '1', '1', '2021-02-26', 'ESCUELA G-130 secretarÃ­a', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2222', '1', '1', '2021-02-26', 'ESCUELA G-130 UTP Baquedano', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'EP2039', '1', '1', '2021-03-01', 'Local', null);
INSERT INTO `clientemaquina` VALUES ('10836775', 'EXBR1625', '1', '1', '2021-03-01', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2245', '1', '0', '2021-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1626', '1', '0', '2021-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1627', '1', '0', '2021-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1628', '1', '0', '2021-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16436574', 'EXBR1626', '1', '1', '2021-03-04', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1627', '1', '1', '2021-03-04', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13898004', 'EXBR1628', '1', '1', '2021-03-04', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO2245', '1', '1', '2021-03-04', 'CC2050 GABY', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1629', '1', '0', '2021-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1630', '1', '0', '2021-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1631', '1', '0', '2021-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1629', '1', '1', '2021-03-04', 'MAQUINA EXTERNA. CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1755', '2', '1', '2021-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2246', '1', '0', '2021-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2246', '1', '0', '2021-03-04', 'DAEM SecretarÃ­a', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1632', '1', '0', '2021-03-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9267076', 'EXBR1630', '1', '1', '2021-03-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('23906778', 'EXBR1631', '1', '1', '2021-03-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('76037060', 'EXBR1632', '1', '1', '2021-03-09', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2037', '3', '0', '2021-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2041', '4', '0', '2021-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76844941', 'EP1883', '1', '0', '2021-03-10', 'CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'U64209A8N6', '1', '1', '2021-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1633', '1', '0', '2021-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EXBR1633', '1', '1', '2021-03-11', 'DAEM TOCOPILLA EXTERNA.', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1637', '1', '0', '2021-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1637', '1', '1', '2021-03-11', 'MAQUINA EXTERNA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2247', '1', '1', '2021-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2247', '1', '1', '2021-03-17', 'BS-201 CGM003BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1976', '2', '1', '2021-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'BR1990', '1', '0', '2021-03-17', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2248', '1', '0', '2021-03-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1638', '1', '0', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1639', '1', '0', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1640', '1', '0', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7709163', 'EXBR1638', '1', '1', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2178', '2', '0', '2021-03-18', 'BS-105-CGM001BA01 GABY 2', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1940', '1', '0', '2021-03-18', 'BS-105-CGM001BA01 GABY 2', '0');
INSERT INTO `clientemaquina` VALUES ('19978734', 'EXBR1639', '1', '1', '2021-03-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2058', '4', '0', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2010', '3', '1', '2021-03-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16524375', 'KY2248', '1', '1', '2021-03-18', 'NOTARIA TALTAL', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2040', '1', '1', '2021-03-19', 'B. OÂ´HIGGINS RECEPCION', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2038', '1', '1', '2021-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2058', '1', '1', '2021-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2163', '1', '1', '2021-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76056333', 'BR1773', '1', '0', '2021-03-19', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2123', '3', '0', '2021-03-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1641', '1', '0', '2021-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EXBR1641', '1', '1', '2021-03-22', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1642', '1', '0', '2021-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17436021', 'EXBR1642', '1', '1', '2021-03-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1643', '1', '0', '2021-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77026216', 'EXBR1640', '1', '1', '2021-03-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1644', '1', '0', '2021-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1645', '1', '1', '2021-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1646', '1', '1', '2021-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1647', '1', '0', '2021-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1648', '1', '1', '2021-03-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15986571', 'EXBR1643', '1', '1', '2021-03-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13428681', 'EXBR1644', '1', '1', '2021-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1988', '1', '0', '2021-03-26', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1999', '4', '1', '2021-03-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1998', '3', '0', '2021-03-26', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO1997', '1', '0', '2021-03-29', 'CC2201 COPIAPO MANTOS ORO', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2262', '1', '0', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1649', '1', '1', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1650', '1', '0', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2262', '1', '1', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'BR2021', '1', '0', '2021-03-29', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1651', '1', '0', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1651', '1', '1', '2021-03-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1652', '1', '1', '2021-03-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77780170', 'EXBR1647', '1', '1', '2021-03-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76376417', 'EP2037', '1', '0', '2021-04-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'RGG0Z13502', '1', '1', '2021-04-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2257', '1', '0', '2021-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'KY2257', '1', '1', '2021-04-06', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1859', '3', '1', '2021-04-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1653', '1', '0', '2021-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1654', '1', '0', '2021-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1655', '1', '0', '2021-04-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76376417', 'EXBR1655', '1', '1', '2021-04-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1656', '1', '0', '2021-04-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1657', '1', '0', '2021-04-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76797557', 'EXEP1656', '1', '1', '2021-04-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2066', '3', '0', '2021-04-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2078', '1', '1', '2021-04-09', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('61964800', 'BR2025', '1', '1', '2021-04-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61964800', 'BR2020', '1', '1', '2021-04-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1658', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('6508799', 'KY2239', '1', '1', '2021-04-12', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1659', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2282', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2249', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2250', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2251', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2252', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2253', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2254', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2255', '1', '0', '2021-04-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76978773', 'EXEP1659', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76110235', 'EXBR1654', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2016', '2', '0', '2021-04-13', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2256', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2258', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2259', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2260', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2261', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2263', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2264', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2265', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2266', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2267', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2268', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2269', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2270', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2271', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2272', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2273', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2274', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2275', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2276', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2277', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2278', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2279', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2280', '1', '1', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2281', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2283', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1660', '1', '0', '2021-04-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2267', '1', '1', '2021-04-13', 'Daem Personal', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1661', '1', '0', '2021-04-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77287961', 'EP2282', '1', '0', '2021-04-14', 'Calama', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1662', '1', '0', '2021-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1663', '1', '0', '2021-04-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78885550', 'EXBR1653', '1', '1', '2021-04-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7525658', 'EXEP1661', '1', '1', '2021-04-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76931378', 'EP2277', '1', '1', '2021-04-19', 'clÃ­nica san Gabriel', null);
INSERT INTO `clientemaquina` VALUES ('18507596', 'EXBR1658', '1', '1', '2021-04-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96789280', 'EXBR1650', '1', '1', '2021-04-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1663', '1', '0', '2021-04-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1664', '1', '0', '2021-04-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76844941', 'EXEP1664', '1', '1', '2021-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76844941', 'EXEP1663', '1', '1', '2021-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78977700', 'EXBR1660', '1', '1', '2021-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15140232', 'EXBR1663', '1', '1', '2021-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15811771', 'EXBR1662', '1', '1', '2021-04-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2035', '6', '1', '2021-04-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1948', '2', '0', '2021-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1796', '1', '1', '2021-04-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2013', '3', '0', '2021-04-27', 'CSJ TALLER MANTENCION', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2096', '2', '1', '2021-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'KY2066', '1', '1', '2021-04-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1665', '1', '0', '2021-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1656', '1', '0', '2021-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10037199', 'EXBR1665', '1', '1', '2021-04-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2034', '1', '0', '2021-04-28', 'DAEM INFRAESTRUCTURA', '0');
INSERT INTO `clientemaquina` VALUES ('76400607', 'EXBR1656', '1', '1', '2021-04-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2299', '1', '0', '2021-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2088', '2', '1', '2021-05-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'KY2077', '1', '1', '2021-05-04', 'ZOCALO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1657', '1', '0', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2291', '1', '0', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2291', '1', '1', '2021-05-05', 'BS-105-CGM001BA01 ASEO TECNIFICADO', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO1948', '1', '0', '2021-05-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2246', '2', '0', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2192', '3', '0', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1738', '5', '1', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1536', '4', '1', '2021-05-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'EP2299', '1', '1', '2021-05-05', 'RECEPCION', null);
INSERT INTO `clientemaquina` VALUES ('17437759', 'EXBR1657', '1', '1', '2021-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO1970', '3', '1', '2021-05-06', 'BS-103-CRT002BA01 RIPIDO PREVENCION', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO2124', '1', '1', '2021-05-06', 'BS-103-CRT002BA01 RIPIDO RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2285', '1', '0', '2021-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2285', '1', '1', '2021-05-06', 'BS-103-CRT002BA01 RIPIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1659', '1', '0', '2021-05-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1670', '1', '0', '2021-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1671', '1', '0', '2021-05-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXBR1670', '1', '1', '2021-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1672', '1', '0', '2021-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10551777', 'EXBR1672', '1', '1', '2021-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1659', '1', '1', '2021-05-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1673', '1', '0', '2021-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2300 ', '1', '0', '2021-05-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'TO2300 ', '1', '1', '2021-05-13', 'CC2090 DMH', null);
INSERT INTO `clientemaquina` VALUES ('76069751', 'EXBR1671', '1', '1', '2021-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1674', '1', '0', '2021-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1675', '1', '1', '2021-05-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1647', '3', '1', '2021-05-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1883', '10', '0', '2021-05-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2011', '4', '0', '2021-05-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1674', '1', '1', '2021-05-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1676', '1', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1677', '1', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1678', '1', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1877', '2', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1856', '3', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '5', '0', '2021-05-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11634263', 'BR1856', '1', '0', '2021-05-20', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('11634263', 'BR1866', '1', '0', '2021-05-20', 'NOTARIA TOCOPILLA', '0');
INSERT INTO `clientemaquina` VALUES ('79578880', 'KY2255', '1', '1', '2021-05-24', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1773', '4', '0', '2021-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2173', '2', '1', '2021-05-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1673', '1', '1', '2021-05-24', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('9543689', 'EXBR1677', '1', '1', '2021-05-24', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('17437759', 'EXEP1657', '1', '1', '2021-05-24', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('19444673', 'EXBR1678', '1', '1', '2021-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77114442', 'EXBR1676', '1', '1', '2021-05-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1679', '1', '1', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1680', '1', '0', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1681', '1', '0', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1682', '1', '0', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1683', '1', '0', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXBR1682', '1', '1', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1922 ', '4', '1', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR2013', '1', '1', '2021-05-26', 'MEL', null);
INSERT INTO `clientemaquina` VALUES ('76522179', 'EXBR1680', '1', '1', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1684', '1', '0', '2021-05-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76408707', 'EXBR1684', '1', '1', '2021-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7619075', 'EXBR1683', '1', '1', '2021-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76031066', 'KY2250', '1', '1', '2021-05-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1685', '1', '0', '2021-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1686', '1', '0', '2021-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1687', '1', '0', '2021-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1688', '1', '0', '2021-05-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77078037', 'EXBR1681', '1', '1', '2021-06-01', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('21463496', 'EXBR1685', '1', '1', '2021-06-01', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR2030', '1', '0', '2021-06-01', 'Romana 1', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1726', '4', '0', '2021-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2210', '3', '0', '2021-06-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2134', '2', '1', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1876', '8', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2181', '2', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2004', '4', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1971', '5', '1', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR2029', '1', '0', '2021-06-03', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2298', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2298', '1', '0', '2021-06-03', 'BS-103-SPC001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1689', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1690', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1691', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1692', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1693', '1', '0', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12000367', 'EXBR1686', '1', '1', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2196', '4', '1', '2021-06-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2209', '2', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2286', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EP2286', '1', '1', '2021-06-04', 'Dideco sierra gorda ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2301', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2302', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2303', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2304', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2305', '1', '0', '2021-06-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1695', '1', '0', '2021-06-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1696', '1', '0', '2021-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1697', '1', '0', '2021-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96596370', 'EXBR1695', '1', '1', '2021-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1687', '1', '1', '2021-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76042014', 'EXBR1688', '1', '1', '2021-06-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76447329', 'EXBR1689', '1', '1', '2021-06-08', 'MINERA SALDIVAR', null);
INSERT INTO `clientemaquina` VALUES ('17020702', 'EXBR1690', '1', '1', '2021-06-08', '6 norte 1590', null);
INSERT INTO `clientemaquina` VALUES ('76190353', 'EXBR1691', '1', '1', '2021-06-09', 'av arturo perez canto 659 antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('23811657', 'EXBR1692', '1', '1', '2021-06-09', 'EDUARDO WORCKMAN 988', null);
INSERT INTO `clientemaquina` VALUES ('12770894', 'EXBR1693', '1', '1', '2021-06-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2301', '1', '1', '2021-06-09', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2303', '1', '1', '2021-06-09', 'BS-101-CTE001B101 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2302', '1', '1', '2021-06-09', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2305', '1', '1', '2021-06-09', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2304', '1', '1', '2021-06-09', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2192', '1', '1', '2021-06-09', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2284', '1', '0', '2021-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2287', '1', '0', '2021-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2026', '2', '1', '2021-06-10', 'ESCUELA CARACOLES ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1843', '5', '1', '2021-06-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO2123', '1', '1', '2021-06-10', 'FAENA CHANCAO ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2284', '1', '1', '2021-06-11', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2287', '1', '1', '2021-06-11', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1968', '2', '1', '2021-06-11', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('15015712', 'EXBR1696', '1', '1', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1698', '1', '0', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1699', '1', '0', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1700', '1', '0', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76954901', 'EXBR1698', '1', '1', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1701', '1', '0', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1702', '1', '0', '2021-06-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1703', '1', '0', '2021-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1704', '1', '0', '2021-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1705', '1', '0', '2021-06-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76220150', 'EXEP1703', '1', '1', '2021-06-16', 'antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1706', '1', '0', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1704', '1', '1', '2021-06-16', 'la negra ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP1941', '1', '0', '2021-06-16', 'notaria maria elena ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '5', '0', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'EP1876', '1', '1', '2021-06-16', 'finanzas', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1673', '5', '1', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1957', '2', '0', '2021-06-16', 'rectoria ', '0');
INSERT INTO `clientemaquina` VALUES ('76093010', 'EXBR1701', '1', '1', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1707', '1', '0', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1708', '1', '0', '2021-06-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1384', '3', '1', '2021-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2094', '2', '0', '2021-06-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2254', '1', '1', '2021-06-17', 'BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2306', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2307', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2308', '1', '1', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2309', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2310', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2311', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2312', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2313', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2314', '1', '0', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2315', '1', '1', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '5', '0', '2021-06-18', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('12576383', 'EP1941', '1', '0', '2021-06-18', 'Notaria ', '0');
INSERT INTO `clientemaquina` VALUES ('72396000', 'KY2256', '1', '1', '2021-06-18', 'calama - oficina ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1469', '2', '1', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77273090', 'EXBR1707', '1', '1', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('88883000', 'EXBR1697', '1', '1', '2021-06-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1709', '1', '0', '2021-06-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2210', '4', '0', '2021-06-24', 'Esc. Caracoles ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2270', '1', '1', '2021-06-30', 'BS-204-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1887', '3', '1', '2021-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'KY2306', '1', '1', '2021-06-30', 'taller electrÃ³nico 2 piso pozo almonte ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'KY2314', '1', '1', '2021-06-30', 'jefe de taller piso 1  pozo al monte ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1710', '1', '0', '2021-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1711', '1', '0', '2021-06-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXTO1709', '1', '1', '2021-07-01', 'chorrillo #1040 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2288', '1', '0', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2288', '1', '1', '2021-07-01', 'escuela bernardo oÂ·higgins ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2309', '1', '0', '2021-07-01', 'BS-103-SCP001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2307', '1', '1', '2021-07-01', 'BS-105-SPC001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2273', '1', '1', '2021-07-01', 'BS-105-SPC001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2272', '1', '1', '2021-07-01', 'BS-202-SPC001BA01', null);
INSERT INTO `clientemaquina` VALUES ('11467743', 'EXBR1700', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77261280', 'EXBR1706', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76063288', 'EXBR1702', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9318731', 'EXBR1705', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12445111', 'EXBR1708', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('4828566', 'EXBR1710', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15813803', 'EXBR1711', '1', '1', '2021-07-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '6', '0', '2021-07-05', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1712', '1', '0', '2021-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1713', '1', '0', '2021-07-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1714', '1', '0', '2021-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1715', '1', '0', '2021-07-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2306', '1', '0', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1716', '1', '0', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1717', '1', '0', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1718', '1', '0', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1719', '1', '0', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'EP2306', '1', '1', '2021-07-09', 'escritura publica ', null);
INSERT INTO `clientemaquina` VALUES ('78498240', 'EXBR1713', '1', '1', '2021-07-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96998260', 'EXBR1715', '1', '1', '2021-07-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1127', '2', '0', '2021-07-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1127', '2', '0', '2021-07-14', 'POLYTEX LOGISTICA LA NEGRA ', '0');
INSERT INTO `clientemaquina` VALUES ('6241080', 'EXBR1712', '1', '1', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'EP2271', '1', '1', '2021-07-14', 'oficina piso7 of 701 Antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1929', '2', '1', '2021-07-14', 'inspectorÃ­a ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2297', '1', '0', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2297', '1', '0', '2021-07-14', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2307', '1', '0', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76190282', 'TO2307', '1', '1', '2021-07-14', 'oficina- marÃ­a Elena ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1735', '5', '1', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76196877', 'TO1754', '1', '1', '2021-07-14', 'oficina- Antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('76756768', 'BR1933', '1', '0', '2021-07-14', 'oficina ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2007', '2', '0', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2011', '1', '1', '2021-07-14', 'ADQUISICIONES', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2181', '2', '0', '2021-07-14', 'SALVADOR- TALTAL ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2105', '3', '0', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77976320', 'TO1962', '1', '1', '2021-07-14', 'oficina - la negra ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1948', '3', '1', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2246', '2', '1', '2021-07-14', 'DAEM SECRETERIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1477', '4', '1', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1860', '1', '1', '2021-07-14', 'BS-000-ADM014ES01 RECEPCION ', null);
INSERT INTO `clientemaquina` VALUES ('76346990', 'EXBR1714', '1', '1', '2021-07-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1720', '1', '0', '2021-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1721', '1', '0', '2021-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16704047', 'EXBR1716', '1', '1', '2021-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2297', '2', '0', '2021-07-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1495', '3', '1', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1737', '1', '1', '2021-07-19', 'administracion ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1722', '1', '0', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('19396874', 'EXEP1722', '1', '1', '2021-07-19', 'centro MaipÃº 477 l12 Antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1694', '1', '0', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76124915', 'EXBR1694', '1', '1', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('24208392', 'EXBR1717', '1', '1', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76124915', 'EXBR1718', '1', '1', '2021-07-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1864', '2', '0', '2021-07-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1723', '1', '0', '2021-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17793481', 'EXBR1723', '1', '1', '2021-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2282', '2', '0', '2022-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1724', '1', '0', '2021-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16672409', 'EXBR1719', '1', '1', '2021-07-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1127', '3', '1', '2021-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1846', '5', '0', '2021-07-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1883', '1', '1', '2021-07-26', 'RRHH', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2309', '2', '0', '2021-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2311', '1', '1', '2021-07-27', 'BS-202-SPC001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1725', '1', '0', '2021-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2309', '2', '0', '2021-07-27', 'BS-103-SPC001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('96777810', 'EXTO1725', '1', '1', '2021-07-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1864', '2', '0', '2021-07-27', 'fam', '0');
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1720', '1', '1', '2021-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8555294', 'KY2310', '1', '1', '2021-07-29', 'notaria mejillones ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1729', '1', '0', '2021-07-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1730', '1', '0', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1914', '2', '1', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1809', '3', '1', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1465', '3', '1', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1852', '1', '1', '2021-08-03', 'BS-000-ADM013ES01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2263', '1', '1', '2021-08-03', 'BS-102-CRT mantenciÃ³n mina', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2264', '1', '1', '2021-08-03', 'BS-102-CRT mantenciÃ³n mina', null);
INSERT INTO `clientemaquina` VALUES ('17885455', 'EXBR1724', '1', '1', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '6', '0', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2017', '3', '1', '2021-08-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76850297', 'EP2268', '1', '0', '2021-08-04', 'MINERA EL ABRA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2089', '2', '1', '2021-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2191', '1', '1', '2021-08-04', 'INFORMATICA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1910', '3', '1', '2021-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2189', '2', '1', '2021-08-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1727', '1', '0', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1728', '1', '0', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBRE1731', '1', '1', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18361819', 'EXBR1721', '1', '1', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1732', '1', '0', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76060289', 'EXBR1732', '1', '1', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16136068', 'EXBR1727', '1', '1', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5283303', 'BR1726', '1', '1', '2021-08-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1801', '4', '1', '2021-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2188', '1', '1', '2021-08-06', 'call center ', null);
INSERT INTO `clientemaquina` VALUES ('15017239', 'EXBR1728', '1', '1', '2021-08-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1733', '1', '0', '2021-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1734', '1', '0', '2021-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1735', '1', '0', '2021-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1949', '2', '1', '2021-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10487973', 'TO1992', '1', '1', '2021-08-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1736', '1', '0', '2021-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76730643', 'EXBR1736', '1', '1', '2021-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81675600', 'EXBR1734', '1', '1', '2021-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15981773', 'EXBR1735', '1', '1', '2021-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76124915', 'EXBR1733', '1', '1', '2021-08-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'KY2312', '1', '0', '2021-08-12', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2193', '2', '0', '2021-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'BR2210', '3', '1', '2021-08-12', 'Esc. Caracoles ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1737', '1', '0', '2021-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76660114', 'EXBR1737', '1', '1', '2021-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76562505', 'EXBR1730', '1', '1', '2021-08-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1738', '1', '0', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76525290', 'EXBR1738', '1', '1', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76741450', 'EXBR1729', '1', '1', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2219', '2', '0', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1739', '1', '0', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1740', '1', '0', '2021-08-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('89701900', 'BR2219', '1', '1', '2021-08-16', 'CENTRO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1646', '4', '1', '2021-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18184348', 'EXBR1739', '1', '1', '2021-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1648', '7', '1', '2021-08-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2023', '1', '1', '2021-08-16', 'INSPECTORIA GENERAL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2312', '1', '0', '2021-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2314', '1', '0', '2021-08-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1911', '5', '1', '2021-08-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2313', '1', '1', '2021-08-23', 'FC-000-STD001ES01 los andes', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2315', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2316', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2317', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2318', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1881', '2', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1741', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1744', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1745', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2319', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2320', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2321', '1', '0', '2021-08-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76410146', 'EP2316', '1', '1', '2021-08-24', 'OFICINA ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1881', '1', '0', '2021-08-24', 'D.O.M', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'TO2314', '1', '1', '2021-08-24', 'BS-102-CRT001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1535', '9', '1', '2021-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1619', '5', '0', '2021-08-24', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76548103', 'KY2317', '1', '1', '2021-08-26', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1807', '5', '1', '2021-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2319', '1', '1', '2021-08-26', 'PUERTO SECO CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1888', '3', '0', '2021-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2034', '2', '0', '2021-08-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('83385600', 'KY2318', '1', '1', '2021-08-26', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'EP2056', '1', '0', '2021-08-26', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('65154641', 'EXBR1741', '1', '1', '2021-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77393120', 'EXBR1744', '1', '1', '2021-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1729', '3', '1', '2021-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('99514800', 'BR2004', '1', '1', '2021-08-27', 'RADIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1682', '2', '1', '2021-08-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('51064970', 'BR1892', '1', '1', '2021-08-27', 'CENTRAL DE APUNTE  ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1742', '1', '0', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2322', '1', '0', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16436446', 'EXBR1742', '1', '1', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76850297', 'EP2315', '1', '0', '2021-08-30', 'OF. CALAMA', '0');
INSERT INTO `clientemaquina` VALUES ('10240244', 'EXBR1740', '1', '1', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2322', '1', '1', '2021-08-30', 'calama', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1815', '3', '1', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2320', '1', '1', '2021-08-30', 'calama', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2021', '3', '0', '2021-08-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2321', '1', '1', '2021-08-30', 'ADM CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2297', '2', '0', '2021-08-30', 'SF-105-SPC001BA01 ', '0');
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2249', '1', '1', '2021-08-30', 'ANTOFAGASTA ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2252', '1', '1', '2021-08-30', 'ANTOFAGASTA GALPON ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2324', '1', '0', '2021-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('92562000', 'EXBR1745', '1', '1', '2021-08-31', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1743', '1', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1746', '1', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1747', '1', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1748', '1', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96539090', 'EXBR1743', '1', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1666', '5', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1835', '5', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1550', '3', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1938', '3', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1619', '1', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1614', '7', '1', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2290', '1', '0', '2021-09-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'EP2290', '1', '1', '2021-09-03', 'SF-000-ADM001ES18 RRHH CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('76079600', 'BR1846', '1', '1', '2021-09-06', 'Antofagasta', null);
INSERT INTO `clientemaquina` VALUES ('76387869', 'EXBR1746', '1', '1', '2021-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76387869', 'EXBR1747', '1', '1', '2021-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2323', '1', '0', '2021-09-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76291963', 'TO2323', '1', '1', '2021-09-06', 'MARIA ELENA', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'KY2258', '1', '1', '2021-09-06', 'DAEM REMUNERACIONES', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1749', '1', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXHP1750', '1', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2312', '1', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2312', '2', '1', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'TO2312', '1', '1', '2021-09-07', 'MARIA ELENA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1933', '4', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1839', '2', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1213', '1', '0', '2021-09-07', 'BS-205-CCH001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2048', '3', '0', '2021-09-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1841', '4', '0', '2021-09-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76077994', 'KY2251', '1', '1', '2021-09-08', 'LEM COPIAPO ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1986', '4', '0', '2021-09-09', 'BS-103-MEL001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1751', '1', '0', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1751', '1', '1', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1755', '1', '0', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1756', '1', '0', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76124915', 'EXBR1756', '1', '1', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77920000', 'EXBR1748', '1', '1', '2021-09-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020500', 'TO2324', '1', '1', '2021-09-13', 'DAEM LICEO C-20', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2012', '4', '1', '2021-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2181', '3', '0', '2021-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1869', '4', '1', '2021-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17725228', 'EXBR1749', '1', '1', '2021-09-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1753', '1', '0', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('10900148', 'EXBR1753', '1', '1', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1752', '1', '0', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'EXBR1752', '1', '1', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2030', '3', '1', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR1877', '1', '1', '2021-09-14', 'romana 3', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2029', '3', '1', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR1839', '1', '1', '2021-09-14', 'romana 2 ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1822', '4', '1', '2021-09-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78876040', 'BR1776', '1', '1', '2021-09-14', 'Romana 1', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1757', '1', '0', '2021-09-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1758', '1', '0', '2021-09-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'EP2007', '1', '1', '2021-09-21', '5to piso', null);
INSERT INTO `clientemaquina` VALUES ('19423014', 'EXBR1758', '1', '1', '2021-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13356576', 'EXBR1757', '1', '1', '2021-09-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2055', '3', '0', '2021-09-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1933', '1', '0', '2021-09-24', 'BS-105-CGM001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2181', '3', '0', '2021-09-24', 'BS-105-CGM001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2014', '2', '1', '2021-09-27', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2041', '1', '1', '2021-09-27', 'BS-000-ADM015ES01', null);
INSERT INTO `clientemaquina` VALUES ('76121841', 'HP2050', '1', '1', '2021-09-27', 'CENTRO COPIADO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1998', '4', '0', '2021-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1759', '1', '0', '2021-09-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1760', '1', '1', '2021-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1761', '1', '0', '2021-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8082310', 'EXBR1759', '1', '1', '2021-10-01', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('76124915', 'EXBR1755', '1', '1', '2021-10-01', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2121', '2', '1', '2021-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1793', '5', '1', '2021-10-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16132908', 'EXBR1761', '1', '1', '2021-10-01', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2132', '3', '0', '2021-10-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2132', '2', '1', '2021-10-07', 'BS-103-CMH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('61004007', 'KY2034', '1', '1', '2021-10-07', 'cÃ¡rcel de mujeres', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1762', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1763', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1764', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1765', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1766', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1767', '1', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76327728', 'EXBR1762', '1', '1', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2178', '3', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1940', '4', '0', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15019594', 'EXBR1766', '1', '1', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('11818337', 'EXBR1763', '1', '1', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'TO1953', '1', '1', '2021-10-08', 'RECTORIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2148', '2', '1', '2021-10-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'EXBR1765', '1', '1', '2021-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('5484346', 'EXBR1764', '1', '1', '2021-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1768', '1', '0', '2021-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1769', '1', '0', '2021-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1770', '1', '0', '2021-10-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1771', '1', '0', '2021-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1772', '1', '0', '2021-10-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69252500', 'EXBR1771', '1', '1', '2021-10-14', 'ESCUELA G-25 ', null);
INSERT INTO `clientemaquina` VALUES ('69252500', 'EXBR1772', '1', '1', '2021-10-14', 'ESCUELA G-25 ', null);
INSERT INTO `clientemaquina` VALUES ('99575470', 'KY2260', '1', '1', '2021-10-14', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2325', '1', '0', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76148340', 'BR2325', '1', '1', '2021-10-15', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('13642312', 'EXHP1750', '1', '1', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1773', '1', '0', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77203099', 'EXBR1773', '1', '1', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15015712', 'EXBR1767', '1', '1', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76356183', 'EXBR1769', '1', '1', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76356183', 'EXBR1768', '1', '1', '2021-10-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2312', '1', '1', '2021-10-19', 'BS-101-CTE001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1774', '1', '0', '2021-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253200', 'EXBR1774', '1', '1', '2021-10-20', 'DIDECO* EXTERNA *', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1775', '1', '0', '2021-10-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EXBR1775', '1', '1', '2021-10-21', 'SOCIAL *EXTERNA*', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2315', '2', '0', '2021-10-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76850297', 'EP2055', '1', '0', '2021-10-21', 'OFICINA CALAMA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2297', '3', '0', '2022-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2056', '4', '0', '2021-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2326', '1', '0', '2021-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76961000', 'TO2326', '1', '0', '2021-10-26', 'Antofagasta ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2090', '2', '0', '2021-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2105', '1', '0', '2021-10-26', 'Tocopilla pedagÃ³gico', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2105', '4', '0', '2021-10-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2315', '1', '1', '2021-10-26', 'pedagÃ³gico ', null);
INSERT INTO `clientemaquina` VALUES ('10831760', 'EXBR1770', '1', '1', '2021-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1776', '1', '0', '2021-10-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('16705746', 'EXBR1776', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR1928', '1', '1', '2021-11-03', 'MATRICULA', null);
INSERT INTO `clientemaquina` VALUES ('78863090', 'BR2018', '1', '0', '2021-11-03', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('76792609', 'EP2283', '1', '1', '2021-11-03', 'mejillones ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1777', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1778', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BREX1779', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2332', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2333', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2334', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2335', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2336', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2337', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2338', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2339', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2340', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2341', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2342', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2327', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2328', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2329', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2330', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BREX1780', '1', '0', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY2328', '1', '1', '2021-11-03', 'piso# 3 ', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY2330', '1', '1', '2021-11-03', 'PISO 2A', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY2327', '1', '1', '2021-11-03', 'piso # 2B', null);
INSERT INTO `clientemaquina` VALUES ('60511020', 'KY2329', '1', '1', '2021-11-03', 'piso#1', null);
INSERT INTO `clientemaquina` VALUES ('76899720', 'BREX1780', '1', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2003', '7', '1', '2021-11-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7993843', 'EXBR1777', '1', '1', '2021-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'BREX1779', '1', '1', '2021-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1988', '3', '1', '2021-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1957', '6', '0', '2021-11-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'EP2105', '1', '1', '2021-11-04', 'RECTORIA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2331', '1', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2331', '1', '1', '2021-11-05', 'SECRETARIA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1792', '2', '1', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1989', '2', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2334', '1', '1', '2021-11-05', 'daem finanzas ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '6', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EPEX1781', '1', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1782', '1', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1783', '1', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1784', '1', '0', '2021-11-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78590360', 'EXBR1778', '1', '1', '2021-11-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2178', '3', '1', '2021-11-08', 'BS-103-MEL001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76942477', 'EPEX1781', '1', '1', '2021-11-08', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2342', '1', '0', '2021-11-08', 'BS-103-SPC001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1784', '1', '1', '2021-11-08', 'Antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR2016', '1', '0', '2021-11-10', 'MATRICULA ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1243', '2', '1', '2021-11-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2326', '2', '1', '2021-11-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EZ230U', '1', '1', '2021-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1785', '1', '0', '2021-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152451', 'EXRI1785', '1', '1', '2021-11-16', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXRI1786', '1', '0', '2021-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152451', 'EXRI1786', '1', '1', '2021-11-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1787', '1', '0', '2021-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78284760', 'EXBR1787', '1', '1', '2021-11-17', 'Antofagasta ', null);
INSERT INTO `clientemaquina` VALUES ('76244049', 'EXBR1782', '1', '1', '2021-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76761188', 'EXBR1783', '1', '1', '2021-11-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1788', '1', '0', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1789', '1', '0', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1790', '1', '0', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76430143', 'EXBR1790', '1', '1', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('18791276', 'EXBR1789', '1', '1', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('72169400', 'EXBR1788', '1', '1', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1791', '1', '0', '2021-11-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'MI1255', '1', '1', '2021-11-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1792', '1', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2343', '1', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76961000', 'TO2343', '1', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1960', '1', '0', '2021-12-02', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '5', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2094', '2', '0', '2021-12-02', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('76121841', 'EP2056', '1', '0', '2021-12-02', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1792', '1', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1792', '1', '1', '2021-12-02', 'Externa Toshiba', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2056', '5', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'EP2056', '1', '1', '2021-12-02', 'Spence', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2212', '2', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1864', '3', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1793', '1', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8797676', 'EXBR1793', '1', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1794', '1', '0', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR2090', '1', '1', '2021-12-02', 'BS-103-MEL001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1986', '7', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('8797676', 'EXBR1794', '1', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP1213', '2', '0', '2021-12-02', 'BS-205-CCH001BA01', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2094', '3', '1', '2021-12-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1960', '7', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1873', '1', '1', '2021-12-03', 'Medio ambiente', null);
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR1773', '1', '0', '2021-12-03', 'MATRICULA ', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR2024', '1', '0', '2021-12-03', 'MATRICULA ', '0');
INSERT INTO `clientemaquina` VALUES ('65152165', 'BR2027', '1', '0', '2021-12-03', 'Matricula', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2195', '2', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2259', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2253', '1', '1', '2021-12-03', 'servicio de vivienda y urbanizaciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2349', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2348', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2347', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2349', '1', '1', '2021-12-03', 'servicio de vivienda y urbanizaciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2348', '1', '1', '2021-12-03', 'servicio de vivienda y urbanizaciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2347', '1', '1', '2021-12-03', 'servicio de vivienda y urbanizaciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1795', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1796', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1797', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1798', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1799', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1800', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1801', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1802', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1803', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96856610', 'EXBR1791', '1', '1', '2021-12-03', 'Cobija 337 Barrio Industrial ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1804', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1805', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1806', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('78974730', 'EXBR1795', '1', '1', '2021-12-03', 'Parque industrial apia, calama', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1807', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1808', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('17656045', 'EXBR1796', '1', '1', '2021-12-03', 'Wlamart Arauco 2448 Calama', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1989', '1', '1', '2021-12-03', 'BS-101-CMZ001BA01', null);
INSERT INTO `clientemaquina` VALUES ('81201000', 'EXBR1797', '1', '1', '2021-12-03', 'Paris', null);
INSERT INTO `clientemaquina` VALUES ('76608790', 'EXBR1799', '1', '1', '2021-12-03', 'galpÃ³n 12', null);
INSERT INTO `clientemaquina` VALUES ('11505605', 'EXBR1802', '1', '1', '2021-12-03', 'calle el oro 8275', null);
INSERT INTO `clientemaquina` VALUES ('86551700', 'KY2339', '1', '1', '2021-12-03', 'Caja', null);
INSERT INTO `clientemaquina` VALUES ('86551700', 'KY2341', '1', '1', '2021-12-03', 'patio constructor', null);
INSERT INTO `clientemaquina` VALUES ('86551700', 'KY2340', '1', '1', '2021-12-03', '21 mayo', null);
INSERT INTO `clientemaquina` VALUES ('16849626', 'EXBR1808', '1', '1', '2021-12-03', 'dep 1', null);
INSERT INTO `clientemaquina` VALUES ('76741450', 'EXBR1798', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76608790', 'EXBR1800', '1', '1', '2021-12-03', 'galpÃ³n 12', null);
INSERT INTO `clientemaquina` VALUES ('11818337', 'EXBR1803', '1', '1', '2021-12-03', 'pasaje cupo', null);
INSERT INTO `clientemaquina` VALUES ('15022088', 'EXBR1801', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77372493', 'EXBR1805', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2350', '1', '0', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76153372', 'KY2337', '1', '1', '2021-12-03', 'OFICINA CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('76262882', 'EXBR1804', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76933647', 'EXBR1807', '1', '1', '2021-12-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1744', '4', '0', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1492', '6', '1', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1809', '1', '0', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'CNJJ12887', '1', '1', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'EXTO1809', '1', '1', '2021-12-13', 'EXTERNA JUMBO CONY ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1810', '1', '0', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13011790', 'EXTO1810', '1', '1', '2021-12-13', 'EXTERNA JUMBO CONY ', null);
INSERT INTO `clientemaquina` VALUES ('77316237', 'TO2350', '1', '1', '2021-12-13', 'Salvador', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2351', '1', '0', '2021-12-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2351', '1', '1', '2021-12-13', 'BS-205-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('18255597', 'EXBR1699', '1', '1', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1812', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1813', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1814', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1811', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('15020904', 'EXTO1811', '1', '1', '2021-12-16', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO2352', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76890745', 'TO2352', '1', '1', '2021-12-16', 'ANTOFAGASTA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2209', '1', '1', '2021-12-16', 'BS-105-CGM001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76214934', 'EP2297', '1', '1', '2022-01-14', 'CECO FC-00-ADM008ES5', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2181', '4', '1', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2037', '4', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1940', '1', '0', '2021-12-16', 'MATRICULA 2do PISO', '0');
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2193', '1', '1', '2021-12-16', 'BS-101-CMZ002BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2353', '1', '0', '2021-12-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2353', '1', '1', '2021-12-16', 'BS-101-CMZ002BA01', null);
INSERT INTO `clientemaquina` VALUES ('76145047', 'BR1841', '1', '1', '2021-12-17', 'CC2202 DMH ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1997', '4', '1', '2021-12-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '7', '0', '2021-12-20', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76866001', 'EXBR1813', '1', '1', '2021-12-22', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('76117385', 'EXBR1814', '1', '1', '2021-12-22', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1815', '1', '0', '2021-12-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77316237', 'EXBR1815', '1', '1', '2021-12-22', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('77920000', 'EXBR1812', '1', '1', '2021-12-22', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'EP1941', '2', '0', '2021-12-22', 'NOTARIA MARIA ELENA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1861', '1', '0', '2021-12-27', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1938', '1', '0', '2021-12-27', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1853', '1', '0', '2021-12-27', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1888', '1', '0', '2021-12-27', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2021', '1', '0', '2021-12-27', 'MATRICULA', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1861', '5', '1', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '5', '0', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1938', '4', '0', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1888', '4', '1', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2021', '4', '1', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1940', '5', '0', '2021-12-29', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2172', '2', '0', '2021-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1881', '3', '1', '2021-12-30', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2342', '2', '0', '2022-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2309', '3', '0', '2022-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2298', '2', '0', '2022-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1815', '1', '0', '2022-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1815', '1', '1', '2022-01-03', 'EXTERNA TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2016', '3', '0', '2022-01-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR2016', '1', '0', '2022-01-03', 'SAN ESTEBAN', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1817', '1', '0', '2022-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12440144', 'EXBR1817', '1', '1', '2022-01-05', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1818', '1', '0', '2022-01-05', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('77321895', 'EXBR1818', '1', '1', '2022-01-05', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2167', '2', '1', '2022-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'EP2048', '1', '1', '2022-01-06', 'SF-105-SPC001BA01 SPENCE', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '8', '0', '2022-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('12576383', 'EP2172', '1', '1', '2022-01-06', 'NOTARIA MARIA ELENA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2067', '2', '1', '2022-01-06', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('7016316', 'KY2309', '1', '1', '2022-01-06', 'SEGUNDO PISO', null);
INSERT INTO `clientemaquina` VALUES ('776803790', 'BR1957', '1', '1', '2022-01-07', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1981', '2', '1', '2022-01-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2298', '1', '1', '2022-01-10', 'SECRETARIA DOM', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1941', '9', '1', '2022-01-12', 'GESTION Y CONTROL', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1773', '5', '0', '2022-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2027', '3', '1', '2022-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2024', '3', '1', '2022-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1819', '1', '0', '2022-01-12', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('24115129', 'EXEP1819', '1', '1', '2022-01-12', 'VENTA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1828', '2', '0', '2022-01-13', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('82200000', 'BR1828', '2', '1', '2022-01-13', 'CAMARA DE COMERCIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2016', '4', '1', '2022-01-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1820', '1', '0', '2022-01-18', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('1581120', 'EXBR1820', '1', '1', '2022-01-18', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2354', '1', '0', '2022-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2355', '1', '0', '2022-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2356', '1', '0', '2022-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2357', '1', '0', '2022-01-19', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2357', '1', '1', '2022-01-19', ' BS-103-CCH001BA02', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2354', '1', '1', '2022-01-19', 'BS-103-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2355', '1', '1', '2022-01-19', 'BS-103-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2356', '1', '1', '2022-01-19', 'BS-103-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('77431100', 'EP2037', '1', '1', '2022-01-19', 'CALAMA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1842', '3', '1', '2022-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1853', '1', '0', '2022-01-25', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1821', '1', '0', '2022-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('26032007', 'EXBR1821', '1', '1', '2022-01-25', 'GARANTIA BROTHER', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1822', '1', '0', '2022-01-25', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76265500', 'EXBR1822', '1', '1', '2022-01-25', 'EXTERNA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1853', '6', '1', '2022-01-26', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('79783050', 'BR1938', '1', '1', '2022-01-26', 'ADQUICISIONES ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1823', '1', '0', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1824', '1', '1', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXEP1825', '1', '1', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1826', '1', '1', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2034', '3', '1', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2282', '1', '1', '2022-01-28', 'DAEM INFRAESTRUCTURA', null);
INSERT INTO `clientemaquina` VALUES ('26320129', 'EXBR1823', '1', '1', '2022-01-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1880', '2', '0', '2022-02-02', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69900303', 'BR1972', '1', '0', '2022-02-02', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2087', '2', '1', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69253600', 'EP2212', '1', '1', '2022-02-03', 'CONSULTORIO', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1902', '2', '1', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'BR1991', '1', '0', '2022-02-03', 'JUZGADO POLICIA LOCAL ', '0');
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1933', '5', '1', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP1213', '6', '0', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1972', '4', '1', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69900303', 'EP1880', '2', '1', '2022-02-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1827', '1', '1', '2022-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1828', '1', '1', '2022-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1829', '1', '0', '2022-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXTO1830', '1', '1', '2022-02-08', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('91426000', 'EXTO1829', '1', '1', '2022-02-08', 'EXTERNA TOSHIBA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2360', '1', '0', '2022-02-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020100', 'EP2360', '1', '1', '2022-02-09', 'DAEM INFRAESTRUCTURA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2042', '3', '0', '2022-02-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2358 ', '1', '0', '2022-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61105000', 'KY2358 ', '1', '1', '2022-02-10', 'ANTOFAGASTA ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1990', '5', '1', '2022-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2367 ', '1', '0', '2022-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96808790', 'EP2367 ', '1', '1', '2022-02-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2370', '1', '0', '2022-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1831', '1', '0', '2022-02-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2194', '5', '1', '2022-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1744', '5', '1', '2022-02-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1832', '1', '1', '2022-02-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1833', '1', '1', '2022-02-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'TO1749', '2', '1', '2022-02-15', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2359', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2361', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2362', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2363', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2365', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2366', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2368', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2369', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2371', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2372', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2373', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2374', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2375', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2376', '1', '0', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76464003', 'KY2376', '1', '1', '2022-02-16', '2Â° PISO', null);
INSERT INTO `clientemaquina` VALUES ('76606931', 'EP2361', '1', '1', '2022-02-16', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2370', '1', '1', '2022-02-17', 'BS-201-CCH001BA01', null);
INSERT INTO `clientemaquina` VALUES ('77490350', 'EXKY1831', '1', '1', '2022-02-17', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76099692', 'EP2281', '1', '1', '2022-02-18', 'la negra', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1998', '4', '1', '2022-02-21', 'BS-103-MEL001BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1834', '1', '1', '2022-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1835', '1', '1', '2022-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1836', '1', '1', '2022-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1837', '1', '1', '2022-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1991', '3', '1', '2022-02-21', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP1213', '2', '1', '2022-02-21', 'JUZGADO POLICIA LOCAL ', null);
INSERT INTO `clientemaquina` VALUES ('76821240', 'KY2359', '1', '1', '2022-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76821240', 'EP2362', '1', '1', '2022-02-22', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2268', '2', '0', '2022-02-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2055', '4', '1', '2022-02-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1838', '1', '1', '2022-02-23', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXKY1839', '1', '0', '2022-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76804856', 'EXKY1839', '1', '1', '2022-02-28', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1840', '1', '1', '2022-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1841', '1', '1', '2022-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR2018', '3', '1', '2022-03-01', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('76409216', 'EP2332', '1', '1', '2022-03-01', 'PISO # 4', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1842', '1', '1', '2022-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1843', '1', '1', '2022-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1844', '1', '1', '2022-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1845', '1', '1', '2022-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1846', '1', '1', '2022-03-03', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2377', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2378', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2379', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2380', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2381', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2382', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2383', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2384', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1847', '1', '1', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'EP2369', '1', '0', '2022-03-04', 'CSJ', '0');
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2378', '1', '1', '2022-03-04', 'piso 1 administraciÃ³n', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'KY2385', '1', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2385', '1', '1', '2022-03-04', 'piso 6 secretaria', null);
INSERT INTO `clientemaquina` VALUES ('76053835', 'KY2381', '1', '1', '2022-03-04', 'OFICINA RENDIC', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EP2369', '2', '0', '2022-03-04', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'EP2369', '2', '1', '2022-03-04', 'SF-104-CTE001 CTE-MANT. RANCAGUA', null);
INSERT INTO `clientemaquina` VALUES ('96846410', 'KY2375', '1', '1', '2022-03-04', 'SF-104-CTE001 CTE-MANT. RANCAGUA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'KY2342', '2', '1', '2022-03-04', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2042', '1', '1', '2022-03-04', 'BS-101-CTE001BA01 RANCAGUA ', null);
INSERT INTO `clientemaquina` VALUES ('65152162', 'BR1940', '2', '1', '2022-03-09', 'BIBLIOTECA ', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2377', '1', '1', '2022-03-09', 'PISO 4', null);
INSERT INTO `clientemaquina` VALUES ('61814000', 'KY2379', '1', '1', '2022-03-09', 'PISO 2', null);
INSERT INTO `clientemaquina` VALUES ('76053835', 'KY2380', '1', '1', '2022-03-09', 'OFICINA  CALLE ZAFIRO', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'EP2268', '1', '1', '2022-03-09', 'FAENA CHANCADO- STEPHANIE', null);
INSERT INTO `clientemaquina` VALUES ('65158175', 'KY2383', '1', '1', '2022-03-09', 'PISO 4', null);
INSERT INTO `clientemaquina` VALUES ('65158175', 'EP2384', '1', '1', '2022-03-09', 'PISO 3', null);
INSERT INTO `clientemaquina` VALUES ('65158175', 'KY2382', '1', '1', '2022-03-09', 'PISO 2', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1259', '2', '1', '2022-03-09', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('69020400', 'EP2365', '1', '1', '2022-03-09', 'INFORMATICA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1856', '4', '0', '2022-03-10', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9976461', 'BR1856', '1', '1', '2022-03-11', 'NOTARIA JORGE SCHWENKE ZUNIGA - TOCOPILLA', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'BR1866', '6', '0', '2022-03-11', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('9976461', 'BR1866', '1', '1', '2022-03-11', 'NOTARIA JORGE SCHWENKE ZUNIGA - TOCOPILLA', null);
INSERT INTO `clientemaquina` VALUES ('76050301', 'BR1773', '1', '1', '2022-03-14', 'BS-101-CMZ02003BA01', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1848', '1', '1', '2022-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1849', '1', '1', '2022-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1850', '1', '1', '2022-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1851', '1', '1', '2022-03-14', 'CSJ', null);
INSERT INTO `clientemaquina` VALUES ('13420903', 'EXBR1852', '1', '1', '2022-03-14', 'CSJ', null);
INSERT INTO `clientes` VALUES ('13420903', '8', 'CSJ Digital Express', 'CSJ Digital Express', 'CSJ Digital Express', '(56)(55)-286160', 'Galleguillos Lorca #1474 ', 'ANTOFAGASTA', 'fotocopiadora');
INSERT INTO `clientes` VALUES ('77887000', '2', 'ADD CORP S.A.', 'ADD CORP', 'NATALIA ', '449200', 'ANTONINO TORO #1125', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96912990', '6', 'AEROPUERTO CERRO MORENO S.A', 'AEROPUERTO CERRO MORENO', '', '254998', 'AVDA. ANDRES BELLO 2711', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('81842900', '2', 'INSTITUTO CHILENO NORTEAMERICANO DE CULTURA', null, 'CHILENO NORTEAMERICANO', '2262731', 'CARRERA 1445', 'ANTOFAGASTA', 'ESTABLECIMIENTOS DE ENSENANZA PREESCOLAR');
INSERT INTO `clientes` VALUES ('89853600', '9', 'constructora INGEVEC S.A', null, 'constructora INGEVEC S.A', '02-6743800', 'AV. apoquindo # 4775 piso 19 las condes', 'santiago', 'constructora ');
INSERT INTO `clientes` VALUES ('9143525', '3', 'ALBERTO CARRASCO', 'ALBETO CARRASCO', '', '376437', '', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('11118822', 'K', 'ALFONSO CRESTA FORADORI', 'ALFONSO CRESTA FORADORI', '', '247994', 'AVELINO CONTARDO 868', 'ANTOFAGASTA', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('78808210', 'K', 'SOCIEDAD PAVIMENTOS NORTE LTDA.', null, 'PAVIMENTOS NORTE', '710813- 170814', 'AV. PEDRO AGUIRRES CERDA #14930 BARRIO INDUSTRIAL', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('65152165', '3', 'FUNDACION EDUCACIONAL NETLAND SCHOOL', 'NETLAND SCHOOL', 'NETLAND SCHOOL', '055-537615', 'ASCOTAN SUR 170', 'ANTOFAGASTA', 'ESTABLECIMIENTOS DE ENSENANZA PREESCOLAR');
INSERT INTO `clientes` VALUES ('76602380', '0', 'ANGLIA CAPACITACION LTDA.', 'ANGLIA CAPACITACION ', '', '488193', 'MANUEL VERBAL #1340', 'ANTOFAGASTA', 'CAPACITACION');
INSERT INTO `clientes` VALUES ('76697710', '3', 'OYARZUN  MICHEA  LTDA', null, 'OYARZUN  MICHEA  LTDA', '1111111', 'LOS TAMARUGOS #256', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76010311', 'K', 'TALENT ART HOME SCHOOL', null, 'ESCUELA CHAÃ‘ARES', '55-689400', 'ANTONINO TORO # 940', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('71529400', '1', 'ASOCIACION GREMIAL DE ABOGADOS DE ANTOFAGASTA.', 'ASOCIACION GREMIAL DE ABOGADOS ', '', '225392', 'PRAT #273', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76037662', '0', 'Repuestos nievas eirl ', null, 'Repuestos nievas eirl ', '055-929472', 'Baquedano 239 Antofagasta', 'Antofagasta', '');
INSERT INTO `clientes` VALUES ('76014676', '5', 'MARIA BASTIA', null, 'MARIA BASTIA', '333333', 'RUTA A 16 KM12 ALTO HOSPICIO', 'IQUIQUE', '');
INSERT INTO `clientes` VALUES ('89701900', '0', 'CARLOS BONILLA L. OSCAR DEL BARRIO C. Y CIA.', 'CARLOS BONILLA', '', '263768', 'SUCRE 220. OF. 506', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60511021', '5', 'GOBERNACION PROVINCIAL DE TOCOPILLA', null, 'GOBERNACION PROVINCIAL DE TOCOPILLA', '819681', '21 DE MAYO #1645', 'TOCOPILLA', 'OTRAS ACTIVIDADES DE SERVICIOS PERSONALE ');
INSERT INTO `clientes` VALUES ('95748000', '4', 'CAUCHOS INDUSTRIALES', 'CAUCHOS INDUSTRIALES', '', '492015', 'KM. 1357, RUTA NORTE, LA NEGRA', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('95432000', '6', 'CENTRO MEDICO ANTOFAGASTA S.A.', 'CENTRO MEDICO ANTOFAGASTA', '', '', 'MANUEL ANTONIO MATTA 1945', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76538490', '7', 'CENTRO ODONTOLOGICO Y DE ESTETICA CARRETA LTDA.', 'CENTRO ODONTOLOGICO Y DE ESTETICA CARRERA', '', '', 'GALLEGUILLOS LORCA 1610', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('70007480', '3', 'CLUB DE YATES ANTOFAGASTA ', 'CLUB DE YATES ', '', '789530', 'BALMACEDA 2705', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77669340', '5', 'COMERCIAL CECOM LTDA', 'COMERCIA CECOM', '', '387840', 'AV. VALLE APACIBLE 03726', 'ANTOFAGASTA', 'CENTRAL TELEFONICA, TELEFONIA COMPUTACION');
INSERT INTO `clientes` VALUES ('72443600', '5', 'SERVICIO DE EVALUACION AMBIENTAL', 'COMISION NACIONAL DEL MEDIO AMBIENTE ', '', '2467100', '14 de febrero 2065 oficina 1401', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('56058530', '6', 'COMUNIDAD EDIFICIO LA PORTADA ', 'EDIF LA PARTADA ', '', '495788', 'GENERAL VELASQUEZ 1046', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76426470', '3', 'COMPLEJO MATCH LTDA', 'COMPLEJO MATCH ', '', '563200', 'VLADIMIR SAAVEDRA 375', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76382160', '9', 'CONCESIONES Y TURISMO S.A.', 'CONCESIONES Y TURISMO ', '', '563200', 'AV. CARRERA 1601', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96531780', '5', 'CONSTRUCCIONES Y MONTAJES S.A.', 'CONSTRUCCIONES Y MONTAJES ', '', '', 'LAS ESTERAS NORTE 2620', 'SANTIAGO', 'CONSTRUCCIONES Y MONTAJES INDUSTRIALES');
INSERT INTO `clientes` VALUES ('86356400', 'K', 'CONSTRUCTORA ALMAGRO S.A.', 'CONSTRUCTORA ALMAGRO', ' SABRINA', '389180', 'PADRE MARIANO # 277', 'PROVIDENCIA STGO.', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('89334500', '0', 'CONSTRUCTORA BDS S.A ', 'CONSTRUCTORA BDS', '', '231735', 'AVDA. RADOMIRO TOMIC 8153', 'ANTOFAGASTA', 'CONSTRUCCION ');
INSERT INTO `clientes` VALUES ('76204970', '8', 'CONSTRUCTORA CONDEMARI', 'CONSTRUCTORA CONDEMARI', '', '418269', 'IQUIQUE 5466', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76005286', '8', 'CONSTRUCTORA MARABIERTO LTDA.', 'CONSTRUCTORA MARABIERTO ', 'KAREN ', '252639', '14 DE FEBRERO1822, 3 º PISO LOCAL 14', 'ANTOFAGASTA', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('83407700', '0', 'CONSTRUCTORA NAVARRETE Y DIAZ COUMSILLE INGENIEROS CIVILES', 'CONSTRUCTORA NAVARRETE Y DIAZ', '', '764649', 'MONEDA 970 PISO 19', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76932810', '6', 'CONSTRUCTORA SANTA MARTA LTDA.', 'CONSTRUCTORA SANTA MARTA ', '', '492140', 'MARIA JOSEFINA 852 B. INDUSTRIAL LAMPA ', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('76010097', '8', 'CONSTRUCTORA Y SERVICIOS CLS LTDA', 'CONSULTORA Y SERVICIOS CLS', '', '378968', 'GALLEGUILLOS LORCA 1474 OF. 01', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('70200800', 'K', 'CORPORACION DE CAPACITACION DE LA CONSTRUCCION', 'CORPORACION DE CAPACITACION DE LA CONSTRUCCION', 'CINTHIA MENESES', '530320', 'EDUARDO ORCHA 1588 CASA 2', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('71102600', '2', 'CORPORACION MUNICIPAL DESARROLLO SOCIAL ANTOFAGASTA ', 'CORMUDESO ', 'ESCUELA D-75', '798508', 'AV. ARGENTINA 1595. 2 ï¿½ PISO ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60804004', '8', 'DIRECCION REGIOANAL DE ADUANA ', 'ADUANA ', '', '813176', 'SUCRE 215', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96870780', '9', 'ECHEVERRIA IZQUIERDO MONTAJES INDUSTRIALES S.A.', 'ECHEVERRIA IZQUIERDO ', 'SERGIO DONOSO ', '02-7574900', 'ROSARIO NORTE 530 OF 702 ', 'LAS CONDE SANTIAGO ', 'INGENIERIA Y MONTAJES');
INSERT INTO `clientes` VALUES ('88006900', '4', 'E-CL', 'EDELNOR ', '', '02-3533200', 'AV. BOSQUE NORTE 500 OF. 902', 'LAS CONDE SANTIAGO ', '');
INSERT INTO `clientes` VALUES ('96731500', '1', 'ELECTROANDINA S.A.', 'ELECROANDINA ', 'MARIA YAÑEZ', '642902', 'AV. LEONARDO GUZMAN 780', 'TOCOPILLA', 'GENERADORA Y DISTRIBUIDORA DE ENERGIA ELECTRICA ');
INSERT INTO `clientes` VALUES ('96266000', '3', 'ENAEX S.A.', 'ENAEX', 'CARLOS SAEZ', '353518', 'AV. COSTANERA NORTE 300 PRILLEX AMERICA ', 'MEJILLONES ', 'FABRICACION Y VTA. DE EXP. INDUSTRIALES ');
INSERT INTO `clientes` VALUES ('776803790', '3', 'FAM AMERICA LATINA MAQUINARIA LTDA.', 'FAM', 'LUIS MUÃ‘OZ ', '09-88892026', 'AV. NUEVA TAJAMAR 481 TORRE NORTE OF. 703', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('99541860', '6', 'FE GARNDE MAQUINARIAS Y SERVICIOS ', 'FE GRANDE ', '', '416149', 'AV LAS PARCELAS 7950', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('81148200', '5', 'FERROCARRIL DE ANTOFAGASTA A BOLIVIA ', 'FERROCARRIL ', 'PAOLO ROCO ', '206537', 'BOLIVAR 255', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76931150', '5', 'FLC MONTAJES S.A.', 'FLC MONTAJES', 'LEOPOLDO ', '02-6241195', 'AV. AMERICO VESPUCIO 268 OF.55', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('61603000', '0', 'FONDO NACIONAL DE SALUD', 'FONASA ', 'NATALIA ', '656829', 'ANTONINO TORO 851', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('51064970', '2', 'FUNDACION EDUCACIONAL SAN LUIS DE LA COMPANIA DE JESUS ', 'COLEGIO SAN LUIS ', 'COLEGIO SAN LUIS', '467062-46', 'BAQUEDANO 855', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61004007', '1', 'GENDARMERIA DE CHILE DIRECCION GENERAL', 'GENDARMERIA ', '', '488124', 'AV GRECIA 2030', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('79634910', '7', 'GEO-OPERACIONES LTDA. ', 'GEO-OPERACIONES', '', '337311', 'PASAJE CEBOLLAR 1615', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('7794454', '2', 'GLOBALMAQ LTDA.', 'GLOBALMAQ', '', '488034', 'URUGUAY 651', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60511023', '1', 'GOBERNACION PROVINCIAL EL LOA ', 'GORE LOA ', '', '341293', 'GRANADEROS 2296', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('72224100', '2', 'GOBIERNO REGIONAL DE ANTOFAGASTA ', 'GOBIERNO REGIONAL', '', '357528', 'PRAT 384', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('9427783', '3', 'GUADALUPE CORTES NEIRA', 'ESANE ', '', '497663', 'MATTA2052', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61606203', '4', 'HOSPITAL DE TOCOPILLA', 'HOSPITAL TOCOPILLA ', 'CAROLINA GONZALEZ', '656270', 'AV. LEONARDO GUZMAN # 0705', 'TOCOPILLA', '');
INSERT INTO `clientes` VALUES ('69020300', '6', 'ILUSTRE MUNICIPALIDAD DE ANTOFAGASTA ', 'MUN. DE AFTA.', '', '358330', 'AV. SEPTIMO DE LINEA 3505', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('69253200', '7', 'ILUSTRE MUNICIPALIDAD DE SIERRA GORDA', 'MUN. SIERRA GORDA ', 'CELIA CASTILLO ', '641915', '', '', '');
INSERT INTO `clientes` VALUES ('69020100', '3', 'ILUSTRE MUNICIPALIDAD DE TOCOPILLA', 'MUN. TOCOPILLA', 'MARIO FLORES ', '426511', 'ANIBAL PINTO # 1305', 'TOCOPILLA', '');
INSERT INTO `clientes` VALUES ('76092002', '9', 'SOCIEDAD EDUCACIONAL KYRIOS S.A', null, 'COLEGIO NEWLAN', '222222', 'AV. PEDRO AGUIRRE CERDA # 8051', 'VENTA', '');
INSERT INTO `clientes` VALUES ('76012654', '4', 'INMOBILIARIA CENTRO MEDICO ANTOFAGASTA ', 'CLINICA ANTOFAGASTA ', 'PAOLA', '', 'MATTA 1945', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96621640', '9', 'INSTITUTO PROFESIONAL AIEP ', 'AIEP ', 'ANA MARIA ', '530691', 'LA TORRE 2528, LOCAL 1', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60511020', '7', 'DELEGACION PRESIDENCIAL REGIONAL DE ANTOFAGASTA', 'INTENDENCIA CONACE', 'INTENDENCIA II REGION', '552 461018', 'ARTURO PRAT # 384 PISO 2', 'ANTOFAGASTA', 'GOBIERNO');
INSERT INTO `clientes` VALUES ('13941385', '7', 'FLOR PEREZ ALARGON', null, 'FLOR ', '1111111111', 'AVDA,  GRECIA # 2569', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('77927080', '7', 'INVERSIONES DOSNORTE LTDA.', 'INVERSIONES DOS NORTE ', 'KAREN ', '490465', '14 DE FEBRERO 1822, 3 º PISO LOCAL 16', 'ANTOFAGASTA', 'INMOBILIARIA');
INSERT INTO `clientes` VALUES ('76794820', '4', 'INVERSIONES MARABIERTO LTDA.', 'INVERSIONES MARABIERTO', 'KAREN ', '490465', '14 DE FEBRERO 1822, 3 º PISO LOCAL 16', 'ANTOFAGASTA', 'INMOBILIARIA');
INSERT INTO `clientes` VALUES ('6445042', '5', 'ISABEL GODOY LETELIER', 'LA CASONA ', 'ISABEL', '450720', 'PUOPIN 1051', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('9956899', '4', 'JORGE TOLEDO ROMAN', 'JORGE TOLEDO ', 'JORGE TOLEDO ', '226655', 'ESMERALDA 1807 OF 501', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('70072600', '2', 'JUNTA NACIONAL DE JARDINES INFANTILES ', 'JUNJI', 'MARITZA', '265691', '', '', '');
INSERT INTO `clientes` VALUES ('77152830', '9', 'KAESER COMPRESORES DE CHILE LTDA.', 'KAESER ', '', '226978', 'CERRO PORTESUELO 9817 A', 'QUILICURA SANTIAGO', 'VENTAS ARRIENDOS COMPRESORES');
INSERT INTO `clientes` VALUES ('96845940', '6', 'KUNSA CONSULTORES S.A.', 'KUNSA ', '', '555912', 'AVELINO CONTARDO 932', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('17433594', 'K', 'LUIS EDUARDO BASTIAS VERA ', 'COLEGIO EBEN- EZER', '', '212919', 'FELIX GARCIA 920 CHIMBA ALTO ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('87682500', '7', 'MAESTRANZA DIESEL', 'MAESTRANZA DIESEL', '', '354900', 'JUAN GLASINOVIC # 485', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76182660', '3', 'MAESTRANZA EL SALAR LTDA.', 'MAESTRANZA EL SALAR', 'CINTHIA ', '419557', 'AV SALVADOR ALLENDE 561', 'ANTOFAGASTA', 'MAESTRANZA');
INSERT INTO `clientes` VALUES ('10857039', '3', 'MARIA TERESA RIVACOBA', 'MARIA TERESA RIVA¡COBA ', 'MARIA TERESA ', '297304', 'PEDRO AGUIRRE CERDA 9400 LOCAL 7', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61930500', '0', 'SEREMI MINVU II REGION ', 'MINVU', 'LEOPOLDO ', '454430', 'AV. ANGAMOS # 721', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61202000', '0', 'MOP DIRECCION DE VIALIDAD', 'MOP', '', '422067', '21 DE MAYO # 470, 3 º PISO ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('78790740', '7', 'NORTERRA Y CIA. LTDA.', 'NORTERRA', '', '220202', 'SITIO 2, KM 12', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('95467000', '7', 'ORICA CHILE S.A.', 'ORICA', '', '565600', 'ROSARIO NORTE # 530 PISO 9', 'LAS CONDE SANTIAGO ', '');
INSERT INTO `clientes` VALUES ('99545610', '9', 'POZOS PROFUNDOS S.A.', 'POZOS PROFUNDOS', '', '02-7335520', 'LOS ARRAYANES # 650 ', 'COLINA SANTIAGO', 'CONSTRUCCION DE SONDAJE');
INSERT INTO `clientes` VALUES ('61002008', '9', 'REGISTRO CIVIL', 'REGISTRO CICIL', '', '221031', 'BOLIVAR # 250', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('81537600', '5', 'RENDIC HNOS S.A.', 'RENDIC Y HNOS.', 'NATALIA ', '259559', 'AV. DEL VALLE # 537', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('9231948', '2', 'RICARDO LAZCANO', 'CASINO RIVER', 'RICARDO LAZCANO', '378596', 'TARAPACA 4651', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76549440', '0', 'SANTA MARTA SERVICIOS Y MONTAJES', 'SANTA MARTA ', '', '492500', 'BALACEDA 2536', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60103000', '2', 'SERPLAC', 'SERPLAC', 'PLABLO LEITON', '449353', 'ARTURO PRAT # 384', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60803000', 'K', 'SERVICIO DE IMPUESTOS INTERNOS', 'SII', '', '658506', 'MANUEL ANTONIO MATTA # 2630', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61606200', 'K', 'SERVICIO DE SALUD ANTOFAGASTA ', 'SERVICIO DE SALUD', 'FELIX', '655392', 'BOLIVAR # 523', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60701011', '0', 'SERVICIO NACIONAL DE PESCA ', 'SERNAPESCA ', '', '556232', 'AV ARGENTINA 2560', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60704000', '1', 'SERVICIO NACIONAL DE TURISMO ', 'SERNATUR', '', '451818', 'ARTURO PRAT # 384, 1 º PISO ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61814000', '8', 'SERVIU II REGION', 'SERVIU', 'FERNANDP SANCHEZ', '415150', 'PJE. LA FRONTERA # 110', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('59090630', '1', 'SICE AGENCIAS CHILE S.A.', 'SICE', 'NELSON CASTILLO ', '503317', 'AV. ANDRES BELLO # 2777, OF 702', 'LAS CONDE SANTIAGO ', '');
INSERT INTO `clientes` VALUES ('79705403', '5', 'SIEC LTDA.', 'SIEC', '', '273858', 'RADOMIRO TOMIC # 7245', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('88417000', '1', 'SKY SERVICE S.A.', 'SKY', '', '459090', 'SANTA ELENA 1761 ', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('65152162', '9', 'FUNDACION EDUCACIONAL COLEGIO SAN AGUSTIN', 'SAN AGUSTIN', 'COLEGIO SAN AGUSTIN', '537615', 'LOS PIMIENTOS 07 LAS ROCAS', 'ANTOFAGASTA', 'ESTABLECIMIENTOS DE ENSENANZA PRIMARIA');
INSERT INTO `clientes` VALUES ('76148340', '4', 'SOCIEDAD EDUCACIONAL COLEGIO SAN PATRICIO ', 'COLEGIO SAN PATRICIO ', '', '480972-889920', 'SANTIAGO HAMBERTONE 220', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('79783050', 'K', 'SOCIEDAD EDUCACIONAL MAGISTER LTDA.', 'SAN ESTEBAN ', 'MONICA', '537614', '14 DE FEBRERO # 2212', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76013849', '5', 'SUMINCO EIRL', 'SUMINCO ', '', '775145', 'PASAJE PUNTA DE RIELES 9403', 'ANTOFAGASTA', 'COMERCIALIZADORA');
INSERT INTO `clientes` VALUES ('78510320', '3', 'THE KING LANGUAJE INSTITUTE', 'THE KING LANGUAJE INSTITUTE', 'MANUEL', '268262', 'GALLEGUILLOS LORCA 1594', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('79826770', '1', 'VISION', 'VISION', 'GENARO CLAPS', '342565', 'PASEO RAMIRES', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('8480132', '1', 'WILLIAM COLLAO CRUZ', 'COLEGIO ALEMAN ', '', '782312', 'URIBE 1161', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76201140', '9', 'RIVADENEIRA Y COMPAÑÍA LTDA.', 'MISTER FOOD', null, '768371', 'LLANQUIHUE #3749', 'ANTOFAGASTA', 'SERVICIO ALIMENTACION');
INSERT INTO `clientes` VALUES ('92011000', '2', 'SHELL CHILE S.A.C.I', 'SHELL', null, '228152', 'IQUIQUE # 5186', 'ANTOFAGASTA', null);
INSERT INTO `clientes` VALUES ('9670942', '0', 'MONTEC LTDA.', null, 'MONTEC', '02-7130300', 'SAN PIO #2460, OF. 1007', 'PROVIDENCIA - SANTIAGO', '');
INSERT INTO `clientes` VALUES ('78863090', '5', 'SOCIEDAD  EDUCACIONAL INMA LTDA.', null, 'COLEGIO ANTONIO RENDIC', '055-537723-18', 'AV. UNIVERSIDAD DE AFTA NÂ° 02700', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('69020400', '2', 'ILUSTRE MUNICIPALIDAD DE MEJILLONES', null, 'MUNICIPALIDAD DE MEJILLONES', '55-2621571', 'FCO. ANTONIO PINTO NÂ° 200', 'MEJILLONES', '');
INSERT INTO `clientes` VALUES ('60109000', '7', 'FONDO DE SOLIDARIDAD E INVERCION SOCIAL', null, 'FOSIS', '450124', 'SAN MARTIN #2298', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96808790', '8', 'SOUTHERNROCK GEOPHYSICS SA', null, 'ZONGE', '268096', 'EDUARDO ORCHA # 1351', 'ANTOFAGASTA', 'INGENIERIA Y GEOFISICA');
INSERT INTO `clientes` VALUES ('81426700', '8', 'LLORENTE INDUSTRIAL S.A.', null, 'LLORENTE', '81634565', 'BARRIO INDUSTRIAL SITIO NÂº 6 ', 'VALLENAR', '');
INSERT INTO `clientes` VALUES ('76942490', '3', 'KORLAET Y JARA CONSTRUCCION, OBRAS Y MONTAJES S.A.', null, 'KORLAET Y JARA', '262655', 'JOSE SANTOS OSSA #2445', 'ANT6FAGASTA', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('11111111', '1', 'CARABINEROS DE CHILE', null, 'CARABINEROS', '133', 'SAN MARTIN', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76044303', '4', 'MAT CONSTRUCCION LTDA.', null, 'MAT CONSTRUCCION', '055-555843', 'MATIAS ROJAS # 1642', 'ANTOFAGASTA', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('99526550', '8', 'FERROVIAL S.A.', null, 'FERROVIAL S.A.', '84336139', 'Ruta cobre 428', 'ANTOFAGASTA', 'transporte ');
INSERT INTO `clientes` VALUES ('6601931', '4', 'RICARDO EMILIO', null, 'RICARDO EMILIO', '975680953', 'Av cerro paranal 210 depto 121 edf trancura', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('17434040', '4', 'DANIEL ORTIZ', null, 'DANIEL ORTIZ', '976593623', 'SANTA BARBARA 02342 ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('79626800', 'K', 'SQM SALAR S.A', null, 'SQM SALAR .SA', '02-4252001', 'LOS MILITARES # 4290', 'LAS CONDES SANTIAGO', 'EXPLOTACION DE MINAS Y CANTERAS N.C.P');
INSERT INTO `clientes` VALUES ('15417520', '2', 'JUAN CASARES', null, 'CONMIGO AHORRAS', '02-2710765', 'SANTIAGO', 'SATIAGO', '');
INSERT INTO `clientes` VALUES ('76125852', '4', 'SERVICIOS BROMATOLOGICOS DEL NORTE LTDA.', null, 'BRONOR LTDA.', '936840', 'MAXIMILIANO POBLETE #596', 'ANTOFAGASTA ', '');
INSERT INTO `clientes` VALUES ('13632833', '6', 'LAURA ALFARO', null, 'LAURA ALFARO', '055-342912', 'MAIPU 2825 POBL. ALEMANIA', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('70385000', '6', 'COLEGIO JUAN PABLO II', null, 'COLEGIO JUAN PABLO II', '555555', 'SIMON BOLIVAR #1890', 'CALAMA    ', '');
INSERT INTO `clientes` VALUES ('76511550', '7', 'SOCIEDAD COMERCIAL LABONORT LTDA.', null, 'LABONORT', '777000', 'DAGOBERTO GODOY #6996', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('71541900', '9', 'UNIVERSIDAD PEDRO DE VALDIVIA SEDE ANTOFAGASTA ', null, 'UNIVERSIDAD PEDRO DE VALDIVIA', '450140', 'CARRERA #1725', 'ANTOFAGASTA ', 'EDUCACION');
INSERT INTO `clientes` VALUES ('89629300', '1', 'Videocorp S.A', null, 'Videocorp S.A', '2345634', 'San Crescente 240 Las ', 'Condes, Santiago', '');
INSERT INTO `clientes` VALUES ('76206541', 'K', 'AKD INTERNATIONAL CHILE S.A.', null, 'AKD', '73750781', 'LOS TOPACIOS 543 ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('99514800', '5', 'CNC INVERSIONES S.A.', null, 'CANAL 95', '289595', 'COPIAPO #886', 'ANTOFAGASTA', 'RADIO');
INSERT INTO `clientes` VALUES ('76105206', '3', 'TECNOLOGIAS INDUSTRIALES BUILDTEK S.A.', null, 'BUILDTEK', '055-592647', 'AV. MONSEÃ‘OR FRANCISCO GILL,MORE # 9180', 'ANTOFAGASTA', 'FABRICACIO, IMPORTACION, EXPORTACION Y COMERCIALIZACION');
INSERT INTO `clientes` VALUES ('96896290', '6', 'DISTRINOR S.A.', null, 'DISTRINOR', '55-642940', 'ROMULO PEÃ‘A #4080', 'ANTOFAGASTA', 'DISTRIBUCIONES DE GAS');
INSERT INTO `clientes` VALUES ('77393120', '8', 'SERVICIOS GASTRONOMICOS CASINOS RIVER LTDA', null, 'CASINO RIVER', '2260670', 'TARAPACA #4651', 'ANTOFAGASTA', 'SERVICIOS ALIMENTACION INDUSTRIAL');
INSERT INTO `clientes` VALUES ('76137208', '4', 'INTEM LTDA.', null, 'INTEM', '893408', 'AVDA. PEDRO AGUIRE CERDA #8360', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('78791070', 'K', 'SERCABOL LTDA.', null, 'SERCABOL', '267575', 'AVDA. MATTA # 1839', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76217844', '3', 'LABONORT SALUD INTEGRAL LTDA.', null, 'LABONORT SALUD', '370400', 'JOSE SANTOS OSSA #2213 PISO 1 Y 2', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96592740', '9', 'SHNEIDER ELECTRIC CHILE SA', null, 'SHNEIDER', '55-893969', 'Edificio Msckenzie Bernando O\'higgins 1338 piso 6', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('78451050', '6', 'UNITED SISTEMA DE TUBERIAS LTDA', null, 'UNITED SISTEMA DE TUBERIAS LTDA', '2492005', 'PUERTA DEL SOL NÂ°55 OF.111', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('73297300', '1', 'FUNDACION MINERA ESCONDIDA', null, 'CREO ANTOFAGASTA', '1111111', 'AV. BERNARDO O`HIGGINS #1280', 'ANTOFAGASTA', 'SIN FINES  DE LUCRO');
INSERT INTO `clientes` VALUES ('76141325', '2', 'LA CONCEPCION LTDA.', null, 'FABIOLA FLORES VARAS', '2933936', 'AVDA. ARGENTINA #2476', 'ANTOFAGASTA', 'EXTRACCION DE COBRE');
INSERT INTO `clientes` VALUES ('95431000', '0', 'SERVICIOS Y ABASTECIMIENTOS-CLINICA', null, 'CLINICA ANTOFAGASTA', '(55) 2-468434', 'MATTA # 1868 PISO 3', 'ANTOFAGASTA ', 'SALUD');
INSERT INTO `clientes` VALUES ('77305800', '8', 'CONSTRUCTORA MIRANDA LTDA.', null, 'ECOMI LTDA.', '771581', 'GALLEGUILLOS LORCA #676 DPTO. 202', 'ANTOFAGASTA', 'CONSTRUCTORA');
INSERT INTO `clientes` VALUES ('61105000', '3', 'FABRICAS Y MAESTRANZAS DEL EJERCITO', null, 'FAMAE', '26718146', 'AV. EJERCITO #353', 'SANTIAGO', 'MAESTRANZA');
INSERT INTO `clientes` VALUES ('88918500', '7', 'AUTOS YUSIC LTDA.', null, 'DERCO', '2112131', 'EDMUNDO PEREZ ZUJOVIC 6274', 'ANTOFAGASTA', 'AUTOMOTRIZ');
INSERT INTO `clientes` VALUES ('83484700', '0', 'REIFOX INDUSTRIAL LTDA.', null, 'REIFOX', '222222222', 'AVDA. AMERICO VESPUCIO 2101', 'RENCA- SANTIAGO', 'FABRICA DE PRODUCTOS PLASTICOS');
INSERT INTO `clientes` VALUES ('76270424', '2', 'ENERGIA EOLICA CJR WIND CHILE LTDA.', null, 'EOLICA CHILA', '56-2-22430403', 'DOCTOR BARROS BORGOÃ‘O #246', 'PROVIDENCIA - SANTIAGO', 'CONSTRUCCION Y GESTION  DE PARQUES EOLICOS  Y FOTOVOLTAICOS');
INSERT INTO `clientes` VALUES ('76050301', '0', 'BERLIAM SPA', null, 'INSER', '0', 'JOSE TORIBIO MEDINA 094 101 Playa Blanca', 'ANTOFAGASTA', 'ACTIVIDADES DE CONSULTORIA DE GESTION ');
INSERT INTO `clientes` VALUES ('76853500', '0', 'SOCIEDAD GONZALEZ MUNOZ LTDA.', null, 'SGM LTDA.', '552838009', 'LOS MANZANOS #8398', 'ANTOFAGASTA', 'TRASPORTES DE CARGA TRASPORTE DE PASAJERO ASEO');
INSERT INTO `clientes` VALUES ('11872506', '9', 'JUAN SANTIAGO TREUER MOYA', null, 'NOTARIA JUAN TREUER MOYA', '11111111', 'CALLE COLON # 1281', 'TOCOPILLA', '');
INSERT INTO `clientes` VALUES ('77797920', '5', 'AQUA TERRA INGENIEROS LTDA.', null, 'AQUA TERRA', '28934675/93077732', 'HERNAN CORTES #2362, Ã‘UÃ‘OA', 'SANTIAGO', 'ASESORIA EN INGENIERIA CIVIL');
INSERT INTO `clientes` VALUES ('76625330', 'k', 'AGGREKO CHILE LTDA.', null, 'AGGREKO CHILE LTDA.', '2-24723934/ 55-2712400', 'AV. GALVARINO #9450 P.I BUENAVENTURA', 'QUILICURA, SANTIAGO CHILE', 'ARRIENDO DE GENERADORES ELECTRICOS');
INSERT INTO `clientes` VALUES ('77650710', '5', 'INTEGRACION DIGITAL OMEGA S.A', null, 'OMEGA SYSTEM', '055-2417170', 'GALLEGUILLOS LORCA #1406', 'ANTOFAGASTA', 'SERVICIOS');
INSERT INTO `clientes` VALUES ('76307633', '4', 'LB LTDA. MONTAJE Y SERVICIOS MINEROS', null, 'LB LTDA.', '85968458', 'LOS CONQUISTADORES # 13936', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96917120', '1', 'TECNICA NACIONAL SERVICIOS INGENIERIA Y CONSTRUCCION S.A.', null, 'TECNASIC', '24833800', 'CARLOS  JUSTICIANO # 1161, PROVIDENCIA', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('78915940', '8', 'ENFASIS PUBLICIDAD VISUAL LTDA', null, 'MADERO', '219020-498235', 'CHANARCILLO #528 OF 2', 'COPIAPO', 'PUBLICIDAD');
INSERT INTO `clientes` VALUES ('76077994', '6', 'SOCIEDAD LEM LABORATORIOS Y ASISTENCIA TECNICA LTDA', null, 'LEM', '55-2955629', 'BALMACEDA 3702', 'COPIAPO', 'ENSAYOS DE MATERIALES, CALIBRACION DE EQUIPOS Y ASESORIAS');
INSERT INTO `clientes` VALUES ('76155777', '7', 'CARLOS CARVAJAL OSSADON INGENIERIA METALMECANICA EIRL ', null, 'ONLYSOLUTIONS', '65885675|', 'URUGUAY #730', 'ANTOFAGASTA', 'INGENIERIA Y SERVICIOS PARA LA MINERIA');
INSERT INTO `clientes` VALUES ('78104070', '3', 'ASESORIA DE FORMACION PROFESIONAL Y SERVICIOS DE CAPACITACION LIMITADA', null, 'AS Y C LTDA', 'EXTERNO', 'ANTONIO POUPIN 1236', 'ANTOFAGASTA', 'OTROS SERVICIOS DE ENSAYOS Y ANALISIS');
INSERT INTO `clientes` VALUES ('76138505', '4', 'COMERCIAL CAMARO LTDA', null, 'EXTERNA', '65972947', 'JORGE WASHINTONG 2562 OF 309', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77939000', '4', 'SOCIEDAD CHILE ENGINEERING LTDA', null, 'SOC CHILE ENGINEERING LTDA', '0552210988', 'DIEGO BARRIOS ARENA 5478', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('22764028', '6', 'DANIEL MICHELL PIBARQUE CAICEDO', null, 'DANIEL', '81292948', 'TOCONAO 522A', 'SAN PEDRO ATACAMA', '');
INSERT INTO `clientes` VALUES ('11820509', 'K', 'PAULA MADRID MOLINA', null, 'PAULA MADRID', '77586312', 'NICANOR PLAZA 1070', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76037556', 'K', 'AVAL CHILE S.A.G.R.', null, 'AVAL CHILE', '82596637', 'CERRO EL PLOMO 5420', 'LAS CONDES SANTIAGO', '');
INSERT INTO `clientes` VALUES ('15021769', '5', 'JAVIER ANDRES SOTO BUZETA', null, 'JAVIER SOTO', '74791223', 'SUCRE 359', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('94879000', '9', 'SANDVIK CHILE S.A.', null, 'SANDVIK', '75691332', 'AVDA EDO FREI M 9990', 'CONCHALI SANTIAGO', '');
INSERT INTO `clientes` VALUES ('96828740', '0', 'WSP SERVICIOS POSTALES SA', null, 'WSP SERVICIOS POSTALES', '974081403', 'AV. MARATHON 3702', 'MACUL SANTIACO', '');
INSERT INTO `clientes` VALUES ('91426000', '0', 'TECHINT CHILE SA', null, 'TECHINT', '22222222', 'CERRO EL PLOMO 5420', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('80207900', '1', 'CLARO VICUNA VALENZUELA SA', null, 'CLARO VICUNA VALENZUELA', '63941363', 'AV CERRO EL PLOMO 5420', 'LAS CONDES SANTIAGO', 'CONSTRUCCION Y OBRAS CIVILES EN GENERAL');
INSERT INTO `clientes` VALUES ('76176613', '9', 'LICANCABUR SERVICIOS LTDA', null, 'LICANCABUR', '55-2543564', 'ANTONIO POUPIN 839 OF 204', 'ANTOFAGASTA', 'SERVICIOS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('76121841', '7', 'DIGITAL SERVICE CC', null, 'DIGITAL SERVICE CC', '2774040', 'GALLEGUILLOS LORCA 1474', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76204669', '5', 'COLEGIO ANTOFAGASTA SPA', null, 'COLEGIO ANTOFAGASTA', '552565177', 'AV ASCOTAN SUR N 220', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96777070', '1', 'TECNO FAST ATCO SA', null, 'TECNO FAST', '552551370', 'LA MONTAÃ‘A 662', 'QUILICURA SANTIAGO', '');
INSERT INTO `clientes` VALUES ('10487973', 'K', 'GONZALO MARTIN HURTADO PERALTA', null, 'GONZALO HUERTADO', '552228105', 'SAN MARTIN 2745', 'ANTOFAGASTA', 'NOTARIA');
INSERT INTO `clientes` VALUES ('13011790', '2', 'IRMA ELENA SOTO MONDACA', null, 'VISION ', '82290455', 'PEDRO AGUIRRE CERDA 9400', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77254640', '8', 'INDUSTRIAL SAVE LTDA', null, 'INDUSTRIAL SAVE', '98290375', 'RADOMIRO TOMIC 8331', 'ANTOFAGASTA', 'REPRESENTACIONES Y FABRICACION INDUSTRIAL');
INSERT INTO `clientes` VALUES ('76052745', '9', 'MAESTRANZA E INGENIERIA DEL NORTE LTDA', null, ' MAESTRANZA DEL NORTE', '2418210', 'RADOMORIO TOMIC 8323', 'ANTOFAGASTA', 'OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('77412250', '8', 'TODOPC M Y J LTDA', null, 'TODO PC', '552362802', 'VIVAR 1911', 'CALAMA', 'VENTA DE EQUIPOS COMPUTACIONALES ');
INSERT INTO `clientes` VALUES ('15019073', '8', 'MAQUINAS ELIMINADAS DE INVENTARIO', null, 'MAQUINAS ELIMINADAS DE INVENTARIO', '0552774040', 'GALLEGUILLOS LORCA 1474', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('15690929', '7', 'JEAN PIERE SOUBLETTE', null, 'JEAN PIERE SOUBLETTE', '0552774040', 'GALLEGUILLOS LORCA 1474', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76409216', '3', 'MEDINORT SALUD OCUPACIONAL E INTEGRAL S.A.', null, 'MEDINOR', '2370400 - 2370399', 'JOSE SANTOS OSSA #2213', 'ANTOFAGASTA', 'CENTRO MEDICO, LABORATORIO, VACUNATORIO');
INSERT INTO `clientes` VALUES ('76179538', '4', 'SOCIEDAD CONCESIONARIA AEROPUERTO DE ANTOFAGASTA', null, 'AEROPUERTO DE ANTOFAGASTA', '2254998', 'AVDA. VITACURA 2736 PISO 3 OF 302 ', 'LAS CONDES - SANTIAGO', 'EXPLOTACION DE CONCESIONES');
INSERT INTO `clientes` VALUES ('17723828', '7', 'INVERSIONES Y SERVICIOS DIGITALES SPA', null, 'INVERSIONES Y SERVICIOS DIGITALES', '55-2774040', 'GALLEGUILLOS LORCA 1474', 'ANTOFAGASTA', 'FOTOCOPIADORA');
INSERT INTO `clientes` VALUES ('8292366', '7', 'FREDY PIZARRO DIAZ', null, 'FREDY PIZARRO', '65866136/552815390', 'TENIENTE MERINO #1185', 'TOCOPILLA', 'SERVICIOS VARIOS');
INSERT INTO `clientes` VALUES ('13643530', '2', 'JUAN PABLO FLORES HUERTA', null, 'JUAN PABLO FLORES HUERTA', '98271489', 'WASHINTONG #2675, EDIF. CENTENARIO PISO 14 OF. 1402', 'ANTOFAGASTA', 'ABOGADO');
INSERT INTO `clientes` VALUES ('61008000', '6', 'SERVICIO NACIONAL DE MENORES', null, 'SENAME', '22511357', 'CALLE 2 MANZANA I SECTOR LA CHIMBA', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('90146000', '0', 'SERVICIOS FINANCIEROS PROGRESO S.A.', null, 'PROGRESO', '224402375', 'MIRAFLORES 222 PISO 25-26', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('65021425', '0', 'COMUNIDAD EDIFICIO ALTOS DEL SUR', null, 'EDIFICIO ALTOS DEL SUR', '55-2939241', 'AV ARGENTINA #1683', 'ANTOFAGASTA', 'COMUNIDAD HABITACIONAL');
INSERT INTO `clientes` VALUES ('99549130', '3', 'CLINICA CUMBRES DEL NORTE S.A.', null, 'CLINICA CUMBRES', '2450600', 'SAN MARTIN 2447', 'ANTOFAGASTA', 'SALUD');
INSERT INTO `clientes` VALUES ('76120463', '7', 'TEGNOLOGIA Y SUMINISTROS PROCESOS MINEROS', null, 'TEGNOLOGIA Y SUMINISTROS PROCESOS MINEROS', '2955586', 'FRANCISCO VERGARA # 853 OLIVAR', 'ANTOFAGASTA', 'COMERCIALIZADORA ');
INSERT INTO `clientes` VALUES ('96757750', '2', 'PIPESA S.A.', null, 'PIPESA', '227336112', 'AGUSTINAS #1022 OF.1026', 'SANTIAGO', 'INGENIERÃA Y CONSTRUCCION');
INSERT INTO `clientes` VALUES ('70791800', '4', 'UNIVERSIDAD DE ANTOFAGASTA', null, 'UNIVERSIDAD DE ANTOFAGASTA', '055 2637225', 'AV ANGAMOS 0601', 'ANTOFAGASTA', 'ENSENANZA SUPERIOR');
INSERT INTO `clientes` VALUES ('5735196', '9', 'JULIO ALEJANDRO ENRIQUE ABASOLO ARAVENA', null, 'JULIO ABASOLO', '2497279', 'WASHINGTON 2653', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('70995200', '5', 'UNIVERSIDAD CENTRAL DE CHILE', null, 'UNIVERSIDAD CENTRAL', '02-5826000', 'TOESCA 17', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('96538130', '9', 'CONSTRUCCIONES Y PAVIMENTOS LTDA', null, 'CONSTRUCCIONES Y PAVIMENTOS LTDA', '75286283', 'LOS MILITARES 5885 OF 601 PISO 6', 'SANTIAGO', 'INGENIERIA Y CONSTRUCCIONES');
INSERT INTO `clientes` VALUES ('5554286', '4', 'JUAN LINARES', null, 'JUAN LINARES', '98867494', 'ANTONIO RENDIC 4530', 'antofagasta', '');
INSERT INTO `clientes` VALUES ('76079669', '7', 'MINERA ANTUCOYA', null, 'MINERA ANTUCOYA', '227985626', 'AVENIDA GRECIA NÂ° 750', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60703000', '6', 'INSTITUTO NACIONAL DE ESTADISTICAS', null, 'INSTITUTO NACIONAL DE ESTADISTICAS', '55-2269112', 'JOSE MIGUEL CARRERA NÂ°1701 PISO 5Â°', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61979930', '5', 'SUBSECRETARIA DE MEDIO AMBIENTE', null, 'SUBSECRETARIA DE MEDIO AMBIENTE', '55 2268200', 'SAN MARTIN 73', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77134310', '4', 'EXPLORA LTDA', null, 'EXPLORA LTDA', '97897349', 'TRUMAO 1281 A', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('7640567', '0', 'JAVIER MOLINA', null, 'JAVIER MOLINA', '942680679', 'TRUMAO 1100 DEPTO 72 COVIEFI', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('16209287', '1', 'JUAN ANDRES RIVEROS DONOSO', null, 'JUAN ANDRES RIVERO DONOSO', '55 2 2893145', 'CALLE COLON #1281', 'TOCOPILLA', 'NOTARIA');
INSERT INTO `clientes` VALUES ('76464003', '9', 'SOCIEDAD EDUCACIONAL SAN MARCOS SPA', null, 'SOC. EDUCACIONAL SAN MARCOS', '942208669', 'LOS EXPLORADORES #13930', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('76495040', '2', 'AKASA SPA', null, 'AKASA SPA', '552220486', 'ANTONIO POUPIN 839 EDF. OFIC. DEL PARQUE NÂ°102', 'ANTOFAGASTA', 'INGENIERIA, PROYECTOS INNOVACION');
INSERT INTO `clientes` VALUES ('8215914', '2', 'MARIA SOLEDAD LASCAR MERINO', null, 'NOTARIA LASCAR', '552389779', 'PRAT 482 OF 25', 'ANTOFAGASTA', 'NOTARIA');
INSERT INTO `clientes` VALUES ('76084407', '1', 'CONSTRUCTORES E INMOBILIARIA GRAF LTDA', null, 'CONSTRUCTORES E INMOBILIARIA GRAF', '999591936', 'BLANCA ESTELA #1505 DEPTO 5423', 'CON CON VALPARAISO', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('76305905', '7', 'CRISTIAN OMAR ALBERTO VALDERRAMA CERECEDA PUBLICIDAD GRAFICA E.I.R.L.', null, 'PUBLICIDAD GRAFICA ', '982461253', 'SARITA ORTIZ #10323 VILLA ESPERANZA', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77794540', '8', 'SMG INGENIERIA SOCIEDAD ANONIMA ', null, 'SMG', '55-2893463', 'CASTRO #5359', 'ANTOFAGASTA', 'SERVICIO A LA MINERIA');
INSERT INTO `clientes` VALUES ('13869531', 'K', 'CRISTIAN MIGUEL OGALDE MESSINA', null, 'CRISTIAN OGALDE', '988277965', 'BAQUEDANO 239 OFINA 519', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('60400000', '9', 'CONTRALORIA GENERAL DE LA REPUBLICA', null, 'CONTRALORIA', '5652119', 'TEATINO 56 PISO 6', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('78048910', '3', 'TRANSPORTE POR CARRETERA', null, 'TRANSPORTE POR CARRETERA', '996999499', 'HUAMACHUCO 10541', 'Antofagasta', '');
INSERT INTO `clientes` VALUES ('76229725', '6', 'COMERCIALIZADORA ARGEO CHIL LTDA', null, 'COMERCIALIZADORA ARGEO CHIL LTDA', '949262226', 'ANTONIA LOPEZ DE BELLO 244', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76293630', '5', 'MAT CONSTRUCCION EIRL', null, 'MAT CONSTRUCCION ', '990156385', 'REBECA MATTE 1061', 'antofagasta', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('77242290', '3', 'SOCIEDAD RIOS', null, 'SOCIEDAD RIOS', '2461213', 'IQUIQUE # 7272', 'antofagasta', '');
INSERT INTO `clientes` VALUES ('91947000', '3', 'SIKA CHILE S.A', null, 'SIKA CHILE S.A.', 'SIN TELEFONO', 'SALVADOR ALLENDE 085 SAN JOAQUIN', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('78459770', '9', 'LEPPE Y LEPPES ABOGADOS LTDA', null, 'LEPPE Y LEPPES ABOGADOS LTDA', '55-2380800', 'PRAT 214 OF 507', 'ANTOFAGASTA', 'SERVICIOS JURIDICOS.');
INSERT INTO `clientes` VALUES ('96596370', '7', 'CULTIVOS HIDROBIOLOGICOS Y BIOTECNOLOGIA AGUAMARIANA S.A', null, 'AGUA MARINA', '5522892851', 'LAS COLONIAS 580', 'ANTOFAGASTA', 'CULTIVO, REPRODUCCION Y CRECIMIENTO');
INSERT INTO `clientes` VALUES ('70265000', '3', 'CORP DE DESARROLLO SOCIAL DEL SECTOR RURAL', null, 'CODESER', '225853300', 'TENDERINI 187 ROL 73-22', 'SANTIAGO', 'OTROS CULTIVO NCP');
INSERT INTO `clientes` VALUES ('10751916', '5', 'DANIEL VEGA', null, 'DANIEL VEGA', '991386090', 'ANTONINO  TORO', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('10772953', '4', 'SANDRA GLADYS VALLADARES DIAZ', null, 'SANDRA GLASYS VALLADARES DIAZ', '2345678', 'MAIPU 467 CENTRO', 'antofagasta', 'COMERCIO DE ARTICULOS DE SUMINISTROS ');
INSERT INTO `clientes` VALUES ('77162800', '1', 'ELECTROMECANICA FLORES LTDA', null, 'ELECTROMECANICA', '552 293552', 'EL YODO 7915', 'ANTOFAGASTA', 'PREPARACION DEL TERRENO, EXCAVACIONES');
INSERT INTO `clientes` VALUES ('76225892', '7', 'SOLUCIONES PREFABRICADAS A LA MINERIA SPA', null, 'SOLPREMIN', '232323232323', 'LOS TOPACIOS MZ 14 ST 6 LA CHIMBA', 'ANTOFAGASTA', 'FABRICACION DE OTROS PRODUCTOS MINERALES ');
INSERT INTO `clientes` VALUES ('76063521', '9', 'INSECAP SPA', null, 'INSECAP SPA', '992775266', 'COBIJA 2498 V. ASCOTAN ', 'CALAMA', 'EDUCACION EXTRAESCOLAR (ESCUELA DE C)');
INSERT INTO `clientes` VALUES ('76145047', '6', 'SCHWAGER SERVICE S.A.', null, 'SCHWAGER', '944316143', 'ABANDERADO JOSE IGNACIO IBITA 080', 'RANCAGUA-SANTIAGO', '');
INSERT INTO `clientes` VALUES ('76275386', '3', 'MALVE LTDA', null, 'MALVE LTDA', '62078455', 'WASHINGTON 2562, OF 309', 'ANTOFAGASTA', 'OBRAS MENORES');
INSERT INTO `clientes` VALUES ('9667377', '9', 'CLAUDIO SALVADOR', null, 'CLAUDIO SALVADOR', '956391388', 'LA TORRE 1520 MEJILLONES', 'ANTOFAGASTA', 'NOTARIA');
INSERT INTO `clientes` VALUES ('99564360', 'K', 'BESALCO MD MONTAJES', null, 'BESALCO', '23847936', 'AV TAJAMAR 183, OF. 101', 'LAS CONDES, SANTIAGO', '');
INSERT INTO `clientes` VALUES ('12348211', '5', 'ALAN SUAZO', null, 'ALAN SUAZO', '966085875', 'CUATRO ORIENTE 2814 CALAMA', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('16133899', '0', 'MIGUEL NIEVAS', null, 'MIGUEL NIEVAS', '944394928', 'BAQUEDANO 239 OFICINA 317', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('15514339', '8', 'JHON CONTRERAS ', null, 'JHON CONTRERAS ', '88374715', 'PASAJE RIO PALENA 839', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('6593783', '2', 'PEDRO ACEVEDO', null, 'PEDRO ACEVEDO', '956071553', 'TRAVESIA DE LA COSTA03572', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('16435864', 'K', 'DANILO PEDAMONTE ', null, 'DANILO PEDAMONTE ', '63432200', 'QUEBRADA SERRANO 1352', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('12107547', '4', 'KATHERINE SOTO HENRIQUEZ', null, 'KATHERINE SOTO HENRIQUEZ', ' 99997788', 'SERRANO 530', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('33333333', '3', 'DEVOLUCION INSUMOS', null, 'DEVOLUCION INSUMOS', '55 2286061', 'GALLEGUILLOS LORCA 1474 PISO 2', 'ANTOFAGASTA', 'FOTOCOPIAS');
INSERT INTO `clientes` VALUES ('76456068', 'K', 'MJS OBRAS CIVILES ', null, 'MJS OBRAS CIVILES ', '963537593', 'PATRIA NUEVA 3378', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('12867333', '4', 'VICTOR NUNEZ', null, 'VICTOR NUNEZ', '74301924', 'BAQUEDANO751', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96711590', '8', 'MANANTIAL S.A.', null, 'MANANTIAL S.A.', '82222222', 'AV. PEDRO AGUIRRE CERDA 6420 ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76162391', '5', 'M3C TRANSEGURO EIRL', null, 'M3C TRANSEGURO EIRL', '55-2546519', 'ANTONINO TORO1357', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('65102261', '4', 'FUNDACION EDUCACIONAL ARNALDO SALAMANCA CID', null, 'FUNDACION EDUCACIONAL ARNALDO SALAMANCA CID', '55-2569400', '14 DE FEBRERO 2784', 'ANTOFAGASTA', 'SERVICIOS PERSONALES DE EDUCACION');
INSERT INTO `clientes` VALUES ('82200000', '2', 'CAMARA DE COMERCIO, SERVICIO Y TURISMO DE ANTOFAGASTA A.G.', null, 'CAMARA DE COMERCIO', '552225175 - 552222053', 'LATORRE 2580, OF 21', 'ANTOFAGASTA', 'ASOSIACION GREMIAL');
INSERT INTO `clientes` VALUES ('59190140', '0', 'KALAM CHILE S.A', null, 'KALAM CHILE S.A', '99456250', 'LASTENIA 11850', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('22100658', '5', 'EDILBERTA CARRILLO ISCARRA', null, 'EDILBERTA CASTILLO ISCARRA', '552281447', 'MAIPU 916', 'ANTOFAGASTA', 'ALMACENES MEDIANOS');
INSERT INTO `clientes` VALUES ('76185799', '1', 'SAGITA CONSULTORA EN RIESGO QUIMICO E INDUSTRIAL SPA', null, 'SAGITA SPA', '55-2667912', 'AVDA. RODOMIRO TOMIC #7421 LOCAL 1-2', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76950750', '7', 'SES EIRL', null, 'SES EIRL', ' 2832988', 'AV PRAT 1975A POBLACION OHIGGINS ', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('76266064', '4', 'COBRA NORTE ', null, 'COBRA NORTE ', '50176661', 'ANTONIO POUPIN 1427', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76350545', '6', 'PASTELERIA VANILIA', null, 'PASTELERIA VANILIA', '552834952', 'ANTONIO POUPIN 949', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('78782700', '4', 'TRANSPORTE ILZAUSPE LTDA', null, 'TRANSPORTE ILZAUSPE LTDA', '990892161', 'LA CRUZ 50 RANCAGUA', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76093795', '9', 'DOMINGO ELIBERTO CASTILLO BELTRAN, SERVICIOS FUNERARIOS', null, 'DOMINGO ELIBERTO CASTILLO BELTRAN, SERVICIOS FUNERARIOS', '2222222222', 'COPIAPO 916', 'ANTOFAGASTA', 'FUNERARIA');
INSERT INTO `clientes` VALUES ('96900610', '3', 'IMPORTADORA Y ARRENDADORA DE MAQUINARIAS  S.A', null, 'IMPORTADORA Y ARRENDADORA DE MAQUINARIAS  S.A', '552551354', 'COBIJA 235', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76425249', '7', 'INMOBILIARIA HUB DOS SPA.', null, 'HUB DOS SPA', '569 76245198', 'calle Washington 2403', 'ANTOFAGASTA ', 'ARRIENDO DE INMUEBLE AMOBLADOS');
INSERT INTO `clientes` VALUES ('77870140', '5', 'MAXAM CHILE S.A.', null, 'MAXAM CHILE S.A.', '942104668', 'CERRO EL PLOMO 6000 404', 'LAS CONDES SANTIAGO', 'FABRICACION DE EXPLOSIVOS Y PRODUCTOS DE');
INSERT INTO `clientes` VALUES ('96554490', '9', 'COMPASS SERVICIOS', null, 'COMPASS SERVICIOS', '944568931', 'AVDA BALMACEDA # 787 PISO 5 HUACHURABA', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('24115129', '8', 'RUTH VIVIANA APAZA CARVAJAL', null, 'RUTH VIVIANA APAZA CARVAJAL', '95467687', 'AVDA. RICA AVENTURA 11475', 'ANTOFAGASTA', 'ALMACENES PEQUENOS');
INSERT INTO `clientes` VALUES ('76535005', '0', 'IVO SERGIO VLADILO GOICOVIC INGENIERIA', null, 'IVO VLADILO', '988314763', '14 DE FEBRERO 1817 - 402', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76486230', '9', 'SOCIEDAD EDUCACIONAL RAKIDUAM Y COMPANIA', null, 'RAKIDUAM', '51-2546100', 'AV. LA CANTERA 610', 'COQUIMBO', 'ESTABLECIMIENTO DE ENSEÃ‘ANZA PREESCOLAR');
INSERT INTO `clientes` VALUES ('77810360', '5', 'CONSTRUCTORA GEONORTE LTDA', null, 'CONSTRUCTORA GEONORTE LTDA', '96341552', 'LLANQUIHUE 4490', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76179222', '9', 'SIT INGENIERIA Y ASESORIA INDUSTRIAL', null, 'SIT INGENIERIA Y ASESORIA INDUSTRIAL', '966085875', 'CUATRO ORIENTE 2814 ', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('12027512', '7', 'GASTON MICKLE', null, 'GASTON MICKLE', '56984137316', 'CERRO PARANAL 375', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('16874234', '7', 'DANIELA RODRIGUEZ ', null, 'DANIELA RODRIGUEZ ', '963683678', 'AVENIDA BONILLA 8149 VILLA LEMARIA ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77261280', 'K', 'FALABELLA RETAIL', null, 'FALABELLA RETAIL', '552462200', 'BALMACEDA 2355', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('13529035', '1', 'LILIAN LOPEZ', null, 'LILIAN LOPEZ', '949582085', 'TULOR 535', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('10983385', '1', 'LUIS VEGA ', null, 'LUIS VEGA ', ' 979977503', 'GALEGULLOS LORCA 1587  DEPTO43', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('96777810', '9', 'POLYTEX ', null, 'POLYTEX ', '22-6771000', 'PANAMERICANA NORTE #21000 COLINA ', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('6216268', '6', 'JORGE PIZARRO', null, 'JORGE PIZARRO', '990510258', 'SECUNDINI CARRIZO 01273', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('8203932', '5', 'SANDRA ROSA JARA PACHECO', null, 'SANDRA ROSA JARA PACHECO', '1111111', 'PUNTA ARENAS 5367 POB. LAUTARO', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61980680', '8', 'MINISTERIO DE LA MUJER Y LA EQUIDAD DE GENERO', null, 'MINISTERIO DE LA MUJER Y LA EQUIDAD DE GENERO', '225496100', 'Catedral 1401 Piso 2', 'Santiago', '');
INSERT INTO `clientes` VALUES ('76182983', '1', 'DESARROLLOS MINEROS AURA SPA', null, 'AURA SPA', '11111111111', 'AVDA. KENNEDY 1741, RANCAGUA', 'SANTIAGO', 'OBRAS INGENIERIAS ');
INSERT INTO `clientes` VALUES ('12937731', '3', 'MARCELA MARIN', null, 'MARCELA MARIN', '974161755', 'BAQUEDANO 1312', 'TOCOPILLA', '');
INSERT INTO `clientes` VALUES ('5972543', '2', 'GUILLERMO MANCILLA', null, 'STARTED MOTORS', '552565170', 'VALDIVIA 5714', 'ANTOFAGASTA', 'TRANSPORTE ARRIENDO DE MAQUINARIAS');
INSERT INTO `clientes` VALUES ('10050364', '6', 'ALFREDO FLORES', null, 'ALFREDO FLORES', '998794358', 'AVENIDA CERRO PARANAL 210 DEPTO 123', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77694090', '9', 'SOCIEDAD INDUSTRIAL NORTH CHROME LTDA. ', null, 'SOCIEDAD INDUSTRIAL NORTH CHROME LTDA. ', '2778877', 'PEDRO AGUIRRE CERDA 7729', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76080169', '0', 'ESCUELA RAICES ', null, 'ESCUELA RAICES ', '2542322', 'ESMERALDA 1757', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('10894352', '1', 'PABLO PARRA ', null, 'INGENIERIA Y CONSTRUCCIONES SIGDO KOPPERS', '961427519', 'MALAGA 120', 'LAS CONDES, SANTIAGO', 'OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('77800010', '5', 'MECAMIN', null, 'MECAMIN', '55-2648320', 'ANDALEN 273', 'ANTOFAGASTA', 'MANTENCION DE MAQUINAS DE LA MINERIA ');
INSERT INTO `clientes` VALUES ('81201000', 'K', 'CENCOSUD RETAIL S.A.', null, 'CENCOSUD', '91533150', 'ANDALEN 273', 'ANTOFAGASTA', 'SUPERMERCADOS');
INSERT INTO `clientes` VALUES ('76184053', '3', 'SOCIEDAD EDUCACIONAL NIDIA MORENO', null, 'SOCIEDAD EDUCACIONAL NIDIA MORENO', '985225776', '21 DE MAYO 1060', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('76352215', '6', 'RODOTRANS CASTRO S.A.', null, 'RODOTRANS', '552895404', 'MANUEL ANTONIO MATTA 1839 OF605', 'ANTOFAGASTA', 'TRANSPORTE Y LOGISTICA NACIONAL E INTERNACIONAL');
INSERT INTO `clientes` VALUES ('87606700', '5', 'AUTOMATICA Y REGULACION S.A.', null, 'AUTOMATICA Y REGULACION S.A.', '552293140', 'EL YODO 7777', 'ANTOFAGASTA', 'FABRICACION DE MOTORES');
INSERT INTO `clientes` VALUES ('76281400', '5', 'ALUMINI INGENIERIA LTDA', null, 'ALUMINI INGENIERIA LTDA', '942473786', 'OSORNO 3838', 'ANTOFAGASTA ', 'MONTAJE INDUSTRIAL ');
INSERT INTO `clientes` VALUES ('96551880', '0', 'DHL GLOBAL', null, 'DHL GLOBAL', '(562)473-7156', 'BAQUEDANO 300', 'ANTOFAGASTA', 'ENVIO EXPRES');
INSERT INTO `clientes` VALUES ('76110235', '4', 'RENTALMIN', null, 'RENTALMIN', '552895509', 'Lautaro Espindola 7124, Los Pinares', 'ANTOFAGASTA', 'Alquiler de Autos y Camionetas Sin Chofer');
INSERT INTO `clientes` VALUES ('78889270', '5', 'PANADERIA SAN JUAN LTDA', null, 'PANADERIA SAN JUAN LTDA', '552379754', 'GALLEGUILLOS LORCA 1554', 'ANTOFAGASTA', 'PANADERIA');
INSERT INTO `clientes` VALUES ('76733334', 'k', 'ACINDUSTRIAL SPA ', null, 'ACINDUSTRIAL SPA ', '0', 'WASHINGTON 2675 of 502 ', 'ANTOFAGASTA', 'OBRAS MENORES EN CONSTRUCCION ');
INSERT INTO `clientes` VALUES ('76031075', '1', 'BEJOS SPA', null, 'BEJOS SPA', '979624169 / 2560544', 'ANTONIO POUPIN # 1138', 'ANTOFAGASTA', 'INGENIERIA APLICADA');
INSERT INTO `clientes` VALUES ('77005150', '9', 'CYNERSIS', null, 'CYNERSIS', '562 7131000', 'Pocuro 2087', 'Providencia, RENCA', ': sociedad de capacitaciÃ³n, consultoria y computaciÃ³n');
INSERT INTO `clientes` VALUES ('71173500', '3', 'ASOC GREMIAL DE DUENOS DE CAMIONES DE TALTAL', null, 'ASOC GREMIAL DE DUENOS DE CAMIONES DE TALTAL', '552612995', 'SERRANO 451 ', 'TAL TAL', 'TRANSPORTE');
INSERT INTO `clientes` VALUES ('11610918', '2', 'SOFIA CHOQUE BLANCO', null, 'SOFIA CHOQUE BLANCO', '(58)2248610		', 'DIEGO PORTALES 1002 LOCAL 31', 'ARICA', '');
INSERT INTO `clientes` VALUES ('77305850', '4', 'SERCAP SPA', null, 'SERCAP SPA', '971717079', 'BONILLA 8679', 'ANTOFAGASTA', 'OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('76329503', '6', ' MONTAJES Y SERVICIOS GENERALES LTDA', null, ' MONTAJES Y SERVICIOS GENERALES LTDA', '965948225', 'AV.ARGENTINA 2313 DEPTO 1', 'ANTOFAGASTA', 'INGENIERIA Y OBRAS CIVILES ');
INSERT INTO `clientes` VALUES ('78403190', 'k', 'CORTES Y FUENTES LTDA', null, 'CORTES Y FUENTES LTDA', '55228268', 'los cerezos 286 ', 'ANTOFAGASTA', 'ingenieria electrica y obras menores');
INSERT INTO `clientes` VALUES ('76419232', 'k', 'LABORATORIO CLINICO CASTILLO ZEPEDA LTDA.', null, 'LABORATORIO CLINICO CASTILLO ZEPEDA LTDA.', '9-96796434', 'DIAZ GANA 1090', 'ANTOFAGASTA', 'LABORATORIOS CLINICOS: INCLUYE BANCO');
INSERT INTO `clientes` VALUES ('14392035', '6', 'JUAN MANRIQUEZ VALENZUELA', null, 'JUAN MANRIQUEZ VALENZUELA', '966166314', 'OFICINA AUSONIA 198', 'ANTOFAGASTA ', 'ELABORACION Y VENTA DE PAN');
INSERT INTO `clientes` VALUES ('76275945', '4', 'GUIDO ALEJANDRO LEDEZMA BUGUENO COMERCIAL Y SERVICIOS AUTOM', null, 'CENTRAL REPUESTOS', '944137344', 'PASAJE ANHIDRITA 230 CASA 4', 'ANTOFAGASTA ', 'MANTENIMIENTO Y REPARACION DE VEHICULOS');
INSERT INTO `clientes` VALUES ('11346834', '3', 'MANUEL GONZALEZ HIDALGO', null, 'MANUEL GONZALEZ HIDALGO', '993452327-552790680', 'santiago humberstone 145 casa 61 condominio bordemar 2', 'ANTOFAGASTA ', '');
INSERT INTO `clientes` VALUES ('76584318', '9', 'TRANSVERSAL SPA', null, 'TRANSVERSAL SPA', '999591936', 'MANUEL VERBAL 1555 2401 CENTRO', 'ANTOFAGASTA', 'PROYECTOS');
INSERT INTO `clientes` VALUES ('76116241', '1', 'TRANSVICH E HIJOS LTDA.', null, 'TRANSVICH E HIJOS LTDA.', '995410338', 'JUAN BRAVO 7411', 'ANTOFAGASTA', 'TRANSPORTE');
INSERT INTO `clientes` VALUES ('83145600', '0', 'CONSTRUCTORA VALKO S.A.', null, 'CONSTRUCTORA VALKO S.A.', '26248566', 'AV. A. VESPUCIO NORTE 2880 1004', 'SANTIAGO', 'OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('76248899', 'K', 'PATRICIO PEREIRA ITURRIAGA CONSTRUCCION E INGENIERIA E.I.R.L.', null, 'PATRICIO PEREIRA ITURRIAGA CONSTRUCCION E INGENIERIA E.I.R.L.', '992105656', 'CALLE NUEVA 2596 PRAT', 'ANTOFAGASTA', 'OBRAS MENORES EN CONSTRUCCION');
INSERT INTO `clientes` VALUES ('65679000', '8', 'AGRUPACION ARTISTICO-CULTURAL PEDRO DE LA BARRA ,ANTOFAGASTA', null, 'AGRUPACION ARTISTICO-CULTURAL PEDRO DE LA BARRA ,ANTOFAGASTA', '0', 'GALLEGUILLOS LORCA 1466', 'ANTOFAGASTA', 'ACTIVIDADES ARTISTICAS');
INSERT INTO `clientes` VALUES ('76551249', '2', 'Empresa de RRHH inherentes a seguridad privada GRUPO MAS', null, 'GRUPO MAS', '956900279', 'Francisco Bilbao 2275 edf PerÃº of 3B', 'ANTOFAGASTA', 'servicios integrales de seguridad');
INSERT INTO `clientes` VALUES ('76698075', '9', 'CONSULTORA CARLOS LOPEZ VEGA, EIRL', null, 'CONSULTORA CARLOS LOPEZ VEGA, EIRL', '55 2223375', 'JOSE MIGUEL CARRERA NUMERO 1869, SEGUNDO PISO', 'ANTOFAGASTA', 'CONSULTORA EMPRESARIAL');
INSERT INTO `clientes` VALUES ('15811642', '1', 'JONATHAN LEIVA JOPIA', null, 'JONATHAN LEIVA JOPIA', '45872462', 'el oro 8119', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('82745300', '5', 'CORP IGLESIA DE LOS ADVENTISTAS DEL SEPTIMO DIA', null, 'CORP IGLESIA DE LOS ADVENTISTAS DEL SEPTIMO DIA', '552 569400', '14 DE FEBRERO 2784', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('7103332', '5', 'FRANCISCO JAVIER GORDILLO YUGO', null, 'FRANCISCO GORDILLO', '57190941', 'MANUEL VERBAL 1545 DEPTO 1104', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('81889300', '0', 'CUERPO DE BOMBEROS DE TALTAL', null, 'CUERPO DE BOMBEROS DE TALTAL', '552611342', 'RAMIREZ 150', 'TALTAL', 'SERVICIO PUBLICO');
INSERT INTO `clientes` VALUES ('76071784', '3', 'SOCIEDAD COMERCIAL LOGISITICA HERRERA Y VIDELA LTDA.', null, 'SOCIEDAD COMERCIAL LOGISITICA HERRERA Y VIDELA LTDA.', '987114758', 'OHIGGINS 1868', 'ANTOFAGASTA', 'RESTAURANT');
INSERT INTO `clientes` VALUES ('76290837', '9', 'SOCIEDAD EDUCACIONAL JUKU LTDA.', null, 'SOCIEDAD EDUCACIONAL JUKU LTDA.', '0', 'ESMERALDA 2533', 'ANTOFAGASTA', 'ESTABLECIMIENTO DE ENSEÃ‘ANZA PREESCOLAR');
INSERT INTO `clientes` VALUES ('76049249', '3', 'CENTRO INTEGRAL DE ODONTOLOGIA LIMITADA', null, 'CENTRO INTEGRAL DE ODONTOLOGIA LIMITADA', '552 289999', 'MANUEL ANTONIO MATTA 1839 2102B EDIFICIO OBELISCO', 'ANTOFAGASTA', 'CENTROS DE ATENCION ODONTOLOGICA');
INSERT INTO `clientes` VALUES ('69900303', '4', 'CONSULADO DE ARGENTINA ANTOFAGASTA', null, 'CONSULADO DE ARGENTINA', '0', 'MANUEL VERBAL 1632', 'ANTOFAGASTA', 'OTRAS ACTIVIDADES DE SERVICIO');
INSERT INTO `clientes` VALUES ('76098841', '3', 'Sociedad Concesionaria Grupos DOS S.A', null, 'Sociedad Concesionaria Grupos DOS S.A', '55268 8203', 'Ruta 5 Norte Kms 1.381, Nudo Uribe', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76196877', '7', 'TECHCOM SERVICIOS S.A', null, 'TECHCOM SERVICIOS S.A.', '0', 'SOTOMAYOR 307-1', 'ARICA', 'OTROS SERVICIOS DE TELECOMUNICACIONES');
INSERT INTO `clientes` VALUES ('69020500', '9', 'ILUSTRE MUNICIPALIDAD DE TALTAL', null, 'MUNICIPALIDAD DE TALTAL', '55-2683013', 'ARTURO PRAT 515', 'TALTAL', '');
INSERT INTO `clientes` VALUES ('10726267', '9', 'PABLO SPENCER', null, 'PABLO SPENCER', '99148859', 'TRAVESIA DEL MIRADOR 03021 DEPTO 3', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76071838', '6', 'CARRIOS CONSTRUCTORA SPA', null, 'CARRIOS CONSTRUCTORA SPA', '956477995', 'AV. BERNARDO OHIGGINS 1116, ESTACION CENTRAL', 'SANTIAGO', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('60107000', '6', 'SERVICIO NACIONAL DE LA MUJER Y EQUIDAD DE GENERO', null, 'SERVICIO NACIONAL DE LA MUJER Y EQUIDAD DE GENERO', '(22)5496215', 'HUERFANOS 1219', 'SANTIAGO', '');
INSERT INTO `clientes` VALUES ('76899720', '9', 'COMERCIAL IMPOCAR LTDA', null, 'IMPOCARB LTDA', '978482058', 'MINERA MICHILLA 530', 'ANTOFAGASTA', 'DISTRIBUCION');
INSERT INTO `clientes` VALUES ('13867385', '5', 'MAURICIO ROJAS', null, 'MAURICIO ROJAS', '77777127', 'LIMACHE 687 DEPTO 503', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('19396150', '9', 'RECARGA DE TONER', null, 'SERVICIO TECNICO', '552774040', 'LABORATORIO DE TONER', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76125014', '0', 'CYG', null, 'CYG', '952180411', 'ONIX 210			', 'ANTOFAGASTA', 'SERVICIOS INDUSTRIALES 			');
INSERT INTO `clientes` VALUES ('78295070', '3', 'FASTPACK S.A', null, 'FASTPACK S.A', '(22)4994000', 'calle orella 610, ofc 301, edf torre empresarial piso 13', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('95151000', '9', 'INDUSTRIAS METALMECANICA RIVET S.A ', null, 'INDUSTRIAS METALMECANICA RIVET S.A ', '987293856', 'LA ESTERA 418 LAMPA SANTIAGO', 'ANTOFAGASTA', 'METALMECANICA ');
INSERT INTO `clientes` VALUES ('96773480', '2', 'SERVICIOS DE REFRIGERACION Y AIRE ACONDICIONADO SPA', null, 'SERVICIOS DE REFRIGERACION Y AIRE ACONDICIONADO SPA', '992712238', 'FAENA CHUQUICAMATA S/N', 'ANTOFAGASTA', 'SERVICIOS A LA MINERIA');
INSERT INTO `clientes` VALUES ('76118094', '0', 'LOS CAMPINOS INFRAESTRUCTURAS Y URBANIZACION LTDA', null, 'LOS CAMPINOS INFRAESTRUCTURAS Y URBANIZACION LTDA', '950975931', 'URUGUAY 731			', 'ANTOFAGASTA', 'PREPARACION DEL TERRENO ESCABACIONES ');
INSERT INTO `clientes` VALUES ('76126252', '1', 'KONECRANES', null, 'KONECRANES', '56966876848', 'libertadores 52', 'SANTIAGO', 'mantencion equipos de levante');
INSERT INTO `clientes` VALUES ('76214280', '5', 'AVA MONTAJES', null, 'AVA MONTAJES', '944581740', 'AUTOPISTA concepcion talcahuano 8696 of 703', 'ANTOFAGASTA', 'obras de ingenieria ');
INSERT INTO `clientes` VALUES ('76739039', '4', 'FUNERARIA SAN JUAN CASTILLO SPA', null, 'FUNERARIA SAN JUAN CASTILLO SPA', '946138181', 'AVENIDA ANTONIO RENDIC 5230', 'ANTOFAGASTA', 'SERVICIOS FUNERARIOS');
INSERT INTO `clientes` VALUES ('76675405', '8', 'EQUIPOS Y MAQUINARIAS SPA', null, 'EQUIPOS Y MAQUINARIAS SPA', '956784742', 'Lota #4237', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('16203216', 'k', 'RODRIGO HURTADO', null, 'RODRIGO HURTADO', '68424279', 'pasaje cerro moreno 9551', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76140282', 'k', 'fullmelec ', null, 'fullmelec ', '40195094		', 'los guindos 246 trocadero ', 'ANTOFAGASTA', 'servicios industriales 			');
INSERT INTO `clientes` VALUES ('16524375', '7', 'PABLO ANDRES SANCHEZ PAREDES', null, 'NOTARIA TALTAL', '55-2611687', 'PRAT 607', 'TALTAL', 'NOTARIA');
INSERT INTO `clientes` VALUES ('7000961', '7', 'FRANCISCO MARTINEZ TORRES', null, 'FRANCISCO MARTINEZ TORRES', '963656692', 'Prat 482 local 25 interior Edificio LÃ³pez', 'ANTOFAGASTA ', 'SERVICIO NOTARIAL ');
INSERT INTO `clientes` VALUES ('5488051', '0', 'MIGUEL LILLO CONTRERAS', null, 'MIGUEL LILLO CONTRERAS', '984080695', 'Pedro Lobos 7514', 'Antofagasta', 'Obras Menores en Contruccion');
INSERT INTO `clientes` VALUES ('76037060', '6', 'SGI LIMITADA', null, 'SGI LIMITADA', '572315064', 'Genaro Gallo 2540', 'IQUIQUE', 'OBRAS DE INGENIERA ');
INSERT INTO `clientes` VALUES ('76689118', '7', 'SOC. POR ACCIONES EDUCACION BRAC SPA', null, 'COLEGIO CORDILLERA', '976097650', 'BAQUEDANO #631', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('70047302', '3', 'SEGUNDA IGLESIA BAUTISTA ANTOFAGASTA', null, 'COLEGIO BAUTISTA ANTOFAGASTA', '950192236', 'MATIAS ROJAS 1616', 'ANTOFAGASTA', 'EDUCACIÃ“N');
INSERT INTO `clientes` VALUES ('96922700', '2', 'INGENOVA ', null, 'INGENOVA ', '957534403', 'AV PROVIDENCIA 2653 PROVIDENCIA SANTIAGO OF 1502', 'ANTOFAGASTA', 'ELECTRICIDAD Y ENERGIA');
INSERT INTO `clientes` VALUES ('76392776', '8', 'WRV ING. Y CONSTRUCCION', null, 'WRV ING. Y CONTRUCCION', '981292045', 'AV. RENDIC 5417', 'ANTOFAGASTA', 'ELECTRICIDAD');
INSERT INTO `clientes` VALUES ('76112086', '7', 'SOLUCIONES ASFALTICAS S.A.', null, 'SOLUCIONES ASFALTICAS ', '55-2895231', 'AVDA. BERNARDO OHIGGINS 1338,1402', 'ANTOFAGASTA', 'MOVIMIENTO DE TIERRA, VTA DE MEZCLA Y BITUMINOSAS');
INSERT INTO `clientes` VALUES ('13419959', '8', 'MAURICIO ALVARO MARRODAN GARCIA ', null, 'MAURICIO ALVARO MARRODAN GARCIA ', '977687131 ', 'TRAVESIA DE LA PLAZA 3007 ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('18154730', '8', 'CAROLINA COFRE', null, 'CAROLINA COFRE', '63532857 ', 'Calle Cerro Moreno 10575', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76761720', '8', 'DIMPORT LTDA', null, 'DIMPORT LTDA', '985312230', 'PIRITA12584 ', 'ANTOFAGASTA', 'COMERCIALIZACION DE PRODUCTOS');
INSERT INTO `clientes` VALUES ('78701740', '1', 'WURTH CHILE LTDA', null, 'WURTH CHILE LTDA', '96509235		', 'Av Perez Zujovic 5604 local 4 ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76761321', '0', 'Aglomerados y Montajes BSMG SPA  ', null, 'Aglomerados y Montajes BSMG SPA  ', '950956499', 'Los Militares 5885 503 las condes ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76540665', 'k', 'Comercial Besos limitada ', null, 'Comercial Besos limitada ', '984792037', 'Geronimo alderete 283 of21 pucon ', 'ANTOFAGASTA', 'BAZAR');
INSERT INTO `clientes` VALUES ('76479476', '1', 'M3 Ingenieria Chile S.A.', null, 'M3 Ingenieria Chile S.A.', '9 98690129 ', 'San Pio X 2460, Oficina 1309. Providencia, Santiago', 'ANTOFAGASTA', 'Servicios de IngenierÃ­a y AdministraciÃ³n de Obras');
INSERT INTO `clientes` VALUES ('11343763', '4', 'NELSON MARCOS ARAYA TORRES', null, 'NELSON MARCOS ARAYA TORRES', '998485336', 'AVDA RICA AVENTURA 10651 C. 46 BORDEMAR IV', 'ANTOFAGASTA', 'OBRAS MENORES EN CONSTRUCCION');
INSERT INTO `clientes` VALUES ('79511210', '3', 'Zanartu Ingenieros Consultores SPA', null, 'Zanartu Ingenieros Consultores SPA', '996127126 ', 'Av pedro Aguirre Cerda 9553 ', 'ANTOFAGASTA', 'Asesoria ');
INSERT INTO `clientes` VALUES ('99536660', '6', 'Mol Ambiente Soc Anonima ', null, 'Mol Ambiente Soc Anonima ', '991810665', 'Av Vc.mackena Poniente 6843 512 edf. MÃ¡xima la florida ', 'SANTIAGO ', 'Ingenieria Ambiental  ');
INSERT INTO `clientes` VALUES ('81675600', '6', 'COMERCIALIZADORA S A', null, 'HITES', '992017221', 'ALMIRANTE LATORRE 2661', 'ANTOFAGASTA', 'GRANDES TIENDAS');
INSERT INTO `clientes` VALUES ('19396811', '2', 'DEYANIRA ', null, 'DEYANIRA ', '84789927', 'PRAT 446', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('8156574', '0', 'GUILLERMO NAVAS ', null, 'GUILLERMO NAVAS ', '995474256', 'ANCHA SACHA 364 CALAMA ', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('77327630', '7', 'IMPORTADORA Y EXPORTADORA CLEER LTDA', null, 'IMPORTADORA Y EXPORTADORA CLEVER LTDA ', '944383361', 'PINTOR GUSTAVO CABELLO O 874 ', 'CALAMA', 'REPARACION DE EQUIPO DE ILUMINACION  ');
INSERT INTO `clientes` VALUES ('77430080', '5', 'ESTUDIO JURIDICO NANCY MELLADO Y CIA LIMITADA', null, 'ESTUDIO JURIDICO NANCY MELLADO ', '55-2224762', 'WASHINGTON 2562 OF 201 ', 'ANTOFAGASTA', 'SERVICIOS JURIDICOS');
INSERT INTO `clientes` VALUES ('76499251', '2', 'METALCAE SERVICE LTDA', null, 'METALCAE', '994484610', 'AVDA. PRAT 1925', 'CALAMA', '');
INSERT INTO `clientes` VALUES ('76095896', '4', 'Comercial y Servicios Barthen Ltda.', null, 'Barthen', '552925608', 'Covadonga 961', 'Antofagasta', 'Obras de Ingenieria ');
INSERT INTO `clientes` VALUES ('8727697', 'K', 'LUIS MARIN', null, 'LUIS MARIN', '992534137', '21 MAYO 838', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('99573900', '3', 'JARA CONSTRUCCION', null, 'JARA CONSTRUCCION', '978340095', 'CATORCE DE JULIO 2155', 'ANTOFAGASTA', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('76467328', 'K', 'RLV SERVICIO Y MAQUINARIAS LTDA', null, 'RLV SERVICIOS', '995474363', 'DAGOBERTO GODOY 7167', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('81518400', '9', 'UNIVERSIDAD CATOLICA DEL NORTE', null, 'UCN', '91998415', 'AV. ANGAMOS 0610', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('76757110', '0', 'ARMAQ SUBIRI S.A.', null, 'ARMAQ SUBIRI S.A.', '55247587', 'AMATISTA 671', 'ANTOFAGASTA', 'ARRIENDO DE MAQUINAS DE CONSTRUCCION');
INSERT INTO `clientes` VALUES ('76820775', '5', 'SERVICIOS INTEGRALES COBRA NORTE 			', null, 'SERVICIOS INTEGRALES COBRA NORTE', '50176661', 'ANTONIO PUPIN 1445 SECTOR HOSPITAL ANTOFAGASTA			', 'ANTOFAGASTA', 'SERVICIOS INTEGRALES');
INSERT INTO `clientes` VALUES ('76243616', '7', 'PRODUCTORA DE EVENTOS CHILYSDOGS SPA', null, 'PRODUCTORA DE EVENTOS CHILYSDOGS SPA', '967284681', 'COQUIMBO 888 501', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76464446', '8', 'ENERGY Y MINING SERVICE SPA', null, 'ENERGY Y MINING SERVICE SPA', '552925592', 'BAQUEDANO 239', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76650889', '8', 'INVERSIONES MOON VALLEY SPA', null, 'INVERSIONES MOON VALLEY SPA', '5527853330', 'LATORRE 2731', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('4234188', '6', 'LUIS ANGUITA LABAIRU', null, 'LUIS ANGUITA LABAIRU', '999393233', 'URIBE 610', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('7954313', '6', 'FRANCIS FERNANDEZ SPA', null, 'FRANCIS FERNANDEZ SPA', '989234101', 'ANTONIO TORO 924', 'ANTOFAGASTA', 'VTA. ARTICULOS DE HOGAR');
INSERT INTO `clientes` VALUES ('76278553', '6', 'FELIPE ANTONIO LA FLOR CATALAN SERVICIOS DE INGENIERIA	', null, 'SOBEKINGENIEROS', '999058563', 'BAQUEDANO 239', 'ANTOFAGASTA', 'OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('77881200', '2', 'PROPIPE S.A.', null, 'PROPIPE S.A.', '225719500', 'COYANCURA 2283 OF 701', 'PROVIDENCIA SANTIAGO', 'INGENIERTIA');
INSERT INTO `clientes` VALUES ('76148551', '2', 'FENNIX', null, 'FENNIX', '975184628', 'LOS PENSAMIENTOS 428 SAN PEDRO DE LA PAZ CONCEPCION', 'ANTOFAGASTA', 'CONTRATISTA OBRAS MENORES');
INSERT INTO `clientes` VALUES ('8082310', 'K', 'LUIS LEIVA', null, 'LUIS LEIVA', '933742086', 'COPIAPO 868 CASA 2', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76599537', 'k', 'Glauben Ecology spa ', null, 'Glauben Ecology spa ', '93437223', 'oficina petronila 170 70 ', 'ANTOFAGASTA ', 'servicios ambientales ');
INSERT INTO `clientes` VALUES ('65628810', '8', 'PRODEL ', null, 'PRODEL', '552 929985', 'carriel sur 10059 ', 'ANTOFAGASTA ', 'servicios de estudio ');
INSERT INTO `clientes` VALUES ('78378860', '8', 'INTERACID TRADING CHILE S.A', null, 'INTERACID TRADING CHILE S.A', '552 351400', 'PARQUE INDUSTRIAL NÂ°6500', 'MEJILLONES', 'OPERACION DE TERMINALES MARITIMOS Y COMERCIALIZACIÃ“N DE ACIDO ');
INSERT INTO `clientes` VALUES ('21863782', '5', 'DINA CARMEN AFRAY CHOQUE', null, 'DINA CARMEN AFRAY CHOQUE', '79529479', 'av.independencia 2265 ', 'Calama', 'venta al por menor de prendas y accesorios ');
INSERT INTO `clientes` VALUES ('76056333', '1', 'TRANSPORTES SOLUCIONES LOGISTICAS S.A.', null, 'TSL CHILE S.A', '222640560', 'AV. PRESIDENTE KENNEDY 6800, OF 505, VITACURA', 'SANTIAGO', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('7704689', '5', 'ROSSANA SANTAMARIA ', null, 'ROSSANA SANTAMARIA ', '996894190', 'LOS AROMOS 8940', 'ANTOFAGASTA', 'ELABORACION DE BEBIDAS NO ALCOHOLICAS');
INSERT INTO `clientes` VALUES ('76754263', '1', 'GACEMA OTEC LIMITADA', null, 'GACEMA OTEC LIMITADA', '940741785', 'CALLE SANTA HELENA 896 COVIEFI', 'ANTOFAGASTA ', 'ACTIVIDADES DE CONSULTORIA DE GESTION ');
INSERT INTO `clientes` VALUES ('77198310', '3', 'SOC DE SERVICIOS MAXIMA SEGURIDAD OPERATIVA LIMITADA', null, 'MSO SEGURIDAD LTDA', ' 985964385', 'CONDE DEL MAULE 4235', 'SANTIAGO', 'SERVICIOS DE SEGURIDAD PRIVADA PRESTADOS');
INSERT INTO `clientes` VALUES ('9512497', '6', 'CARLOS FREDDY MIRANDA ZULETA', null, 'CARLOS FREDDY MIRANDA ZULETA', '552954047', 'JOSE TORIBIO MEDINA 254', 'ANTOFAGASTA', 'SERVICIO DE ARQUITECTURA');
INSERT INTO `clientes` VALUES ('76398358', '7', 'SERVICIOS GENERALES ANGELICA MARITZA ALVAREZ CASTILLO E.I.R.L.', null, 'INCOSER EIRL', '992562773', 'Oficina Solferino 224 Portada Norte 1', 'ANTOFAGASTA ', 'ARRIENDO DE EQUIPOS');
INSERT INTO `clientes` VALUES ('16438921', '9', 'LEIDY JOANNA BARRAZA BARRAZA ', null, 'LEIDY JOANNA BARRAZA BARRAZA ', '58912121- 67285229', 'oficina lina condominio olivillos casa 58', 'ANTOFAGASTA', 'OTRAS ACTIVIDADES DE SERVICIOS PERSONALE');
INSERT INTO `clientes` VALUES ('16947603', '9', 'JORGE ESTEBAN CANALES VILLALBA', null, 'JORGE ESTEBAN CANALES VILLALBA', '63289537', 'psje gustavo le paige 1308', 'ANTOFAGASTA ', 'TERMINACIÃ“N Y ACABADO DE EDIFICIOS');
INSERT INTO `clientes` VALUES ('76696035', '9', 'ESTUDIO JURIDICO NARANJO Y ASOCIADOS SPA', null, 'ESTUDIO JURIDICO NARANJO Y ASOCIADOS SPA', '552 776751', 'ARTURO PRAT 461 807 ', 'ANTOFAGASTA ', 'SERVICIOS DE ASESORAMIENTO Y REPRESENTAC');
INSERT INTO `clientes` VALUES ('99572320', '4', 'RUSSELL MINERAL EQUIPMENT S A', null, 'RUSSELL MINERAL EQUIPMENT S A', '985003212+56981884640', 'GENERAL BORGOÃ‘O 934 OF 401 ', 'ANTOFAGASTA ', 'MANTENIMIENTO DE EQUIPOS MINEROS ');
INSERT INTO `clientes` VALUES ('70095900', '7', 'CORPORACION NACIONAL DEL CANCER', null, 'CONAC', '552 265300', 'EDUARDO LEFORT 1638', 'ANTOFAGASTA ', 'OTRAS ACTIVIDADES DE ATENCION EN INSTITU');
INSERT INTO `clientes` VALUES ('76181913', '5', 'ESLAINER & ESLAINER COMPANIA LIMITADA ', null, 'ESLAINER & ESLAINER COMPAÃ‘ÃA LIMITADA ', '92419429', 'OFICINA SAN GREGORIO 74 D 42 ', 'ANTOFAGASTA ', 'TRANSPORTES ');
INSERT INTO `clientes` VALUES ('76006032', '1', 'SERVICIOS GENERALES EN GOMAS Y METALMECANICA LTDA ', null, 'SERVICIOS GENERALES EN GOMAS Y METALMECANICA LTDA ', '956295801 ', 'SARGENTO CANDELARIA 824 ', 'ANTOFAGASTA ', 'CONTRATISTA ');
INSERT INTO `clientes` VALUES ('14464403', '4', 'JASNA PLANTAK', null, 'JASNA PLANTAK', '552 932145', 'LATORRE 2528 LC 13 CENTRO ', 'ANTOFAGASTA ', 'VENTA AL POR MENOR DE PRODUCTOS MEDICINA ');
INSERT INTO `clientes` VALUES ('76043850', '2', 'OPERADORES E INTERMEDIADORES DE PROYECTOS IND E INMOBILIARIOS LTDA', null, 'Opinpro Ltda', '965104725', 'antonio poupin 839 oficina 104', 'ANTOFAGASTA ', 'Ingeneria y ConstrucciÃ³n ');
INSERT INTO `clientes` VALUES ('76525290', '3', 'EBCO S.A.', null, 'EBCO S.A.', '96449634', 'Av. Santa Maria #2450', 'Antofagasta', 'Construccion');
INSERT INTO `clientes` VALUES ('78764450', '3', 'TMA ingenieria y operaciones mineras ', null, 'TMA ingenieria y operaciones mineras ', '944116534', 'valentin letelier 1373 of 502 a', 'ANTOFAGASTA ', 'servicio de operaciÃ³n, maquinaria movimiento de tierra ');
INSERT INTO `clientes` VALUES ('96659360', '1', 'HONEYWELL CHILE S A', null, 'HONEYWELL CHILE S A', '56 225718461 ', 'AVELINO CONTARDO 933 ', 'ANTOFAGASTA', 'VENTA AL POR MAYOR DE OTROS TIPOS DE MAQ ');
INSERT INTO `clientes` VALUES ('76260599', '6', 'INVERSIONES JUAN ASPER PARADA E.I.R.L.', null, 'INVERSIONES JUAN ASPER PARADA E.I.R.L.', '98454397', 'COPIAPO 833 DP.135 EDIF, GIRASOLES', 'ANTOFAGASTA ', 'servicios de estudio ');
INSERT INTO `clientes` VALUES ('16791574', '4', 'FELIPE ACUNA ROBLES ', null, 'FELIPE ACUÃ‘A ROBLES ', '77914587', 'RODRIGO DE TRIANA 02177 ', 'ANTOFAGASTA ', 'ACTIVIDADES PERSONALES ');
INSERT INTO `clientes` VALUES ('96842570', '6', 'CONSTRUCTORA IS LTDA.', null, 'CONSTRUCTORA IS LTDA.', '9942345980', 'AVDA. PEDRO AGUIRRE CERDA #5527', 'ANTOFAGASTA ', 'CONSTRUCCION');
INSERT INTO `clientes` VALUES ('76521779', '2', 'ursicorp ', null, 'ursicorp ', '56933916946', 'pedro aguirre cerda 11395 local 12b ', 'ANTOFAGASTA ', 'venta de articulos textiles  ');
INSERT INTO `clientes` VALUES ('77134420', '8', 'PUBLIEVENTOS LDTA ', null, 'RADIO CARNAVAL', '552 495343', 'SUCRE 763 TERCER PISO ', 'ANTOFAGASTA ', 'PROPAGANDA Y EVENTOS ');
INSERT INTO `clientes` VALUES ('96732670', '4', 'HOTEL COLON S.A ', null, 'HOTEL COLON S.A ', '2261851', 'SAN MARTIN 2434 ', 'ANTOFAGASTA ', 'HOTEL ');
INSERT INTO `clientes` VALUES ('76769012', '6', 'INGENIERIA CONSTRUCCION Y MONTAJES SPA', null, 'INGENIERIA CONSTRUCCION Y MONTAJES SPA', ' 989059638 ', 'LA FILARMONICA 11597 VISTA HERMOSA ', 'ANTOFAGASTA ', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F ');
INSERT INTO `clientes` VALUES ('76391903', 'K', 'EDF RENEWABLE SERVICES CHILE SPA ', null, 'EDF RENEWABLE SERVICES CHILE SPA ', '552514204', 'AV.APOQUINDO 3472 1601 LAS CONDES ', 'ANTOFAGASTA ', 'OPERACIÃ“N MANTENIMIENTO ');
INSERT INTO `clientes` VALUES ('17433995', '3', 'KAREN ORDENES ', null, 'KAREN ORDENES ', '984308522', 'ESTACION DE LOS VIENTOS 20028 ', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('8311491', '6', 'JULIO RODRIGO MOVILLO MATTASSI', null, 'NOTARIA TOCOPILLA', '552 812159', 'FREIRE 1312 ', 'TOCOPILLA', 'SERVICIOS DE ASESORAMIENTO Y REPRESENTAC');
INSERT INTO `clientes` VALUES ('11203242', '8', 'MARITZA DE GUADALUPE ROJAS HUERTA ', null, 'MARITZA DE GUADALUPE ROJAS HUERTA ', '553 209506 - 954107723', 'AV.SALVADOR ALLENDE S/N 0 VILLA DESIERTO ', 'BAQUEDANO', 'VENTA AL POR MENOR DE ALIMENTOS EN COMER');
INSERT INTO `clientes` VALUES ('78498240', '8', 'geomaq ltda', null, 'geomaq ltda', '92283094 ', 'av croacia 0416', 'ANTOFAGASTA ', 'servicios geologicos ');
INSERT INTO `clientes` VALUES ('9441231', '5', 'juan carlos torres santander ', null, 'juan carlos torres santander ', '82996355', 'chamonate 10055 ', 'ANTOFAGASTA ', 'particular ');
INSERT INTO `clientes` VALUES ('76902411', '5', 'SOCIEDAD JARA Y DIAZ LTDA ', null, 'SOCIEDAD JARA Y DIAZ LTDA ', '968685009', 'ISABEL RIQUELME 372', 'ANTOFAGASTA ', 'ARRIENDO Y VENTA DE MAQUINARIA ');
INSERT INTO `clientes` VALUES ('56020680', '1', 'COMUNIDAD EDIFICIO BRASIL IV', null, 'COMUNIDAD EDIFICIO BRASIL IV', '55-2939241', 'AV. OÂ´HIGGINS 1804 ', 'Antofagasta', 'COMUNIDAD HABITACIONAL');
INSERT INTO `clientes` VALUES ('76513726', '8', 'INVERSIONES INMOBILIARIAS Y HOTELERAS MT S.A.', null, 'HOTEL HAMPTON BY HILTON ANTOFAGASTA', '227971200', 'AV AMERICO VESPUCIO NORTE 1090 P12 ', 'VITACURA SANTIAGO', 'FONDOS Y SOCIEDADES DE INVERSION Y ENTID ');
INSERT INTO `clientes` VALUES ('76265500', '4', 'Lo Castillo Producciones', null, 'Lo Castillo Producciones', '91355384', 'Esmeralda 1807 of 302', 'Antofagasta', 'Producciones de Eventos');
INSERT INTO `clientes` VALUES ('9132056', '8', 'LUZ MATURANA', null, 'LUZ MATURANA', '984433891', 'POUPIN 1960', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('61107000', '4', ' INSTITUTO NACIONAL DE DEPORTES DE CHILE ', null, ' INSTITUTO NACIONAL DE DEPORTES DE CHILE ', '552 268664', '21 DE MAYO 511 561 CENTRO ENTRENAM REGI ', 'ANTOFAGASTA', 'ACTIVIDADES DE LA ADMINISTRACION PUBLICA');
INSERT INTO `clientes` VALUES ('65155528', '0', 'FUNDACION EDUCACIONAL COLEGIO SANTA EMILIA', null, 'COLEGIO SANTA EMILIA', '68328476', 'MANUEL SILVA 1014 BONILLA', 'ANTOFAGASTA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('76961000', '6', 'CONSTRUCTORA ECORA S.A', null, 'ECORA SA.', '552 552410', 'BAQUEDANO 647', 'ANTOFAGASTA', 'OBRAS DE INGENIERIA ');
INSERT INTO `clientes` VALUES ('65114358', '6', 'FUNDACION MI NORTE', null, 'FUNDACION MI NORTE', '942207503', 'ANTONIO POUPIN 1138', 'ANTOFAGASTA', 'ACTIVIDADES DE CONSULTORIA DE GESTION');
INSERT INTO `clientes` VALUES ('76354375', '7', 'ICK INGENIERIA', null, 'ICK INGENIERIA', '78469668', 'BAQUEDANO 239', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('69252500', '0', 'ILUSTRE MUNICIPALIDAD DE SAN PEDRO DE ATACAMA', null, 'MUNICIPALIDAD DE SAN PEDRO DE ATACAMA', '983178692', 'GUSTAVO LE PAIGE 328', 'SAN PEDRO', '');
INSERT INTO `clientes` VALUES ('76732735', '8', 'NUNEZ HURTADO Y COMPANIA LTDA', null, 'NUÃ‘EZ HURTADO Y COMPALIA', '942726620', 'AV PADRE ALBERTO HURTADO 3578 RENE SCNEIDER', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('15022287', '7', 'CLAUDIA MUNOZ', null, 'CLAUDIA MUNOZ', '974581182', 'OFICINA SANTA LAURA 11838', 'ANTOFAGASTA', '');
INSERT INTO `clientes` VALUES ('76121510', '8', 'ASESORIAS MORALES E HIJOS LTDA', null, 'ASESORIAS MORALES E HIJOS LTDA', '979059354', 'AV. GRECIA NÂ° 1532, PISO 3 , ANTOFAGASTA', 'Antofagasta', '');
INSERT INTO `clientes` VALUES ('7778699', '6', 'CARLOS ENRIQUE MARTICORENA ALTAMIRANO ', null, 'CARLOS ENRIQUE MARTICORENA ALTAMIRANO ', '983309209', ' edmundo perez zujovic 11092 ', 'ANTOFAGASTA ', 'OTRAS ACTIVIDADES DE IMPRESION N.C.P. ');
INSERT INTO `clientes` VALUES ('15975323', '9', 'MACARENA NATALY MANCILLA OLIVARES', null, 'MACARENA NATALY MANCILLA OLIVARES', '982668397', 'ANACLETO SOLORSA 9770', 'Antofagasta ', 'ACTIVIDADES DE RESTAURANTES');
INSERT INTO `clientes` VALUES ('6953383', '3', 'Nelly Lastra Aracena ', null, 'Nelly Lastra Aracena ', '56851065', 'Av Septima de linea 3480 torre codelco 2 dpa 302 ', 'ANTOFAGASTA ', 'OTRAS ACTIVIDADES DE SERVICIOS PERSONALE');
INSERT INTO `clientes` VALUES ('15760680', '8', 'Marcos Ortega Osorio ', null, 'Marcos Ortega Osorio ', '77669358 ', 'pasaje el roble 7272 ', 'Antofagasta ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('13172729', '1', 'ROXSSANA LEAL', null, 'ROXSSANA LEAL', '976187400', 'DIAS GANA 900 ARACIFE 4 DEPTO 43', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76191772', '2', 'SOCIEDAD DE PROFESIONALES FLORES MOLINA Y OLIVARES ABOGADOS ASOCIADOS', null, 'Soporte Legal Abogados Asociados Limitada', '966665569', 'Prat 461, oficina 1201', 'Antofagasta', 'Servicios JurÃ­dicos');
INSERT INTO `clientes` VALUES ('83385600', '6', 'MOVIMIENTO DE TIERRA Y CONSTRUCCION S A ', null, 'MOVITEC', '2555612', 'AVDA LAS CONDES 11400 OF 72 ', 'VITACURA', 'ALQUILER DE OTROS TIPOS DE MAQUINARIAS');
INSERT INTO `clientes` VALUES ('99575470', '3', 'SERVICIOS INDUSTRIALES MINARDI S A', null, 'SERVICIOS INDUSTRIALES MINARDI S A', '342344373', 'AVDA ARGENTINA ORIENTE 131 ', 'LOS ANDES ', 'MANTENIMIENTO Y REPARACION DE VEHICULOS');
INSERT INTO `clientes` VALUES ('11612845', '4', 'Alejandro Palma ', null, 'Alejandro Palma ', '942768620', 'manuel berval 1555 ', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76229860', '0', 'saser safety service ', null, 'saser safety service ', '942496629', 'gral velsquez 890 of 404 sector av brasil ', 'ANTOFAGASTA ', 'asesoria y servicios ');
INSERT INTO `clientes` VALUES ('6752412', '8', 'maria montenegro ', null, 'maria montenegro ', '995415289', 'baquedano 1136', 'ANTOFAGASTA ', 'residencial ');
INSERT INTO `clientes` VALUES ('93779000', '7', ' SKF CHILENA SAIC ', null, ' SKF CHILENA SAIC ', '22437200', 'AV V MACKENNA 655 ', 'SANTIAGO', 'VENTA AL POR MAYOR NO ESPECIALIZADA ');
INSERT INTO `clientes` VALUES ('93077000', '0', 'METSO CHILE SPA', null, 'METSO CHILE', '995174705', 'CAMINO INTERNACIONAL 5725', 'CONCON', 'FABRICACION DE OTROS PRODUCTOS DE CAUCHO');
INSERT INTO `clientes` VALUES ('13198616', '5', ' VIVIANA SOLEDAD RAMOS HENRIQUEZ ', null, ' VIVIANA SOLEDAD RAMOS HENRIQUEZ ', '979786563', 'CARACOLES O 295-B CENTRO A ', 'S.PEDRO ATACA', 'FOTOCOPIADO, PREPARACION DE DOCUMENT ');
INSERT INTO `clientes` VALUES ('76001769', '8', 'sociedad mena y mena ltda ', null, 'sociedad mena y mena ltda ', '966663250', 'psj carrizal alto 9634', 'ANTOFAGASTA ', 'obras de ingenieria ');
INSERT INTO `clientes` VALUES ('79527230', '5', 'EMIN INGENIERIA Y CONSTRUCCION ', null, 'EMIN INGENIERIA Y CONSTRUCCION ', '66761159 ', 'FELIX DE AMESTI 90 PISO 3 ', 'ANTOFAGASTA ', 'INGENIERIA Y CONSTRUCCION  ');
INSERT INTO `clientes` VALUES ('15336964', 'k', 'tania avendano miranda ', null, 'tania avendaÃ±o miranda ', '982595823', 'padre gonzalo errazuriz 7756', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76682120', '0', 'asesorias informaticas braun and morgan ', null, 'asesorias informaticas braun and morgan ', '999970605', 'maximiliano poblete 14655 ', 'ANTOFAGASTA ', 'obras de ingenieria ');
INSERT INTO `clientes` VALUES ('13421196', '2', 'GABRIELA ALEJANDRA QUEZADA TITICHICA', null, 'GABRIELA QUEZADA TITICHOCA', '987247642', 'MATIAS ROJAS 1631', 'ANTOFAGASTA', 'VENTA AL POR MENOR DE ALIMENTOS EN COMER');
INSERT INTO `clientes` VALUES ('76042014', 'k', 'walmart chile s.a ', null, 'walmart cile s.a ', '57763053', 'zenteno 21	', 'ANTOFAGASTA ', 'hipermercado');
INSERT INTO `clientes` VALUES ('76380532', '8', 'RAM RENTAL SPA ', null, 'RAM RENTAL SPA ', '552844089', 'av rendic 4513  ', 'ANTOFAGASTA ', 'ferreteria 	');
INSERT INTO `clientes` VALUES ('76367270', '0', 'TRANSFACTOR LIMITADA ', null, 'TRANSFACTOR', '2381060', 'Serrano 63 OF 42', 'SANTIAGO', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('74454100', 'K', 'FONDO DE BIENESTAR SOCIAL DE LOS TRABAJADORES DE MINERA ESCONDIDA LTDA', null, 'MEDIMEL', '552 457705', 'COQUIMBO 888 301 PISO 3 ', 'ANTOFAGASTA ', 'ACTIVIDADES DE OTRAS ASOCIACIONES N.C.P. ');
INSERT INTO `clientes` VALUES ('99562370', '6', 'CONTEMPORA FACTORING S A', null, 'CONTEMPORA FACTORING S A', '223704402', 'AV. EL BOSQUE NORTE 0177 703', 'SANTIAGO', 'FONDOS Y SOCIEDADES DE INVERSION Y ENTID');
INSERT INTO `clientes` VALUES ('76479798', '1', 'CLC SERVICIOS INDUSTRIALES LIMITADA', null, 'CLC', '32335008', 'CALLE DOCE 559 ', 'CON CON VALPARAISO', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F ');
INSERT INTO `clientes` VALUES ('24311943', 'k', 'sadan maldonado nina ', null, 'sadan maldonado nina ', '967970224', 'av yanquihue 4355', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76660114', '6', 'Gama Digital SPA', null, 'Gama Digital', '552936002', 'Dias Ganas 1048', 'Antofagasta', 'DiseÃ±o grafico e impresion');
INSERT INTO `clientes` VALUES ('76190353', '5', 'RODRIGO VEGA VEGA FERRETERIA INDUSTRIAL EIRL', null, 'PRENORTE', '552 542848 ', 'VALDIVIA 5684 LAUTARO', 'ANTOFAGASTA ', 'VENTA AL POR MAYOR DE MATERIALES DE CONS ');
INSERT INTO `clientes` VALUES ('76238445', '0', 'SUAVAL SPA', null, 'SUAVAL ', '999685440', 'APOQUINDO 3001 901 ', 'LAS CONDES SANTIAGO', 'OTRAS INSTALACIONES PARA OBRAS DE CONSTR ');
INSERT INTO `clientes` VALUES ('86431800', '2', 'BRINKS CHILE S.A', null, 'BRINKS CHILE S.A', '226800700', 'OLIVOS 964', 'SANTIAGO', 'TRANSPORTE DE VALORES COD. 730');
INSERT INTO `clientes` VALUES ('76662759', '5', 'TRANSPORTES MICHEA SPA', null, 'TRANSPORTES MICHEA SPA', '966587040', 'OMAR PETRINOVIC NORTE 3540 PORTAL DEL INCA VI', 'CALAMA', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('76797557', '0', 'BESALCO - INCOPESA S.A. ', null, 'BISA S.A.', '225407410', 'JOSE JOAQUIN PRIETO 9660 ', 'EL BOSQUE SANTIAGO', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F ');
INSERT INTO `clientes` VALUES ('73968300', '9', 'EMPRESA PORTUARIA ANTOFAGASTA', null, 'EMPRESA PORTUARIA ANTOFAGASTA', '552 563709', 'AVDA GRECIA S/N ', 'ANTOFAGASTA ', 'OTROS SERVICIOS DE ALMACENAMIENTO Y DEPO ');
INSERT INTO `clientes` VALUES ('78991830', '9', 'METALMECANICA TORMETAL SPA ', null, 'TORMETAL SPA ', '552 689700', 'MONTEGRANDE 323 LOTEO COBIJA-SECT.3 ', 'ANTOFAGASTA ', 'REPARACION DE OTROS EFECTOS PERSONALES Y ');
INSERT INTO `clientes` VALUES ('23906778', '6', 'Edgar Castellon', null, 'Edgar Castellon', '930675152', 'campamento futuro antofagasta cs. 42', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76429110', '7', 'SOCIEDAD UBERLINDA OVANDO ANTOFAGASTA LIMITADA', null, 'FABRICA MOISES ANTOFAGASTA', '552 561897', ' SUCRE 1052 centro ', 'ANTOFAGASTA ', 'VENTA AL POR MAYOR NO ESPECIALIZADA ');
INSERT INTO `clientes` VALUES ('76009937', '6', 'LY H SERVICIOS INDUSTRIALES CHILE LIMITADA', null, 'LY H SERVICIOS INDUSTRIALES CHILE LIMITADA', '931472366', 'PANAMERICANA NORTE KM 1350 SECTOR LA NEGRA ', 'ANTOFAGASTA ', 'VENTA DE REPUESTOS PARA LA MINERIA ');
INSERT INTO `clientes` VALUES ('76953555', '1', 'SOCIEDAD AZOCAR E Y E SPA', null, 'SOCIEDAD AZOCAR E Y E SPA', '984022390', 'PRAT  482   22-23 LOCAL 19', 'ANTOFAGASTA ', 'CAFETERIA');
INSERT INTO `clientes` VALUES ('12263231', '8', 'felipe palomino', null, 'felipe palomino', '993183342', 'OFICINA PETRONILA 183 CS 11', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('7683976', 'k', 'miguel salinas ', null, 'miguel salinas ', '999175411', 'cerro paranal 380   dep .172', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76613923', 'K', 'CENTRO MEDICO ANGAMOS SPA ', null, 'CENTRO MEDICO ANGAMOS SPA ', '552 552210 ', ' MANUEL VERBAL 1201 ', 'ANTOFAGASTA ', 'ACTIVIDADES DE HOSPITALES Y CLINICAS PRI ');
INSERT INTO `clientes` VALUES ('16438099', '8', 'oscar diaz', null, 'oscar diaz', '971029840', 'sucre 470', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('77276280', '1', 'industrial support company limitada ', null, 'industrial support company limitada ', '942952307', 'anhidrita 281', 'ANTOFAGASTA ', 'mantencion estructural');
INSERT INTO `clientes` VALUES ('92177000', '6', 'LE GRAND CHIC S.A', null, 'LE GRAND CHIC S.A', '90844771', 'LOS CONQUISTADORES 2752', 'SANTIAGO', 'LAVANDERIA INDUSTRIAL');
INSERT INTO `clientes` VALUES ('65147763', '8', 'FUNDACION EDUCACIONAL SONIA GONZALEZ FORD', null, 'FUNDACION EDUCACIONAL SONIA GONZALEZ FORD', '968328476', 'MENANDRO URRUTIA 2311 ', 'ARICA', 'EDUCACION');
INSERT INTO `clientes` VALUES ('17210262', 'K', 'DANIEL ZAMORA', null, 'DANIEL ZAMORA', '984473102', 'OFICINA BONASORT 280 BLOKE 6 DEP. 102', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('77471030', '2', 'THYSSENKRUPP INDUSTRIAL SOLUTIONS (CHILE) LIMITADA', null, 'THYSSENKRUPP INDUSTRIAL SOLUTIONS (CHILE) LIMITADA', '229989828', 'SIDORA GOYENECHEA 2800 OF 1901 ', 'SANTIAGO', 'ACTIVIDADES DE APOYO PARA LA EXPLOTACION ');
INSERT INTO `clientes` VALUES ('96684600', '3', 'SALFA MONTAJES', null, 'SALFA MONTAJES', '978728578', 'AVND. PRESIDENTE RIESCO 5335', 'ANTOFAGASTA ', 'CONSTRUCCION Y/O INSTALACION DE BIENES INMUEBLES ');
INSERT INTO `clientes` VALUES ('69253600', '2', 'Ilustre Municipalidad de Maria Elena ', null, 'Ilustre Municipalidad de Maria Elena ', '984436694', 'IGNACIO CARRERA PINTO 1926', 'Maria Elena ', 'ACTIVIDADES DE LA ADMINISTRACION PUBLICA ');
INSERT INTO `clientes` VALUES ('11680709', '2', 'EDUARDO FERRADA BARRIGA', null, 'EDUARDO FERRADA BARRIGA', '995474518', 'MATTA 1839 OF 1401A', 'ANTOFAGASTA', 'MEDICINA');
INSERT INTO `clientes` VALUES ('76270521', '4', 'TRANSMAT SPA ', null, 'TRANSMAT SPA ', '968326481', 'CALLE RUTA DEL COBRE 320 0 SITIO 11.SECTOR LA NEGRA', 'ANTOFAGASTA ', 'MAQUINARIA Y TRANSPORTES');
INSERT INTO `clientes` VALUES ('15691900', '4', 'LEONARDO VELIZ ', null, 'LEONARDO VELIZ ', '972574341', 'AV.PADRE HURTADO 4210', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76010685', '2', 'SERVICIOS A LA MINERA E INDUSTRIALES TMETAL SPA ', null, 'TMETAL', '552 593205', 'ORELLA 610 502 CENTRO', 'ANTOFAGASTA ', 'MUELLAJE, COMPRA Y VENTA DE VEHICULOS, MOVIMIENTO DE TIERRA');
INSERT INTO `clientes` VALUES ('11383739', 'K', 'HERNAN CARVAJAL', null, 'HERNAN CARVAJAL', '950095628', 'CHAMIZA 175', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('14264113', '5', 'MARIELA ESTER CERDA LOPEZ', null, 'MARIELA ESTER CERDA LOPEZ', '978340095', 'PANIRI 4050', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76657896', '9', 'empresa de servicios mecanicos andres buzeta labarca eirl', null, 'empresa de servicios mecanicos andres buzeta labarca eirl', '941524098', 'salar de pujsa 4075 villa los salares', 'ANTOFAGASTA ', 'servicios mecanicos');
INSERT INTO `clientes` VALUES ('76930563', '7', 'NUEVA ESPERANZA SPA', null, 'NES SPA', '934225892', 'URIBE 636 OFICINA 414', 'ANTOFAGASTA ', 'TERMINACIÃ“N Y ACABADO DE EDIFICIOS');
INSERT INTO `clientes` VALUES ('72907800', 'K', 'COMUNIDAD INDIGENA ATACAMENA DE TALABRE', null, 'COMUNIDAD INDIGENA ATACAMEÃ‘A DE TALABRE', '982265225', 'TALABRE SIN NUMERO', 'SAN PEDRO ATACAMA', 'ACTIVIDADES DE OTRAS ASOCIACIONES  N.C.P');
INSERT INTO `clientes` VALUES ('8377117', '8', 'JOSE PATERAKIS', null, 'JOSE PATERAKIS', '982334491', 'GALLEGUILLOS LORCA 1554', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('13868210', '2', 'WOLFGANG LIEBSCH DIAZ', null, 'WOLFGANG LIEBSCH DIAZ', '982710290', 'IGNACIO CARRERA PINTO 908', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76262882', '1', 'ICME LTDA', null, 'ICME LTDA', '935628450', 'SERRANO 849', 'ANTOFAGASTA ', 'INGENIERIA Y CONSTRUCCION  ');
INSERT INTO `clientes` VALUES ('76732124', '4', 'ANTOFAGASTA SERVICE', null, 'ANTOFAGASTA SERVICE', '967270457', 'MANUEL VERBAL . 1525', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76132593', '0', 'GESTA SERVICIOS A LA MINERIA SPA.', null, 'MSH MINERIA ', '982937327', 'LIPARITA 135', 'ANTOFAGASTA ', 'SERVICIOS A LA MINERIA');
INSERT INTO `clientes` VALUES ('96849540', '2', 'TRANSPORTE VIGAL S.A', null, 'TRANSPORTE VIGAL S.A', '322819637', 'LA HIGUIERA LOTE 6 ACC BITUMIX', 'CONCON VALPARAISO', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('76507666', '8', 'FLOR DEL VALLE SERVICIOS', null, 'FLOR DEL VALLE SERVICIOS', '978461476 ', 'SAN MIGUEL 345', 'ANTOFAGASTA ', 'FERRETERIA INDUSTRIAL,TRANSPORTES Y SERVICIOS');
INSERT INTO `clientes` VALUES ('65728790', '3', 'CORPORACION FONDO DE BIENESTAR EMABLOS S A', null, 'CORPORACION FONDO DE BIENESTAR EMABLOS S A', '552765742 ', 'OHHIGINS 1964', 'ANTOFAGASTA ', 'CORPORACION ');
INSERT INTO `clientes` VALUES ('61103019', '3', 'FUERZA AEREA DE CHILE', null, 'FUERZA AEREA DE CHILE', '977698096', 'BASE AEREA CERRO MORENO', 'ANTOFAGASTA ', 'GOB CENTRAL Y ADM . PUBLICA ');
INSERT INTO `clientes` VALUES ('13328822', '8', 'RICARDO HONORES', null, 'RICARDO HONORES', '983280700', 'AV.OVIEDO CAVADA 3651', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76257428', '4', 'SHIMIN INGENIERIA SPA', null, 'SHIMIN INGENIERIA', '224490360', 'AV VITACURA 2808 OF 501', 'SANTIAGO', 'SERVICIOS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('77572850', '7', 'SCANCONTROLS ING. LTDA.', null, 'SCANCONTROLS ING. LTDA.', '552 477634', 'GRAN AVENIDA RADOMIRO TOMIC NÂ°8153', 'ANTOFAGASTA ', 'REPRESENTACIONES');
INSERT INTO `clientes` VALUES ('77780170', '8', 'CONSTRUCTORA BAICAL LTDA', null, 'CONSTRUCTORA BAICAL LTDA', '552 485999', 'BLUMELL 016', 'ANTOFAGASTA ', 'CONSTRUCTORA ');
INSERT INTO `clientes` VALUES ('99595800', '7', 'TECNOLOGIA Y SERVICIOS PARA LA INDUSTRIA DEL TRANSPORTE Y LA MINERIA S.A.', null, 'TESRA S.A.', '552 945377', 'CALLE AZAPA NÂ°6930', 'ANTOFAGASTA ', 'INGENIERIA');
INSERT INTO `clientes` VALUES ('77059162', '7', 'COMERCIALIZADORA GLOCAL EMPORIUM SPA', null, 'COMERCIALIZADORA GLOCAL EMPORIUM SPA', '2897863', 'AV. PEDRO AGUIRRE CERDA NÂ°8251 LOCAL15', 'ANTOFAGASTA ', 'LIBRERIA');
INSERT INTO `clientes` VALUES ('11946737', '3', 'JHOANA MARIN ', null, 'JHOANA MARIN ', '982932703', 'AV . OHIGGINS 1650 DEP. 1002', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76381978', '7', 'INGENIERIA Y CONSTRUCCION MYD LTDA', null, 'INGENIERIA Y CONSTRUCCION MYD LTDA', '24789400', 'LOTE 12 SUBDIVISION CHOLGUAGUE', 'LOS ANGELES', 'INGENIERIA Y CONSTRUCCION  ');
INSERT INTO `clientes` VALUES ('76947246', '0', 'RISCK CONTROL SPA ', null, 'RISCK CONTROL SPA ', '965104725', 'HERMOGENES ALFARO 1234 2', 'ANTOFAGASTA ', 'CONSTRUCCION DE OTRAS OBRAS DE INGENIERIA');
INSERT INTO `clientes` VALUES ('77073480', '0', 'A-PORT OPERACIONES S.A. ', null, 'A-PORT OPERACIONES S.A. ', '2254998', 'AVDA. VITACURA 2736 2101 ', 'SANTIAGO', 'COMPRA, VENTA Y ALQUILER ');
INSERT INTO `clientes` VALUES ('76446262', '9', 'ESTUDIO JURIDICO CRISTIAN OGALDE MESSINA Y COMPANIA LTDA', null, 'ESTUDIO JURIDICO CRISTIAN OGALDE MESSINA Y COMPANIA LTDA', '988277965', 'BAQUEDANO 239 519 CENTRO ', 'ANTOFAGASTA ', 'ACTIVIDADES DE AGENCIAS DE COBRO ');
INSERT INTO `clientes` VALUES ('76079600', 'K', 'MADERO COMUNICACIONES LTDA', null, 'MADERO COMUNICACIONES LTDA', '219020-498235', 'ENRIQUE VILLEGAS 2061 P.P.FIGUEROA ', 'COPIAPO', 'TRANSMISIONES DE RADIO ');
INSERT INTO `clientes` VALUES ('7016316', '0', 'NICOLAS FERNANDO ARRIETA CONCHA ', null, 'NICOLAS FERNANDO ARRIETA CONCHA ', '552 389779', 'ARTURO PRAT 470 3 ', 'ANTOFAGASTA ', 'SERVICIO NOTARIAL ');
INSERT INTO `clientes` VALUES ('77461750', '7', 'LIEBHERR CHILE SPA', null, 'LIEBHERR CHILE SPA', '(55) 2718557 ', 'LA NEGRA GRANADEROS 4155', 'ANTOFAGASTA ', 'MANTENCION,ASISTENCIA TECNICA DE MAQUINARIA');
INSERT INTO `clientes` VALUES ('11722632', '8', 'SAMUEL KONG', null, 'SAMUEL KONG', '995957173', 'ADAMSON 3321', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76683564', '3', 'SOCIEDAD CHILE ENGINELI GROUP SPA', null, 'SOCIEDAD CHILE ENGINELI GROUP SPA', '92235487', 'ADAMSON 3321', 'ANTOFAGASTA ', 'INGENIERIA Y TWELECOMUNICACIONES');
INSERT INTO `clientes` VALUES ('76134245', '2', 'HL INGENIERIA SPA', null, 'HL INGENIERIA SPA', '22 9445762', 'AVENIDA NUEVA PROVIDENCIA 2353 10', 'SANTIAGO', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F');
INSERT INTO `clientes` VALUES ('24334035', '7', 'NATALIA HURTADO', null, 'NATALIA HURTADO', '934362437 ', '14 DE FEBRERO 3121 DEP-. 201', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76400472', '8', 'CJC PREMIUM SPA', null, 'CJC PREMIUM SPA', '994837159', 'SOTOMAYOR 1952 CENTRO', 'CALAMA', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('16133237', '2', 'alexis nunez', null, 'alexis nunez', '942726620', 'av. Padre hurtado 3578', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('12347432', '5', 'NELLY CRISTINA ALVARADO ARAYA', null, 'NELLY CRISTINA ALVARADO ARAYA', '958189232', 'SAAVEDRA 2283 CENTRO ALTO ', ' ANTOFAGASTA ', 'ACTIVIDADES DE SERVICIOS RELACIONADAS CO ');
INSERT INTO `clientes` VALUES ('16450044', '6', 'YURI CONTRERAS', null, 'YURI CONTRERAS', '984003681', 'LUIS CARRASCO 9396', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('12365746', '2', 'SERGIO RETAMALES', null, 'SERGIO RETAMALES', '774040', 'SAN MARTIN ', 'ANTOFAGASTA', 'ODONTOLOGÃA');
INSERT INTO `clientes` VALUES ('96945150', '6', 'OHL INDUSTRIAL CHILE S.A', null, 'OHLI', '227319400', 'CERRO EL PLOMO 5855 PISO 15', 'LAS CONDES SANTIAGO', 'obras de ingenieria ');
INSERT INTO `clientes` VALUES ('76036872', '5', 'CAPACITACION INTEGRAL ATACAMA LTDA', null, 'CIAL CAPACITACION ', '552 485255', 'ANTONIO VARAS NÂ°626', 'ANTOFAGASTA ', 'SERVICIO DE CAPACITACION ');
INSERT INTO `clientes` VALUES ('76768702', '8', 'SERVICIOS MECATRONICA SPA', null, 'SERVICIOS MECATRONICA SPA', '0', 'AMANECER 518 9 LASCAR ', 'ANTOFAGASTA ', 'TERMINACION Y ACABADO DE EDIFICIOS ');
INSERT INTO `clientes` VALUES ('77242190', '7', 'VEAS FERNANDEZ ASOCIADOS SPA', null, 'SERCONOR SPA', '552 897790-897789-897788', 'TENIENTE URIBE 636 OF403', 'ANTOFAGASTA ', 'CONTABILIDADES');
INSERT INTO `clientes` VALUES ('65086877', '3', 'fuerza animal', null, 'fuerza animal', '944990733', 'abracita 1600', 'ANTOFAGASTA ', 'clinica veterinaria');
INSERT INTO `clientes` VALUES ('76356183', '6', 'DIPRO-FIRE CHILE LIMITADA', null, 'DIPRO-FIRE', '552 540811/847107', 'JUAN GLASINOVIC 480 GALPON 38', 'ANTOFAGASTA', 'SISTEMA CONTRA INCENDIOS ');
INSERT INTO `clientes` VALUES ('16245135', '9', 'NAZELY LUCO ', null, 'NAZELY LUCO ', '961422072', 'ANTILHUE 01613', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76136141', '4', 'GTS TRANSPORTES', null, 'GTS TRANSPORTES', '961398292', 'AV. REPUBLICA DE CROACIA 0416', 'ANTOFAGASTA ', 'TRANSPORTES ');
INSERT INTO `clientes` VALUES ('78075740', 'K', 'REALINI FUENTES CIA LTDA', null, 'OCYRE', '556 896579', 'MANZANA 3 SITIO 19 SECTOR PUERTO SECO', 'CALAMA', 'CONSTRUCCION Y SERVICIOS ');
INSERT INTO `clientes` VALUES ('61979830', '9', 'SUBSECRETARIA DE ENERGIA', null, 'SUBSECRETARIA DE ENERGIA', '56223656605', 'GENERAL BORGONO 934 OF 402', 'ANTOFAGASTA ', 'ACTIVIDADES DE LA ADMINISTRACION PUBLICA');
INSERT INTO `clientes` VALUES ('78438660', '0', 'PRODUCTORA DE ALGAS MARINAS S.A ', null, 'PRODALMAR S.A', '552 284148- 552 556713', 'GRAL VELASQUEZ 890 602 ', 'ANTOFAGASTA ', 'CULTIVO, REPRODUCCION Y MANEJO DE ALGAS ');
INSERT INTO `clientes` VALUES ('77928160', '4', 'GEDES, GESTION Y DESARROLLO LIMITADA', null, 'GEDES, GESTION Y DESARROLLO LIMITADA', '0', 'DIAZ GANA 1071 101', 'ANTOFAGASTA ', 'ACTIVIDADES DE CONSULTORIA DE GESTION ');
INSERT INTO `clientes` VALUES ('76284812', '0', 'INMOBILIARIA ANTOFAGASTA CENTRO SPA', null, 'HUB COLIVING', '222461138', 'ESTEBAN DELL ORTO 4515 6615', 'SANTIAGO', 'ALQUILER DE BIENES INMUEBLES');
INSERT INTO `clientes` VALUES ('96846410', '8', 'STEEL INGENIERIA S.A.', null, 'STEEL INGENIERIA S.A.', '56-34-2490000', 'AVENIDA ARGENTINA ORIENTE 17, OFICINA 209, LOS ANDES', 'SANTIAGO', 'MANTENCION INDUSTRIAL, OBRAS CIVILES');
INSERT INTO `clientes` VALUES ('99580830', '7', 'NEW TECH COPPER SPA', null, 'NEW TECH COPPER SPA', '992205467', 'liparita 168', 'ANTOFAGASTA ', 'servicio a la  mineria ');
INSERT INTO `clientes` VALUES ('78829890', '0', 'INGENIERIA EN SANITIZACION SOCIEDAD ANONIMA', null, 'SERGIO CESPEDES TOLEDO', '979896598', 'AV. HUAMACHUCO 12946: LA CHIMBA', 'ANTOFAGASTA ', 'INGENIERA  ENSANITIZACION');
INSERT INTO `clientes` VALUES ('92805000', '9', 'ABB S A ', null, 'ABB S A ', '0', 'V MACKENNA 1602', 'NUNOA SANTIAGO', 'OTRAS INDUSTRIAS MANUFACTURERAS N.C.P. ');
INSERT INTO `clientes` VALUES ('76129826', '7', 'VECCHIOLA INGENIERIA Y CONSTRUCCION ', null, 'VECCHIOLA INGENIERIA Y CONSTRUCCION ', ' 978068301', 'PANAMERICANA NORTE KM 809', 'COPIAPO', 'OBRAS CIVILES Y MOVIMIENTO DE TIERRA ');
INSERT INTO `clientes` VALUES ('77515180', '3', 'ESTRADA Y CIA LIMITADA', null, 'ESTRADA Y CIA LIMITADA', '552253388', 'ARTURO PRAT 214 OF 405', 'ANTOFAGASTA ', 'SERVICIOS JURIDICOS');
INSERT INTO `clientes` VALUES ('76031066', '2', 'SOCIEDAD TRANSPORTES Y ARRIENDO DE MAQUINARIAS STARTER MOTORS LIMITADA', null, 'STARTER MOTORS', '55 2565170', 'VALDIVIA 5714', 'ANTOFAGASTA ', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('76371830', '1', 'INVERSIONES SAN MARTIN LIMITADA', null, 'HOTEL SAN MARTIN', '55 2458888 - 55 2458889', 'Avenida General JosÃ© De San MartÃ­n 2781', 'ANTOFAGASTA ', 'HOTEL ');
INSERT INTO `clientes` VALUES ('15019147', '5', 'ANDREA CONCHA', null, 'ANDREA CONCHA', '947497307', 'LOS EXPLORADORES 14011 CS 146', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('96789280', '7', 'CIA PORTUARIA MEJILLONES S A ', null, 'PUERTO MEJILLONES', '0', 'AV LONGITUDINAL 5500 ', 'MEJILLONES', 'CONSTRUCCION DE OTRAS OBRAS DE INGENIERI ');
INSERT INTO `clientes` VALUES ('76156521', '4', 'COBRA MONTAJES, SERVICIOS Y AGUA LIMITADA ', null, 'COBRA MSA', '225781900', 'LOS MILITARES 5885 P 10 ', 'LAS CONDES SANTIAGO', 'INGENIERIA Y CONSTRUCCION  ');
INSERT INTO `clientes` VALUES ('76453379', '8', 'ABBA MONTAJES SPA ', null, 'ABBA MONTAJES SPA ', '935620779', 'AVENIDA INDUSTRIAL 8090 ', 'ANTOFAGASTA', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F ');
INSERT INTO `clientes` VALUES ('76004534', '9', 'TRANSPORTES GAC LIMITADA', null, 'TRANSPORTES GAC LIMITADA', '0', 'Oficina Petronila 274', 'ANTOFAGASTA ', 'MANTENIMIENTO Y REPARACION DE VEHICULOS');
INSERT INTO `clientes` VALUES ('65077905', '3', 'FUNDACION DE CULTURA Y TURISMO DE SAN PEDRO DE ATACAMA ', null, 'FUNDACION DE CULTURA Y TURISMO DE SAN PEDRO DE ATACAMA', '952233788', 'IGNACIO CARRERA PINTO 547', 'SAN PEDRO ATACAMA', 'ACTIVIDADES DE OTRAS ASOCIACIONES  N.C.P');
INSERT INTO `clientes` VALUES ('77490350', 'K', 'RFP LOGISTICA S.A', null, 'RFP LOGISTICA S.A', '0', 'CARRETERA GENERAL SAN MARTIN 9290', 'QUILICURA', 'LOGISTICA ');
INSERT INTO `clientes` VALUES ('13043560', '2', 'ALEJANDRO ROA', null, 'ALEJANDRO ROA', '963754092 / 984074197', 'MAIPU 1414', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76060841', '6', 'OBRAS ESPECIALES CHILE S.A', null, 'OBECHILE', '227501500', 'AVENIDA PRESIDENTE RIESCO 5561 501-A', 'LAS CONDES SANTIAGO', 'OBRAS INGENIERIA');
INSERT INTO `clientes` VALUES ('76000158', '9', 'FAYRE MINERIA LIMITADA ', null, 'FAYRE MINERIA LIMITADA ', '227581200 / 966783855', 'JUAN GLASINOVIC 455', 'ANTOFAGASTA ', 'VENTA AL POR MAYOR NO ESPECIALIZADA ');
INSERT INTO `clientes` VALUES ('25267423', '3', 'MARIUXI SANDY PIBAQUE', null, 'MARIUXI SANDY PIBAQUE', '987544208', 'LINCANCABUR', 'SAN PEDRO ATACAMA', 'SERVICIOS GRAFICOS');
INSERT INTO `clientes` VALUES ('15017086', '9', 'JORGE CABEZAS', null, 'JORGE CABEZAS', '991616416', 'AV. SIERRANEVADA 10939 CASA 22', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76060289', '2', 'TTPM S.A.', null, 'TTPM S.A.', '552 552840', 'CALLE 9  NÂ°425, GALPON 16-17', 'ANTOFAGASTA ', 'SERVICIO A LA MINERIA');
INSERT INTO `clientes` VALUES ('76946077', '2', 'GETCOM SPA ', null, 'GETCOM SPA ', '0', 'LA ESTUDIANTINA 11725 ', 'ANTOFAGASTA ', 'OTRAS INSTALACIONES PARA OBRAS DE CONSTR ');
INSERT INTO `clientes` VALUES ('65803400', '6', 'SINDICATO N 1 DE EMPRESA ORICA CHILE ', null, 'SINDICATO N 1 DE EMPRESA ORICA CHILE ', '0', 'CAMINO A MEJILLONES KM 8 ', 'ANTOFAGASTA ', 'ACTIVIDADES DE SINDICATOS');
INSERT INTO `clientes` VALUES ('20213167', '0', ' FERNANDA CORNEJO', null, ' FERNANDA CORNEJO', '930723182', 'HECTOR ROJAS 9674', 'ANTOFAGASTA', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76003181', 'K', 'MAURICIO ABELARDO CARVAJAL VARGAS TRANSPORTES DE CARGA E.I.R.L.', null, 'MAURICIO ABELARDO CARVAJAL VARGAS TRANSPORTES DE CARGA E.I.R.L.', '0', 'BORGONO 345 SECTOR CENTRO', 'MEJILLONES', 'TRANSPORTE DE CARGA POR CARRETERA');
INSERT INTO `clientes` VALUES ('76866001', '8', 'CONSORCIO PRODIEL-SANTA FE S.A.', null, 'CONSORCIO PRODIEL-SANTA FE S.A.', '0', 'AV. APOQUINDO 5400 2101', 'LAS CONDES SANTIAGO', 'CONSTRUCCION DE CARRETERAS Y LINEAS DE F ');
INSERT INTO `clientes` VALUES ('12442343', '0', 'CHRISTIAN ARAYA', null, 'CHRISTIAN ARAYA', '67861984', 'LOS  NARANJOS 27. DEP 407', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('18315170', '3', 'janeth mollo', null, 'janeth mollo', '962455044', 'pasaje sierra bella 9865', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('77189740', '1', 'ICL CÃTODOS LIMITADA', null, 'ICL CÃTODOS LIMITADA', '552538140', 'LAS INDUSTRIAS 325 PUERTO SECO', 'ANTOFAGASTA ', 'REPARACION Y MANTENCION DE CÃTODOS');
INSERT INTO `clientes` VALUES ('81242500', '5', 'COOPERATIVA DE CONSUMOS CARABINEROS', null, 'COOPERATIVA DE CONSUMOS CARABINEROS', '989233451', 'ANIBAL PINTO 3459', 'ANTOFAGASTA ', 'FABRICACION DE PRENDAS DE VESTIR DE MATE ');
INSERT INTO `clientes` VALUES ('70954900', '6', 'CORPORACION MUNICIPAL DE DESARROLLO SOCIAL DE CALAMA', null, 'COMDES', '55711823', 'AV BERNARDO OHIGGINS 1155 VILLA CHICA', 'CALAMA', 'EDUCACION Y SALUD');
INSERT INTO `clientes` VALUES ('76928183', '5', 'QUALITAS  INDUSTRIAL SPA', null, 'QUALITAS  INDUSTRIAL SPA', '952523066', 'URIBE 636 OFICINA 707', 'ANTOFAGASTA', 'OTROS NO CLASIFICADOS');
INSERT INTO `clientes` VALUES ('14056874', '0', 'Luis Rebolledo', null, 'Luis Rebolledo', '982897138', 'juan bautista 1626', 'CALAMA', 'PERSONAL');
INSERT INTO `clientes` VALUES ('11728712', '2', 'CRISTIAN VARGAS MEZA', null, 'CRISTIAN VARGAS MEZA', '940361906', 'LOS SULFUROS 1146', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('13724673', '2', 'OSCAR HERRERA', null, 'OSCAR HERRERA', '979676290', 'MANUEL VERBAL 1356', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('12696840', 'K', 'MARIA JOSE ALVAREZ ', null, 'MARIA JOSE ALVAREZ ', '997895690', 'SUBIDA DEL DESIERTO 0341', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('77044498', '5', 'TRANSPORTES TC', null, 'TRANSPORTES TC', '995310404', 'OSORNO 6490', 'ANTOFAGASTA ', 'SERVICIOS DE TRANSPORTE DE TRABAJADORES');
INSERT INTO `clientes` VALUES ('76544188', '9', 'ARON ROJAS MHE MAESTRANZAS ', null, 'ARON ROJAS MHE MAESTRANZAS ', '938634667', 'HEROES DE LA CONCEPCION 23875', 'ANTOFAGASTA ', 'MAESTRANZAS');
INSERT INTO `clientes` VALUES ('6569463', '8', 'INES TORO', null, 'INES TORO', '996398978', 'PASAJE ELKI 1458 POBLACION PRAT D', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('23811657', '0', 'LUZ RODRIGUEZ ', null, 'LUZ RODRIGUEZ ', '965191961', 'EDUARDO WOLCMA', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('17937221', '5', 'EDUARDO JOFRE', null, 'EDUARDO JOFRE', '942486206', 'LOS MANZANOS CASA 127', 'ANTOFAGASTA ', 'PERSONAL');
INSERT INTO `clientes` VALUES ('76451669', '9', 'SERVICIOS INTEGRALES API SPA', null, 'SERVICIOS INTEGRALES API SPA', '932584042', 'ISMAEL VALDEZ VERGARA 514 D-4', 'SANTIAGO', 'EXPLOTACION DE MINAS');
INSERT INTO `clientes` VALUES ('76108995', '1', 'EMPRESA DE ARRENDAMIENTOS ASIS CHILE LTDA', null, 'EMPRESA DE ARRENDAMIENTOS ASIS CHILE LTDA', '976092298', 'CALLE 9 TALLER # 2 425', 'ANTOFAGASTA', 'VENTA AL POR MENOR DE OTROS PRODUCTOS EN');
INSE