<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require("../config/global.php");
require('../libs/fpdf/fpdf.php');
require('../modelos/ControladorBD.php');
require('../modelos/Clientes.php');
require('../modelos/ControlSalida.php');
//</editor-fold>

$clientes = new Clientes($_CONF);
$control = new ControlSalida($_CONF);

$idcontrol 	= $_GET['idControl'];

//Datos Orden de Compra
$cs				 	= $control->obtenerdatosControl($idcontrol);
$listainventario 	= $control->obtenerInventarioControl($idcontrol);
$listamaquinas 		= $control->obtenerMaquinasControl($idcontrol);

//Datos Cliente
$cliente			= $clientes->obtenerDatos($cs["rut"]);

class PDF extends FPDF
{
	//Cabecera de pagina
	function Header()
	{
		//Logo
		$this->Image('../imagenes/headerdoc.jpg',55,10,100,20);
		//Salto de l�nea
		$this->Ln(24);
	}

	//Tabla simple
	//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
	
	function BasicTable($header,$data)
	{
		
		//Cabecera
		$this->SetFillColor(220,220,220);
		foreach($header as $col)	
		{	$head = substr($col,0,8);
			if($head == "Descripc")
				$this->Cell(155,5,$col,1,0,'C',true);
			else
				$this->Cell(35,5,$col,1,0,'C',true);
		}
		$this->Ln();
		//Datos
		foreach($data as $row) //Por cada Array
		{
			$pos = 1;
			foreach($row as $col) //Por cada celda del Array
			{				
				if($pos == 2)
					$this->Cell(155,5,utf8_decode($col),1,0,'C');
				else
					$this->Cell(35,5,$col,1,0,'C');
					
				$pos++;
			}
			$this->Ln();
		}
	}
}
/* PRIMER CONTROL SALIDA */
$pdf=new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->SetFillColor(220,220,220);
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Cell(0,5,'CONTROL SALIDA DE MATERIALES DE BODEGA  No '.$cs["IDcontrol"],0,3,'C',true);
$pdf->Ln();
$pdf->Cell(40,5,'Razon Social:');
$pdf->Cell(40,5,$cliente["razonsocial"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Rut:');
$pdf->Cell(40,5,$cliente["rut"]."-".$cliente["dv"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Nombre:');
$pdf->Cell(40,5,$cliente["nombre"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Direccion:');
$pdf->Cell(40,5,$cliente["direccion"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Telefono:');
$pdf->Cell(40,5,$cliente["telefono"],0,0,'L');
$pdf->Cell(25,5,'Ciudad:');
$pdf->Cell(40,5,$cliente["ciudad"],0,1,'L');
$pdf->Ln();

$header=array('Cantidad','Descripcion');

if(is_array($listainventario))
{
	foreach($listainventario as $c)
	{		
		$data[]=array($c["cantidad"], $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["codinterno"]." - ".$c["modelo"]);
		
		//$data[]=array($c["cantidad"], $c["nombrecategoria"]." ".$c["nombremarca"]." ".$c["codinterno"]);	
		//$data[]=array($c["cantidad"], $c["nombrecategoria"]." ".$c["nombremarca"]." - ".$c["codinterno"]);
	}//fin lista
}
else
{
	$data[]=array('','');
}

$pdf->BasicTable($header,$data);
$pdf->Ln();
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
//Persona que recibe
$pdf->Cell(20,7,'Nombre:');
$pdf->Cell(65,7,$cs["nombrecliente"],0,0,'L');
$pdf->Cell(20,7,'Rut:');
$pdf->Cell(40,7,$cs["rutcliente"],0,0,'L');
$pdf->Ln();
$pdf->Cell(20,7,'Firma:');
$pdf->Cell(40,7,'');
$pdf->Cell(25,7,'Fecha/Hora:');
$pdf->Cell(40,7,gmdate("d-m-Y",strtotime($cs["fecha"]))." ".$cs["hora"],0,0,'L');
$pdf->Cell(20,7,'Recinto:');
$pdf->Cell(40,7,$cs["recinto"],0,0,'L');
$pdf->Ln();
$pdf->Cell(30,7,'Centro de Costo:');
$pdf->Cell(25,7,$cs["nombreCentroCosto"],0,0,'L');
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'__________________________',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'__________________________',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Ln();
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'Despache Conforme',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'Recibi Conforme',0,0,'C');
$pdf->Cell(30,5,'',0,1,'C');
$pdf->Ln(10);

/* SEGUNDO CONTROL SALIDA */
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
$pdf->Image('../imagenes/headerdoc.jpg',55,null,100,20);
$pdf->Ln();
$pdf->Cell(0,5,'CONTROL SALIDA DE MATERIALES DE BODEGA  No '.$cs["IDcontrol"],0,3,'C',true);
$pdf->Ln();
$pdf->Cell(40,5,'Razon Social:');
$pdf->Cell(40,5,$cliente["razonsocial"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Rut:');
$pdf->Cell(40,5,$cliente["rut"]."-".$cliente["dv"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Nombre:');
$pdf->Cell(40,5,$cliente["nombre"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Direccion:');
$pdf->Cell(40,5,$cliente["direccion"],0,0,'L');
$pdf->Ln();
$pdf->Cell(40,5,'Telefono:');
$pdf->Cell(40,5,$cliente["telefono"],0,0,'L');
$pdf->Cell(25,5,'Ciudad:');
$pdf->Cell(40,5,$cliente["ciudad"],0,1,'L');
$pdf->Ln();

$header=array('Cantidad','Descripcion');
$pdf->BasicTable($header,$data);
$pdf->Ln();
//function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
//Persona que recibe
$pdf->Cell(20,7,'Nombre:');
$pdf->Cell(65,7,$cs["nombrecliente"],0,0,'L');
$pdf->Cell(20,7,'Rut:');
$pdf->Cell(40,7,$cs["rutcliente"],0,0,'L');
$pdf->Ln();
$pdf->Cell(20,7,'Firma:');
$pdf->Cell(40,7,'');
$pdf->Cell(25,7,'Fecha/Hora:');
$pdf->Cell(40,7,gmdate("d-m-Y",strtotime($cs["fecha"]))." ".$cs["hora"],0,0,'L');
$pdf->Cell(20,7,'Recinto:');
$pdf->Cell(40,7,$cs["recinto"],0,0,'L');
$pdf->Ln();
$pdf->Cell(30,7,'Centro de Costo:');
$pdf->Cell(25,7,$cs["nombreCentroCosto"],0,0,'L');
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'__________________________',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'__________________________',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Ln();
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'Despache Conforme',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');
$pdf->Cell(50,5,'Recibi Conforme',0,0,'C');
$pdf->Cell(30,5,'',0,0,'C');

$pdf->Output("ControlSalida",'I');

?>