<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
//</editor-fold>

class Usuarios {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LOGIN">
	public function login($rut, $pass)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM usuarios
				WHERE rut = '$rut'
				AND pass = '$pass'
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function changePass($rut, $pass)
	{
		$sql = 	"
				UPDATE usuarios
				SET pass = '$pass'
				WHERE rut = '$rut'
				";
		return $this->controladorBD->query($sql);
	}
	
	public function changeEstado($rut, $estado)
	{
		$sql = 	"
				UPDATE usuarios
				SET estado = $estado
				WHERE rut = '$rut'
				";
		return $this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $whereArea)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM usuarios, areas
				WHERE (apellidos LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%' ) AND
				usuarios.area = areas.idarea $whereArea
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $whereArea)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM usuarios
				WHERE (apellidos LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%') $whereArea	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarAreas">
	public function listarAreas()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM areas
				ORDER BY nombrearea
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : existe">
	public function existe($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT rut
				FROM usuarios
				WHERE rut = '$rut'
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($rut, $dv, $nombre, $apellido, $telefono, $direccion, $area, $pass, $correo)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO 
				    usuarios (
				              rut, 
				              dv, 
				              nombre, 
				              apellidos, 
				              fono, 
				              direccion, 
				              area, 
				              pass, 
				              correo)
				VALUES (
				       '{$rut}', 
				       '{$dv}', 
				       '{$nombre}', 
				       '{$apellido}', 
				       '{$telefono}', 
				       '{$direccion}', 
				       '{$area}', 
				       '{$pass}', 
				       '{$correo}');
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
	public function eliminar($rut)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				DELETE FROM 
				            usuarios
				WHERE 
				      rut = '{$rut}';
				");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatos">
	public function obtenerDatos($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM usuarios
				WHERE rut =	'$rut'	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificar">
	public function modificar($rut, $nombre, $apellido, $telefono, $direccion, $area, $correo)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE usuarios
				SET 
				    nombre = '{$nombre}', 
				    apellidos = '{$apellido}', 
				    fono = '{$telefono}',
				    direccion = '{$direccion}', 
				    area = {$area}, 
				    correo = '{$correo}'
				WHERE 
				      rut = '{$rut}';
				");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : restablecerPass">
	public function restablecerPass($rut, $pass)
	{
        $this->NX_DB->CONECTAR();
        try {
            $this->NX_DB->QUERY("
				UPDATE 
				    usuarios
				SET 
				    pass = '{$pass}', 
				    estado = 0
				WHERE 
				      rut = '{$rut}';
				");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarUsuariosArea">
	public function listarUsuariosArea($area)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM usuarios
				where area = {$area}
				ORDER BY apellidos
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

}