<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
//</editor-fold>

class ReportTalonario {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenertalonarios">
	public function obtenertalonarios($rut, $estado)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT reporttalonarios.*
				FROM reporttalonarios
				WHERE reporttalonarios.ruttecnico='$rut' and
				reporttalonarios.estado = $estado
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenertalonarioactual">
	public function obtenertalonarioactual($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT reporttalonarios.*
				FROM reporttalonarios
				WHERE reporttalonarios.ruttecnico='$rut' and
				reporttalonarios.estado = 1
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenercantidadtalonarios">
	public function obtenercantidadtalonarios($rut, $estado)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS TOTAL
				FROM reporttalonarios
				WHERE reporttalonarios.ruttecnico = '$rut' and
				reporttalonarios.estado = $estado
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function ingresartalonario($rut, $estado, $numinicio, $numfinal)
	{
		$sql = 	"
				INSERT INTO reporttalonarios(ruttecnico, estado, numactual, numinicial, numfinal, fecha)
				VALUES('$rut', $estado, $numinicio, $numinicio, $numfinal, NOW())
				";
		return $this->controladorBD->fetchId($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cambiarnumeroactual">
	public function cambiarnumeroactual($idtalonario, $newnumeroactual)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE reporttalonarios
				SET numactual = $newnumeroactual
				WHERE reporttalonarios.IDtalonario = $idtalonario
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

	public function cambiarestado($idtalonario, $estado)
	{
		$sql = 	"
				UPDATE reporttalonarios
				SET estado = $estado
				WHERE reporttalonarios.IDtalonario = $idtalonario
				";
		return $this->controladorBD->query($sql);
	}
	
	public function obtenernuevotalonario($rut)
	{
		$sql = 	"
				SELECT MIN(IDtalonario)
				FROM reporttalonarios
				WHERE ruttecnico = '$rut' and
				estado = 2
				";
		return $this->controladorBD->fetchOne($sql);		
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaranulado">
	public function ingresaranulado($idtalonario, $numero, $razon)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO reportanulados(IDtalonario, numanulado, detalle, fecha)
				VALUES($idtalonario, '$numero', '$razon', NOW())
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

}