﻿<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class OrdenTrabajo {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numeroot, $rut, $idtalonario, $responsable, $fecha, $totalneto, $tipopago)
	{
		list( $dia, $mes, $anio) = explode( '-', $fecha );
		$fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO ot(IDot, rutcliente, idtalonario, nombreresp, fecha, total, tipopago)
				VALUES('$numeroot', '$rut', '$idtalonario', '$responsable', '$fecha2', $totalneto, $tipopago ) 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerservicios">
	public function obtenerservicios($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM servicios
				WHERE IDCliente = '{$rut}'
				ORDER BY servicios.servicio ASC
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerserviciosBuscar">
	public function obtenerserviciosBuscar($rut,$servicio)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM servicios
				WHERE IDCliente = '{$rut}'
				AND servicio like '%{$servicio}%'
				ORDER BY servicios.servicio ASC
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarservicios">
	public function ingresarservicios($numeroot, $rut, $servicios, $cantorig, $coporig, $unidades, $precio)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO otservicios(IDot, rutcliente, IDservicio, cantoriginales, copiasoriginales, unidades, precio)
				VALUES('{$numeroot}', '{$rut}', '{$servicios}', {$cantorig}, {$coporig}, {$unidades}, {$precio}) 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar_ot_cliente">
	public function listar_ot_cliente($inicial, $resultados, $buscar, $rut, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM ot
				WHERE rutcliente = '$rut' AND
				CAST( ot.IDot AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad_ot_cliente">
	public function cantidad_ot_cliente($buscar, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS 'cantidad'
				FROM ot
				WHERE rutcliente = '$rut' AND				
				CAST( ot.IDot AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>
	
	public function asignarboleta($idot, $rut, $numboleta, $tipopago, $ajuste, $totalapagar)
	{
		$sql = 	"
				UPDATE ot
				SET numboleta = $numboleta,
				tipopago = $tipopago,
				ajuste = $ajuste,
				totalapagar = $totalapagar
				WHERE ot.IDot = $idot AND
				ot.rutcliente = '$rut' 
				";	
		return $this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosOT">
	public function obtenerdatosOT($idot, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM ot, clientes, tipospagoot
				WHERE ot.IDot = {$idot} AND
				clientes.rut = '{$rut}' AND
				ot.rutcliente = '{$rut}' AND
				ot.tipopago = tipospagoot.idTipoPagoOT;");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerServiciosOT">
	public function obtenerServiciosOT($idot, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM otservicios, servicios
				WHERE otservicios.IDot = $idot AND
				otservicios.rutcliente = '$rut' AND
				servicios.IDservicio = otservicios.IDservicio
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM ot, clientes
				WHERE ot.rutcliente = clientes.rut AND
				razonsocial LIKE '%" . addslashes($buscar) . "%'  
				{$fechas};
				");
        if($this->NX_DB->NUM_ROWS() >= 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM ot, clientes, tipospagoot
				WHERE ot.rutcliente = clientes.rut AND
				ot.tipopago = tipospagoot.idTipoPagoOT AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				{$fechas}
				ORDER BY fecha
				LIMIT {$inicial}, {$resultados}
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarToExcelOTDetalle">
	public function listarTOEXCEL($buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM ot, clientes, tipospagoot
				WHERE ot.rutcliente = clientes.rut AND
				ot.tipopago = tipospagoot.idTipoPagoOT AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				ORDER BY fecha;
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarToExcelOTDetalle">
	public function listarToExcelOTDetalle($buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					ot.IDot,
					ot.rutcliente,
					ot.idtalonario,
					ot.idfactura,
					ot.nombreresp,
					ot.fecha,
					ot.numboleta,
					ot.idguia,
					ot.total,
					clientes.rut,
					clientes.dv,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre,
					clientes.telefono,
					clientes.direccion,
					clientes.ciudad,
					clientes.giro,
					otservicios.Id,
					otservicios.rutcliente,
					otservicios.IDservicio,
					otservicios.cantoriginales,
					otservicios.copiasoriginales,
					otservicios.unidades,
					otservicios.precio,
					otservicios.IDot,
					servicios.servicio,
					servicios.precio,
					servicios.tipocambio,
					servicios.IDCliente,
					tipospagoot.descripcion					
				FROM
					ot
					Inner Join clientes ON ot.rutcliente = clientes.rut
					Inner Join otservicios ON otservicios.IDot = ot.IDot
					Inner Join servicios ON otservicios.IDservicio = servicios.IDservicio
					Inner Join tipospagoot ON ot.tipopago = tipospagoot.idTipoPagoOT
				WHERE ot.rutcliente = clientes.rut
					AND razonsocial LIKE '%" . addslashes($buscar) . "%' 
					$fechas
				ORDER BY ot.fecha;
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : precioTotalLista">
	public function precioTotalLista($buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT SUM(total) as TOTAL
				FROM ot, clientes
				WHERE  ot.rutcliente = clientes.rut AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				{$fechas}
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarOT">
	public function actualizarOT($idot, $rut, $boleta, $totalneto, $responsable)
	{
        $this->NX_DB->CONECTAR();
        if($boleta == '')
			{
                $this->NX_DB->QUERY("
				UPDATE ot
				SET total = $totalneto, nombreresp = '$responsable'
				WHERE IDot = '$idot' AND rutcliente = '$rut'
				");
			}		
		else
			{
                $this->NX_DB->QUERY("
				UPDATE ot
				SET total = $totalneto, numboleta = $boleta, nombreresp = '$responsable'
				WHERE IDot = '$idot' AND rutcliente = '$rut'
				");
			}
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarServicios">
	public function actualizarServicios($id, $servicios, $cantorig, $coporig, $unidades, $precio)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE otservicios
		SET IDservicio = $servicios, cantoriginales = $cantorig, copiasoriginales = '$coporig', unidades = $unidades, precio = $precio
				WHERE Id = $id
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar_ot_cliente_anual">
	public function listar_ot_cliente_anual($rut, $anio)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				ot.rutcliente,
				count(ot.IDot) as Cantidad,
				monthname(ot.fecha) as Mes,
				month(ot.fecha) as MesNumero
				FROM ot
				WHERE rutcliente = '$rut'
				and year(ot.fecha) = '$anio'
				and ot.idfactura is null
				GROUP BY
				month(ot.fecha)
				order by month(ot.fecha)
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteConIdOt">
	public function obtenerDatosFacturacionMensualPorCliente($rut, $anio, $mes)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				count(ot.IDot) as Cantidad, 
				month(ot.fecha) AS MesNumero, 
				count(otservicios.IDservicio), 
				sum(otservicios.cantoriginales) as cantoriginales, 
				sum(otservicios.copiasoriginales) as copiasoriginales, 
				sum(otservicios.unidades) as unidades, 
				otservicios.precio, 
				servicios.servicio as nombreTipoServicio, 
				servicios.tipocambio 
				FROM ot INNER JOIN otservicios ON otservicios.IDot = ot.IDot INNER JOIN servicios ON servicios.IDservicio = otservicios.IDservicio 
				WHERE 
				ot.rutcliente = '$rut' 
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes'
				and ot.idfactura is null 
				group by 
				otservicios.IDservicio,
				otservicios.precio,
				servicios.servicio,
				servicios.tipocambio 
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteConIdOt">
	public function obtenerDatosFacturacionMensualPorClienteConIdOt($rut, $anio, $mes)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				ot.IDot, 
				month(ot.fecha) AS MesNumero, 
				otservicios.IDservicio, 
				otservicios.cantoriginales, 
				otservicios.copiasoriginales, 
				otservicios.unidades, 
				otservicios.precio, 
				servicios.servicio as nombreTipoServicio, 
				servicios.tipocambio 
				FROM ot INNER JOIN otservicios ON otservicios.IDot = ot.IDot INNER JOIN servicios ON servicios.IDservicio = otservicios.IDservicio 
				WHERE 
				ot.rutcliente = '$rut' 
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes'
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteSoloIdOt">
	public function obtenerDatosFacturacionMensualPorClienteSoloIdOt($rut, $anio, $mes)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				ot.IDot 
				FROM ot
				WHERE
				ot.rutcliente = '$rut'
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes'
				and ot.idfactura is null
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : grabarFactura">
	public function grabarFactura($rut, $mes, $anio, $numerofactura)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
			UPDATE ot	
			SET idfactura = $numerofactura
			WHERE rutcliente = '$rut'
			and year(fecha) = '$anio'
			and month(fecha) = '$mes'			
			");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>
}