<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class OrdenCompra {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT MAX(LAST_INSERT_ID(oc.IDoc)) AS NUMERO
				FROM oc;");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numerooc, $rutp, $fecha, $total, $condicionpago, $despacho)
	{
		list( $dia, $mes, $anio) = explode( '-', $fecha );
		$fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    oc (
				        IDoc, 
				        rutp, 
				        fecha, 
				        total, 
				        estado, 
				        condicionpago, 
				        despacho)
				VALUES(
				       {$numerooc}, 
				       '{$rutp}', 
				       '{$fecha2}', 
				       {$total}, 
				       2, 
				       '{$condicionpago}', 
				       '{$despacho}');");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritems">
	public function ingresaritems($numerooc, $id, $cant, $precio,$tipo)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    ocitems (
				             IDoc, 
				             IDproducto, 
				             cantidad, 
				             precio, 
				             tipo)
				VALUES(
				       {$numerooc}, 
				       '{$id}', 
				       {$cant}, 
				       {$precio}, 
				       {$tipo});");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarMaqServ">
	public function ingresarMaqServ($numerooc, $id, $cant, $precio, $tipo, $descripcion)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    ocitems (
				             IDoc, 
				             IDproducto, 
				             cantidad, 
				             precio, 
				             tipo, 
				             descripcion)
				VALUES(
				       {$numerooc}, 
				       '{$id}', 
				       {$cant}, 
				       {$precio}, 
				       {$tipo}, 
				       '{$descripcion}');");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $numoc, $orden, $whereTip, $desde, $hasta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
	    if (empty($numoc))
        {
            $this->NX_DB->QUERY("
				SELECT *
				FROM oc, proveedores
				WHERE rutp LIKE '%" . addslashes($buscar) . "%' AND
				proveedores.rut LIKE '%" . addslashes($buscar) . "%' AND
				oc.rutp = proveedores.rut AND
				fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') {$whereTip}
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados};");
        }
	    else
        {
            $this->NX_DB->QUERY("
				SELECT *
				FROM oc, proveedores
				WHERE
				    oc.IDoc = '{$numoc}' and 
				    oc.rutp = proveedores.rut
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados};");
        }
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarEXCEL">
	public function listarEXCEL($buscar, $numoc, $orden, $whereTip, $desde, $hasta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        if (empty($numoc))
        {
            $this->NX_DB->QUERY("
				SELECT
				oc.IDoc,
				oc.rutp,
				oc.fecha,
				oc.total,
				oc.estado,
				oc.numfactura,
				oc.condicionpago,
				oc.despacho,
				proveedores.rut,
				proveedores.razonsocial,
				proveedores.nombre,
				proveedores.telefono,
				proveedores.direccion,
				proveedores.ciudad,
				proveedores.giro,
				ocpagos.idPago,
				ocpagos.tipopago,
				ocpagos.numcheque30,
				ocpagos.numcheque60,
				ocpagos.numcheque90,
				ocpagos.numcheque120,
				ocpagos.montocheque30,
				ocpagos.montocheque60,
				ocpagos.montocheque90,
				ocpagos.montocheque120,
				ocpagos.numtransferencia,
				ocpagos.fechacredito,
				ocpagos.fechacheque30,
				ocpagos.fechacheque60,
				ocpagos.fechacheque90,
				ocpagos.fechacheque120,
				ocpagos.fechatransferencia,
				ocpagos.montotransferencia,
				tipospago.descripcion
				FROM
				oc
				Inner Join proveedores ON oc.rutp = proveedores.rut
				Left Outer Join ocpagos ON oc.IDoc = ocpagos.IDoc
				left outer Join tipospago ON ocpagos.tipopago = tipospago.idTipoPago
				WHERE rutp LIKE '%" . addslashes($buscar) . "%' AND
				proveedores.rut LIKE '%" . addslashes($buscar) . "%' AND
				oc.rutp = proveedores.rut AND
				fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') {$whereTip}
				ORDER BY {$orden};");
        }
        else
        {
            $this->NX_DB->QUERY("
				SELECT
				oc.IDoc,
				oc.rutp,
				oc.fecha,
				oc.total,
				oc.estado,
				oc.numfactura,
				oc.condicionpago,
				oc.despacho,
				proveedores.rut,
				proveedores.razonsocial,
				proveedores.nombre,
				proveedores.telefono,
				proveedores.direccion,
				proveedores.ciudad,
				proveedores.giro,
				ocpagos.idPago,
				ocpagos.tipopago,
				ocpagos.numcheque30,
				ocpagos.numcheque60,
				ocpagos.numcheque90,
				ocpagos.numcheque120,
				ocpagos.montocheque30,
				ocpagos.montocheque60,
				ocpagos.montocheque90,
				ocpagos.montocheque120,
				ocpagos.numtransferencia,
				ocpagos.fechacredito,
				ocpagos.fechacheque30,
				ocpagos.fechacheque60,
				ocpagos.fechacheque90,
				ocpagos.fechacheque120,
				ocpagos.fechatransferencia,
				ocpagos.montotransferencia,
				tipospago.descripcion
				FROM
				oc
				Inner Join proveedores ON oc.rutp = proveedores.rut
				Left Outer Join ocpagos ON oc.IDoc = ocpagos.IDoc
				left outer Join tipospago ON ocpagos.tipopago = tipospago.idTipoPago
				WHERE oc.IDoc = '{$numoc}' AND
				oc.rutp = proveedores.rut;");
        }
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadEXCEL">
	public function cantidadEXCEL($buscar, $whereTip, $desde, $hasta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM oc, proveedores
				WHERE rutp LIKE '%" . addslashes($buscar) . "%' AND
				proveedores.rut LIKE '%" . addslashes($buscar) . "%' AND
				oc.rutp = proveedores.rut AND
				fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') {$whereTip};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    public function listarOCPendientes($yeardesde)
    {
        $sql = "
            SELECT
                oc.IDoc,
                oc.rutp,
                oc.fecha,
                oc.estado,
                oc.condicionpago,
                oc.despacho,
                datediff(curdate(),oc.fecha) as dias
                from oc
                where year(fecha) >= $yeardesde
                and  (estado =2 
                or estado = 1)
                order by fecha desc";
        return $this->controladorBD->fetchAll($sql);
    }

    public function listarOCPendientesPago()
    {
        $sql = "
select * ,
datediff(curdate(),fechacredito) as diascredito,
datediff(curdate(),fechacheque30) as diascheque30,
datediff(curdate(),fechacheque60) as diascheque60,
datediff(curdate(),fechacheque90) as diascheque90,
datediff(curdate(),fechacheque120) as diascheque120,
oc.rutp,
oc.total
from 
ocpagos,oc
where 
ocpagos.IDoc in (
        SELECT
oc.IDoc
from oc
where estado =2 
or estado = 1
order by fecha desc
)
and tipopago in (1,2)
and oc.IDoc= ocpagos.IDoc
order by ocpagos.IDoc desc
";
        return $this->controladorBD->fetchAll($sql);
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : anios">
	public function anios()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT DISTINCT YEAR(fecha) anio
				FROM oc
				ORDER BY anio;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : aniosDesc">
	public function aniosDesc()
	{
		$this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT DISTINCT YEAR(fecha) anio
				FROM oc
				ORDER BY anio DESC;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $numoc, $whereTip, $desde, $hasta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        if (empty($numoc))
        {
            $this->NX_DB->QUERY("
                    SELECT count(*) AS TOTAL
                    FROM oc, proveedores
                    WHERE rutp LIKE '%" . addslashes($buscar) . "%' AND
                    proveedores.rut LIKE '%" . addslashes($buscar) . "%' AND
                    oc.rutp = proveedores.rut AND
                    fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') {$whereTip};");
        }
        else
        {
            $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM oc, proveedores
				WHERE
				    oc.IDoc = '{$numoc}' and 
				    oc.rutp = proveedores.rut;");
        }
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosOC">
	public function obtenerdatosOC($idoc)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM oc, proveedores
				WHERE oc.IDoc = {$idoc} AND
				proveedores.rut = oc.rutp;");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsInventarioOC">
	public function obtenerItemsInventarioOC($idoc)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("			
				SELECT ocitems.*, inventario.*, categorias.nombrecategoria, marcasmaquina.nombremarca
				FROM ocitems, inventario, categorias, marcasmaquina
				WHERE ocitems.IDoc = {$idoc} AND
				inventario.marca = marcasmaquina.ID AND
				ocitems.IDproducto = inventario.ID AND
				inventario.categoria = categorias.IDcategoria;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsMaqServOC">
	public function obtenerItemsMaqServOC($idoc)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ocitems.*
				FROM ocitems
				WHERE ocitems.IDoc = $idoc AND
				ocitems.IDproducto = 'ESPECIAL'");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerProductosOC">
	public function obtenerProductosOC($idoc)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("			
				SELECT ocitems.*
				FROM ocitems
				WHERE ocitems.IDoc = {$idoc} AND
				tipo = 1;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarOC">
	public function actualizarOC($idoc, $valor, $col)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE oc
				SET {$col} = {$valor}
				WHERE IDoc = {$idoc};");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarItemOC">
	public function actualizarItemOC($idocitem, $valor, $col)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE ocitems
				SET {$col} = {$valor}
				WHERE IDocitem = {$idocitem};");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : borrarItemOC">
	public function borrarItemOC($idocitem)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				DELETE FROM ocitems
				WHERE IDocitem = {$idocitem};");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : borrarinventarioOC">
	public function borrarinventarioOC($idoc, $idprod)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				DELETE FROM ocinventario
				WHERE IDproducto = '{$idprod}' AND
				IDoc = {$idoc};");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarOcDetalleExcel">
	public function listarOcDetalleExcel($buscar, $numoc, $orden, $whereTip, $desde, $hasta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        if (empty($numoc)) {
            $this->NX_DB->QUERY("
                SELECT
                    oc.IDoc,
                    proveedores.razonsocial,
                    proveedores.rut,
                    proveedores.nombre,
                    proveedores.direccion,
                    proveedores.telefono,
                    proveedores.ciudad,
                    proveedores.giro,
                    oc.fecha,
                    oc.numfactura,
                    ocitems.cantidad,
                    categorias.nombrecategoria,
                    marcasmaquina.nombremarca,
                    inventario.modelo,
                    inventario.descripcion,
                    ocitems.IDproducto,
                    inventario.codinterno,
                    ocitems.precio,
                    oc.total,
                    inventario.numparte,
                    estado
                FROM
                    oc
                    Inner Join ocitems ON oc.IDoc = ocitems.IDoc
                    Inner Join inventario ON ocitems.IDproducto = inventario.ID
                    Inner Join categorias ON inventario.categoria = categorias.IDcategoria
                    Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
                    Inner Join proveedores ON oc.rutp = proveedores.rut
                WHERE
                    oc.rutp LIKE '%" . addslashes($buscar) . "%'
                    and fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}')  
                    {$whereTip}			
                UNION
                SELECT
                    oc.IDoc,
                    proveedores.razonsocial,
                    proveedores.rut,
                    proveedores.nombre,
                    proveedores.direccion,
                    proveedores.telefono,
                    proveedores.ciudad,
                    proveedores.giro,
                    oc.fecha,
                    oc.numfactura,
                    ocitems.cantidad,
                    'ESPECIAL',
                    'ESPECIAL',
                    'ESPECIAL',
                    ocitems.descripcion,
                    ocitems.IDproducto,
                    'ESPECIAL',
                    ocitems.precio,
                    oc.total,
                    'ESPECIAL',
                    estado
                FROM
                    oc
                    Inner Join ocitems ON oc.IDoc = ocitems.IDoc
                    Inner Join proveedores ON oc.rutp = proveedores.rut
                WHERE 
                    ocitems.IDproducto = 'ESPECIAL'
                    and oc.rutp LIKE '%" . addslashes($buscar) . "%'
                    and fecha BETWEEN '{$desde}' AND LAST_DAY('{$hasta}')				
                    {$whereTip}
                ORDER BY {$orden};");
        }
		else
            {
                $this->NX_DB->QUERY("
                    SELECT
                        oc.IDoc,
                        proveedores.razonsocial,
                        proveedores.rut,
                        proveedores.nombre,
                        proveedores.direccion,
                        proveedores.telefono,
                        proveedores.ciudad,
                        proveedores.giro,
                        oc.fecha,
                        oc.numfactura,
                        ocitems.cantidad,
                        categorias.nombrecategoria,
                        marcasmaquina.nombremarca,
                        inventario.modelo,
                        inventario.descripcion,
                        ocitems.IDproducto,
                        inventario.codinterno,
                        ocitems.precio,
                        oc.total,
                        inventario.numparte,
                        estado
                    FROM
                        oc
                        Inner Join ocitems ON oc.IDoc = ocitems.IDoc
                        Inner Join inventario ON ocitems.IDproducto = inventario.ID
                        Inner Join categorias ON inventario.categoria = categorias.IDcategoria
                        Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
                        Inner Join proveedores ON oc.rutp = proveedores.rut
                    WHERE
                        oc.IDoc = '{$numoc}'			
                    UNION
                    SELECT
                        oc.IDoc,
                        proveedores.razonsocial,
                        proveedores.rut,
                        proveedores.nombre,
                        proveedores.direccion,
                        proveedores.telefono,
                        proveedores.ciudad,
                        proveedores.giro,
                        oc.fecha,
                        oc.numfactura,
                        ocitems.cantidad,
                        'ESPECIAL',
                        'ESPECIAL',
                        'ESPECIAL',
                        ocitems.descripcion,
                        ocitems.IDproducto,
                        'ESPECIAL',
                        ocitems.precio,
                        oc.total,
                        'ESPECIAL',
                        estado
                    FROM
                        oc
                        Inner Join ocitems ON oc.IDoc = ocitems.IDoc
                        Inner Join proveedores ON oc.rutp = proveedores.rut
                    WHERE 
                        ocitems.IDproducto = 'ESPECIAL'
                        and oc.IDoc = '{$numoc}';");
        }
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : guardarFormaPagoOC">
	public function guardarFormaPagoOC($numerooc, $tipopago, $numcheque30, $montocheque30, $numcheque60, $montocheque60, $numcheque90, $montocheque90, $numcheque120, $montocheque120, $numtransferencia, $montotransferencia, $fechacredito, $fechacheque30, $fechacheque60, $fechacheque90, $fechacheque120, $fechatransferencia) 
	{
		list( $dia, $mes, $anio) = explode( '-', $fechacredito );
		$fechacredito2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    ocpagos(
				            IDoc, 
				            tipopago,
				            numcheque30,
				            numcheque60,
				            numcheque90,
				            numcheque120,
				            montocheque30,
				            montocheque60,
				            montocheque90,
				            montocheque120,
				            numtransferencia,
				            montotransferencia,
				            fechacredito,
				            fechacheque30,
				            fechacheque60,
				            fechacheque90,
				            fechacheque120,
				            fechatransferencia)
				VALUES(
				       {$numerooc}, 
				       {$tipopago}, 
				       '{$numcheque30}', 
				       '{$numcheque60}', 
				       '{$numcheque90}', 
				       '{$numcheque120}', 
				       '{$montocheque30}', 
				       '{$montocheque60}', 
				       '{$montocheque90}', 
				       '{$montocheque120}', 
				       '{$numtransferencia}', 
				       '{$montotransferencia}', 
				       '{$fechacredito2}', 
				       '{$fechacheque30}', 
				       '{$fechacheque60}', 
				       '{$fechacheque90}', 
				       '{$fechacheque120}', 
				       '{$fechatransferencia}');");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

	public function actualizarFormaPagoOC($numerooc, $tipopago, $numcheque30, $montocheque30, $numcheque60, $montocheque60, $numcheque90, $montocheque90, $numcheque120, $montocheque120, $numtransferencia,
            $fechacredito,
			$fecha30dias,
			$fecha60dias,
			$fecha90dias,
			$fecha120dias,
			$montotransferencia,
			$fechatransferencia) 
	{


		switch ($tipopago) {
    		case "1":  //CREDITO
				list( $dia, $mes, $anio) 	= split( '-', $fechacredito );
				$fechacreditoFormato 		= "$anio/$mes/$dia"; 
  
				$fecha30diasFormato			= "";
				$fecha60diasFormato			= "";
				$fecha90diasFormato			= "";
				$fecha120diasFormato		= "";
				$fechatransferenciaFormato	= "";		
        		break;
    		case "2":   //CHEQUE
				list( $dia, $mes, $anio) 	= split( '-', $fecha30dias );
				$fecha30diasFormato 		= "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) 	= split( '-', $fecha60dias );
				$fecha60diasFormato 		= "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) 	= split( '-', $fecha90dias );
				$fecha90diasFormato 		= "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) 	= split( '-', $fecha120dias );
				$fecha120diasFormato 		= "$anio/$mes/$dia"; 

				$fechacreditoFormato 		= ""; 
				$fechatransferenciaFormato	= "";	
        		break;
    		case "3":   //TRANSFERENCIA
				list( $dia, $mes, $anio) 	= split( '-', $fechatransferencia);
				$fechatransferenciaFormato 	= "$anio/$mes/$dia"; 

				$fechacreditoFormato 		= ""; 
  				$fecha30diasFormato			= "";
				$fecha60diasFormato			= "";
				$fecha90diasFormato			= "";
				$fecha120diasFormato		= "";
				break;
		}

		$sql = 	"
				UPDATE ocpagos
				SET 
					tipopago 			= $tipopago,
					numcheque30 		= '$numcheque30',
					numcheque60 		='$numcheque60',
					numcheque90 		='$numcheque90',
					numcheque120 		='$numcheque120',
					montocheque30 		='$montocheque30',
					montocheque60 		='$montocheque60',
					montocheque90 		='$montocheque90',
					montocheque120 		='$montocheque120',
					numtransferencia 	='$numtransferencia',
					fechacredito 		='$fechacreditoFormato',
					fechacheque30		='$fecha30diasFormato',
					fechacheque60		= '$fecha60diasFormato',
					fechacheque90		='$fecha90diasFormato',
					fechacheque120		='$fecha120diasFormato',
					montotransferencia	='$montotransferencia',
					fechatransferencia  ='$fechatransferenciaFormato'
				WHERE 
				    IDoc = $numerooc 
				";			
        //echo $sql;
		return $this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatospagoOC">
	public function obtenerdatospagoOC($idoc)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM ocpagos
				WHERE ocpagos.IDoc = {$idoc};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

}