<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Maquinas {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>
	
	public function nuevo($serieinterna, $seriemaquina, $tipomaquina, $marca, $modelo, $fechacompra, $formato, $conectividad, $existe, $idfactura, $cargofijo)
	{
		list( $dia, $mes, $anio) = explode( '-', $fechacompra );
		$fecha2 = "$anio/$mes/$dia"; 
		$sql = 	"
				INSERT INTO maquinas(serieinterna, seriemaquina, tipomaquina, marca, modelo, fechacompra, formato, conectividad, existe, idfactura, cargofijo)
				VALUES('$serieinterna', '$seriemaquina', $tipomaquina, $marca, '$modelo', '$fecha2', '$formato', '$conectividad', $existe, $idfactura, $cargofijo)
				";
		return $this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : existe">
	public function existe($serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM maquinas
				WHERE serieinterna = '$serieinterna'
				and existe = 1
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
	public function eliminar($serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE maquinas
				SET existe = 0
				WHERE serieinterna = '$serieinterna'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

	public function modificar($serieinterna, $seriemaquina, $modelo, $formato, $conectividad, $cargofijo)
	{
		$sql = 	"
				UPDATE maquinas
				SET modelo = '$modelo', formato = '$formato', conectividad = '$conectividad', cargofijo = $cargofijo, seriemaquina = '$seriemaquina'
				WHERE serieinterna = '$serieinterna'
				";
		return $this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	/********* PARA EL LISTAR y SELECCIONAR TODOS (controles, ot, etc.) **********/
	public function cantidad($buscar, $whereMar, $whereTip, $whereExis)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM maquinas
				WHERE serieinterna LIKE '%" . addslashes($buscar) . "%'	and existe = 1 $whereMar $whereTip $whereExis
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $whereMar, $whereTip, $whereExis)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM maquinas, tiposmaquina, marcasmaquina
				WHERE serieinterna LIKE '%" . addslashes($buscar) . "%' 
				and maquinas.tipomaquina = tiposmaquina.id
				and maquinas.marca = marcasmaquina.id
				and maquinas.existe = 1 
				$whereMar $whereTip $whereExis
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	/******************* MAQUINAS DEL CLIENTE INSTALADAS! (CLICK EN EL MENU DE CLIENTES) ************/
	public function cantidadPorCliente($buscar, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS 'cantidad'
				FROM clientemaquina, maquinas
				WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = '$rut'
				AND clientemaquina.estado = 1
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LISTAR MAQUINAS POR CLIENTE">
	public function listarPorCliente($rut, $inicial, $resultados, $buscar, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT maquinas.*, tiposmaquina.tipo, marcasmaquina.nombremarca, clientemaquina.correlativo, clientemaquina.ubicacion
				FROM clientemaquina, maquinas, tiposmaquina, marcasmaquina
				WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna 
				AND tiposmaquina.id = maquinas.tipomaquina
				AND marcasmaquina.id = maquinas.marca
				AND clientemaquina.rutcliente = '$rut'
				AND clientemaquina.estado = 1
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	/**************************************************/
	
	/******************* MAQUINAS DEL CLIENTE RETIRADAS!! (CLICK EN EL MENU DE CLIENTES) ************/
    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadRetiradasPorCliente">
	public function cantidadRetiradasPorCliente($buscar, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM clientemaquina, maquinas
				WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = '$rut'
				AND clientemaquina.estado = 0
				AND clientemaquina.facturada = 0
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarRetiradasPorCliente">
	public function listarRetiradasPorCliente($rut, $inicial, $resultados, $buscar, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT maquinas.*, tiposmaquina.tipo, marcasmaquina.nombremarca, clientemaquina.correlativo, clientemaquina.ubicacion
				FROM clientemaquina, maquinas, tiposmaquina, marcasmaquina
				WHERE clientemaquina.serieintmaquina LIKE '%".addslashes($buscar)."%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna 
				AND tiposmaquina.id = maquinas.tipomaquina
				AND marcasmaquina.id = maquinas.marca
				AND clientemaquina.rutcliente = '{$rut}'
				AND clientemaquina.estado = 0 
				AND clientemaquina.facturada = 0
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados}
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadClientes">
	/******************* CLIENTES QUE HA TENIDO LA MAQUINA (MENU MAQUINAS, historial) ************/	
	public function cantidadClientes($buscar, $serieinterna)//buscar: rut o razon social
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*)
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'
				");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarClientes">
	public function listarClientes($inicial, $resultados, $buscar, $orden, $serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'	
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : OBTIENE DATOS DE LAS MAQUINAS">
	public function obtenerDatosMaquinaCliente($buscar, $serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT max(correlativo) as correlativo ,max(ubicacion) as ubicacion 
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.estado= 1 AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LAS MAQUINAS DEL CLIENTE">
	public function obtenerDatos($serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM maquinas, tiposmaquina, marcasmaquina
				WHERE serieinterna = '$serieinterna' AND
				maquinas.tipomaquina = tiposmaquina.ID AND
				maquinas.marca = marcasmaquina.ID
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function seleccionarfallas()
	{
	    $sql = 	"
				SELECT * 
				FROM fallas
				order by IDfalla desc
				";
		return $this->controladorBD->fetchAll($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : setEstadoHistorial">
	public function setEstadoHistorial($serieInterna)
	{

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE clientemaquina
				   SET estado = 0
				 WHERE serieintmaquina = '$serieInterna'
				   AND estado = 1
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : setEstadoFacturada">
	public function setEstadoFacturada($rut, $serieInterna, $estado)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE clientemaquina
				   SET facturada = {$estado}
				 WHERE serieintmaquina = '{$serieInterna}'
				  AND rutcliente = '{$rut}';");
        }catch (Exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>
	
	public function actualizarStock($id, $cant, $oper, $col)
	{
		$sql = 	"
				UPDATE maquinas
				SET $col = ($col $oper $cant)
				WHERE serieinterna = '$id'
				";			
		$this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionAnualPorCliente">
	public function listarFacturacionAnualPorCliente($rut, $inicial, $resultados, $buscar, $anio)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				contadores.rutcliente,
				count(contadores.serieintmaquina) as Cantidad,
				monthname(contadores.fechafacturacion) as Mes,
				month(contadores.fechafacturacion) as MesNumero
				FROM
				contadores
				where 
				contadores.rutcliente = '$rut'
				and year(contadores.fechafacturacion) = '$anio'
				and contadores.idfactura is null
				GROUP BY
				month(contadores.fechafacturacion)
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorCliente">
	public function listarFacturacionTotalPorCliente($rut, $inicial, $resultados, $idmaquina, $anio, $mes, $buscar)
	{
		//Esta consulta incluye toda la información que se copiara en la nueva facturacion				
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut' 
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null										
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
					where copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
					group by copiascliente.serieintmaquina					
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadFacturacionTotalPorCliente">
	public function cantidadFacturacionTotalPorCliente($rut,$idmaquina, $anio, $mes, $buscar)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut' 
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null					
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where
					copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
				group by copiascliente.serieintmaquina									
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorClienteMinimoCopiadoGlobal">
	public function listarFacturacionTotalPorClienteMinimoCopiadoGlobal($rut, $inicial, $resultados, $idmaquina, $anio, $mes, $buscar, $tiposervicio)
	{
		//Esta consulta incluye toda la información que se copiara en la nueva facturacion				
        if($buscar == null){
            $buscar = "";
        }
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '{$rut}'
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%{$anio}%'
					{$mes}
					and contadores.serieintmaquina LIKE '%{$idmaquina}%'
					and contadores.idfactura is null	
					{$tiposervicio}									
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
					where copiascliente.rutcliente = '{$rut}' 
					and copiascliente.serieintmaquina LIKE '%{$buscar}%'
					and copiascliente.costofijo > 0
					group by copiascliente.serieintmaquina					
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				LIMIT {$inicial}, {$resultados}
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal">
	public function cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal($rut,$idmaquina, $anio, $mes, $buscar, $tiposervicio)
	{
        if($buscar == null){
            $buscar = "";
        }
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '{$rut}' 
					and contadores.serieintmaquina LIKE '%{$buscar}%'
					and year(contadores.fechafacturacion) LIKE  '%{$anio}%'
					{$mes}
					and contadores.serieintmaquina LIKE '%{$idmaquina}%'
					and contadores.idfactura is null
					{$tiposervicio}				
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where
					copiascliente.rutcliente = '{$rut}' 
					and copiascliente.serieintmaquina LIKE '%{$buscar}%'
					and copiascliente.costofijo > 0
				group by copiascliente.serieintmaquina									
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorCliente">
	public function obtenerDatosFacturacionMensualPorCliente($rut, $anio, $mes)
	{
        //Esta query captura informacion aunque los contadores no tengan datos en la tabla CONTADORES
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT
				copiascliente.rutcliente,
				contadores.copiasfacturadas,
				copiascliente.serieintmaquina,
				contadores.fechafacturacion,
				Month(contadores.fechafacturacion) AS Mes,
				copiascliente.costocopia,
				copiascliente.minimocopia,
				copiascliente.costofijo,
				copiascliente.idTipoServicioMaquina,
				tiposerviciomaquina.nombreTipoServicio,
				maquinas.modelo,
				marcasmaquina.nombremarca
				FROM
				copiascliente
				Left Outer Join contadores ON copiascliente.rutcliente = contadores.rutcliente AND copiascliente.serieintmaquina = contadores.serieintmaquina AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina
				Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
				Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
				Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where copiascliente.rutcliente = '$rut'
				and (year(contadores.fechafacturacion) = '$anio'
						or year(contadores.fechafacturacion) is null)
				and (month(contadores.fechafacturacion) = '$mes'
					or month(contadores.fechafacturacion) is null)
				and contadores.idfactura is null
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteCargoFijo">
	public function obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes)
	{
		//Esta query toma todos los cargos fijos para poder calcular todos los tipos de servicio
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				copiascliente.rutcliente,
				copiascliente.serieintmaquina,
				contadores.fechafacturacion,
				maquinas.modelo,
				marcasmaquina.nombremarca,
				copiascliente.costofijo AS CargoFijo,
				copiascliente.idTipoServicioMaquina,
				tiposerviciomaquina.nombreTipoServicio
				FROM
				copiascliente
				Left Outer Join contadores ON copiascliente.rutcliente = contadores.rutcliente AND copiascliente.serieintmaquina = contadores.serieintmaquina AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina
				Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
				Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
				Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where copiascliente.rutcliente = '$rut'
				and (year(contadores.fechafacturacion) = '$anio'
						or year(contadores.fechafacturacion) is null)
				and (month(contadores.fechafacturacion) = '$mes'
					or month(contadores.fechafacturacion) is null)
				and contadores.idfactura is null
				order by copiascliente.serieintmaquina,copiascliente.idTipoServicioMaquina
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarUbicacionClienteMaquina">
	public function actualizarUbicacionClienteMaquina($rut, $serieIntMaquina, $ubicacionNueva)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE clientemaquina
				SET ubicacion = '{$ubicacionNueva}'
				WHERE clientemaquina.serieintmaquina = '{$serieIntMaquina}'
					AND clientemaquina.estado= 1 
					AND clientemaquina.rutcliente = '{$rut}'");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;

		$this->controladorBD->query($sql);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasCotizacion">
	public function listarMaquinasCotizacion($inicial, $resultados, $buscarModelo, $buscarPeriodo)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idMaquinaCotizacion,
                cotizacionmaquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo,
                cotizacionmaquinasperiodosvalores.bnMinimo,
                cotizacionmaquinasperiodosvalores.colorMinimo,
                cotizacionmaquinasperiodosvalores.bnCosto,
                cotizacionmaquinasperiodosvalores.colorCosto,
                cotizacionmaquinasperiodosvalores.cargoFijo,
                cotizacionmaquinasperiodos.idPeriodo,
                cotizacionmaquinasperiodos.descripcionPeriodo
            FROM
                cotizacionmaquinas
            Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
            Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
            Inner Join cotizacionmaquinasperiodosvalores ON cotizacionmaquinas.idMaquinaCotizacion = cotizacionmaquinasperiodosvalores.idMaquinaCotizacion
            Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
            where 
            cotizacionmaquinas.modelo LIKE '%$buscarModelo%' and 
            cotizacionmaquinasperiodos.descripcionPeriodo LIKE '%$buscarPeriodo%'
			LIMIT $inicial, $resultados;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasCotizacion">
	public function cantidadMaquinasCotizacion($buscarModelo, $buscarPeriodo)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
            cotizacionmaquinas.idMaquinaCotizacion,
            cotizacionmaquinas.modelo,
            marcasmaquina.nombremarca,
            tiposmaquina.tipo,
            cotizacionmaquinasperiodosvalores.bnMinimo,
            cotizacionmaquinasperiodosvalores.colorMinimo,
            cotizacionmaquinasperiodosvalores.bnCosto,
            cotizacionmaquinasperiodosvalores.colorCosto,
            cotizacionmaquinasperiodosvalores.cargoFijo,
            cotizacionmaquinasperiodos.idPeriodo,
            cotizacionmaquinasperiodos.descripcionPeriodo
            FROM
            cotizacionmaquinas
            Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
            Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
            Inner Join cotizacionmaquinasperiodosvalores ON cotizacionmaquinas.idMaquinaCotizacion = cotizacionmaquinasperiodosvalores.idMaquinaCotizacion
            Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
            where 
            cotizacionmaquinas.modelo LIKE '%{$buscarModelo}%' and 
            cotizacionmaquinasperiodos.descripcionPeriodo LIKE '%{$buscarPeriodo}%';");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimoNumeroSerieInterna">
	public function ultimoNumeroSerieInterna($tipo)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				select max(right(serieinterna,4)) AS NUMERO
				from maquinas
				where serieinterna like '%" . addslashes($tipo) . "%';");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

}