<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
//</editor-fold>

class Inventario 
{

	//<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
	private $NX_CONFIG;
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
		$this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
			$this->NX_CONFIG["DB_HOST"],
			$this->NX_CONFIG["DB_PORT"],
			$this->NX_CONFIG["DB_USER"],
			$this->NX_CONFIG["DB_PASS"],
			$this->NX_CONFIG["DB_NAME"],
			$this->NX_CONFIG["DB_CHARSET"]
		);
	}
	//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerCorrelativo">
	public function obtenerCorrelativo($inicial)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2) AS NUMERO
				FROM inventario
				WHERE ID LIKE '%-$inicial%'
				ORDER BY CAST(SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2) AS unsigned) DESC
				LIMIT 1
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, $nombremaquina, $cantidadacomprar, $rendimiento = "")
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    inventario(
				               ID, 
				               tipo, 
				               categoria, 
				               marca, modelo, codinterno, numparte, descripcion, contteorico, contreal, stockcritico, stockminimo, precioventa, existe, maquinas, cantidadacomprar,rendimiento)
				VALUES('$idproducto', '$tipo', $categoria, $marca, '$modelo', '$codinterno', '$numparte', '$descripcion', $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, '$nombremaquina', '$cantidadacomprar', '$rendimiento')
				");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : modificarProducto">
	public function modificarProducto($idproducto, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $nombremaquina, $cantidadacomprar, $rendimiento)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				UPDATE inventario
				SET numparte = '$numparte', contteorico = $contteorico, contreal = $contreal, stockcritico = $stockcritico, stockminimo = $stockminimo, codinterno = '$codinterno', precioventa = $pventa, maquinas = '$nombremaquina', descripcion = '$descripcion', cantidadacomprar = '$cantidadacomprar', rendimiento = '$rendimiento'
				WHERE ID = '$idproducto'
				");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarProducto">
	public function eliminarProducto($idproducto)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				UPDATE inventario
				SET activo = 0
				WHERE ID = '$idproducto'
				");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : asociarMaquinaInventario">
	public function asociarMaquinaInventario($m, $idproducto)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				INSERT INTO maquinasinventario(serieintmaquina, IDproducto)
				VALUES('$m','$idproducto')
				");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($buscar, $whereCat, $whereTip, $whereCant, $modelo, $numparte)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT COUNT(inventario.ID) AS cantidad
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID
				AND inventario.activo = 1 AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' and
				inventario.modelo LIKE '%" . addslashes($modelo) . "%' AND
				inventario.numparte LIKE '%" . addslashes($numparte) . "%'
				$whereCant $whereCat $whereTip ");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY()["cantidad"];
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant, $modelo, $numparte)
	{
		if(!isset($wheremodelo)){
			$wheremodelo = "";
		}
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID AND
				inventario.activo = 1 AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.modelo LIKE '%" . addslashes($modelo) . "%' AND
				inventario.numparte LIKE '%" . addslashes($numparte) . "%'				
				$whereCant $whereCat $whereTip  $wheremodelo
				ORDER BY $orden 
				LIMIT $inicial, $resultados");
		while($_ROW = $this->NX_DB->FETCH_ARRAY()){
			$RESPONSE[] = $_ROW;
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarConIdControl">
	public function listarConIdControl($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant, $whereControl)
	{

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT 
				       inventario.*, 
				       nombrecategoria, 
				       nombremarca 
				FROM 
				     inventario, 
				     categorias, 
				     marcasmaquina
				WHERE 
				      inventario.categoria = categorias.IDcategoria 
                      AND inventario.marca = marcasmaquina.ID AND
                      inventario.activo = 1 AND
                      inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
                      {$whereCant} {$whereCat} {$whereTip}  {$whereControl}
                      ORDER BY {$orden} 
                      LIMIT {$inicial}, {$resultados};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadConIdControl">
    public function cantidadConIdControl($buscar, $whereCat, $whereTip, $whereCant, $whereControl)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT 
				       COUNT(inventario.ID) AS NUMERO
				FROM 
				     inventario, 
				     categorias, 
				     marcasmaquina
				WHERE 
				      inventario.categoria = categorias.IDcategoria 
				      AND inventario.marca = marcasmaquina.ID AND
				      inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				{$whereCant} {$whereCat} {$whereTip} {$whereControl};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
	public function listarTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant , $modelo, $numparte)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
		if($buscar == ""){
            $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID 
				AND inventario.activo = 1 
				AND inventario.numparte LIKE '%" . addslashes($numparte) . "%'
				{$whereCant} {$whereCat} {$whereTip};");
		}else{
            $this->NX_DB->QUERY("
				SELECT DISTINCT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina,
					(SELECT IDproducto
					FROM maquinasinventario 
					WHERE serieintmaquina LIKE '%" . addslashes($buscar) . "%'
					)inventarioMaq
				WHERE inventario.categoria = categorias.IDcategoria
				AND inventario.marca = marcasmaquina.ID
				AND inventarioMaq.IDproducto = inventario.ID 
				and inventario.activo = 1
				AND inventario.numparte LIKE '%" . addslashes($numparte) . "%' 
				{$whereCant} {$whereCat} {$whereTip};");
		}
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaqProd">
	public function cantidadMaqProd($buscarm, $buscarp, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM maquinas, inventario, maquinasinventario, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '$buscarm' AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' {$whereTip}
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaqProd">
	public function listarMaqProd($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM maquinas, inventario, maquinasinventario, categorias, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '{$buscarm}' AND				
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' {$whereTip};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaqProd2">
	public function cantidadMaqProd2($buscarm, $buscarp, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM inventario, marcasmaquina
				WHERE inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' {$whereTip}");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaqProd2">
	public function listarMaqProd2($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, marcasmaquina, categorias
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' {$whereTip}");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : detalleproducto">
	public function detalleproducto($id)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.ID = '$id' AND
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID
				");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerMaquinasdelProducto">
	public function obtenerMaquinasdelProducto($id)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT *
				FROM maquinasinventario, maquinas, marcasmaquina, tiposmaquina
				WHERE maquinasinventario.IDproducto = '$id' AND
				maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinas.marca = marcasmaquina.ID AND
				maquinas.tipomaquina = tiposmaquina.ID
				");
		while($_ROW = $this->NX_DB->FETCH_ARRAY()){
			$RESPONSE[] = $_ROW;
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : borrarMaquinasdelProducto">
	public function borrarMaquinasdelProducto($id, $serie)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				DELETE FROM maquinasinventario
				WHERE serieintmaquina = '$serie' AND
				IDproducto = '$id'
				");
		$this->NX_DB->DESCONECTAR();
        return true;
	}
	//</editor-fold>
	
	public function obtenerProveedoresdelProducto($id)
	{
		$sql = 	"
				SELECT *
				FROM proveedorinventario, proveedores
				WHERE proveedorinventario.IDproducto = '$id' AND
				proveedorinventario.rutp = proveedores.rut
				";			
		return $this->controladorBD->fetchAll($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : borrarMaquinasdelProducto">
	public function actualizarStock($id, $cant, $oper, $col)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE inventario
				SET $col = ($col $oper $cant)
				WHERE ID = '$id'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarPcompra">
	public function actualizarPcompra($id, $precio)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE 
				    inventario
				SET 
				    preciocompra = '{$precio}'
				WHERE 
				      ID = '{$id}';");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarPcompra">
	public function actualizarPcompraProveedorItems($id, $precio, $rutp)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE 
				    proveedoritems 
				SET 
				    precio = '{$precio}'
				WHERE 
				      IDitem = '{$id}' AND 
				      rutp = '{$rutp}';");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadcritica">
	public function cantidadcritica($buscar, $whereCat, $whereTip)
	{

        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.activo = 1 AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip}");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockcritico">
	public function stockcritico($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.marca = marcasmaquina.ID AND
				inventario.activo = 1 AND
				inventario.categoria = categorias.IDcategoria $whereCat $whereTip
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadminima">
	public function cantidadminima($buscar, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal <= inventario.stockminimo AND		
				inventario.activo = 1 AND	
				inventario.stockminimo > 0 AND				
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip}");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockminimo">
	public function stockminimo($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal <= inventario.stockminimo AND				
				inventario.marca = marcasmaquina.ID AND
				inventario.activo = 1 AND
				inventario.stockminimo > 0 AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip}
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarCambioRepuesto">
	public function listarCambioRepuesto($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
			SELECT Count(reports.serieinterna) AS Cantidad, 
			inventario.codinterno AS RepuestoCodigoInterno, 
			inventario.ID AS RepuestoCodigo, categorias.nombrecategoria AS RepuestoCategoria,
			inventario.descripcion, 
			marcasmaquina.nombremarca AS MaquinaMarca, 
			tiposmaquina.tipo AS MaquinaTipo, 
			maquinas.modelo as MaquinaModelo, 
			maquinas.serieinterna AS MaquinaSerieInterna, 
			reports.fecha as Fecha, 
			inventario.tipo as TipoInventario 
			FROM reports INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
 			INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			where 
			inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
			and maquinas.serieinterna LIKE '%" . addslashes($buscarMaquina) . "%'
			{$fechas}
			group by
			inventario.codinterno,
			inventario.ID,
			categorias.nombrecategoria,
			inventario.descripcion, 
			marcasmaquina.nombremarca,
			tiposmaquina.tipo, 
			maquinas.modelo, 
			maquinas.serieinterna, 
			reports.fecha, 
			inventario.tipo 
			order by {$orden}
			LIMIT {$inicial}, {$resultados};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadCambioRepuesto">
    public function cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS TOTAL
				FROM T_RepuestosUsadosPorMaquina				
				WHERE
				RepuestoCodigoInterno LIKE '%" . addslashes($buscar) . "%' 
				and MaquinaSerieinterna LIKE '%" . addslashes($buscarMaquina) . "%'
				{$fechas}
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarCambioRepuestoTOEXCEL">
	public function listarCambioRepuestoTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant, $buscarMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				Count(reports.serieinterna) AS Cantidad,
				inventario.codinterno AS RepuestoCodigoInterno,
				inventario.ID AS RepuestoCodigo,
				categorias.nombrecategoria AS RepuestoCategoria,
				inventario.descripcion,
				marcasmaquina.nombremarca AS MaquinaMarca,
				tiposmaquina.tipo AS MaquinaTipo,
				maquinas.modelo as MaquinaModelo,
				maquinas.serieinterna AS MaquinaSerieInterna,
				inventario.tipo as TipoInventario
				FROM
				reports
				INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport
				INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto
				INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria
				INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
				where inventario.tipo = 'Repuesto' and
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				and maquinas.serieinterna LIKE '%" . addslashes($buscarMaquina) . "%'
				group by
				reports.serieinterna,
				marcasmaquina.nombremarca,
				inventario.ID,
				categorias.nombrecategoria,
				tiposmaquina.tipo
				order by {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarStockPorVentaInsumo">
	public function actualizarStockPorVentaInsumo($id, $cant)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE inventario
				SET contteorico = contteorico - $cant
				WHERE ID = '$id'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

	public function listarInventarioStockMinimo()
	{
		$sql = 	"	
				SELECT
					inventario.ID,
					inventario.codinterno,
					categorias.nombrecategoria,
					inventario.modelo,
					marcasmaquina.nombremarca,
					inventario.descripcion,
					inventario.contreal,
					inventario.stockminimo,
					inventario.cantidadacomprar,
					inventario.tipo
				FROM
					inventario
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
					Inner Join categorias ON inventario.categoria = categorias.IDcategoria
				where 
					inventario.activo = 1
					and inventario.stockminimo > 0
					and inventario.stockminimo >= inventario.contreal
				order by inventario.tipo,inventario.codinterno			
			";
		return $this->controladorBD->fetchAll($sql);
	}

}