<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Facturas {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerUltimaFactura">
	public function obtenerUltimaFactura()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT max(idFactura)+1 as UltimaFactura
				FROM
				facturas
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["UltimaFactura"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $fechas, $nfactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM v_listado_facturas_v2
				WHERE 
				razonsocial LIKE '%" . addslashes($buscar) . "%'
				$fechas		
				$nfactura				
				");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $fechas, $nfactura)
	{
        if($buscar == null){
            $buscar = "";
        }
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM v_listado_facturas_v2
				WHERE 
				razonsocial LIKE '%" . addslashes($buscar) . "%'
				{$fechas}		
				{$nfactura}				
				order by idFactura
				LIMIT {$inicial}, {$resultados}				
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
	public function listarTOEXCEL($buscar, $fechas, $ordenStr, $nfactura)
	{
        if($buscar == null){
            $buscar = "";
        }
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM v_listado_facturas_v3
				WHERE 
				razonsocial LIKE '%" . addslashes($buscar) . "%'
				{$fechas}		
				{$nfactura}			
				order by idFactura
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCELDETALLE">
	public function listarTOEXCELDETALLE($buscar, $fechas, $ordenStr, $nfactura)
	{
        if($buscar == null){
            $buscar = "";
        }
        if($nfactura == null){
            $nfactura = "";
        }
        if($fechas == null){
            $fechas = "";
        }
        if($ordenStr == null){
            $ordenStr = "";
        }
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					facturaitems.IDfacturaitem,
					facturaitems.IDfactura,
					facturaitems.descripcion,
					facturaitems.cantidad,
					facturaitems.precio,
					facturaitems.IDinventario,
					facturaitems.IDdepartamentoCliente,
					facturaitems.IDcentroCosto,
					facturas.fechaFactura,
					facturas.fechaVencimiento,
					facturas.rutCliente,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre,
					centrocosto.nombreCentroCosto,
					clientedepartamentos.nombreDepartamentoCliente,
					inventario.codinterno
				FROM
					facturaitems
					Inner Join facturas ON facturaitems.IDfactura = facturas.idFactura
					Inner Join clientes ON facturas.rutCliente = clientes.rut
					Left Outer Join centrocosto ON facturaitems.IDcentroCosto = centrocosto.idCentroCosto
					Left Outer Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
					Left Outer Join inventario ON facturaitems.IDinventario = inventario.ID
				WHERE 
				razonsocial LIKE '%" . addslashes($buscar) . "%'					
				{$fechas}		
				{$nfactura}			
			");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFactura">
	public function obtenerDatosFactura($idFactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				facturas.*,
				clientes.*
				FROM
				facturas
				left outer JOIN clientes ON clientes.rut = facturas.rutCliente
				where idFactura = {$idFactura}
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleFacturaVenta">
	public function obtenerDatosDetalleFacturaVenta($idFactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				select * from facturaitems
				where IDFactura = $idFactura
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleFacturaCentroCopiado">
	public function obtenerDatosDetalleFacturaCentroCopiado($idFactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				select * from ot
				where idfactura = {$idFactura}
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function obtenerDatosDetalleFacturaArriendo($idFactura)
	{
		$sql = 	"
				select * from contadores
				where idfactura = $idFactura
				";
		return $this->controladorBD->fetchAll($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleFacturaArriendoItem">
	public function obtenerDatosDetalleFacturaArriendoItem($idFactura)
	{
		//Consulta mejorada para tener datos de centro de costo y nombre departamento
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT
				facturaitems.IDfacturaitem,
				facturaitems.IDfactura,
				facturaitems.descripcion,
				concat(facturaitems.descripcion,' - ',facturaitems.IDinventario,' - ',clientedepartamentos.nombreDepartamentoCliente, ' - CC',centrocosto.idCentroCosto) as descripcionDetalle,
				facturaitems.cantidad,
				facturaitems.precio,
				facturaitems.IDinventario,
				facturaitems.IDdepartamentoCliente,
				facturaitems.IDcentroCosto,
				centrocosto.nombreCentroCosto,
				clientedepartamentos.nombreDepartamentoCliente,
				clientedepartamentos.estado
				FROM
				facturaitems
				Inner Join centrocosto ON facturaitems.IDcentroCosto = centrocosto.idCentroCosto
				Inner Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where facturaitems.IDfactura = (
					select distinct idfactura from contadores
					where idfactura = {$idFactura})					
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoVentaGeneral">
	public function nuevoVentaGeneral($idFactura, $fechaFactura, $rutCliente, $fechavencimiento, $formaPago, $referencias, $porcdescuento)
	{		
		$dia = substr($fechaFactura, 0, 2);    // returns "f"
		$mes = substr($fechaFactura, 3, 2);    // returns "ef"
		$anio = substr($fechaFactura, 6, 4); // returns "d"

		$diaV = substr($fechavencimiento, 0, 2);    // returns "f"
		$mesV = substr($fechavencimiento, 3, 2);    // returns "ef"
		$anioV = substr($fechavencimiento, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia"; 
		$fechaV = "$anioV/$mesV/$diaV";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO 
				    facturas(
				        idFactura, 
				        fechaFactura, 
				        rutCliente, 
				        fechavencimiento, 
				        formaPago, 
				        referencia, 
				        descuento)
				VALUES(
				       '$idFactura', 
				       '$fecha2', 
				       '$rutCliente', 
				       '$fechaV', 
				       '$formaPago',
				       '$referencias', 
				       '$porcdescuento' 
				       ); 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoArriendo">
	public function nuevoArriendo($idFactura, $fechaFactura, $rutCliente, $fechavencimiento, $formaPago, $referencias, $otro, $porcdescuento)
	{		
		$dia = substr($fechaFactura, 0, 2);    // returns "f"
		$mes = substr($fechaFactura, 3, 2);    // returns "ef"
		$anio = substr($fechaFactura, 6, 4); // returns "d"

		$diaV = substr($fechavencimiento, 0, 2);    // returns "f"
		$mesV = substr($fechavencimiento, 3, 2);    // returns "ef"
		$anioV = substr($fechavencimiento, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia"; 
		$fechaV = "$anioV/$mesV/$diaV";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO facturas(idFactura, fechaFactura, rutCliente, fechavencimiento, formaPago, referencia, otro, descuento)
				VALUES('$idFactura', '$fecha2', '$rutCliente', '$fechaV', '$formaPago','$referencias', '$otro', $porcdescuento ) 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemVentaGeneral">
	public function nuevoItemVentaGeneral ($idFactura, $descripcion, $cantidad, $precio, $centrocosto)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO 
				    facturaitems(
				        IDfactura, 
				        descripcion, 
				        cantidad, 
				        precio, 
				        IDcentroCosto)
				VALUES(
				       '$idFactura', 
				       '$descripcion', 
				       '$cantidad', 
				       '$precio', 
				       '$centrocosto');				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemVentaInventario">
	public function nuevoItemVentaInventario ($idFactura, $descripcion, $cantidad, $precio, $idInventario, $CentroCosto)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO 
				    facturaitems(
				        IDfactura, 
				        descripcion, 
				        cantidad, 
				        precio, 
				        IDinventario, 
				        IDcentroCosto)
				VALUES(
				       '$idFactura', 
				       '$descripcion', 
				       '$cantidad', 
				       '$precio', 
				       '$idInventario', 
				       '$CentroCosto') 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemArriendo">
	public function nuevoItemArriendo ($idFactura, $descripcion, $cantidad, $precio, $idInventario, $idDepartamentoCliente, $idCentroCosto)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO facturaitems(IDfactura, descripcion, cantidad, precio, IDinventario, IDdepartamentoCliente, IDcentroCosto)
				VALUES('$idFactura', '$descripcion', '$cantidad', '$precio', '$idInventario', '$idDepartamentoCliente', '$idCentroCosto') 				
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturaTOEXCEL">
	public function obtenerDatosFacturaTOEXCEL($idFactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				facturas.*,
				clientes.*
				FROM
				facturas
				left outer JOIN clientes ON clientes.rut = facturas.rutCliente
				where idFactura = $idFactura
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturaDetalleItemTOEXCEL">
	public function obtenerDatosFacturaDetalleItemTOEXCEL($idFactura)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				facturaitems.cantidad,
				concat(descripcion,' ',ifnull(IDinventario,''), ' ',if(facturaitems.IDdepartamentocliente=0,'',concat('- ',clientedepartamentos.nombreDepartamentoCliente)),' ',IF(idcentrocosto=0,'',concat('- CC',idcentrocosto))) AS descripcion,
				facturaitems.precio AS precioUnitario,
				precio*cantidad AS precioTotal
				FROM
				facturaitems
				Left Outer Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where idFactura = $idFactura
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    public function nuevoFacturaLectura($numero, $rut, $valor, $cliente)
    {
        $sql = "
				INSERT INTO facturalectura(numero, rut, valor, cliente)
				VALUES('$numero', '$rut', '$valor', '$cliente') 				
				";
        return $this->controladorBD->query($sql);
    }
}