<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Cotizacion {

	//<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
	private $NX_CONFIG;
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
		$this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
			$this->NX_CONFIG["DB_HOST"],
			$this->NX_CONFIG["DB_PORT"],
			$this->NX_CONFIG["DB_USER"],
			$this->NX_CONFIG["DB_PASS"],
			$this->NX_CONFIG["DB_NAME"],
			$this->NX_CONFIG["DB_CHARSET"]
		);
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = 0;
		$this->NX_DB->QUERY("
				SELECT MAX(LAST_INSERT_ID(cotizacion.IDcotizacion)) AS NUMERO
				FROM cotizacion;");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numerocotizacion, $fechaCotizacion, $tipoCotizacion, $validez, $nombreContacto, $empresa, $direccion, $ciudad, $correo, $telefono, $idVendedor)
	{
		list( $dia, $mes, $anio) = explode( '-', $fechaCotizacion );
		$fecha2 = "$anio/$mes/$dia";
		$this->NX_DB->CONECTAR();
		try {
			$this->NX_DB->QUERY("
				INSERT INTO cotizacion(
					idCotizacion,
					fechaCotizacion, 
					estado,
					tipoCotizacion,
					validez, 
					nombreContacto, 
					empresa, 
					direccion, 
					ciudad, 
					correo, 
					telefono,
					idVendedor
				)
				VALUES(
					{$numerocotizacion},
					'{$fecha2}',
					1,
					{$tipoCotizacion},
					'{$validez}', 
					'{$nombreContacto}', 
					'{$empresa}', 
					'{$direccion}', 
					'{$ciudad}', 
					'{$correo}', 
					'{$telefono}',
					'{$idVendedor}'
					);");
		}catch (mysqli_sql_exception $e){
			error_log("NX_ERROR : {$e}", 0);
			$this->NX_DB->DESCONECTAR();
			return false;
		}
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritems">
	public function ingresaritems($idCotizacion, $idPeriodo, $idMaquinaCotizacion)
	{
		$this->NX_DB->CONECTAR();
		try{
			$this->NX_DB->QUERY("
				INSERT INTO 
				    cotizacionitems (
				                     idCotizacion, 
				                     idPeriodo, 
				                     idMaquinaCotizacion)
				VALUES(
				       {$idCotizacion}, 
				       {$idPeriodo}, 
				       {$idMaquinaCotizacion});");
		}catch (mysqli_sql_exception $e){
			error_log("NX_ERROR : {$e}", 0);
			$this->NX_DB->DESCONECTAR();
			return false;
		}
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $whereTip, $desde, $hasta)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
			SELECT
				cotizacion.idCotizacion,
				cotizacion.fechaCotizacion,
				cotizacion.estado,
				cotizacion.tipocotizacion,
				cotizacion.validez,
				cotizacion.nombreContacto,
				cotizacion.empresa,
				cotizacion.direccion,
				cotizacion.ciudad,
				cotizacion.correo,
				cotizacion.telefono,
				cotizacion.idVendedor,
				cotizaciontipo.descripcion AS descripcionCotizacion,
				cotizacionestado.descripcion as descripcionEstado
			FROM
				cotizacion
				Inner Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
				Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
			WHERE 
				cotizacion.idCotizacion LIKE '%" . addslashes($buscar) . "%' AND			
				cotizacion.fechaCotizacion BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') 
				{$whereTip}
			ORDER BY {$orden}			
			LIMIT {$inicial}, {$resultados};");
		while($_ROW = $this->NX_DB->FETCH_ARRAY()){
			$RESPONSE[] = $_ROW;
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $whereTip, $desde, $hasta)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = 0;
		$this->NX_DB->QUERY("
			SELECT
				cotizacion.idCotizacion,
				cotizacion.fechaCotizacion,
				cotizacion.estado,
				cotizacion.tipocotizacion,
				cotizacion.validez,
				cotizacion.nombreContacto,
				cotizacion.empresa,
				cotizacion.direccion,
				cotizacion.ciudad,
				cotizacion.correo,
				cotizacion.telefono,
				cotizacion.idVendedor,
				cotizaciontipo.descripcion AS descripcionCotizacion,
				cotizacionestado.descripcion as descripcionEstado
			FROM
				cotizacion
				Inner Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
				Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
			WHERE 
				cotizacion.idCotizacion LIKE '%\" . addslashes($buscar) . \"%' AND			
				cotizacion.fechaCotizacion BETWEEN '{$desde}' AND LAST_DAY('{$hasta}') 
				{$whereTip}");
		$RESPONSE = $this->NX_DB->NUM_ROWS();
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	public function obtenerdatosMaquinaPeriodoCosto($idperiodo, $idmaquinacotizacion)
	{
		$sql = 	"
SELECT
cotizacionmaquinasperiodosvalores.bnMinimo,
cotizacionmaquinasperiodosvalores.colorMinimo,
cotizacionmaquinasperiodosvalores.bnCosto,
cotizacionmaquinasperiodosvalores.colorCosto,
cotizacionmaquinasperiodosvalores.cargoFijo,
cotizacionmaquinasperiodosvalores.idPeriodo,
cotizacionmaquinasperiodosvalores.idMaquinaCotizacion,
cotizacionmaquinasperiodos.descripcionPeriodo,
cotizacionmaquinas.modelo,
cotizacionmaquinas.marca,
cotizacionmaquinas.formato,
tiposmaquina.tipo,
marcasmaquina.nombremarca,
cotizacionmaquinas.tipomaquina 
FROM
cotizacionmaquinasperiodosvalores
Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
Inner Join cotizacionmaquinas ON cotizacionmaquinasperiodosvalores.idMaquinaCotizacion = cotizacionmaquinas.idmaquinacotizacion
Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
where 
cotizacionmaquinasperiodosvalores.idPeriodo = $idperiodo and
cotizacionmaquinasperiodosvalores.idMaquinaCotizacion = $idmaquinacotizacion
				";
		//echo $sql;
		return $this->controladorBD->fetch($sql);
	}

	public function obtenerdatosMaquinaPeriodoCostoCondiciones($idperiodo, $idmaquinacotizacion)
	{
		$sql = 	"
SELECT
cotizacionmaquinascondiciones.idCotizacionMaquinaCondiciones,
cotizacionmaquinascondiciones.Condiciones
from
cotizacionmaquinascondiciones
WHERE
cotizacionmaquinascondiciones.idCotizacionMaquinaCondiciones =  '1'
";
		//echo $sql;
		return $this->controladorBD->fetch($sql);
	}

	//<editor-fold defaultstate="collapsed" desc="FUNCION : anios">
	public function anios()
	{//
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT DISTINCT YEAR(fecha) anio
				FROM oc
				ORDER BY anio 
				");
		while($_ROW = $this->NX_DB->FETCH_ARRAY()){
			$RESPONSE[] = $_ROW;
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : aniosDesc">
	public function aniosDesc()
	{//
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT DISTINCT YEAR(fechaCotizacion) anio
				FROM cotizacion
				ORDER BY anio desc
				");
		while($_ROW = $this->NX_DB->FETCH_ARRAY()){
			$RESPONSE[] = $_ROW;
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosCotizacion">
	public function obtenerdatosCotizacion($idcotizacion)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT *
				FROM cotizacion
				WHERE cotizacion.idCotizacion = $idcotizacion
				");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	public function obtenerItemsCotizacion($idcotizacion)
	{
		$sql = 	"
			SELECT
				cotizacion.idCotizacion,
				cotizacionitems.idCotizacionItem,
				cotizacionmaquinasperiodos.descripcionPeriodo,
				cotizacionmaquinas.modelo,
				cotizacionmaquinas.formato,
				cotizacionmaquinas.conectividad,
				cotizacionmaquinas.activo,
				marcasmaquina.nombremarca,
				tiposmaquina.tipo,
				cotizacionmaquinasperiodosvalores.bnMinimo,
				cotizacionmaquinasperiodosvalores.colorMinimo,
				cotizacionmaquinasperiodosvalores.bnCosto,
				cotizacionmaquinasperiodosvalores.colorCosto,
				cotizacionmaquinasperiodosvalores.cargoFijo
			FROM
				cotizacion
				Inner Join cotizacionitems ON cotizacion.idCotizacion = cotizacionitems.idCotizacion
				Inner Join cotizacionmaquinasperiodos ON cotizacionitems.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
				Inner Join cotizacionmaquinas ON cotizacionitems.idMaquinaCotizacion = cotizacionmaquinas.idmaquinacotizacion
				Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
				Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
				Inner Join cotizacionmaquinasperiodosvalores ON cotizacionitems.idPeriodo = cotizacionmaquinasperiodosvalores.idPeriodo AND cotizacionmaquinas.idmaquinacotizacion = cotizacionmaquinasperiodosvalores.idMaquinaCotizacion
			WHERE cotizacion.idCotizacion = $idcotizacion 
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function obtenerItemsMaqServOC($idoc)
	{
		$sql = 	"
				SELECT ocitems.*
				FROM ocitems
				WHERE ocitems.IDoc = $idoc AND
				ocitems.IDproducto = 'ESPECIAL'
				";
		return $this->controladorBD->fetchAll($sql);
	}	
	
	//Solo productos Insumos o respuestos (tipo = 1)
	public function obtenerProductosOC($idoc)
	{
		$sql = 	"			
				SELECT ocitems.*
				FROM ocitems
				WHERE ocitems.IDoc = $idoc AND
				tipo = 1
				";
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function actualizarCotizacion($idCotizacion, $valor, $col)
	{
		$sql = 	"
				UPDATE cotizacion
				SET $col = $valor
				WHERE idCotizacion = $idCotizacion
				";
		return $this->controladorBD->query($sql);
	}
	
	public function borrarinventarioOC($idoc, $idprod)
	{
		$sql = 	"
				DELETE FROM ocinventario
				WHERE IDproducto = '$idprod' AND
				IDoc = $idoc				
				";
		$this->controladorBD->query($sql);
	}
	
	public function listarOcDetalleExcel($buscar, $orden, $whereTip, $desde, $hasta)
	{
		$sql = 	"
			SELECT
				oc.IDoc,
				proveedores.razonsocial,
				proveedores.rut,
				proveedores.nombre,
				proveedores.direccion,
				proveedores.telefono,
				proveedores.ciudad,
				proveedores.giro,
				oc.fecha,
				oc.numfactura,
				ocitems.cantidad,
				categorias.nombrecategoria,
				marcasmaquina.nombremarca,
				inventario.modelo,
				inventario.descripcion,
				ocitems.IDproducto,
				inventario.codinterno,
				ocitems.precio,
				oc.total,
				inventario.numparte
			FROM
				oc
				Inner Join ocitems ON oc.IDoc = ocitems.IDoc
				Inner Join inventario ON ocitems.IDproducto = inventario.ID
				Inner Join categorias ON inventario.categoria = categorias.IDcategoria
				Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				Inner Join proveedores ON oc.rutp = proveedores.rut
			WHERE
				oc.rutp LIKE '%" . addslashes($buscar) . "%'
				and fecha BETWEEN '$desde' AND LAST_DAY('$hasta')  
				$whereTip			
			UNION
			SELECT
				oc.IDoc,
				proveedores.razonsocial,
				proveedores.rut,
				proveedores.nombre,
				proveedores.direccion,
				proveedores.telefono,
				proveedores.ciudad,
				proveedores.giro,
				oc.fecha,
				oc.numfactura,
				ocitems.cantidad,
				'ESPECIAL',
				'ESPECIAL',
				'ESPECIAL',
				ocitems.descripcion,
				ocitems.IDproducto,
				'ESPECIAL',
				ocitems.precio,
				oc.total,
				'ESPECIAL'
			FROM
				oc
				Inner Join ocitems ON oc.IDoc = ocitems.IDoc
				Inner Join proveedores ON oc.rutp = proveedores.rut
			WHERE 
				ocitems.IDproducto = 'ESPECIAL'
				and oc.rutp LIKE '%" . addslashes($buscar) . "%'
				and fecha BETWEEN '$desde' AND LAST_DAY('$hasta')				
				$whereTip
			ORDER BY $orden
		"; 
		return $this->controladorBD->fetchAll($sql);
	}

}
?>
