<?php

class NX_MYSQL
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $_CONN;
    private $_QUERY;
    private $_HOST;
    private $_PORT;
    private $_USER;
    private $_PASS;
    private $_DB;
    private $_CHAR;
    private $_ERROR_LOG=[];
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($_HOST, $_PORT, $_USER, $_PASS, $_DB, $_CHARSET = "utf8") {
        $this->_HOST = $_HOST;
        $this->_PORT = $_PORT;
        $this->_USER = $_USER;
        $this->_PASS = $_PASS;
        $this->_DB = $_DB;
        $this->_CHAR = $_CHARSET;
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : CONECTAR">
    public function CONECTAR(){
        try {
            $this->_CONN = new mysqli($this->_HOST,
                $this->_USER,
                $this->_PASS,
                $this->_DB);
            if($this->_CONN->connect_error){
                $this->_ERROR_LOG[] = array("code" => 2,"msg" => "ERROR_MYSQL_CONNECT",
                    "error_info" => strval($this->_CONN->connect_error));
            }
            $this->_CONN->set_charset($this->_CHAR);
            return true;
        }catch (Exception $_t){
            $this->_ERROR_LOG[] = array("code" => 1,"msg" => "ERROR_MYSQL_NOT_HANDLED", "error_info" => strval($_t));
            return false;
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : CHECK_CONNECTION">
    private function CHECK_CONNECTION(){
        if($this->_CONN == false){
            throw new Exception('MYSQL_FAIL_CONNECT');
        } else {
            return true;
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : DESCONECTAR">
    public function DESCONECTAR(){
        if($this->_CONN){
            $this->_CONN->close();
            return true;
        }else{
            return false;
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : QUERY">
    public function QUERY($_SQL){
        $this->CHECK_CONNECTION();
        if($this->_CONN){
            $this->_QUERY = $this->_CONN->query($_SQL);
            return true;
        }else{
            $this->_ERROR_LOG[] = array("code" => 3,"msg" => "ERROR_MYSQL_QUERY_ERROR", "error_info" => "CONNECT_NOT_OPEN");
            error_log("[NX_MYSQL] : QUERY | CONNECT_NOT_OPEN", 0);
            return false;
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : NUM_ROWS">
    public function NUM_ROWS(){
        if($this->_QUERY == false) {
            return 0;
        }else{
            return $this->_QUERY->num_rows;
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : FETCH_ARRAY">
    public function FETCH_ARRAY(){
        return $this->_QUERY->fetch_array(MYSQLI_ASSOC);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : AFFECTED_ROWS">
    public function AFFECTED_ROWS(){
        return $this->_CONN->affected_rows;
    }
    //</editor-fold>

	public function fetch($sql) 
	{
		$this->query($sql);
		return mysql_fetch_assoc($this->stmt);
	}
	
	public function fetchOne($sql) 
	{
		$this->query($sql);
		if ($data = mysql_fetch_row($this->stmt)) 
		{
			return array_shift($data);
		}
		return false;
	}
	
	public function fetchAll($sql) 
	{
		$data = null;
		$this->query($sql);
		while ($row = mysql_fetch_assoc($this->stmt))
		{
			$data[] = $row;
		}
		mysql_free_result($this->stmt);
		//mysql_close();
		return $data;
	}
	
	public function fetchId($sql)
	{
		if($this->query($sql))
		{
			return mysql_insert_id();
		}else{
			return false;
		}
	}
	
	
	public function countAll($sql) 
	{
		$data = null;
		$cantidad = 0;
		$this->query($sql);
		while ($row = mysql_fetch_assoc($this->stmt))
		{
			$cantidad ++;
			$data[] = $row;
		}
		mysql_free_result($this->stmt);
		//mysql_close();
		return $cantidad;
		return $data;
	}
	
	public function fetchNumRows($sql)
	{		
		$this->stmt = mysql_query($sql, $this->res);
		return mysql_num_rows($this->stmt);		
	}		
}