<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class ControlSalida {

	//<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
	private $NX_CONFIG;
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
		$this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
			$this->NX_CONFIG["DB_HOST"],
			$this->NX_CONFIG["DB_PORT"],
			$this->NX_CONFIG["DB_USER"],
			$this->NX_CONFIG["DB_PASS"],
			$this->NX_CONFIG["DB_NAME"],
			$this->NX_CONFIG["DB_CHARSET"]
		);
	}
	//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT MAX(LAST_INSERT_ID(controlsalida.IDcontrol)) AS NUMERO
				FROM controlsalida;");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["NUMERO"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numerocontrol, $rut, $nombrecliente, $rutcliente, $recinto, $fecha, $hora, $idCentroCosto)
	{
		list( $dia, $mes, $anio) = explode( '-', $fecha );
		$fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    controlsalida (
				                   IDcontrol, 
				                   rut, 
				                   nombrecliente, 
				                   rutcliente, 
				                   recinto, 
				                   fecha, 
				                   hora, 
				                   idCentroCosto)
				VALUES(
				       {$numerocontrol}, 
				       '{$rut}', 
				       '{$nombrecliente}', 
				       '{$rutcliente}', 
				       '{$recinto}', 
				       '{$fecha2}', 
				       '{$hora}', 
				       '{$idCentroCosto}');");
        }catch (Exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarinventario">
	public function ingresarinventario($idcontrol, $id, $cantidad)
	{
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    controlinventario 
				    (IDcontrol, 
				     IDproducto, 
				     cantidad)
				VALUES(
				       {$idcontrol}, 
				       '{$id}', 
				       '{$cantidad}');");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LISTAR CONTROL CLIENTE">
	public function listar_control_cliente($inicial, $resultados, $buscar, $rut, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM controlsalida
				WHERE rut = '$rut' AND
				CAST( controlsalida.IDcontrol AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : CANTIDAD DE CONTROLES">
	public function cantidad_control_cliente($buscar, $rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) as 'cantidad'
				FROM controlsalida
				WHERE rut = '$rut' AND				
				CAST( controlsalida.IDcontrol AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosControl">
	public function obtenerdatosControl($idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE controlsalida.IDcontrol = {$idcontrol} AND
				clientes.rut = controlsalida.rut AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto;");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerInventarioControl">
	public function obtenerInventarioControl($idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT controlinventario.*, inventario.*, nombrecategoria, nombremarca
				FROM controlinventario, inventario, categorias, marcasmaquina
				WHERE controlinventario.IDcontrol = {$idcontrol} AND
				inventario.marca = marcasmaquina.ID AND
				controlinventario.IDproducto = inventario.ID AND
				inventario.categoria = categorias.IDcategoria;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerMaquinasControl">
	public function obtenerMaquinasControl($idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT controlinventario.*, maquinas.*, nombremarca, tipo
				FROM controlinventario, maquinas, marcasmaquina, tiposmaquina
				WHERE controlinventario.IDcontrol = {$idcontrol} AND
				maquinas.serieinterna = controlinventario.IDproducto AND
				maquinas.marca = marcasmaquina.ID AND
				maquinas.tipomaquina = tiposmaquina.ID;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $fecha , $idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM controlsalida, clientes
				WHERE controlsalida.rut = clientes.rut AND
				controlsalida.idcontrol LIKE '%" . addslashes($idcontrol) . "%' AND
				razonsocial LIKE '%" . addslashes($buscar) . "%'
				{$fecha};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $fecha , $idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT controlsalida.*, clientes.razonsocial, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE clientes.razonsocial LIKE '%" . addslashes($buscar) . "%' AND
				controlsalida.rut = clientes.rut AND
				controlsalida.idcontrol LIKE '%" . addslashes($idcontrol) . "%' AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto
				{$fecha}
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarPorID">
	public function listarPorID($inicial, $resultados, $buscar, $orden, $idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT controlsalida.*, clientes.razonsocial, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE clientes.razonsocial LIKE '%" . addslashes($buscar) . "%' AND
				controlsalida.rut = clientes.rut AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto
				and controlsalida.idcontrol like '%" . addslashes($idcontrol) . "%'
				ORDER BY {$orden}
				LIMIT {$inicial}, {$resultados}");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadPorID">
	public function cantidadPorID($buscar, $idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM controlsalida, clientes
				WHERE controlsalida.rut = clientes.rut AND
				razonsocial LIKE '%" . addslashes($buscar) . "%'  
				and controlsalida.idcontrol like '%" . addslashes($idcontrol) . "%';");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
	public function listarTOEXCEL($buscar, $orden, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT controlsalida.*, clientes.razonsocial, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE clientes.razonsocial LIKE '%" . addslashes($buscar) . "%' AND
				controlsalida.rut = clientes.rut  AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto
				{$fechas}
				ORDER BY {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCELDETALLE">
	public function listarTOEXCELDETALLE($buscar, $orden, $fechas, $idcontrol)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					controlsalida.IDcontrol,
					controlsalida.rut,
					controlsalida.nombrecliente,
					controlsalida.rutcliente,
					controlsalida.recinto,
					controlsalida.fecha,
					controlsalida.hora,
					controlsalida.idCentroCosto,
					clientes.razonsocial,
					centrocosto.nombreCentroCosto,
					controlinventario.IDproducto,
					controlinventario.cantidad,
					inventario.codinterno,
					inventario.descripcion,
					inventario.maquinas,
					inventario.modelo				
				FROM
					controlsalida
					Inner Join clientes ON controlsalida.rut = clientes.rut
					Inner Join centrocosto ON controlsalida.idCentroCosto = centrocosto.idCentroCosto
					Inner Join controlinventario ON controlsalida.IDcontrol = controlinventario.IDcontrol
					Inner Join inventario ON controlinventario.IDproducto = inventario.ID
				WHERE clientes.razonsocial LIKE '%" . addslashes($buscar) . "%'
				{$fechas}
								and controlsalida.idcontrol LIKE '%" . addslashes($idcontrol) . "%'
				ORDER BY {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarResponsables">
	public function listarResponsables()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					usuarios.rut,
					usuarios.dv,
					usuarios.nombre,
					usuarios.apellidos,
					UPPER(concat_ws(' ', usuarios.nombre, usuarios.apellidos)) as nombrecompleto,
					concat_ws('-', usuarios.rut, usuarios.dv) as rutcompleto,
					usuarios.estado,
					usuarios.area
				from usuarios
				where usuarios.rut <> 1
				order by 
					usuarios.area DESC,
					usuarios.nombre ASC;");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>
		
}