<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Clientes {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>
	
	public function nuevo($rut, $dv, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro)
	{

		$sql = 	"
				INSERT INTO clientes(rut, dv, razonsocial, nombre, telefono, direccion, ciudad, giro)
				VALUES('$rut', '$dv', '$razonSocial', '$nombre', '$telefono', '$direccion', '$ciudad', '$giro')
				";
		return $this->controladorBD->query($sql);
	}
	
	public function eliminar($rut)
	{
		$sql = 	"
				DELETE FROM clientes
				WHERE rut = '$rut'
				";
		$this->controladorBD->query($sql);
	}
	
	public function existe($rut)
	{
		$sql = 	"
				SELECT count(*)
				FROM clientes
				WHERE rut = '$rut'
				";
		return $this->controladorBD->fetchOne($sql);		
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LISTA LOS CLIENTES">
	public function listar($rutcsj, $inicial, $resultados, $buscar, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM clientes
				WHERE rut = '{$rutcsj}' 
				UNION
				(SELECT * 
				FROM clientes
				WHERE razonsocial LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados)
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarCentroCopiado">
	public function listarCentroCopiado($rutcsj, $inicial, $resultados, $buscar, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT DISTINCT
					ot.rutcliente,
					clientes.rut,
					clientes.dv,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre,
					clientes.telefono,
					clientes.direccion,
					clientes.ciudad,
				clientes.giro
				FROM
					ot
					Inner Join clientes ON ot.rutcliente = clientes.rut
				WHERE cast(ot.rutcliente as CHAR) LIKE '%" . addslashes($buscar) . "%'
				or razonsocial LIKE '%" . addslashes($buscar) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadCentroCopiado">
	public function cantidadCentroCopiado($buscar)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT DISTINCT
					ot.rutcliente,
					clientes.rut,
					clientes.dv,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre,
					clientes.telefono,
					clientes.direccion,
					clientes.ciudad,
				    clientes.giro
				FROM
					ot
					Inner Join clientes ON ot.rutcliente = clientes.rut
				WHERE cast(ot.rutcliente as CHAR) LIKE '%" . addslashes($buscar) . "%'
				");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : CANTIDAD DE CLIENTES">
	public function cantidad($buscar)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS 'cantidad'
				FROM clientes
				WHERE razonsocial LIKE '%" . addslashes($buscar) . "%'		
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : OBTIENE DATOS DE CLIENTES">
	public function obtenerDatos($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM clientes
				WHERE rut =	'$rut'	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function modificar($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro)
	{

		$sql = 	"
				UPDATE clientes
				SET razonsocial = '$razonSocial', nombre = '$nombre', telefono = '$telefono',
				    direccion = '$direccion', ciudad = '$ciudad', giro = '$giro'
				WHERE rut = '$rut'
				";
		$this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : agregarMaquina">
	public function agregarMaquina($rut, $serieInterna, $correlativo, $ubicacion)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO clientemaquina(rutcliente, serieintmaquina, correlativo, estado, fecha, ubicacion)
				VALUES('$rut', '$serieInterna', $correlativo, 1, now(), '$ubicacion');
				");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nextCorrelativoClienteMaquina">
	public function nextCorrelativoClienteMaquina($rut, $serieInterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT IFNULL(MAX(correlativo)+1, 1) AS correlativo
				  FROM clientemaquina
				 WHERE rutcliente = '$rut'
				   AND serieintmaquina = '$serieInterna'
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarDepartamentos">
	public function listarDepartamentos($rutcsj, $inicial, $resultados, $buscar, $orden)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM clientedepartamentos
				WHERE rutCliente = '$rutcsj' 
				and estado = 1
				and nombreDepartamentoCliente LIKE '%" . addslashes($buscar) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function listarDepartamentosAll($rut)
	{	
		$sql = 	"
				SELECT * 
				FROM clientedepartamentos
				WHERE rutCliente = '$rut' 
				and estado = 1
				";				
		return $this->controladorBD->fetchAll($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarDepartamentos">
	public function cantidadListarDepartamentos($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM clientedepartamentos
				WHERE rutCliente = '$rut'		
				and estado = 1
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function nuevoDepartamento($rut, $nombreDepartamento)
	{

		$sql = 	"
				INSERT INTO clientedepartamentos(nombreDepartamentoCliente, rutCliente)
				VALUES(UPPER('$nombreDepartamento'), '$rut')
				";
		return $this->controladorBD->query($sql);
	}	

	public function listarDepartamentoByID($iddepartamento)
	{	
		$sql = 	"
				SELECT * 
				FROM clientedepartamentos
				WHERE idDepartamentoCliente = '$iddepartamento'	
                AND estado = 1				
				";
		return $this->controladorBD->fetch($sql);
	}
	
	public function modificarDepartamento($idDepartamento, $nombreDepartamento)
	{

		$sql = 	"
				UPDATE clientedepartamentos
				SET nombreDepartamentoCliente = UPPER('$nombreDepartamento')
				WHERE idDepartamentoCliente = '$idDepartamento'
				";
		$this->controladorBD->query($sql);
	}	

	public function eliminarDepartamento($idDepartamento)
	{

		$sql = 	"
				UPDATE clientedepartamentos
				SET estado = 0
				WHERE idDepartamentoCliente = '$idDepartamento'
				";
		$this->controladorBD->query($sql);
	}		
	
}