<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Boletas {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerUltimaBoleta">
	public function obtenerUltimaBoleta()
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT max(idBoleta)+1 as UltimaBoleta
				FROM
				boletas
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["UltimaBoleta"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function cantidad($buscar, $fechas)
	{
		$sql = 	"		
				SELECT count(*)
				FROM boletas
				Inner Join clientes ON boletas.rutCliente = clientes.rut
				WHERE 
				clientes.razonsocial LIKE '%" . addslashes($buscar) . "%'
				$fechas	
				";
		return $this->controladorBD->fetchOne($sql);	
	}
		
	public function listar($inicial, $resultados, $buscar, $fechas)
	{
		$sql = 	"
				SELECT
				boletas.idBoleta,
				boletas.fechaBoleta,
				boletas.rutCliente,
				(select sum(cantidad * precio) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) as NETO,
				(select sum(round((cantidad * precio)*0.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS IVA ,
				(select sum(round((cantidad * precio)*1.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS TOTAL,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				WHERE 
				clientes.razonsocial LIKE '%" . addslashes($buscar) . "%'
				$fechas						
				order by idBoleta
				LIMIT $inicial, $resultados				
				";
		return $this->controladorBD->fetchAll($sql);
	}	
	
	public function listarTOEXCEL($buscar, $fechas, $ordenStr)
	{
		$sql = 	"
				SELECT
				boletas.idBoleta,
				boletas.fechaBoleta,
				boletas.rutCliente,
				(select sum(cantidad * precio) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) as NETO,
				(select sum(round((cantidad * precio)*0.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS IVA ,
				(select sum(round((cantidad * precio)*1.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS TOTAL,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				order by idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	
	
	public function obtenerDatosBoleta($idBoleta)
	{
		$sql = 	"
				SELECT
				boletas.*,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				where idBoleta = $idBoleta
				";
		return $this->controladorBD->fetch($sql);
	}	

	public function obtenerDatosDetalleBoletaVenta($idBoleta)
	{
		$sql = 	"
				select * from facturaitems
				where IDBoleta = $idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	

	public function obtenerDatosDetalleBoletaCentroCopiado($idBoleta)
	{
		$sql = 	"
				select * from ot
				where idfactura = $idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	
	
	public function obtenerDatosDetalleBoletaArriendo($idBoleta)
	{
		$sql = 	"
				select * from contadores
				where idfactura = $idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	
	
	public function obtenerDatosDetalleBoletaArriendoItem($idBoleta)
	{
		$sql = 	"
				select * from facturaitems
				where IDBoleta = (
					select distinct idfactura from contadores
					where idfactura = $idBoleta)					
				";
		//Consulta mejorada para tener datos de centro de costo y nombre departamento
		$sql = 	"		
				SELECT
				facturaitems.IDfacturaitem,
				facturaitems.IDfactura,
				facturaitems.descripcion,
				concat(facturaitems.descripcion,' - ',facturaitems.IDinventario,' - ',clientedepartamentos.nombreDepartamentoCliente, ' - CC',centrocosto.idCentroCosto) as descripcionDetalle,
				facturaitems.cantidad,
				facturaitems.precio,
				facturaitems.IDinventario,
				facturaitems.IDdepartamentoCliente,
				facturaitems.IDcentroCosto,
				centrocosto.nombreCentroCosto,
				clientedepartamentos.nombreDepartamentoCliente,
				clientedepartamentos.estado
				FROM
				facturaitems
				Inner Join centrocosto ON facturaitems.IDcentroCosto = centrocosto.idCentroCosto
				Inner Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where facturaitems.IDfactura = (
					select distinct idfactura from contadores
					where idfactura = $idBoleta)					
				"; 
				
		return $this->controladorBD->fetchAll($sql);
	}	
	
	public function nuevoVentaGeneral ($idBoleta, $fechaBoleta, $rutCliente, $idCentroCosto, $porcdescuento)
	{		
		$dia = substr($fechaBoleta, 0, 2);    // returns "f"
		$mes = substr($fechaBoleta, 3, 2);    // returns "ef"
		$anio = substr($fechaBoleta, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia"; 
		
		$sql = "
				INSERT INTO boletas(idBoleta, fechaBoleta, rutCliente, idCentroCosto, descuento)
				VALUES('$idBoleta', '$fecha2', '$rutCliente', '$idCentroCosto', '$porcdescuento') 				
				";

		return $this->controladorBD->query($sql);
	}

	public function nuevoArriendo($idBoleta, $fechaBoleta, $rutCliente, $formaPago, $referencia)
	{		
		$dia = substr($fechaBoleta, 0, 2);    // returns "f"
		$mes = substr($fechaBoleta, 3, 2);    // returns "ef"
		$anio = substr($fechaBoleta, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia"; 
		
		$sql = "
				INSERT INTO boletas(idBoleta, fechaBoleta, rutCliente, formaPago, referencia)
				VALUES('$idBoleta', '$fecha2', '$rutCliente', '$formaPago', '$referencia' ) 				
				";	
		return $this->controladorBD->query($sql);
	}
	
	public function nuevoItemVentaGeneral ($idBoleta, $descripcion, $cantidad, $precio)
	{
		$sql = 	"
				INSERT INTO boletaitems(IDboleta, descripcion, cantidad, precio)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio') 				
				";	
		return $this->controladorBD->query($sql);
	}

	public function nuevoItemVentaInventario ($idBoleta, $descripcion, $cantidad, $precio, $idInventario, $idCentroCosto)
	{
		$sql = 	"
				INSERT INTO boletaitems(IDboleta, descripcion, cantidad, precio, IDinventario, IDcentroCosto)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio', '$idInventario','$idCentroCosto') 				
				";	
		return $this->controladorBD->query($sql);
	}

	public function nuevoItemArriendo ($idBoleta, $descripcion, $cantidad, $precio, $idInventario, $idDepartamentoCliente, $idCentroCosto)
	{
		$sql = 	"
				INSERT INTO facturaitems(IDfactura, descripcion, cantidad, precio, IDinventario, IDdepartamentoCliente, IDcentroCosto)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio', '$idInventario', '$idDepartamentoCliente', '$idCentroCosto') 				
				";	
		return $this->controladorBD->query($sql);
	}

	public function obtenerDatosBoletaTOEXCEL($idBoleta)
	{
		$sql = 	"
				SELECT
				boletas.*,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				where idBoleta = $idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	

	public function obtenerDatosBoletaDetalleItemTOEXCEL($idBoleta)
	{
		$sql = 	"	
				select 
				cantidad,
				concat(descripcion,' ',ifnull(IDinventario, '')) as descripcion,
				precio as precioUnitario,
				precio*cantidad as precioTotal
				from facturaitems
				where idBoleta = $idBoleta
				";
		//24/01/2018
		//se crea esta consulta para agregar a las boletas de arriendo la leyenda
		//para el centro de costo y el nombre de departamento
		$sql = 	"
				SELECT
				facturaitems.cantidad,
				concat(descripcion,' ',ifnull(IDinventario,''), ' ',if(facturaitems.IDdepartamentocliente=0,'',concat('- ',clientedepartamentos.nombreDepartamentoCliente)),' ',IF(idcentrocosto=0,'',concat('- CC',idcentrocosto))) AS descripcion,
				facturaitems.precio AS precioUnitario,
				precio*cantidad AS precioTotal
				FROM
				facturaitems
				Left Outer Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where idBoleta = $idBoleta
				";
		return $this->controladorBD->fetchAll($sql);
	}	
}
?>