<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');


class Inventario 
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>
	
	public function obtenerCorrelativo($inicial)
	{
		$sql = 	"
				SELECT SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2)
				FROM inventario
				WHERE ID LIKE '%-$inicial%'
				ORDER BY CAST(SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2) AS unsigned) DESC
				LIMIT 1
				"; 
		return $this->controladorBD->fetchOne($sql);
	}

	public function nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, $nombremaquina)
	{
		$sql = 	"
				INSERT INTO inventario(ID, tipo, categoria, marca, modelo, codinterno, numparte, descripcion, contteorico, contreal, stockcritico, stockminimo, precioventa, existe, maquinas)
				VALUES('$idproducto', '$tipo', $categoria, $marca, '$modelo', '$codinterno', '$numparte', '$descripcion', $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, '$nombremaquina')
				";
		return $this->controladorBD->query($sql);
	}	
	            
	public function modificarProducto($idproducto, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $nombremaquina)
	{
		$sql = 	"
				UPDATE inventario
				SET numparte = '$numparte', contteorico = $contteorico, contreal = $contreal, stockcritico = $stockcritico, stockminimo = $stockminimo, codinterno = '$codinterno', precioventa = $pventa, maquinas = '$nombremaquina', descripcion = '$descripcion'
				WHERE ID = '$idproducto'
				";
		return $this->controladorBD->query($sql);
	}
	
	public function asociarMaquinaInventario($m, $idproducto)
	{
		$sql = 	"
				INSERT INTO maquinasinventario(serieintmaquina, IDproducto)
				VALUES('$m','$idproducto')
				";
		return $this->controladorBD->query($sql);
	}

    public function cantidad($buscar, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"
				SELECT COUNT(inventario.ID)
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				$whereCant $whereCat $whereTip";		
		/*if($buscar == ""){ //Sin búsqueda por serie interna
			$sql = 	"
				SELECT COUNT(inventario.ID)
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID 
				$whereCant $whereCat $whereTip";
		}else{ //busqueda por serieinterna
			$sql = 	"
				SELECT COUNT(DISTINCT inventario.ID)
				FROM inventario, categorias, marcasmaquina,
					(SELECT IDproducto
					FROM maquinasinventario 
					WHERE serieintmaquina LIKE '%" . addslashes($buscar) . "%'
					)inventarioMaq
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				inventarioMaq.IDproducto = inventario.ID 
				$whereCant $whereCat $whereTip 
				";
		}*/
		return $this->controladorBD->fetchOne($sql);	
	}
	
	public function listar($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID AND
				inventario.activo = 1 AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				$whereCant $whereCat $whereTip 
				ORDER BY $orden 
				LIMIT $inicial, $resultados";
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function listarTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		if($buscar == ""){ //Sin búsqueda por serie interna
			$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID 
				and inventario.activo = 1
				$whereCant $whereCat $whereTip";
		}else{ //busqueda por serieinterna
			$sql = 	"
				SELECT DISTINCT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina,
					(SELECT IDproducto
					FROM maquinasinventario 
					WHERE serieintmaquina LIKE '%" . addslashes($buscar) . "%'
					)inventarioMaq
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				inventarioMaq.IDproducto = inventario.ID
				AND inventario.activo = 1
				$whereCant $whereCat $whereTip 
				";
		}
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function cantidadMaqProd($buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT count(*)
				FROM maquinas, inventario, maquinasinventario, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '$buscarm' AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' $whereTip
				";	
		return $this->controladorBD->fetchOne($sql);	
	}
	
	public function listarMaqProd($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM maquinas, inventario, maquinasinventario, categorias, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '$buscarm' AND				
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' $whereTip
				";
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function cantidadMaqProd2($buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT count(*)
				FROM inventario, marcasmaquina
				WHERE inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' $whereTip
				";	
		return $this->controladorBD->fetchOne($sql);	
	}
	
	public function listarMaqProd2($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, marcasmaquina, categorias
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' $whereTip
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function detalleproducto($id)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.ID = '$id' AND
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID
				";			
		return $this->controladorBD->fetch($sql);
	}
	
	public function obtenerMaquinasdelProducto($id)
	{
		$sql = 	"
				SELECT *
				FROM maquinasinventario, maquinas, marcasmaquina, tiposmaquina
				WHERE maquinasinventario.IDproducto = '$id' AND
				maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinas.marca = marcasmaquina.ID AND
				maquinas.tipomaquina = tiposmaquina.ID
				";			
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function borrarMaquinasdelProducto($id, $serie)
	{
		$sql = 	"
				DELETE FROM maquinasinventario
				WHERE serieintmaquina = '$serie' AND
				IDproducto = '$id'
				";			
		return $this->controladorBD->query($sql);
	}
	
	public function obtenerProveedoresdelProducto($id)
	{
		$sql = 	"
				SELECT *
				FROM proveedorinventario, proveedores
				WHERE proveedorinventario.IDproducto = '$id' AND
				proveedorinventario.rutp = proveedores.rut
				";			
		return $this->controladorBD->fetchAll($sql);
	}
	
	public function actualizarStock($id, $cant, $oper, $col)
	{
		$sql = 	"
				UPDATE inventario
				SET $col = ($col $oper $cant)
				WHERE ID = '$id'
				";		
		$this->controladorBD->query($sql);
	}
	
	public function actualizarPcompra($id, $precio)
	{
		$sql = 	"
				UPDATE inventario
				SET preciocompra = $precio
				WHERE ID = '$id'
				";			
		$this->controladorBD->query($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadcritica">
	public function cantidadcritica($buscar, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockcritico">
	public function stockcritico($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.marca = marcasmaquina.ID AND
				inventario.activo = 1 AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip}
				ORDER BY {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadminima">
	public function cantidadminima($buscar, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal <= inventario.stockminimo AND
				inventario.activo = 1 AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip};");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockminimo">
	public function stockminimo($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal <= inventario.stockminimo AND
				inventario.activo = 1 AND
				inventario.stockminimo > 0 AND				
				inventario.marca = marcasmaquina.ID AND
				inventario.categoria = categorias.IDcategoria {$whereCat} {$whereTip}
				ORDER BY {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

	public function listarCambioRepuesto($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				$whereCant $whereCat $whereTip 
				ORDER BY $orden 
				LIMIT $inicial, $resultados";
		
		$sql = 	"		
				SELECT
				Count(reports.serieinterna) AS Cantidad,
				inventario.codinterno AS RepuestoCodigoInterno,
				inventario.ID AS RepuestoCodigo,
				categorias.nombrecategoria AS RepuestoCategoria,
				inventario.descripcion,
				marcasmaquina.nombremarca AS MaquinaMarca,
				tiposmaquina.tipo AS MaquinaTipo,
				maquinas.modelo as MaquinaModelo,
				maquinas.serieinterna AS MaquinaSerieInterna,
				reports.fecha as Fecha
				FROM
				reports
				INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport
				INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto
				INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria
				INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
				where 
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				group by
				reports.serieinterna,
				marcasmaquina.nombremarca,
				inventario.ID,
				categorias.nombrecategoria,
				tiposmaquina.tipo
				order by $orden
				LIMIT $inicial, $resultados
			";			
//inventario.tipo = 'Repuesto' and			
		return $this->controladorBD->fetchAll($sql);
	}

    public function cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		
		
		/*				WHERE 
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				$whereCant $whereCat $whereTip
				*/

		$sql = 	"
				SELECT COUNT(*)
				FROM T_RepuestosUsadosPorMaquina				
				WHERE
				RepuestoCodigoInterno LIKE '%" . addslashes($buscar) . "%' 
				";		
		return $this->controladorBD->fetchOne($sql);	
	}

	public function listarCambioRepuestoTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
				$sql = 	"		
				SELECT
				Count(reports.serieinterna) AS Cantidad,
				inventario.codinterno AS RepuestoCodigoInterno,
				inventario.ID AS RepuestoCodigo,
				categorias.nombrecategoria AS RepuestoCategoria,
				inventario.descripcion,
				marcasmaquina.nombremarca AS MaquinaMarca,
				tiposmaquina.tipo AS MaquinaTipo,
				maquinas.modelo as MaquinaModelo,
				maquinas.serieinterna AS MaquinaSerieInterna
				FROM
				reports
				INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport
				INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto
				INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria
				INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
				where inventario.tipo = 'Repuesto' and
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				group by
				reports.serieinterna,
				marcasmaquina.nombremarca,
				inventario.ID,
				categorias.nombrecategoria,
				tiposmaquina.tipo
				order by $orden
			";				
		return $this->controladorBD->fetchAll($sql);
	}	
}











//Obtención de datos

$inventario = new Inventario($_CONF);

$pagina 		= 1;
$resultados 	= 20;
$buscar 		= !isset($_GET['buscar']) ? "" : $_GET['buscar'];
$orden 			= !isset($_GET['orden']) ? "" : $_GET['orden'];
$categoria 		= !isset($_GET['categoria']) ? "" : $_GET['categoria'];
$tipo			= !isset($_GET['tipo']) ? "" : $_GET['tipo'];
$nombre			= !isset($_GET['nombre']) ? "" : $_GET['nombre'];

if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])){
    $pagina = $_GET['pagina'];
}
switch($orden)
{
	default:
		$ordenStr = 'modelo';
		$orden = 1;
		break;
	case 2:
		$ordenStr = 'modelo DESC';
		break;
	case 3:
		$ordenStr = 'nombremarca';
		break;
	case 4:
		$ordenStr = 'nombremarca DESC';
		break;
	case 5:
		$ordenStr = 'nombrecategoria';
		break;
	case 6:
		$ordenStr = 'nombrecategoria DESC';
		break;	
	case 7:
		$ordenStr = 'contreal';
		break;
	case 8:
		$ordenStr = 'contreal DESC';
		break;
}
		
switch($categoria)
{
	default:
		$whereCat = 'AND categoria='.$categoria;
		break;
	case 0:
		$whereCat = '';
		break;			
}
		
switch($tipo)
{
	default:
		$whereTip = '';
		break;
	case 1: //Insumos
		$whereTip = "AND tipo='Insumo'";
		break;	
	case 2: //Repuestos
		$whereTip = "AND tipo='Repuesto'";
		break;			
}


if($nombre=="stockminimo")
{
	$cantidad = $inventario->cantidadminima($buscar, $whereCat, $whereTip);
	$lista = $inventario->stockminimo($resultados * ($pagina-1), $resultados, $buscar, $ordenStr, $whereCat, $whereTip);
	$titulo = "STOCK MÍNIMO";
}

if($nombre=="stockcritico")
{
	$cantidad = $inventario->cantidadcritica($buscar, $whereCat, $whereTip);
	$lista = $inventario->stockcritico($resultados * ($pagina-1), $resultados, $buscar, $ordenStr, $whereCat, $whereTip);
	$titulo = "STOCK CRÍTICO";
}
		

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista Inventario")
							 ->setSubject("")
							 ->setDescription("Lista Inventario")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:J2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', $titulo);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Cod. Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Categoría');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, "Stock Teórico");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Stock Real');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Stock Mínimo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Stock Crítico');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Cantidad a Comprar');
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["codinterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["tipo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["nombrecategoria"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["nombremarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, iconv ("ISO-8859-1", "UTF-8", $i["modelo"]));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["contteorico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["contreal"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["stockminimo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["stockcritico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["cantidadacomprar"]);
		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Inventario');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaInventario.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
?>