<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
include '../modelos/ControladorBD.php';

class Inventario
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

	public function obtenerCorrelativo($inicial)
	{
		$sql = 	"SELECT SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2) FROM inventario WHERE ID LIKE '%-$inicial%' ORDER BY CAST(SUBSTR(inventario.ID,INSTR(inventario.ID, '-$inicial')+2) AS unsigned) DESC LIMIT 1";
		return $this->controladorBD->fetchOne($sql);
	}

	public function nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, $nombremaquina)
	{
		$sql = 	"INSERT INTO inventario(ID, tipo, categoria, marca, modelo, codinterno, numparte, descripcion, contteorico, contreal, stockcritico, stockminimo, precioventa, existe, maquinas) VALUES('$idproducto', '$tipo', $categoria, $marca, '$modelo', '$codinterno', '$numparte', '$descripcion', $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $existe, '$nombremaquina')";
		return $this->controladorBD->query($sql);
	}

	public function modificarProducto($idproducto, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $nombremaquina)
	{
		$sql = 	"UPDATE inventario SET numparte = '$numparte', contteorico = $contteorico, contreal = $contreal, stockcritico = $stockcritico, stockminimo = $stockminimo, codinterno = '$codinterno', precioventa = $pventa, maquinas = '$nombremaquina', descripcion = '$descripcion' WHERE ID = '$idproducto'";
		return $this->controladorBD->query($sql);
	}

	public function asociarMaquinaInventario($m, $idproducto)
	{
		$sql = 	"INSERT INTO maquinasinventario(serieintmaquina, IDproducto) VALUES('$m','$idproducto')";
		return $this->controladorBD->query($sql);
	}

    public function cantidad($buscar, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"SELECT COUNT(inventario.ID) FROM inventario, categorias, marcasmaquina WHERE inventario.categoria = categorias.IDcategoria AND inventario.marca = marcasmaquina.ID AND inventario.codinterno LIKE '%" . addslashes($buscar) . "%' $whereCant $whereCat $whereTip";
		return $this->controladorBD->fetchOne($sql);
	}

	public function listar($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"SELECT inventario.*, nombrecategoria, nombremarca FROM inventario, categorias, marcasmaquina WHERE inventario.categoria = categorias.IDcategoria AND inventario.marca = marcasmaquina.ID AND inventario.codinterno LIKE '%" . addslashes($buscar) . "%' $whereCant $whereCat $whereTip ORDER BY $orden LIMIT $inicial, $resultados";
		return $this->controladorBD->fetchAll($sql);
	}

	public function listarTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		if($buscar == ""){ //Sin búsqueda por serie interna
			$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID 
				$whereCant $whereCat $whereTip";
		}else{ //busqueda por serieinterna
			$sql = 	"
				SELECT DISTINCT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina,
					(SELECT IDproducto
					FROM maquinasinventario 
					WHERE serieintmaquina LIKE '%" . addslashes($buscar) . "%'
					)inventarioMaq
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				inventarioMaq.IDproducto = inventario.ID 
				$whereCant $whereCat $whereTip 
				";
		}
		return $this->controladorBD->fetchAll($sql);
	}

	public function cantidadMaqProd($buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT count(*)
				FROM maquinas, inventario, maquinasinventario, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '$buscarm' AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' $whereTip
				";
		return $this->controladorBD->fetchOne($sql);
	}

	public function listarMaqProd($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM maquinas, inventario, maquinasinventario, categorias, marcasmaquina
				WHERE maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinasinventario.IDproducto = inventario.ID AND
				maquinasinventario.serieintmaquina = '$buscarm' AND				
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' $whereTip
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function cantidadMaqProd2($buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT count(*)
				FROM inventario, marcasmaquina
				WHERE inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' $whereTip
				";
		return $this->controladorBD->fetchOne($sql);
	}

	public function listarMaqProd2($inicial, $resultados, $buscarm, $buscarp, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, marcasmaquina, categorias
				WHERE inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID AND
				marcasmaquina.nombremarca LIKE '%" . addslashes($buscarp) . "%' AND
				inventario.maquinas LIKE '%" . addslashes($buscarm) . "%' $whereTip
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function detalleproducto($id)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.ID = '$id' AND
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID
				";
		return $this->controladorBD->fetch($sql);
	}

	public function obtenerMaquinasdelProducto($id)
	{
		$sql = 	"
				SELECT *
				FROM maquinasinventario, maquinas, marcasmaquina, tiposmaquina
				WHERE maquinasinventario.IDproducto = '$id' AND
				maquinasinventario.serieintmaquina = maquinas.serieinterna AND
				maquinas.marca = marcasmaquina.ID AND
				maquinas.tipomaquina = tiposmaquina.ID
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function borrarMaquinasdelProducto($id, $serie)
	{
		$sql = 	"
				DELETE FROM maquinasinventario
				WHERE serieintmaquina = '$serie' AND
				IDproducto = '$id'
				";
		return $this->controladorBD->query($sql);
	}

	public function obtenerProveedoresdelProducto($id)
	{
		$sql = 	"
				SELECT *
				FROM proveedorinventario, proveedores
				WHERE proveedorinventario.IDproducto = '$id' AND
				proveedorinventario.rutp = proveedores.rut
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function actualizarStock($id, $cant, $oper, $col)
	{
		$sql = 	"
				UPDATE inventario
				SET $col = ($col $oper $cant)
				WHERE ID = '$id'
				";
		$this->controladorBD->query($sql);
	}

	public function actualizarPcompra($id, $precio)
	{
		$sql = 	"
				UPDATE inventario
				SET preciocompra = $precio
				WHERE ID = '$id'
				";
		$this->controladorBD->query($sql);
	}

	public function cantidadcritica($buscar, $whereCat, $whereTip)
	{

		$sql = 	"
				SELECT count(*)
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.categoria = categorias.IDcategoria $whereCat $whereTip
				";
		return $this->controladorBD->fetchOne($sql);
	}

	public function stockcritico($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockcritico AND
				inventario.marca = marcasmaquina.ID AND
				inventario.categoria = categorias.IDcategoria $whereCat $whereTip
				ORDER BY $orden
				LIMIT $inicial, $resultados
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function cantidadminima($buscar, $whereCat, $whereTip)
	{
		$sql = 	"
				SELECT count(*)
				FROM inventario, categorias
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockminimo AND
				inventario.contreal > inventario.stockcritico AND
				inventario.categoria = categorias.IDcategoria $whereCat $whereTip
				";
		return $this->controladorBD->fetchOne($sql);
	}

	public function stockminimo($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip)
	{
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca
				FROM inventario, categorias, marcasmaquina
				WHERE codinterno LIKE '%" . addslashes($buscar) . "%' AND
				inventario.contreal < inventario.stockminimo AND
				inventario.contreal > inventario.stockcritico AND
				inventario.marca = marcasmaquina.ID AND
				inventario.categoria = categorias.IDcategoria $whereCat $whereTip
				ORDER BY $orden
				LIMIT $inicial, $resultados
				";
		return $this->controladorBD->fetchAll($sql);
	}

	public function listarCambioRepuesto($inicial, $resultados, $buscar, $orden, $whereCat, $whereTip, $whereCant)
	{
		/* 04/01/2010 */
		$sql = 	"
				SELECT inventario.*, nombrecategoria, nombremarca 
				FROM inventario, categorias, marcasmaquina
				WHERE inventario.categoria = categorias.IDcategoria 
				AND inventario.marca = marcasmaquina.ID AND
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				$whereCant $whereCat $whereTip 
				ORDER BY $orden 
				LIMIT $inicial, $resultados";

		$sql = 	"		
				SELECT
				Count(reports.serieinterna) AS Cantidad,
				inventario.codinterno AS RepuestoCodigoInterno,
				inventario.ID AS RepuestoCodigo,
				categorias.nombrecategoria AS RepuestoCategoria,
				inventario.descripcion,
				marcasmaquina.nombremarca AS MaquinaMarca,
				tiposmaquina.tipo AS MaquinaTipo,
				maquinas.modelo as MaquinaModelo,
				maquinas.serieinterna AS MaquinaSerieInterna,
				reports.fecha as Fecha
				FROM
				reports
				INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport
				INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto
				INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria
				INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
				where 
				inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
				group by
				reports.serieinterna,
				marcasmaquina.nombremarca,
				inventario.ID,
				categorias.nombrecategoria,
				tiposmaquina.tipo
				order by $orden
				LIMIT $inicial, $resultados
			";
		return $this->controladorBD->fetchAll($sql);
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadCambioRepuesto">
    public function cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS TOTAL
				FROM T_RepuestosUsadosPorMaquina				
				WHERE
				RepuestoCodigoInterno LIKE '%" . addslashes($buscar) . "%' 
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarCambioRepuestoTOEXCEL">
	public function listarCambioRepuestoTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
                SELECT Count(reports.serieinterna) AS Cantidad, 
                inventario.codinterno AS RepuestoCodigoInterno, 
                inventario.ID AS RepuestoCodigo, categorias.nombrecategoria AS RepuestoCategoria,
                inventario.descripcion, 
                marcasmaquina.nombremarca AS MaquinaMarca, 
                tiposmaquina.tipo AS MaquinaTipo, 
                maquinas.modelo as MaquinaModelo, 
                maquinas.serieinterna AS MaquinaSerieInterna, 
                reports.fecha as Fecha, 
                inventario.tipo as TipoInventario 
                FROM reports INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
                INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
                where 
                inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
                and maquinas.serieinterna LIKE '%" . addslashes($buscarMaquina) . "%'
                {$fechas}
                group by
                inventario.codinterno,
                inventario.ID,
                categorias.nombrecategoria,
                inventario.descripcion, 
                marcasmaquina.nombremarca,
                tiposmaquina.tipo, 
                maquinas.modelo, 
                maquinas.serieinterna, 
                reports.fecha, 
                inventario.tipo 
                order by {$orden};");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>
}



//Obtención de datos

$inventario = new Inventario($_CONF);

$buscar 	   = $_GET['buscar'];
$buscarMaquina = $_GET['buscarMaquina'];
$orden 		   = $_GET['orden'];		
$filtrocat 	   = $_GET['categoria'];	
$filtrotipo    = $_GET['tipo'];	
$fechaDesde 	= $_GET['desde'];
$fechaHasta 	= $_GET['hasta'];
		
$fechas = "";
if($fechaDesde != "" && $fechaHasta != "")
{
	list( $dia, $mes, $anio) = explode( '-', $fechaDesde);
	$fecha1 = "$anio/$mes/$dia"; 
	list( $dia, $mes, $anio) = explode( '-', $fechaHasta);
	$fecha2  = "$anio/$mes/$dia"; 
	$fechas = "AND FECHA BETWEEN '".$fecha1."' AND '".$fecha2."'";	
}		



switch($orden)
{
	default:
	$ordenStr = 'Cantidad DESC';
	$this->orden = 1;
	break;
	case 1:
		$ordenStr = 'Cantidad DESC';
	break;
	case 2:
		$ordenStr = 'Cantidad';
	break;			
	case 3:
		$ordenStr = 'RepuestoCodigoInterno';
	break;
	case 4:
		$ordenStr = 'RepuestoCodigoInterno DESC';
	break;
	case 5:
		$ordenStr = 'RepuestoCategoria';
	break;
	case 6:
		$ordenStr = 'RepuestoCategoria DESC';
	break;
	case 7:
		$ordenStr = 'MaquinaModelo';
	break;	
	case 8:
		$ordenStr = 'MaquinaModelo DESC';
	break;
}

switch($filtrocat)
{
	default:
		$whereCat = 'AND categoria='.$filtrocat;
		break;
	case 0:
		$whereCat = '';
		break;			
}
		
switch($filtrotipo)
{
	default:
		$whereTip = '';
		break;
	case 1: //Insumos
		$whereTip = "AND tipo='Insumo'";
		break;	
	case 2: //Repuestos
		$whereTip = "AND tipo='Repuesto'";
		break;			
}



$whereCant ="";		
$cantidad = $inventario->cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant);		
$lista = $inventario->listarCambioRepuestoTOEXCEL($buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas);	




// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista Repuestos Usados")
							 ->setSubject("")
							 ->setDescription("Lista Repuestos Usados")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:L2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LISTADO REPUESTOS USADOS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Repuesto Código Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Repuesto Código');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Repuesto Categoría');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Tipo Inventario');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Cantidad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Descripción');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Máquina Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Máquina Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Máquina Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Máquina Serie Interna');
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["Fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["RepuestoCodigoInterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["RepuestoCodigo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["RepuestoCategoria"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["TipoInventario"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["Cantidad"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["descripcion"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["MaquinaMarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["MaquinaTipo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["MaquinaModelo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["MaquinaSerieInterna"]);		
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('RepuestosUsados');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaRepuestosUsados.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
?>