<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/Reportabilidad.php');

//Obtención de datos

$reportabilidad = new Reportabilidad($_CONF);

$cliente		= $_GET['cliente'] ?? "";

$lista = $reportabilidad->reporteServiciosClienteToExcel($cliente);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Reporte Uso Insumo Mensual")
							 ->setSubject("")
							 ->setDescription("Reporte Uso Insumo Mensual")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:F2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORTABILIDAD');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Servicio');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Precio');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Moneda');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Rut Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Cliente');

$objPHPExcel->getActiveSheet()->getStyle('A1:F3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:F3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:F3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

if(isset($lista) && count($lista)>0)
{
	$c=0;$f=4;$count=1;
	$moneda = "";
	foreach($lista as $i)
	{
		//echo $i["ID"];
		if ($i["tipocambio"] == "p" ):
			$moneda = "CLP";
		elseif ($i["tipocambio"] == "UF" ):
    		$moneda = "UF";
		else:
    		$moneda = "NO DEFINIDO";
		endif;	




		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["servicio"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, "p"==$i["tipocambio"]?number_format($i['precio'],0,'',''):number_format($i['precio'],1,'',''));
	    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $moneda);
	 	$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, htmlentities($i["IDCliente"], ENT_QUOTES));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, htmlentities($i["razonsocial"], ENT_QUOTES));
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Reportabilidad');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ReportabilidadServiciosCliente.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');