<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/OrdenCompra.php');

//Obtención de datos

$orden = new OrdenCompra($_CONF);

$buscar 		= !isset($_GET['buscar']) ? "" : $_GET['buscar'];
$numoc          = !isset($_GET['numoc']) ? : $_GET['numoc'];
$filtroorden 	= !isset($_GET['orden']) ? : $_GET['orden'];
$estado 		= !isset($_GET['estado']) ? : $_GET['estado'];
		
$fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
$fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
			
switch($filtroorden)
{
	default:
		$ordenStr = 'IDoc';
		$filtroorden = 1;
		break;
	case 2:
		$ordenStr = 'IDoc DESC';
		break;
	case 3:
		$ordenStr = 'total';
		break;
	case 4:
		$ordenStr = 'total DESC';
		break;
	case 5:
		$ordenStr = 'fecha';
		break;
	case 6:
		$ordenStr = 'fecha DESC';
		break;	
}

switch($estado)
{
	default:
	   $whereTip = '';
		break;
	case 0: //completa
		$whereTip = "AND estado=0";
		break;
	case 1: //Pendientes Recibo conforme
		$whereTip = "AND estado=1";
		break;	
	case 2: //Pendientes de Pago y Recibo Conforme
		$whereTip = "AND estado=2";
		break;		
	case 3: //Anuladas
		$whereTip = "AND estado=3";
		break;	
}

//$cantidads = $orden->cantidad($buscar, $whereTip, $fechaDesde, $fechaHasta);
$lista = $orden->listarOcDetalleExcel($buscar, $numoc, $ordenStr, $whereTip, $fechaDesde, $fechaHasta);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Orden de Compra - Detalle")
							 ->setSubject("")
							 ->setDescription("Orden de Compra - Detalle")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:R2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'DETALLES ORDENES DE COMPRA');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);


$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'FECHA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'N° OC');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'N° FACTURA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'PROVEEDOR');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'RUT');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'ESTADO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "NETO FACTURA");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'IVA FACTURA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'TOTAL FACTURA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'CANTIDAD');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'CATEGORIA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'MARCA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'MODELO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'DESCRIPCION');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 3, 'NUM PARTE');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, 'CODINTERNO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(16, 3, 'PRECIO UNITARIO NETO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(17, 3, 'PRECIO TOTAL NETO');

$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;
	foreach($lista as $i)
	{
		$textoEstado = "";

		switch ($i["estado"]) {
    		case 0:
		        $textoEstado = "Completa";
		        break;
    		case 1:
        		$textoEstado = "Pend. Recibo Conf.";
        		break;
    		case 2:
        		$textoEstado = "Pend Pago. Recibo Conf.";
				break;
    		case 3:
        		$textoEstado = "Anulada";		
        		break;
		}	




		//echo $i["ID"];
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDoc"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["numfactura"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["razonsocial"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["rut"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $textoEstado);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["total"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, round($i["total"]*0.19));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, round($i["total"]+($i["total"]*0.19)));
		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["cantidad"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["nombrecategoria"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["nombremarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["modelo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["descripcion"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, $i["numparte"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+15, $f, $i["codinterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+16, $f, $i["precio"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+17, $f, round($i["precio"]*$i["cantidad"]));
		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Ordenes_Compra');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="OrdenesCompraDetalle.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
?>

*/