<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/OrdenCompra.php');

//Obtención de datos

$orden = new OrdenCompra($_CONF);

$buscar 		= !isset($_GET['buscar']) ? "" : $_GET['buscar'];
$filtroorden 	= !isset($_GET['orden']) ? "" : $_GET['orden'];
$estado 		= !isset($_GET['estado']) ? "" : $_GET['estado'];
$numoc   		= !isset($_GET['numoc']) ? "" : $_GET['numoc'];

$fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
$fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
			
switch($filtroorden)
{
	default:
		$ordenStr = 'IDoc';
		$filtroorden = 1;
		break;
	case 2:
		$ordenStr = 'IDoc DESC';
		break;
	case 3:
		$ordenStr = 'total';
		break;
	case 4:
		$ordenStr = 'total DESC';
		break;
	case 5:
		$ordenStr = 'fecha';
		break;
	case 6:
		$ordenStr = 'fecha DESC';
		break;	
}


switch($estado)
{
	default:
	   $whereTip = '';
		break;
	case 0: //completa
		$whereTip = "AND estado=0";
		break;
	case 1: //Pendientes Recibo conforme
		$whereTip = "AND estado=1";
		break;	
	case 2: //Pendientes de Pago y Recibo Conforme
		$whereTip = "AND estado=2";
		break;		
	case 3: //Anuladas
		$whereTip = "AND estado=3";
		break;	
		}

//$cantidads = $orden->cantidadEXCEL($buscar, $whereTip, $fechaDesde, $fechaHasta); 
$lista = $orden->listarEXCEL($buscar, $numoc, $ordenStr, $whereTip, $fechaDesde, $fechaHasta);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Orden de Compra")
							 ->setSubject("")
							 ->setDescription("Orden de Compra")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:Z2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'ORDENES DE COMPRA');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'FECHA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'N° OC');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'N° FACTURA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'PROVEEDOR');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'RUT');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'ESTADO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "NETO");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'IVA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'TOTAL');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'TIPO DE PAGO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'FECHA CREDITO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'CHEQUE 30D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'MONTO 30D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'FECHA 30D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 3, 'CHEQUE 60D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, 'MONTO 60D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(16, 3, 'FECHA 60D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(17, 3, 'CHEQUE 90D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(18, 3, 'MONTO 90D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(19, 3, 'FECHA 900D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(20, 3, 'CHEQUE 120D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(21, 3, 'MONTO 120D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(22, 3, 'FECHA 120D');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(23, 3, 'NUM TRANSFERENCIA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(24, 3, 'MONTO TRANSFERENCIA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(25, 3, 'FECHA TRANSFERENCIA');




$objPHPExcel->getActiveSheet()->getStyle('A1:Z3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:Z3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:Z3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);

if(count($lista)>0)
{
	$textoEstado = "";
	$c=0;$f=4;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDoc"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["numfactura"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["razonsocial"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["rut"]);
		
		switch ($i["estado"]) {
    	case 0:
        	$textoEstado = "Completa";
        	break;
    	case 1:
        	$textoEstado = "Pend. Recibo Conf.";
        	break;
    	case 2:
	        $textoEstado = "Pend Pago. Recibo Conf.";
			break;
    	case 3:
	        $textoEstado = "Anulada";		
        	break;
		}	
	
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $textoEstado);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["total"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, round($i["total"]*0.19));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, round($i["total"]+($i["total"]*0.19)));

		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["descripcion"]);


		switch ($i["tipopago"]) {
    	case 1:
    		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, gmdate("d-m-Y",strtotime($i["fechacredito"])));
        	break;
    	case 2:
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["numcheque30"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, "0"==$i["montocheque30"]?'':$i["montocheque30"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, "0"==$i["montocheque30"]?'':gmdate("d-m-Y",strtotime($i["fechacheque30"])));
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, $i["numcheque60"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+15, $f, "0"==$i["montocheque60"]?'':$i["montocheque60"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+16, $f, "0"==$i["montocheque60"]?'':gmdate("d-m-Y",strtotime($i["fechacheque60"])));
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+17, $f, $i["numcheque90"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+18, $f, "0"==$i["montocheque90"]?'':$i["montocheque90"]);	
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+19, $f, "0"==$i["montocheque90"]?'':gmdate("d-m-Y",strtotime($i["fechacheque90"])));		
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+20, $f, $i["numcheque120"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+21, $f, "0"==$i["montocheque120"]?'':$i["montocheque120"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+22, $f, "0"==$i["montocheque120"]?'':gmdate("d-m-Y",strtotime($i["fechacheque120"])));
			break;
    	case 3:
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+23, $f, $i["numtransferencia"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+24, $f, $i["montotransferencia"]);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+25, $f, gmdate("d-m-Y",strtotime($i["fechatransferencia"])));
        	break;
		}


		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Ordenes_Compra');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="OrdenesCompra.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
?>

*/