<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Llamados.php');

//Obtención de datos

$Llamados = new Llamados($_CONF);

$buscar 	= !isset($_GET['buscar']) ? "" : $_GET['buscar'];
$orden 		= !isset($_GET['orden']) ? "" : $_GET['orden'];
$fecha1  	= !isset($_GET['fecha1']) ? "" : $_GET['fecha1'];
$fecha2 	= !isset($_GET['fecha2']) ? "" : $_GET['fecha2'];
$fechas     = "";

if($fecha1 !="" && $fecha2 !="")
{
    list( $dia, $mes, $anio) = explode( '-', $fecha1);
    $fecha1 = "$anio/$mes/$dia";
    list( $dia, $mes, $anio) = explode( '-', $fecha2);
    $fecha2 = "$anio/$mes/$dia";

    $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
}

switch($orden)
{
	default:
		$ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
	break;
	case 1:
		$ordenStr = 'usuarios.apellidos';
	break;
	case 2:
		$ordenStr = 'clientes.razonsocial';
	break;
	case 3:
		$ordenStr = 'maquinas.modelo';
	break;
	case 4:
		$ordenStr = 'llamados.fecha DESC';
	break;	
}

$lista = $Llamados->listarLlamadosTecnicosClientesTOEXCEL($buscar, $ordenStr, $fechas);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Llamados Histórico Técnicos")
							 ->setSubject("")
							 ->setDescription("Llamados Histórico Técnicos")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:N2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LLAMADOS HISTORICOS TECNICOS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Rut Técnico');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Nombre Tecnico');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Rut Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, "Fecha Llamado");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'SubTipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Falla');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Prioridad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Marca Maquina');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Modelo Maquina');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Serie Interna Máquina');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'Tipo Máquina');
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["RUTTecnico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["NombreTecnico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["RutCliente"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i['ClienteRazonSocial']);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i['FechaLlamado']);		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i['tipo']);		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i['otrotipo']);				
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i['idfalla']>0?utf8_encode($i['nombrefalla']):($i['idfalla']==-2?utf8_encode($i['otrafalla']):"Código: ".$i['coderror']));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i['prioridad']==1?'Alta':($i['prioridad']==2?"Media":"Baja"));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["MarcaMaquina"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["ModeloMaquina"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["SerieInternaMaquina"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["TipoMaquina"]);		
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Llamados');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel;charset=iso-8859-1');
header('Content-Disposition: attachment;filename="ListaLlamadosPorTecnico.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');