<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Llamados.php');

//Obtención de datos

$Llamados = new Llamados($_CONF);

$buscar 	= !isset($_GET['buscar']) ? "" : $_GET['buscar'];
$orden 		= !isset($_GET['orden']) ? "" : $_GET['orden'];
$fecha1  	= !isset($_GET['fecha1']) ? "" :$_GET['fecha1'];
$fecha2 	= !isset($_GET['fecha2']) ? "" : $_GET['fecha2'];
$fechas     = "";

$idReport   = !isset($_GET['idReport']) ? "" : $_GET['idReport'];
$idllamado  = !isset($_GET['idllamado']) ? "" : $_GET['idllamado'];
$pendiente  = !isset($_GET['pendiente']) ? "" : $_GET['pendiente'];

$idllamadoWhere = "";

if(empty($idllamado))
{
    $idllamadoWhere = "";
}
else
{
    $idllamadoWhere = "AND llamados.idllamado LIKE '%".$idllamado."%' ";
}

if($fecha1 !="" && $fecha2 !="")
{
    list( $dia, $mes, $anio) = explode( '-', $fecha1);
    $fecha1 = "$anio/$mes/$dia";
    list( $dia, $mes, $anio) = explode( '-', $fecha2);
    $fecha2 = "$anio/$mes/$dia";

    $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
}

switch($orden)
{
	default:
		$ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
	break;
	case 1:
		$ordenStr = 'usuarios.apellidos';
	break;
	case 2:
		$ordenStr = 'clientes.razonsocial';
	break;
	case 3:
		$ordenStr = 'maquinas.modelo';
	break;
	case 4:
		$ordenStr = 'llamados.fecha DESC';
	break;	
}

switch($pendiente)
{
    default:
        $pendienteWhere = ' ';
        break;
    case 1:
        $pendienteWhere = ' ';
        break;
    case 2:
        $pendienteWhere = 'and llamados.pendiente = "NO" ';
        break;
    case 3:
        $pendienteWhere = 'and llamados.pendiente is null ';
        break;
}


$lista = $Llamados->listarLlamadosEliminadosTOEXCEL($buscar, $ordenStr, $fechas, $idReport, $idllamadoWhere, $pendienteWhere);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Listado General de Llamados")
							 ->setSubject("")
							 ->setDescription("Listado General de Llamados")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:G2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Listado General de Llamados');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID Llamado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Rut Empresa');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Razon Social');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Fecha Llamado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Hora Llamado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Razon');

$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["idllamado"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["rut"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["razonsocial"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["FechaLlamado"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["HoraLlamado"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["razon"]);

		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Llamados');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel;charset=iso-8859-1');
header('Content-Disposition: attachment;filename="ListaLlamadosEliminados.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');