<?php
/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Facturas.php');

//Obtención de datos

$facturas = new Facturas($_CONF);

$buscar 		= !isset($_GET['buscar']) ? null : $_GET['buscar'];
$orden 			= !isset($_GET['orden']) ? null : $_GET['orden'];
$fechaDesde 	= !isset($_GET['desde']) ? null : $_GET['desde'];
$fechaHasta 	= !isset($_GET['hasta']) ? null : $_GET['hasta'];
$idCentroCosto	= !isset($_GET['centrocosto']) ? null : $_GET['centrocosto'];
$nfactura       = $_GET['nfactura'];

$centroCosto 	= "";
$fechas 		= "";
$numerofactura  = "";		

if($nfactura > 0)
{
	$numeroFactura = " AND idFactura = ".$nfactura;	
}

if($idCentroCosto != 0)
{
	$centroCosto = " AND IDCENTROCOSTO = ".$idCentroCosto;	
}
		
		if($fechaDesde != "" && $fechaHasta != "")
		{
			list( $dia, $mes, $anio) = split( '-', $fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = split( '-', $fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND fechaFactura BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}		
		
switch($orden)
{
	default:
		$ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
	break;
	case 1:
		$ordenStr = 'usuarios.apellidos';
	break;
	case 2:
		$ordenStr = 'clientes.razonsocial';
	break;
	case 3:
		$ordenStr = 'maquinas.modelo';
	break;
	case 4:
		$ordenStr = 'llamados.fecha DESC';
	break;	
}

$lista = $facturas->listarTOEXCEL($buscar, $fechas, $ordenStr, (isset($numeroFactura) ? $numeroFactura : null));

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Listado Facturas")
							 ->setSubject("")
							 ->setDescription("Listado Facturas")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:M2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LISTADO FACTURAS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'N° Factura');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Rut Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Razon Social');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Fecha Factura');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Fecha Vencimiento');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Forma de Pago');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "Neto");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, "%Descuento");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, "Nuevo Neto");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'IVA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Total');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Centro de Costo');

$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["idFactura"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["rutCliente"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["razonsocial"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, gmdate("d-m-Y",strtotime($i["fechaFactura"])));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, gmdate("d-m-Y",strtotime($i['fechaVencimiento'])));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i['formaPago']);	
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i['NETO']);	
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i['descuento']);	
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, round($i["NETO"]*(100 - $i["descuento"])/100,0));	
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, round($i["NETO"]*(100 - $i["descuento"])/100*19/100,0));		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, round($i["NETO"]*(100 - $i["descuento"])/100*119/100,0));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i['CENTROCOSTO']);
		$c=0;$f++;$count++;
	}
}




// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Facturas');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel;charset=iso-8859-1');
header('Content-Disposition: attachment;filename="ListaFacturas.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');