<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/CompraDirecta.php');

//Obtención de datos

$compra = new CompraDirecta($_CONF);

$buscar 		= $_GET['buscar'] ?? "";
$filtroorden 	= $_GET['orden'] ?? "";
		
$fechaDesde 	= $_GET['desde'] ?? "";
$fechaHasta 	= $_GET['hasta'] ?? "";
			
switch($filtroorden)
{
	default:
		$ordenStr = 'IDcd';
		$filtroorden = 1;
		break;
	case 2:
		$ordenStr = 'IDcd DESC';
		break;
	case 3:
		$ordenStr = 'total';
		break;
	case 4:
		$ordenStr = 'total DESC';
		break;
	case 5:
		$ordenStr = 'fecha';
		break;
	case 6:
		$ordenStr = 'fecha DESC';
		break;	
}

$cantidads = $compra->cantidad($buscar, $fechaDesde, $fechaHasta);
$lista = $compra->listar(0, $cantidads, $buscar, $ordenStr, $fechaDesde, $fechaHasta);		

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Compra Directa")
							 ->setSubject("")
							 ->setDescription("Compra Directa")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:G2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'COMPRAS DIRECTAS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'FECHA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'N° CD');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'PROVEEDOR');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'RUT');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, "NETO");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'IVA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'TOTAL');

$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:G3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

if(isset($lista) && count($lista)>0)
{
	$c=0;$f=4;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDcd"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["razonsocial"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["rutp"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["total"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, round($i["total"]*0.19));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, round($i["total"]+($i["total"]*0.19)));
		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Compra_Directa');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="CompraDirecta.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');