<?php
class ServiciosControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $servicios;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->servicios = new Servicios($this->NX_CONFIG);
	}
    //</editor-fold>

	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$servicio 			= utf8_encode($_POST['servicio']);
			$precio 			= $_POST['precio'];
			$tipocambio 		= $_POST['tipocambio'];
		    $ok = $this->servicios->nuevo($servicio, $precio, $tipocambio,13420903);
			if($ok)
			{
				return $this->info_msg = $this->msg('popup', 'Servicio', 1,0,1);
			}else{
				return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Servicio, contacte al Administrador.');</script>";
			}
		}
		return $this->ver('nuevo_servicio');
	}
	
	public function nuevoPorCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$servicio 			= utf8_encode($_POST['servicio']);
			$precio 			= $_POST['precio'];
			$tipocambio 		= $_POST['tipocambio'];
			$idCliente          = $_POST['rut'];
		    $ok = $this->servicios->nuevoPorCliente($servicio, $precio, $tipocambio,$idCliente);
			if($ok)
			{
				return $this->info_msg = $this->msg('popup', 'Servicio', 1,0,1);
			}else{
				return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Servicio, contacte al Administrador.');</script>";
			}
		}
		return $this->ver('nuevo_servicio');
	}
	
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 		= 1;
		$this->resultados 	= 20;
		$this->buscar 		= $_GET['buscar'];
		$this->orden 		= $_GET['orden'];		
		
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'servicio';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'servicio DESC';
			break;			
		}
		
		$cantidad = $this->servicios->cantidad($this->buscar);
		$this->lista = $this->servicios->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);		
		$this->nPaginas = ceil($cantidad / $this->resultados);
			
		return $this->ver('seleccionar_servicio');	
	}
	
	public function editar() 
	{
		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9 ) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if(!isset($_SESSION['usuario']))
		{
			header('location: index.php?error=nologin');
		}
		$servicios = new Servicios($this->NX_CONFIG);
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idservicio		= $_POST['servicio'];
			$nombreservicio	= $_POST['nombreservicio'];
			$precios		= $_POST['precio'];
			$tipocambio		= $_POST['tipocambio'];
			$n = count($precios);
			$i = 0;
			while ($i < $n){
				$servicios->editar($idservicio[$i], utf8_encode($nombreservicio[$i]), $precios[$i], $tipocambio[$i]);
				$i++;
			}
			header("Location: index.php?controlador=Servicios&accion=editar&infomsg=ok");
			return;
		
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="ok")
		{
			$this->info_msg  = $this->msg('completa', 'Listado de servicios', 2, 0, 1);
		}

		$this->listado = $servicios->listarTodos(13420903);
		$this->contenido = $this->ver('editar_servicio');
		return $this->ver('index');		
	}

	public function editarclienteServicios() 
	{
		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if(!isset($_SESSION['usuario']))
		{
			header('location: index.php?error=nologin');
		}
		$servicios = new Servicios($this->NX_CONFIG);
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idservicio		= $_POST['servicio'];
			$nombreservicio	= $_POST['nombreservicio'];
			$precios		= $_POST['precio'];
			$tipocambio		= $_POST['tipocambio'];
			$n = count($precios);
			$i = 0;
			while ($i < $n){
				$servicios->editar($idservicio[$i], utf8_encode($nombreservicio[$i]), $precios[$i], $tipocambio[$i]);
				$i++;
			}
			//header("Location: index.php?controlador=Servicios&accion=editarclienteServicios&infomsg=ok");
			return;
		
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="ok")
		{
			$this->info_msg  = $this->msg('completa', 'Listado de servicios', 2, 0, 1);
		}
		$this->listado = $servicios->listarTodosPorCliente($_GET["rut"]);
		$this->contenido = $this->ver('editar_clienteServicios');
		return $this->ver('index');		
	}
	
	public function eliminar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5) 
		{
			header('location: index.php?error=restringido');
			return;
		}

		$idservicio = $_GET['idservicio'];
		$this->servicios->eliminar($idservicio);
		header('location: index.php?controlador=Servicios&accion=editar');
	}

	public function eliminarclienteServicios()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5) 
		{
			header('location: index.php?error=restringido');
			return;
		}

		$idservicio = $_GET['idservicio'];
		$this->servicios->eliminar($idservicio);
		header('location: index.php?controlador=Servicios&accion=editarclienteServicios');
	}

}
?>