<?php

class ReportabilidadControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $reportabilidad;
	var $configuraciones;
    private $NX_CONFIG;
    //</editor-fold>
		
			/** Actual month last day **/
	private function _data_last_month_day() 
	{ 
    	$month = date('m');
      	$year = date('Y');
      	$day = date("d", mktime(0,0,0, $month+1, 0, $year));
 
		return date('Y-m-d', mktime(0,0,0, $month, $day, $year));
  	}
 
  	/** Actual month first day **/
  	private function _data_first_month_day() 
  	{
    	$month = date('m');
      	$year = date('Y');
      	return date('Y-m-d', mktime(0,0,0, $month, 1, $year));
  	}

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->reportabilidad   = new Reportabilidad($this->NX_CONFIG);
		$this->configuraciones	= new Configuraciones($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteUsoInsumoMensual">
	public function reporteUsoInsumoMensual()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$clausulaIdProducto = "";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->idproducto	= $_GET['idproducto'] ?? "";
		$this->codinterno   = $_GET['idproducto'] ?? "";
		$this->fecha1 		= $_GET['fecha1'] ?? "";
		$this->fecha2 		= $_GET['fecha2'] ?? "";
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if ($this->idproducto != "")
		{
			$clausulaIdProducto = " and inventario.codinterno = '" . $this->idproducto . "' ";	
		}
		
	
		if($this->fecha1 !="" )
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 
				
				$fechas= "WHERE reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			
			$this->cantidad = $this->reportabilidad->cantidadReporteUsoInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto);
			$this->lista = $this->reportabilidad->reporteUsoInsumoMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto);
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}
		else
		{
			//Obtenemos el Primer Dia del Mes Actual 
			$month = date('m');
      		$year = date('Y');
      		$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
	
			//Obtenemos el Ultimo Dia del Mes Actual				
			$month = date('m');
      		$year = date('Y');
      		$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
			$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
				
			$fechas= "WHERE reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
				
			$this->cantidad = $this->reportabilidad->cantidadReporteUsoInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto);
			$this->lista = $this->reportabilidad->reporteUsoInsumoMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto);
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		
		$this->contenido = $this->ver('reportabilidadUsoInsumoMensual');
		return $this->ver('index');	
		
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCantidadMaquinaMensual">
	public function reporteCantidadMaquinaMensual()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$clausulaIdProducto = "";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->idmaquina	= $_GET['idmaquina'] ?? "";
		$this->codinterno   = $_GET['idmaquina'] ?? "";
		$this->fecha1 		= $_GET['fecha1'] ?? "";
		$this->fecha2 		= $_GET['fecha2'] ?? "";
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if ($this->idmaquina != "")
		{
			$clausulaIdMaquina = " and maquinas.serieinterna = '" . $this->idmaquina . "' ";	
		}
		
	
		if($this->fecha1 !="" )
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 				
				$fechas= " and fechacompra BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			
			$this->cantidad = $this->reportabilidad->cantidadReporteCantidadMaquinaMensual(
                $fechas ?? "",
                $clausulaIdMaquina ?? "");
			$this->lista = $this->reportabilidad->reporteCantidadMaquinaMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdMaquina ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}
		else
		{
			//Obtenemos el Primer Dia del Mes Actual 
			$month = date('m');
      		$year = date('Y');
      		$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
	
			//Obtenemos el Ultimo Dia del Mes Actual				
			$month = date('m');
      		$year = date('Y');
      		$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
			$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
				
			$fechas= " and fechacompra BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
				
			$this->cantidad = $this->reportabilidad->cantidadReporteCantidadMaquinaMensual(
                $fechas ?? "",
                $clausulaIdMaquina ?? "");
			$this->lista = $this->reportabilidad->reporteCantidadMaquinaMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdMaquina ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		
		$this->contenido = $this->ver('reportabilidadCantidadMaquinaMensual');
		return $this->ver('index');	
		
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteComprasCategoriaMensual">
	public function reporteComprasCategoriaMensual()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$clausulaIdProducto = "";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->idproducto	= $_GET['idproducto'] ?? "";
		$this->codinterno   = $_GET['idproducto'] ?? "";
		$this->fecha1 		= $_GET['fecha1'] ?? "";
		$this->fecha2 		= $_GET['fecha2'] ?? "";
		
		
		$this->buscar = $_GET['buscar'] ?? "";
		$this->orden = $_GET['orden'] ?? "";
		$this->filtrocat = $_GET['categoria'] ?? "";
		$this->filtrotipo = $_GET['tipo'] ?? "";
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if ($this->idproducto != "")
		{
			$clausulaIdProducto = " and ocitems.idproducto = '" . $this->idproducto . "' ";	
		}

	    switch($this->filtrocat)
		{
			default:
				$whereCat = ' AND inventario.categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		switch($this->filtrotipo)
		{
			default:
			   $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = " AND inventario.tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = " AND inventario.tipo='Repuesto'";
			break;			
		}
		
	
		if($this->fecha1 !="" )
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 				
				$fechas= " and oc.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			
			$this->cantidad = $this->reportabilidad->cantidadComprasCategoriaMensual(
                $fechas ?? "",
                $clausulaIdProducto ?? "",
                $whereCat ?? "",
                $whereTip ?? "");
			$this->lista = $this->reportabilidad->reporteComprasCategoriaMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto ?? "",
                $whereCat ?? "",
                $whereTip ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}
		else
		{
			//Obtenemos el Primer Dia del Mes Actual 
			$month = date('m');
      		$year = date('Y');
      		$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
	
			//Obtenemos el Ultimo Dia del Mes Actual				
			$month = date('m');
      		$year = date('Y');
      		$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
			$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
				
			$fechas= " and oc.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
				
			$this->cantidad = $this->reportabilidad->cantidadComprasCategoriaMensual(
                $fechas ?? "",
                $clausulaIdProducto ?? "",
                $whereCat ?? "",
                $whereTip ?? "");
			$this->lista = $this->reportabilidad->reporteComprasCategoriaMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto ?? "",
                $whereCat ?? "",
                $whereTip ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		
		$categoriasInv = new Categorias($this->NX_CONFIG);
		$this->categorias = $categoriasInv->listar();
		
		$this->contenido = $this->ver('reportabilidadComprasCategoriaMensual');
		return $this->ver('index');
	}
    //</editor-fold>
	
/************************      NUEVO REPORT         ************************/
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->rutTaller = $this->configuraciones->getValor(IDCONFIG_RUT_TALLER);
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idReport 				= $_POST['numeroreport'];
			$rut 					= $_POST['rut']; //cliente
			$serieInterna 			= $_POST['serieinterna']; //DATOS DE LA MAQUINA			
			$correlativo 			= $_POST['correlativo'];
			$movimiento 			= $_POST['movimiento']; //radio button seleccionado(n�mero)			
			$fecha 					= $_POST['fecha']; //DATOS DEL REPORT
			$ubicacion 				= $_POST['ubicacion']; //UBICACION
			$horaDespacho 			= $_POST['horadespacho'];//DATOS DEL REPORT
			$horaLlegada	 		= $_POST['horallegada'];//DATOS DEL REPORT
			$horaSalida 			= $_POST['horasalida'];//DATOS DEL REPORT
			$ruttecnico 			= $_POST['ruttecnico'];//DATOS DEL REPORT
			$contador 				= $_POST['contador'];//DATOS DEL REPORT
			$detalle 				= $_POST['detalle'];//DATOS DEL REPORT
			$tipoServicioMaquina	= $_POST['tipoServicioMaquina'];//DATOS DEL REPORT

			//PRODUCTOS UTILIZADOS
			$productoid		= $_POST['productoid'];
			$prodcant		= $_POST['prodcant'];
			
			$estadoretiro		= $_POST['estadoretiro'];//RETIRO DE LA MAQUINA
			$observacionretiro	= $_POST['observacionretiro'];//RETIRO DE LA MAQUINA
			$observacionmaqext	= $_POST['observacionmaqext'];//SERVICIO MAQ EXTERNA
			$solucion			= $_POST['solucion'];
			$falla				= $_POST['falla'];
			$actTalonario = false;
			$inventario = new Inventario();
			$llamado = new Llamados();
			
			
			//Instalacion
			if($movimiento==1)
			{
				/*
				1. (REPORT)Se ingresa el report - tabla 'reports'
				2. (CLIENTE) Se obtiene un correlativo (numero de veces que posee la maquina el cliente) - tabla 'clientemaquina'
				3. (MAQUINAS) actualizar el estado de la maquina con el cliente actual a 0 - tabla 'clientemaquina'
				4. (CLIENTE) Asociar maquina al cliente - tabla 'clientemaquina' (estado = 1)
				6. (REPORT) se agregan los insumos utilizados - tabla 'reportinventario' 
				7. (INVENTARIO) se actualiza el stock - tabla 'inventario'
				*/

				//Se ingresa el REPORT
				$ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",$tipoServicioMaquina);
				$correlativo = $this->clientes->nextCorrelativoClienteMaquina($rut, $serieInterna);
				
				if($ok)
				{
					
					$this->maquinas->setEstadoHistorial($serieInterna); //Al antiguo due�o se le asigna un estado 0 (clientemaquina)
					$this->clientes->agregarMaquina($rut, $serieInterna, $correlativo, $ubicacion); //Se le ingresa la maquina al nuevo cliente (clientemaquina)

					//Agrega automaticamente a la tabla contadores 10/01/11
					//$this->contadores->nuevo($rut, $serieInterna, $correlativo, 1, $fecha, $contador, 0, 0, $fecha, 1, "NULL", $idReport);		
					
					//Agregar los productos al report
					$n        = count($productoid);
					$i        = 0;
					while ($i < $n){
						$this->reports->agregarProducto($idReport , $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
						$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
						$i++;
					}					
					$actTalonario = true;
					
				}else{//modificar el info msg
					$this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
				}
				
			}
			
			//Retiro
			if($movimiento==2)
			{
				/*
				1. (REPORT)Se ingresa el report - tabla 'reports'
				2. (LLAMADOS) Llamados de la m�quina a pendiente = NO				
				2. (CLIENTE) Se obtiene un correlativo (numero de veces que posee la maquina el cliente) - tabla 'clientemaquina'
				3. (MAQUINAS) actualizar el estado de la maquina con el cliente actual a 0 - tabla 'clientemaquina'
				4. (MAQUINAS) Si es facturada se actualiza el campo 'facturada' en 'clientemaquina'
				5. (CLIENTE) Asociar maquina a CSJ - tabla 'clientemaquina' (estado = 1)
				*/
				
				$ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext,$tipoServicioMaquina);
				
				if($ok)
				{
					//Modificar los llamados a pendiente = NO
					$llamados = new Llamados();
					$llamados->cambiarestado($rut, $serieInterna, $correlativo);
					
					$correlativo = $this->clientes->nextCorrelativoClienteMaquina($this->rutTaller, $serieInterna);	//Nuevo correlativo
					$this->maquinas->setEstadoHistorial($serieInterna);//Al antiguo due�o se le asigna un estado 0 (clientemaquina)
					
					//Colocar si es facturada o no
					$this->maquinas->setEstadoFacturada($rut, $serieInterna, 0);
					
					//Se le ingresa la maquina a CSJ (clientemaquina)
					$this->clientes->agregarMaquina($this->rutTaller , $serieInterna, $correlativo, 'CSJ'); 
					
					$actTalonario = true; //Actualizar Talonario					
					
				}else{//modificar el info msg
					$this->info_msg = "<script>alert('Error al realizar el Retiro, contacte al Administrador.');</script>";
				}		
			}	
			
			//Mantenciones
			if($movimiento>=3 && $movimiento<=6)
			{
				
				//nuevo($idReport, $rut, $serieInterna, $correlativo, $tecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext)
				
				$ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",$tipoServicioMaquina);		
				
				if($ok)
				{			
					//Agregar los productos al report
					$n        = count($productoid);
					$i        = 0;
					while ($i < $n){
						$this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
						$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
						$i++;
					}					
					
					//Modificar los Llamados
					for($i=0 ; $i<count($solucion) ; $i++)
					{
						if($solucion[$i]==1)
						{
							$llamado->cambiarestadollamado($falla[$i], $idReport);
						}
					}
					
					$actTalonario = true; 
					
				}else{//modificar el info msg
					$this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
				}			
			}
			
			//Otros movimientos
			if($movimiento>=7 && $movimiento<=9)
			{
				if($movimiento == 7)//----> Entrega de Facturas
				{
					                    //nuevo($idReport, $rut, $serieInterna, $correlativo, $tecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext)

					$ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",$tipoServicioMaquina);
					
				}
				if($movimiento == 8)//-----> Servicio Maquina Externa (No hay serie interna por ser maquina externa)
				{
					$ok = $this->reports->nuevo($idReport, $rut, "", 0, $ruttecnico, 0, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", $observacionmaqext,$tipoServicioMaquina);
					
				}
				if($movimiento == 9)//---> Toma de Contador
				{
					$ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",$tipoServicioMaquina);
				}				
				
				$actTalonario = true;
				
				if($ok)
				{
					//$actTalonario = true; //Actualizar Talonario	
				}else{//modificar el info msg
					$this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
				}		
			}	
			
			//ACTUALIZAR TALONARIO
			$talonarioactual = new ReportTalonario();
			$talonarionuevo = new ReportTalonario();
			$talonario = new ReportTalonario();
			if($actTalonario)
			{   
				$talonarioactual = $talonario->obtenertalonarioactual($ruttecnico);
				if($idReport == $talonarioactual["numfinal"])
				{
					//nuevo numero actual es igual al numero final del talonario
					$talonario->cambiarestado($talonarioactual["IDtalonario"], 3); //talonario actual se acabo (estado 3: usado)
					$talonarionuevo = $talonario->obtenernuevotalonario($ruttecnico);
					if(isset($talonarionuevo))
					{
						$talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual	
					}else{
						//echo "no hay talonarios 2";
					}
				}else{//nuevo numero actual dentro del rango
					$talonario->cambiarnumeroactual($talonarioactual["IDtalonario"], $idReport+1);
				}		
				header("Location: index.php?controlador=Reports&accion=inicio&infomsg=yes");
				return;	
			}
		}

		$rut  = $_GET['rut'];
		$user = new Usuarios($this->NX_CONFIG);
		$this->datostecnico = $user->obtenerDatos($rut);
		$rtalonario = new ReportTalonario();
		$talact = $rtalonario->obtenertalonarioactual($rut);
		$this->number = $talact["numactual"];
		$this->contenido = $this->ver('nuevo_report');
		return $this->ver('index');
	}
	
/************************      INICIO         ************************/
	public function inicio()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			//Entra a esta secci�n de codigo si se anular� el Report (sea uno o el talonario completo)
			$rut 		= $_POST['rut'];
			$razon 		= $_POST['detalle'];
			$numactual 	= $_POST['numeroreport'];
			$tipo		= $_POST['tipo']; // 1:solo el report, 0:Todo el talonario
		
			$talonario = new ReportTalonario();
			$actual = $talonario->obtenertalonarioactual($rut);

			if($tipo==0)//Anular Talonario
			{
				$ok = $talonario->ingresaranulado($actual["IDtalonario"],$actual["numactual"]."-".$actual["numfinal"],$razon);//Insert Anulado 
				if($ok)
				{
					$talonario->cambiarestado($actual["IDtalonario"],4);//talonario actual a estado anulado (4)
					$talonarionuevo = $talonario->obtenernuevotalonario($rut);//Obtener talonario en cola, si corresponde
					if(isset($talonarionuevo))
					{
						$talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual		
					}else{
						//T�cnico no posee talonarios en cola
					}
					header("Location: index.php?controlador=Reports&accion=inicio&infomsg=si&key=Talonario");
					return;	
				}				
			}
			
			if($tipo==1)//Anular Report
			{
				$ok = $talonario->ingresaranulado($actual["IDtalonario"],$actual["numactual"],$razon);//Insert Anulado 
				if($ok)
				{			
					if($numactual==$actual["numfinal"])
					{
						$talonario->cambiarestado($actual["IDtalonario"],3);//talonario actual a estado anulado (4)
						$talonarionuevo = $talonario->obtenernuevotalonario($rut);//Obtener talonario en cola, si corresponde
						if(isset($talonarionuevo))
						{
							$talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual		
						}else{
							//tecnico sin talonarios
						}
					}else{
						$talonario->cambiarnumeroactual($actual["IDtalonario"], $numactual+1);
					}
					header("Location: index.php?controlador=Reports&accion=inicio&infomsg=si&key=Report");
					return;	
				}
			}
		}
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', $_GET["key"], 4, 0, 1);
		}
		if($_GET["infomsg"]=="yes")
		{
			$this->info_msg  = $this->msg('completa', 'Report', 1, 0, 1);
		}
		
		$this->contenido = $this->ver('inicio_report');
		return $this->ver('index');
	}
	
/************************      SELECCIONAR POR CLIENTE MAQUINA         ************************/
	//Al seleccionar IngresarContador -> Report
	public function seleccionarByClienteMaquina()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
	
		$this->rut 					= $_GET['rut'];
		$this->serieInterna 		= $_GET['serieinterna'];
		$this->correlativo 			= $_GET['correlativo'];
		$this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'];
		
		$this->lista 		= $this->reports->getByClienteMaquina($this->rut, $this->serieInterna, $this->correlativo);
				
		return $this->ver('seleccionar_report_contador');
	}
	
/************************      LISTAR         ************************/
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->cliente 		= $_GET['cliente'];
		$this->maquina 		= $_GET['maquina'];		
		$this->tecnico 		= $_GET['tecnico'];	
		$this->numreport	= $_GET['numreport'];
		$this->fecha1 		= $_GET['fecha1'];	
		$this->fecha2 		= $_GET['fecha2'];	
		
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
		
		if($this->cliente != "" || $this->maquina != "" || $this->tecnico !="" || $this->fecha1 !="" || $this->numreport != "")
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 
				
				$fechas= "AND reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			
			$this->cantidad = $this->reports->cantidadlistar($this->cliente, $this->maquina, $this->tecnico, $fechas, $this->numreport); 	
			$this->lista = $this->reports->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->cliente, $this->maquina, $this->tecnico, $fechas, $this->numreport);		
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}else
		{
			$this->cantidad = $this->reports->cantidadlistarTodos(); 	
			$this->lista = $this->reports->listarTodos($this->resultados * ($this->pagina-1), $this->resultados);		
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		
		$this->contenido = $this->ver('listar_reports');
		return $this->ver('index');	
	}	
	
/************************      DETALLE         ************************/
	public function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idreport	= $_GET['idreport'];
		$this->detalles = $this->reports->detalle($idreport);	
		$this->cliente = $this->clientes->obtenerDatos($this->detalles["rut"]);
		$usuario = new Usuarios();
		$this->tecnico = $usuario->obtenerDatos($this->detalles["tecnico"]);
		$this->maquina = $this->maquinas->obtenerDatos($this->detalles["serieinterna"]);
		$llamado = new Llamados();
		$this->listallamadosresueltos = $llamado->listarLlamadosResueltos($idreport);
		$this->productos = $this->reports->productosReport($idreport);
		return $this->ver('ver_detalle_reports');
	}

// 20/01/11
	public function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{		
			$numeroot		= $_POST['numeroot'];
			$numerobol		= $_POST['numerobol'];
			$rut			= $_POST['rut'];
			$totalneto		= $_POST['totalnetosf'];
			$responsable	= $_POST['resp'];
			
			$this->OT->actualizarOT($numeroot, $rut, $numerobol, $totalneto, $responsable);
			
			$filas			= $_POST['pos'];			
			$servicios		= $_POST['desc'];
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precios		= $_POST['preciosf'];

			$n = count($filas);
			$i = 0;
			while ($i < $n){
				$this->OT->actualizarServicios($filas[$i], $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i]);
				$i++;
			}
			header("Location: index.php?controlador=OT&accion=iniciolistar&infomsg=si");
			return;
		}
		$idreport = $_GET['idreport'];
		$this->detalles = $this->reports->detalle($idreport);
		$this->cliente = $this->clientes->obtenerDatos($this->detalles["rut"]);
		$usuario = new Usuarios();
		$this->tecnico = $usuario->obtenerDatos($this->detalles["tecnico"]);
		$this->maquina = $this->maquinas->obtenerDatos($this->detalles["serieinterna"]);
		$llamado = new Llamados();
		$this->listallamadosresueltos = $llamado->listarLlamadosResueltos($idreport);
		$this->productos = $this->reports->productosReport($idreport);
		$this->ubicacion = $this->reports->ubicacionMaquina($this->detalles["rut"], $this->detalles["serieinterna"]);	
		
		$this->contenido = $this->ver('editar_report');
		return $this->ver('index');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteDevolucionInsumoMensual">
	public function reporteDevolucionInsumoMensual()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$clausulaIdProducto = "";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->idproducto	= $_GET['idproducto'] ?? "";
		$this->codinterno   = $_GET['idproducto'] ?? "";
		$this->fecha1 		= $_GET['fecha1'] ?? "";
		$this->fecha2 		= $_GET['fecha2'] ?? "";
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if ($this->idproducto != "")
		{
			$clausulaIdProducto = " and inventario.codinterno = '" . $this->idproducto . "' ";	
		}
		if($this->fecha1 !="" )
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 
				
				$fechas= " controldevolucioninventario.fechaDevolucionReal BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			$this->cantidad = $this->reportabilidad->cantidadReporteDevolucionInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto ?? "");
			$this->lista = $this->reportabilidad->reporteDevolucionInsumoMensual(
                $this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto);
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}
		else
		{
			//Obtenemos el Primer Dia del Mes Actual 
			$month = date('m');
      		$year = date('Y');
      		$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
	
			//Obtenemos el Ultimo Dia del Mes Actual				
			$month = date('m');
      		$year = date('Y');
      		$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
			$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
				
			$fechas= " controldevolucioninventario.fechaDevolucion BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
				
			$this->cantidad = $this->reportabilidad->cantidadReporteDevolucionInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto ?? "");
			$this->lista = $this->reportabilidad->reporteDevolucionInsumoMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto);
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		$this->contenido = $this->ver('reportabilidadDevolucionInsumoMensual');
		return $this->ver('index');	
		
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCentroCostoInsumoMensual">
	public function reporteCentroCostoInsumoMensual()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$clausulaIdProducto = "";
		$clausulaCliente = "";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->idproducto	 = $_GET['idproducto'] ?? "";
		$this->codinterno    = $_GET['idproducto'] ?? "";
		$this->fecha1 		 = $_GET['fecha1'] ?? "";
		$this->fecha2 		 = $_GET['fecha2'] ?? "";
		$this->cliente		 = $_GET['cliente'] ?? "";
		$this->idcentrocosto = $_GET['idcentrocosto'] ?? "";
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if ($this->idproducto != "")
		{
			$clausulaIdProducto = " and codinterno like '%" . $this->idproducto . "%' ";	
		}

		if ($this->cliente != "")
		{
			$clausulaCliente = " and razonsocial like '%" . $this->cliente . "%' ";	
		}		
		
		if ($this->idcentrocosto > 0)
		{
			$clausulaIdCentroCosto = " and idCentroCosto = '" . $this->idcentrocosto . "' ";
		}
	
		if($this->fecha1 !="" )
		{
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 
				
				$fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}
			
			$this->cantidad = $this->reportabilidad->cantidadReporteCentroCostoInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto,
                $clausulaCliente,
                $clausulaIdCentroCosto ?? "");
			$this->lista = $this->reportabilidad->reporteCentroCostoInsumoMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto,
                $clausulaCliente,
                $clausulaIdCentroCosto ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		}
		else
		{
			//Obtenemos el Primer Dia del Mes Actual 
			$month = date('m');
      		$year = date('Y');
      		$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
	
			//Obtenemos el Ultimo Dia del Mes Actual				
			$month = date('m');
      		$year = date('Y');
      		$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
			$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
				
			$fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
				
			$this->cantidad = $this->reportabilidad->cantidadReporteCentroCostoInsumoMensual(
                $fechas ?? "",
                $clausulaIdProducto,
                $clausulaCliente,
                $clausulaIdCentroCosto ?? "");
			$this->lista = $this->reportabilidad->reporteCentroCostoInsumoMensual(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $fechas ?? "",
                $clausulaIdProducto,
                $clausulaCliente,
                $clausulaIdCentroCosto ?? "");
			$this->nPaginas = ceil( $this->cantidad / $this->resultados);					
		}
		
		$this->contenido = $this->ver('reportabilidadCentroCostoInsumoMensual');
		return $this->ver('index');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteServiciosCliente">
	public function reporteServiciosCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$cliente = "13420903";
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->cliente	= $_GET['cliente'] ?? "";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		if (strlen($this->cliente) == 0)
		{				
			$this->cliente = "13420903";
		}	
		else
		{
			$cliente = $this->cliente;
		}	
	
		$this->cantidad = $this->reportabilidad->cantidadReporteServiciosCliente($cliente);
		$this->lista = $this->reportabilidad->reporteServiciosCliente(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $cliente);
		$this->nPaginas = ceil( $this->cantidad / $this->resultados);	
		
		$this->contenido = $this->ver('reportabilidadServiciosCliente');
		return $this->ver('index');		
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteGestionHorasLlamadoReporte">
    public function reporteGestionHorasLlamadoReporte()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $cliente = "13420903";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->cliente	= $_GET['cliente'] ?? "";

        $this->fecha1 		= $_GET['fecha1'] ?? "";
        $this->fecha2 		= $_GET['fecha2'] ?? "";

        $this->idReport = $_GET['idReport'] ?? "";
        $this->idllamado = $_GET['idllamado'] ?? "";


        $idllamadoWhere = "";

        if(empty($this->idllamado))
        {
            $idllamadoWhere = "";
        }
        else
        {
            $idllamadoWhere = " AND llamados.idllamado = ".$this->idllamado." ";
        }

        $idReportWhere = "";

        if(empty($this->idReport))
        {
            $idReportWhere = "";
        }
        else
        {
            $idReportWhere = " AND llamados.report = ".$this->idReport." ";
        }

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        if (strlen($this->cliente) == 0)
        {
            $this->cliente = "";
        }
        else
        {
            $cliente = $this->cliente;
        }

        $this->lista = $this->reportabilidad->reporteGestionHorasLlamadoReporte(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->cliente,
            $ordenStr ?? "",
            $fechas ?? "",
            $idReportWhere ?? "",
            $idllamadoWhere ?? "");
        $this->cantidad = $this->reportabilidad->cantidadReporteGestionHorasLlamadoReporte(
            $this->cliente,
            $fechas ?? "",
            $idReportWhere ?? "",
            $idllamadoWhere ?? "");
        $this->nPaginas = ceil( $this->cantidad / $this->resultados);

        $this->contenido = $this->ver('reportabilidadGestionHorasLlamadoReporte');
        return $this->ver('index');
    }
    //</editor-fold>
}