<?php
class ReportTalonarioControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $talonario;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->talonario = new ReportTalonario($this->NX_CONFIG);
	}
    //</editor-fold>

	//Con el objetivo de obtener numero inicial,final,actual y total de talonarios en cola
	public function obtenercontadores()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut 	= $_POST['rut'];	
		$this->numeros = $this->talonario->obtenertalonarios($rut, 1);	
		$this->encola =  $this->talonario->obtenercantidadtalonarios($rut, 2);	
	    return $this->ver('contadores_asignar_talonario_report');
	} 
	
	public function asignar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 			= $_POST['rut'];
			$numinicio 		= $_POST['desde'];
			$numfinal 		= $_POST['hasta'];
			$date = date("Y-m-d");
	
			$this->num = $this->talonario->obtenercantidadtalonarios($rut, 1);
			if ($this->num==0)
			{
				$idtalonario = $this->talonario->ingresartalonario($rut, 1, $numinicio, $numfinal);				
			}else{
				$idtalonario = $this->talonario->ingresartalonario($rut, 2, $numinicio, $numfinal);
			}
			
			$this->info_msg  = $this->msg('completa', 'talonario', 1, 0, 1);					
		}
		$this->contenido = $this->ver('asignar_talonario_report');
		return $this->ver('index');
	}
	
	public function detallestalonarioscola()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut 	= $_GET['rut'];
		$this->encola = $this->talonario->obtenertalonarios($rut, 2);		
		return $this->ver('menu_detalle_talonarios_cola');	
	}
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut 	= $_GET['rut'];	
		$this->talactual = $this->talonario->obtenertalonarioactual($rut);
		$this->numeroactual = 'Sin talonario';
		if(is_array($this->talactual))
		{
			$this->numeroactual = $this->talactual["numactual"];
		}
		return $this->numeroactual;
	}
}
?>