<?php

class RebajaInsumoControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $rebajainsumo;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->rebajainsumo = new RebajaInsumo($this->NX_CONFIG);
		$this->centroCosto = new CentroCosto($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->numero = $this->rebajainsumo->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerorebajainsumo  = $_POST["numerorebajainsumo"];
			
			$productoid		= $_POST['productoid'] ?? -1;
			$prodcant		= $_POST['prodcant'] ?? "";
			$idCentroCosto  = $_POST['cencosto'] ?? "";
            $_DETALLE = $_POST["detalle"] ?? "";

			//Ingreso nuevo rebajainsumo salida
			$ok = $this->rebajainsumo->nuevo(
                $numerorebajainsumo,
                $idCentroCosto,
                $_DETALLE);
			if($ok)
			{
				$inventario = new Inventario($this->NX_CONFIG);
				
				//Insumos y respuestos
				$n        = $productoid == -1 ? 0 : count($productoid);
				$i        = 0;
				while ($i < $n){
					$this->rebajainsumo->ingresarinventario($numerorebajainsumo, $productoid[$i], $prodcant[$i]);
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contreal');
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');
					$i++;
				}		 	
				
			header("Location: index.php?controlador=RebajaInsumo&accion=nuevo&infomsg=si");
				return;		
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar Rebaja Insumo, contacte al Administrador.');</script>";
			}
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Rebaja Insumo', 1, 0, 1);	
		}
		$this->listaresponsables = $this->rebajainsumo->listarResponsables();
		$this->listaCentroCosto = $this->centroCosto->listar();
		$this->contenido = $this->ver('nueva_rebajainsumo');
		return $this->ver('index');
	}
    //</editor-fold>

	public function seleccionar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}

		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'];
		$this->orden = $_GET['orden'];
		$this->rut = $_GET['rut'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'IDsalidainterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'IDsalidainterna DESC';
			break;
			case 3:
				$ordenStr = 'Fecha';
			break;
			case 4:
				$ordenStr = 'Fecha DESC';
			break;	
		}
		
	$this->lista = $this->rebajainsumo->listar_salidainterna_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);	
	$cantidad = $this->rebajainsumo->cantidad_salidainterna_cliente($this->buscar, $this->rut);
	$this->nPaginas = ceil($cantidad / $this->resultados);	
    return $this->ver('seleccionar_salidainterna');
	}
	
	public function ver_salidainterna_cliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$idsalidainterna = $_GET['idsalidainterna'];
		$this->salidainternasalida = $this->rebajainsumo->obtenerdatossalidainterna($idsalidainterna);
		$this->listainventario = $this->rebajainsumo->obtenerInventariosalidainterna($idsalidainterna);
		$this->listamaquinas = $this->rebajainsumo->obtenerMaquinassalidainterna($idsalidainterna);
		$this->contenido = $this->ver('ver_salidainterna_cliente');
		return $this->ver('index');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar 	= $_GET['buscar'] ?? "";
		$this->orden 	= $_GET['orden'] ?? "";
		$this->fecha1 	= $_GET['fecha1'] ?? "";
		$this->fecha2 	= $_GET['fecha2'] ?? "";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
		if($this->fecha1 !="" && $this->fecha2 !="")
		{
			list( $dia, $mes, $anio) = explode('-', $this->fecha1);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
			$fecha2 = "$anio/$mes/$dia"; 
			
			$fechas= "and fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
		}
		
        $this->lista = $this->rebajainsumo->listar(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->buscar,
            $ordenStr,
            $fechas ?? "");
        $cantidad = $this->rebajainsumo->cantidad(
            $this->buscar,
            $fechas ?? "");
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_rebajainsumo');
        return $this->ver('index');
	}
    //</editor-fold>

	public function listarParaDevolucionInsumos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 		= $_GET['buscar'];
		$this->idsalidainterna	= $_GET['idsalidainterna'];
		$this->orden 		= $_GET['orden'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
		
	$this->lista = $this->rebajainsumo->listarPorId($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->idsalidainterna);	
	$cantidad = $this->rebajainsumo->cantidadPorID($this->buscar, $this->idsalidainterna);
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	return $this->ver('listar_salidainternaesSalidaParaDevolucionInsumos');	
	}

}
