<?php

class OrdenCompraControlador extends Controlador
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $orden;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->orden = new OrdenCompra($this->NX_CONFIG);
	}
    //</editor-fold>

	/*****************************************************************************************************************/ 
	/*****************************************  OBTENER NÚMERO  *************************************************/
	/*****************************************************************************************************************/
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->orden->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= !isset($_POST['numerooc']) ? "" : $_POST['numerooc'];
			$rutp 			= !isset($_POST['rut']) ? "" : $_POST['rut'];
			$fecha 			= !isset($_POST['fecha']) ? "" : $_POST['fecha'];
			$sumatotal 		= !isset($_POST['sumatotal']) ? "" : $_POST['sumatotal'];
			$rutproveedor	= !isset($_POST['rut']) ? "" : $_POST['rut'];
			$formadepago	= !isset($_POST['formadepago']) ? "" : $_POST['formadepago'];
			$despacharpor	= !isset($_POST['despacharpor']) ? "" : $_POST['despacharpor'];
			//Productos de inventario
			$itemid		    = !isset($_POST['itemid']) ? -1 : $_POST['itemid'];
			$itemcant		= !isset($_POST['itemcant']) ? "" : $_POST['itemcant'];
			$itemprec		= !isset($_POST['itemprec']) ? "" : $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= !isset($_POST['nproductoid']) ? -1 :  $_POST['nproductoid'];
			$nprodcant		= !isset($_POST['nprodcant']) ? "" : $_POST['nprodcant'];
			$nprodprecio	= !isset($_POST['nprodprecio']) ? "" : $_POST['nprodprecio'];
			$datosprod		= !isset($_POST['datosprod']) ? "" : $_POST['datosprod'];
			$codinterno     = !isset($_POST['codinterno']) ? "" : $_POST['codinterno'];

			//Nueva maquina o servicio
			$maqservid			= !isset($_POST['maqservid']) ? -1 : $_POST['maqservid'];
			$maqservcant		= !isset($_POST['maqservcant']) ? "" : $_POST['maqservcant'];
			$maqservprecio		= !isset($_POST['maqservprecio']) ? "" : $_POST['maqservprecio'];
			$datosmaqserv		= !isset($_POST['datosmaqserv']) ? "" : $_POST['datosmaqserv'];
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal, $formadepago, $despacharpor); //Estado = 2
			
			if($ok)
			{ 

			    $inventario = new Inventario($this->NX_CONFIG);
 		    //--> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = ($itemid == -1 ? 0 : count($itemid));
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutproveedor);
					$i++;
				}
				$proveedor = new Proveedor($this->NX_CONFIG);
		        //--> Ingreso de Nuevos Productos
				$cat 		= new Categorias($this->NX_CONFIG);
				$n        	= ($nproductoid == -1 ? 0 : count($nproductoid));
				$i        	= 0;
				while ($i < $n){
                    list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );
                    if($categoria == -1)
                    {
                        $existe = $cat->buscar(strtoupper($nombrecategoria));
                        if(is_numeric($existe))
                        {
                            $categoria = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $categoria = $cat->nuevo(strtoupper($nombrecategoria));
                        }
                    }
                    if($marca == -1)
                    {
                        $existe = $marcamaq->buscar(strtoupper($nombremarca));
                        if(is_numeric($existe))
                        {
                            $marca = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $marca = $marcamaq->nuevo(strtoupper($nombremarca));
                        }
                    }
                    $corr = $inventario->obtenerCorrelativo($tipo[0]);
                    $idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);
                    $inventario->nuevo(
                        $idproducto,
                        $tipo,
                        $categoria,
                        $marca,
                        $modelo,
                        $codinterno[$i],
                        $numparte,
                        $descripcion,
                        0,
                        0,
                        0,
                        0,
                        0,
                        1,
                        '',
                        '',
                        '');
                    $this->orden->ingresaritems(
                        $numerooc,
                        $idproducto,
                        $nprodcant[$i],
                        $nprodprecio[$i],
                        1);
                    $inventario->actualizarPcompra(
                        $idproducto,
                        $nprodprecio[$i]);
                    $inventario->actualizarPcompraProveedorItems(
                        $itemid[$i],
                        $itemprec[$i],
                        $rutproveedor);
                    //asociar al proveedor
                    $proveedor->asociarProducto(
                        $rutproveedor,
                        $idproducto,
                        ($nprodprecio == -1 ? 0 : $nprodprecio[$i]),
                        "");
					$i++;
				}
				$n        = ($maqservid == -1 ? 0 : count($maqservid));
				$i        = 0;
				while ($i < $n){
                    $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
                    $i++;
				}
		        $this->orden->guardarFormaPagoOC($numerooc, 1, "", "", "", "", "", "", "", "", "", "", Date("d-m-Y" , strtotime("+1 month")), "", "", "", "", "");
		        $this->orden->actualizarOC($numerooc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;
				header("Location: index.php?controlador=OrdenCompra&accion=nuevo&infomsg=si");
			    return;	
				
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		if(!isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_oc');
		return $this->ver('index');
	}
    //</editor-fold>

	public function iniciolistar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->anios = $this->orden->aniosDesc();
		$this->contenido = $this->ver('inicio_listar_oc');
		return $this->ver('index');	
	}	
	
	/*****************************************************************************************************************/ 
	/*****************************************  LISTAR    *************************************************/
	/*****************************************************************************************************************/
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada página
		$this->pagVisible = 8; //paginas a mostrar en la paginación
		
		$this->buscar 		= $_GET['buscar'];
		$this->numoc        = $_GET['numoc'];
		$this->filtroorden 	= $_GET['orden'];		
		$this->estado 		= $_GET['estado'];	
		
		$this->fechaDesde 	= $_GET['desde'];
		$this->fechaHasta 	= $_GET['hasta'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->filtroorden)
		{
			default:
				$ordenStr = 'IDoc';
				$this->filtroorden = 1;
			break;
			case 2:
				$ordenStr = 'IDoc DESC';
			break;
			case 3:
				$ordenStr = 'total';
			break;
			case 4:
				$ordenStr = 'total DESC';
			break;
			case 5:
				$ordenStr = 'fecha';
			break;
			case 6:
				$ordenStr = 'fecha DESC';
			break;	
		}

		switch($this->estado)
		{
			default:
			   $whereTip = '';
			break;
			case 0: //completa
				$whereTip = "AND estado=0";
			break;
			case 1: //Pendientes Recibo conforme
				$whereTip = "AND estado=1";
			break;	
			case 2: //Pendientes de Pago y Recibo Conforme
				$whereTip = "AND estado=2";
			break;		
			case 3: //Anuladas
				$whereTip = "AND estado=3";
			break;	
		}
		$cantidads = $this->orden->cantidad($this->buscar, $this->numoc, $whereTip, $this->fechaDesde, $this->fechaHasta);
		$this->lista = $this->orden->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->numoc, $ordenStr, $whereTip, $this->fechaDesde, $this->fechaHasta);
		$this->nPaginas = ceil($cantidads / $this->resultados);	
		return $this->ver('listar_oc');
	}	

	/*****************************************************************************************************************/ 
	/*****************************************  EDITAR ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idoc				 = $_POST['numerooc'];
			$rutp 				 = $_POST['rut'];
			$total				 = $_POST['totalisimo'];
			$numfactura		     = $_POST['numfactura']; 
			$itemid		     	 = $_POST['itemid'];
			$idocitem	    	 = $_POST['idocitem'];
			$itemcant			 = $_POST['itemcant'];
			$itemprec  			 = $_POST['itemprec'];
			$idOCItemBorrar	     = $_POST['idOCItemBorrar'];
			$idOCItemBorrarID    = $_POST['idOCItemBorrarID'];			

			$idocitemmaq         = $_POST['idocitemmaq'];
			$maqservid			 = $_POST['maqservid'];
			$maqservcant         = $_POST['maqservcant'];
			$maqservprecio       = $_POST['maqservprecio'];
			$idOCItemMaqBorrar	 = $_POST['idOCItemMaqBorrar'];
			$idOCItemMaqBorrarID = $_POST['idOCItemMaqBorrarID'];			
			
			$ok 				 = $this->orden->actualizarOC($idoc, $total, "total");

			$inventario = new Inventario();

			$n        = count($idOCItemBorrarID);
			$i        = 0;
			while ($i < $n)
			{
				if ($idOCItemBorrar[$i] == 'SI')
				{
					$this->orden->borrarItemOC($idOCItemBorrarID[$i]);
					//echo "entra a borrar ITEM:";
					//echo $idOCItemBorrarID[$i];
					//echo "<br>";
				}
				$i++;
            }


			$n        = count($idOCItemMaqBorrarID);
			$i        = 0;
			while ($i < $n)
			{
				if ($idOCItemMaqBorrar[$i] == 'SI')
				{
					$this->orden->borrarItemOC($idOCItemMaqBorrarID[$i]);
					//echo "entra a borrar MAQUINA:";
					//echo $idOCItemMaqBorrarID[$i];
					//echo "<br>";
				}
				$i++;
            }

            //ACTUALIZACION DE DATOS OCITEMS
			$n        = count($itemid);
			$i        = 0;

			while ($i < $n)
			{
				$this->orden->actualizarItemOC($idocitem[$i], $itemcant[$i], "cantidad");
				$this->orden->actualizarItemOC($idocitem[$i], $itemprec[$i], "precio");
						//$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
						/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
						//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
						//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');			

				$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
				$inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutp);
				$i++;
            }
			
			$n        = count($maqservid);
			$i        = 0;

			while ($i < $n)
			{				
				$this->orden->actualizarItemOC($idocitemmaq[$i], $maqservcant[$i], "cantidad");
				$this->orden->actualizarItemOC($idocitemmaq[$i], $maqservprecio[$i], "precio");
						



						//$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
						/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
						//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
						//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');			


                        //12Dic2019 Estas dos lineas actualizan el valor del producto en la referencia del proveedor
                        //          Revisar si aplica para las maquinas 
						//$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
						//$inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutp);
				$i++;
			}



			if($ok)
			{
				//Solo por testing. para que no actualice el estado. 
				$this->orden->actualizarOC($idoc, 1, "estado"); //Estado = Pendiente de factura (1)
				if(is_numeric($numfactura))
				{
					$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); //Ingresar numero factura
					$this->orden->actualizarOC($idoc, 0, "estado"); //Estado = Completado (0)
				}
				$borrados	= $_POST['totales'];			
				$n        = count($borrados);
				$i        = 0;
				while ($i < $n){
					$this->orden->borrarinventarioOC($idoc, $borrados[$i]);
					$i++;
				}
					
				$this->info_msg  = $this->msg('completa', 'Orden de Compra', 2, 1, 1);
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al guardar la Orden de Compra, contacte al Administrador.');</script>";
			}
		}				
		$idoc = $_GET['idoc'];
		$this->oc = $this->orden->obtenerdatosOC($idoc);
		$this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
		$this->listamaquinas = $this->orden->obtenerItemsMaqServOC($idoc);
		$this->contenido = $this->ver('editar_oc');
		return $this->ver('index');
	}

	/*****************************************************************************************************************/ 
	/*****************************************  DETALLE ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		$idoc = $_GET['idoc'];
		$this->oc = $this->orden->obtenerdatosOC($idoc);
		$this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
		$this->listamaqserv = $this->orden->obtenerItemsMaqServOC($idoc);
		$this->info_msg = "";
		$this->contenido = $this->ver('ver_oc');		
		return $this->ver('index');
	}
	
	/*****************************************************************************************************************/ 
	/*****************************************  DAR POR PAGADA ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	function OCpagada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc		= $_GET['idOC'];
		$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1;
	}
	
	//Actualizar Stock
	function OCconfirmada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc			= $_GET['idOC'];
		$numfactura		= $_GET['numfactura'];
		$this->orden->actualizarOC($idoc, 0, "estado"); // Cambiar a ESTADO = 0;		
		$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); // Actualizar factura
		//Actualizar inventario
		$inventario = new Inventario();		
		$listainventario = $this->orden->obtenerProductosOC($idoc);
		if(count($listainventario )>0){
			foreach($listainventario as $li){
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contteorico');
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contreal');
			}
		}
	}
	
	function anular()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc		= $_GET['idOC'];
		$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
	}
	
	/* ORDEN COMPRA NUEVA MAQ o SERV */
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
	
	public function seleccionarformadepago() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'];
		$this->orden = $_GET['orden'];		
		
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'rut';
			break;
			case 4:
				$ordenStr = 'rut DESC';
			break;	
		}
		
		//$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		//$cantidad = $this->proveedor->cantidad($this->buscar);
		//$this->nPaginas = ceil($cantidad / $this->resultados);		
		return $this->ver('seleccionar_formadepago');	
	}

	function guardarformadepago()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc				= $_GET['idOC'];
		$tipopago			= $_GET['tipopago'];
		$numcheque30dias	= $_GET['numcheque30dias'];
		$monto30dias		= $_GET['monto30dias'];
		$numcheque60dias	= $_GET['numcheque60dias'];
		$monto60dias		= $_GET['monto60dias'];
		$numcheque90dias	= $_GET['numcheque90dias'];
		$monto90dias		= $_GET['monto90dias'];
		$numcheque120dias	= $_GET['numcheque120dias'];
		$monto120dias		= $_GET['monto120dias'];
		$numtransferencia	= $_GET['numtransferencia'];

		switch ($tipopago) {
    		case "1":  //CREDITO
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
				$numtransferencia	= "";
        		break;
    		case "2":   //CHEQUE
        		$numtransferencia	= "";
        		break;
    		case "3":   //TRANSFERENCIA
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
        		break;
    		default:
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
				$numtransferencia	= "";
		}

		$this->orden->guardarFormaPagoOC($idoc, $tipopago, $numcheque30dias, $monto30dias, $numcheque60dias, $monto60dias, $numcheque90dias, $monto90dias, $numcheque120dias, $monto120dias, $numtransferencia);
		$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;
		//$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
	}

	public function actualizarformadepago() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$idoc			= $_GET['idOC'];	
				
		$this->lista = $this->orden->obtenerdatospagoOC($idoc);
		$this->orden = $idoc;

		//$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		//$cantidad = $this->proveedor->cantidad($this->buscar);
		//$this->nPaginas = ceil($cantidad / $this->resultados);		
		return $this->ver('actualizar_formadepago');	
	}

	function guardaractualizarformadepago()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc				= $_GET['idOC'];
		$tipopago			= $_GET['tipopago'];
		$numcheque30dias	= $_GET['numcheque30dias'];
		$monto30dias		= $_GET['monto30dias'];
		$numcheque60dias	= $_GET['numcheque60dias'];
		$monto60dias		= $_GET['monto60dias'];
		$numcheque90dias	= $_GET['numcheque90dias'];
		$monto90dias		= $_GET['monto90dias'];
		$numcheque120dias	= $_GET['numcheque120dias'];
		$monto120dias		= $_GET['monto120dias'];
		$numtransferencia	= $_GET['numtransferencia'];
		$fechacredito		= $_GET['fechacredito'];
		$fecha30dias		= $_GET['fecha30dias'];
		$fecha60dias		= $_GET['fecha60dias'];
		$fecha90dias		= $_GET['fecha90dias'];
		$fecha120dias		= $_GET['fecha120dias'];
		$montotransferencia	= $_GET['montotransferencia'];
		$fechatransferencia	= $_GET['fechatransferencia'];		

		switch ($tipopago) {
    		case "1":  //CREDITO
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
				$numtransferencia	= "";
				$fecha30dias		= "";
				$fecha60dias		= "";
				$fecha90dias		= "";
				$fecha120dias		= "";
				$montotransferencia	= "";
				$fechatransferencia	= "";		
        		break;
    		case "2":   //CHEQUE
        		$numtransferencia	= "";
				$montotransferencia	= "";
				$fechatransferencia	= "";		
				$fechacredito       = "";
        		break;
    		case "3":   //TRANSFERENCIA
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
				$fecha30dias		= "";
				$fecha60dias		= "";
				$fecha90dias		= "";
				$fecha120dias		= "";
				$fechacredito       = "";
        		break;
    		default:
        		$numcheque30dias	= "";
				$monto30dias		= "";
				$numcheque60dias	= "";
				$monto60dias		= "";
				$numcheque90dias	= "";
				$monto90dias		= "";
				$numcheque120dias	= "";
				$monto120dias		= "";
				$numtransferencia	= "";
		}

		$this->orden->actualizarFormaPagoOC(
			$idoc, 
			$tipopago, 
			$numcheque30dias, 
			$monto30dias, 
			$numcheque60dias, 
			$monto60dias, 
			$numcheque90dias, 
			$monto90dias, 
			$numcheque120dias, 
			$monto120dias, 
			$numtransferencia,
			$fechacredito,
			$fecha30dias,
			$fecha60dias,
			$fecha90dias,
			$fecha120dias,
			$montotransferencia,
			$fechatransferencia
		);
		//$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;
		//$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
	}
}
?>