<?php
class OTTalonarioControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $talonario;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->talonario = new OTTalonario($this->NX_CONFIG);
	}
    //</editor-fold>
	
	//Con el objetivo de obtener numero inicial,final,actual y total de talonarios en cola
	public function obtenercontadores()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$rut 	= $_POST['rut'];	
		$this->numeros = $this->talonario->obtenertalonario($rut, 1);	
		$this->encola =  $this->talonario->obtenercantidadtalonarios($rut, 2);	
	    return $this->ver('contadores_asignar_talonario');
	}
	
	public function detallestalonarioscola()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut 	= $_GET['rut'];	
		$this->encola = $this->talonario->obtenertalonario($rut, 2);		
		return $this->ver('menu_detalle_talonarios_cola');	
	}
	
	public function asignar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 			= $_POST['rut'];
			$numinicio 		= $_POST['desde'];
			$numfinal 		= $_POST['hasta'];
			$date = date("Y-m-d");
	
			$this->num = $this->talonario->obtenercantidadtalonarios($rut, 1);
			if ($this->num["cantidad"]==0)
			{
				$idtalonario = $this->talonario->ingresartalonario($rut, 1, $numinicio, $numfinal);				
			}else{
				$idtalonario = $this->talonario->ingresartalonario($rut, 2, $numinicio, $numfinal);
			}
			
			$this->info_msg  = $this->msg('completa', 'talonario', 1, 0, 1);					
		}
		$this->contenido = $this->ver('asignar_talonario_ot');
		return $this->ver('index');
	}		
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=2 && $_SESSION['area']!=4 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10  && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut 	= $_GET['rut'];	
		$this->numero = $this->talonario->obtenertalonario($rut, 1);
		$this->numeroactual = 'Sin talonario';
		if(count($this->numero)>0)
		{   
			foreach($this->numero as $num)
			{   
				$this->numeroactual = $num["numactual"];
			}
		}
		return $this->numeroactual;
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada página
		$this->pagVisible = 8; //paginas a mostrar en la paginación

		$this->fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
		$this->fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$fechas = "";
		
		if($this->fechaDesde != "" && $this->fechaHasta != "")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		
		$cantidads = $this->talonario->cantidad($this->buscar, $fechas); 
		$this->lista = $this->talonario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $fechas);		
		$this->nPaginas = ceil($cantidads / $this->resultados);	

		$this->total = 1;	
		//return $this->ver('listar_ot');
		
		$this->contenido = $this->ver('listar_talonario');
		return $this->ver('index');	
	}
    //</editor-fold>

	public function eliminar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$idTalonario = $_GET['idTalonario'];
		$this->talonario->cambiarestado($idTalonario, 3);
		header('location: index.php?controlador=OTTalonario&accion=listar');
	}
	
	public function activar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$idTalonario = $_GET['idTalonario'];
		$this->talonario->cambiarestado($idTalonario, 1);
		header('location: index.php?controlador=OTTalonario&accion=listar');
	}
}