<?php
class OTControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $OT;
	var $clientes;
	var $facturas;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->clientes = new Clientes($this->NX_CONFIG);
		$this->OT = new OrdenTrabajo($this->NX_CONFIG);
		$this->configuraciones	= new Configuraciones($this->NX_CONFIG);
		$this->facturas = new Facturas($this->NX_CONFIG);
		$this->funcionesMatematicas = new FuncionesMatematicas($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numeroot		= $_POST['numeroot'];
			$newnumeroactual = $numeroot + 1;
			$rut			= $_POST['rut'];
			$responsable	= $_POST['responsable'];			
			$fecha			= $_POST['fecha'];	
			$servicios		= $_POST['servicioClientesId'];
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precios		= $_POST['precioServicioClientes'];
			$totalneto		= $_POST['totalnetosf'];
			$tipopago      	= $_POST['tipopago'];

			//echo $tipopago;
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$talonarios = new OTTalonario($this->NX_CONFIG);
			$talonarionuevo = new OTTalonario($this->NX_CONFIG);
			$talonario = $talonarios->obtenertalonario($rut, 1);
			foreach($talonario as $t)
			{
				$ok= $this->OT->nuevo($numeroot, $rut, $t["IDtalonario"], $responsable, $fecha, $totalneto, $tipopago);
				//echo $ok;
				if($ok){
					if($numeroot == $t["numfinal"])
					{
						//nuevo numero actual es igual al numero final del talonario
						$talonarios->cambiarestado($t["IDtalonario"], 3); //talonario actual se acabo (estado 3: usado)
						$talonarionuevo = $talonarios->obtenernuevotalonario($rut);
						if(isset($talonarionuevo))
						{
							$talonarios->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual	
						}else{
							//echo "no hay talonarios 2";
							//retornar un aviso colocando un div en la pagina u otra idea
							/*return "<script>alert('Cliente ah terminado su talonario, no posee en cola.');</script>";*/
						}
					}else{//nuevo numero actual dentro del rango
						$talonarios->cambiarnumeroactual($t["IDtalonario"], $newnumeroactual);
					}				
				}
			}	
		
			if($ok){
				//ingreso de servicios
				$n        = count($servicios);
				$i        = 0;
				while ($i < $n){
					$this->OT->ingresarservicios($numeroot, $rut, $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i]);
					$i++;
				}
				header("Location: index.php?controlador=OT&accion=nuevo&infomsg=si");
				return;
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Trabajo, contacte al Administrador.');</script>";
			}
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de trabajo', 1, 1, 1);
		}
		$rut			= !isset($_GET['rut']) ? "" : $_GET['rut'];
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		//		echo $rut;
		//		echo "el rut";
		$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('nueva_ot');
		return $this->ver('index');
	}
    //</editor-fold>

	public function seleccionar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6) 
		{
			header('location: index.php?error=restringido');
			return;
		}
	
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->rut = (isset($_GET['rut']) ? $_GET['rut'] : null);;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'IDot';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'IDot DESC';
			break;
			case 3:
				$ordenStr = 'Fecha';
			break;
			case 4:
				$ordenStr = 'Fecha DESC';
			break;	
		}

		$this->lista = $this->OT->listar_ot_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);	
		$cantidad = $this->OT->cantidad_ot_cliente($this->buscar, $this->rut)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);	
    	return $this->ver('seleccionar_ot');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ver_ot_cliente">
	public function ver_ot_cliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idot = $_GET['idot'];
		$rut = $_GET['rut'];
		$this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
		$this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut);
		$this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut);
        $this->info_msg = "";
		if($rut==$this->configuraciones->getValor(IDCONFIG_RUT_CSJ))
		{
			$this->contenido = $this->ver('ver_otinterna_cliente');
		}else
		{
			$this->contenido = $this->ver('ver_ot_cliente');
		}
		return $this->ver('index');	
	}
    //</editor-fold>
	
	public function asignarboleta()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idot			= $_GET['ot'];
		$rut			= $_GET['rut'];
		$numboleta		= $_GET['boleta'];
		$tipopago   	= $_GET['tipopago'];
		$ajuste   		= $_GET['ajuste'];
		$totalapagar	= $_GET['totalapagar'];

		$this->OT->asignarboleta($idot, $rut, $numboleta, $tipopago, $ajuste, $totalapagar);
	}

    //<editor-fold defaultstate="collapsed" desc="listar">
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion

		$this->fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
		$this->fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$fechas = "";
		
		if($this->fechaDesde != "" && $this->fechaHasta != "")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		
		$cantidads = $this->OT->cantidad($this->buscar, $fechas); 
		$this->lista = $this->OT->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $fechas);		
		$this->nPaginas = ceil($cantidads / $this->resultados);	

		$this->total = $this->OT->precioTotalLista($this->buscar, $fechas);
		
		$this->contenido = $this->ver('listar_ot');
		return $this->ver('index');	
	}
    //</editor-fold>

	public function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idot = $_GET['idot'];
		$rut = $_GET['rut'];
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
		$this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut);
		$this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut);
		return $this->ver('ver_detalle_ot');	
	}	
	
	public function editarOT()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{		
			$numeroot		= $_POST['numeroot'];
			$numerobol		= $_POST['numerobol'];
			$rut			= $_POST['rut'];
			$totalneto		= $_POST['totalnetosf'];
			$responsable	= $_POST['resp'];
			

			$this->OT->actualizarOT($numeroot, $rut, $numerobol, $totalneto, $responsable);

			$filas			= $_POST['pos'];			
			$servicios		= $_POST['servicioClientesId'];
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precios		= $_POST['preciosf'];

			$n = count($filas);
			
			$i = 0;
			while ($i < $n){
				$this->OT->actualizarServicios($filas[$i], $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i]);
				$i++;
			}
			
			header("Location: index.php?controlador=OT&accion=listar&infomsg=si");
			return;
			
		}
		
		
		$idot = $_GET['idot'];
		$rut = $_GET['rut'];
		$this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
		$this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut);
		$this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut);
		$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('editar_ot');
		return $this->ver('index');	
		
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionPorClienteCentroCopiado">
	/************************      LISTAR CENTRO DE COPIADO DE UN CLIENTE PARA FACTURACION (MENU CLIENTES)         ************************/
	public function listarFacturacionPorClienteCentroCopiado()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		if($_SESSION['area']==6)//Solo secretaria no puede ver la informaci�n del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = !isset($_GET['buscar']) ? null : $_GET['buscar'];
		$this->rutc = !isset($_GET['rut']) ? null : $_GET['rut'];
		$this->anio = !isset($_GET['anio']) ? null : $_GET['anio'];
		if(isset($_GET['anio']) && !is_numeric($_GET['anio'])) {
            $this->anio = date("Y");
        }
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->lista = $this->OT->listar_ot_cliente_anual($this->rutc, $this->anio);	
		$cantidad = 12;
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_centro_copiado_facturacion_cliente');
	}
    //</editor-fold>

	/*****************************************************************************************************************/ 
	/*****************************************  DETALLE CENTRO COPIADOS  *********************************************/
	/*****************************************************************************************************************/
	function detalleClienteCentroCopiado()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura			= $_POST['numfactura'];
			$rut					= $_POST['rut'];
			$fecha					= $_POST['fecha'];	
			$fechavencimiento		= $_POST['fechavencimiento'];	
			$referencias			= $_POST['referencias'];	
			$formapago				= $_POST['formaPago'];	
			$centrocosto			= $_POST['idcentrocosto'];	
			$copias		    		= $_POST['cantorig'];			
			$servicio				= $_POST['servicio'];
			$precio         		= $_POST['precioUnitario'];
			$listaOT		 		= $_POST['listaCodigoOT'];			
			$this->mes				= $_POST['mes'];
			$this->anio				= $_POST['anio'];
			$this->razonsocial      = $_POST['razonsocial'];
			$porcdescuento 			= $_POST['porcdescuento'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias, $porcdescuento); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
			$this->OT->grabarFactura($rut,$this->mes,$this->anio,$numerofactura); 
			
			$ok = false;				
				
			for ($i = 0; $i < count($copias); $i++) {
				$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precio[$i], $centrocosto);
			}
			
			for ($i = 0; $i < count($listaOT); $i++) {
				$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $listaOT[$i], 0, 0, $centrocosto);
			}
		
			if($ok){	
				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Clientes&accion=listarClientesCentroCopiado";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}		
		}	
		
		$rut = $_GET['rut'];
		$this->anio = $_GET['anio'];
		$this->mes = $_GET['mes'];		

		$this->lista 	= $this->OT->obtenerDatosFacturacionMensualPorCliente($rut, $this->anio, $this->mes);	
		$this->listaOT 	= $this->OT->obtenerDatosFacturacionMensualPorClienteSoloIdOt($rut, $this->anio, $this->mes);	
		
		//		$this->listaCargoFijo = $this->OT->obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes);	
		
		$this->cliente 	= $this->clientes->obtenerDatos($rut);
		
		$this->ultimaFactura 	= $this->facturas->obtenerUltimaFactura();
		$this->contenido 		= $this->ver('ver_centro_copiado_cliente_factura');
		return $this->ver('index');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarServiciosCliente">
	public function seleccionarServiciosCliente() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'CAST(rut as UNSIGNED)';
			break;
			case 4:
				$ordenStr = 'CAST(rut as UNSIGNED) DESC';
			break;		
		}
		$rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

		$this->rut			= !isset($_GET['rut']) ? "" : $_GET['rut'];
		$this->idcontrolador    = $_GET['idcontrolador'];
		$this->lista = $this->OT->obtenerservicios($this->rut);
		return $this->ver('seleccionar_servicios_cliente');	
	}
    //</editor-fold>

	public function seleccionarServiciosClienteBuscar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'];
		$this->orden = $_GET['orden'];	
		
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'CAST(rut as UNSIGNED)';
			break;
			case 4:
				$ordenStr = 'CAST(rut as UNSIGNED) DESC';
			break;		
		}
		$rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		//		$this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		//		$cantidad = $this->clientes->cantidad($this->buscar);
		//		$this->nPaginas = ceil($cantidad / $this->resultados);		

		$this->rut			= $_GET['rut'];
		$this->idcontrolador    = $_GET['idcontrolador'];
		//$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		//$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		//echo "<br>";
		//echo $this->idcontrolador;
		//echo "el controlador";
		$this->lista = $this->OT->obtenerserviciosBuscar($this->rut,$this->buscar);
		return $this->ver('seleccionar_servicios_cliente');	
	}


}