<?php
class MaquinasControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $maquinas;
	var $clientes;
	var $configuraciones;
	var $facturas;
	var $contadores;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->clientes = new Clientes($this->NX_CONFIG);
		$this->maquinas = new Maquinas($this->NX_CONFIG);
		$this->configuraciones	= new Configuraciones($this->NX_CONFIG );
		$this->facturas = new Facturas($this->NX_CONFIG );
		$this->contadores = new Contadores($this->NX_CONFIG );
	}
    //</editor-fold>
	
	public function menu() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->serieinterna		= $_GET['serieinterna'];
		return $this->ver('menu_maquinas');		
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	/***********  NUEVA MAQUINA ***************/
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$serieinterna = $_POST['serieinterna'];
			$seriemaquina = $_POST['seriemaquina'];
			$tipomaquina  = $_POST['tipomaquina'];
			$marca        = $_POST['marca'];
			$modelo       = $_POST['modelo'];
			$fechacompra  = $_POST['fechacompra'];			
			$formato      = $_POST['formato'];
			$conectividad = $_POST['conectividad'];
			
			$rutprov		= $_POST['rutproveedor'];
			$pcompra		= $_POST['pcompra'];
			$pventa         = $_POST['pventa'];
			$codprov		= $_POST['codprov'];
			
			$cont = $this->maquinas->existe($serieinterna);
			
			if(($cont) != null) //máquina ya existe
			{ 
				  $this->info_msg = "<script>javascript:alert('Serie Interna ya existe.');</script>";
			}
			else 
			{
				if($tipomaquina == -1)
				{
					$nombretipo = $_POST['nombretipo'];
					$tipomaq = new TipoMaquina();
					$existe = $tipomaq->buscar(strtoupper($nombretipo));
					if(is_numeric($existe))
					{
						$tipomaquina = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$tipomaquina = $tipomaq->nuevo(strtoupper($nombretipo));
					}					
				}
				if($marca == -1)
				{
					$nombremarca = $_POST['nombremarca'];
					$marcas = new MarcaMaquina();
					$existe = $marcas->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcas->nuevo(strtoupper($nombremarca));
					}					
				}
				// 1 porque existe, NULL por que no tiene idfactura
	      		$ok = $this->maquinas->nuevo($serieinterna, $seriemaquina, $tipomaquina, $marca, $modelo, $fechacompra, $formato, 		$conectividad, 1, "NULL",0);
				
				if ($ok)
				{//asociar a taller
					$rutTaller = $this->configuraciones->getValor(IDCONFIG_RUT_TALLER);
					$this->clientes->agregarMaquina($rutTaller, $serieinterna, 1, "CSJ");
					
					//asociar la máquina a los proveedores
					$proveedor = new Proveedor();
					$n        = count($rutprov);
					$i        = 0;
					while ($i < $n){
						$proveedor->asociarProducto($rutprov[$i], $serieinterna, $pcompra[$i], $codprov[$i], $pventa[$i]);
						$i++;
					}								
					
					header("Location: index.php?controlador=Maquinas&accion=nuevo&infomsg=si");
					return;					
					
				}else{//modificar el info msg
					$this->info_msg = "<script>javascript:alert('Error al ingresar nueva Máquina, contacte al Administrador.');</script>";
				}
			}
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Máquina', 1, 1, 1);	
		}
		$tipomaquina = new TipoMaquina($this->NX_CONFIG);
		$this->tiposmaquina = $tipomaquina->listar();
		$marcamaquina = new MarcaMaquina($this->NX_CONFIG);
		$this->marcasmaquina = $marcamaquina->listar();
		$this->contenido = $this->ver('nueva_maquina');
		return $this->ver('index');
	}
    //</editor-fold>

	public function comprar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$tipomaquina = new TipoMaquina();
		$this->tiposmaquina = $tipomaquina->listar();
		$marcamaquina = new MarcaMaquina();
		$this->marcasmaquina = $marcamaquina->listar();
		return $this->ver('nueva_maquina_compra');
	}
	
	public function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$serieinterna 	= $_POST['serieinterna'];
			$seriemaquina 	= $_POST['seriemaquina'];
			
			$modelo 		= $_POST['modelo'];
			$formato 		= $_POST['formato'];
			$conectividad 	= $_POST['conectividad'];
			
			$rutprov		= $_POST['rutproveedor'];
			$pcompra		= $_POST['pcompra'];
			$pventa  		= $_POST['pventa'];
			$codprov		= $_POST['codprov'];
			
			$ok = $this->maquinas->modificar($serieinterna, $seriemaquina, $modelo, $formato, $conectividad, 0);
			if($ok)
			{
				$proveedor = new Proveedor();
				$proveedores = $proveedor->obtenerProveedores($serieinterna);
				if(isset($proveedores))//antiguos proveedores
				{
					foreach($proveedores as $p)
					{
						$proveedor->borrarProducto($p["rut"], $serieinterna);
					}
				}

				$n  = count($rutprov); //nuevos proveedores
				$i  = 0;
				while ($i < $n){
					$proveedor->asociarProducto($rutprov[$i], $serieinterna, $pcompra[$i], $codprov[$i], $pventa[$i]);
					$i++;
				}
				
				header('Location: index.php?controlador=Maquinas&accion=editar&infomsg=si&serieinterna='.$serieinterna);
				return;
			}else{
				$this->info_msg = "<script>alert('Error al actualizar la Máquina, contacte al Administrador.');</script>";
		    }
		}
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Máquina', 2, 1, 1);	
		}
		$serieinterna = $_GET['serieinterna'];
		$this->datosmaquina = $this->maquinas->obtenerDatos($serieinterna);
		$proveedor = new Proveedor();
		$this->proveedoresmaquina = $proveedor->obtenerProveedores($serieinterna);
		$this->contenido = $this->ver('editar_maquina');
		return $this->ver('index');			
	}
	
	public function eliminar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$serieinterna = $_GET['serieinterna'];
		$this->maquinas->eliminar($serieinterna);
		header('location: index.php?controlador=Maquinas&accion=listar');
	}
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6
			and $_SESSION['area']!=7 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10  && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada página
		$this->pagVisible = 8; //paginas a mostrar en la paginación
		
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->marca = (isset($_GET['filtromarca']) ? $_GET['filtromarca'] : null);
		$this->tipo = (isset($_GET['filtrotipo']) ? $_GET['filtrotipo'] : null);
		$this->existe = (isset($_GET['filtroexiste']) ? $_GET['filtroexiste'] : null);

		
		
		switch($this->orden)
		{
			default:
				$ordenStr = 'serieinterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'seriemaquina';
			break;
			case 4:
				$ordenStr = 'seriemaquina DESC';
			break;	
		}
		
		switch($this->marca)
		{
			default:
				$whereMar = 'AND marca='.$this->marca;
			break;
			case 0:
				$whereMar = '';
			break;			
		}
		
		switch($this->tipo)
		{
			default:
				$whereTip = 'AND tipomaquina='.$this->tipo;
			break;
			case 0:
				$whereTip = '';
			break;			
		}
		
		switch($this->existe)
		{
			default:
				$whereExis = '';
			break;
			case 1:
				$whereExis = 'AND existe=1';
			break;
			case 2:
				$whereExis = 'AND existe=0 AND idfactura>0';
			break;
		}
		
		$cantidad = $this->maquinas->cantidad($this->buscar, $whereMar, $whereTip, $whereExis)["cantidad"];
		$this->lista = $this->maquinas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip, $whereExis);	
		$this->nPaginas = ceil($cantidad / $this->resultados);
		
		$marcasmaq = new MarcaMaquina($this->NX_CONFIG);
		$this->marcas = $marcasmaq->listar();	
	
		$tiposmaq = new TipoMaquina($this->NX_CONFIG);
		$this->tipos = $tiposmaq->listar();	
		
		$this->contenido = $this->ver('listar_maquinas');
		return $this->ver('index');	
	}
	
	public function listarHistorial() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina 		= 1;
		$this->resultados 	= 20;
		$this->buscar 		= !isset($_GET['buscar']) ? null : $_GET['buscar']; //rut o razon social
		$this->orden 		= !isset($_GET['orden']) ? null : $_GET['orden'];
		$this->serieint		= !isset($_GET['serieinterna']) ? null : $_GET['serieinterna'];
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'fecha DESC';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'fecha ASC';
			break;
		}
		
	   $this->lista = $this->maquinas->listarClientes($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->serieint);	
	   $cantidad = $this->maquinas->cantidadClientes($this->buscar, $this->serieint);
	   $this->nPaginas = ceil($cantidad / $this->resultados);
		
		$this->contenido = $this->ver('historial_maquina');
		return $this->ver('index');		
	}
	
	/************************      LISTAR MAQUINAS DE UN CLIENTE (MENU CLIENTES)         ************************/
	public function listarPorCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->rutc = (isset($_GET['rut']) ? $_GET['rut'] : null);
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
		
		switch($this->orden)
		{
			default:
				$ordenStr = 'serieinterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'seriemaquina';
			break;
			case 4:
				$ordenStr = 'seriemaquina DESC';
			break;	
		}		
		
		$this->lista = $this->maquinas->listarPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_maquinas_cliente');
	}
	
	/************************      LISTAR MAQUINAS RETIRADAS DE UN CLIENTE (MENU CLIENTES)         ************************/
	public function listarRetiradasPorCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->rutc = (isset($_GET['rut']) ? $_GET['rut'] : null);;
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
		
		switch($this->orden)
		{
			default:
				$ordenStr = 'serieinterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'seriemaquina';
			break;
			case 4:
				$ordenStr = 'seriemaquina DESC';
			break;	
		}		

		$this->lista = $this->maquinas->listarRetiradasPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->maquinas->cantidadRetiradasPorCliente($this->buscar, $this->rutc)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_maquinas_retiradas_cliente');
	}
	
	public function darPorFacturada()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$rut 			= $_GET['rut'];
		$serieinterna 	= $_GET['serieinterna'];
		$this->maquinas->setEstadoFacturada($rut, $serieinterna, 1);	
		header('location: index.php?controlador=Clientes&accion=listar');
	}
	
	/************************      SELECCIONAR MAQUINAS DE UN CLIENTE (NUEVO LLAMADO)         ************************/
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->rutc = (isset($_GET['rut']) ? $_GET['rut'] : null);
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
		
		switch($this->orden)
		{
			default:
				$ordenStr = 'serieinterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'seriemaquina';
			break;
			case 4:
				$ordenStr = 'seriemaquina DESC';
			break;	
		}		
		
		$this->lista = $this->maquinas->listarPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('seleccionar_maquina_de_cliente');
	}

	/*****************************************************************************************************************/ 	
	/************************************      MUESTRA TODAS LAS MAQUINAS         ************************************/
	/*****************************************************************************************************************/ 
	public function seleccionarTodos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
		
		switch($this->orden)
		{
			default:
				$ordenStr = 'serieinterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'seriemaquina';
			break;
			case 4:
				$ordenStr = 'seriemaquina DESC';
			break;	
		}
		
		$whereMar = "";
		$whereTip = "";
		$whereExis = "AND existe=1";
				
		$this->lista = $this->maquinas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip, $whereExis);	
		$cantidad = $this->maquinas->cantidad($this->buscar, $whereMar, $whereTip, $whereExis)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('seleccionar_maquina');
	}

	/*****************************************************************************************************************/ 
	/******************      LISTAR MAQUINAS DE UN CLIENTE PARA FACTURACION (MENU CLIENTES)         ******************/
	/*****************************************************************************************************************/ 
	public function listarFacturacionPorCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->rutc = $_GET['rut'];
		$this->anio = $_GET['anio'];
		
		if(!is_numeric($_GET['anio']))
			//$this->anio = getdate()[year];
			$this->anio = date("Y");
		
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'];
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
		
		$this->lista = $this->maquinas->listarFacturacionAnualPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->anio);	
		$cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_maquinas_facturacion_cliente');
	}

	/*****************************************************************************************************************/ 
	/**********************  LISTAR TODAS MAQUINAS DE UN CLIENTE PARA FACTURACION (MENU CLIENTES)  *******************/
	/*****************************************************************************************************************/	
	public function listarFacturacionTotalPorCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->rutc = (isset($_GET['rut']) ? $_GET['rut'] : null);
		$this->anio = (isset($_GET['anio']) ? $_GET['anio'] : null);
		$this->mes = (isset($_GET['mes']) ? $_GET['mes'] : null);
		$this->idmaquina = (isset($_GET['idmaquina']) ? $_GET['idmaquina'] : null);
		$this->posicion = (isset($_GET['posicion']) ? $_GET['posicion'] : null);
		
		if(isset($_GET['anio']) && !is_numeric($_GET['anio'])) {
            $this->anio = date("Y");
        }

        if(isset($_GET['mes']) && !is_numeric($_GET['mes'])) {
            $this->mes = "0";
        }
		
		$this->clausulaMes = "";
		
		if($this->mes > 0)
		{
			$this->clausulaMes = "and month(contadores.fechafacturacion) = " . $this->mes;
		}
	
		$this->resultados = 15;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->lista = $this->maquinas->listarFacturacionTotalPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar);	
		$cantidad = $this->maquinas->cantidadFacturacionTotalPorCliente($this->rutc, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar)["cantidad"];
		
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_maquinas_facturacion_total_cliente');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorClienteMinimoCopiadoGlobal">
	/*****************************************************************************************************************/ 
	/*******************  LISTAR TODAS MAQUINAS DE UN CLIENTE PARA FACTURACION MINIMO COPIADO GLOBAL  ****************/
	/*****************************************************************************************************************/	
	public function listarFacturacionTotalPorClienteMinimoCopiadoGlobal()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina 		= 1;
		$this->rutc 		= !isset($_GET['rut']) ? "" : $_GET['rut'];
		$this->anio 		= !isset($_GET['anio']) ? "" : $_GET['anio'];
		$this->mes 			= !isset($_GET['mes']) ? "" : $_GET['mes'];
		$this->idmaquina	= !isset($_GET['idmaquina']) ? "" : $_GET['idmaquina'];
		$this->posicion 	= !isset($_GET['posicion']) ? "" : $_GET['posicion'];
		$this->tiposervicio = !isset($_GET['tiposervicio']) ? "" : $_GET['tiposervicio'];
		
		if(isset($_GET['anio']) && !is_numeric($_GET['anio'])) {
            $this->anio = date("Y");
        }
		if(isset($_GET['mes']) && !is_numeric($_GET['mes'])) {
            $this->mes = "0";
        }
		$this->clausulaMes = "";
		
		if($this->mes > 0)
		{
			$this->clausulaMes = " and month(contadores.fechafacturacion) = " . $this->mes;
		}

		if($this->tiposervicio > 0)
		{
			$this->clausulatiposervicio = " and copiascliente.idTipoServicioMaquina = " . $this->tiposervicio;
		}
	
		$this->resultados = 15;
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->lista = $this->maquinas->listarFacturacionTotalPorClienteMinimoCopiadoGlobal(
            $this->rutc,
            $this->resultados * ($this->pagina-1),
            $this->resultados, $this->idmaquina,
            $this->anio,
            $this->clausulaMes,
            $this->buscar,
            (!isset($this->clausulatiposervicio) ? "" : $this->clausulatiposervicio));
		$cantidad = $this->maquinas->cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal(
            $this->rutc,
            $this->idmaquina,
            $this->anio,
            $this->clausulaMes,
            $this->buscar,
            (!isset($this->clausulatiposervicio) ? "" : $this->clausulatiposervicio));
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_maquinas_facturacion_total_cliente_minimo_copiado_global');
	}
    //</editor-fold>

	/*****************************************************************************************************************/ 
	/***********************************  DETALLE FACTURA POR MAQUINAS  **********************************************/
	/*****************************************************************************************************************/
	function detalleMaquinaFactura()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura			= $_POST['numfactura'];
			//$newnumeroactual 		= $numeroot + 1;
			$rut					= $_POST['rut'];
			$fecha					= $_POST['fecha'];	
			$copias		    		= $_POST['copias'];			
			$servicio				= $_POST['servicio'];
			$precio         		= $_POST['precioUnitario'];
			//$totalneto				= $_POST['totalItem'];
			$cantidadCargoFijo 		= $_POST['cantidadCargoFijo'];
			$descripcionCargoFijo	= $_POST['descripcionCargoFijo'];
			$valorCargoFijo			= $_POST['valorCargoFijo'];
			$this->mes				= $_POST['mes'];
			$this->anio				= $_POST['anio'];
			$this->razonsocial      = $_POST['razonsocial'];

			$fechavencimiento	= $_POST['fechavencimiento'];
			$formapago          = $_POST['formapago'];
			$referencias  		= $_POST['referencias'];
			$centrocosto        = $_POST['idcentrocosto'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
			$this->contadores->grabarFactura($rut,$this->mes,$this->anio,$numerofactura); 
			
			$ok = false;	
			$precioItem = 0;
				
			for ($i = 0; $i < count($copias); $i++) {
				if ( is_numeric($precio[$i]))
				{
					$precioItem = $precio[$i];
				}
				
				$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precioItem, $centrocosto);
				$precioItem = 0;
			}
			
			for ($i = 0; $i < count($descripcionCargoFijo); $i++) {
				if ( $valorCargoFijo[$i] > 0 )				
				{
					$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $descripcionCargoFijo[$i], $cantidadCargoFijo[$i], $valorCargoFijo[$i], $centrocosto);
				}
				else
				{
					$ok = true;
				}
			}
		
			if($ok){	
            //$url = "excel/generarFactura.php?idFactura=" + $numerofactura	;		
			//header("Location: $url");
				//header("Location: index.php?controlador=Clientes&accion=listarClientesArriendo&infomsg=si");				
				//return;
				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Clientes&accion=listarClientesArriendo";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}		
		}	
		
		$this->rut  = $_GET['rut'];
		$this->anio = $_GET['anio'];
		$this->mes  = $_GET['mes'];		

		$this->lista = $this->maquinas->obtenerDatosFacturacionMensualPorCliente($this->rut, $this->anio, $this->mes);	
		
		$this->listaCargoFijo = $this->maquinas->obtenerDatosFacturacionMensualPorClienteCargoFijo($this->rut, $this->anio, $this->mes);	
		
		$this->cliente = $this->clientes->obtenerDatos($this->rut);
		$this->ultimaFactura = $this->facturas->obtenerUltimaFactura()["UltimaFactura"];
		$this->contenido = $this->ver('ver_maquina_factura');
		return $this->ver('index');
	}
	
	/*****************************************************************************************************************/ 
	/**********************************  DETALLE FACTURA POR MAQUINAS VERSION 2 **************************************/
	/*****************************************************************************************************************/
	function detalleMaquinaFacturaV2()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura			= $_POST['numfactura'];
			//$newnumeroactual 		= $numeroot + 1;
			$rut					= $_POST['rut'];
			$fecha					= $_POST['fecha'];	
			$copias		    		= $_POST['copias'];			
			$servicio				= $_POST['servicio'];
			$precio         		= $_POST['precioUnitario'];
			//$totalneto				= $_POST['totalItem'];
			$cantidadCargoFijo 		= $_POST['cantidadCargoFijo'];
			$descripcionCargoFijo	= $_POST['descripcionCargoFijo'];
			$valorCargoFijo			= $_POST['valorCargoFijo'];
			$this->mes				= $_POST['mes'];
			$this->anio				= $_POST['anio'];
			$this->razonsocial      = $_POST['razonsocial'];

			$fechavencimiento	= $_POST['fechavencimiento'];
			$formapago          = $_POST['formapago'];
			$referencias  		= $_POST['referencias'];
			$centrocosto        = $_POST['idcentrocosto'];
			

			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
			$this->contadores->grabarFactura($rut,$this->mes,$this->anio,$numerofactura); 
			
			$ok = false;	
			$precioItem = 0;
				
			for ($i = 0; $i < count($copias); $i++) {
				if ( is_numeric($precio[$i]))
				{
					$precioItem = $precio[$i];
				}
				
				$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precioItem);
				$precioItem = 0;
			}
			
			for ($i = 0; $i < count($descripcionCargoFijo); $i++) {
				if ( $valorCargoFijo[$i] > 0 )				
				{
					$ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $descripcionCargoFijo[$i], $cantidadCargoFijo[$i], $valorCargoFijo[$i], $centrocosto);
				}
				else
				{
					$ok = true;
				}
			}
		
			if($ok){	
            //$url = "excel/generarFactura.php?idFactura=" + $numerofactura	;		
			//header("Location: $url");
				//header("Location: index.php?controlador=Clientes&accion=listarClientesArriendo&infomsg=si");				
				//return;
				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Clientes&accion=listarClientesArriendo";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}		
		}	
		
		$this->rut  = $_GET['rut'];
		$this->anio = $_GET['anio'];
		$this->mes  = $_GET['mes'];		

		$this->lista = $this->maquinas->obtenerDatosFacturacionMensualPorCliente($this->rut, $this->anio, $this->mes);	
		
		$this->listaCargoFijo = $this->maquinas->obtenerDatosFacturacionMensualPorClienteCargoFijo($this->rut, $this->anio, $this->mes);	
		
		$this->cliente = $this->clientes->obtenerDatos($this->rut);
		$this->ultimaFactura = $this->facturas->obtenerUltimaFactura();
		$this->contenido = $this->ver('ver_maquina_facturaV2');
		return $this->ver('index');
	}	
}