<?php

class InventarioControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $inventario;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
		$this->inventario = new Inventario($this->NX_CONFIG);
	}
    //</editor-fold>

	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8  && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$tipo				= $_POST['tipo']; 
			$categoria			= $_POST['categoria'];
			$marca				= $_POST['marca'];
			$nombremarca		= $_POST['namemarca'];
			$modelo				= $_POST['modelo'];
			$maquinas 			= $_POST['maquinas'];	
			$nombremaquina		= $_POST['nombremaquina'];
			$codproveedor		= $_POST['codproveedor'];
			$numparte			= $_POST['numparte'];
			$contteorico		= $_POST['contteorico'];
			$contreal			= $_POST['contreal'];
			$stockcritico		= $_POST['stockcritico'];
			$stockminimo		= $_POST['stockminimo'];
			$pventa				= $_POST['pventa'];
			$pcompra			= $_POST['pcompra'];
			$codinterno			= $_POST['codinterno'];
			$descripcion		= $_POST['descripcion'];
			$rutprov			= $_POST['rutproveedor'];
			$pcompra			= $_POST['pcompra'];
			$codprov			= $_POST['codprov'];
			$cantidadacomprar	= $_POST['cantidadacomprar'];
			$rendimiento        = $_POST['rendimiento'];

			if($categoria == -1)
			{
				$nombrecategoria = $_POST['nombrecategoria'];
				$cat = new Categorias();
				$existe = $cat->buscar(strtoupper($nombrecategoria));
				if(is_numeric($existe))
				{
					$categoria = $existe;//se le da la ID que ya estaba ingresada
				}else{
					$categoria = $cat->nuevo(strtoupper($nombrecategoria));
				}					
			}
			if($marca == -1)
			{
				$nombremarca = $_POST['nombremarca'];
				$marcas = new MarcaMaquina();;
				$existe = $marcas->buscar(strtoupper($nombremarca));
				if(is_numeric($existe))
				{
					$marca = $existe;//se le da la ID que ya estaba ingresada
				}else{
					$marca = $marcas->nuevo(strtoupper($nombremarca));
				}					
			}		
			
			$corr = $this->inventario->obtenerCorrelativo($tipo{0});
			$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);
			
			$ok = $this->inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, 1, $nombremaquina, $cantidadacomprar,strtoupper($rendimiento));
			
			if($ok)
			{
				//asociar el producto con sus maquinas
				if(isset($maquinas))
				{
					foreach($maquinas as $m)
					{
						$this->inventario->asociarMaquinaInventario($m, $idproducto);
					}
				}
				//asociar el producto a los proveedores
				$proveedor = new Proveedor();
				$n        = count($rutprov);
				$i        = 0;
				while ($i < $n){
					$proveedor->asociarProducto($rutprov[$i], $idproducto, $pcompra[$i], $codprov[$i]);
					$i++;
				}				
				header("Location: index.php?controlador=Inventario&accion=nuevo&infomsg=si");
				return;
			}else{
				$this->info_msg = "<script>javascript:alert('Error al ingresar el Producto, contacte al Administrador.');</script>";
		    }
				
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Producto', 1, 0, 1);	
		}
		$categoriasInv = new Categorias($this->NX_CONFIG);
		$this->categorias = $categoriasInv->listar();
		$marcamaquina = new MarcaMaquina($this->NX_CONFIG);
		$this->marcasmaquina = $marcamaquina->listar();
		$this->contenido = $this->ver('nuevo_producto');
		return $this->ver('index');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : comprar">
	public function comprar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$categoriasInv = new Categorias($this->NX_CONFIG);
		$this->categorias = $categoriasInv->listar();
		$marcamaquina = new MarcaMaquina($this->NX_CONFIG);
		$this->marcasmaquina = $marcamaquina->listar();
		return $this->ver('nuevo_producto_compra');
	}
    //</editor-fold>

	public function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idproducto			= $_POST['idproducto'];

			$numparte			= $_POST['numparte'];
			$contteorico		= $_POST['contteorico'];
			$contreal			= $_POST['contreal'];
			$stockcritico		= $_POST['stockcritico'];
			$stockminimo		= $_POST['stockminimo'];
			$pventa				= $_POST['pventa'];
			$codinterno			= $_POST['codinterno'];
			$descripcion		= $_POST['descripcion'];
			$nombremaquina		= $_POST['nombremaquina'];
			
			$maquinas 			= $_POST['maquinas'];
			$rutprov			= $_POST['rutproveedor'];
			$pcompra			= $_POST['pcompra'];
			$codprov			= $_POST['codprov'];
			$cantidadacomprar	= $_POST['cantidadacomprar'];
			$rendimiento        = $_POST['rendimiento'];
			
     		$ok = $this->inventario->modificarProducto($idproducto, $codinterno, $numparte, $descripcion, $contteorico, $contreal, $stockcritico, $stockminimo, $pventa, $nombremaquina, $cantidadacomprar, strtoupper($rendimiento));
			
			if($ok)
			{
				$maquinasold = $this->inventario->obtenerMaquinasdelProducto($idproducto);
				if(isset($maquinasold))//eliminar antiguas maquinas
				{
					foreach($maquinasold as $mo)
					{
						$this->inventario->borrarMaquinasdelProducto($idproducto, $mo["serieintmaquina"] );
					}
				}
			
				if(isset($maquinas)) //agregar maquinas seleccionadas
				{
					foreach($maquinas as $m)
					{
						$this->inventario->asociarMaquinaInventario($m, $idproducto);
					}
				}
				$proveedor = new Proveedor($this->NX_CONFIG);
				$proveedores = $proveedor->obtenerProveedores($idproducto);
				if(isset($proveedores))//antiguos proveedores
				{
					foreach($proveedores as $pi)
					{
						$proveedor->borrarProducto($pi["rut"], $idproducto);
					}
				}

				$n  = count($rutprov); //nuevos proveedores
				$i  = 0;
				while ($i < $n){
					$proveedor->asociarProducto($rutprov[$i], $idproducto, $pcompra[$i], $codprov[$i], $pventa[$i]);
					$i++;
				}
				
				header('Location: index.php?controlador=Inventario&accion=editar&infomsg=si&ID='.$idproducto);
				return;

			}else{
				$this->info_msg = "<script>alert('Error al actualizar el Producto, contacte al Administrador.');</script>";
		    }
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Producto', 2, 0, 1);	
		}
		$id = $_GET['ID'];
		$this->datosproducto = $this->inventario->detalleproducto($id);
		$proveedor = new Proveedor($this->NX_CONFIG);
		$this->proveedoresinventario = $proveedor->obtenerProveedores($id);
		$this->maquinasinventario = $this->inventario->obtenerMaquinasdelProducto($id);
		$this->contenido = $this->ver('editar_producto');
		return $this->ver('index');			
	}

	public function eliminar()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$item = $_GET['item'];
		$this->inventario->eliminarProducto($item);
		header('location: index.php?controlador=Inventario&accion=listar');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->modelo = (isset($_GET['modelo']) ? $_GET['modelo'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->filtrocat = (isset($_GET['categoria']) ? $_GET['categoria'] : null);
		$this->filtrotipo = (isset($_GET['tipo']) ? $_GET['tipo'] : null);
        $this->numparte = (isset($_GET['numparte']) ? $_GET['numparte'] : null);
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'nombrecategoria';
			break;
			case 6:
				$ordenStr = 'nombrecategoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		switch($this->filtrotipo)
		{
			default:
			   $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = "AND tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = "AND tipo='Repuesto'";
			break;			
		}
		$whereCant ="";//en caso de filtrar por contador
        $cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, $this->numparte);
        $this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, $this->numparte);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();
        $this->contenido = $this->ver('listar_inventario');
        return $this->ver('index');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->filtrocat = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->filtrotipo = !isset($_GET['tipo']) ? "" : $_GET['tipo'];
		$this->modelo = !isset($_GET['modelo']) ? "" : $_GET['modelo'];

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereTip = "AND tipo='".$this->filtrotipo."'";
		$whereCant = "AND contreal > 0";
	// LISTA LOS QUE TIENE CONTREAL > 0	
	$cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo,'');
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	$categoriasInv = new Categorias();
	$this->categorias = $categoriasInv->listar();	
	return $this->ver('seleccionar_inventario');	
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarCompleto">
	/* DESDE COMPRA DIRECTA y ORDENES DE COMPRA */
	public function seleccionarCompleto() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->filtrocat = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->modelo = !isset($_GET['modelo']) ? "" : $_GET['modelo'];
		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereTip = "";
		$whereCant = "";
		
        $cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, '');
        $this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, '');
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();
        return $this->ver('seleccionar_inventario_completo');
	}
    //</editor-fold>
	
	/* DESDE COMPRA DIRECTA y ORDENES DE COMPRA */
	public function seleccionarCompletoVenta() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 15;
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->filtrocat = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->posicion = !isset($_GET['posicion']) ? "" : $_GET['posicion'];
		$this->modelo = !isset($_GET['modelo']) ? "" : $_GET['modelo'];
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereTip = "";
		$whereCant = "";
		
	$cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	$categoriasInv = new Categorias($this->NX_CONFIG);
	$this->categorias = $categoriasInv->listar();	
	return $this->ver('seleccionar_inventario_completo_venta');	
	}
		
	
	/* INVENTARIO CONTTEORICO > 0 ( NUEVO REPORT) */
	public function seleccionarTeoricoMayorCero() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
		$this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
		$this->filtrocat = (isset($_GET['categoria']) ? $_GET['categoria'] : null);
		$this->modelo = (isset($_GET['modelo']) ? $_GET['modelo'] : null);

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereTip = "";
		$whereCant = "AND contteorico > 0";
		
	$cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, '')["cantidad"];
	$this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	$categoriasInv = new Categorias($this->NX_CONFIG);
	$this->categorias = $categoriasInv->listar();	
	return $this->ver('seleccionar_inventario_report');	
	}
	
	public function seleccionarTodos() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'];
		$this->orden = $_GET['orden'];		
		$this->filtrocat = $_GET['categoria'];	
		$this->filtrotipo = $_GET['tipo'];	
		$this->modelo = $_GET['modelo'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereTip = "AND tipo='".$this->filtrotipo."'";
		$whereCant = "";
		
	$cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, '');
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	$categoriasInv = new Categorias();
	$this->categorias = $categoriasInv->listar();	
	return $this->ver('seleccionar_inventario');	
	}
	
	public function detalleproducto()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$id	= $_GET['id'];
		$this->detalles = $this->inventario->detalleproducto($id);	
		$this->maquinainventario = $this->inventario->obtenerMaquinasdelProducto($id);
		$proveedor = new Proveedor($this->NX_CONFIG);
		$this->proveedoresinventario = $proveedor->obtenerProveedores($id);
		return $this->ver('ver_detalle_producto');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockcritico">
	public function stockcritico() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->categoria = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->tipo = !isset($_GET['tipo']) ? "" : $_GET['tipo'];
		$this->nombre = "stockcritico";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'nombrecategoria';
			break;
			case 6:
				$ordenStr = 'nombrecategoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->categoria)
		{
			default:
				$whereCat = 'AND categoria='.$this->categoria;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		switch($this->tipo)
		{
			default:
			   $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = "AND tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = "AND tipo='Repuesto'";
			break;			
		}

	$cantidad = $this->inventario->cantidadcritica(
        $this->buscar,
        $whereCat,
        $whereTip);
	$this->lista = $this->inventario->stockcritico($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip);
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	$categoriasInv = new Categorias($this->NX_CONFIG);
	$this->categorias = $categoriasInv->listar();	
	$this->contenido = $this->ver('listar_stock');
	return $this->ver('index');		
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : stockminimo">
	public function stockminimo() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->categoria = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->tipo = !isset($_GET['tipo']) ? "" : $_GET['tipo'];
		$this->nombre = "stockminimo";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'nombrecategoria';
			break;
			case 6:
				$ordenStr = 'nombrecategoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->categoria)
		{
			default:
				$whereCat = 'AND categoria='.$this->categoria;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		switch($this->tipo)
		{
			default:
			   $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = "AND tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = "AND tipo='Repuesto'";
			break;			
		}

        $cantidad = $this->inventario->cantidadminima(
            $this->buscar,
            $whereCat,
            $whereTip);
        $this->lista = $this->inventario->stockminimo(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->buscar,
            $ordenStr,
            $whereCat,
            $whereTip);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();
        $this->contenido = $this->ver('listar_stock');
        return $this->ver('index');
	}
    //</editor-fold>

	public function iniciobuscar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->contenido = $this->ver('inicio_buscar_inventario');
		return $this->ver('index');	
	}	
	
	public function buscar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina 		= 1;
		$this->resultados 	= 20;
		$this->buscarm 		= !isset($_GET['buscarm']) ? "" : $_GET['buscarm'];
		$this->buscarp 		= !isset($_GET['buscarp']) ? "" : $_GET['buscarp'];
		$this->filtrotipo 	= !isset($_GET['tipo']) ? "" : $_GET['tipo'];
		
		$maquinas = new Maquinas($this->NX_CONFIG);
		$this->existe = $maquinas->existe($this->buscarm);
		$this->datosmaquina = $maquinas->obtenerDatos($this->buscarm);
		
		switch($this->filtrotipo)
		{
			default:
			    $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = "AND tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = "AND tipo='Repuesto'";
			break;	
		}		
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$cantidad = $this->inventario->cantidadMaqProd($this->buscarm, $this->buscarp, $whereTip); 
	    $this->lista = $this->inventario->listarMaqProd($this->resultados * ($this->pagina-1), $this->resultados, $this->buscarm, $this->buscarp, $whereTip);
		
		if($cantidad==0)//No existe en las maquinas internas, buscar en otras maquinas(atributo 'maquinas' en inventario)
		{
	        $cantidad = $this->inventario->cantidadMaqProd2($this->buscarm, $this->buscarp, $whereTip);
            $this->lista = $this->inventario->listarMaqProd2($this->resultados * ($this->pagina-1), $this->resultados, $this->buscarm, $this->buscarp, $whereTip);
		}		
		$this->nPaginas = ceil($cantidad / $this->resultados);
		return $this->ver('listar_inventario_de_maquina');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarCambioRepuesto">
	public function listarCambioRepuesto() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->buscarMaquina = !isset($_GET['buscarMaquina']) ? "" : $_GET['buscarMaquina'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->filtrocat = !isset($_GET['categoria']) ? "" : $_GET['categoria'];
		$this->filtrotipo = !isset($_GET['tipo']) ? "" : $_GET['tipo'];
		
		$this->fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
		$this->fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
		
		$fechas = "";
		if($this->fechaDesde != "" && $this->fechaHasta != "")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND FECHA BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'MaquinaModelo';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Cantidad DESC';
			break;
			case 2:
				$ordenStr = 'Cantidad';
			break;			
			case 3:
				$ordenStr = 'RepuestoCodigoInterno';
			break;
			case 4:
				$ordenStr = 'RepuestoCodigoInterno DESC';
			break;
			case 5:
				$ordenStr = 'RepuestoCategoria';
			break;
			case 6:
				$ordenStr = 'RepuestoCategoria DESC';
			break;
			case 7:
				$ordenStr = 'MaquinaModelo';
			break;	
			case 8:
				$ordenStr = 'MaquinaModelo DESC';
			break;
		}
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		switch($this->filtrotipo)
		{
			default:
			   $whereTip = '';
			break;
			case 1: //Insumos
				$whereTip = "AND tipo='Insumo'";
			break;	
			case 2: //Repuestos
				$whereTip = "AND tipo='Repuesto'";
			break;			
		}
		$whereCant ='';//en caso de filtrar por contador
        $cantidad = $this->inventario->cantidadCambioRepuesto(
            $this->buscar,
            $whereCat,
            $whereTip,
            $whereCant,
            $this->buscarMaquina,
            (!isset($fechas) ? "" : $fechas));
        $this->lista = $this->inventario->listarCambioRepuesto(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->buscar,
            $ordenStr,
            $whereCat,
            $whereTip,
            $whereCant,
            $this->buscarMaquina,
            (!isset($fechas) ? "" : $fechas));
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();
        $this->contenido = $this->ver('listar_repuestos_usados');
        return $this->ver('index');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarCompletoPorIdControl">
	public function seleccionarCompletoPorIdControl() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'] ?? "";
		$this->orden = $_GET['orden'] ?? "";
		$this->filtrocat = $_GET['categoria'] ?? "";
		$this->idControl = $_GET['idControl'] ?? "";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'modelo';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'modelo DESC';
			break;
			case 3:
				$ordenStr = 'nombremarca';
			break;
			case 4:
				$ordenStr = 'nombremarca DESC';
			break;
			case 5:
				$ordenStr = 'categoria';
			break;
			case 6:
				$ordenStr = 'categoria DESC';
			break;	
			case 7:
				$ordenStr = 'contreal';
			break;
			case 8:
				$ordenStr = 'contreal DESC';
			break;
		}
		
		switch($this->filtrocat)
		{
			default:
				$whereCat = 'AND categoria='.$this->filtrocat;
			break;
			case 0:
				$whereCat = '';
			break;			
		}
		
		$whereControl = 'and inventario.id in (
										SELECT
											controlinventario.IDproducto
										FROM
											controlinventario
										where
											controlinventario.IDcontrol = '.$this->idControl.'  )';
		$whereTip = "";
		$whereCant = "";
		
        $cantidad = $this->inventario->cantidadConIdControl($this->buscar, $whereCat, $whereTip, $whereCant, $whereControl);
        $this->lista = $this->inventario->listarConIdControl($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $whereControl);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();
        return $this->ver('seleccionar_inventario_completoConIdControl');
	}
    //</editor-fold>
	
	
}