<?php
class FacturasControlador extends Controlador
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $facturas;
	var $clientes;
	var $inventario;
	var $contadores;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
		$this->facturas = new Facturas($this->NX_CONFIG);
		$this->clientes = new Clientes($this->NX_CONFIG);
		$this->inventario = new Inventario($this->NX_CONFIG);
		$this->contadores = new Contadores($this->NX_CONFIG);
		$this->configuraciones	= new Configuraciones($this->NX_CONFIG);
	}
    //</editor-fold>
		
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}
				
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 10; //Registros a mostrar por cada página
		$this->pagVisible = 8; //paginas a mostrar en la paginación

		$this->fechaDesde 		= !isset($_GET['desde']) ? null : $_GET['desde'];
		$this->fechaHasta 		= !isset($_GET['hasta']) ? null : $_GET['hasta'];
		$this->buscar 			= !isset($_GET['buscar']) ? null : $_GET['buscar'];
		//$this->idCentroCosto	= $_GET['centrocosto'];
		$this->nfactura         = !isset($_GET['nfactura']) ? null : $_GET['nfactura'];
		$fechas = "";
		$centroCosto = "";
		$numeroFactura = "";

		if($this->nfactura > 0)
		{
			$numeroFactura = " AND idFactura = ".$this->nfactura;	
		}
		
		if(($this->fechaDesde != "" && $this->fechaHasta != "") && ($this->fechaHasta != null && $this->fechaHasta != null))
		{
			list( $dia, $mes, $anio) = split( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = split( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND fechaFactura BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		
		if(isset($this->idCentroCosto) && $this->idCentroCosto != 0)
		{
			$centroCosto = " AND IDCENTROCOSTO = ".$this->idCentroCosto;	
		}
		
		$cantidad = $this->facturas->cantidad($this->buscar, $fechas, $numeroFactura);
		$this->lista = $this->facturas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $fechas, $numeroFactura );		
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_facturas');
		return $this->ver('index');		
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
		{
			header('location: index.php?error=restringido');
			return;
		}

		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura		= $_POST['numerofactura'];
			$newnumeroactual 	= $numeroot + 1;
			$rut				= $_POST['rut'];
			$responsable		= $_POST['responsable'];			
			$fecha				= $_POST['fecha'];
			$fechavencimiento	= $_POST['fechavencimiento'];
			$formapago          = $_POST['formaPago'];
			$referencias  		= $_POST['referencias'];
			$items		    	= $_POST['desc'];
			$centrocosto		= $_POST['centrocosto'];			
			$cantorig			= $_POST['cantorig'];
			$coporig			= $_POST['coporig'];
			$unidades			= $_POST['unidades'];
			$precio         	= $_POST['precio'];
			$precios			= $_POST['preciosf'];
			$totalneto			= $_POST['totalnetosf'];
			$porcdescuento 		= $_POST['porcdescuento'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias, $porcdescuento);
				
			$ok = false;	
				
				
				
			for ($i = 0; $i < count($items); $i++) {
				$ok = $this->facturas->nuevoItemVentaGeneral ($numerofactura, $items[$i], $unidades[$i], $precio[$i], $centrocosto);
			}
		
		if($ok){
			//header("Location: index.php?controlador=Facturas&accion=nuevo&infomsg=si");
		    //return;
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Facturas&accion=nuevo&infomsg=si";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');
			
		}else{
			$this->info_msg = "<script>alert('Error al ingresar la Factura, contacte al Administrador.');</script>";
		}
		}
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Factura', 1, 1, 1);
		}

		$rut			= $_GET['rut'];
		$this->UltimaFactura = $this->facturas->obtenerUltimaFactura();
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->contenido = $this->ver('nueva_factura');
		return $this->ver('index');
	}	
	
	public function nuevoRepuestos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura		= $_POST['numerofactura'];
			$newnumeroactual 	= $numeroot + 1;
			$rut				= $_POST['rut'];
			$responsable		= $_POST['responsable'];			
			$fecha				= $_POST['fecha'];	
			$fechavencimiento	= $_POST['fechavencimiento'];
			$formapago          = $_POST['formaPago'];
			$referencias  		= $_POST['referencias'];	
			$items		    	= $_POST['item'];
			$inventario			= $_POST['inventario'];
			$idcentrocosto 		= $_POST['idcentrocosto'];
			
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precio         = $_POST['precio'];
			$precios		= $_POST['preciosf'];
			$totalneto		= $_POST['totalnetosf'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias);
				
			$ok = false;	
				
			for ($i = 0; $i < count($items); $i++) {
				$ok = $this->facturas->nuevoItemVentaInventario($numerofactura, $items[$i], $unidades[$i], $precio[$i], $inventario[$i], $idcentrocosto);
				$ok = $this->inventario->actualizarStockPorVentaInsumo($inventario[$i], $unidades[$i]);
			}
		
			if($ok){
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Facturas&accion=nuevoRepuestos&infomsg=si";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');		
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}
		}
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Factura', 1, 1, 1);
		}

		$rut		= $_GET['rut'];
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UltimaFactura = $this->facturas->obtenerUltimaFactura();
		//$this->inventario =$this->inventario->
		//$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('nueva_factura_repuestos');
		return $this->ver('index');
	}	

	public function nuevoGeneralRepuestos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura		= $_POST['numerofactura'];
			$newnumeroactual 	= isset($numeroot) ? $numeroot + 1 : 0;
			$rut				= $_POST['rut'];
			$responsable		= $_POST['responsable'] ?? "n/a";
			$fecha				= $_POST['fecha'];	
			$fechavencimiento	= $_POST['fechavencimiento'];
			$formapago          = $_POST['formaPago'];
			$referencias  		= $_POST['referencias'];	
			$idcentrocostoGeneral 	= $_POST['centrocostoGeneral'] ?? "n/a";
			$idcentrocostoRepuesto 	= $_POST['centrocostoRepuesto'] ?? "n/a";
			$porcdescuento 		= $_POST['porcdescuento'] ?? "n/a";

			$unidadesGeneral	= $_POST['unidadesGeneral'] ?? "n/a";
			$descGeneral		= $_POST['descGeneral'] ?? "n/a";
			$precioGeneral 		= $_POST['precioGeneral'] ?? "n/a";
			$preciosGeneral		= $_POST['preciosfGeneral'] ?? "n/a";
			$totalGeneral		= $_POST['totalGeneral'] ?? "n/a";

			$unidadesRepuesto	= $_POST['unidadesRepuesto'] ?? "n/a";
			$itemsRepuesto		= $_POST['itemRepuesto'] ?? "n/a";
			$inventarioRepuesto = $_POST['inventarioRepuesto'] ?? "n/a";
			$precioRepuesto		= $_POST['precioRepuesto'] ?? "n/a";
			$preciosRepuesto	= $_POST['preciosfRepuesto'] ?? "n/a";
			$totalRepuesto		= $_POST['totalRepuesto'];
			
			$totalneto 			= $_POST['totalnetosf'];
			$nuevototalneto     = $_POST['nuevototalneto'];
			$iva 				= $_POST['iva'];
			$totalf 			= $_POST['totalf'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias, $porcdescuento);
				
			$ok = false;	
				
			for ($i = 0; $itemsRepuesto != "n/a" && $i < count($itemsRepuesto); $i++) {
				$ok = $this->facturas->nuevoItemVentaInventario($numerofactura, $itemsRepuesto[$i], $unidadesRepuesto[$i], $precioRepuesto[$i], $inventarioRepuesto[$i], $idcentrocostoRepuesto[$i]);
				$ok = $this->inventario->actualizarStockPorVentaInsumo($inventarioRepuesto[$i], $unidadesRepuesto[$i]);
			}

            print $descGeneral;
			for ($i = 0; $descGeneral != "n/a" && $i < count($descGeneral); $i++) {
				$ok = $this->facturas->nuevoItemVentaGeneral ($numerofactura, $descGeneral[$i], $unidadesGeneral[$i], $precioGeneral[$i], $idcentrocostoGeneral[$i]);
			}


			if($ok){
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Facturas&accion=nuevoRepuestos&infomsg=si";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');		
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta General-Insumos/Repuestos, contacte al Administrador.');</script>";
			}
		}
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
		{
			$this->info_msg  = $this->msg('completa', 'Factura', 1, 1, 1);
		}

		$rut		= !isset($_GET['rut']) ? null : $_GET['rut'];
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UltimaFactura = $this->facturas->obtenerUltimaFactura();
		//$this->inventario =$this->inventario->
		//$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('nueva_factura_general_repuestos');
		return $this->ver('index');
	}	

	public function nuevoArriendos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerofactura		= $_POST['numerofactura'];
			$newnumeroactual 	= (isset($numeroot) ? $numeroot + 1 : 1);
			$rut				= (isset($_POST['rut']) ? $_POST['rut'] : null);
			$responsable		= (isset($_POST['responsable']) ? $_POST['responsable'] : null);
			$fecha				= $_POST['fecha'];	
			$fechavencimiento	= $_POST['fechavencimiento'];
		    $formaPago      	= $_POST['formaPago'];
		    $otro               = $_POST['otro'];
			$referencias     	= $_POST['referencias'];
			$items		    	= $_POST['item'];
			$inventario			= $_POST['inventario'];
			
			$cantorig			= (isset($_POST['cantorig']) ? $_POST['cantorig'] : null);
			$coporig			= (isset($_POST['coporig']) ? $_POST['coporig'] : null);
			$unidades			= $_POST['unidades'];
			$precio         	= (isset($_POST['precio']) ? $_POST['precio'] : null);
			$precios			= $_POST['preciosf'];
			$totalneto			= (isset($_POST['totalnetosf']) ? $_POST['totalnetosf'] : null);
			
			$serieinterna 		= $_POST['serieinterna'];
			$mes		 		= $_POST['mes'];
			$year		 		= $_POST['year'];

			
			$idTipoServicio 		= $_POST['tipoServicioId'];			
			$idDepartamentoCliente 	= $_POST['departamentoId'];
			$idCentroCosto 			= $_POST['centrocosto'];

			$porcdescuento 		= $_POST['porcdescuento'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->facturas->nuevoArriendo($numerofactura, $fecha, $rut, $fechavencimiento, $formaPago, $referencias, $otro, $porcdescuento);
				
			$ok = false;	
				//ACA TRABAJANDO PARA TERMINAR FACTURAS
			for ($i = 0; $i < count($items); $i++) {
		    $this->contadores->grabarFacturaArriendo($rut, $mes[$i], $year[$i], $numerofactura, $serieinterna[$i], $idTipoServicio[$i]);
			$ok = $this->facturas->nuevoItemArriendo($numerofactura, $items[$i], $unidades[$i], $precios[$i], $inventario[$i], $idDepartamentoCliente[$i], $idCentroCosto[$i]);
			}
		
			if($ok){
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->factura = $numerofactura;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Facturas&accion=nuevoRepuestos&infomsg=si";
				$this->contenido = $this->ver('factura_procesada');
				return $this->ver('index');		
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}
		}
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Factura', 1, 1, 1);
		}

		$rut		= (isset($_GET['rut']) ? $_GET['rut'] : null);
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UltimaFactura = $this->facturas->obtenerUltimaFactura();
		//$this->inventario =$this->inventario->
		//$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('nueva_factura_arriendos');
		return $this->ver('index');
	}

    public function nuevoArriendosV2()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerofactura		= $_POST['numerofactura'];
            $newnumeroactual 	= $numeroot + 1;
            $rut				= $_POST['rut'];
            $responsable		= $_POST['responsable'];
            $fecha				= $_POST['fecha'];
            $fechavencimiento	= $_POST['fechavencimiento'];
            $formaPago      	= $_POST['formaPago'];
            $otro               = $_POST['otro'];
            $referencias     	= $_POST['referencias'];
            $items		    	= $_POST['item'];
            $inventario			= $_POST['inventario'];

            $cantorig			= $_POST['cantorig'];
            $coporig			= $_POST['coporig'];
            $unidades			= $_POST['unidades'];
            $precio         	= $_POST['precio'];
            $precios			= $_POST['preciosf'];
            $totalneto			= $_POST['totalnetosf'];

            $serieinterna 		= $_POST['serieinterna'];
            $mes		 		= $_POST['mes'];
            $year		 		= $_POST['year'];


            $idTipoServicio 		= $_POST['tipoServicioId'];
            $idDepartamentoCliente 	= $_POST['departamentoId'];
            $idCentroCosto 			= $_POST['centrocosto'];

            $porcdescuento 		= $_POST['porcdescuento'];

            if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

            $this->facturas->nuevoArriendo($numerofactura, $fecha, $rut, $fechavencimiento, $formaPago, $referencias, $otro, $porcdescuento);

            $ok = false;
            //ACA TRABAJANDO PARA TERMINAR FACTURAS
            for ($i = 0; $i < count($items); $i++) {
                $this->contadores->grabarFacturaArriendo($rut, $mes[$i], $year[$i], $numerofactura, $serieinterna[$i], $idTipoServicio[$i]);
                $ok = $this->facturas->nuevoItemArriendo($numerofactura, $items[$i], $unidades[$i], $precios[$i], $inventario[$i], $idDepartamentoCliente[$i], $idCentroCosto[$i]);
            }

            if($ok){
                $this->mes				= $_POST['fecha'];
                $this->anio				= $_POST['fecha'];
                $this->razonsocial      = $_POST['razonsocial'];

                $this->factura = $numerofactura;
                $this->rut = $rut;
                $this->padre = "index.php?controlador=Facturas&accion=nuevoRepuestos&infomsg=si";
                $this->contenido = $this->ver('factura_procesada');
                return $this->ver('index');
            }else{
                $this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
            }
        }

        if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
        {
            $this->info_msg  = $this->msg('completa', 'Factura', 1, 1, 1);
        }

        $rut		= !isset($_GET['rut']) ? null : $_GET['rut'];
        $this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
        $this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->UltimaFactura = $this->facturas->obtenerUltimaFactura();
        //$this->inventario =$this->inventario->
        //$this->servicios = $this->OT->obtenerservicios($rut);
        $this->contenido = $this->ver('nueva_factura_arriendos_V2');
        return $this->ver('index');
    }




    public function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11 and $_SESSION['area']!=2)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		$idFactura = $_GET['idFactura'];
		$rut = $_GET['rut'];
		$this->fechaFactura = $_GET['fecha'];
		
		$this->lista 				= $this->facturas->obtenerDatosFactura($idFactura);	
		$this->listaCentroCopiado 	= $this->facturas->obtenerDatosDetalleFacturaCentroCopiado($idFactura);
		$this->listaArriendo		= $this->facturas->obtenerDatosDetalleFacturaArriendoItem($idFactura);
		if(isset($this->listaArriendo) && count($this->listaArriendo)==0){
				$this->listaVentas = $this->facturas->obtenerDatosDetalleFacturaVenta($idFactura);
		}
		
		//		$this->listaCargoFijo = $this->OT->obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes);	
		
		$this->idFactura = $idFactura;
		$this->cliente = $this->clientes->obtenerDatos($rut);

		
		//$this->ultimaFactura = $this->facturas->obtenerUltimaFactura();
		
		//$this->contenido = $this->ver('ver_factura_detalle_listado');
		//return $this->ver('index');
		
		return $this->ver('ver_factura_detalle_listado');	
	}	
	
}
?>