<?php

class DevolucionProductoControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $compra;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->devolucionproducto = new DevolucionProducto($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->compra->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerocd		= $_POST['numerocd'];
			$rutp 			= $_POST['rut'];
			$razon 			= $_POST['razonsocial'];
			$nombre			= $_POST['nombre'];
			$fecha 			= $_POST['fecha'];
			$sumatotal 		= $_POST['sumatotal'];
			//Productos de inventario
			$productoid		= $_POST['productoid'];
			$prodcant		= $_POST['prodcant'];
			$prodprecio		= $_POST['prodprecio'];			
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosmaqserv'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$fechadevolucion    = $_POST['fechadevolucion'];
			$idcontrol    		= $_POST['idcontrol'];
			$idcontrol2    		= $_POST['idcontrol2'];	
				
			$ok =  true; //$this->compra->nuevo($numerocd, $rutp, $razon, $nombre, $fecha, $sumatotal);
			
			if($ok)
			{
				$inventario = new Inventario();
				$devolucionProducto = new DevolucionProducto();
//---------> Ingreso de Insumos y respuestos del inventario (Tipo 1: inventario)
				$n        = count($productoid);
				$i        = 0;
				while ($i < $n){
					//$this->compra->ingresaritems($numerocd, $productoid[$i], $prodcant[$i], $prodprecio[$i],1);
					//$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contteorico');
					$devolucionProducto->nuevo($idcontrol2, $productoid[$i], $prodcant[$i], $fechadevolucion);
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contreal');
					//$inventario->actualizarPcompra($productoid[$i], $prodprecio[$i]);
					$i++;
				}
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Devolución de Producto, contacte al Administrador.');</script>";
			}
			
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Devolución Producto', 1, 1, 1);	
		}
		$this->contenido = $this->ver('nueva_devolucion_producto');
		return $this->ver('index');
	}
    //</editor-fold>

	public function verCD()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idcd = $_GET['idcd'];
		$this->cd = $this->compra->obtenerdatosCD($idcd);
		$this->listainventario = $this->compra->obtenerItemsInventarioCD($idcd);
		$this->listamaqserv = $this->compra->obtenerItemsMaqServCD($idcd);
		$this->contenido = $this->ver('ver_cd');
		return $this->ver('index');
	}
	
	public function iniciolistar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->anios = $this->compra->anios();
		$this->contenido = $this->ver('inicio_listar_cd');
		return $this->ver('index');	
	}	
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 		= $_GET['buscar'];
		$this->filtroorden 	= $_GET['orden'];		

		$this->fechaDesde 	= $_GET['desde'];
		$this->fechaHasta 	= $_GET['hasta'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->filtroorden)
		{
			default:
				$ordenStr = 'IDcd';
				$this->filtroorden = 1;
			break;
			case 2:
				$ordenStr = 'IDcd DESC';
			break;
			case 3:
				$ordenStr = 'total';
			break;
			case 4:
				$ordenStr = 'total DESC';
			break;
			case 5:
				$ordenStr = 'fecha';
			break;
			case 6:
				$ordenStr = 'fecha DESC';
			break;	
		}
	
		$cantidads = $this->compra->cantidad($this->buscar, $this->fechaDesde, $this->fechaHasta);
		$this->lista = $this->compra->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->fechaDesde, $this->fechaHasta);		
		$this->nPaginas = ceil($cantidads / $this->resultados);	
		$this->contenido = $this->ver('listar_cd');
		return $this->ver('listar_cd');
	}
	
	/* COMPRA DIRECTA NUEVA MAQ o SERV */
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
}