<?php

class CotizacionControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $cotizacion;
	var $maquinas;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->cotizacion = new Cotizacion($this->NX_CONFIG);
		$this->maquinas = new Maquinas($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->cotizacion->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
    //</editor-fold>

	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_oc');
		return $this->ver('index');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : arriendoMaquinas">
	public function arriendoMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
		    header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerocotizacion = $_POST['numerocotizacion'];
			$nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_SESSION['rut'];

            //echo $nombrecontacto.'<br>';
            //echo $nombreempresa.'<br>';
            //echo $direccion.'<br>';
            //echo $telefono.'<br>';
            //echo $correo.'<br>';
            //echo $ciudad.'<br>';
            //echo $validez.'<br>';
            //echo $fecha.'<br>';


			$itemid		                = $_POST['itemid'];
			$itemcant		            = $_POST['itemcant'];
            $itemidmaquinacotizacion    = $_POST['itemidmaquinacotizacion'];
            $itemidperiodo		        = $_POST['itemidperiodo'];
			$itemprec		            = $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion

            $tipocotizacion = 1; //1 para arriendo maquinas

			$ok =  $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
			
			if($ok)
			{ 
			$inventario = new Inventario($this->NX_CONFIG);
			$n        = count($itemperiodo);
			$i        = 0;


			while ($i < $n){
			    //$this->cotizacion->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
                $this->cotizacion->ingresaritems($numerocotizacion, $itemidperiodo[$i], $itemidmaquinacotizacion[$i]);
                //echo '<br>ItemID:';
                //echo $itemid[$i];
                //echo '<br>itemcant:';
                 //   echo $itemcant[$i];
                //echo '<br>idmaquina:';
                //echo $itemidmaquinacotizacion[$i];
                  //  echo '<br>idperiodo:';
                   // echo $itemidperiodo[$i];
					$i++;
			}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=arriendoMaquinas&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Cotizacion, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Cotizacion', 1, 1, 1);
		}
		$this->rutVendedor = $_SESSION['rut'];
		$this->contenido = $this->ver('nueva_cotizacion_arriendo_maquina');
		return $this->ver('index');
	}
    //</editor-fold>

	public function ventaMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_venta_maquina');
		return $this->ver('index');
	}

	public function centroCopiado()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_centro_copiado');
		return $this->ver('index');
	}

	public function ventaInsumos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_venta_insumo');
		return $this->ver('index');
	}

	public function mantencionesExternas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo{0});
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_mantencion_externa');
		return $this->ver('index');
	}
	
	public function iniciolistar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->anios = $this->cotizacion->aniosDesc();
		$this->contenido = $this->ver('inicio_listar_cotizaciones');
		return $this->ver('index');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
		    $this->pagina = $_GET['pagina'];

		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->numcotizacion = $_GET['numcotizacion'];
		$this->buscar 		= $_GET['buscar'];
		$this->filtroorden 	= $_GET['orden'];		
		$this->estado 		= $_GET['estado'];	
		
		$this->fechaDesde 	= $_GET['desde'];
		$this->fechaHasta 	= $_GET['hasta'];


		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->filtroorden)
		{
            case 1:
                $ordenStr = 'cotizacion.idCotizacion DESC ';
                break;
			case 2:
				$ordenStr = 'cotizacion.idCotizacion ';
			    break;
			case 3:
				$ordenStr = 'cotizacion.fechaCotizacion DESC ';
			    break;
			case 4:
				$ordenStr = 'cotizacion.fechaCotizacion ';
			    break;
		}

		switch($this->estado)
		{
			default:
			   $whereTip = '';
			break;
			case 0: //enviada
				$whereTip = " AND cotizacion.estado=1";
			break;
			case 1: //Aprobada
				$whereTip = " AND cotizacion.estado=2";
			break;	
			case 2: //Rechazada
				$whereTip = " AND cotizacion.estado=3";
			break;
		}

        $cantidads = $this->cotizacion->cantidad($this->numcotizacion, $whereTip, $this->fechaDesde, $this->fechaHasta);
        $this->lista = $this->cotizacion->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->numcotizacion, $ordenStr, $whereTip, $this->fechaDesde, $this->fechaHasta);
        $this->nPaginas = ceil($cantidads / $this->resultados);
        //$this->contenido = $this->ver('listar_cotizaciones');
	    return $this->ver('listar_cotizaciones');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarmaquinasarriendo">
	public function listarmaquinasarriendo() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 			= 1;
		$this->resultados 		= 20;
		$this->codinterno 		= $_GET['codigointerno'] ?? "";
		$this->busquedaModelo   = $_GET['busquedaModelo'] ?? "";
		$this->busquedaPeriodo   = $_GET['busquedaPeriodo'] ?? "";
		$this->rutp 			= $_GET['rutp'] ?? "";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->busquedaModelo, $this->busquedaPeriodo);
		$cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->busquedaModelo, $this->busquedaPeriodo);
	    //$this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno);
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		return $this->ver('seleccionar_cotizacion_maquinas');	
	}
    //</editor-fold>

	public function listarmaquinasventa() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 			= 1;
		$this->resultados 		= 20;
		$this->codinterno 		= $_GET['codigointerno'];
		$this->rutp 			= $_GET['rutp'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
			
		$cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->codinterno, $this->rutp);		
	    $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno); 
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		return $this->ver('seleccionar_cotizacion_maquinas_venta');	
	}

    public function verpreviewpdf()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 			= 1;
        $this->resultados 		= 20;
        $this->codinterno 		= $_GET['codigointerno'];
        $this->busquedaModelo   = $_GET['busquedaModelo'];
        $this->busquedaPeriodo   = $_GET['busquedaPeriodo'];
        $this->rutp 			= $_GET['rutp'];

        $this->numerocotizacion = $_GET['numerocotizacion'];
        $this->nombrecontacto = $_GET['nombrecontacto'];
        $this->nombreempresa = $_GET['nombreempresa'];
        $this->direccion = $_GET['direccion'];
        $this->telefono = $_GET['telefono'];
        $this->correo = $_GET['correo'];
        $this->ciudad = $_GET['ciudad'];
        $this->validez = $_GET['validez'];
        $this->fecha = $_GET['fecha'];
        $this->idVendedor = $_SESSION['rut'];

        $this->itemid		                = $_GET['itemid'];
        $this->itemcant		            = $_GET['itemcant'];
        $this->itemidmaquinacotizacion    = $_GET['itemidmaquinacotizacion'];
        $this->itemidperiodo		        = $_GET['itemidperiodo'];
        $this->itemprec		            = $_GET['itemprec'];
        //Nuevo Producto
        $this->nproductoid	= $_GET['nproductoid'];
        $this->nprodcant		= $_GET['nprodcant'];
        $this->nprodprecio	= $_GET['nprodprecio'];
        $this->datosprod		= $_GET['datosprod'];
        //Nueva maquina o servicio
        $this->maqservid			= $_GET['maqservid'];
        $this->maqservcant		= $_GET['maqservcant'];
        $this->maqservprecio		= $_GET['maqservprecio'];
        $this->datosmaqserv		= $_GET['datosmaqserv'];

        $this->tipocotizacion = 1; //1 para arriendo maquinas


        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];
        $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->busquedaModelo, $this->busquedaPeriodo);
        $cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->busquedaModelo, $this->busquedaPeriodo);
        //$this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('cotizacion_previsualizar_pdf');
    }

	function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idoc			= $_POST['numerooc'];
			$total			= $_POST['totalisimo'];
			$numfactura		= $_POST['numfactura']; 
			$ok = $this->orden->actualizarOC($idoc, $total, "total");
			if($ok)
			{
				$this->orden->actualizarOC($idoc, 1, "estado"); //Estado = Pendiente de factura (1)
				if(is_numeric($numfactura))
				{
					$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); //Ingresar numero factura
					$this->orden->actualizarOC($idoc, 0, "estado"); //Estado = Completado (0)
				}
				$borrados	= $_POST['totales'];			
				$n        = count($borrados);
				$i        = 0;
				while ($i < $n){
					$this->orden->borrarinventarioOC($idoc, $borrados[$i]);
					$i++;
				}
					
				$this->info_msg  = $this->msg('completa', 'Orden de Compra', 2, 1, 1);
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al guardar la Orden de Compra, contacte al Administrador.');</script>";
			}
		}				
		$idoc = $_GET['idoc'];
		$this->oc = $this->orden->obtenerdatosOC($idoc);
		$this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
		$this->listamaquinas = $this->orden->obtenerItemsMaqServOC($idoc);
		$this->contenido = $this->ver('editar_oc');
		return $this->ver('index');
	}

	function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$idCotizacion = $_GET['idCotizacion'];


		$this->cotizacionDatos     = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
		$this->listaMaquinas       = $this->cotizacion->obtenerItemsCotizacion($idCotizacion);
		$this->info_msg = "";
		$this->contenido = $this->ver('ver_cotizacion');
		return $this->ver('index');
	}

	function OCpagada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc		= $_GET['idOC'];
		$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1;
	}
	
	function OCconfirmada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc			= $_GET['idOC'];
		$numfactura		= $_GET['numfactura'];
		$this->orden->actualizarOC($idoc, 0, "estado"); // Cambiar a ESTADO = 0;		
		$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); // Actualizar factura
		//Actualizar inventario
		$inventario = new Inventario();		
		$listainventario = $this->orden->obtenerProductosOC($idoc);
		if(count($listainventario )>0){
			foreach($listainventario as $li){
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contteorico');
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contreal');
			}
		}
	}
	
	function rechazar()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
        $idCotizacion = $_GET['idCotizacion'];
		$this->cotizacion->actualizarCotizacion($idCotizacion, 3, "estado"); // Cambiar a ESTADO = 3;
	}
	
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
}
?>