<?php

class ControlControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $control;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->control = new ControlSalida($this->NX_CONFIG);
		$this->centroCosto = new CentroCosto($this->NX_CONFIG);
	}
    //</editor-fold>
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->numero = $this->control->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerocontrol  = $_POST["numerocontrol"];
			
			$rut 			= !isset($_POST['rut']) ? "" : $_POST['rut'];
			$nomcliente 	= !isset($_POST['nomcliente']) ? "" : $_POST['nomcliente'];
			$nomresponsable = !isset($_POST['nomresponsable']) ? "" : $_POST['nomresponsable'];
			$rutcliente 	= !isset($_POST['rutcliente']) ? "" : $_POST['rutcliente'];
			$recinto 	    = !isset($_POST['recinto']) ? "" : $_POST['recinto'];
			$fecha 			= !isset($_POST['fecha']) ? "" : $_POST['fecha'];
			$hora 			= !isset($_POST['hora2']) ? "" : $_POST['hora2'];
			
			$productoid		= !isset($_POST['productoid']) ? -1 : $_POST['productoid'];
			$prodcant		= !isset($_POST['prodcant']) ? "" : $_POST['prodcant'];
			$idCentroCosto  = !isset($_POST['cencosto']) ? "" : $_POST['cencosto'];
		
			//Ingreso nuevo control salida
			$ok = $this->control->nuevo($numerocontrol, $rut, $nomresponsable, $rutcliente, $recinto, $fecha, $hora, $idCentroCosto);
			if($ok)
			{
				$inventario = new Inventario($this->NX_CONFIG);
				//Insumos y respuestos
				$n        = ($productoid == -1 ? 0 : count($productoid));
				$i        = 0;
				while ($i < $n){
					$this->control->ingresarinventario(
                        $numerocontrol,
                        $productoid[$i],
                        $prodcant[$i]);
					$inventario->actualizarStock(
                        $productoid[$i],
                        $prodcant[$i],
                        '-',
                        'contreal');
					$i++;
				}
				header("Location: index.php?controlador=Control&accion=nuevo&infomsg=si");
				return;
			}else{
				$this->info_msg = "<script>alert('Error al ingresar Control de Salida, contacte al Administrador.');</script>";
			}
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
		{
			$this->info_msg  = $this->msg('completa', 'Control de Salida', 1, 0, 1);	
		}
		$this->listaresponsables = $this->control->listarResponsables();
		$this->listaCentroCosto = $this->centroCosto->listar();
		$this->contenido = $this->ver('nuevo_control');
		return $this->ver('index');
	}
    //</editor-fold>

	public function seleccionar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}

		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = (!isset($_GET['buscar']) ? "" : $_GET['buscar']);
		$this->orden = (!isset($_GET['orden']) ? "" : $_GET['orden']);
		$this->rut = (!isset($_GET['rut']) ? "" : $_GET['rut']);

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = (!isset($_GET['pagina']) ? "" : $_GET['pagina']);
        }

		switch($this->orden)
		{
			default:
				$ordenStr = 'IDcontrol';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'IDcontrol DESC';
			break;
			case 3:
				$ordenStr = 'Fecha';
			break;
			case 4:
				$ordenStr = 'Fecha DESC';
			break;	
		}
		
	$this->lista = $this->control->listar_control_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);	
	$cantidad = $this->control->cantidad_control_cliente($this->buscar, $this->rut);
	$this->nPaginas = ceil($cantidad["cantidad"] / $this->resultados);
    return $this->ver('seleccionar_control');
	}
	
	public function ver_control_cliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$idcontrol = $_GET['idcontrol'];
		$this->controlsalida = $this->control->obtenerdatosControl($idcontrol);
		$this->listainventario = $this->control->obtenerInventarioControl($idcontrol);
		$this->listamaquinas = $this->control->obtenerMaquinasControl($idcontrol);
		$this->contenido = $this->ver('ver_control_cliente');
		return $this->ver('index');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])){
			$this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		$this->buscar = !isset($_GET['buscar']) ? "" : $_GET['buscar'];
		$this->orden = !isset($_GET['orden']) ? "" : $_GET['orden'];
		$this->fechaDesde 	= !isset($_GET['desde']) ? "" : $_GET['desde'];
		$this->fechaHasta 	= !isset($_GET['hasta']) ? "" : $_GET['hasta'];
        $this->idcontrol	= !isset($_GET['idcontrol']) ? "" : $_GET['idcontrol'];
		if($this->fechaDesde != "" && $this->fechaHasta != "")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
        $this->lista = $this->control->listar(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->buscar,
            $ordenStr,
            $fechas ?? "",
            $this->idcontrol);
        $cantidad = $this->control->cantidad(
            $this->buscar,
            $fechas ?? "",
            $this->idcontrol);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_controlesSalida');
        return $this->ver('index');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarParaDevolucionInsumos">
	public function listarParaDevolucionInsumos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar 		= $_GET['buscar'] ?? "";
		$this->idcontrol	= $_GET['idcontrol'] ?? "";
		$this->orden 		= $_GET['orden'] ?? "";

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
		
        $this->lista = $this->control->listarPorId(
            $this->resultados * ($this->pagina-1),
            $this->resultados,
            $this->buscar,
            $ordenStr,
            $this->idcontrol);
        $cantidad = $this->control->cantidadPorID(
            $this->buscar,
            $this->idcontrol);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_controlesSalidaParaDevolucionInsumos');
	}
    //</editor-fold>

}