<?php
class ContadoresControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $contadores;
	var $clientes;
	var $maquinas;
	var $tipoCapturas;
	var $reports;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	/*
		Se crean las hojas con los contadores, IMPORTANTE:
		- Cuando se crea un report este se debe ingresar explicitamente con el bot�n "Ingresar Contador"
	*/
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->contadores 	= new Contadores($this->NX_CONFIG);
		$this->clientes 	= new Clientes($this->NX_CONFIG);
		$this->maquinas 	= new Maquinas($this->NX_CONFIG);
		$this->tipoCapturas = new TipoCapturas($this->NX_CONFIG);
		$this->reports 		= new Reports($this->NX_CONFIG);
	}
    //</editor-fold>

	//Primera pantalla despues de seleccionar maquina desde el menu cliente->listar maquinas cliente
	public function inicio()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		/*
		1. (CONTADORES) se obtiene ultima fecha de facturacion - tabla 'contadores'
		2. (CLIENTE) obtener datos - tabla 'clientes'
		3. (MAQUINA) obtener datos - tabla 'maquinas'
		4. (CONTADORES) obtener a�os de facturacion - tabla 'contadores'
		*/
		
		$rut 						= $_GET['rut'];
		$serieInterna 				= $_GET['serieinterna'];		
		$this->correlativo 			= $_GET['correlativo'];
		$this->tipoServicioMaquina 	= $_GET['tipoServicioMaquina'];
		
		$ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $this->tipoServicioMaquina)["fechafacturacion"];
		
		$this->cliente  	  = $this->clientes->obtenerDatos($rut);
		$this->maquina  	  = $this->maquinas->obtenerDatos($serieInterna);
		$this->maquinacliente = $this->maquinas->obtenerDatosMaquinaCliente($rut, $serieInterna);	
		
		$this->anios    	= $this->contadores->anios($rut , $serieInterna);//Obtener los a�os de facturacion ordenados
		
		$this->mesHasta		= date('m', strtotime($ultimaFechaFacturacion));
		$this->anioHasta	= date('Y', strtotime($ultimaFechaFacturacion));
		
		if($this->anios[0]["anio"]==$this->anioHasta)//Dentro del mismo a�o
		{
			$this->mesDesde		= 1;		//Mes 1 hasta el mes en el que se encuentra la ultima fecha de facturacion
			$this->anioDesde	= $this->anioHasta; //Es el mismo a�o el "desde" y "hasta"
		}
		else //existen mas a�os facturados, se resta un a�o que es el lapso que se mostrara en la pagina, se mostrara desde la ultima fecha 1 a�o atras
		{
			$this->mesDesde		= date('m', strtotime($ultimaFechaFacturacion . '-1 year'));		
			$this->anioDesde	= date('Y', strtotime($ultimaFechaFacturacion . '-1 year'));
		}				
		
		//Valores de minimo copiado y costo copiado
		$this->datosCopiado = $this->contadores->obtenerMinCostCopia($rut, $this->tipoServicioMaquina, $this->maquina);
		
		$this->contenido 	= $this->ver('contadores');
		return $this->ver('index');
	}

	/**************************************************************/
	/****************     NUEVO CONTADOR       ******************/
	//click en IngresarContador en Contadores&accion=inicio
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
	
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut				= $_POST['rut'];
			$serieInterna		= $_POST['serieinterna'];
			$correlativo		= $_POST['correlativo'];
			$dia = '28';
			if($_POST['mesfacturacion'] == 2)
			{ $dia = '28';}
			$fechaFacturacion 	= $dia.'-'.$_POST['mesfacturacion']."-".$_POST['aniofacturacion'];
			$tipoCaptura		= $_POST['tipocaptura'];
			$contador			= $_POST['contador'];			
			$copiaErrores		= $_POST['erroneas'];
			$fechaCaptura		= $_POST['fechacaptura'];
			$firma				= "'".$_POST['firma']."'";	
			$diferencia			= $_POST['diferencia'];	
			$copiasFacturadas	= $_POST['copias'];
			$tipoServicioMaquina= $_POST['tipoServicioMaquina'];

			$this->ultimoContador  	= $this->contadores->ultimoContador($rut, $serieInterna,$tipoServicioMaquina);
			$ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna,$tipoServicioMaquina);
			//{contador, diferencia, errores, facturadas}
			$flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 0, $fechaFacturacion, $contador, $copiaErrores, $diferencia, $copiasFacturadas, $fechaCaptura, $tipoCaptura, $firma, "NULL",$tipoServicioMaquina); 
			//Idreport NULL por que el ingreso es con otro tipo de captura
			if($flag)
			{
				return $this->info_msg = $this->msg('popup', 'contador', 1, 0, 1);
			}
			//error
			return "Error al ingresar el contador";
		}

		$this->rut 					= $_GET['rut'];
		$this->serieInterna 		= $_GET['serieinterna'];
		$this->correlativo 			= $_GET['correlativo'];	
		$this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'];	

		//Valores de minimo copiado y costo copiado
		$this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieInterna);
		$this->ultimoContador  	= $this->contadores->ultimoContador($this->rut, $this->serieInterna, $this->tipoServicioMaquina);
	
		if($this->ultimoContador == "")
		{
			$this->ultimoContador = 0;	
		}

		$this->listaCapturas 	= $this->tipoCapturas->listar();
		return $this->ver('nuevo_contador');
	}
	
	public function nuevoByReport()//(aparece al seleccionar report en Ingresar contador
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut				= $_POST['rut'];
			$serieInterna		= $_POST['serieinterna'];
			$correlativo		= $_POST['correlativo'];
			$idReport			= $_POST['idreport'];
			$dia = '31';
			if($_POST['mesfacturacion'] == 2)
			{ $dia = '28';}
			$fechaFacturacion 	= $dia.'-'.$_POST['mesfacturacion']."-".$_POST['aniofacturacion'];
			$contador			= $_POST['contador'];	
			$diferencia			= $_POST['diferencia'];	
			$copiaErrores		= $_POST['erroneas'];
			$fechaCaptura		= $_POST['fechacaptura'];
			$movimientoReport	= substr($_POST['movimientoReport'],0,9);
			$copiasFacturadas	= $_POST['copias'];
			$tipoServicioMaquina= $_POST['tipoServicioMaquina'];
			
			if($movimientoReport == 'Instalaci')
			{
				//instalaci�n (fecha captura = fecha facturacion) {contador, diferencia, errores, facturadas}
				$flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 1, $fechaCaptura, $contador, 0, 0, 0,$fechaCaptura, 1, "NULL", $idReport,$tipoServicioMaquina);
			}else{

				//Otro report
				$this->ultimoContador = $this->contadores->ultimoContador($rut, $serieInterna,$tipoServicioMaquina);
				$ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna,$tipoServicioMaquina);			
				//{contador, diferencia, errores, facturadas}
				$flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 0, $fechaFacturacion, $contador, $copiaErrores, $diferencia, $copiasFacturadas, $fechaCaptura, 1, "NULL", $idReport,$tipoServicioMaquina);
			}
			
			if($flag)
			{
				return $this->info_msg = $this->msg('popup', 'contador', 1, 0, 1);
			}		
		}
		
		$this->rut 					= $_GET['rut'];
		$this->serieInterna 		= $_GET['serieinterna'];
		$this->correlativo			= $_GET['correlativo'];
		$this->idReport 			= $_GET['idreport'];
		$this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'];
				
		$this->report 			= $this->reports->getById($this->idReport);
		$this->ultimoContador  	= $this->contadores->ultimoContador($this->rut, $this->serieInterna, $this->tipoServicioMaquina);
		$this->copias  			= $this->report['contador'] - $this->ultimoContador;
		$this->diferencia  		= $this->copias;
		//Valores de minimo copiado y costo copiado
		$this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieInterna);
		
		if($this->datosCopiado["minimocopia"] > $this->copias)
		{
			$this->copias = $this->datosCopiado["minimocopia"];	
		}
		
		//Si es instalacion u otro report redireccionar
		if($this->report['nombre'] == "Instalaci�n")
		{
			return $this->ver('nuevo_contador_by_report_inst');
		}else{
			return $this->ver('nuevo_contador_by_report');
		}
	}	
	
	/*******************  SECCION MEDIA DE LA PAGINA CONTADORES, SE LISTAN LOS MOVIMIENTOS *************************/	
	public function listar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$rut 					= $_GET['rut'];
		$serieInterna 			= $_GET['serieinterna'];
		$correlativo 			= $_GET['correlativo'];
		$tipoServicioMaquina    = $_GET['tipoServicioMaquina'];
		
		$ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $tipoServicioMaquina)["fechafacturacion"];
		
		if(isset($_GET['desde']	))//si no llegan datos (primera carga) toma desde la ultima fecha de facturacion un a�o atras
		{
			$desde	= $_GET['desde'];
		}
		else
		{
			$desde	= date('Y-m-d', strtotime($ultimaFechaFacturacion . '-1 year'));
		}
		
		if(isset($_GET['hasta']	))
		{
			$hasta	= $_GET['hasta'];
		}
		else
		{
			$hasta	= $ultimaFechaFacturacion;
		}

		$this->lista = $this->contadores->listarByFechas($rut , $serieInterna, $correlativo, $desde, $hasta,$tipoServicioMaquina);		
		//Valores de minimo copiado y costo copiado
		$this->datosCopiado = $this->contadores->obtenerMinCostCopia($rut, $tipoServicioMaquina, $serieInterna);
		
		return $this->ver('lista_contadores');
	}
	
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$rut = $_GET['rut'];
		$this->lista = $this->contadores->seleccionar($rut);	
		return $this->ver('seleccionar_contador');	
	}
	
	/* 10/01/2010 */
	public function nuevoMinCostCopia() //click en IngresarContador en Contadores&accion=inicio
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
	
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut					= $_POST['rut'];				
			$costocopia				= $_POST['costocopia'];
			$minimocopia			= $_POST['mincopia'];
			$costofijo				= $_POST['costofijo'];
			$tipoServicioMaquina	= $_POST['tipoServicioMaquina'];
			$serieIntMaquina        = $_POST['serieIntMaquina'];
				
			$this->contadores->actualizarMinCostCopia($rut, $costocopia, $minimocopia, $costofijo,$tipoServicioMaquina,$serieIntMaquina);
			return $this->info_msg = $this->msg('popup', 'M&iacute;nimo y Costo de Copiado', 2, 0, 1);
		}
		
		$this->rut	=	$_GET['rut'];	
		$this->serieIntMaquina = $_GET['serieIntMaquina'];
		$this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'];
		$this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieIntMaquina);
		return $this->ver('nuevo_mincost_copia');
	}
	
	
	/* 10/01/2010 */
	public function actualizarUbicacionMaquina()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
	
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut					= $_POST['rut'];				
			$ubicacionNueva			= $_POST['ubicacionnueva'];
			$tipoServicioMaquina	= $_POST['tipoServicioMaquina'];
			$serieIntMaquina        = $_POST['serieIntMaquina'];
				
			$this->maquinas->actualizarUbicacionClienteMaquina($rut, $serieIntMaquina, $ubicacionNueva);
			return $this->info_msg = $this->msg('popup', 'dato de Ubicación Actual', 2, 0, 1);
		}
		
		$this->rut	=	$_GET['rut'];	
		$this->serieIntMaquina = $_GET['serieIntMaquina'];
		$this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'];
		$this->ubicacion = $_GET['ubicacion'];
		
		$this->cliente  	  = $this->clientes->obtenerDatos($this->rut);
		$this->maquina  	  = $this->maquinas->obtenerDatos($this->serieIntMaquina);
		return $this->ver('cambiar_ubicacion_maquina');
	}	
	
	
}
?>