<?php

class CompraDirectaControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $compra;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG){
        $this->NX_CONFIG = $NX_CONFIG;
		$this->compra = new CompraDirecta($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->compra->obtenernumero();
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerocd		= $_POST['numerocd'];
			$rutp 			= $_POST['rut'];
			$razon 			= $_POST['razonsocial'];
			$nombre			= $_POST['nombre'];
			$fecha 			= $_POST['fecha'];
			$sumatotal 		= $_POST['sumatotal'];
			//Productos de inventario
			$productoid		= !isset($_POST['productoid']) ? -1 : $_POST['productoid'];
			$prodcant		= !isset($_POST['prodcant']) ? "" : $_POST['prodcant'];
			$prodprecio		= !isset($_POST['prodprecio']) ? "" : $_POST['prodprecio'];
			//Nuevo Producto
			$nproductoid	= !isset($_POST['nproductoid']) ? -1 : $_POST['nproductoid'];
			$nprodcant		= !isset($_POST['nprodcant']) ? "" : $_POST['nprodcant'];
			$nprodprecio	= !isset($_POST['nprodprecio']) ? "" : $_POST['nprodprecio'];
			$datosprod		= !isset($_POST['datosprod']) ? "" : $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= !isset($_POST['maqservid']) ? -1 : $_POST['maqservid']; //id = descripcion
			$maqservcant		= !isset($_POST['maqservcant']) ? "" : $_POST['maqservcant'];
			$maqservprecio		= !isset($_POST['maqservprecio']) ? "" : $_POST['maqservprecio'];
			$datosmaqserv		= !isset($_POST['datosmaqserv']) ? "" : $_POST['datosmaqserv']; // = descripcion

			$ok =  $this->compra->nuevo($numerocd, $rutp, $razon, $nombre, $fecha, $sumatotal);
			
			if($ok)
			{
				$inventario = new Inventario($this->NX_CONFIG);
				$n        = ($productoid == -1 ? 0 : count($productoid));
				$i        = 0;
				while ($i < $n){
					$this->compra->ingresaritems($numerocd, $productoid[$i], $prodcant[$i], $prodprecio[$i],1);
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contteorico');
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($productoid[$i], $prodprecio[$i]);
					$i++;
				}
				$cat = new Categorias($this->NX_CONFIG);
				$n        = ($nproductoid == -1 ? 0 : count($nproductoid));
				$i        = 0;
				while ($i < $n){
                    list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode('%', $datosprod[$i]);
                    if($categoria == -1)
                    {
                        $existe = $cat->buscar(strtoupper($nombrecategoria));
                        if(is_numeric($existe))
                        {
                            $categoria = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $categoria = $cat->nuevo(strtoupper($nombrecategoria));
                        }
                    }
				
                    if($marca == -1)
                    {
                        $existe = $marcamaq->buscar(strtoupper($nombremarca));
                        if(is_numeric($existe))
                        {
                            $marca = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $marca = $marcamaq->nuevo(strtoupper($nombremarca));
                        }
                    }

                    $corr = $inventario->obtenerCorrelativo($tipo{0});
                    $idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo{0}.($corr+1);
                    //nprodcant se le da a todos los valores
                    $inventario->nuevo(
                        $idproducto,
                        $tipo,
                        $categoria,
                        $marca,
                        $modelo,
                        (isset($codinterno) ? $codinterno : ""),
                        $numparte,
                        $descripcion,
                        $nprodcant[$i],
                        $nprodcant[$i],
                        $nprodcant[$i],
                        $nprodcant[$i],
                        $pventa,
                        1,
                        $nombremaquina,
                        "",
                        "");
                    $this->compra->ingresaritems(
                        $numerocd,
                        $idproducto,
                        $nprodcant[$i],
                        $nprodprecio[$i],
                        1);
                    $inventario->actualizarPcompra(
                        $idproducto,
                        $nprodprecio[$i]);
                    $i++;
				}
				$n        = ($maqservid == -1 ? 0 : count($maqservid));
				$i        = 0;
				while ($i < $n){
				    $this->compra->ingresarMaqServ($numerocd, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
				header("Location: index.php?controlador=CompraDirecta&accion=nuevo&infomsg=si");
			    return;
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Compra Directa, contacte al Administrador.');</script>";
			}
			
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
		{
			$this->info_msg  = $this->msg('completa', 'Compra Directa', 1, 1, 1);	
		}
		$this->contenido = $this->ver('nueva_cd');
		return $this->ver('index');
	}
    //</editor-fold>

	public function verCD()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idcd = $_GET['idcd'];
		$this->cd = $this->compra->obtenerdatosCD($idcd);
		$this->listainventario = $this->compra->obtenerItemsInventarioCD($idcd);
		$this->listamaqserv = $this->compra->obtenerItemsMaqServCD($idcd);
		$this->contenido = $this->ver('ver_cd');
		return $this->ver('index');
	}
	
	public function iniciolistar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->anios = $this->compra->anios();
		$this->contenido = $this->ver('inicio_listar_cd');
		return $this->ver('index');	
	}	
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 		= $_GET['buscar'];
		$this->filtroorden 	= $_GET['orden'];		

		$this->fechaDesde 	= $_GET['desde'];
		$this->fechaHasta 	= $_GET['hasta'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];	
			
		switch($this->filtroorden)
		{
			default:
				$ordenStr = 'IDcd';
				$this->filtroorden = 1;
			break;
			case 2:
				$ordenStr = 'IDcd DESC';
			break;
			case 3:
				$ordenStr = 'total';
			break;
			case 4:
				$ordenStr = 'total DESC';
			break;
			case 5:
				$ordenStr = 'fecha';
			break;
			case 6:
				$ordenStr = 'fecha DESC';
			break;	
		}
	
		$cantidads = $this->compra->cantidad($this->buscar, $this->fechaDesde, $this->fechaHasta);
		$this->lista = $this->compra->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->fechaDesde, $this->fechaHasta);		
		$this->nPaginas = ceil($cantidads / $this->resultados);	
		$this->contenido = $this->ver('listar_cd');
		return $this->ver('listar_cd');
	}
	
	/* COMPRA DIRECTA NUEVA MAQ o SERV */
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
}