<?php
class BoletasControlador extends Controlador
{
	var $boletas;
	var $clientes;
	var $inventario;
	var $contadores;
	var $centroCosto;
    private $NX_CONFIG;

	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->boletas = new Boletas($this->NX_CONFIG);
		$this->clientes = new Clientes($this->NX_CONFIG);
		$this->inventario = new Inventario($this->NX_CONFIG);
		$this->contadores = new Contadores($this->NX_CONFIG);
		$this->configuraciones	= new Configuraciones($this->NX_CONFIG);
		$this->centroCosto = new CentroCosto($this->NX_CONFIG);
	}
		
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}
				
		$this->pagina = 1;
		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];			
		$this->resultados = 10; //Registros a mostrar por cada página
		$this->pagVisible = 8; //paginas a mostrar en la paginación

		$this->fechaDesde 	= $_GET['desde'];
		$this->fechaHasta 	= $_GET['hasta'];
		$this->buscar = $_GET['buscar'];
		$fechas = "";
		if($this->fechaDesde != "" && $this->fechaHasta != "")
		{
			list( $dia, $mes, $anio) = split( '-', $this->fechaDesde);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = split( '-', $this->fechaHasta);
			$fecha2  = "$anio/$mes/$dia"; 
			$fechas = "AND boletas.fechaFactura BETWEEN '".$fecha1."' AND '".$fecha2."'";	
		}
		
		$cantidad = $this->boletas->cantidad($this->buscar, $fechas); 
		$this->lista = $this->boletas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $fechas );		
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		//		$this->total = $this->boletas->precioTotalLista($this->buscar, $fechas);		
		//return $this->ver('listar_ot');
		$this->contenido = $this->ver('listar_boletas');
		return $this->ver('index');		
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}

		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numeroboleta	= $_POST['numeroboleta'];
			$rut			= $_POST['rut'];
			$responsable	= $_POST['responsable'];			
			$fecha			= $_POST['fecha'];	
			$items		    = $_POST['desc'];
			
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precio         = $_POST['precio'];
			$precios		= $_POST['preciosf'];
			$totalneto		= $_POST['totalnetosf'];

			$porcdescuento	= $_POST['porcdescuento'];

			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->boletas->nuevoVentaGeneral($numeroboleta, $fecha, $rut, $porcdescuento);
				
			$ok = false;	
				
				
			for ($i = 0; $i < count($items); $i++) {
				$ok = $this->boletas->nuevoItemVentaInventario ($numeroboleta, $items[$i], $unidades[$i], $precio[$i]);
			}
		
		if($ok){
			//header("Location: index.php?controlador=Boletas&accion=nuevo&infomsg=si");
		    //return;
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->boleta = $numeroboleta;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Boletas&accion=nuevo&infomsg=si";
				$this->contenido = $this->ver('boleta_procesada');
				return $this->ver('index');
			
		}else{
			$this->info_msg = "<script>alert('Error al ingresar la Boleta, contacte al Administrador.');</script>";
		}
		

		
		}
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Boleta', 1, 1, 1);
		}


		
		$rut					= $_GET['rut'];
		$this->UltimaFactura 	= $this->boletas->obtenerUltimaFactura(); 
		$this->UF 				= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ				= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->contenido 		= $this->ver('nueva_boleta_repuestos');
		return $this->ver('index');
	}	
	
	public function nuevoRepuestos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numeroboleta		= $_POST['numeroboleta'];
			$newnumeroactual 	= $numeroot + 1;
			$rut				= $_POST['rut'];
			$responsable		= $_POST['responsable'];			
			$fecha				= $_POST['fecha'];	
			$items		    	= $_POST['item'];
			$inventario			= $_POST['inventario'];
			$idCentroCosto		= $_POST['cencosto']; 
			
			$cantorig			= $_POST['cantorig'];
			$coporig			= $_POST['coporig'];
			$unidades			= $_POST['unidades'];
			$precio         	= $_POST['precio'];
			$precios			= $_POST['preciosf'];
			$totalneto			= $_POST['totalnetosf'];

			$porcdescuento		= $_POST['porcdescuento'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->boletas->nuevoVentaGeneral($numeroboleta, $fecha, $rut, $idCentroCosto, $porcdescuento);
				
			$ok = false;	
				
			for ($i = 0; $i < count($items); $i++) {
				$ok = $this->boletas->nuevoItemVentaInventario ($numeroboleta, $items[$i], $unidades[$i], $precio[$i], $inventario[$i], $idCentroCosto);
				$ok = $this->inventario->actualizarStockPorVentaInsumo($inventario[$i], $unidades[$i]);
			}
		
			if($ok){
				$this->fecha				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->boleta = $numeroboleta;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Boletas&accion=nuevoRepuestos&infomsg=si";
				$this->contenido = $this->ver('boleta_procesada');
				return $this->ver('index');		
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Boleta de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}
		}
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Boleta', 1, 1, 1);
		}

		$rut		= !isset($_GET['rut']) ? null : $_GET['rut'];
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UltimaBoleta = $this->boletas->obtenerUltimaBoleta();
		$this->listaCentroCosto = $this->centroCosto->listar();
		$this->contenido = $this->ver('nueva_boleta_repuestos');
		return $this->ver('index');
	}	
	
	public function nuevoArriendos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=10 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numeroboleta		= $_POST['numeroboleta'];
			$newnumeroactual = $numeroot + 1;
			$rut			= $_POST['rut'];
			$responsable	= $_POST['responsable'];			
			$fecha			= $_POST['fecha'];	
		    $formaPago      = $_POST['formaPago'];
			$referencias    = $_POST['referencias'];
			$items		    = $_POST['item'];
			$inventario		= $_POST['inventario'];
			
			$cantorig		= $_POST['cantorig'];
			$coporig		= $_POST['coporig'];
			$unidades		= $_POST['unidades'];
			$precio         = $_POST['precio'];
			$precios		= $_POST['preciosf'];
			$totalneto		= $_POST['totalnetosf'];	
			
			
			$serieinterna 	= $_POST['serieinterna'];
			$mes		 	= $_POST['mes'];
			$year		 	= $_POST['year'];

			
			$idTipoServicio = $_POST['tipoServicioId'];			
			$idDepartamentoCliente 	= $_POST['departamentoId'];
			$idCentroCosto 			= $_POST['centrocosto'];
			
			if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

			$this->boletas->nuevoArriendo($numeroboleta, $fecha, $rut, $formaPago, $referencia);
				
			$ok = false;	
				//ACA TRABAJANDO PARA TERMINAR FACTURAS
			for ($i = 0; $i < count($items); $i++) {
		    $this->contadores->grabarFacturaArriendo($rut, $mes[$i], $year[$i], $numeroboleta, $serieinterna[$i], $idTipoServicio[$i]);
			$ok = $this->boletas->nuevoItemArriendo($numeroboleta, $items[$i], $unidades[$i], $precios[$i], $inventario[$i], $idDepartamentoCliente[$i], $idCentroCosto[$i]);
			}
		
			if($ok){
				$this->mes				= $_POST['fecha'];
				$this->anio				= $_POST['fecha'];
				$this->razonsocial      = $_POST['razonsocial'];

				$this->boleta = $numeroboleta;
				$this->rut = $rut;
				$this->padre = "index.php?controlador=Boletas&accion=nuevoRepuestos&infomsg=si";
				$this->contenido = $this->ver('boleta_procesada');
				return $this->ver('index');		
			}else{
				$this->info_msg = "<script>alert('Error al ingresar la Boleta de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
			}
		}
		
		if($_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Boleta', 1, 1, 1);
		}

		$rut		= $_GET['rut'];
		$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
		$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
		$this->UltimaFactura = $this->boletas->obtenerUltimaFactura(); 
		//$this->inventario =$this->inventario->
		//$this->servicios = $this->OT->obtenerservicios($rut);
		$this->contenido = $this->ver('nueva_boleta_arriendos');
		return $this->ver('index');
	}	
	
	public function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 and $_SESSION['area']!=2) 
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		$idFactura = $_GET['idFactura'];
		$rut = $_GET['rut'];
		$this->fechaFactura = $_GET['fecha'];
		
		$this->lista 				= $this->boletas->obtenerDatosFactura($idFactura);	
		$this->listaCentroCopiado 	= $this->boletas->obtenerDatosDetalleFacturaCentroCopiado($idFactura);
		$this->listaArriendo		= $this->boletas->obtenerDatosDetalleFacturaArriendoItem($idFactura);
		if(count($this->listaArriendo )==0){
				$this->listaVentas = $this->boletas->obtenerDatosDetalleFacturaVenta($idFactura);
		}
		
//		$this->listaCargoFijo = $this->OT->obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes);	
		
		$this->idFactura = $idFactura;
		$this->cliente = $this->clientes->obtenerDatos($rut);

		
		//$this->ultimaFactura = $this->boletas->obtenerUltimaFactura();
		
		//$this->contenido = $this->ver('ver_boleta_detalle_listado');
		//return $this->ver('index');
		
		return $this->ver('ver_boleta_detalle_listado');	
	}	
	
}
?>