<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
//</editor-fold>

class Usuarios {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : LOGIN">
    public function login($rut, $pass)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM usuarios
				WHERE rut = '$rut'
				AND pass = '$pass'
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : changePass">
	public function changePass($rut, $pass)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        usuarios
			SET 
			    pass = '$pass'
			WHERE 
			    rut = '$rut';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : changeEstado">
	public function changeEstado($rut, $estado)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        usuarios
			SET 
			    estado = $estado
			WHERE 
			    rut = '$rut';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    public function listar($inicial, $resultados, $buscar, $orden, $whereArea)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM usuarios, areas
				WHERE (apellidos LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%' ) AND
				usuarios.area = areas.idarea $whereArea
				and activo = 1
				ORDER BY $orden
				LIMIT $inicial, $resultados
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($buscar, $whereArea)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM usuarios
				WHERE
			     activo = 1 and
				 (apellidos LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%') $whereArea	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarAreas">
    public function listarAreas()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM areas
				ORDER BY nombrearea
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarSucursales">
    public function listarSucursales()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT * 
				FROM sucursal
				ORDER BY nombresucursal
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : existe">
	public function existe($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        count(*) AS cantidad
			FROM 
			    usuarios
			WHERE 
			    rut = '$rut';
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($rut, $dv, $nombre, $apellido, $telefono, $direccion, $area, $pass, $correo, $sucursal)
	{
        $this->NX_DB->CONECTAR();
        $sql = "
		    INSERT INTO 
		        usuarios (rut, dv, nombre, apellidos, fono, direccion, area, pass, correo, sucursal)
			VALUES 
			    ('$rut', '$dv', '$nombre', '$apellido', '$telefono', '$direccion', $area, '$pass', '$correo', $sucursal)
		";
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
    public function eliminar($rut)
    {
        $this->NX_DB->CONECTAR();
        try{
            $this->NX_DB->QUERY("
				UPDATE usuarios
				set activo = 0
				WHERE rut = '{$rut}';
			");
        }catch (mysqli_sql_exception $e){
            error_log("NX_ERROR : {$e}", 0);
            $this->NX_DB->DESCONECTAR();
            return false;
        }
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatos">
    public function obtenerDatos($rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM usuarios
				WHERE rut =	'$rut'	
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificar">
	public function modificar($rut, $nombre, $apellido, $telefono, $direccion, $area, $correo, $sucursal)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        usuarios
			SET 
			    nombre = '$nombre', 
			    apellidos = '$apellido', 
			    fono = '$telefono',
				direccion = '$direccion', 
			    area = $area,
			    correo = '$correo',
			    sucursal = $sucursal
			WHERE 
			    rut = '$rut';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : restablecerPass">
	public function restablecerPass($rut, $pass)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        usuarios
			SET 
			    pass = '$pass', 
			    estado = 0
			WHERE 
			    rut = '$rut';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarUsuariosArea">
	public function listarUsuariosArea($area)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		           * 
			FROM 
			    usuarios
			WHERE 
			    area = $area
			    and activo = 1
			ORDER BY apellidos;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>
	
}