<?php
//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
//</editor-fold>

class Servicios {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo($servicio, $precio, $tipocambio,$rutCentroFotocopiado, $idsucursal, $familia, $formato, $tipo, $gramaje)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO servicios(servicio, precio, tipocambio, IDCliente, idsucursal, idfamilia, idformato, idtipo, idgramaje)
			VALUES('$servicio', $precio, '$tipocambio',$rutCentroFotocopiado, $idsucursal, $familia, $formato, $tipo, $gramaje);
		");
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoPorCliente">
    function nuevoPorCliente($servicio, $precio, $tipocambio, $idCliente, $idsucursal)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO servicios(servicio, precio, tipocambio,IDCliente)
			VALUES('$servicio', $precio, '$tipocambio', '$idCliente');
		");
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    function cantidad($buscar)
    {
        $sql = 	"
				SELECT count(*)
				FROM servicios
				WHERE servicio LIKE '%" . addslashes($buscar) . "%'
				";
        return $this->controladorBD->fetchOne($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar($inicial, $resultados, $buscar, $orden)
    {
        $sql = 	"
				SELECT * 
				FROM servicios
				WHERE servicio LIKE '%" . addslashes($buscar) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados
				";
        return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTodos">
    function listarTodos($rutCentroFotocopiado, $buscar, $idsucursal, $idfamilia, $idformato, $idtipo, $idgramaje)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT
                    servicios.IDservicio, 
                    servicios.servicio, 
                    servicios.precio, 
                    servicios.tipocambio, 
                    servicios.IDCliente, 
                    sucursal.idsucursal, 
                    sucursal.nombresucursal, 
                    sucursal.direccionsucursal, 
                    sucursal.telefonosucursal, 
                    sucursal.ciudadsucursal, 
                    serviciosformato.idformato, 
                    serviciosformato.formatodesc, 
                    serviciosfamilia.idserviciofamilia, 
                    serviciosfamilia.familiadesc, 
                    serviciostipo.idtipo, 
                    serviciostipo.tipodesc, 
                    serviciosgramaje.idgramaje, 
                    serviciosgramaje.gramajedesc
                FROM
                    servicios
                    INNER JOIN
                    sucursal
                    ON 
                        servicios.idsucursal = sucursal.idsucursal
                    INNER JOIN
                    serviciosfamilia
                    ON 
                        servicios.idfamilia = serviciosfamilia.idserviciofamilia
                    INNER JOIN
                    serviciosformato
                    ON 
                        servicios.idformato = serviciosformato.idformato
                    INNER JOIN
                    serviciostipo
                    ON 
                        servicios.idtipo = serviciostipo.idtipo
                    INNER JOIN
                    serviciosgramaje
                    ON 
                        servicios.idgramaje = serviciosgramaje.idgramaje
				where IDCliente = $rutCentroFotocopiado
				and servicios.servicio like '%$buscar%'
				$idsucursal
                $idfamilia
                $idformato
                $idtipo
                $idgramaje
				ORDER BY sucursal.idsucursal, servicio ASC
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTodosPorCliente">
    public function listarTodosPorCliente($idCliente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM servicios where IdCliente = '{$idCliente}'
				ORDER BY servicio
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarServiciosToExcel">
    function listarServiciosToExcel($buscar, $rut, $idsucursal, $idfamilia, $idformato, $idtipo, $idgramaje)
    {
        $sql = "
                select 
                    servicios.servicio,
                    servicios.IDservicio,
                    servicios.precio,
                    servicios.tipocambio,
                    clientes.razonsocial,
			        sucursal.nombresucursal,
                    serviciosfamilia.familiadesc,
                    serviciosformato.formatodesc,
                    serviciostipo.tipodesc,
                    serviciosgramaje.gramajedesc
			    from servicios
                    Inner Join clientes ON servicios.IDCliente = clientes.rut
                    Inner Join sucursal ON servicios.idsucursal = sucursal.idsucursal
                    Inner Join serviciosfamilia ON servicios.idfamilia = serviciosfamilia.idserviciofamilia
                    Inner Join serviciosformato ON servicios.idformato = serviciosformato.idformato
                    Inner Join serviciostipo ON servicios.idtipo = serviciostipo.idtipo
                    Inner Join serviciosgramaje ON servicios.idgramaje = serviciosgramaje.idgramaje
                WHERE servicios.servicio LIKE '%" . addslashes($buscar) . "%'
                    AND servicios.IDCliente = $rut
                $idsucursal
                $idfamilia
                $idformato
                $idtipo
                $idgramaje
                ORDER BY servicios.servicio
                    ";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;  
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editar">
    public function editar($idservicio, $nombreservicio, $precio, $tipocambio)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE servicios
				SET servicio = '$nombreservicio', precio = $precio, tipocambio = '$tipocambio'
				WHERE IDservicio = '$idservicio'
				");
        return $this->NX_DB->DESCONECTAR();;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : Eliminar">
    public function eliminar($idservicio)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
            DELETE FROM 
                servicios
			WHERE 
			    IDservicio = $idservicio;
			");
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : buscarFamilia">
    function buscarFamilia($nombrefamilia)
    {
        $sql = 	"
				SELECT max(idserviciofamilia) as idserviciofamilia
				FROM serviciosfamilia
				WHERE familiadesc = '$nombrefamilia'
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevaFamilia">
    function nuevaFamilia($nombrefamilia)
    {
        $this->NX_DB->CONECTAR();
        $sql = 	"
				INSERT INTO serviciosfamilia(familiadesc)
				VALUES('$nombrefamilia')
				";
        $this->NX_DB->QUERY($sql);
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFamilias">
    function listarFamilias()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT * 
				FROM serviciosfamilia
				ORDER BY familiadesc
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : buscarFormato">
    function buscarFormato($nombreformato)
    {
        $sql = 	"
				SELECT max(idformato) as idformato
				FROM serviciosformato
				WHERE formatodesc = '$nombreformato'
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoFormato">
    function nuevoFormato($nombreformato)
    {
        $sql = 	"
				INSERT INTO serviciosformato(formatodesc)
				VALUES('$nombreformato')
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFormato">
    function listarFormato()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT * 
				FROM serviciosformato
				ORDER BY formatodesc
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : buscarTipo">
    function buscarTipo($nombretipo)
    {
        $sql = 	"
				SELECT max(idtipo) as idtipo
				FROM serviciostipo
				WHERE tipodesc = '$nombretipo'
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoTipo">
    function nuevoTipo($nombretipo)
    {
        $sql = 	"
				INSERT INTO serviciostipo(tipodesc)
				VALUES('$nombretipo')
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTipo">
    function listarTipo()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT * 
				FROM serviciostipo
				ORDER BY tipodesc
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : buscarGramaje">
    function buscarGramaje($nombregramaje)
    {
        $sql = 	"
				SELECT max(idgramaje) as idgramaje
				FROM serviciosgramaje
				WHERE gramajedesc = '$nombregramaje'
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoGramaje">
    function nuevoGramaje($nombregramaje)
    {
        $sql = 	"
				INSERT INTO serviciosgramaje(gramajedesc)
				VALUES('$nombregramaje')
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        return $this->NX_DB->DESCONECTAR();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarGramaje">
    function listarGramaje()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = 	"
				SELECT * 
				FROM serviciosgramaje
				ORDER BY gramajedesc
				";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>
}
?>