<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Reports {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo($idReport, $rut, $serieInterna, $correlativo, $tecnico, $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext,$tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio)
    {
        list( $dia, $mes, $anio) = explode( '-', $fecha );
        $fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO reports(idreport, rut, serieinterna, correlativo, tecnico, contador, fecha, horadespacho, horallegada, horasalida, movimiento, detalle, estadoretiro, observacionretiro, observacionmaqext,idTipoServicioMaquina, contadorColor, contadorScanner, idreportlugarservicio)
				VALUES($idReport, '$rut', '$serieInterna', $correlativo, $tecnico, $contador, '$fecha2', '$horaDespacho', '$horaLlegada', '$horaSalida', $movimiento, '$detalle', $estadoretiro, '$observacionretiro', '$observacionmaqext','$tipoServicioMaquina','$contadorColor','$contadorScanner',$idreportlugarservicio)
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : agregarProducto">
    public function agregarProducto($idReport, $idProducto, $cantidad)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO reportinventario(idreport, IDproducto, cantidad)
				VALUES('$idReport', '$idProducto', $cantidad)
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : getById">
    public function getById($idReport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM reports, movimientosmaquina
				WHERE idreport = $idReport and movimiento = idmovimiento
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : getByClienteMaquina">
    public function getByClienteMaquina($rut, $serieInterna, $correlativo)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT reports.*, movimientosmaquina.nombre movimiento
				FROM movimientosmaquina Inner Join reports 
				ON reports.movimiento = movimientosmaquina.idmovimiento
				WHERE rut = '$rut'
				AND serieinterna = '$serieInterna'
				AND correlativo = '$correlativo'
				AND contador > (SELECT IFNULL(MAX(contador), 0)
								FROM contadores
								WHERE rutcliente = '$rut'
								AND serieintmaquina = '$serieInterna'
								AND correlativo = '$correlativo')
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($idReport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS cantidad
				FROM reports
				WHERE idreport = $idReport
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadlistar">
    public function cantidadlistar($cliente, $maquina, $tecnico, $fechas, $numreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS cantidad
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				reports.idreport LIKE '%" . addslashes($numreport) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' AND
				usuarios.rut LIKE '%" . addslashes($tecnico) . "%' AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' $fechas
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    public function listar($inicial, $resultados, $cliente, $maquina, $tecnico, $fechas, $numreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				reports.idreport LIKE '%" . addslashes($numreport) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' AND
				usuarios.rut LIKE '%" . addslashes($tecnico) . "%' AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' $fechas
				ORDER BY reports.fecha DESC
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
    public function listarTOEXCEL($cliente, $maquina, $tecnico, $fechas, $numreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*, reportslugarservicio.descripcion as descripcionlugarservicio
				FROM reports, movimientosmaquina, usuarios, clientes, reportslugarservicio
				WHERE 
				reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				reports.idReportLugarServicio = reportslugarservicio.idReportLugarServicio AND
				reports.idreport LIKE '%" . addslashes($numreport) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' AND
				usuarios.rut LIKE '%" . addslashes($tecnico) . "%' AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' 
				$fechas
				ORDER BY reports.fecha DESC
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadlistarTodos">
    public function cantidadlistarTodos()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS cantidad
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTodos">
    public function listarTodos($inicial, $resultados)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut 
				ORDER BY reports.fecha DESC
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTodosTOEXCEL">
    public function listarTodosTOEXCEL()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*, reportslugarservicio.descripcion as descripcionlugarservicio
				FROM reports, movimientosmaquina, usuarios, clientes, reportslugarservicio
				WHERE 
				reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND 
				reports.idReportLugarServicio = reportslugarservicio.idReportLugarServicio
				ORDER BY reports.fecha DESC
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : detalle">
    public function detalle($idreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.dv cdv, usuarios.dv udv, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.idreport = '$idreport' AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut				
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ubicacionMaquina">
    public function ubicacionMaquina($rut, $serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM clientemaquina
				WHERE clientemaquina.rutcliente = '$rut' AND
				clientemaquina.serieintmaquina = '$serieinterna' AND
				estado = 1
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : productosReport">
    public function productosReport($idreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM reportinventario, inventario, categorias, marcasmaquina
				WHERE reportinventario.idreport = '$idreport' AND
				reportinventario.idproducto = inventario.ID AND
				inventario.categoria = categorias.IDcategoria AND
				inventario.marca = marcasmaquina.ID
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadlistarReportsRepetidos">
    public function cantidadlistarReportsRepetidos($cliente, $maquina, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' 
				$fechas
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE ?? 0;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarReportsRepetidosClaves">
    public function listarReportsRepetidosClaves($cliente, $maquina, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT 
                serieinterna,
                rut
            FROM 
                reports 
            WHERE
				serieinterna LIKE '%" . addslashes($maquina) . "%' AND
				rut LIKE '%" . addslashes($cliente) . "%' 
				$fechas
			group by serieinterna,rut
            having count(reports.serieinterna) > 1;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarReportsRepetidos">
    public function listarReportsRepetidos($inicial, $resultados, $cliente, $maquina, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' 
				$fechas
				ORDER BY reports.serieinterna DESC
				
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarReportsRepetidosPorSerieintPorRut">
    public function listarReportsRepetidosPorSerieintPorRut($inicial, $resultados, $cliente, $maquina, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut AND
				serieinterna LIKE '%" . addslashes($maquina) . "%' AND
				clientes.rut LIKE '%" . addslashes($cliente) . "%' 
				$fechas
				ORDER BY reports.fecha DESC
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadlistarTodosReportsRepetidos">
    public function cantidadlistarTodosReportsRepetidos()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTodosReportsRepetidos">
    public function listarTodosReportsRepetidos($inicial, $resultados)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.razonsocial, usuarios.nombre nombretecnico, usuarios.apellidos apellidostecnico, reports.*, movimientosmaquina.*
				FROM reports, movimientosmaquina, usuarios, clientes
				WHERE reports.movimiento = movimientosmaquina.idmovimiento AND
				reports.tecnico = usuarios.rut AND
				reports.rut = clientes.rut
				ORDER BY reports.fecha DESC
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

}